/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: hbtool.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file hbtool.c The hbtool module.
*/


#line 113 "hbtool.ctr"


#include "dk3all.h"
#include "dk3se.h"
#include "htmlbook.h"





#line 122 "hbtool.ctr"



int
hbtool_add_file(hb_job_t *job, dkChar const *fn)
{
  dkChar	 bu[DK3_MAX_PATH];	/* File name buffer */
  dkChar	*p1;			/* Start of file name */
  int		 back = 0;
  

#line 132 "hbtool.ctr"
  if(fn) {
    if(dk3str_len(fn) < DK3_SIZEOF(bu,dkChar)) {
      p1 = dk3str_start(fn, NULL);
      if(p1) {
        dk3str_cpy(bu, p1);
	dk3str_chomp(bu, NULL);
	if(dk3sto_it_find_like(job->i_files, bu, 0)) {
	  back = 1;
	} else {
	  p1 = dk3str_dup_app(bu, job->app);
	  if(p1) {
	    if(dk3sto_add(job->s_files, p1)) {
	      back = 1;
	    } else {
	      dk3_delete(p1);
	    }
	  }
	}
      }
    } else {
      dk3app_log_i3(job->app, DK3_LL_ERROR, 65, 66, fn);
    }
  } 

#line 155 "hbtool.ctr"
  return back;
}



int
hbtool_check_filename_encoding(hb_job_t *job, dkChar const *fn)
{
  int		 back;
  int		 se;		/* Standard encoding to check */
  

#line 166 "hbtool.ctr"
#if DK3_ON_WINDOWS
  se = (DK3SE_ANSI | DK3SE_URL);
#else
  if((job->options) & HB_JOB_OPT_CHM) {
    se = (DK3SE_ANSI | DK3SE_URL);
  } else {
    se = DK3SE_URL;
  }
#endif
  back = dk3se_check(fn,dk3app_get_encoding(job->app),se,NULL,NULL,job->app);
  

#line 177 "hbtool.ctr"
  return back;
}



int
hbtool_check_filename(hb_job_t *job, dkChar const *fn)
{
  int		 back;
  

#line 187 "hbtool.ctr"
  back = hbtool_check_filename_encoding(job, fn);
  if(dk3str_chr(fn, DK3_CHAR_SEP)) {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 12);
    back = 0;
  } 

#line 192 "hbtool.ctr"
  return back;
}




dk3_c32_t
hbtool_get_start_char(dkChar const *text, int enc)
{
  dk3_c32_t		back = 0UL;
  dk3_c32_t		c32 = 0UL;	/* Start character */
  size_t		sl;		/* String length */
  size_t		used;		/* Number of bytes used */
  char			c;		/* Result character */
  

#line 207 "hbtool.ctr"
  if(text) {
    sl = dk3str_len(text);
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
    back = *text;
#else
    used = 0;
    if(dk3enc_utf162uc(&c32, text, sl, &used)) {
      back = c32;
    }
#endif
#else
    if(enc == DK3_ENCODING_UTF8) {
      used = 0;
      if(dk3enc_utf82uc(&c32, (unsigned char const *)text, sl, &used)) {
        back = c32;
      }
    } else {
      c = *text;
      back = (dk3_c32_t)c;
      back &= ((dk3_c32_t)0x000000FFUL);
    }
#endif
  } 

#line 231 "hbtool.ctr"
  return back;
}



void
hbtool_enumerate(hb_job_t *job)
{
  hb_node_t	*nptr;	/* Next node */
  hb_node_t	*cptr;	/* Current node */
  dk3sto_it_reset(job->i_nodes);
  while(NULL != (nptr = (hb_node_t *)dk3sto_it_next(job->i_nodes))) {
    nptr->headno = 0UL; nptr->nextsubheadno = 0UL;
    nptr->tocstate = HB_TOC_STATE_INIT;
  }
  cptr = job->rootnode;
  while(cptr) {
    switch(cptr->tocstate) {
      case HB_TOC_STATE_INIT: {
        dk3sto_it_reset(cptr->i_subnodes);
	nptr = (hb_node_t *)dk3sto_it_next(cptr->i_subnodes);
	if(nptr) {
	  cptr->tocstate = HB_TOC_STATE_IN_PROGRESS;
	  nptr->headno = cptr->nextsubheadno;
	  cptr->nextsubheadno += 1UL;
	  cptr = nptr;
	} else {
	  cptr->tocstate = HB_TOC_STATE_FINISHED;
	  cptr = cptr->parent;
	}
      } break;
      case HB_TOC_STATE_IN_PROGRESS: {
        nptr = (hb_node_t *)dk3sto_it_next(cptr->i_subnodes);
	if(nptr) {
	  nptr->headno = cptr->nextsubheadno;
	  cptr->nextsubheadno += 1UL;
	  cptr = nptr;
	} else {
	  cptr->tocstate = HB_TOC_STATE_FINISHED;
	  cptr = cptr->parent;
	}
      } break;
      case HB_TOC_STATE_FINISHED: {
        cptr = cptr->parent;
      } break;
    }
  }
  dk3sto_it_reset(job->i_nodes);
  while(NULL != (nptr = (hb_node_t *)dk3sto_it_next(job->i_nodes))) {
    nptr->tocstate = HB_TOC_STATE_INIT;
  }
}



int
hbtool_write_header_number(hb_job_t *job, hb_node_t *nptr)
{
  dkChar		bu[32];
  int			back = 0;
  

#line 292 "hbtool.ctr"
  if((job) && (nptr)) {
    if(nptr->parent) { 				

#line 294 "hbtool.ctr"
      if(nptr->depth <= job->headlevels) {	

#line 295 "hbtool.ctr"
        back = 1;
	if(job->impressumnode) {
	  if((job->impressumnode)->objno == nptr->objno) {
	    back = 0;				

#line 299 "hbtool.ctr"
	  }
	}
	if(back) {				

#line 302 "hbtool.ctr"
          hbtool_write_header_number(job, nptr->parent);
	  if(1 < nptr->depth) {			

#line 304 "hbtool.ctr"
	    hbhtml_output_for_text(job, dkT("."));
	  }
#if VERSION_BEFORE_20140716
	  dk3sf_sprintf3(bu, dkT("%lu"), (1UL + nptr->headno));
	  hbhtml_output_for_text(job, bu);	

#line 309 "hbtool.ctr"
#else
	  if (dk3ma_um_to_string(bu, DK3_SIZEOF(bu,dkChar), (dk3_um_t)(1UL + nptr->headno))) {
	    hbhtml_output_for_text(job, bu);
	  }
#endif
	} else {				

#line 315 "hbtool.ctr"
	}
      } else {					

#line 317 "hbtool.ctr"
      }
    } else {					

#line 319 "hbtool.ctr"
    }
  } 

#line 321 "hbtool.ctr"
  return back;
}



int
hbtool_add_url(hb_job_t *job, dkChar const *url)
{
  dkChar	 bu[DK3_MAX_PATH];	/* Copy of URL */
  dkChar	*p1;			/* Start of text in url */
  int		 back = 1;
  if(!hbhtml_check_link_for_external(url)) {
    if(dk3str_len(url) < DK3_SIZEOF(bu,dkChar)) {
      dk3str_cpy(bu, url);
      p1 = dk3str_chr(bu, dkT('?'));
      if(p1) {
        *p1 = dkT('\0');
      } else {
        p1 = dk3str_chr(bu, dkT('#'));
	if(p1) {
	  *p1 = dkT('\0');
	}
      }
      if(NULL == dk3str_chr(bu, dkT('/'))) {
        if(0 < dk3str_len(bu)) {
          back = hbtool_add_file(job, bu);
	}
      }
    } else {
      /* ERROR: File name too long! */
      dk3app_log_i3(job->app, DK3_LL_ERROR, 65, 66, url);
      back = 0;
    }
  }
  return back;
}



void
hbtool_correct_backslash_to_slash(dkChar *str)
{
#if DK3_ON_WINDOWS
  char *ptr;
  ptr = str;
  while(*ptr) {
    if(dkT('\\') == *ptr) { *ptr = dkT('/'); }
    ptr++;
  }
#endif
}



int
hbtool_write_all_titles(hb_job_t *job, hb_node_t *nptr, int isprim)
{
  int			 back = 0;
  /* hbhtml_output_for_text(job, dkT(" ")); */
  if ((job) && (nptr)) {
    if (nptr->parent) {
      back = 1;
      if (job->impressumnode) {
        if ((job->impressumnode)->objno == nptr->objno) {
	  back = 0;
	}
      }
      if (back) {
        if (hbtool_write_all_titles(job, nptr->parent, 0)) {
	  hbhtml_output_for_text(job, dkT(" &#8594; "));
	}
	if (isprim) {
	  if (nptr->title) {
	    hbhtml_output_for_text(job, nptr->title);
	  }
	} else {
	  if (nptr->shorttitle) {
	    hbhtml_output_for_text(job, nptr->shorttitle);
	  } else {
	    if (nptr->title) {
	      hbhtml_output_for_text(job, nptr->title);
	    }
	  }
	}
      }
    }
  }
  return back;
}



int
hbtool_write_text_utf(hb_job_t *job, dkChar const *src)
{
  char		 bu[(1024 < DK3_MAX_PATH) ? DK3_MAX_PATH : 1024];
  int		 back = 0;
  int		 ie;
  if ((job) && (src)) {
    ie = dk3app_get_encoding(job->app);
    if (dk3str_to_c8u_app(bu, sizeof(bu), src, ie, job->app)) {
      if (EOF != fputs(bu, job->of)) {
        back = 1;
      }
    }
  }
  return back;
}


