/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: hbnode.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file hbnode.h Header file for the hbnode module.
*/

#ifndef HBNODE_H_INCLUDED
/** Avoid multiple inclusions. */
#define HBNODE_H_INCLUDED 1


#line 10 "hbnode.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Compare two nodes.
	@param	l	Pointer to left node.
	@param	r	Pointer to right node.
	@param	cr	Comparison criteria (ignored).
	@return	Comparison result.
*/
int
hb_node_compare(void const *l, void const *r, int cr);

/**	Create node, allocate memory.
	@param	job	Job structure.
	@param	parent	Parent node.
	@param	lineno	Line number where object was created.
	@param	objno	Object number (in order of creation).
	@param	indent	Line indent.
	@return	Pointer to new node on success, NULL on error.
*/
hb_node_t *
hb_node_new(
  hb_job_t		*job,
  hb_node_t		*parent,
  unsigned long		 lineno,
  unsigned long		 objno,
  int			 indent
);

/**	Destroy node, release memory.
	@param	ptr	Node to destroy.
*/
void
hb_node_delete(hb_node_t *ptr);

/**	Search for variable in node and parents.
	@param	node	Start node for search.
	@param	name	Variable name.
	@return	Pointer to value on success, NULL on error.
*/
dkChar const *
hbnode_variable(hb_node_t *node, dkChar const *name);

/**	Create link structure.
	@param	url	URL to store.
	@param	lno	Link number.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to new link structure on success, NULL on error.
*/
hb_link_t *
hbnode_link_new(dkChar const *url, unsigned long lno, dk3_app_t *app);

/**	Delete link structure.
	@param	ptr	Link structure to delete.
*/
void
hbnode_link_delete(hb_link_t *ptr);

/**	Compare two link structures.
	@param	l	Left structure.
	@param	r	Right structure or URL.
	@param	cr	Comparison criteria
			(0=obj/obj by URL, 1=obj/URL, 2=obj/obj by lno).
	@return	Comparison result.
*/
int
hbnode_link_compare(const void *l, const void *r, int cr);

#ifdef __cplusplus
}
#endif


#endif
