/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: hbindex.ctr
*/

/**	@file hbindex.h Header file for the hbindex module.
*/

#ifndef HBINDEX_H_INCLUDED
/** Avoid multiple inclusions. */
#define HBINDEX_H_INCLUDED 1


#line 4 "hbindex.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Create index entry, allocate memory.
	@param	tx	Index text.
	@param	fn	File name.
	@param	an	Anchor name (optional).
	@param	ul	Anchor number, used if no anchor name specified.
	@param	app	Application structure for diagnostics, may be NULL.
	@param	nptr	Current node.
	@return	Pointer to new entry on success, NULL on error.
*/
hb_index_entry_t *
hbindex_new(
  dkChar const		*tx,
  dkChar const		*fn,
  dkChar const		*an,
  unsigned long	const	 ul,
  dk3_app_t		*app,
  hb_node_t		*nptr
);

/**	Destroy index entry, release memory.
	@param	pi	Index entry to destroy.
*/
void
hbindex_delete(hb_index_entry_t *pi);

/**	Compare two index entries.
	@param	l	Left entry.
	@param	r	Right entry or name.
	@param	cr	Comparison criteria (0=object/object, 1=object/name).
	@return	Comparison result.
*/
int
hbindex_compare(void const *l, void const *r, int cr);

/**	Write anchor name for index entry (either given name or number-based).
	@param	job	Job structure.
	@param	in	Index entry.
	@return	1 on success, 0 on error.
*/
int
hb_index_write_anchor(hb_job_t *job, hb_index_entry_t *in);

#ifdef __cplusplus
}
#endif


#endif
