/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: hbimgdim.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file hbimgdim.h Header file for the hbimgdim module.
*/

#ifndef HBIMGDIM_H_INCLUDED
/** Avoid multiple inclusions. */
#define HBIMGDIM_H_INCLUDED 1


#line 10 "hbimgdim.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Find image dimensions.
	@param	job	Job structure.
	@param	fn	Image file name.
	@param	w	Pointer to result variable for width.
	@param	h	Pointer to result variable for height.
	@param	save	Flag: Save result to cache.
	@return	1 on success, 0 on error.
*/
int
hbimgdim_find(
  hb_job_t	*job,
  dkChar const	*fn,
  unsigned long	*w,
  unsigned long	*h,
  int		 save
);

/**	Create image dimension cache entry, allocate memory.
	@param	fn	Image file name.
	@param	w	Image width.
	@param	h	Image height.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to new entry on success, NULL on error.
*/
hb_img_dim_t	*
hbimgdim_new(
  dkChar const	*fn,
  unsigned long	 w,
  unsigned long	 h,
  dk3_app_t	*app
);

/**	Delete image dimension cache entry, release memory.
	@param	ptr	Cache entry to delete.
*/
void
hbimgdim_delete(hb_img_dim_t *ptr);

/**	Compare two image dimension entries.
	@param	l	Left entry pointer.
	@param	r	Right entry pointer or file name pointer.
	@param	cr	Comparison criteria (0=entry/entry, 1=entry/name).
	@return	Comparison result.
*/
int
hbimgdim_compare(void const *l, void const *r, int cr);

#ifdef __cplusplus
}
#endif




#endif
