/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: hbimgdim.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file hbimgdim.c The hbimgdim module.
*/


#line 69 "hbimgdim.ctr"


#include "dk3all.h"
#include "dk3bif.h"
#include "htmlbook.h"





#line 78 "hbimgdim.ctr"



int
hbimgdim_compare(void const *l, void const *r, int cr)
{
  int		 back = 0;
  hb_img_dim_t	*pl;
  hb_img_dim_t	*pr;
  

#line 88 "hbimgdim.ctr"
  if(l) {
    if(r) {
      pl = (hb_img_dim_t *)l;
      switch(cr) {
        case 1: {
	  back = dk3str_fncmp(pl->fn, (dkChar const *)r);
	} break;
	default: {
	  pr = (hb_img_dim_t *)r;
	  back = dk3str_fncmp(pl->fn, pr->fn);
	} break;
      }
      if(-1 > back) { back = -1; }
      if( 1 < back) { back =  1; }
    } else back = 1;
  } else {
    if(r) back = -1;
  } 

#line 106 "hbimgdim.ctr"
  return back;
}



void
hbimgdim_delete(hb_img_dim_t *ptr)
{
  

#line 115 "hbimgdim.ctr"
  if(ptr) {
    dk3_release(ptr->fn);
    ptr->w = 0UL;
    ptr->h = 0UL;
    dk3_delete(ptr);
  } 

#line 121 "hbimgdim.ctr"
}



hb_img_dim_t	*
hbimgdim_new(dkChar const *fn, unsigned long w, unsigned long h, dk3_app_t *app)
{
  hb_img_dim_t		*back = NULL;
  

#line 130 "hbimgdim.ctr"
  back = dk3_new_app(hb_img_dim_t,1,app);
  if(back) {
    back->w = w;
    back->h = h;
    back->fn = dk3str_dup_app(fn,app);
    if(!(back->fn)) {
      hbimgdim_delete(back);
      back = NULL;
    }
  } 

#line 140 "hbimgdim.ctr"
  return back;
}



int
hbimgdim_find(
  hb_job_t	*job,
  dkChar const	*fn,
  unsigned long	*w,
  unsigned long	*h,
  int		 save
)
{
  hb_img_dim_t		*idptr;		/* Image dimension found or new */
  dk3_bif_t		*bp;		/* BIF object for graphics file */
  unsigned long		 xw;		/* Width read from file */
  unsigned long		 xh;		/* Height read from file */
  int			 back = 0;
  

#line 160 "hbimgdim.ctr"
  if((job) && (fn) && (w) && (h)) {
    idptr = dk3sto_it_find_like(job->i_imgdim, fn, 1);
    if(idptr) {
      *w = idptr->w;
      *h = idptr->h;
      back = 1;
    } else {
      bp = dk3bif_open_filename_app(fn, DK3_BIF_IMAGE_TYPE_UNKNOWN, job->app);
      if(bp) {
        xw = dk3bif_get_width(bp);
	xh = dk3bif_get_height(bp);
        dk3bif_close(bp);
	if((xw) && (xh)) {
	  *w = xw;
	  *h = xh;
	  back = 1;
	  if(save) {
	    idptr = hbimgdim_new(fn, xw, xh, job->app);
	    if(idptr) {
	      if(!(dk3sto_add(job->s_imgdim, idptr))) {
	        hbimgdim_delete(idptr);
	      }
	    }
	  }
	}
      }
    }
  } 

#line 188 "hbimgdim.ctr"
  return back;
}



