/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: hbhtml.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file hbhtml.h Header file for the hbhtml module.
*/

#ifndef HBHTML_H_INCLUDED
/** Avoid multiple inclusions. */
#define HBHTML_H_INCLUDED 1


#line 9 "hbhtml.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Write one HTML file.
	@param	job		Job structure.
	@param	nodeptr		Node for file to write.
	@param	p		Previous node.
	@param	n		Next node.
*/
void
hbhtml_write_file(hb_job_t *job,hb_node_t *nodeptr,hb_node_t *p,hb_node_t *n);

/**	Write one 32-bit character to HTML output.
	@param	job	Job structure.
	@param	c32	Character to write.
*/
void
hbhtml_c32(hb_job_t *job, dk3_c32_t c32);

/**	Write some text as HTML.
	@param	job	Job structure.
	@param	text	Text to write.
	@return	1 on success, 0 on error.
*/
int
hbhtml_output_for_text(hb_job_t *job, dkChar const *text);

/**	Write some URL text as HTML.
	@param	job	Job structure.
	@param	text	Text to write.
	@return	1 on success, 0 on error.
*/
int
hbhtml_url_output_for_text(hb_job_t *job, dkChar const *text);

/**	Handle one input line, either from template or from text file.
	@param	obj	Line processor structure.
	@param	il	Input line to process.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
int
hbhtml_line_handler(void *obj, dkChar *il);

/**	Construct output file name.
	@param	dptr	Destination buffer pointer.
	@param	sz	Destination buffer size.
	@param	job	Job structure.
	@param	nptr	Node to process.
	@return	1 on success, 0 on error.
*/
int
hbhtml_create_output_filename(
  dkChar	*dptr,
  size_t 	 sz,
  hb_job_t	*job,
  hb_node_t	*nptr
);

/**	Check whether a link is an external link (http:// or ftp://
	at start).
	@param	link	Link to check.
	@return	1 for external links, 0 for internal links.
*/
int
hbhtml_check_link_for_external(dkChar const *link);

#ifdef __cplusplus
}
#endif



#endif
