/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: hbhtml.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file hbhtml.c The hbhtml module.
*/

/** @defgroup dkct_state_machine_hbhtml_stm1 The hbhtml_stm1 state machine. */
/**@{*/

#ifndef STM1_ST_BS
/** State: Backslash found */
#line 92 "hbhtml.ctr"
#define STM1_ST_BS 0
#else
#line 92 "hbhtml.ctr"
#error "Redefinition of STM1_ST_BS"
#endif

#ifndef STM1_ST_ERROR
/** State: Error occured */
#line 91 "hbhtml.ctr"
#define STM1_ST_ERROR 1
#else
#line 91 "hbhtml.ctr"
#error "Redefinition of STM1_ST_ERROR"
#endif

#ifndef STM1_ST_PERCENT
/** State: One percent sign found */
#line 93 "hbhtml.ctr"
#define STM1_ST_PERCENT 2
#else
#line 93 "hbhtml.ctr"
#error "Redefinition of STM1_ST_PERCENT"
#endif

#ifndef STM1_ST_SPECIAL
/** State: Recording a special */
#line 94 "hbhtml.ctr"
#define STM1_ST_SPECIAL 3
#else
#line 94 "hbhtml.ctr"
#error "Redefinition of STM1_ST_SPECIAL"
#endif

#ifndef STM1_ST_SPEC_BS
/** State: Backslash found in special */
#line 95 "hbhtml.ctr"
#define STM1_ST_SPEC_BS 4
#else
#line 95 "hbhtml.ctr"
#error "Redefinition of STM1_ST_SPEC_BS"
#endif

#ifndef STM1_ST_SPEC_PC
/** State: Percent found in special */
#line 96 "hbhtml.ctr"
#define STM1_ST_SPEC_PC 5
#else
#line 96 "hbhtml.ctr"
#error "Redefinition of STM1_ST_SPEC_PC"
#endif

#ifndef STM1_ST_START
/** State: Start state */
#line 90 "hbhtml.ctr"
#define STM1_ST_START 6
#else
#line 90 "hbhtml.ctr"
#error "Redefinition of STM1_ST_START"
#endif

#ifndef STM1_I_ANY
/** State machine input: Any character */
#line 99 "hbhtml.ctr"
#define STM1_I_ANY 0
#else
#line 99 "hbhtml.ctr"
#error "Redefinition of STM1_I_ANY"
#endif

#ifndef STM1_I_BS
/** State machine input: Backslash */
#line 100 "hbhtml.ctr"
#define STM1_I_BS 1
#else
#line 100 "hbhtml.ctr"
#error "Redefinition of STM1_I_BS"
#endif

#ifndef STM1_I_PERCENT
/** State machine input: Percent sign */
#line 101 "hbhtml.ctr"
#define STM1_I_PERCENT 2
#else
#line 101 "hbhtml.ctr"
#error "Redefinition of STM1_I_PERCENT"
#endif

#ifndef STM1_O_BS_SHIPOUT
/** State machine output: Shipout character after backslash */
#line 107 "hbhtml.ctr"
#define STM1_O_BS_SHIPOUT 0
#else
#line 107 "hbhtml.ctr"
#error "Redefinition of STM1_O_BS_SHIPOUT"
#endif

#ifndef STM1_O_ERROR
/** State machine output: Error, do nothing */
#line 104 "hbhtml.ctr"
#define STM1_O_ERROR 1
#else
#line 104 "hbhtml.ctr"
#error "Redefinition of STM1_O_ERROR"
#endif

#ifndef STM1_O_EXECUTE
/** State machine output: Execute special */
#line 115 "hbhtml.ctr"
#define STM1_O_EXECUTE 2
#else
#line 115 "hbhtml.ctr"
#error "Redefinition of STM1_O_EXECUTE"
#endif

#ifndef STM1_O_NOTHING
/** State machine output: Do nothing */
#line 105 "hbhtml.ctr"
#define STM1_O_NOTHING 3
#else
#line 105 "hbhtml.ctr"
#error "Redefinition of STM1_O_NOTHING"
#endif

#ifndef STM1_O_PERCENT
/** State machine output: Shipout just percent sign */
#line 109 "hbhtml.ctr"
#define STM1_O_PERCENT 4
#else
#line 109 "hbhtml.ctr"
#error "Redefinition of STM1_O_PERCENT"
#endif

#ifndef STM1_O_PERCENT_SHIPOUT
/** State machine output: Shipout percent sign and current character */
#line 108 "hbhtml.ctr"
#define STM1_O_PERCENT_SHIPOUT 5
#else
#line 108 "hbhtml.ctr"
#error "Redefinition of STM1_O_PERCENT_SHIPOUT"
#endif

#ifndef STM1_O_SHIPOUT
/** State machine output: Add character to shipout buffer */
#line 106 "hbhtml.ctr"
#define STM1_O_SHIPOUT 6
#else
#line 106 "hbhtml.ctr"
#error "Redefinition of STM1_O_SHIPOUT"
#endif

#ifndef STM1_O_SPECIAL
/** State machine output: Add current character to special */
#line 111 "hbhtml.ctr"
#define STM1_O_SPECIAL 7
#else
#line 111 "hbhtml.ctr"
#error "Redefinition of STM1_O_SPECIAL"
#endif

#ifndef STM1_O_SPEC_BS
/** State machine output: Add char after backslash to special */
#line 112 "hbhtml.ctr"
#define STM1_O_SPEC_BS 8
#else
#line 112 "hbhtml.ctr"
#error "Redefinition of STM1_O_SPEC_BS"
#endif

#ifndef STM1_O_SPEC_PC
/** State machine output: Add percent sign to special */
#line 114 "hbhtml.ctr"
#define STM1_O_SPEC_PC 9
#else
#line 114 "hbhtml.ctr"
#error "Redefinition of STM1_O_SPEC_PC"
#endif

#ifndef STM1_O_SPEC_PC_ADD
/** State machine output: Add percent and current char to special */
#line 113 "hbhtml.ctr"
#define STM1_O_SPEC_PC_ADD 10
#else
#line 113 "hbhtml.ctr"
#error "Redefinition of STM1_O_SPEC_PC_ADD"
#endif

#ifndef STM1_O_SWITCH
/** State machine output: Flush shipout and switch to saving special */
#line 110 "hbhtml.ctr"
#define STM1_O_SWITCH 11
#else
#line 110 "hbhtml.ctr"
#error "Redefinition of STM1_O_SWITCH"
#endif

/**@}*/

/**	Reset hbhtml_stm1 state machine.
	@param	st	Pointer to state variable.
*/
static
void
hbhtml_stm1_reset(int *st)
{
  if(st) { *st = STM1_ST_START; }
}

/**	State machine hbhtml_stm1 step.
	@param	st	Pointer to state variable.
	@param	in	Input.
	@return	Transition output.
*/
static
int
hbhtml_stm1_step(int *st, int in)
{
  int back = STM1_O_ERROR;
  if(st) {
    int os;
    int nf = 1;
    int ns = STM1_ST_ERROR;
    os = *st;
    switch(os) {
      case STM1_ST_PERCENT: {
        switch(in) {
          case STM1_I_BS: {
            ns = STM1_ST_BS; back = STM1_O_PERCENT; nf = 0;
          } break;
          case STM1_I_PERCENT: {
            ns = STM1_ST_SPECIAL; back = STM1_O_SWITCH; nf = 0;
          } break;
        }
      } break;
      case STM1_ST_SPECIAL: {
        switch(in) {
          case STM1_I_BS: {
            ns = STM1_ST_SPEC_BS; back = STM1_O_NOTHING; nf = 0;
          } break;
          case STM1_I_PERCENT: {
            ns = STM1_ST_SPEC_PC; back = STM1_O_NOTHING; nf = 0;
          } break;
        }
      } break;
      case STM1_ST_SPEC_PC: {
        switch(in) {
          case STM1_I_BS: {
            ns = STM1_ST_SPEC_BS; back = STM1_O_SPEC_PC; nf = 0;
          } break;
          case STM1_I_PERCENT: {
            ns = STM1_ST_START; back = STM1_O_EXECUTE; nf = 0;
          } break;
        }
      } break;
      case STM1_ST_START: {
        switch(in) {
          case STM1_I_BS: {
            ns = STM1_ST_BS; back = STM1_O_NOTHING; nf = 0;
          } break;
          case STM1_I_PERCENT: {
            ns = STM1_ST_PERCENT; back = STM1_O_NOTHING; nf = 0;
          } break;
        }
      } break;
    }
    if(nf) {
      if(os == STM1_ST_START) {
      ns = STM1_ST_START; back = STM1_O_SHIPOUT;
      } else {
      if(os == STM1_ST_BS) {
      ns = STM1_ST_START; back = STM1_O_BS_SHIPOUT;
      } else {
      if(os == STM1_ST_PERCENT) {
      ns = STM1_ST_START; back = STM1_O_PERCENT_SHIPOUT;
      } else {
      if(os == STM1_ST_SPECIAL) {
      ns = STM1_ST_SPECIAL; back = STM1_O_SPECIAL;
      } else {
      if(os == STM1_ST_SPEC_BS) {
      ns = STM1_ST_SPECIAL; back = STM1_O_SPEC_BS;
      } else {
      if(os == STM1_ST_SPEC_PC) {
      ns = STM1_ST_SPECIAL; back = STM1_O_SPEC_PC_ADD;
      } else {
      }
      }
      }
      }
      }
      }
    }
    *st = ns;
  } else {
  }
  return back;
}

/** @defgroup dkct_state_machine_hbhtml_stm3 The hbhtml_stm3 state machine. */
/**@{*/

#ifndef STM3_ST_COLON
/** State: Colon found */
#line 147 "hbhtml.ctr"
#define STM3_ST_COLON 0
#else
#line 147 "hbhtml.ctr"
#error "Redefinition of STM3_ST_COLON"
#endif

#ifndef STM3_ST_COLSL
/** State: Colon and slash */
#line 148 "hbhtml.ctr"
#define STM3_ST_COLSL 1
#else
#line 148 "hbhtml.ctr"
#error "Redefinition of STM3_ST_COLSL"
#endif

#ifndef STM3_ST_ERROR
/** State: Not a protocol at start of text */
#line 150 "hbhtml.ctr"
#define STM3_ST_ERROR 2
#else
#line 150 "hbhtml.ctr"
#error "Redefinition of STM3_ST_ERROR"
#endif

#ifndef STM3_ST_NAME
/** State: ASCII characters (for protocol name) found */
#line 146 "hbhtml.ctr"
#define STM3_ST_NAME 3
#else
#line 146 "hbhtml.ctr"
#error "Redefinition of STM3_ST_NAME"
#endif

#ifndef STM3_ST_START
/** State: No character processed yet */
#line 145 "hbhtml.ctr"
#define STM3_ST_START 4
#else
#line 145 "hbhtml.ctr"
#error "Redefinition of STM3_ST_START"
#endif

#ifndef STM3_ST_SUCCESS
/** State: Colon and two slashes found */
#line 149 "hbhtml.ctr"
#define STM3_ST_SUCCESS 5
#else
#line 149 "hbhtml.ctr"
#error "Redefinition of STM3_ST_SUCCESS"
#endif

#ifndef STM3_I_ANY
/** State machine input: Anything not listed below */
#line 152 "hbhtml.ctr"
#define STM3_I_ANY 0
#else
#line 152 "hbhtml.ctr"
#error "Redefinition of STM3_I_ANY"
#endif

#ifndef STM3_I_ASCII
/** State machine input: a-zA-Z01-9_ */
#line 153 "hbhtml.ctr"
#define STM3_I_ASCII 1
#else
#line 153 "hbhtml.ctr"
#error "Redefinition of STM3_I_ASCII"
#endif

#ifndef STM3_I_COLON
/** State machine input: Colon */
#line 154 "hbhtml.ctr"
#define STM3_I_COLON 2
#else
#line 154 "hbhtml.ctr"
#error "Redefinition of STM3_I_COLON"
#endif

#ifndef STM3_I_SLASH
/** State machine input: Slash */
#line 155 "hbhtml.ctr"
#define STM3_I_SLASH 3
#else
#line 155 "hbhtml.ctr"
#error "Redefinition of STM3_I_SLASH"
#endif

#ifndef STM3_O_ERROR
/** State machine output: ERROR found */
#line 158 "hbhtml.ctr"
#define STM3_O_ERROR 0
#else
#line 158 "hbhtml.ctr"
#error "Redefinition of STM3_O_ERROR"
#endif

#ifndef STM3_O_OK
/** State machine output: OK so far */
#line 157 "hbhtml.ctr"
#define STM3_O_OK 1
#else
#line 157 "hbhtml.ctr"
#error "Redefinition of STM3_O_OK"
#endif

/**@}*/

/**	Reset hbhtml_stm3 state machine.
	@param	st	Pointer to state variable.
*/
static
void
hbhtml_stm3_reset(int *st)
{
  if(st) { *st = STM3_ST_START; }
}

/**	State machine hbhtml_stm3 step.
	@param	st	Pointer to state variable.
	@param	in	Input.
	@return	Transition output.
*/
static
int
hbhtml_stm3_step(int *st, int in)
{
  int back = STM3_O_ERROR;
  if(st) {
    int os;
    int nf = 1;
    int ns = STM3_ST_ERROR;
    os = *st;
    switch(os) {
      case STM3_ST_COLON: {
        switch(in) {
          case STM3_I_SLASH: {
            ns = STM3_ST_COLSL; back = STM3_O_OK; nf = 0;
          } break;
        }
      } break;
      case STM3_ST_COLSL: {
        switch(in) {
          case STM3_I_SLASH: {
            ns = STM3_ST_SUCCESS; back = STM3_O_OK; nf = 0;
          } break;
        }
      } break;
      case STM3_ST_NAME: {
        switch(in) {
          case STM3_I_ASCII: {
            ns = STM3_ST_NAME; back = STM3_O_OK; nf = 0;
          } break;
          case STM3_I_COLON: {
            ns = STM3_ST_COLON; back = STM3_O_OK; nf = 0;
          } break;
        }
      } break;
      case STM3_ST_START: {
        switch(in) {
          case STM3_I_ASCII: {
            ns = STM3_ST_NAME; back = STM3_O_OK; nf = 0;
          } break;
        }
      } break;
    }
    if(nf) {
      if(os == STM3_ST_SUCCESS) {
      ns = STM3_ST_SUCCESS; back = STM3_O_OK;
      } else {
      }
    }
    *st = ns;
  } else {
  }
  return back;
}


#line 170 "hbhtml.ctr"


#include "dk3all.h"
#include "dk3strkv.h"
#include "htmlbook.h"





#line 179 "hbhtml.ctr"



/**	Translation table for ASCII characters.
*/
static char const * const hbhtml_translation_table[] = {
/*   0 00 */	 NULL,
/*   1 01 */	 NULL,
/*   2 02 */	 NULL,
/*   3 03 */	 NULL,
/*   4 04 */	 NULL,
/*   5 05 */	 NULL,
/*   6 06 */	 NULL,
/*   7 07 */	 NULL,
/*   8 08 */	 NULL,
/*   9 09 */	"\t",
/*  10 0a */	 NULL,
/*  11 0b */	 NULL,
/*  12 0c */	 NULL,
/*  13 0d */	 NULL,
/*  14 0e */	 NULL,
/*  15 0f */	 NULL,
/*  16 10 */	 NULL,
/*  17 11 */	 NULL,
/*  18 12 */	 NULL,
/*  19 13 */	 NULL,
/*  20 14 */	 NULL,
/*  21 15 */	 NULL,
/*  22 16 */	 NULL,
/*  23 17 */	 NULL,
/*  24 18 */	 NULL,
/*  25 19 */	 NULL,
/*  26 1a */	 NULL,
/*  27 1b */	 NULL,
/*  28 1c */	 NULL,
/*  29 1d */	 NULL,
/*  30 1e */	 NULL,
/*  31 1f */	 NULL,
/*  32 20 */	" ",
/*  33 21 */	"!",
/*  34 22 */	"&quot;",
/*  35 23 */	"#",
/*  36 24 */	"$",
/*  37 25 */	"%",
/*  38 26 */	"&amp;",
/*  39 27 */	"'",
/*  40 28 */	"(",
/*  41 29 */	")",
/*  42 2a */	"*",
/*  43 2b */	"+",
/*  44 2c */	",",
/*  45 2d */	"-",
/*  46 2e */	".",
/*  47 2f */	"/",
/*  48 30 */	"0",
/*  49 31 */	"1",
/*  50 32 */	"2",
/*  51 33 */	"3",
/*  52 34 */	"4",
/*  53 35 */	"5",
/*  54 36 */	"6",
/*  55 37 */	"7",
/*  56 38 */	"8",
/*  57 39 */	"9",
/*  58 3a */	":",
/*  59 3b */	";",
/*  60 3c */	"&lt;",
/*  61 3d */	"=",
/*  62 3e */	"&gt;",
/*  63 3f */	"?",
/*  64 40 */	"@",
/*  65 41 */	"A",
/*  66 42 */	"B",
/*  67 43 */	"C",
/*  68 44 */	"D",
/*  69 45 */	"E",
/*  70 46 */	"F",
/*  71 47 */	"G",
/*  72 48 */	"H",
/*  73 49 */	"I",
/*  74 4a */	"J",
/*  75 4b */	"K",
/*  76 4c */	"L",
/*  77 4d */	"M",
/*  78 4e */	"N",
/*  79 4f */	"O",
/*  80 50 */	"P",
/*  81 51 */	"Q",
/*  82 52 */	"R",
/*  83 53 */	"S",
/*  84 54 */	"T",
/*  85 55 */	"U",
/*  86 56 */	"V",
/*  87 57 */	"W",
/*  88 58 */	"X",
/*  89 59 */	"Y",
/*  90 5a */	"Z",
/*  91 5b */	"[",
/*  92 5c */	"\\",
/*  93 5d */	"]",
/*  94 5e */	"^",
/*  95 5f */	"_",
/*  96 60 */	"`",
/*  97 61 */	"a",
/*  98 62 */	"b",
/*  99 63 */	"c",
/* 100 64 */	"d",
/* 101 65 */	"e",
/* 102 66 */	"f",
/* 103 67 */	"g",
/* 104 68 */	"h",
/* 105 69 */	"i",
/* 106 6a */	"j",
/* 107 6b */	"k",
/* 108 6c */	"l",
/* 109 6d */	"m",
/* 110 6e */	"n",
/* 111 6f */	"o",
/* 112 70 */	"p",
/* 113 71 */	"q",
/* 114 72 */	"r",
/* 115 73 */	"s",
/* 116 74 */	"t",
/* 117 75 */	"u",
/* 118 76 */	"v",
/* 119 77 */	"w",
/* 120 78 */	"x",
/* 121 79 */	"y",
/* 122 7a */	"z",
/* 123 7b */	"{",
/* 124 7c */	"|",
/* 125 7d */	"}",
/* 126 7e */	"~",
/* 127 7f */	 NULL,
/* 128 80 */	 NULL,
/* 129 81 */	 NULL,
/* 130 82 */	 NULL,
/* 131 83 */	 NULL,
/* 132 84 */	 NULL,
/* 133 85 */	 NULL,
/* 134 86 */	 NULL,
/* 135 87 */	 NULL,
/* 136 88 */	 NULL,
/* 137 89 */	 NULL,
/* 138 8a */	 NULL,
/* 139 8b */	 NULL,
/* 140 8c */	 NULL,
/* 141 8d */	 NULL,
/* 142 8e */	 NULL,
/* 143 8f */	 NULL,
/* 144 90 */	 NULL,
/* 145 91 */	 NULL,
/* 146 92 */	 NULL,
/* 147 93 */	 NULL,
/* 148 94 */	 NULL,
/* 149 95 */	 NULL,
/* 150 96 */	 NULL,
/* 151 97 */	 NULL,
/* 152 98 */	 NULL,
/* 153 99 */	 NULL,
/* 154 9a */	 NULL,
/* 155 9b */	 NULL,
/* 156 9c */	 NULL,
/* 157 9d */	 NULL,
/* 158 9e */	 NULL,
/* 159 9f */	 NULL,
/* 160 a0 */	"&nbsp;",
/* 161 a1 */	"&iexcl;",
/* 162 a2 */	"&cent;",
/* 163 a3 */	"&pound;",
/* 164 a4 */	"&curren;",
/* 165 a5 */	"&yen;",
/* 166 a6 */	"&brvbar;",
/* 167 a7 */	"&sect;",
/* 168 a8 */	"&uml;",
/* 169 a9 */	"&copy;",
/* 170 aa */	"&ordf;",
/* 171 ab */	"&laquo;",
/* 172 ac */	"&not;",
/* 173 ad */	"&shy;",
/* 174 ae */	"&reg;",
/* 175 af */	"&macr;",
/* 176 b0 */	"&deg;",
/* 177 b1 */	"&plusmn;",
/* 178 b2 */	"&sup2;",
/* 179 b3 */	"&sup3;",
/* 180 b4 */	"&acute;",
/* 181 b5 */	"&micro;",
/* 182 b6 */	"&para;",
/* 183 b7 */	"&middot;",
/* 184 b8 */	"&cedil;",
/* 185 b9 */	"&sup1;",
/* 186 ba */	"&ordm;",
/* 187 bb */	"&raquo;",
/* 188 bc */	"&frac14;",
/* 189 bd */	"&frac12;",
/* 190 be */	"&frac34;",
/* 191 bf */	"&iquest;",
/* 192 c0 */	"&Agrave;",
/* 193 c1 */	"&Aacute;",
/* 194 c2 */	"&Acirc;",
/* 195 c3 */	"&Atilde;",
/* 196 c4 */	"&Auml;",
/* 197 c5 */	"&Aring;",
/* 198 c6 */	"&AElig;",
/* 199 c7 */	"&Ccedil;",
/* 200 c8 */	"&Egrave;",
/* 201 c9 */	"&Eacute;",
/* 202 ca */	"&Ecirc;",
/* 203 cb */	"&Euml;",
/* 204 cc */	"/Igrave;",
/* 205 cd */	"&Iacute;",
/* 206 ce */	"&Icirc;",
/* 207 cf */	"&Iuml;",
/* 208 d0 */	"&ETH;",
/* 209 d1 */	"&Ntilde;",
/* 210 d2 */	"&Ograve;",
/* 211 d3 */	"&Oacute;",
/* 212 d4 */	"&Ocirc;",
/* 213 d5 */	"&Otilde;",
/* 214 d6 */	"&Ouml;",
/* 215 d7 */	"&times;",
/* 216 d8 */	"&Oslash;",
/* 217 d9 */	"&Ugrave;",
/* 218 da */	"&Uacute;",
/* 219 db */	"&Ucirc;",
/* 220 dc */	"&Uuml;",
/* 221 dd */	"&Yacute;",
/* 222 de */	"&THORN;",
/* 223 df */	"&szlig;",
/* 224 e0 */	"&agrave;",
/* 225 e1 */	"&aacute;",
/* 226 e2 */	"&acirc;",
/* 227 e3 */	"&atilde;",
/* 228 e4 */	"&auml;",
/* 229 e5 */	"&aring;",
/* 230 e6 */	"&aelig;",
/* 231 e7 */	"&ccedil;",
/* 232 e8 */	"&egrave;",
/* 233 e9 */	"&eacute;",
/* 234 ea */	"&ecirc;",
/* 235 eb */	"&euml;",
/* 236 ec */	"&igrave;",
/* 237 ed */	"&iacute;",
/* 238 ee */	"&icirc;",
/* 239 ef */	"&iuml;",
/* 240 f0 */	"&eth;",
/* 241 f1 */	"&ntilde;",
/* 242 f2 */	"&ograve;",
/* 243 f3 */	"&oacute;",
/* 244 f4 */	"&ocirc;",
/* 245 f5 */	"&otilde;",
/* 246 f6 */	"&ouml;",
/* 247 f7 */	"&divide;",
/* 248 f8 */	"&oslash;",
/* 249 f9 */	"&ugrave;",
/* 250 fa */	"&uacute;",
/* 251 fb */	"&ucirc;",
/* 252 fc */	"&uuml;",
/* 253 fd */	"&yacute;",
/* 254 fe */	"&thorn;",
/* 255 ff */	"&yuml;"
};



/**	Constant 8-bit character keywords.
*/
static char const * const	hbhtml_c8_kw[] = {
/* 0 */
"\n",

/* 1 */
" ",

/* 2 */
"<img ",

/* 3 */
">",

/* 4 */
"src=\"",

/* 5 */
"\"",

/* 6 */
" alt=\"",

/* 7 */
" title=\"",

/* 8 */
" border=\"",

/* 9 */
" width=\"",

/* 10 */
" height=\"",

/* 11 */
"<html>\n",

/* 12 */
"</html>\n",

/* 13 */
"<body>\n",

/* 14 */
"</body>\n",

/* 15 */
"<head>\n",

/* 16 */
"</head>\n",

/* 17 */
"<!-- Generated by htmlbook (see http://dktools.sourceforge.net) -->\n",

/* 18 */
"<meta name=\"generator\" content=\"htmlbook\">\n",

/* 19 */
"<title>",

/* 20 */
"</title>\n",

/* 21 */
"<link rel=\"stylesheet\" type=\"text/css\" href=\"",

/* 22 */
"\">\n",

/* 23 */
"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=us-ascii\">\n",

/* 24 */
"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n",

/* 25 */
"<meta name=\"author\" content=\"",

/* 26 */
"\">\n",

/* 27 */
"<link rel=\"shortcut icon\" href=\"",

/* 28 */
"\">\n",

/* 29 */
"<div class=\"hb_nm_div\">\n",

/* 30 */
"</div><!-- class=hb_nm_div -->\n",

/* 31 */
"<ul class=\"hb_nm_ul\">\n",

/* 32 */
"</ul><!-- class=hb_nm_ul -->\n",

/* 33 */
"<li class=\"hb_nm_sep\">&nbsp;</li>\n",

/* 34 */
"<li class=\"hb_nm_c\"",

/* 35 */
"</li>\n",

/* 36 */
"<li class=\"hb_nm_li\">",

/* 37 */
"</li>\n",

/* 38 */
"hb_nm_a",

/* 39 */
"<a href=\"",

/* 40 */
">",

/* 41 */
"</a>",

/* 42 */
"\"",

/* 43 */
" class=\"",

/* 44 */
" title=\"",

/* 45 */
" type=\"",

/* 46 */
"<div class=\"hb_navigation\">",

/* 47 */
"</div>\n",

/* 48 */
"&nbsp;",

/* 49 */
"<a class=\"hb_navi_a\" href=\"",

/* 50 */
"\" title=\"",

/* 51 */
"\">",

/* 52 */
"</a>",

/* 53 */
"<img src=\"",

/* 54 */
"\" alt=\"",

/* 55 */
"\" title=\"",

/* 56 */
"\" class=\"hb_navi_img\" border=\"0\"",

/* 57 */
"0",

/* 58 */
" name=\"",

/* 59 */
" longdesc=\"",

/* 60 */
" class=\"",

/* 61 */
" id=\"",

/* 62 */
" usemap=\"",

/* 63 */
" align=\"",

/* 64 */
" hspace=\"",

/* 65 */
" vspace=\"",

/* 66 */
" ismap",

/* 67 */
" width=\"%lu\" height=\"%lu\"",

/* 68 */
"<a class=\"hb_img_a_larger\" href=\"",

/* 69 */
"\" target=\"_blank\"",

/* 70 */
"<object type=\"application/pdf\" data=\"",

/* 71 */
"\" width=\"",

/* 72 */
"\" height=\"",

/* 73 */
"</object>",

/* 74 */
"<a name=\"",

/* 75 */
"\" target=\"",

/* 76 */
"\" type=\"",

/* 77 */
"\" class=\"",

/* 78 */
"\" id=\"",

/* 79 */
"\" style=\"",

/* 80 */
"\" hreflang=\"",

/* 81 */
"\" title=\"",

/* 82 */
"\" onblur=\"",

/* 83 */
"\" onfocus=\"",

/* 84 */
"\" rel=\"",

/* 85 */
"\" rev=\"",

/* 86 */
"\" shape=\"",

/* 87 */
"\" tabindex=\"",

/* 88 */
"\" accesskey=\"",

/* 89 */
"\" charset=\"",

/* 90 */
"\" coords=\"",

/* 91 */
"<span class=\"hb_link_number\">&nbsp;&#9001;%lu&#9002;</span>",

/* 92 */
"<table class=\"hb_me_ta\" summary=\"",

/* 93 */
"</table>\n",

/* 94 */
"<tr class=\"hb_me_tr\">\n",

/* 95 */
"</tr>\n",

/* 96 */
"<td class=\"hb_me_td_text\" colspan=\"%u\">",

/* 97 */
"</td>\n",

/* 98 */
"<td></td>\n",

/* 99 */
"<td class=\"hb_me_td_arrow\">&nbsp;&#8594;&nbsp;</td>\n",

/* 100 */
"hb_a_i",

/* 101 */
"hb_a_e",

/* 102 */
"<div class=\"hb_file_div\">\n",

/* 103 */
"<a class=\"hb_file_a\" target=\"_blank\" href=\"",

/* 104 */
"text/plain",

/* 105 */
"<br>\n",

/* 106 */
"<pre>\n",

/* 107 */
"</pre>\n",

/* 108 */
"\" target=\"_blank",

/* 109 */
"<div class=\"hb_img_div_outer\">\n",

/* 110 */
"<div class=\"hb_img_div_inner_img\">\n",

/* 111 */
"<div class=\"hb_img_div_inner_img_centered\">\n",

/* 112 */
"<p class=\"hb_img_p_download\">\n",

/* 113 */
"<br class=\"clearboth\">\n</p>\n",

/* 114 */
"\n<object type=\"image/svg+xml\" data=\"",

/* 115 */
"<param name=\"src\" value=\"",

/* 116 */
"<br>\n<span class=\"hb_img_caption\">",

/* 117 */
"</span>",

/* 118 */
" type=\"image/svg+xml\"",

/* 119 */
" type=\"application/pdf\"",

/* 120 */
"<p><br class=\"clearboth\"></p>\n",

/* 121 */
"<script src=\"",

/* 122 */
"\" type=\"text/javascript\">\n</script>\n",

/* 123 */
"<link rel=\"",

/* 124 */
"\" title=\"",

/* 125 */
"\" href=\"",

/* 126 */
"\">\n",

/* 127 */
"author",

/* 128 */
"contents",

/* 129 */
"index",

/* 130 */
"top",

/* 131 */
"up",

/* 132 */
"first",

/* 133 */
"prev",

/* 134 */
"next",

/* 135 */
"last",

/* 136 */
"#hb_toc",

/* 137 */
"#hb_index",

/* 138 */
"<table class=\"hb_img_ta\" summary=\"",

/* 139 */
"<tr class=\"hb_img_tr\">\n",

/* 140 */
"<td class=\"hb_img_td_img\">\n",

/* 141 */
"<td class=\"hb_img_td_empty\">&nbsp;</td>\n",

/* 142 */
"<td class=\"hb_img_td_a\">\n",

/* 143 */
"\">\n",

/* 144 */
"hb_nm_a_parent",

/* 145 */
"<div class=\"hb_img_div_no_vspace\">\n",

/* 146 */
"<code title=\"",

/* 147 */
"\">",

/* 148 */
"</code>",

/* 149 */
"   ",

/* 150 */
" ",

NULL


#line 811 "hbhtml.ctr"
};



/**	Special commands.
*/
dkChar const * const	hbhtml_special_commands[] = {
/* 0 */
dkT("contents"),

/* 1 */
dkT("title"),

/* 2 */
dkT("img"),

/* 3 */
dkT("menu"),

/* 4 */
dkT("navigation"),

/* 5 */
dkT("links"),

/* 6 */
dkT("author"),

/* 7 */
dkT("location"),

/* 8 */
dkT("date"),

/* 9 */
dkT("var"),

/* 10 */
dkT("code"),

/* 11 */
dkT("a"),

/* 12 */
dkT("menuentry"),

/* 13 */
dkT("index"),

/* 14 */
dkT("sourcefile"),

NULL


#line 880 "hbhtml.ctr"
};




/**	Attributes allowed in image special command.
*/
dkChar const * const	hbhtml_img_keys[] = {
/* 0 */
dkT("ali$gn"),

/* 1 */
dkT("alt"),

/* 2 */
dkT("b$order"),

/* 3 */
dkT("he$ight"),

/* 4 */
dkT("hs$pace"),

/* 5 */
dkT("is$map"),

/* 6 */
dkT("lo$ngdesc"),

/* 7 */
dkT("n$ame"),

/* 8 */
dkT("sr$c"),

/* 9 */
dkT("u$semap"),

/* 10 */
dkT("v$space"),

/* 11 */
dkT("w$idth"),

/* 12 */
dkT("la$rger"),

/* 13 */
dkT("p$df"),

/* 14 */
dkT("cac$he"),

/* 15 */
dkT("ti$tle"),

/* 16 */
dkT("cl$ass"),

/* 17 */
dkT("id"),

/* 18 */
dkT("div"),

/* 19 */
dkT("cap$tion"),

/* 20 */
dkT("ce$ntered"),

/* 21 */
dkT("svg"),

/* 22 */
dkT("svgwh"),

/* 23 */
dkT("do$wnloads"),

/* 24 */
dkT("o$bject"),

/* 25 */
dkT("ta$ble"),

/* 26 */
dkT("no-v$space"),

/* 27 */
dkT("f$ile"),

NULL


#line 918 "hbhtml.ctr"
};



/**	Attributes for menu.
*/
dkChar const * const	hbhtml_menu_keys[] = {
/* 0 */
dkT("st$yle"),

/* 1 */
dkT("su$b"),

NULL


#line 929 "hbhtml.ctr"
};



/**	Attributes for menuentry.
*/
dkChar const * const	hbhtml_menuentry_keys[] = {
/* 0 */
dkT("i$tem"),

NULL


#line 939 "hbhtml.ctr"
};



/**	Attributes for index entry.
*/
dkChar const * const	hbhtml_index_keys[] = {
/* 0 */
dkT("t$ext"),

/* 1 */
dkT("n$ame"),

/* 2 */
dkT("ref$erence"),

NULL


#line 951 "hbhtml.ctr"
};



/**	Attributes for sourcefile special command.
*/
dkChar const * const	hbhtml_sourcef_keys[] = {
/* 0 */
dkT("f$ile"),

/* 1 */
dkT("ty$pe"),

/* 2 */
dkT("ti$tle"),

/* 3 */
dkT("l$ineno"),

NULL


#line 964 "hbhtml.ctr"
};


/**	Attributes for navigation.
*/
dkChar const * const	hbhtml_navi_keys[] = {
/* 0 */
dkT("t$oc"),

/* 1 */
dkT("p$revious"),

/* 2 */
dkT("n$ext"),

/* 3 */
dkT("i$ndex"),

NULL


#line 976 "hbhtml.ctr"
};



/**	Attributes for code special command.
*/
dkChar const * const	hbhtml_code_keys[] = {
/* 0 */
dkT("e$nable"),

/* 1 */
dkT("on"),

/* 2 */
dkT("d$isable"),

/* 3 */
dkT("of$f"),

/* 4 */
dkT("t$oggle"),

/* 5 */
dkT("l$ineno"),

NULL


#line 991 "hbhtml.ctr"
};



/**	Attribute for a.
*/
dkChar const * const    hbhtml_a_keys[] = {
/* 0 */
dkT("te$xt"),

/* 1 */
dkT("ti$tle"),

/* 2 */
dkT("ac$cesskey"),

/* 3 */
dkT("ch$arset"),

/* 4 */
dkT("co$ords"),

/* 5 */
dkT("href"),

/* 6 */
dkT("hrefl$ang"),

/* 7 */
dkT("na$me"),

/* 8 */
dkT("onb$lur"),

/* 9 */
dkT("onf$ocus"),

/* 10 */
dkT("rel"),

/* 11 */
dkT("rev"),

/* 12 */
dkT("sh$ape"),

/* 13 */
dkT("tab$index"),

/* 14 */
dkT("tar$get"),

/* 15 */
dkT("ty$pe"),

/* 16 */
dkT("cl$ass"),

/* 17 */
dkT("id"),

/* 18 */
dkT("st$yle"),

/* 19 */
dkT("ext$ernal"),

NULL


#line 1020 "hbhtml.ctr"
};



/**	The menu styles.
*/
dkChar const * const	hbhtml_menu_styles[] = {
/* 0 */
dkT("r$everse"),

/* 1 */
dkT("f$ull"),

/* 2 */
dkT("c$urrent"),

/* 3 */
dkT("t$op"),

NULL


#line 1033 "hbhtml.ctr"
};



/**	Attributes allowed in date special.
*/
dkChar const * const	hbhtml_date_keys[] = {
/* 0 */
dkT("st$yle"),

NULL


#line 1043 "hbhtml.ctr"
};



/**	Subcommands of img with not vertical space.
*/
dkChar const * const	hbhtml_no_vspace_suffixes[] = {
/* 0 */
dkT("tex"),

NULL


#line 1053 "hbhtml.ctr"
};



/**	File name suffixes.
*/
dkChar const * const	hbhtml_image_filename_suffixes[] = {
/* 0 */
dkT(".png"),

/* 1 */
dkT(".pdf"),

/* 2 */
dkT(".svg"),

NULL


#line 1065 "hbhtml.ctr"
};



/**	Check whether a character is useable in an URL.
	RFC 1630 and 3986 allow only 8-bit characters (octets)
	in URLs.
	@param	c32	Character to check.
	@return	1 for usable character, 0 otherwise.
*/
static
int
hbhtml_url_useable(dk3_c32_t c32)
{
  int		back = 1;
  

#line 1081 "hbhtml.ctr"
  if((dk3_c32_t)255 < c32) {
    back = 0;	/* NOT REPORTED */
  } 

#line 1084 "hbhtml.ctr"
  return back;
}



#if 0
/**	Check whether a character must be written hex-encoded to an URL.
	See RFC 3986 for reserved and unreserved characters.
	@param	c32	Character to check.
	@return	1 for hex-encoding, 0 for direct use.
*/
static
int
hbhtml_url_must_encode_normally(dk3_c32_t c32)
{
  int		 back = 1;
  char		 c;
  if((dk3_c32_t)128 > c32) {
    c = (char)c32;
    c &= 0x7F;
    if(('a' <= c) && ('z' >= c)) {
      back = 0;
    } else {
      if(('A' <= c) && ('Z' >= c)) {
        back = 0;
      } else {
        if(('0' <= c) && ('9' >= c)) {
	  back = 0;
	} else {
	  switch(c) {
	    case '-': case '_': case '.': case '~': {
	      back = 0;
	    } break;
	  }
	}
      }
    }
  }
  return back;
}
#endif



/**	Check whether a character must be written hex-encoded to an URL.
	See RFC 3986 for reserved and unreserved characters.
	@param	c32	Character to check.
	@return	1 for hex-encoding, 0 for direct use.
*/
static
int
hbhtml_url_must_encode(dk3_c32_t c32)
{
  int		 back = 0;
  

#line 1139 "hbhtml.ctr"
  if((dk3_c32_t)126 < c32) {
    back = 1;
  } else {
    if((dk3_c32_t)33 > c32) {
      back = 1;
    }
  } 

#line 1146 "hbhtml.ctr"
  return back;
}



/**	Write one character in URL encoding, complain on problems.
	Unusable characters (not in octect range 0...0xFF) 
	are UTF-8 encoded first and hex-converted for the URL.
	Some ASCII characters have special meaning in URL encoding
	(i.e. ampersand, question mark...). We assume the user
	intended to use these characters and specified the URL
	so we can use it "as is".

	@param	job	Job structure.
	@param	c32	Character to print.
*/
static
void
hbhtml_url_c32(hb_job_t *job, dk3_c32_t c32)
{
  char		buf[16];	/* Buffer for hexadecimal notation */
  unsigned char	ub[16];		/* Buffer for UTF-8 notation */
  size_t	sz;		/* Number of bytes used in ub */
  size_t	i;		/* Traverse ub */
  

#line 1171 "hbhtml.ctr"
  if(hbhtml_url_useable(c32)) {
    if(hbhtml_url_must_encode(c32)) {
      buf[0] = '%';
      sprintf(&(buf[1]), "%02X", (unsigned)c32);
      fputs(buf, job->of);
    } else {
      fputc((((char)c32) & ((char)0x7F)), job->of);
    }
  } else {
    job->non_url = 1;
    sz = dk3enc_uc2utf8(c32, ub, sizeof(ub));
    for(i = 0; i < sz; i++) {
      buf[0] = '%';
      sprintf(&(buf[1]), "%02X", ((unsigned)(ub[i]) & 0x00FFU));
      fputs(buf, job->of);
    }
  } 

#line 1188 "hbhtml.ctr"
}



/**	Write shipout buffer in URL encoding.
	@param	job	Job  structure.
*/
static
void
hbhtml_url_flush_shipout(hb_job_t *job)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  size_t		 i;
#else
  dk3_c16_t const	*sp;		/* Source character pointer */
  dk3_c32_t		 c32;		/* 32-bit character */
  size_t		 sl;		/* Remaining source string length */
  size_t		 used;		/* Number of source chars used */
#endif
#else
  unsigned char const	*sp;		/* Source character pointer */
  dk3_c32_t		 c32;		/* 32-bit character */
  size_t		 sl;		/* Remaining source string length */
  size_t		 used;		/* Number of source chars used */
  size_t		 i;		/* Process all source chars */
  unsigned char		 c;		/* Current source char to process */
#endif
  

#line 1217 "hbhtml.ctr"
  if(job->shipused) {
    job->non_url = 0;
    if(job->shipused < job->bs) {
      (job->shipbuffer)[job->shipused] = dkT('\0');
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
	for(i = 0; i < (job->shipused); i++) {
	  hbhtml_url_c32(job, (job->shipused)[i]);
	}
#else
	sp = (dk3_c16_t const *)(job->shipbuffer);
	sl = job->shipused;
	while(sl > 0) {
	  used = 0;
	  if(dk3enc_utf162uc(&c32, sp, sl, &used)) {
	    hbhtml_url_c32(job, c32);
	    if(used > 0) {
	      if(sl >= used) {
	        sl = sl - used;
		sp = &(sp[used]);
	      } else {
	        sl = 0;
		/* ERROR: Decoding */
		dk3app_log_i1(job->app, DK3_LL_ERROR, 119);
	      }
	    } else {
	      sl = 0;
	      /* ERROR: Decoding */
	      dk3app_log_i1(job->app, DK3_LL_ERROR, 119);
	    }
	  } else {
	    sl = 0;
	    /* ERROR: Decoding */
	    dk3app_log_i1(job->app, DK3_LL_ERROR, 119);
	  }
	}
#endif
#else
	

#line 1256 "hbhtml.ctr"
        if(dk3app_get_encoding(job->app) == DK3_ENCODING_UTF8) {
	  

#line 1258 "hbhtml.ctr"
	  sp = (unsigned char const *)(job->shipbuffer);
	  sl = job->shipused;
	  while(sl > 0) {
	    used = 0;
	    if(dk3enc_utf82uc(&c32, sp, sl, &used)) {
	      hbhtml_url_c32(job, c32);
	      if(used > 0) {
	        if(sl >= used) {
		  sl = sl - used;
		  sp = &(sp[used]);
		} else {
		  sl = 0;
		  /* ERROR: Decoding problem */
		  dk3app_log_i1(job->app, DK3_LL_ERROR, 118);
		}
	      } else {
	        sl = 0;
		/* ERROR: Decoding problem */
		dk3app_log_i1(job->app, DK3_LL_ERROR, 118);
	      }
	    } else {
	      sl = 0;
	      /* ERROR: Decoding problem */
	      dk3app_log_i1(job->app, DK3_LL_ERROR, 118);
	    }
	  }
	} else {
	  sp = (unsigned char const *)(job->shipbuffer);
	  for(i = 0; i < (job->shipused); i++) {
	    c = sp[i];
	    c32 = (dk3_c32_t)c;
	    c32 &= 0x000000FFUL;
	    hbhtml_url_c32(job, c32);
	  }
	}
	

#line 1294 "hbhtml.ctr"
#endif
      if(job->non_url) {
        /* WARNING: Non-URL characters in string! */
	dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 21, 22, job->shipbuffer);
      }
    }
    job->non_url = 0;
  }
  job->shipused = 0;
  

#line 1304 "hbhtml.ctr"
}



void
hbhtml_c32(hb_job_t *job, dk3_c32_t c32)
{
  unsigned char	ub[16];		/* Buffer for UTF-8 conversion */
  size_t	sz;		/* Number of chars used in ub */
  size_t	i;		/* Process all chars in ub */
  char		c;		/* Current char from ub */
  

#line 1316 "hbhtml.ctr"
  if(((dk3_c32_t)128) > c32) {
    c = (((char)c32) & ((char)0x7F));
    switch(c) {
      case '\n': {
        fputc('\n', job->of);
      } break;
      case '&': {
        if((job->options) & HB_JOB_OPT_CODE) {
	  fputs(hbhtml_translation_table[38], job->of);
	} else {
	  if(((job->currentnode)->options) & HB_NODE_OPT_REPLACE_AMPERSAND) {
	    fputs(hbhtml_translation_table[38], job->of);
	  } else {
	    fputc('&', job->of);
	  }
	}
      } break;
      case '<': {
        if((job->options) & HB_JOB_OPT_CODE) {
	  fputs(hbhtml_translation_table[60], job->of);
	} else {
	  fputc('<', job->of);
	}
      } break;
      case '>': {
        if((job->options) & HB_JOB_OPT_CODE) {
	  fputs(hbhtml_translation_table[62], job->of);
	} else {
	  fputc('>', job->of);
	}
      } break;
      case '"': {
        if((job->options) & HB_JOB_OPT_CODE) {
	  fputs(hbhtml_translation_table[34], job->of);
	} else {
	  fputc('"', job->of);
	}
      } break;
      case '%': {
        fputc('%', job->of);	/* PROBABLY NEED A CODE */
      } break;
      default: {
        sz = (size_t)c32;
	sz &= (size_t)0x007FU;
	if(hbhtml_translation_table[sz]) {
	  fputs(hbhtml_translation_table[sz], job->of);
	} else {
	  fprintf(job->of, "&#x%02lx;", (unsigned long)c32);
	}
      } break;
    }
  } else {
    if(((dk3_c32_t)256) > c32) {
      sz = (size_t)c32;
      sz &= (size_t)0x00FFU;
      if(hbhtml_translation_table[sz]) {
        fputs(hbhtml_translation_table[sz], job->of);
      } else {
	fprintf(job->of, "&#x%02lx;", (unsigned long)c32);
      }
    } else {
      if(HB_CS_UTF_8 == job->cs) {
        sz = dk3enc_uc2utf8(c32, ub, sizeof(ub));
	for(i = 0; i < sz; i++) { fputc(ub[i], job->of); }
      } else {
        if(((dk3_c32_t)0x010000UL) > c32) {
	  fprintf(job->of, "&#x%04lx;", (unsigned long)c32);
	} else {
	  if(((dk3_c32_t)0x01000000UL) > c32) {
	    fprintf(job->of, "&#x%06lx;", (unsigned long)c32);
	  } else {
	    fprintf(job->of, "&#x%08lx;", (unsigned long)c32);
	  }
	}
      }
    }
  } 

#line 1393 "hbhtml.ctr"
}



/**	Flush the shipout buffer.
	@param	job	Job structure.
*/
static
void
hbhtml_flush_shipout(hb_job_t *job)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  size_t		 i;		/* Process all characters */
#else
  dk3_c16_t const	*sp;		/* Current source start */
  dk3_c32_t		 c32;		/* Current 32-bit char to process */
  size_t		 sl;		/* Remaining source length */
  size_t		 used;		/* Source chars used */
#endif
#else
  unsigned char const	*sp;		/* Current source start */
  dk3_c32_t		 c32;		/* Current 32-bit char to process */
  size_t		 sl;		/* Remaining source length */
  size_t		 used;		/* Source chars used */
  size_t		 i;		/* Process all chars from buffer */
  unsigned char		 c;		/* Current char to process */
#endif
  

#line 1422 "hbhtml.ctr"
  if(job->shipused) {
    if(job->shipused < job->bs) {
      (job->shipbuffer)[job->shipused] = dkT('\0');
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
	for(i = 0; i < (job->shipused); i++) {
	  hbhtml_c32(job, (job->shipused)[i]);
	}
#else
	sp = (dk3_c16_t const *)(job->shipbuffer);
	sl = job->shipused;
	while(sl > 0) {
	  used = 0;
	  if(dk3enc_utf162uc(&c32, sp, sl, &used)) {
	    hbhtml_c32(job, c32);
	    if(used > 0) {
	      if(sl >= used) {
	        sl = sl - used;
		sp = &(sp[used]);
	      } else {
	        sl = 0;
		/* ERROR: Decoding */
		dk3app_log_i1(job->app, DK3_LL_ERROR, 119);
	      }
	    } else {
	      sl = 0;
	      /* ERROR: Decoding */
	      dk3app_log_i1(job->app, DK3_LL_ERROR, 119);
	    }
	  } else {
	    sl = 0;
	    /* ERROR: Decoding */
	    dk3app_log_i1(job->app, DK3_LL_ERROR, 119);
	  }
	}
#endif
#else
	

#line 1460 "hbhtml.ctr"
        if(dk3app_get_encoding(job->app) == DK3_ENCODING_UTF8) {
	  

#line 1462 "hbhtml.ctr"
	  sp = (unsigned char const *)(job->shipbuffer);
	  sl = job->shipused;
	  while(sl > 0) {
	    used = 0;
	    if(dk3enc_utf82uc(&c32, sp, sl, &used)) {
	      hbhtml_c32(job, c32);
	      if(used > 0) {
	        if(sl >= used) {
		  sl = sl - used;
		  sp = &(sp[used]);
		} else {
		  sl = 0;
		  /* ERROR: Decoding problem */
		  dk3app_log_i1(job->app, DK3_LL_ERROR, 118);
		}
	      } else {
	        sl = 0;
		/* ERROR: Decoding problem */
		dk3app_log_i1(job->app, DK3_LL_ERROR, 118);
	      }
	    } else {
	      sl = 0;
	      /* ERROR: Decoding problem */
	      dk3app_log_i1(job->app, DK3_LL_ERROR, 118);
	    }
	  }
	} else {
	  sp = (unsigned char const *)(job->shipbuffer);
	  for(i = 0; i < (job->shipused); i++) {
	    c = sp[i];
	    c32 = (dk3_c32_t)c;
	    c32 &= 0x000000FFUL;
	    hbhtml_c32(job, c32);
	  }
	}
	

#line 1498 "hbhtml.ctr"
#endif
    }
  }
  job->shipused = 0;
  

#line 1503 "hbhtml.ctr"
}



/**	Add one character to shipout buffer.
	@param	job	Job structure.
	@param	c	Character to add.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_shipout(hb_job_t *job, dkChar c)
{
  int		 back = 1;
  

#line 1518 "hbhtml.ctr"
  if((job->shipused) < (job->bs - 1)) {
    (job->shipbuffer)[job->shipused] = c;
    job->shipused += 1;
    if(job->shipused >= job->bs) {
      back = 0;
    }
  } else {
    back = 0;
  } 

#line 1527 "hbhtml.ctr"
  return back;
}


 
/**	Add one character to special command buffer.
	@param	job	Job structure.
	@param	c	Character to add.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_add_to_special(hb_job_t *job, dkChar c)
{
  int		 back = 1;
  

#line 1543 "hbhtml.ctr"
  if((job->spused) < (job->bs - 1)) {
    (job->special)[job->spused] = c;
    job->spused += 1;
    if(job->spused >= job->bs) {
      back = 0;
    }
  } else {
    back = 0;
  } 

#line 1552 "hbhtml.ctr"
  return back;
}



/**	Classify a character for processing by state machine 1.
	@param	c	Character to classify.
	@return	Classification result.
*/
static
int
hbhtml_classify_for_stm1(dkChar c)
{
  int		back = STM1_I_ANY;
  switch(c) {
    case dkT('%'): {
      back = STM1_I_PERCENT;
    } break;
    case dkT('\\'): {
      back = STM1_I_BS;
    } break;
  }
  return back;
}



/**	Write text to HTML output file.
	@param	job	Job structure.
	@param	text	Text to write.
	@return	1 on success, 0 on error.
*/
int
hbhtml_output_for_text(hb_job_t *job, dkChar const *text)
{
  size_t	sz;
#if VERSION_BEFORE_20131219
  int		oldcode;
#endif
  int		back	= 0;
  

#line 1593 "hbhtml.ctr"
  if((job) && (text)) {
    sz = dk3str_len(text);
    if(sz < job->bs) {			

#line 1596 "hbhtml.ctr"
#if VERSION_BEFORE_20131219
      oldcode = (((job->options) & HB_JOB_OPT_CODE) ? 1 : 0);
      job->options &= (~(HB_JOB_OPT_CODE));
#endif
      dk3str_cpy(job->shipbuffer, text);
      job->shipused = sz;		

#line 1602 "hbhtml.ctr"
      hbhtml_flush_shipout(job);	

#line 1603 "hbhtml.ctr"
      back = 1;
      job->spused = 0;
      job->shipused = 0;
#if VERSION_BEFORE_20131219
      if(oldcode) {
        job->options |= HB_JOB_OPT_CODE;
      }
#endif
    }
  } 

#line 1613 "hbhtml.ctr"
  return back;
}



/**	Write text to URL output file.
	@param	job	Job structure.
	@param	text	Text to write.
	@return	1 on success, 0 on error.
*/
int
hbhtml_url_output_for_text(hb_job_t *job, dkChar const *text)
{
  size_t		 sz;		/* Text length */
  int			 back = 0;
  

#line 1629 "hbhtml.ctr"
  if((job) && (text)) {
    sz = dk3str_len(text);
    if(sz < job->bs) {
      dk3str_cpy(job->shipbuffer, text);
      job->shipused = sz;
      hbhtml_url_flush_shipout(job);
      back = 1;
      job->spused = 0;
      job->shipused = 0;
    }
  } 

#line 1640 "hbhtml.ctr"
  return back;
}



/**	Process the title special command.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_process_sp_title(hb_job_t *job)
{
  int			 back = 0;
  

#line 1655 "hbhtml.ctr"
  if(job->rootnode) {			

#line 1656 "hbhtml.ctr"
    if((job->rootnode)->title) {		

#line 1657 "hbhtml.ctr"
      if(hbhtml_output_for_text(job, (job->rootnode)->title)) {
        back = 1;
      }
    }
  } 

#line 1662 "hbhtml.ctr"
  return back;
}



/**	Build new file name if necessary.
	@param	oldname		Existing file name.
	@param	fnb		File name buffer.
	@param	fnbsz		Size of file name buffer.
	@param	sc		Sub command.
	@param	newsuffix	New file name suffix.
	@param	job		Job structure.
	@param	ecp		Error code variable pointer.
*/
static
dkChar *
hbhtml_sc_fn(
  dkChar		*oldname,
  dkChar		*fnb,
  size_t		 fnbsz,
  dkChar		*sc,
  dkChar const		*newsuffix,
  hb_job_t		*job,
  int			*ecp
)
{
  dk3_stat_t	 stb;
  dkChar	*back;
  dkChar	*sp;
  

#line 1692 "hbhtml.ctr"
  

#line 1693 "hbhtml.ctr"
  

#line 1694 "hbhtml.ctr"
  back = oldname;
  if(!(back)) {
    /*	Remove suffix if it matches subcommand.
    */
    sp = dk3str_get_suffix(fnb);
    if(sp) {
      if(0 == dk3str_casecmp(&(sp[1]), sc)) {
        *sp = dkT('\0');
      }
    }
    /*	Add new suffix.
    */
    if(fnbsz > (dk3str_len(fnb) + dk3str_len(newsuffix))) {
      dk3str_cat(fnb, newsuffix);
      /*	If file exists, use file name from fnb.
      */
      if(dk3sf_stat_app(&stb, fnb, NULL)) {
        switch(stb.ft) {
	  case DK3_FT_REGULAR: {
	    back = fnb;
	  } break;
	  default: {
	    /* ERROR: Not a regular file */
	    dk3app_log_i3(job->app, DK3_LL_ERROR, 255, 256, fnb);
	  } break;
	}
      } else {
        dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 84, 85, fnb);
      }
    } else {
      /* ERROR: File name too long */
      dk3app_log_i3(job->app, DK3_LL_ERROR, 65, 66, fnb);
      if(ecp) { *ecp = 1; }
    }
  }  

#line 1729 "hbhtml.ctr"
  return back;
}



/**	Process image special command.
	@param	job		Job structure.
	@param	pa		Pointer to arguments.
	@param	sc		Subcommand, may be NULL.
	@param	in_template	Flag: Processing the template.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_process_sp_image(hb_job_t *job, dkChar *pa, dkChar *sc, int in_template)
{
  dkChar		 svgnbuf[DK3_MAX_PATH];	/* SVG file name */
  dkChar		 pdfnbuf[DK3_MAX_PATH];	/* PDF file name */
  dkChar		 pngnbuf[DK3_MAX_PATH];	/* PNG file name */
  dk3_key_value_t	 kv[30];		/* Parameters */
  dkChar		 wbuf[64];		/* Width buffer */
  dkChar		 hbuf[64];		/* Height buffer */
  dkChar 		*align	= NULL;		/* Align specified */
  dkChar		*alt	= NULL;		/* Alternative text */	
  dkChar		*border	= NULL;		/* Border specified */
  dkChar		*height	= NULL;		/* Height specified */
  dkChar		*hspace	= NULL;		/* Horiz space specified */
  dkChar		*longdesc	= NULL;	/* Longdesc specified */
  dkChar		*name	= NULL;		/* Name. */
  dkChar		*src	= NULL;		/* Image file name */
  dkChar		*usemap	= NULL;		/* Usemap text */
  dkChar		*vspace	= NULL;		/* Vertical space specified */
  dkChar		*width	= NULL;		/* Width specified */
  dkChar		*larger	= NULL;		/* File name large resolution */
  dkChar		*pdf	= NULL;		/* PDF file name */
  dkChar		*clptr	= NULL;		/* Image CSS class */
  dkChar		*idptr	= NULL;		/* Image CSS id */
  dkChar		*title	= NULL;		/* Image title */
  dkChar		*capt	= NULL;		/* Image caption */
  dkChar		*svg	= NULL;		/* SVG file name */
  dkChar		*fnptr	= NULL;		/* The file argument */
  unsigned long		 xw	= 0UL;		/* Width found */
  unsigned long		 xh	= 0UL;		/* Height found */
  size_t		 sz;			/* Size of key value array */
  size_t		 i;			/* Traverse key value array */
  int			 cache	= 0;		/* Flag: Cache width+height */
  int			 ismap	= 0;		/* Flag: Write isamp attrib */
  int			 back	= 0;		/* Result */
  int			 tispec	= 0;		/* Flag: Title specified */
  int			 caspec = 0;		/* Flag: Capction specified */
  int			 svgwh	= 0;		/* Flag: For SVG width+height */
  int			 dodiv	= 0;		/* Img in div(1) or table(2) */
  int			 center	= 0;		/* Flag: Center image */
  int			 downlo	= 0;		/* Flag: Create download div */
  int			 haveli	= 0;		/* Already have written link */
  int			 crobj	= 1;		/* Flag: Create object */
  int			 novsp	= 0;		/* Flag: No vertical space. */
  int			 fnerr	= 0;		/* Flag: Error related file */
  

#line 1788 "hbhtml.ctr"
  sz = DK3_SIZEOF(kv,dk3_key_value_t);
  svgnbuf[0] = pdfnbuf[0] = pngnbuf[0] = dkT('\0');
  if(dk3str_to_key_value(kv, &sz, pa, job->app)) {
    

#line 1792 "hbhtml.ctr"
    if(sc) {		

#line 1793 "hbhtml.ctr"
      tispec = 1;
      downlo = 1;
      dodiv  = 2;
      if(-1 < dk3str_array_index(hbhtml_no_vspace_suffixes, sc, 0)) {
        novsp = 1;
      }
    }
    for(i = 0; i < sz; i++) {
      if(kv[i].key) {				

#line 1802 "hbhtml.ctr"
        switch(dk3str_array_abbr(hbhtml_img_keys, kv[i].key, dkT('$'), 0)) {
	  case 0: {			

#line 1804 "hbhtml.ctr"
	    align = kv[i].val;
	  } break;
	  case 1: {			

#line 1807 "hbhtml.ctr"
	    alt = kv[i].val;
	  } break;
	  case 2: {			

#line 1810 "hbhtml.ctr"
	    border = kv[i].val;
	  } break;
	  case 3: {			

#line 1813 "hbhtml.ctr"
	    height = kv[i].val;
	  } break;
	  case 4: {			

#line 1816 "hbhtml.ctr"
	    hspace = kv[i].val;
	  } break;
	  case 5: {	/* ismap */	

#line 1819 "hbhtml.ctr"
	    if(kv[i].val) {
	      if(dk3str_is_bool(kv[i].val)) {
	        if(dk3str_is_on(kv[i].val)) {
		  ismap = 1;
		} else {
		  ismap = 0;
		}
	      }
	    } else {
	      ismap = 1;
	    }
	  } break;
	  case 6: {				

#line 1832 "hbhtml.ctr"
	    longdesc = kv[i].val;
	  } break;
	  case 7: {				

#line 1835 "hbhtml.ctr"
	    name = kv[i].val;
	  } break;
	  case 8: {				

#line 1838 "hbhtml.ctr"
	    src = kv[i].val;
	  } break;
	  case 9: {				

#line 1841 "hbhtml.ctr"
	    usemap = kv[i].val;
	  } break;
	  case 10: {				

#line 1844 "hbhtml.ctr"
	    vspace = kv[i].val;
	  } break;
	  case 11: {				

#line 1847 "hbhtml.ctr"
	    width = kv[i].val;
	  } break;
	  case 12: {	

#line 1850 "hbhtml.ctr"
	    larger = kv[i].val;
	  } break;
	  case 13: {				

#line 1853 "hbhtml.ctr"
	    pdf = kv[i].val;
	  } break;
	  case 14: {	/* caching */		

#line 1856 "hbhtml.ctr"
	    if(kv[i].val) {
	      if(dk3str_is_bool(kv[i].val)) {
	        if(dk3str_is_on(kv[i].val)) {
		  cache = 1;
		} else {
		  cache = 0;
		}
	      }
	    } else {
	      cache = 1;
	    }
	  } break;
	  case 15: {			

#line 1869 "hbhtml.ctr"
	    title = kv[i].val;
	    tispec = 1;
	  } break;
	  case 16: {			

#line 1873 "hbhtml.ctr"
	    clptr = kv[i].val;
	  } break;
	  case 17: {			

#line 1876 "hbhtml.ctr"
	    idptr = kv[i].val;
	  } break;
	  case 18: {	/* div */
	    if(kv[i].val) {
	      if(dk3str_is_bool(kv[i].val)) {
	        dodiv = ((dk3str_is_on(kv[i].val)) ? 1 : 0);
	      } else {
	        /* ERROR: Not boolean */
		dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, kv[i].val);
	      }
	    } else {
	      dodiv = 1;
	    }
	  } break;
	  case 19: {	/* caption */
	    caspec = 1;
	    capt = kv[i].val;
	  } break;
	  case 20: {	/* centered */
	    if(kv[i].val) {
	      if(dk3str_is_bool(kv[i].val)) {
	        center = ((dk3str_is_on(kv[i].val)) ? 1 : 0);
	      } else {
	        /* ERROR: Not boolean */
		dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, kv[i].val);
	      }
	    } else {
	      center = 1;
	    }
	  } break;
	  case 21: {	/* svg */
	    svg = kv[i].val;
	  } break;
	  case 22: {	/* svgwh */
	    if(kv[i].val) {
	      if(dk3str_is_bool(kv[i].val)) {
	        svgwh = ((dk3str_is_on(kv[i].val)) ? 1 : 0);
	      } else {
	        /* ERROR: Not boolean */
		dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, kv[i].val);
	      }
	    } else {
	      svgwh = 1;
	    }
	  } break;
	  case 23: {	/* downloads */
	    if(kv[i].val) {
	      if(dk3str_is_bool(kv[i].val)) {
	        downlo = ((dk3str_is_on(kv[i].val)) ? 1 : 0);
	      } else {
	        /* ERROR: Not boolean */
		dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, kv[i].val);
	      }
	    } else {
	      downlo = 1;
	    }
	  } break;
	  case 24: {
	    if(kv[i].val) {
	      if(dk3str_is_bool(kv[i].val)) {
	        crobj = ((dk3str_is_on(kv[i].val)) ? 1 : 0);
	      } else {
	        /* ERROR: Not boolean */
		dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, kv[i].val);
	      }
	    } else {
	      crobj = 1;
	    }
	  } break;
	  case 25: {
	    if(kv[i].val) {
	      if(dk3str_is_bool(kv[i].val)) {
	        if(dk3str_is_on(kv[i].val)) {
		  if(1 == dodiv) {
		    /* Warning: Overwriting div by table */
		    dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 66);
		  }
		  dodiv = 2;
		} else {
		  if(1 != dodiv) {
		    dodiv = 0;
		  }
		}
	      } else {
	        dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, kv[i].val);
	      }
	    } else {
	      if(1 == dodiv) {
	        /* Warning: Overwriting div by table */
		dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 66);
	      }
	      dodiv = 2;
	    }
	  } break;
	  case 26: {
	    if(kv[i].val) {
	      if(dk3str_is_bool(kv[i].val)) {
	        novsp = ((dk3str_is_on(kv[i].val)) ? 1 : 0);
	      } else {
	        /* ERROR: Not a boolean */
	        dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, kv[i].val);
	      }
	    } else {
	      novsp = 1;
	    }
	  } break;
	  case 27: {	

#line 1983 "hbhtml.ctr"
	    if(kv[i].val) {
	      if(fnptr) {	

#line 1985 "hbhtml.ctr"
	        /* WARNING: Overwriting file setting! */
		dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 86);
	      }
	      fnptr = kv[i].val;
	    } else {		

#line 1990 "hbhtml.ctr"
	      /* ERROR: No file name specified */
	    }
	  } break;
	}
      }
    }
    if(fnptr) {		

#line 1997 "hbhtml.ctr"
      if(dk3str_len(fnptr) < DK3_SIZEOF(svgnbuf,dkChar)) {
        dk3str_cpy(svgnbuf, fnptr);
	dk3str_cpy(pdfnbuf, fnptr);
	dk3str_cpy(pngnbuf, fnptr);
	src = hbhtml_sc_fn(
	  src, pngnbuf, DK3_SIZEOF(pngnbuf,dkChar), sc,
	  hbhtml_image_filename_suffixes[0], job, &fnerr
	);
	svg = hbhtml_sc_fn(
	  svg, svgnbuf, DK3_SIZEOF(svgnbuf,dkChar), sc,
	  hbhtml_image_filename_suffixes[2], job, &fnerr
	);
	pdf = hbhtml_sc_fn(
	  pdf, pdfnbuf, DK3_SIZEOF(pdfnbuf,dkChar), sc,
	  hbhtml_image_filename_suffixes[1], job, &fnerr
	);
      } else {
        /* ERROR: Name too long */
        dk3app_log_i3(job->app, DK3_LL_ERROR, 65, 66, fnptr);
	fnerr = 1;
      }
    }
    if(src) {
      if(!hbtool_check_filename(job, src)) { src = NULL; }
    }
    if(src) {
      if(0 == fnerr) { back = 1; }
      if(larger) {	

#line 2025 "hbhtml.ctr"
        if(!hbtool_check_filename(job, larger)) { larger = NULL; }
      }
      if(pdf) {		

#line 2028 "hbhtml.ctr"
        if(!hbtool_check_filename(job, pdf)) { pdf = NULL; }
      }
      if(svg) {		

#line 2031 "hbhtml.ctr"
        if(!hbtool_check_filename(job, svg)) { svg = NULL; }
      }
      if(tispec) {
        if(!(title)) { title = alt; }
	if(!(title)) { title = src; }
      }
      if(caspec) {
        if(!(capt)) { capt = title; }
	if(!(capt)) { capt = alt; }
      }
      if(!((width) && (height))) {
        if(hbimgdim_find(job, src, &xw, &xh, cache)) {
	  if((xw) && (xh)) {
#if VERSION_BEFORE_20140716
	    dk3sf_sprintf3(wbuf, dkT("%lu"), xw);
	    dk3sf_sprintf3(hbuf, dkT("%lu"), xh);
	    if(!(width)) { width = wbuf; }
	    if(!(height)) { height = hbuf; }
#else
	    if(!(width)) {
	      if (dk3ma_um_to_string(wbuf,DK3_SIZEOF(wbuf,dkChar),(dk3_um_t)xw))
	      {
	        width = wbuf;
	      }
	    }
	    if(!(height)) {
	      if (dk3ma_um_to_string(hbuf,DK3_SIZEOF(hbuf,dkChar),(dk3_um_t)xh))
	      {
	        height = hbuf;
	      }
	    }
#endif
	  }
	}
      }
      if(capt) { if(!(dodiv)) { dodiv = 2;  } }
      if(downlo) { if(!(dodiv)) { dodiv = 2; } }

      /*	Output creation starts here.
      */
      if(dodiv) {
        if(2 == dodiv) {
	  /* div		Open outer div */
	  fputs(hbhtml_c8_kw[((novsp) ? (145) : (109))], job->of);
	  /* table */
	  fputs(hbhtml_c8_kw[138], job->of);
	  hbhtml_output_for_text(job, (job->msg)[65]);
	  fputs(hbhtml_c8_kw[143], job->of);
	  /* tr */
	  fputs(hbhtml_c8_kw[139], job->of);
	  /* td */
	  fputs(hbhtml_c8_kw[140], job->of);
	} else {
          /* div		Open outer div */
	  fputs(hbhtml_c8_kw[109], job->of);
	  /* div		Open image div */
	  fputs(hbhtml_c8_kw[(center) ? 111 : 110], job->of);
	}
      }

      /*	SVG object start.
      */
      if((svg) && (crobj)) {
        /* Opening object tag */
	fputs(hbhtml_c8_kw[114], job->of);
	if(!hbhtml_url_output_for_text(job, svg)) { back = 0; }
	if((svgwh) && (width) && (height)) {
	  fputs(hbhtml_c8_kw[71], job->of);
	  if(!hbhtml_url_output_for_text(job, width)) { back = 0; }
	  fputs(hbhtml_c8_kw[72], job->of);
	  if(!hbhtml_url_output_for_text(job, height)) { back = 0; }
	}
	fputs(hbhtml_c8_kw[51], job->of);
	fputs(hbhtml_c8_kw[0], job->of);
	/* Object param */
	fputs(hbhtml_c8_kw[115], job->of);
	if(!hbhtml_url_output_for_text(job, svg)) { back = 0; }
	fputs(hbhtml_c8_kw[51], job->of);
	fputs(hbhtml_c8_kw[0], job->of);
      }

      /* Image
      */
      fputs(hbhtml_c8_kw[2], job->of);
      fputs(hbhtml_c8_kw[4], job->of);
      if(!hbhtml_url_output_for_text(job, src)) {
        back = 0;
      }
      fputs(hbhtml_c8_kw[5], job->of);
      if(name) {
        fputs(hbhtml_c8_kw[58], job->of);
	if(!hbhtml_output_for_text(job, name)) {
	  back = 0;
	}
	fputs(hbhtml_c8_kw[5], job->of);
      }
      fputs(hbhtml_c8_kw[6], job->of);
      if(alt) {
        if(!hbhtml_output_for_text(job, alt)) {
	  back = 0;
	}
      }
      fputs(hbhtml_c8_kw[5], job->of);
      if(title) {
        fputs(hbhtml_c8_kw[7], job->of);
	if(!hbhtml_output_for_text(job, title)) {
	  back = 0;
	}
	fputs(hbhtml_c8_kw[5], job->of);
      }
      if(longdesc) {
        fputs(hbhtml_c8_kw[59], job->of);
	if(!hbhtml_url_output_for_text(job, longdesc)) {
	  back = 0;
	}
	fputs(hbhtml_c8_kw[5], job->of);
      }
      if((width) && (height)) {
        fputs(hbhtml_c8_kw[9], job->of);
	if(!hbhtml_url_output_for_text(job, width)) {
	  back = 0;
	}
	fputs(hbhtml_c8_kw[5], job->of);
	fputs(hbhtml_c8_kw[10], job->of);
	if(!hbhtml_url_output_for_text(job, height)) {
	  back = 0;
	}
	fputs(hbhtml_c8_kw[5], job->of);
      }
      fputs(hbhtml_c8_kw[8], job->of);
      if(border) {
	if(!hbhtml_url_output_for_text(job, border)) {
	  back = 0;
	}
      } else {
        fputs(hbhtml_c8_kw[57], job->of);
      }
      fputs(hbhtml_c8_kw[5], job->of);
      if(clptr) {
        fputs(hbhtml_c8_kw[60], job->of);
	if(!hbhtml_url_output_for_text(job, clptr)) {
	  back = 0;
	}
	fputs(hbhtml_c8_kw[5], job->of);
      }
      if(idptr) {
        fputs(hbhtml_c8_kw[61], job->of);
	if(!hbhtml_url_output_for_text(job, idptr)) {
	  back = 0;
	}
	fputs(hbhtml_c8_kw[5], job->of);
      }
      if(usemap) {
        fputs(hbhtml_c8_kw[62], job->of);
	if(!hbhtml_url_output_for_text(job, usemap)) {
	  back = 0;
	}
	fputs(hbhtml_c8_kw[5], job->of);
      }
      if(align) {
        fputs(hbhtml_c8_kw[63], job->of);
	if(!hbhtml_url_output_for_text(job, align)) {
	  back = 0;
	}
	fputs(hbhtml_c8_kw[5], job->of);
      }
      if(hspace) {
        fputs(hbhtml_c8_kw[64], job->of);
	if(!hbhtml_url_output_for_text(job, hspace)) {
	  back = 0;
	}
	fputs(hbhtml_c8_kw[5], job->of);
      }
      if(vspace) {
        fputs(hbhtml_c8_kw[65], job->of);
	if(!hbhtml_url_output_for_text(job, vspace)) {
	  back = 0;
	}
	fputs(hbhtml_c8_kw[5], job->of);
      }
      if(ismap) {
        fputs(hbhtml_c8_kw[66], job->of);
      }
      fputs(hbhtml_c8_kw[3], job->of);
      fputs(hbhtml_c8_kw[0], job->of);

      /* SVG object end.
      */
      if((svg) && (crobj)) {
        /* Closing object tag */
	fputs(hbhtml_c8_kw[73], job->of);
	fputs(hbhtml_c8_kw[0], job->of);
      }

      /* Table or div end
      */
      if(dodiv) {
        if(capt) {
	  /* Print caption
	  */
	  fputs(hbhtml_c8_kw[116], job->of);
	  if(!hbhtml_output_for_text(job, capt)) { back = 0; }
	  fputs(hbhtml_c8_kw[117], job->of);
	  /* fputs(hbhtml_c8_kw[0], job->of); */
	}
	if(2 == dodiv) {
	  /* !td 		Close image td */
	  fputs(hbhtml_c8_kw[97], job->of);
	} else {
	  /* !div		Close inner div */
	  fputs(hbhtml_c8_kw[47], job->of);
	}
	if(downlo) {
	  if(2 == dodiv) {
	    /* td space !td 	Space div */
	    fputs(hbhtml_c8_kw[141], job->of);
	    /* td		Open download td */
	    fputs(hbhtml_c8_kw[142], job->of);
	  } else {
	    /* p		Open download p */
	    fputs(hbhtml_c8_kw[112], job->of);
	  }
	  /* Write download links */
	  {
	    haveli = 0;
	    if(svg) {		

#line 2257 "hbhtml.ctr"
	      haveli = 1;
	      fputs(hbhtml_c8_kw[68], job->of);
	      if(!hbhtml_url_output_for_text(job, svg)) { back = 0; }
	      fputs(hbhtml_c8_kw[69], job->of);
	      fputs(hbhtml_c8_kw[118], job->of);
	      fputs(hbhtml_c8_kw[40], job->of);
	      if(!hbhtml_output_for_text(job, (job->kwnl)[33])) { back = 0; }
	      fputs(hbhtml_c8_kw[41], job->of);
	    }
	    if(pdf) {		

#line 2267 "hbhtml.ctr"
	      if(haveli) {
	          fputs(hbhtml_c8_kw[105], job->of);
	      }
	      haveli = 1;
	      fputs(hbhtml_c8_kw[68], job->of);
	      if(!hbhtml_url_output_for_text(job, pdf)) { back = 0; }
	      fputs(hbhtml_c8_kw[69], job->of);
	      fputs(hbhtml_c8_kw[119], job->of);
	      fputs(hbhtml_c8_kw[40], job->of);
	      if(!hbhtml_output_for_text(job, (job->kwnl)[34])) { back = 0; }
	      fputs(hbhtml_c8_kw[41], job->of);
	    }
	    if(larger) {	

#line 2280 "hbhtml.ctr"
	      if(haveli) {
	        fputs(hbhtml_c8_kw[105], job->of);
	      }
	      haveli = 1;
	      fputs(hbhtml_c8_kw[68], job->of);
	      if(!hbhtml_url_output_for_text(job, larger)) { back = 0; }
	      fputs(hbhtml_c8_kw[69], job->of);
	      fputs(hbhtml_c8_kw[40], job->of);
	      if(!hbhtml_output_for_text(job, (job->msg)[58])) { back = 0; }
	      fputs(hbhtml_c8_kw[41], job->of);
	    }
	    if(haveli) {
	      fputs(hbhtml_c8_kw[105], job->of);
	    }
	    fputs(hbhtml_c8_kw[68], job->of);
	    if(!hbhtml_url_output_for_text(job, src)) { back = 0; }
	    fputs(hbhtml_c8_kw[69], job->of);
	    fputs(hbhtml_c8_kw[40], job->of);
	    if(!hbhtml_output_for_text(job, (job->msg)[59])) { back = 0; }
	    fputs(hbhtml_c8_kw[41], job->of);
	  }
	  if(2 == dodiv) {
	    /* !td		Close download td */
	    fputs(hbhtml_c8_kw[97], job->of);
	  } else {
	    /* !p		Close download p */
	    fputs(hbhtml_c8_kw[113], job->of);
	  }
	} else {
	  if(2 == dodiv) {
	  } else {
	    fputs(hbhtml_c8_kw[120], job->of);
	  }
	}
	if(2 == dodiv) {
	  /* !tr */
	  fputs(hbhtml_c8_kw[95], job->of);
	  /* !table */
	  fputs(hbhtml_c8_kw[93], job->of);
	  /* !div		Close outer div */
	  fputs(hbhtml_c8_kw[47], job->of);
	} else {
	  /* !div		Close outer div */
	  fputs(hbhtml_c8_kw[47], job->of);
	}
#if 0
        if(2 == dodiv) {
	} else {
	  /* Close image div
	  */
	  fputs(hbhtml_c8_kw[47], job->of);
	  if(downlo) {
	    /* Open outer download div */
	    fputs(hbhtml_c8_kw[112], job->of);
	    /* Download links */
	    {
	      haveli = 0;
	      if(svg) {		

#line 2338 "hbhtml.ctr"
	        haveli = 1;
	        fputs(hbhtml_c8_kw[68], job->of);
	        if(!hbhtml_url_output_for_text(job, svg)) { back = 0; }
	        fputs(hbhtml_c8_kw[69], job->of);
	        fputs(hbhtml_c8_kw[118], job->of);
	        fputs(hbhtml_c8_kw[40], job->of);
	        if(!hbhtml_output_for_text(job, (job->kwnl)[33])) { back = 0; }
	        fputs(hbhtml_c8_kw[41], job->of);
	      }
	      if(pdf) {		

#line 2348 "hbhtml.ctr"
	        if(haveli) {
	          fputs(hbhtml_c8_kw[105], job->of);
	        }
	        haveli = 1;
	        fputs(hbhtml_c8_kw[68], job->of);
	        if(!hbhtml_url_output_for_text(job, pdf)) { back = 0; }
	        fputs(hbhtml_c8_kw[69], job->of);
	        fputs(hbhtml_c8_kw[119], job->of);
	        fputs(hbhtml_c8_kw[40], job->of);
	        if(!hbhtml_output_for_text(job, (job->kwnl)[34])) { back = 0; }
	        fputs(hbhtml_c8_kw[41], job->of);
	      }
	      if(larger) {	

#line 2361 "hbhtml.ctr"
	        if(haveli) {
	          fputs(hbhtml_c8_kw[105], job->of);
	        }
	        haveli = 1;
	        fputs(hbhtml_c8_kw[68], job->of);
	        if(!hbhtml_url_output_for_text(job, larger)) { back = 0; }
	        fputs(hbhtml_c8_kw[69], job->of);
	        fputs(hbhtml_c8_kw[40], job->of);
	        if(!hbhtml_output_for_text(job, (job->msg)[58])) { back = 0; }
	        fputs(hbhtml_c8_kw[41], job->of);
	      }
	      if(haveli) {
	        fputs(hbhtml_c8_kw[105], job->of);
	      }
	      fputs(hbhtml_c8_kw[68], job->of);
	      if(!hbhtml_url_output_for_text(job, src)) { back = 0; }
	      fputs(hbhtml_c8_kw[69], job->of);
	      fputs(hbhtml_c8_kw[40], job->of);
	      if(!hbhtml_output_for_text(job, (job->msg)[59])) { back = 0; }
	      fputs(hbhtml_c8_kw[41], job->of);
	    }
	    /* Close output download div */
	    fputs(hbhtml_c8_kw[113], job->of);
	  } else {
	    fputs(hbhtml_c8_kw[120], job->of);
	  }
          /* Close outer div
	  */
	  fputs(hbhtml_c8_kw[47], job->of);
	}
#endif
      }

      /*	Output creation is finished here.
      		Now we add the files to copy to the list.
      */
      if(src)		{ if(!hbtool_add_url(job, src)) { back = 0; } }
      if(larger)	{ if(!hbtool_add_url(job, larger)) { back = 0; } }
      if(pdf)		{ if(!hbtool_add_url(job, pdf)) { back = 0; } }
      if(svg)		{ if(!hbtool_add_url(job, svg)) { back = 0; } }
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 40);
  } 

#line 2405 "hbhtml.ctr"
  return back;
}



/**	Write current node item to navigation menu.
	@param	job	Job structure.
	@param	nptr	Current node.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_link_to_current_node(hb_job_t *job, hb_node_t *nptr)
{
  dkChar	*p;		/* Text to show */
  int		 back	= 1;
  

#line 2422 "hbhtml.ctr"
  p = nptr->shorttitle;
  if(!(p)) { p = nptr->title; }
  if(p) {
    fputs(hbhtml_c8_kw[34], job->of);
    if(nptr->title) {
      fputs(hbhtml_c8_kw[7], job->of);
      if(hbtool_write_header_number(job, nptr)) {
        fputs(hbhtml_c8_kw[1], job->of);
      }
      if(!hbhtml_output_for_text(job, nptr->title)) { back = 0; }
      fputs(hbhtml_c8_kw[5], job->of);
    }
    fputs(hbhtml_c8_kw[3], job->of);
    back = hbhtml_output_for_text(job, p);
    fputs(hbhtml_c8_kw[35], job->of);
  } else {
    back = 0;						

#line 2439 "hbhtml.ctr"
  } 

#line 2440 "hbhtml.ctr"
  return back;
}



/**	Write opening link tag to HTML output.
	@param	job	Job structure.
	@param	cl	Class name.
	@param	ti	Title.
	@param	dp	Destination.
	@param	tp	Type (optional).
	@param	nptr	Current node.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_write_link_start(
  hb_job_t	*job,
  char const	*cl,
  dkChar const	*ti,
  dkChar const	*dp,
  dkChar const	*tp,
  hb_node_t	*nptr
)
{
  int		 back = 0;
  

#line 2467 "hbhtml.ctr"
  if(dp) {
    back = 1;
    fputs(hbhtml_c8_kw[39], job->of);
    if(!(hbhtml_url_output_for_text(job, dp))) {
      back = 0;					

#line 2472 "hbhtml.ctr"
    }
    fputs(hbhtml_c8_kw[42], job->of);
    if(cl) {
      fputs(hbhtml_c8_kw[43], job->of);
      if(EOF == fputs(cl, job->of)) { back = 0; }
      fputs(hbhtml_c8_kw[42], job->of);
    }
    if(ti) {
      fputs(hbhtml_c8_kw[44], job->of);
      if(hbtool_write_header_number(job, nptr)) {
        fputs(hbhtml_c8_kw[1], job->of);
      }
      if(!(hbhtml_output_for_text(job, ti))) {
        back = 0;				

#line 2486 "hbhtml.ctr"
      }
      fputs(hbhtml_c8_kw[42], job->of);
    }
    if(tp) {
      fputs(hbhtml_c8_kw[45], job->of);
      if(!(hbhtml_output_for_text(job, tp))) {
        back = 0;				

#line 2493 "hbhtml.ctr"
      }
      fputs(hbhtml_c8_kw[42], job->of);
    }
    fputs(hbhtml_c8_kw[40], job->of);
  } 

#line 2498 "hbhtml.ctr"
  return back;
}



/**	Write closing link tag.
	@param	job	Job structure.
*/
static
void
hbhtml_write_link_end(hb_job_t	*job)
{
  fputs(hbhtml_c8_kw[41], job->of);
  

#line 2512 "hbhtml.ctr"
}




/**	Write a link to HTML output.
	@param	job	Job structure.
	@param	cl	Class name.
	@param	ti	Title.
	@param	dp	Destination.
	@param	tp	Type (optional).
	@param	tx	Link text.
	@param	nptr	Current node.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_write_link(
  hb_job_t	*job,
  char const	*cl,
  dkChar const	*ti,
  dkChar const	*dp,
  dkChar const	*tp,
  dkChar const	*tx,
  hb_node_t	*nptr
)
{
  int			 back	= 0;
  

#line 2541 "hbhtml.ctr"
  if((tx) && (dp)) {
    back = 1;
    if(!(hbhtml_write_link_start(job, cl, ti, dp, tp, nptr))) {
      back = 0;				

#line 2545 "hbhtml.ctr"
    }
    if(!(hbhtml_output_for_text(job, tx))) {
      back = 0;				

#line 2548 "hbhtml.ctr"
    }
    hbhtml_write_link_end(job);
  } 

#line 2551 "hbhtml.ctr"
  return back;
}



int
hbhtml_create_output_filename(
  dkChar	*dptr,
  size_t 	 sz,
  hb_job_t	*job,
  hb_node_t	*nptr
)
{
  dkChar const		*sptr;		/* Suffix for output file */
  dkChar		*p1;		/* Suffix position */
  size_t		 nsz;		/* Summary length name + new suffix */
  int			 back = 0;
  

#line 2569 "hbhtml.ctr"
  if (nptr) {
    dptr[0] = dkT('\0');
    if(0UL == nptr->objno) {		

#line 2572 "hbhtml.ctr"
      if(dk3str_len((job->kwnl)[8]) < sz) {
        dk3str_cpy(dptr, (job->kwnl)[8]);
        back = 1;
      } else {
        /* ERROR: Name too long! */
        dk3app_log_i3(job->app, DK3_LL_ERROR, 65, 66, (job->kwnl)[8]);
      }
    } else {				

#line 2580 "hbhtml.ctr"
      if(nptr->filename) {		

#line 2581 "hbhtml.ctr"
        if(dk3str_len(nptr->filename) < sz) {	

#line 2582 "hbhtml.ctr"
          dk3str_cpy(dptr, nptr->filename);
	  p1 = dk3str_get_suffix(dptr);
	  if(p1) {
	    p1++;
	    *p1 = dkT('\0');
	    if(nptr->suffix) {
	      sptr = nptr->suffix;
	    } else {
	      sptr = (job->kwnl)[10]; 
	    }
	    nsz = dk3str_len(dptr) + dk3str_len(sptr);
	    if(nsz < sz) {
	      dk3str_cat(dptr, sptr);
	      back = 1;
	    } else {			

#line 2597 "hbhtml.ctr"
	      /* ERROR: File name too long! */
              dk3app_log_i3(job->app, DK3_LL_ERROR, 65, 66, nptr->filename);
	    }
	  } else {
	    if(nptr->suffix) {
	      sptr = nptr->suffix;
	    } else {
	      sptr = (job->kwnl)[10];
	    }
	    nsz = dk3str_len(dptr)+dk3str_len(sptr)+dk3str_len((job->kwnl)[9]);
	    if(nsz < sz) {
	      dk3str_cat(dptr, (job->kwnl)[9]);
	      dk3str_cat(dptr, sptr);
	      back = 1;
	    } else {			

#line 2612 "hbhtml.ctr"
	      /* File name too long! */
              dk3app_log_i3(job->app, DK3_LL_ERROR, 65, 66, nptr->filename);
	    }
	  }
        } else {				

#line 2617 "hbhtml.ctr"
          /* ERROR: Input file name too long! */
          dk3app_log_i3(job->app, DK3_LL_ERROR, 65, 66, nptr->filename);
        }
      } else {				

#line 2621 "hbhtml.ctr"
        /* ERROR: No source file name! */
        dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 24);
      }
    }
  } else {				

#line 2626 "hbhtml.ctr"
  }
  

#line 2628 "hbhtml.ctr"
  return back;
}



/**	Write link to one node to navigation menu.
	@param	job	Job structure.
	@param	nptr	Node to link to.
	@param	bold	Flag: Make link bold.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_link_to_node(hb_job_t *job, hb_node_t *nptr, int bold)
{
  dkChar	 bu[DK3_MAX_PATH];	/* Buffer for destination name */
  hb_node_t	*jnode;			/* Link jump destination */
  dkChar 	*p1;			/* Link title (full) */
  dkChar	*p2;			/* Link title (short or full) */
  int		 back	= 0;
  

#line 2649 "hbhtml.ctr"
  jnode = nptr;
  if(!(nptr->filename)) {
    jnode = nptr->jumpnode;
  }
  p1 = nptr->title;
  p2 = ((nptr->shorttitle) ? (nptr->shorttitle) : (nptr->title));
  if((p1) && (p2)) {
    if(jnode) {
      if(hbhtml_create_output_filename(bu, DK3_SIZEOF(bu,dkChar), job, jnode)) {
        fputs(hbhtml_c8_kw[36], job->of);
        back = hbhtml_write_link(
	  job, hbhtml_c8_kw[(bold) ? 144 : 38], p1, bu, NULL, p2, nptr
	);
        fputs(hbhtml_c8_kw[37], job->of);
      }
    } else {
      /* ERROR: No text node! */
      dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 52, 53, nptr->title);
    }
  } 

#line 2669 "hbhtml.ctr"
  return back;
}



/**	Write the menu entries for a node.
	@param	job	Job structure.
	@param	nptr	Node to write menu entries for.
	@param	sepreq	Flag: Menu separator required.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_menu_entries_for_node(hb_job_t *job, hb_node_t *nptr, int sepreq)
{
  hb_node_t		*subnode;		/* Current node */
  hb_node_t		*jnptr;			/* Jump node for subnode */
  int			 active;		/* Flag: Active node */
  int			 sepdone	= 0;	/* Flag: Separator done */
  int			 bold		= 0;	/* Flag: Make bold */
  int			 back		= 1;
  

#line 2691 "hbhtml.ctr"
  if(nptr) {	

#line 2692 "hbhtml.ctr"
    dk3sto_it_reset(nptr->i_subnodes);
    while(NULL != (subnode = (hb_node_t *)dk3sto_it_next(nptr->i_subnodes))) {
      jnptr = subnode;
      if(!(jnptr->filename)) { jnptr = jnptr->jumpnode; }
      if(sepreq) {
        if(!(sepdone)) {
	  sepdone = 1;
	  fputs(hbhtml_c8_kw[33], job->of);
	}
      } 

#line 2702 "hbhtml.ctr"
      active = 1;
      bold = 0;
#if VERSION_BEFORE_20140109
      if(nptr->curchild) {
        if(((nptr->curchild)->objno) == (subnode->objno)) {
	  active = 0;
	}
      }
#else
      if(job->currentnode) {
        if(jnptr) {
	  if(jnptr->objno == (job->currentnode)->objno) {
	    active = 0;
	  }
	}
      }
      if(nptr->curchild) {
        if(((nptr->curchild)->objno) == (subnode->objno)) {
	  bold = 1;
	}
      }
#endif
      if(active) {
        hbhtml_link_to_node(job, subnode, bold);
      } else {
        hbhtml_link_to_current_node(job, subnode);
      }
    }
  } 

#line 2731 "hbhtml.ctr"
  return back;
}



/**	Check whether a node has sub menu items.
	@param	ptr	Node to check.
	@return	1 if sub items are present, 0 otherwise.
*/
static
int
hbhtml_have_sub_menu_items(hb_node_t *ptr)
{
  int		 back = 0;
  

#line 2746 "hbhtml.ctr"
  dk3sto_it_reset(ptr->i_subnodes);
  while(NULL != dk3sto_it_next(ptr->i_subnodes)) {
    back = 1;
  } 

#line 2750 "hbhtml.ctr"
  return back;
}



/**	Process menu special command.
	@param	job	Job structure.
	@param	pa	Special command arguments.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
static
int
hbhtml_process_sp_menu(hb_job_t *job, dkChar *pa)
{
  dk3_key_value_t	 kv[10];	/* Key value pairs */
  hb_node_t		*mnptr;		/* Menu node pointer */
  size_t		 sz;		/* Size of kv */
  size_t		 i;		/* Traverse kv */
  int			 res;		/* Result from writing link */
  int			 sep	= 0;	/* Flag: Need separator */
  int			 tv	= 0;	/* Test value */
  int			 mnst	= 0;	/* Menu style (full) */
  int			 sub	= 1;	/* Include sub menu of current node */
  int			 back	= 1;
  

#line 2775 "hbhtml.ctr"
  sz = DK3_SIZEOF(kv,dk3_key_value_t);
  if(dk3str_to_key_value(kv, &sz, pa, job->app)) {
    for(i = 0; i < sz; i++) {
      if(kv[i].key) {
        switch(dk3str_array_abbr(hbhtml_menu_keys, kv[i].key, dkT('$'), 0)) {
	  case 0: {
	    if(kv[i].val) {
	      tv = dk3str_array_abbr(hbhtml_menu_styles,kv[i].val,dkT('$'),0);
	      if(0 <= tv) {
	        mnst = tv;
	      } else {
	        /* ERROR: Illegal menu style */
		dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,25,26,kv[i].val);
	      }
	    }
	  } break;
	  case 1: {
	    if(kv[i].val) {
	      sub = ((dk3str_is_on(kv[i].val)) ? 1 : 0);
	    } else {
	      sub = 1;
	    }
	  } break;
	  default: {
	    /* ERROR: Illegal key. */
	    dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,27,26,kv[i].key);
	  } break;
	}
      }
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 40);
  } 

#line 2808 "hbhtml.ctr"
  if(((job->currentnode)->options) & HB_NODE_OPT_IMPRESSUM) {
    /*	When we are writing the menu for the impressum page,
    	we print the top menu only.
    */
    mnst = 3;
    sub = 0;
  }	

#line 2815 "hbhtml.ctr"
  fputs(hbhtml_c8_kw[29], job->of);
  fputs(hbhtml_c8_kw[31], job->of);
  /*	Impressum node first, separator.
  */
  if(job->impressumnode) {		

#line 2820 "hbhtml.ctr"
    if(((job->currentnode)->options) & HB_NODE_OPT_IMPRESSUM) {
      if(!hbhtml_link_to_current_node(job, job->impressumnode)) {
        back = 0;				

#line 2823 "hbhtml.ctr"
      }
    } else {
      if(!hbhtml_link_to_node(job, job->impressumnode, 0)) {
        back = 0;				

#line 2827 "hbhtml.ctr"
      }
    }
    /* Separator */
    fputs(hbhtml_c8_kw[33], job->of);
  } else {
    if(job->impressumlink) {		

#line 2833 "hbhtml.ctr"
      fputs(hbhtml_c8_kw[36], job->of);
      res = hbhtml_write_link(
        job, hbhtml_c8_kw[38], (job->msg)[0], job->impressumlink,
	NULL, (job->msg)[0], NULL
      );
      fputs(hbhtml_c8_kw[37], job->of);
      if(!(res)) {
        back = 0;			

#line 2841 "hbhtml.ctr"
      }
      /* Separator */
      fputs(hbhtml_c8_kw[33], job->of);
    } else {				

#line 2845 "hbhtml.ctr"
    }
  }
  /*	Now real menu(s)
  	0=reverse, 1=full, 2=current, 3=top
  */
  mnptr = job->currentnode;
  if(mnptr) {		

#line 2852 "hbhtml.ctr"
    switch(mnst) {
      case -1: case 0: case 2: {	

#line 2854 "hbhtml.ctr"
        if(sub) {
	  if(hbhtml_have_sub_menu_items(mnptr)) {	

#line 2856 "hbhtml.ctr"
            /* Menu for mnptr without leading space */
	    

#line 2858 "hbhtml.ctr"
	    hbhtml_menu_entries_for_node(job, mnptr, 0);
	    sep = 1;
	  }
        }
	mnptr = mnptr->parent;
	if(mnptr) {
	  /* Menu for mnptr with leading space */
	  

#line 2866 "hbhtml.ctr"
	  hbhtml_menu_entries_for_node(job, mnptr, sep);
          if(2 != mnst) {			

#line 2868 "hbhtml.ctr"
	    do {
	      mnptr = mnptr->parent;
	      if(mnptr) {
	        /* Menu for mnptr with leading space */
		

#line 2873 "hbhtml.ctr"
	        hbhtml_menu_entries_for_node(job, mnptr, 1);
	      }
	    } while(mnptr);
          }
	}
      } break;
      case 1: case 3: {		

#line 2880 "hbhtml.ctr"
        if(((job->currentnode)->options) & HB_NODE_OPT_IMPRESSUM) {
          mnptr = job->rootnode;
	  sub = 0;
        } else {
          while(mnptr->parent) { mnptr = mnptr->parent; }
        }
        /* Menu for mnptr without leading space */
	

#line 2888 "hbhtml.ctr"
        hbhtml_menu_entries_for_node(job, mnptr, 0);
        if(1 == mnst) {		

#line 2890 "hbhtml.ctr"
          do {
	    mnptr = mnptr->curchild;
	    if(mnptr) {
	      if(mnptr->curchild) {
	        /* Menu for mnptr with leading space */
		

#line 2896 "hbhtml.ctr"
	        hbhtml_menu_entries_for_node(job, mnptr, 1);
	      } else {
	        if(sub) {
		  /* Menu entry from current node */
		  

#line 2901 "hbhtml.ctr"
		  hbhtml_menu_entries_for_node(job, mnptr, 1);
		}
	      }
	    }
	  } while(mnptr);
        }
      } break;
    }
  }
  fputs(hbhtml_c8_kw[32], job->of);
  fputs(hbhtml_c8_kw[30], job->of);	

#line 2912 "hbhtml.ctr"
  return back;
}



/**	Write image with link for one navigation icon.
	@param	job		Job structure.
	@param	iconfile	Icon file name.
	@param	dest		Destination URL.
	@param	titlea1		Title part 1 when icon link is active.
	@param	titlea2		Title part 2 when icon link is active.
	@param	titlena		Title when icon is not active.
	@param	act		Flag: Link is active.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_one_navi_icon(
  hb_job_t	*job,
  dkChar const	*iconfile,
  dkChar const	*dest,
  dkChar const	*titlea1,
  dkChar const	*titlea2,
  dkChar const	*titlena,
  int		 act
)
{
  int		 back = 1;
  unsigned long	 w = 0UL;	/* Icon width */
  unsigned long	 h = 0UL;	/* Icon height */
  

#line 2943 "hbhtml.ctr"
  

#line 2944 "hbhtml.ctr"
  

#line 2945 "hbhtml.ctr"
  

#line 2946 "hbhtml.ctr"
  

#line 2947 "hbhtml.ctr"
  

#line 2948 "hbhtml.ctr"
  

#line 2949 "hbhtml.ctr"
  if(act) {			

#line 2950 "hbhtml.ctr"
    fputs(hbhtml_c8_kw[49], job->of);
    if(!(hbhtml_url_output_for_text(job, dest))) {
      back = 0;
    }				

#line 2954 "hbhtml.ctr"
    fputs(hbhtml_c8_kw[50], job->of);
    if(!(hbhtml_output_for_text(job, titlea1))) {
      back = 0;
    }				

#line 2958 "hbhtml.ctr"
    if(titlea2) {
      if(!(hbhtml_output_for_text(job, titlea2))) {
        back = 0;
      }
    }				

#line 2963 "hbhtml.ctr"
    fputs(hbhtml_c8_kw[51], job->of);
    fputs(hbhtml_c8_kw[53], job->of);
    if(!(hbhtml_url_output_for_text(job, iconfile))) {
      back = 0;
    }				

#line 2968 "hbhtml.ctr"
    fputs(hbhtml_c8_kw[54], job->of);
    if(!(hbhtml_output_for_text(job, titlea1))) {
      back = 0;
    }				

#line 2972 "hbhtml.ctr"
    if(titlea2) {
      if(!(hbhtml_output_for_text(job, titlea2))) {
        back = 0;
      }
    }
    fputs(hbhtml_c8_kw[55], job->of);
    if(!(hbhtml_output_for_text(job, titlea1))) {
      back = 0;
    }				

#line 2981 "hbhtml.ctr"
    if(titlea2) {
      if(!(hbhtml_output_for_text(job, titlea2))) {
        back = 0;
      }
    }
    fputs(hbhtml_c8_kw[56], job->of);
    if(hbimgdim_find(job, iconfile, &w, &h, 1)) {
      if((w) && (h)) {
        fprintf(job->of, hbhtml_c8_kw[67], w, h);
      }
    }
    fputs(hbhtml_c8_kw[3], job->of);
    fputs(hbhtml_c8_kw[52], job->of);	

#line 2994 "hbhtml.ctr"
  } else {			

#line 2995 "hbhtml.ctr"
    fputs(hbhtml_c8_kw[53], job->of);
    if(!(hbhtml_url_output_for_text(job, iconfile))) {
      back = 0;
    }					

#line 2999 "hbhtml.ctr"
    fputs(hbhtml_c8_kw[54], job->of);
    if(!(hbhtml_output_for_text(job, titlea1))) {
      back = 0;
    }				

#line 3003 "hbhtml.ctr"
    if(titlea2) {
      if(!(hbhtml_output_for_text(job, titlea2))) {
        back = 0;
      }
    }
    fputs(hbhtml_c8_kw[55], job->of);
    if(!(hbhtml_output_for_text(job, titlena))) {
      back = 0;
    }					

#line 3012 "hbhtml.ctr"
    fputs(hbhtml_c8_kw[56], job->of);
    if(hbimgdim_find(job, iconfile, &w, &h, 1)) {
      if((w) && (h)) {
        fprintf(job->of, hbhtml_c8_kw[67], w, h);
      }
    }
    fputs(hbhtml_c8_kw[3], job->of);
  } 

#line 3020 "hbhtml.ctr"
  return back;
}



/**	Process special command to build navigation div.
	@param	job	Job structure.
	@param	pa	Programm arguments (ignored).
	@param	p	Previous node.
	@param	n	Next node.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_process_sp_navigation(
  hb_job_t	*job,
  dkChar	*pa,
  hb_node_t	*p,
  hb_node_t	*n
)
{
  dk3_key_value_t	 kv[10];		/* Command parameters */
  dkChar		 bu[DK3_MAX_PATH];	/* Construct file name */
  hb_node_t		*nptr;			/* Current node */
  dkChar const		*itop	= NULL;		/* TOC icon name */
  dkChar const		*iprev	= NULL;		/* Previous icon name */
  dkChar const		*inext	= NULL;		/* Next icon name */
  dkChar const		*ikind	= NULL;		/* Index icon name */
  dkChar const		*ta1;			/* Icon image title, node */
  dkChar const		*ta2;			/* Icon image title */
  dkChar const		*tna;			/* Icon image title start */
  size_t		 sz;			/* Number of command params */
  size_t		 szurl;			/* URL length */
  size_t		 i;			/* Traverse command params */
  int			 res;			/* Result create one icon */
  int			 kind	= 0;		/* Flag: Keyword index */
  int			 back = 1;
  

#line 3058 "hbhtml.ctr"
  sz = DK3_SIZEOF(kv,dk3_key_value_t);
  if(dk3str_to_key_value(kv, &sz, pa, job->app)) {
    for(i = 0; i < sz; i++) {
      if(kv[i].key) {
        switch(dk3str_array_abbr(hbhtml_navi_keys, kv[i].key, dkT('$'), 0)) {
	  case 0: {
	    itop = kv[i].val;
	  } break;
	  case 1: {
	    iprev = kv[i].val;
	  } break;
	  case 2: {
	    inext = kv[i].val;
	  } break;
	  case 3: {
	    ikind = kv[i].val;
	  } break;
	}
      }
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 40);
  }
  nptr = job->currentnode;
  kind = (((job->options) & HB_JOB_OPT_CREATE_INDEX) ? 1 : 0);
  while((nptr) && (!((itop) && (iprev) && (inext) && ((ikind) || (!(kind)))))) {
    if(!(itop)) itop = nptr->icontoc;
    if(!(iprev)) iprev = nptr->iconprev;
    if(!(inext)) inext = nptr->iconnext;
    if(!(ikind)) ikind = nptr->iconindex;
    nptr = nptr->parent;
  }
  

#line 3091 "hbhtml.ctr"
  if(!(itop))  itop  = (job->kwnl)[14];
  if(!(iprev)) iprev = (job->kwnl)[15];
  if(!(inext)) inext = (job->kwnl)[16];
  if(!(ikind)) ikind = (job->kwnl)[17];
  

#line 3096 "hbhtml.ctr"
  if((itop) && (iprev) && (inext) && ((ikind) || (!(kind)))) {
    back = 1;
    if(itop) { if(!hbtool_add_file(job, itop)) { back = 0; } }
    if(iprev) { if(!hbtool_add_file(job, iprev)) { back = 0; } }
    if(inext) { if(!hbtool_add_file(job, inext)) { back = 0; } }
    if(ikind) { if(!hbtool_add_file(job, ikind)) { back = 0; } }
    fputs(hbhtml_c8_kw[46], job->of);
    /* TOC */		

#line 3104 "hbhtml.ctr"
    ta1 = (job->msg)[1];
    ta2 = (job->rootnode)->title;
    tna = (job->msg)[2];
    res = hbhtml_create_output_filename(
      bu, DK3_SIZEOF(bu,dkChar), job, job->rootnode
    );
    if(res) {	

#line 3111 "hbhtml.ctr"
      if((job->options) & HB_JOB_OPT_CREATE_TOC) {
        szurl = dk3str_len(bu);
	szurl += dk3str_len((job->kwnl)[31]);
	if(szurl < DK3_SIZEOF(bu,dkChar)) {
	  dk3str_cat(bu, (job->kwnl)[31]);
	}
      }
      

#line 3119 "hbhtml.ctr"
      res = hbhtml_one_navi_icon(
        job,itop,bu,ta1,ta2,tna,((0UL == (job->currentnode)->objno) ? 0 : 1)
      );
      if(!(res)) { back = 0; }
      

#line 3124 "hbhtml.ctr"
    } else {	

#line 3125 "hbhtml.ctr"
      back = 0;
    }
    /* Previous */	

#line 3128 "hbhtml.ctr"
    ta1 = (job->msg)[3];
    ta2 = NULL;
    if(p) ta2 = p->title;
    tna = (job->msg)[4];
    if(p) {
      res = hbhtml_create_output_filename(
        bu, DK3_SIZEOF(bu,dkChar), job, p
      );
      if(res) {
        fputs(hbhtml_c8_kw[48], job->of);
	res = hbhtml_one_navi_icon(job, iprev, bu, ta1, ta2, tna, 1);
	if(!(res)) { back = 0; }
      } else {
        back = 0;
      }
    } else {
      fputs(hbhtml_c8_kw[48], job->of);
      res = hbhtml_one_navi_icon(job, iprev, NULL, ta1, ta2, tna, 0);
      if(!(res)) { back = 0; }
    }
    /* Next */		

#line 3149 "hbhtml.ctr"
    ta1 = (job->msg)[5];
    ta2 = NULL;
    if(n) ta2 = n->title;
    tna = (job->msg)[6];
    if(n) {
      res = hbhtml_create_output_filename(
        bu, DK3_SIZEOF(bu,dkChar), job, n
      );
      if(res) {
        fputs(hbhtml_c8_kw[48], job->of);
	res = hbhtml_one_navi_icon(job, inext, bu, ta1, ta2, tna, 1);
	if(!(res)) { back = 0; }
      } else {
        back = 0;
      }
    } else {
      fputs(hbhtml_c8_kw[48], job->of);
      res = hbhtml_one_navi_icon(job, inext, NULL, ta1, ta2, tna, 0);
      if(!(res)) { back = 0; }
    }
    /* Key index */
    if(kind) {			

#line 3171 "hbhtml.ctr"
      ta1 = (job->msg)[7];
      ta2 = NULL;
      tna = NULL;
      res = hbhtml_create_output_filename(
        bu, DK3_SIZEOF(bu,dkChar), job, job->rootnode
      );
      if(res) {
        if(dk3str_len(bu)+dk3str_len((job->kwnl)[13]) < DK3_SIZEOF(bu,dkChar)) {
	  dk3str_cat(bu, (job->kwnl)[13]);
	  fputs(hbhtml_c8_kw[48], job->of);
          res = hbhtml_one_navi_icon(job, ikind, bu, ta1, ta2, tna, 1);
          if(!(res)) { back = 0; }
	} else {
	  back = 0;
	}
      } else {
        back = 0;
      }
    }
    fputs(hbhtml_c8_kw[47], job->of);
    

#line 3192 "hbhtml.ctr"
  } else {			

#line 3193 "hbhtml.ctr"
    

#line 3194 "hbhtml.ctr"
    

#line 3195 "hbhtml.ctr"
    

#line 3196 "hbhtml.ctr"
    

#line 3197 "hbhtml.ctr"
  }
  

#line 3199 "hbhtml.ctr"
  return back;
}



/**	Process author special command.
	@param	job	Job structure.
	@param	pa	Program arguments.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
static
int
hbhtml_process_sp_author(hb_job_t *job, dkChar *pa)
{
  dkChar const		*ptr;		/* Author name */
  int			 back = 0;
  

#line 3216 "hbhtml.ctr"
  ptr = hbconf_author(job->currentnode);
  if(ptr) {
    if(hbhtml_output_for_text(job, ptr)) {
      back = 1;
    }
  } 

#line 3222 "hbhtml.ctr"
  return back;
}



/**	Process location special command.
	@param	job	Job structure.
	@param	pa	Program arguments.
	@return 1 on success, 0 on error (continue), -1 on error (exit).
*/
static
int
hbhtml_process_sp_location(hb_job_t *job, dkChar *pa)
{
  dkChar const		*ptr;		/* Location name */
  int			 back = 0;
  

#line 3239 "hbhtml.ctr"
  ptr = hbconf_location(job->currentnode);
  if(ptr) {
    if(hbhtml_output_for_text(job, ptr)) {
      back = 1;
    }
  } 

#line 3245 "hbhtml.ctr"
  return back;
}



/**	Process date special command.
	@param  job	Job structure.
	@param  pa	Program arguments.
	@return 1 on success, 0 on error (continue), -1 on error (exit).
*/
static
int
hbhtml_process_sp_date(hb_job_t *job, dkChar *pa)
{
  dk3_key_value_t	 kv[5];		/* Command parameters */
  size_t		 sz;		/* Number of command paramters */
  size_t		 i;		/* Traverse command paramters */
  int			 german = 0;	/* Flag: German style date */
  int			 back = 1;
  

#line 3265 "hbhtml.ctr"
  sz = DK3_SIZEOF(kv,dk3_key_value_t);
  if(dk3str_to_key_value(kv,&sz,pa,job->app)) {	

#line 3267 "hbhtml.ctr"
    for(i = 0; i < sz; i++) {	

#line 3268 "hbhtml.ctr"
      if(kv[i].key) {	

#line 3269 "hbhtml.ctr"
        switch(dk3str_array_abbr(hbhtml_date_keys, kv[i].key, dkT('$'), 0)) {
	  case 0: {
	    if(kv[i].val) {
	      if(0 == dk3str_casecmp((job->kwnl)[11], kv[i].val)) {
	        german = 1;	

#line 3274 "hbhtml.ctr"
	      } else {
	        german = 0;	

#line 3276 "hbhtml.ctr"
	      }
	    }
	  } break;
	  default: {
	    /* ERROR: Illegal attribute! */
	    dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,27,26,kv[i].key);
	    back = 0;		

#line 3283 "hbhtml.ctr"
	  } break;
	}
      }
    }
  } else {		

#line 3288 "hbhtml.ctr"
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 40);
  }
  if(german) {
    fprintf(
      job->of, "%02d.%02d.%04d",
      (job->starttime).D, (job->starttime).M, (job->starttime).Y
    );
  } else {
    fprintf(
      job->of, "%04d-%02d-%02d",
      (job->starttime).Y, (job->starttime).M, (job->starttime).D
    );
  } 

#line 3301 "hbhtml.ctr"
  return back;
}



/**	Process special command to show variable.
	@param	job	Job structure.
	@param	pa	Pointer to arguments.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_process_sp_variable(hb_job_t *job, dkChar *pa)
{
  dk3_key_value_t	 kv[5];		/* Argument pairs */
  dkChar const		*varname;	/* Variable name. */
  dkChar const		*varval;	/* Variable value */
  size_t		 sz;		/* Size of kv */
  size_t		 i;		/* Traverse kv */
  int			 urlm	= 0;	/* Flag: URL mode */
  int			 back	= 1;
  

#line 3323 "hbhtml.ctr"
  sz = DK3_SIZEOF(kv,dk3_key_value_t);
  if(dk3str_to_key_value(kv,&sz,pa,job->app)) {
    if(sz > 0) {
      varname = kv[0].key;
      for(i = 1; i < sz; i++) {
        if(kv[i].key) {
	  if(dk3str_casecmp((job->kwnl)[12], kv[i].key) == 0) {
	    if(kv[i].val) {
	      urlm = ((dk3str_is_on(kv[i].val)) ? 1 : 0);
	    } else {
	      urlm = 1;
	    }
	  } else {
	    back = 0;			

#line 3337 "hbhtml.ctr"
	    /* ERROR: Illegal argument */
	    dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,27,26,kv[i].key);
	  }
	}
      }
      varval = hbnode_variable(job->currentnode, varname);
      if(varval) {
        if(urlm) {
	  if(!hbhtml_url_output_for_text(job, varval)) {
	    back = 0;			

#line 3347 "hbhtml.ctr"
	  }
	} else {
	  if(!hbhtml_output_for_text(job, varval)) {
	    back = 0;			

#line 3351 "hbhtml.ctr"
	  }
	}
      }
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 40);
  } 

#line 3358 "hbhtml.ctr"
  return back;
}



/**	Process contents of one file.
	@param	job	Job structure.
	@param	p	Previous node.
	@param	n	Next node.
	@return	1 on success, 0 on error (can continue), -1 on error (exit).
*/
static
int
hbhtml_process_sp_contents(hb_job_t *job, hb_node_t *p, hb_node_t *n)
{
  int			 back = 1;
  job->spused = 0;
  job->shipused = 0;
  

#line 3377 "hbhtml.ctr"
  if(job->currentnode) {		

#line 3378 "hbhtml.ctr"
    if((job->currentnode)->filename) {	

#line 3379 "hbhtml.ctr"
      back = hbcont_process(job, p, n);
    } else {				

#line 3381 "hbhtml.ctr"
      if(0UL == (job->currentnode)->objno) {	

#line 3382 "hbhtml.ctr"
        back = hbcont_process(job, p, n);
      } else {					

#line 3384 "hbhtml.ctr"
      }
    }
  } 

#line 3387 "hbhtml.ctr"
  return back;
}



/**	Open code tag for line number.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_coli_open(hb_job_t *job)
{
  int		back = 1;
  if (EOF == fputs(hbhtml_c8_kw[146], job->of)) { back = 0; }
  if (1000 > job->coli) {
    if (0 > fprintf(job->of, "%03d", job->coli)) { back = 0; }
    job->coli += 1;
    if (1000 == job->coli) {
      back = 0;
      /* WARNING: Too many code lines */
      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 88);
    }
  } else {
    back = 0;
    fputs(hbhtml_c8_kw[149], job->of);
  }
  if (EOF == fputs(hbhtml_c8_kw[147], job->of)) { back = 0; }
  return back;
}



/**	Close code tag for line number.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_coli_close(hb_job_t *job)
{
  int		 back = 1;
  if (EOF == fputs(hbhtml_c8_kw[148], job->of)) { back = 0; }
  return back;
}



/**	Output dummy code line to avoid trimming emptry code tag.
	@param	job	Job structure.
	@return	1 on success, 0 on error
*/
static
int
hbhtml_coli_dummy(hb_job_t *job)
{
  int		 back = 1;
  if (!hbhtml_coli_open(job)) { back = 0; }
  if (EOF == fputs(hbhtml_c8_kw[150], job->of)) { back = 0; }
  if (!hbhtml_coli_close(job)) { back = 0; }
  return back;
}



/**	Start of a code line found.
	Invoked from the input line handler.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_code_line_start(hb_job_t *job)
{
  int		 back = 1;
  if (((job->options) & HB_JOB_OPT_CODE) && (0 < job->coli)) {
    switch (job->cols) {
      case HB_COLIST_NONE: {
        if (!hbhtml_coli_open(job)) { back = 0; }
        job->cols = HB_COLIST_OPENED;
      } break;
      case HB_COLIST_NOT_OPENED: {
        if (!hbhtml_coli_open(job)) { back = 0; }
        job->cols = HB_COLIST_OPENED;
      } break;
#if 0
      case HB_COLIST_OPENED: {
      } break;
#endif
    }
  }
  return back;
}



/**	Finalize a code line.
	Invoked from the input line handler.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_code_line_end(hb_job_t *job)
{
  int		 back = 1;
  if (((job->options) & HB_JOB_OPT_CODE) && (0 < job->coli)) {
    switch (job->cols) {
      case HB_COLIST_NONE: {
        job->cols = HB_COLIST_NOT_OPENED;
      } break;
      case HB_COLIST_NOT_OPENED: {
        if (!hbhtml_coli_dummy(job)) { back = 0; }
      } break;
      case HB_COLIST_OPENED: {
        if (!hbhtml_coli_close(job)) { back = 0; }
        job->cols = HB_COLIST_NOT_OPENED;
      } break;
    }
  }
  return back;
}



/**	Start code line numbering.
	Invoked from the input line handler.
	Invoked from the code special command.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_start_code_line_numbers(hb_job_t *job)
{
  int		 back = 1;
  job->coli = 1;
  job->cols = HB_COLIST_NONE;
  return back;
}



/**	End code line numbering if it was started.
	Invoked from the code special command.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_end_code_line_numbers(hb_job_t *job)
{
  int		 back = 1;
  if (((job->options) & HB_JOB_OPT_CODE) && (0 < job->coli)) {
    switch (job->cols) {
      case HB_COLIST_OPENED: {
        if (EOF == fputs(hbhtml_c8_kw[148], job->of)) { back = 0; }
      } break;
    }
  }
  job->coli = 0;
  job->cols = HB_COLIST_NONE;
  return back;
}



/**	Process the code special command.
	@param	job	Job structure.
	@param	pa	Arguments
*/
static
void
hbhtml_process_sp_code(hb_job_t *job, dkChar *pa)
{
  dk3_key_value_t	kv[10];		/* Command paramters */
  size_t		sz;		/* Number of command parameters */
  size_t		i;		/* Process all command parameters */
  int			act = 0;	/* Action to take */
  int			lineno = 0;	/* Flag: Write line numbers */
  
  

#line 3569 "hbhtml.ctr"

  /*	Get configuration defaults
  */
  if ((job->options) & HB_JOB_OPT_CODE_LINE_NUMBERS) {
    lineno = 1;
  }

  /*	Use command options
  */
  sz = DK3_SIZEOF(kv,dk3_key_value_t);
  if(dk3str_to_key_value(kv,&sz,pa,job->app)) {
    if(sz > 0) {
      for(i = 0; i < sz; i++) {
        if(kv[i].key) {
	  switch(dk3str_array_abbr(hbhtml_code_keys, kv[i].key, dkT('$'), 0)) {
	    case 0: case 1: {
	      if(kv[i].val) {
	        if(dk3str_is_bool(kv[i].val)) {
		  if(dk3str_is_on(kv[i].val)) {
		    act = 1;
		  } else {
		    act = 2;
		  }
		} else {
		  act = 1;
		}
	      } else {
	        act = 1;
	      }
	    } break;
	    case 2: case 3: {
	      if(kv[i].val) {
	        if(dk3str_is_bool(kv[i].val)) {
		  if(dk3str_is_on(kv[i].val)) {
		    act = 2;
		  } else {
		    act = 1;
		  }
		} else {
		  act = 2;
		}
	      } else {
	        act = 2;
	      }
	    } break;
	    case 4: {
	      act = 0;
	    } break;
	    case 5: {
	      if (kv[i].val) {
	        if (dk3str_is_bool(kv[i].val)) {
		  lineno = ((dk3str_is_on(kv[i].val)) ? 1 : 0);
		} else {
		  /* Warning: Not a boolean */
	          dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, kv[i].val);
		}
	      } else {
	        lineno = 1;
	      }
	    } break;
	  }
	}
      }
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 40);
  }

  /*	Finish open code line numbering.
  */
  (void)hbhtml_end_code_line_numbers(job);

  /*	Turn code mode on or off.
  */
  switch(act) {
    case 0: {
      if((job->options) & HB_JOB_OPT_CODE) {
        job->options &= (~(HB_JOB_OPT_CODE));
      } else {
        job->options |= HB_JOB_OPT_CODE;
	if (lineno) {
	  (void)hbhtml_start_code_line_numbers(job);
	}
      }
    } break;
    case 1: {
      job->options |= HB_JOB_OPT_CODE;
      if (lineno) {
        (void)hbhtml_start_code_line_numbers(job);
      }
    } break;
    case 2: {
      job->options &= (~(HB_JOB_OPT_CODE));
    } break;
  } 

#line 3664 "hbhtml.ctr"
}



#if 0
static
int
hbhtml_check_link_for_external(dkChar *link, hb_job_t *job)
{
  size_t	 sz;
  int		 back = 0;
  if(link) {
    sz = dk3str_len(link);
    if(sz >= dk3str_len((job->kwnl)[20])) {
      if(0 == dk3str_ncmp(link, (job->kwnl)[20], dk3str_len((job->kwnl)[20]))) {
        back = 1;
      }
    }
    if(sz >= dk3str_len((job->kwnl)[21])) {
      if(0 == dk3str_ncmp(link, (job->kwnl)[21], dk3str_len((job->kwnl)[21]))) {
        back = 1;
      }
    }
  }
  return back;
}
#endif



int
hbhtml_check_link_for_external(dkChar const *link)
{
  dkChar const		*ptr;		/* Traverse string */
  dkChar		 c;		/* Current character */
  int			 stm3;		/* State machine for traversal */
  int			 i;		/* Input classification */
  int			 back = 0;
  

#line 3703 "hbhtml.ctr"
  hbhtml_stm3_reset(&stm3);
  ptr = link;
  while(*ptr) {
    c = *(ptr++);
    i = STM3_I_ANY;
    switch(c) {
      case dkT(':'): {
        i = STM3_I_COLON;
      } break;
      case dkT('/'): {
        i = STM3_I_SLASH;
      } break;
      case dkT('_'): {
        i = STM3_I_ASCII;
      } break;
      default: {
        if((dkT('a') <= c) && (dkT('z') >= c)) {
	  i = STM3_I_ASCII;
	} else {
	  if((dkT('A') <= c) && (dkT('Z') >= c)) {
	    i = STM3_I_ASCII;
	  } else {
	    if((dkT('0') <= c) && (dkT('9') >= c)) {
	      i = STM3_I_ASCII;
	    }
	  }
	}
      } break;
    }
    hbhtml_stm3_step(&stm3, i);
  }
  if(STM3_ST_SUCCESS == stm3) {
    back = 1;
  } 

#line 3737 "hbhtml.ctr"
  return back;
}



/**	Process special command to build a link.
	@param	job	Job structure.
	@param	pa	Program arguments.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
static
int
hbhtml_process_sp_a(hb_job_t *job, dkChar *pa)
{
  dk3_key_value_t	 kv[25];		/* Command parameters */
  hb_link_t		*linkptr;		/* Link data for URL */
  hb_node_t		*nptr;			/* Current node */
  dkChar		*text	= NULL;		/* Link text */
  dkChar		*title	= NULL;		/* Link title */
  dkChar		*accessk	= NULL;	/* Accesskey argument */
  dkChar		*charset	= NULL;	/* Charset argument */
  dkChar		*coords	= NULL;		/* Coords argument */
  dkChar		*href	= NULL;		/* href argument */
  dkChar		*hrefl	= NULL;		/* hreflang argument */
  dkChar		*name	= NULL;		/* name argument */
  dkChar		*onblur	= NULL;		/* onblur argument */
  dkChar		*onfocus = NULL;	/* onfocus argument */
  dkChar		*rel	= NULL;		/* rel argument */
  dkChar		*rev	= NULL;		/* rev argument */
  dkChar		*shape	= NULL;		/* shape argument */
  dkChar		*tabind	= NULL;		/* tabindex argument */
  dkChar		*target	= NULL;		/* target argument */
  dkChar		*type	= NULL;		/* type argument */
  dkChar		*clptr	= NULL;		/* class argument */
  dkChar		*idptr	= NULL;		/* id argument */
  dkChar		*style	= NULL;		/* style argument */
  size_t		 sz;			/* Number of parameters */
  size_t		 i;			/* Traverse parameters */
  int			 external = 0;		/* Flag: External link */
  int			 extspec = 0;		/* Flag: External specified */
  int			 titlespec = 0;		/* Flag: Title specified */
  int			 back = 0;
  

#line 3780 "hbhtml.ctr"
  nptr = job->currentnode;
  sz = DK3_SIZEOF(kv,dk3_key_value_t);
  if(dk3str_to_key_value(kv,&sz,pa,job->app)) {
    if(sz > 0) {
      for(i = 0; i < sz; i++) {
        if(kv[i].key) {
	  switch(dk3str_array_abbr(hbhtml_a_keys, kv[i].key, dkT('$'), 0)) {
	    case 0: {	

#line 3788 "hbhtml.ctr"
	      text = kv[i].val;
	    } break;
	    case 1: {	

#line 3791 "hbhtml.ctr"
	      title = kv[i].val; titlespec = 1;
	    } break;
	    case 2: {	

#line 3794 "hbhtml.ctr"
	      accessk = kv[i].val;
	    } break;
	    case 3: {	

#line 3797 "hbhtml.ctr"
	      charset = kv[i].val;
	    } break;
	    case 4: {	

#line 3800 "hbhtml.ctr"
	      coords = kv[i].val;
	    } break;
	    case 5: {	

#line 3803 "hbhtml.ctr"
	      href= kv[i].val;
	    } break;
	    case 6: {	

#line 3806 "hbhtml.ctr"
	      hrefl = kv[i].val;
	    } break;
	    case 7: {	

#line 3809 "hbhtml.ctr"
	      name = kv[i].val;
	    } break;
	    case 8: {	

#line 3812 "hbhtml.ctr"
	      onblur = kv[i].val;
	    } break;
	    case 9: {	

#line 3815 "hbhtml.ctr"
	      onfocus = kv[i].val;
	    } break;
	    case 10: {	

#line 3818 "hbhtml.ctr"
	      rel = kv[i].val;
	    } break;
	    case 11: {	

#line 3821 "hbhtml.ctr"
	      rev = kv[i].val;
	    } break;
	    case 12: {	

#line 3824 "hbhtml.ctr"
	      shape = kv[i].val;
	    } break;
	    case 13: {	

#line 3827 "hbhtml.ctr"
	      tabind = kv[i].val;
	    } break;
	    case 14: {	

#line 3830 "hbhtml.ctr"
	      target = kv[i].val;
	    } break;
	    case 15: {	

#line 3833 "hbhtml.ctr"
	      type = kv[i].val;
	    } break;
	    case 16: {	

#line 3836 "hbhtml.ctr"
	      clptr = kv[i].val;
	    } break;
	    case 17: {	

#line 3839 "hbhtml.ctr"
	      idptr = kv[i].val;
	    } break;
	    case 18: {	

#line 3842 "hbhtml.ctr"
	      style = kv[i].val;
	    } break;
	    case 19: {
	      if(kv[i].val) {
	        if(dk3str_is_bool(kv[i].val)) {
		  if(dk3str_is_on(kv[i].val)) {
		    external = 1; extspec = 1;
		  } else {
		    external = 0; extspec = 1;
		  }
		}
	      } else {
	        external = 1; extspec = 1;
	      }
	    } break;
	    default: {
	      dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,27,26,kv[i].key);
	    } break;
	  }
	}
      }
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 40);
  }
  if(href) {
    if(!(extspec)) {
      external = hbhtml_check_link_for_external(href);
    }
    if(titlespec) {
        if(!(title)) { title = text; }
	if(!(title)) { title = href; }
    }
    back = 1;
  } else {
    if(name) {
      back = 1;
    }
  }
  if(back) {
    /* Write <a...> */
    if(href) {
      fputs(hbhtml_c8_kw[39], job->of);
      if(!hbhtml_url_output_for_text(job, href)) { back = 0; }
    } else {
      fputs(hbhtml_c8_kw[74], job->of);
      if(!hbhtml_url_output_for_text(job, name)) { back = 0; }
    }
    if(target) {
      fputs(hbhtml_c8_kw[75], job->of);
      if(!hbhtml_url_output_for_text(job, target)) { back = 0; }
    } else {
      if(external) {
        fputs(hbhtml_c8_kw[108], job->of);
      }
    }
    if(type) {
      fputs(hbhtml_c8_kw[76], job->of);
      if(!hbhtml_url_output_for_text(job, type)) { back = 0; }
    }
    fputs(hbhtml_c8_kw[77], job->of);
    if(clptr) {
      if(!hbhtml_url_output_for_text(job, clptr)) { back = 0; }
    } else {
      if(external) {
        fputs(hbhtml_c8_kw[101], job->of);
      } else {
        fputs(hbhtml_c8_kw[100], job->of);
      }
    }
    if(idptr) {
      fputs(hbhtml_c8_kw[78], job->of);
      if(!hbhtml_url_output_for_text(job, idptr)) { back = 0; }
    }
    if(style) {
      fputs(hbhtml_c8_kw[79], job->of);
      if(!hbhtml_url_output_for_text(job, style)) { back = 0; }
    }
    if(hrefl) {
      fputs(hbhtml_c8_kw[80], job->of);
      if(!hbhtml_url_output_for_text(job, hrefl)) { back = 0; }
    }
    if(title) {
      fputs(hbhtml_c8_kw[81], job->of);
      if(!hbhtml_output_for_text(job, title)) { back = 0; }
    }
    if(onblur) {
      fputs(hbhtml_c8_kw[82], job->of);
      if(!hbhtml_url_output_for_text(job, onblur)) { back = 0; }
    }
    if(onfocus) {
      fputs(hbhtml_c8_kw[83], job->of);
      if(!hbhtml_url_output_for_text(job, onfocus)) { back = 0; }
    }
    if(rel) {
      fputs(hbhtml_c8_kw[84], job->of);
      if(!hbhtml_url_output_for_text(job, rel)) { back = 0; }
    }
    if(rev) {
      fputs(hbhtml_c8_kw[85], job->of);
      if(!hbhtml_url_output_for_text(job, rev)) { back = 0; }
    }
    if(shape) {
      fputs(hbhtml_c8_kw[86], job->of);
      if(!hbhtml_url_output_for_text(job, shape)) { back = 0; }
    }
    if(tabind) {
      fputs(hbhtml_c8_kw[87], job->of);
      if(!hbhtml_url_output_for_text(job, tabind)) { back = 0; }
    }
    if(accessk) {
      fputs(hbhtml_c8_kw[88], job->of);
      if(!hbhtml_url_output_for_text(job, accessk)) { back = 0; }
    }
    if(charset) {
      fputs(hbhtml_c8_kw[89], job->of);
      if(!hbhtml_url_output_for_text(job, charset)) { back = 0; }
    }
    if(coords) {
      fputs(hbhtml_c8_kw[90], job->of);
      if(!hbhtml_url_output_for_text(job, coords)) { back = 0; }
    }
    fputs(hbhtml_c8_kw[5], job->of);
    fputs(hbhtml_c8_kw[3], job->of);
    if(href) {
      if(text) {
        if(!hbhtml_output_for_text(job, text)) { back = 0; }
      } else {
        if(!hbhtml_output_for_text(job, href)) { back = 0; }
      }
    }
    fputs(hbhtml_c8_kw[41], job->of);
    if((href) && (external) && (text)) {
      /* Save link and write link number */
      linkptr = dk3sto_it_find_like(nptr->i_lbyurl, href, 1);
      if(linkptr) {
        fprintf(job->of, hbhtml_c8_kw[91], (1UL + linkptr->lno));
      } else {
        linkptr = hbnode_link_new(href, nptr->nextlink, job->app);
	if(linkptr) {
	  if(dk3sto_add(nptr->s_lbyurl, linkptr)) {
	    nptr->nextlink += 1UL;
	    if(dk3sto_add(nptr->s_lbylno, linkptr)) {
	      fprintf(job->of, hbhtml_c8_kw[91], (1UL + linkptr->lno));
	    } else {
	      back = 0;
	    }
	  } else {
	    back = 0;
	    hbnode_link_delete(linkptr);
	    linkptr = NULL;
	  }
	} else {
	  back = 0;
	}
      }
    }
    if((!(href)) && (name)) {
      if(text) {
        if(!hbhtml_output_for_text(job, text)) { back = 0; }
      }
    }
    if(href) {
      if(!hbtool_add_url(job, href)) { back = 0; }
    }
  } 

#line 4008 "hbhtml.ctr"
  return back;
}



/**	Process menuentry special command.
	@param	job	Job structure.
	@param	pa	Arguments.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
static
int
hbhtml_process_sp_menuentry(hb_job_t *job, dkChar *pa)
{
  dk3_key_value_t	 kv[20];	/* Command parameters */
  dkChar 		*items[DK3_SIZEOF(kv,dk3_key_value_t)];
  size_t		 sz;		/* Number of command parameters */
  size_t		 i;		/* Traverse command parameters */
  size_t		 n_items = 0;	/* number of items */
  size_t		 cr;		/* Current item index */
  int			 back	 = 0;
  

#line 4030 "hbhtml.ctr"
  sz = DK3_SIZEOF(kv,dk3_key_value_t);
  if(dk3str_to_key_value(kv,&sz,pa,job->app)) {
    if(sz > 0) {
      for(i = 0; i < sz; i++) {
        if(kv[i].key) {
	  switch(dk3str_array_abbr(hbhtml_menuentry_keys,kv[i].key,dkT('$'),0))
	  {
	    case 0: {
	      if(kv[i].val) {
	        if(n_items < DK3_SIZEOF(kv,dk3_key_value_t)) {
		  items[n_items++] = kv[i].val;
		} else {
		  dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
		}
	      }
	    } break;
	    default: {
	      dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,27,26,kv[i].key);
	      back = 0;
	    } break;
	  }
	}
      }
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 40);
  }
  if(n_items) {
    back = 1;
    fputs(hbhtml_c8_kw[92], job->of);
    if(!hbhtml_output_for_text(job, (job->msg)[60])) { back = 0; }
    fputs(hbhtml_c8_kw[22], job->of);
    for(cr = 0; cr < n_items; cr++) {
      fputs(hbhtml_c8_kw[94], job->of);
      if(cr) {
        for(i = 0; i < (cr - 1); i++) {
	  fputs(hbhtml_c8_kw[98], job->of);
	}
	fputs(hbhtml_c8_kw[99], job->of);
	fprintf(job->of, hbhtml_c8_kw[96], (unsigned)(n_items - cr));
	if(!hbhtml_output_for_text(job, items[cr])) { back = 0; }
	fputs(hbhtml_c8_kw[97], job->of);
      } else {
        fprintf(job->of, hbhtml_c8_kw[96], (unsigned)n_items);
	if(!hbhtml_output_for_text(job, items[cr])) { back = 0; }
	fputs(hbhtml_c8_kw[97], job->of);
      }
      fputs(hbhtml_c8_kw[95], job->of);
    }
    fputs(hbhtml_c8_kw[93], job->of);
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 42);
  } 

#line 4083 "hbhtml.ctr"
  return back;
}



/**	Process index special command.
	@param	job	Job structure.
	@param	pa	Program arguments.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
static
int
hbhtml_process_sp_index(hb_job_t *job, dkChar *pa)
{
  dk3_key_value_t	 kv[10];	/* Command parameters */
  hb_node_t		*nptr;		/* Current node */
  hb_index_entry_t	*indptr;	/* New index entry item */
  dkChar		*text	= NULL;	/* Text for index entry */
  dkChar		*name	= NULL;	/* Name for index entry */
  size_t		 sz;		/* Number of command paramters */
  size_t		 i;		/* Traverse command parameters */
  int			 refer	= 0;	/* Flag: Refer to existing entry */
  int			 back	= 0;
  

#line 4107 "hbhtml.ctr"
  nptr = job->currentnode;
  sz = DK3_SIZEOF(kv,dk3_key_value_t);
  if(dk3str_to_key_value(kv,&sz,pa,job->app)) {
    if(sz > 0) {
      for(i = 0; i < sz; i++) {
        if(kv[i].key) {
	  switch(dk3str_array_abbr(hbhtml_index_keys, kv[i].key, dkT('$'), 0)) {
	    case 0: {
	      text = kv[i].val;
	    } break;
	    case 1: {
	      name = kv[i].val;
	    } break;
	    case 2: {
	      if(kv[i].val) {
	        if(dk3str_is_bool(kv[i].val)) {
		  if(dk3str_is_on(kv[i].val)) {
		    refer = 1;
		  } else {
		    refer = 0;
		  }
		} else {
		  /* ERROR: Not a boolean */
		  dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, kv[i].val);
		}
	      } else {
	        refer = 1;
	      }
	    } break;
	  }
	}
      }
      if(text) {
        if((job->options) & HB_JOB_OPT_CREATE_INDEX) {
          indptr = hbindex_new(
	    text, nptr->outFileName, name, nptr->nextindex, job->app, nptr
	  );
	  if(indptr) {
	    if(dk3sto_add(job->s_index, indptr)) {
	      back = 1;
	      nptr->nextindex += 1UL;
	      if(!((name) && (refer))) {
	        fputs(hbhtml_c8_kw[74], job->of);
	        if(!hb_index_write_anchor(job, indptr)) { back = 0; }
	        fputs(hbhtml_c8_kw[51], job->of);
	        fputs(hbhtml_c8_kw[52], job->of);
	      }
	    } else {
	      hbindex_delete(indptr);
	    }
	  }
	} else {
	  back = 1;
	}
      } else {
        /* ERROR: Missing text attribute! */
	dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 48);
      }
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 40);
  } 

#line 4169 "hbhtml.ctr"
  return back;
}



/**	Handle one source code line.
	@param	obj	Job structure.
	@param	il	Input line.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
static
int
hbhtml_sourcefile_line_handler(void *obj, dkChar *il)
{
  hb_job_t	*job;
  int		 back = 1;

  job = (hb_job_t *)obj;
  dk3str_delnl(il);
  

#line 4189 "hbhtml.ctr"
  if (job->coli) {
    if (0 < dk3str_len(il)) {
      if (!hbhtml_coli_open(job)) { back = 0; }
      if(!hbhtml_output_for_text(job, il)) { back = 0; }
      if (!hbhtml_coli_close(job)) { back = 0; }
    } else {
      if (!hbhtml_coli_dummy(job)) { back = 0; }
    }
  } else {
    if(!hbhtml_output_for_text(job, il)) { back = 0; }
  }
  fputc('\n', job->of);
  

#line 4202 "hbhtml.ctr"
  return back;
}



/**	Process sourcefile special command.
	@param	job	Job structure.
	@param	pa	Program arguemnts.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
static
int
html_process_sp_sourcefile(hb_job_t *job, dkChar *pa)
{
  dkChar		 bu[4096];	/* Buffer for source file lines */
  dk3_key_value_t	 kv[10];	/* Command parameters */
  dkChar		*file	= NULL;	/* Input file */
  dkChar		*type	= NULL;	/* Type argument */
  dkChar		*title	= NULL;	/* Title argument */
  size_t		 sz;		/* Number of command parameters */
  size_t		 i;		/* Traverse command parameters */
  int			 lineno = 0;	/* Flag: Write line numbers */
  int		 	 back = 0;
  int			 res;		/* Result from processing file */
  int			 oldcode;	/* Old code flag value */
  

#line 4228 "hbhtml.ctr"
  if ((job->options) & HB_JOB_OPT_CODE_LINE_NUMBERS) {
    lineno = 1;
  }
  sz = DK3_SIZEOF(kv,dk3_key_value_t);
  if(dk3str_to_key_value(kv, &sz, pa, job->app)) {
    if(sz > 0) {
      for(i = 0; i < sz; i++) {
        if(kv[i].key) {
	  switch(dk3str_array_abbr(hbhtml_sourcef_keys,kv[i].key,dkT('$'),0)) {
	    case 0: {
	      file = kv[i].val;
	    } break;
	    case 1: {
	      type = kv[i].val;
	    } break;
	    case 2: {
	      title = kv[i].val;
	    } break;
	    case 3: {
	      if (kv[i].val) {
	        if (dk3str_is_bool(kv[i].val)) {
		  lineno = ((dk3str_is_on(kv[i].val)) ? 1 : 0);
		} else {
		  /* WARNING: Not a boolean */
	          dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, kv[i].val);
		}
	      } else {
	        lineno = 1;
	      }
	    } break;
	  }
	}
      }
    }
    if(file) {
      back = 1;
      if(hbtool_add_file(job, file)) {
        fputs(hbhtml_c8_kw[102], job->of);
	fputs(hbhtml_c8_kw[103], job->of);
	if(!hbhtml_url_output_for_text(job, file)) { back = 0; }
	fputs(hbhtml_c8_kw[81], job->of);
	if(title) {
	  if(!hbhtml_output_for_text(job, title)) { back = 0; }
	} else {
	  if(!hbhtml_output_for_text(job, file)) { back = 0; }
	}
	fputs(hbhtml_c8_kw[76], job->of);
	if(type) {
	  if(!hbhtml_output_for_text(job, type)) { back = 0; }
	} else {
	  fputs(hbhtml_c8_kw[104], job->of);
	}
	fputs(hbhtml_c8_kw[51], job->of);
	if(!hbhtml_output_for_text(job, file)) { back = 0; }
	fputs(hbhtml_c8_kw[52], job->of);
	fputs(hbhtml_c8_kw[105], job->of);
	fputs(hbhtml_c8_kw[106], job->of);
	oldcode = (((job->options) & HB_JOB_OPT_CODE) ? 1 : 0);
	job->options |= HB_JOB_OPT_CODE;
	job->coli = ((lineno) ? 1 : 0);
	res = dk3stream_process_filename_lines_app(
	  (void *)job, hbhtml_sourcefile_line_handler, file,
	  bu, DK3_SIZEOF(bu,dkChar),
	  dk3app_get_encoding(job->app),
	  dk3app_get_input_file_encoding(job->app),
	  job->app
	);
	job->coli = 0;
	if(!(res)) { back = 0; }
	if(oldcode) {
	  job->options |= HB_JOB_OPT_CODE;
	} else {
	  job->options &= (~(HB_JOB_OPT_CODE));
	}
	fputs(hbhtml_c8_kw[107], job->of);
	fputs(hbhtml_c8_kw[47], job->of);
      } else {
        back = 0;
      }
    } else {
      /* ERROR: No file name specified! */
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 49);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 40);
  } 

#line 4314 "hbhtml.ctr"
  return back;
}



/**	Process a special command.
	@param	job		Job structure.
	@param	in_template	Flag: Processing a template.
	@param	p		Previous node.
	@param	n		Next node.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
static
int
hbhtml_process_special(
  hb_job_t	*job,
  int		 in_template,
  hb_node_t	*p,
  hb_node_t	*n
)
{
  dkChar		*pc;		/* Special command name */
  dkChar		*pa;		/* Start of command arguments */
  dkChar		*sc;		/* Start of sub command. */
  int			 ct;		/* Command identifier */
  int			 back = 0;
  

#line 4341 "hbhtml.ctr"
  pc = dk3str_start(job->special, NULL);
  sc = NULL;
  if(pc) {
    pa = dk3str_next(pc, NULL);
    if(pa) {
      dk3str_chomp(pa, NULL);
    }
    sc = dk3str_chr(pc, dkT('.'));
    if(sc) { *(sc++) = dkT('\0'); }
    ct = dk3str_array_index(hbhtml_special_commands, pc, 0);
    

#line 4352 "hbhtml.ctr"
    switch(ct) {
      case 0: {		

#line 4354 "hbhtml.ctr"
        if(in_template) {
	  back = hbhtml_process_sp_contents(job, p, n);
	} else {
	  /* ERROR: Contents special not allowed in contents! */
	  dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 28);
	}
      } break;
      case 1: {		

#line 4362 "hbhtml.ctr"
        back = hbhtml_process_sp_title(job);
        if(1 != back) { dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 39); }
      } break;
      case 2: {		

#line 4366 "hbhtml.ctr"
        back = hbhtml_process_sp_image(job, pa, sc, in_template);
        if(1 != back) { dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 39); }
      } break;
      case 3: {		

#line 4370 "hbhtml.ctr"
        back = hbhtml_process_sp_menu(job, pa);
        if(1 != back) { dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 39); }
      } break;
      case 4: {		

#line 4374 "hbhtml.ctr"
        back = hbhtml_process_sp_navigation(job, pa, p, n);
        if(1 != back) { dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 39); }
      } break;
      case 5: {	/* links */
        /* #### Probably not */
	back = 1;
      } break;
      case 6: {		

#line 4382 "hbhtml.ctr"
        back = hbhtml_process_sp_author(job, pa);
        if(1 != back) { dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 39); }
      } break;
      case 7: {		

#line 4386 "hbhtml.ctr"
        back = hbhtml_process_sp_location(job, pa);
        if(1 != back) { dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 39); }
      } break;
      case 8: {		

#line 4390 "hbhtml.ctr"
        back = hbhtml_process_sp_date(job, pa);
        if(1 != back) { dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 39); }
      } break;
      case 9: {		

#line 4394 "hbhtml.ctr"
        back = hbhtml_process_sp_variable(job, pa);
        if(1 != back) { dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 39); }
      } break;
      case 10: {
        hbhtml_process_sp_code(job, pa);
	back = 1;
      } break;
      case 11: {
        back = hbhtml_process_sp_a(job, pa);
        if(1 != back) { dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 39); }
      } break;
      case 12: {
        back = hbhtml_process_sp_menuentry(job, pa);
        if(1 != back) { dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 39); }
      } break;
      case 13: {
        if(0 == in_template) {
          back = hbhtml_process_sp_index(job, pa);
	  if(1 != back) { dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 39); }
	} else {
	  /* ERROR: Can not be used in template */
	  dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 50);
	}
      } break;
      case 14: {
        back = html_process_sp_sourcefile(job, pa);
	if(1 != back) { dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 39); }
      } break;
      default: {	

#line 4423 "hbhtml.ctr"
        back = 0;
	/* ERROR: Unknown special command. */
	dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,29,26,pc);
      } break;
    }
  } else {
    back = 1;	/* Empty special */
  }
  

#line 4432 "hbhtml.ctr"
  return back;
}



int
hbhtml_line_handler(void *obj, dkChar *il)
{
  dkChar		 xmsg[8];	/* Array for diagnostics */
  hb_file_processor_t	*proc;		/* Line processor */
  hb_job_t		*job;		/* Job */
  dkChar		*p1;		/* Start of input line */
  size_t		 pos;		/* Non-whitespace position */
  int			 i;		/* Input classification */
  int			 o;		/* Reaction from state machine */
  int			 ltl	= 0;	/* Flag: Error from shipout */
  int			 back	= 1;
  dkChar		 c;		/* Character to ship out */
  

#line 4451 "hbhtml.ctr"
  pos = 0;
  proc = (hb_file_processor_t *)obj;
  job = proc->job;
  dk3str_delnl(il);
  hbhtml_stm1_reset(&(proc->stm));
  job->shipused = 0;
  job->spused = 0;
  p1 = il;
  while(*p1) {
    c = *p1;
    i = hbhtml_classify_for_stm1(c);
    o = hbhtml_stm1_step(&(proc->stm), i);
    switch(o) {
      case STM1_O_ERROR: {
        /* ERROR: Parse error */
	dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,30,26,p1);
        back = -1;				

#line 4468 "hbhtml.ctr"
      } break;
      case STM1_O_NOTHING: {
      } break;
      case STM1_O_SHIPOUT: {
        if (!hbhtml_code_line_start(job)) { back = 0; }
        if(!(hbhtml_shipout(job, c))) {
	  back = 0;				

#line 4475 "hbhtml.ctr"
	  if(0 == ltl) {
	    ltl = 1;
	    /* ERROR: Line too long! */
	  }
	}
      } break;
      case STM1_O_BS_SHIPOUT: {
        switch(c) {
	  case dkT('n'): {
            if (!hbhtml_code_line_start(job)) { back = 0; }
	    if(!(hbhtml_shipout(job, dkT('\n')))) {
	      back = 0;				

#line 4487 "hbhtml.ctr"
	      if(0 == ltl) {
	        ltl = 1;
	        /* ERROR: Line too long! */
	      }
	    }
	  } break;
	  case dkT('r'): {
            if (!hbhtml_code_line_start(job)) { back = 0; }
	    if(!(hbhtml_shipout(job, dkT('\r')))) {
	      back = 0;				

#line 4497 "hbhtml.ctr"
	      if(0 == ltl) {
	        ltl = 1;
	        /* ERROR: Line too long! */
	      }
	    }
	  } break;
	  case dkT('t'): {
            if (!hbhtml_code_line_start(job)) { back = 0; }
	    if(!(hbhtml_shipout(job, dkT('\t')))) {
	      back = 0;				

#line 4507 "hbhtml.ctr"
	      if(0 == ltl) {
	        ltl = 1;
	        /* ERROR: Line too long! */
	      }
	    }
	  } break;
	  case dkT('%'): case dkT('\\'): {
            if (!hbhtml_code_line_start(job)) { back = 0; }
	    if(!(hbhtml_shipout(job, c))) {
	      back = 0;				

#line 4517 "hbhtml.ctr"
	      if(0 == ltl) {
	        ltl = 1;
	        /* ERROR: Line too long! */
	      }
	    }
	  } break;
	  case dkT('.'): {
	    /*	We can escape a leading dot.
	    */
	    if(1 < pos) {
	      xmsg[0] = dkT('\\');
	      xmsg[1] = c;
	      xmsg[2] = dkT('\0');
	      dk3app_log_3(job->app, DK3_LL_WARNING, job->msg, 63, 64, xmsg);
	    }
            if (!hbhtml_code_line_start(job)) { back = 0; }
	    if(!(hbhtml_shipout(job, c))) {
	      back = 0;				

#line 4535 "hbhtml.ctr"
	      if(0 == ltl) {
	        ltl = 1;
	        /* ERROR: Line too long! */
	      }
	    }
	  } break;
	  default: {
	    xmsg[0] = dkT('\\');
	    xmsg[1] = c;
	    xmsg[2] = dkT('\0');
	    dk3app_log_3(job->app, DK3_LL_WARNING, job->msg, 63, 64, xmsg);
            if (!hbhtml_code_line_start(job)) { back = 0; }
	    if(!(hbhtml_shipout(job, c))) {
	      back = 0;				

#line 4549 "hbhtml.ctr"
	      if(0 == ltl) {
	        ltl = 1;
	        /* ERROR: Line too long! */
	      }
	    }
	  } break;
	}
      } break;
      case STM1_O_PERCENT_SHIPOUT: {
        if (!hbhtml_code_line_start(job)) { back = 0; }
        if(!(hbhtml_shipout(job, dkT('%')))) {
	  back = 0;				

#line 4561 "hbhtml.ctr"
	  if(0 == ltl) {
	    ltl = 1;
	  }
	}
	if(!(hbhtml_shipout(job, c))) {
	  back = 0;				

#line 4567 "hbhtml.ctr"
	  if(0 == ltl) {
	    ltl = 1;
	  }
	}
      } break;
      case STM1_O_PERCENT: {
        if (!hbhtml_code_line_start(job)) { back = 0; }
        if(!(hbhtml_shipout(job, dkT('%')))) {
	  back = 0;				

#line 4576 "hbhtml.ctr"
	  if(0 == ltl) {
	    ltl = 1;
	  }
	}
      } break;
      case STM1_O_SWITCH: {
        hbhtml_flush_shipout(job);
	job->spused = 0;
      } break;
      case STM1_O_SPECIAL: {
        if(!hbhtml_add_to_special(job, c)) {
	  back = 0;				

#line 4588 "hbhtml.ctr"
	  if(0 == ltl) {
	    ltl = 1;
	  }
	} 
      } break;
      case STM1_O_SPEC_BS: {
        switch(c) {
	  case dkT('n'): {
	    if(!hbhtml_add_to_special(job, dkT('\n'))) {
	      back = 0;				

#line 4598 "hbhtml.ctr"
	      if(0 == ltl) {
	        ltl = 1;
	      }
	    }
	  } break;
	  case dkT('r'): {
	    if(!hbhtml_add_to_special(job, dkT('\r'))) {
	      back = 0;				

#line 4606 "hbhtml.ctr"
	      if(0 == ltl) {
	        ltl = 1;
	      }
	    }
	  } break;
	  case dkT('t'): {
	    if(!hbhtml_add_to_special(job, dkT('\t'))) {
	      back = 0;				

#line 4614 "hbhtml.ctr"
	      if(0 == ltl) {
	        ltl = 1;
	      }
	    }
	  } break;
	  default: {
	    if(!hbhtml_add_to_special(job, c)) {
	      back = 0;				

#line 4622 "hbhtml.ctr"
	      if(0 == ltl) {
	        ltl = 1;
	      }
	    }
	  } break;
	}
      } break;
      case STM1_O_SPEC_PC_ADD: {
        if(!hbhtml_add_to_special(job, dkT('%'))) {
	  back = 0;				

#line 4632 "hbhtml.ctr"
	  if(0 == ltl) {
	    ltl = 1;
	  }
	}
        if(!hbhtml_add_to_special(job, c)) {
	  back = 0;				

#line 4638 "hbhtml.ctr"
	  if(0 == ltl) {
	    ltl = 1;
	  }
	}
      } break;
      case STM1_O_SPEC_PC: {
        if(!hbhtml_add_to_special(job, dkT('%'))) {
	  back = 0;				

#line 4646 "hbhtml.ctr"
	  if(0 == ltl) {
	    ltl = 1;
	  }
	}
      } break;
      case STM1_O_EXECUTE: {
        if((job->spused) < (job->bs)) {
	  (job->special)[job->spused] = dkT('\0');
	  back = hbhtml_process_special(job,proc->in_template,proc->p,proc->n);
	} else {
	  back = 0;				

#line 4657 "hbhtml.ctr"
	  if(0 == ltl) {
	    ltl = 1;
	  }
	}
        job->spused = 0;
	job->shipused = 0;
      } break;
    }
    p1++;
    if((dkT(' ') != c) && (dkT('\t') != c)) {
      pos++;
    }
  }
  switch(proc->stm) {
    case STM1_ST_BS: {
      if (!hbhtml_code_line_start(job)) { back = 0; }
      if(!(hbhtml_shipout(job, dkT('\\')))) {
        back = 0;
        if(0 == ltl) { ltl = 1; }
      }
    } break;
    case STM1_ST_PERCENT: {
      if (!hbhtml_code_line_start(job)) { back = 0; }
      if(!(hbhtml_shipout(job, dkT('%')))) {
        back = 0;
	if(0 == ltl) { ltl = 1; }
      }
    } break;
    case STM1_ST_SPECIAL: case STM1_ST_SPEC_BS: case STM1_ST_SPEC_PC: {
      /* ERROR: Unfinished special command! */
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 62);
      back = 0;
    } break;
  }
  if(ltl) {
    dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 31, 26, il);
  }
  hbhtml_flush_shipout(job);
  if (!hbhtml_code_line_end(job)) { back = 0; }
  if (EOF == fputc('\n', job->of)) {
    back = 0;				

#line 4698 "hbhtml.ctr"
  }
  

#line 4700 "hbhtml.ctr"
  return back;
}



/**	Write JS files to HTML header.
	@param	job	Job structure.
	@param	nptr
	@return	1 on success, 0 on error.
*/
static
int
hbhtml_write_js_files(hb_job_t *job, hb_node_t *nptr)
{
  hb_link_t	*linkptr;	/* File name data for JavaScript file */
  int		 back = 1;
  /*	Write parent JS files.
  */
  if(nptr->parent) {
    if(!((nptr->options) & HB_NODE_OPT_STOP_JS_INHERITANCE)) {
      hbhtml_write_js_files(job, nptr->parent);
    }
  }

  /*	Write node JS files.
  */
  if((nptr->s_jsfiles) && (nptr->i_jsfiles)) {
    dk3sto_it_reset(nptr->i_jsfiles);
    while(NULL != (linkptr = (hb_link_t *)dk3sto_it_next(nptr->i_jsfiles))) {
      if(linkptr->url) {
        fputs(hbhtml_c8_kw[121], job->of);
	if(!hbhtml_url_output_for_text(job, linkptr->url)) { back = 0; }
	fputs(hbhtml_c8_kw[122], job->of);
      }
    }
  }
  return back;
}



/**	Write one head navigation entry.
	@param	job		Job structure.
	@param	nptr		Node (may be NULL for impressum).
	@param	url		URL to use if nptr is NULL.
	@param	titleind	Title index if nptr is NULL.
	@param	linkkwind	Link keyword index.
	@param	appendind	Index for keyword index.
*/
static
void
hbhtml_one_head_navigation(
  hb_job_t	*job,
  hb_node_t	*nptr,
  dkChar const	*url,
  size_t	 titleind,
  size_t	 linkkwind,
  size_t	 appendind
)
{
  dkChar	 bu[DK3_MAX_PATH];	/* Buffer for output file name */
  hb_node_t	*jnptr;			/* Jump node */

  if(nptr) {
    jnptr = nptr;
    if(!(jnptr->filename)) { jnptr = jnptr->jumpnode; }
    if(hbhtml_create_output_filename(bu, DK3_SIZEOF(bu,dkChar), job, jnptr)) {
      fputs(hbhtml_c8_kw[123], job->of);
      fputs(hbhtml_c8_kw[linkkwind], job->of);
      fputs(hbhtml_c8_kw[124], job->of);
      if(!hbhtml_output_for_text(job, jnptr->title)) { job->exv = 1; }
      fputs(hbhtml_c8_kw[125], job->of);
      if(!hbhtml_url_output_for_text(job, bu)) { job->exv = 1; }
      if(appendind) {
        fputs(hbhtml_c8_kw[appendind], job->of);
      }
      fputs(hbhtml_c8_kw[126], job->of);
    } else {
      job->exv = 1;
    }
  } else {
    fputs(hbhtml_c8_kw[123], job->of);
    fputs(hbhtml_c8_kw[linkkwind], job->of);
    fputs(hbhtml_c8_kw[124], job->of);
    if(!hbhtml_output_for_text(job, (job->msg)[titleind])) { job->exv = 1; }
    fputs(hbhtml_c8_kw[125], job->of);
    if(!hbhtml_url_output_for_text(job, url)) { job->exv = 1; }
    if(appendind) {
      fputs(hbhtml_c8_kw[appendind], job->of);
    }
    fputs(hbhtml_c8_kw[126], job->of);
  }
}



/**	Write navigation entries to HTML header.
	@param	job	Job structure.
	@param	node	Current node to write.
	@param	prev	Previous node.
	@param	next	Next node.
*/
static
void
hbhtml_write_head_navigation(
  hb_job_t	*job,
  hb_node_t	*node,
  hb_node_t	*prev,
  hb_node_t	*next
)
{
  hb_node_t	*nptr;	/* Current node to process */

  /*	Navigation (links)
  	author (impressum), contents, index, top, up, first, prev, next, last
	link rel="..." title="..." href="..."
  */
  if(job->impressumnode) {
    nptr = job->impressumnode;
    hbhtml_one_head_navigation(job, nptr, NULL, 0, 127, 0);
  } else {
    if(job->impressumlink) {
      hbhtml_one_head_navigation(job, NULL, job->impressumlink, 61, 127, 0);
    }
  }
  if(job->rootnode) {
    hbhtml_one_head_navigation(
      job, job->rootnode, NULL, 0, 128,
      (((job->options) & HB_JOB_OPT_CREATE_TOC) ? 136 : 0)
    );
    hbhtml_one_head_navigation(
      job, job->rootnode, NULL, 0, 129,
      (((job->options) & HB_JOB_OPT_CREATE_INDEX) ? 137 : 0)
    );
    hbhtml_one_head_navigation(job, job->rootnode, NULL, 0, 130, 0);
  }
  nptr = node;
  nptr = nptr->parent;
  if(nptr) {
    while((!(nptr->filename)) && (nptr->parent)) { nptr = nptr->parent; }
    if(nptr) {
      hbhtml_one_head_navigation(job, nptr, NULL, 0, 131, 0);
    }
  }
  if(job->firstnode) {
    hbhtml_one_head_navigation(job, job->firstnode, NULL, 0, 132, 0);
  }
  if(prev) {
    hbhtml_one_head_navigation(job, prev, NULL, 0, 133, 0);
  }
  if(next) {
    hbhtml_one_head_navigation(job, next, NULL, 0, 134, 0);
  }
  if(job->lastnode) {
    hbhtml_one_head_navigation(job, job->lastnode, NULL, 0, 135, 0);
  }
}



/**	Write HTML header
	@param	job	Job structure.
	@param	nodeptr	Current node to write.
	@param	prev	Previous node.
	@param	next	Next node.
*/
static
void
hbhtml_write_header(
  hb_job_t *job, hb_node_t *nodeptr, hb_node_t *prev, hb_node_t *next
)
{
  dkChar const	*ptr;		/* Multiple text elements */
  

#line 4874 "hbhtml.ctr"
  fputs(hbhtml_c8_kw[15], job->of);
  /*	Title
  */
  fputs(hbhtml_c8_kw[19], job->of);
  hbhtml_output_for_text(job, hbconf_title(nodeptr));
  fputs(hbhtml_c8_kw[20], job->of);
  /*	Generator (comment)
  */
  if((nodeptr->options) & HB_NODE_OPT_USE_TIDY) {
    fputs(hbhtml_c8_kw[17], job->of);
  }
  /*	Generator (meta)
  */
  fputs(hbhtml_c8_kw[18], job->of);
  /*	Style (link)
  */
  ptr = hbconf_stylefile(nodeptr);
  if(ptr) {
    if(!hbtool_add_file(job, ptr)) { job->exv = 1; }
    fputs(hbhtml_c8_kw[21], job->of);
    hbhtml_url_output_for_text(job, ptr);
    fputs(hbhtml_c8_kw[22], job->of);
  }
  /*	Shortcut icon (link)
  */
  ptr = hbconf_favicon(nodeptr);
  if(ptr) {
    fputs(hbhtml_c8_kw[27], job->of);
    hbhtml_url_output_for_text(job, ptr);
    fputs(hbhtml_c8_kw[28], job->of);
  }
  /*	Navigation (links)
  */
  hbhtml_write_head_navigation(job, nodeptr, prev, next);
  /*	Character set (meta)
  */
  if(HB_CS_UTF_8 == job->cs) {
    fputs(hbhtml_c8_kw[24], job->of);
  } else {
    fputs(hbhtml_c8_kw[23], job->of);
  }
  /*	Author (meta)
  */
  ptr = hbconf_author(nodeptr);
  if(ptr) {
    fputs(hbhtml_c8_kw[25], job->of);
    hbhtml_output_for_text(job, ptr);
    fputs(hbhtml_c8_kw[26], job->of);
  }
  (void)hbhtml_write_js_files(job, nodeptr);
  fputs(hbhtml_c8_kw[16], job->of); 

#line 4925 "hbhtml.ctr"
}



/**	Write one output file.
	@param	job	Job structure.
	@param	nodeptr	Current node to write.
	@param	fn	Output file name.
	@param	p	Previous node.
	@param	n	Next node.
*/
static
void
hbhtml_write_named_file(
  hb_job_t	*job,
  hb_node_t	*nodeptr,
  dkChar const	*fn,
  hb_node_t	*p,
  hb_node_t	*n
)
{
  hb_file_processor_t	 proc;		/* Template file processor */
  dkChar const		*templateName;	/* Template file name */
  dkChar const		*oldsourcefile;	/* Old source file name */
  unsigned long		 oldsourceline;	/* Old source file line */
  int			 inenc;		/* Input encoding */
  int			 res;		/* Result from file processing */
  

#line 4953 "hbhtml.ctr"
  

#line 4954 "hbhtml.ctr"
  

#line 4955 "hbhtml.ctr"
  oldsourcefile = dk3app_get_source_file(job->app);
  oldsourceline = dk3app_get_source_line(job->app);
  dk3app_set_source_line(job->app, nodeptr->lineno);
  nodeptr->outFileName = fn;
  job->currentnode = nodeptr;
  job->of = NULL;
  templateName = hbconf_node_template(job, nodeptr);
  if(templateName) {
    dk3app_set_source_file(job->app, templateName);
    job->options &= (~(HB_JOB_OPT_CODE));
    job->of = dk3sf_fopen_app(fn, dkT("w"), job->app);
    if(job->of) {
      fputs(hbhtml_c8_kw[11], job->of);
      hbhtml_write_header(job, nodeptr, p, n);
      fputs(hbhtml_c8_kw[13], job->of);
      proc.job = job;
      proc.in_template = 1;
      proc.stm = 0;
      proc.p = p;
      proc.n = n;
      inenc = dk3app_get_input_file_encoding(job->app);
      if(0 <= job->iecmd) { inenc = job->iecmd; }
      res = dk3stream_process_filename_lines_app(
        (void *)(&proc), hbhtml_line_handler, templateName,
	job->iltemplate, job->bs,
	dk3app_get_encoding(job->app),
	inenc,
	job->app
      );
      fputs(hbhtml_c8_kw[14], job->of);
      fputs(hbhtml_c8_kw[12], job->of);
      if(1 != res) {
        job->exv = 1;			

#line 4988 "hbhtml.ctr"
      }
      if(!(dk3sf_fclose_fn_app(job->of, fn, job->app))) {
        job->exv = 1;			

#line 4991 "hbhtml.ctr"
      }
    } else {
      job->exv = 1;			

#line 4994 "hbhtml.ctr"
    }
  } else {
    /* ERROR: No template! */
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 19);
    job->exv = 1;			

#line 4999 "hbhtml.ctr"
  }
  nodeptr->outFileName = NULL;
  dk3app_set_source_file(job->app, oldsourcefile);
  dk3app_set_source_line(job->app, oldsourceline);
  

#line 5004 "hbhtml.ctr"
}



/**	Mark path to current node in parent nodes
	(set the curchild element).
	@param	nodeptr	Current node.
*/
static
void
hbhtml_mark_path(hb_node_t *nodeptr)
{
  hb_node_t	*cp;		/* Current node */
  

#line 5018 "hbhtml.ctr"
  cp = nodeptr;
  cp->curchild = NULL;
  while(cp) {
    if(cp->parent) { (cp->parent)->curchild = cp; }
    cp = cp->parent;
  } 

#line 5024 "hbhtml.ctr"
}



void
hbhtml_write_file(hb_job_t *job, hb_node_t *nodeptr, hb_node_t *p, hb_node_t *n)
{
  dkChar	 bu[DK3_MAX_PATH];	/* File name buffer. */
  

#line 5033 "hbhtml.ctr"

  /*	Set things up for new file.
  */
  job->coli = 0;
  job->cols = HB_COLIST_NONE;
  job->options &= (~(HB_JOB_OPT_CODE));

  /*	Process the file.
  */
  hbhtml_mark_path(nodeptr);
  if(hbhtml_create_output_filename(bu, DK3_SIZEOF(bu,dkChar), job, nodeptr)) {
    

#line 5045 "hbhtml.ctr"
    hbhtml_write_named_file(job, nodeptr, bu, p, n);
  } else {
    job->exv = 1;		

#line 5048 "hbhtml.ctr"
  }
  
  

#line 5051 "hbhtml.ctr"
}


