/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: hbcont.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file hbcont.c The hbcont module.
*/


#line 44 "hbcont.ctr"

#include "dk3all.h"
#include "htmlbook.h"





#line 51 "hbcont.ctr"



/**	Object to process a contents line.
*/
typedef struct {
  hb_job_t		*job;		/**< Job structure. */
  hb_node_t		*nptr;		/**< Current node. */
  unsigned long		 lineno;	/**< Current line number. */
  unsigned long		 nheader;	/**< Next header number. */
  unsigned		 maxheader;	/**< Maximum header number found. */
} hb_contents_line_processor_t;



/**	Output keywords.
*/
static char const * const	hbcont_c8_kw[] = {
/* 0 */
"\n",

/* 1 */
" ",

/* 2 */
"<h1>",

/* 3 */
"</h1>\n",

/* 4 */
"<table class=\"hb_pos_ta\" summary=\"",

/* 5 */
"</table>\n",

/* 6 */
"<tr class=\"hb_pos_tr\">\n",

/* 7 */
"</tr>\n",

/* 8 */
"<td class=\"hb_pos_td_arrow\">",

/* 9 */
"</td>\n",

/* 10 */
"&#8594;",

/* 11 */
"<td class=\"hb_pos_td_text\" colspan=\"%d\">",

/* 12 */
"<h%u>",

/* 13 */
"</h%u>\n",

/* 14 */
"<a name=\"",

/* 15 */
"\"></a>",

/* 16 */
"hb_h",

/* 17 */
"<table class=\"hb_ptoc_ta\" summary=\"",

/* 18 */
"</table>\n",

/* 19 */
"<tr class=\"hb_ptoc_tr\">",

/* 20 */
"</tr>\n",

/* 21 */
"<td class=\"hb_ptoc_td_empty\">&nbsp;&nbsp;&nbsp;</td>\n",

/* 22 */
"<td class=\"hb_ptoc_td_data\" colspan=\"%u\">",

/* 23 */
"</td>\n",

/* 24 */
"<a href=\"#",

/* 25 */
"\" title=\"",

/* 26 */
"\" class=\"hb_ptoc_a\">",

/* 27 */
"</a>",

/* 28 */
"<div class=\"hb_link_div\">\n<h2>",

/* 29 */
"</h2>\n",

/* 30 */
"</div>",

/* 31 */
"<table class=\"hb_link_ta\" summary=\"",

/* 32 */
"</table>\n",

/* 33 */
"<tr class=\"\">\n",

/* 34 */
"</tr>\n",

/* 35 */
"<td class=\"hb_link_td_number\">",

/* 36 */
"</td>\n",

/* 37 */
"&nbsp;%lu&nbsp;",

/* 38 */
"<td class=\"hb_link_td_url\">",

/* 39 */
"<div class=\"hb_dtoc_div\">\n<table class=\"hb_dtoc_ta\" summary=\"",

/* 40 */
"</table>\n</div><!-- class=\"hb_dtoc_div\" -->\n",

/* 41 */
"<tr class=\"hb_dtoc_tr\">\n",

/* 42 */
"</tr>\n",

/* 43 */
"<td class=\"hb_dtoc_td_space\">&nbsp;&nbsp;&nbsp;</td>\n",

/* 44 */
"<td class=\"hb_dtoc_td_entry\" colspan=\"%d\">",

/* 45 */
"<a class=\"hb_dtoc_a\" href=\"",

/* 46 */
"\">",

/* 47 */
"<a name=\"hb_toc\"></a><h2 class=\"hb_dtoc_h2\">",

/* 48 */
"</h2>\n",

/* 49 */
"<div class=\"hb_pos_div\">",

/* 50 */
"<div class=\"hb_ki_div\">",

/* 51 */
"<a name=\"hb_index\"></a><h2 class=\"hb_ki_h2\">",

/* 52 */
"<dl class=\"hb_ki_dl\">",

/* 53 */
"</dl>\n",

/* 54 */
"<dt class=\"hb_ki_dt\">",

/* 55 */
"</dt>\n",

/* 56 */
"<dd class=\"hb_ki_dd\">\n<ul class=\"hb_ki_ul\">\n",

/* 57 */
"</ul>\n</dd>\n",

/* 58 */
"<li class=\"hb_ki_li\">",

/* 59 */
"</li>\n",

/* 60 */
"<a class=\"hb_ki_a\" href=\"",

/* 61 */
"#",

NULL


#line 232 "hbcont.ctr"
};



void
hbcont_line_delete(hb_line_t *lp)
{
  

#line 240 "hbcont.ctr"
  if(lp) {
    lp->aname = NULL;
    lp->realtext = NULL;
    lp->lineno = 0UL;
    lp->header = 0UL;
    lp->headlevel = 0;
    lp->lt = 0;
    dk3_release(lp->text);
    dk3_delete(lp);
  } 

#line 250 "hbcont.ctr"
}



hb_line_t *
hbcont_line_new(dkChar const *il, unsigned long lineno, dk3_app_t *app)
{
  hb_line_t	*back = NULL;
  

#line 259 "hbcont.ctr"
  if(il) {
    back = dk3_new_app(hb_line_t,1,app);
    if(back) {
      back->text = NULL;
      back->aname = NULL;
      back->realtext = NULL;
      back->lineno = lineno;
      back->header = 0UL;
      back->lt = 0;
      back->text = dk3str_dup_app(il, app);
      if(!(back->text)) {
        hbcont_line_delete(back);
	back = NULL;
      }
    }
  } 

#line 275 "hbcont.ctr"
  return back;
}



/**	Compare two saved lines.
	@param	l	Left line.
	@param	r	Right line.
	@param	cr	Comparison criteria (ignored).
	@return	Comparison result.
*/
static
int
hbcont_line_compare(void const *l, void const *r, int cr)
{
  hb_line_t	*pl;
  hb_line_t	*pr;
  int		 back = 0;
  

#line 294 "hbcont.ctr"
  if(l) {
    if(r) {
      pl = (hb_line_t *)l;
      pr = (hb_line_t *)r;
      if(pl->lineno > pr->lineno) {
        back = 1;
      } else {
        if(pl->lineno < pr->lineno) {
	  back = -1;
	}
      }
    } else back = 1;
  } else {
    if(r) back = -1;
  } 

#line 309 "hbcont.ctr"
  return back;
}



/**	Prepare current node for content processing (allocate
	storage and iterator for lines).
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbcont_prepare(hb_job_t *job)
{
  int		 back = 0;
  

#line 325 "hbcont.ctr"
  (job->currentnode)->s_lines = dk3sto_open_app(job->app);
  if((job->currentnode)->s_lines) {
    dk3sto_set_comp((job->currentnode)->s_lines, hbcont_line_compare, 0);
    (job->currentnode)->i_lines = dk3sto_it_open((job->currentnode)->s_lines);
    if((job->currentnode)->i_lines) {
      back = 1;
    }
  } 

#line 333 "hbcont.ctr"
  return back;
}



/**	Clean up current node (release contents lines, storage and iterator).
	@param	job	Job structure.
*/
static
void
hbcont_cleanup(hb_job_t *job)
{
  hb_line_t	*lp;
  

#line 347 "hbcont.ctr"
  if((job->currentnode)->s_lines) {
    if((job->currentnode)->i_lines) {
      dk3sto_it_reset((job->currentnode)->i_lines);
      do {
        lp = (hb_line_t *)dk3sto_it_next((job->currentnode)->i_lines);
	hbcont_line_delete(lp);
      } while(lp);
      dk3sto_it_close((job->currentnode)->i_lines);
    }
    dk3sto_close((job->currentnode)->s_lines);
  }
  (job->currentnode)->s_lines = NULL;
  (job->currentnode)->i_lines = NULL;
  

#line 361 "hbcont.ctr"
}



/**	Check whether a line is a header line.
	@param	il	Line to check.
	@return	1 for headers, 0 for normal lines.
*/
static
int
hbcont_check_header(dkChar *il)
{
  int		 back = 0;
  

#line 375 "hbcont.ctr"
  if(dkT('.') == *il) {
    il++;
    il = dk3str_start(il, NULL);
    if(il) {
      switch(*il) {
        case dkT('1'): case dkT('2'): case dkT('3'):
	case dkT('4'): case dkT('5'): case dkT('6'): {
	  back = 1;
	} break;
      }
    }
  } 

#line 387 "hbcont.ctr"
  return back;
}



/**	Line handler processing function.
	@param	obj	Handler object.
	@param	il	Input line to process.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
static
int
hbcont_line_handler(void *obj, dkChar *il)
{
  hb_contents_line_processor_t	*proc;		/* Processor */
  hb_job_t			*job;		/* Job structure */
  hb_node_t			*nptr;		/* Current node */
  hb_line_t			*lptr;		/* Current line structure */
  dkChar			*p1;		/* Start of line */
  dkChar			*p2;		/* Start of a name */
  dkChar			*p3;		/* Start of real text */
  unsigned			 u;		/* Header level */
  int				 back = 0;
  dk3str_delnl(il);
  

#line 412 "hbcont.ctr"
  proc = (hb_contents_line_processor_t *)obj;
  proc->lineno += 1UL;
  job = proc->job;
  nptr = job->currentnode;
  lptr = hbcont_line_new(il, proc->lineno, job->app);
  if(lptr) {
    if(dk3sto_add(nptr->s_lines, lptr)) {
      back = 1;
      p1 = dk3str_start(lptr->text, NULL);
      if(p1) {
        if(hbcont_check_header(p1)) {
	  back = 0;
	  p1++;
	  p1 = dk3str_start(p1, NULL);
	  if(p1) {
	    p2 = dk3str_next(p1, NULL);
	    if(p2) {
	      lptr->realtext = p2;
	      lptr->lt = 1;
#if VERSION_BEFORE_20140716
	      if(dk3sf_sscanf3(p1, dkT("%u"), &u) == 1)
#else
	      if (0 != dk3ma_ui_from_string(&u, p1, NULL))
#endif
	      {
	        lptr->headlevel = u;
		lptr->header = proc->nheader;
		if(u > proc->maxheader) { proc->maxheader = u; }
		proc->nheader += 1UL;
		back = 1;
		if(dkT('@') == *p2) {
		  back = 0;
		  *(p2++) = dkT('\0');
		  p2 = dk3str_start(p2, NULL);
		  if(p2) {
		    p3 = dk3str_chr(p2, dkT('@'));
		    if(p3) {
		      *(p3++) = dkT('\0');
		      p3 = dk3str_start(p3, NULL);
		      if(p3) {
		        lptr->aname = p2;
			lptr->realtext = p3;
			back = 1;
		      } else {		

#line 456 "hbcont.ctr"
		        /* ERROR: Missing heading text */
			dk3app_log_1(job->app,DK3_LL_ERROR,job->msg,32);
		      }
		    } else {		

#line 460 "hbcont.ctr"
		      /* ERROR: Missing closing @ */
		      dk3app_log_1(job->app,DK3_LL_ERROR,job->msg,33);
		    }
		  } else {		

#line 464 "hbcont.ctr"
		    /* ERROR: No a name text */
		    dk3app_log_1(job->app,DK3_LL_ERROR,job->msg,34);
		  }
		}
	      } else {			

#line 469 "hbcont.ctr"
	        /* ERROR: No header level */
		dk3app_log_1(job->app,DK3_LL_ERROR,job->msg,35);
	      }
	    } else {			

#line 473 "hbcont.ctr"
	      /* ERROR: No header text */
	      dk3app_log_1(job->app,DK3_LL_ERROR,job->msg,32);
	    }
	  } else {			

#line 477 "hbcont.ctr"
	    /* ERROR: Syntax, no text after dot */
	    dk3app_log_1(job->app,DK3_LL_ERROR,job->msg,36);
	  }
	}
      }
    } else {				

#line 483 "hbcont.ctr"
    }
  } else {				

#line 485 "hbcont.ctr"
  }
  

#line 487 "hbcont.ctr"
  return back;
}



/**	Read contents into storage.
	@param	job	Job structure.
	@param	proc	Line processing structure.
	@return	1 on success, 0 on errors.
*/
static
int
hbcont_read(hb_job_t *job, hb_contents_line_processor_t *proc)
{
  int		 res;		/* Result from file processing */
  int		 inenc;		/* Input encoding */
  int		 back = 0;
  

#line 505 "hbcont.ctr"
  inenc = dk3app_get_input_file_encoding(job->app);
  if(0 <= job->iecmd) { inenc = job->iecmd; }
  if(0 <= (job->currentnode)->inenc) { inenc = (job->currentnode)->inenc; }
  if((job->currentnode)->filename) {
    res = dk3stream_process_filename_lines_app(
      (void *)proc, hbcont_line_handler, (job->currentnode)->filename,
      job->ilfile, job->bs,
      dk3app_get_encoding(job->app),
      inenc,
      job->app
    );
    if(1 == res) { back = 1; }	

#line 517 "hbcont.ctr"
  } else {
    if(0UL == (job->currentnode)->objno) {
      back = 1;
    }
  }
  return back;
}



/**	Write HTML page title.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbcont_write_title(hb_job_t *job)
{
  int	 back = 0;
  

#line 537 "hbcont.ctr"
  fputs(hbcont_c8_kw[2], job->of);
  if((job->currentnode)->title) {
    if (((job->options) & HB_JOB_OPT_NUM_IN_PAGE_HEADER)) {
      if (!((job->options) & HB_JOB_OPT_CHM)) {
        if((job->currentnode)->depth < job->headlevels) {
          if(hbtool_write_header_number(job, job->currentnode)) {
            hbhtml_output_for_text(job, (job->kwnl[35]));
          }
        }
      }
    }
    back = hbhtml_output_for_text(job, (job->currentnode)->title);
  }
  fputs(hbcont_c8_kw[3], job->of);
  

#line 552 "hbcont.ctr"
  return back;
}



/**	Write position of current node.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbcont_write_position(hb_job_t *job)
{
  hb_node_t		*nptr;		/* Current node to handle. */
  int			 i;
  int			 rs;		/* td width */
  int			 curl = 0;	/* Current level */
  int			 maxl = 0;	/* Maximum level */
  int			 back = 1;
  

#line 572 "hbcont.ctr"
  nptr = job->rootnode;
  while(nptr) {
    if((nptr->parent) && (nptr->curchild)) {
      maxl++;
    }
    nptr = nptr->curchild;
  }
#if TRACE_DEBUG
  /* DEBUG */ fprintf(job->of , "<!-- maxl=%d -->\n", maxl);
#endif
  if(0 < maxl) {
    fputs(hbcont_c8_kw[49], job->of);
    fputs(hbcont_c8_kw[4], job->of);
    if(!hbhtml_output_for_text(job, (job->msg)[54])) { back = 1; }
    fputs(hbcont_c8_kw[46], job->of);
    fputs(hbcont_c8_kw[0], job->of);
    nptr = job->rootnode;
    while(nptr) {
      dk3app_set_source_line(job->app, nptr->lineno);
      if((nptr->parent) && (nptr->curchild)) {
#if TRACE_DEBUG
        /* DEBUG */ fprintf(job->of, "<!-- curl=%d maxl=%d -->\n", curl, maxl);
#endif
        fputs(hbcont_c8_kw[6], job->of);
	if(0 < curl) {
	  for(i = 0; i < (curl - 1); i++) {
	    fputs(hbcont_c8_kw[8], job->of);
	    fputs(hbcont_c8_kw[9], job->of);
	  }
	  fputs(hbcont_c8_kw[8], job->of);
	  fputs(hbcont_c8_kw[10], job->of);
	  fputs(hbcont_c8_kw[9], job->of);
	}
	rs = maxl - curl;
	fprintf(job->of, hbcont_c8_kw[11], rs);
	if(nptr->title) {
#if (!(VERSION_BEFORE_20140412))
	  /*	2014-04-12
	  	Also write header number in position.
	  */
	  if ((job->options) & HB_JOB_OPT_NUM_IN_POS) {
	    if (hbtool_write_header_number(job, nptr)) {
	      if (!hbhtml_output_for_text(job, dkT(" "))) {
	        back = 0;
	      }
	    }
	  }
#endif
	  if(!hbhtml_output_for_text(job, nptr->title)) {
	    back = 0;
	  }
	}
	fputs(hbcont_c8_kw[9], job->of);
	fputs(hbcont_c8_kw[7], job->of);
	curl++;
      }
      nptr = nptr->curchild;
    }
    fputs(hbcont_c8_kw[5], job->of);
    fputs(hbcont_c8_kw[30], job->of);
    fputs(hbcont_c8_kw[0], job->of);
  }	

#line 634 "hbcont.ctr"
  return back;
}



/**	Write anchor name for a header line.
	@param	job	Job structure.
	@param	lptr	Line to process.
	@return	1 on success, 0 on error.
*/
static
int
hbcont_write_anchor_name_for_header(hb_job_t *job, hb_line_t *lptr)
{
  char		 buffer[64];	/* Buffer to convert number to text */
  int		 back = 1;
  

#line 651 "hbcont.ctr"
  if(lptr->aname) {
    if(!hbhtml_url_output_for_text(job, lptr->aname)) {
      back = 0;
    }
  } else {
#if DK3_SIZEOF_LONG > 4
    sprintf(buffer, "%016lx", lptr->header);
#else
    sprintf(buffer, "%08lx", lptr->header);
#endif
    fputs(hbcont_c8_kw[16], job->of);
    fputs(buffer, job->of);
  } 

#line 664 "hbcont.ctr"
  return back;
}



/**	Process the content lines saved before.
	@param	job	Job structure.
	@param	proc	Line processing structure.
	@param	p	Previous node.
	@param	n	Next node.
	@return	1 on success, 0 on error.
*/
static
int
hbcont_write_contents(
  hb_job_t			*job,
  hb_contents_line_processor_t	*proc,
  hb_node_t			*p,
  hb_node_t			*n
)
{
  hb_file_processor_t	 myproc;
  hb_line_t		*lptr;		/* Current line to process */
  hb_line_t		*tocptr;	/* Current TOC line to process */
  hb_node_t		*nptr;		/* Current node to process */
  dk3_sto_it_t		*i_toc;		/* Line traversal for TOC */
  unsigned		 cs	= 0;	/* Column space */
  unsigned		 sp	= 0;	/* Spaces before data field */
  unsigned		 hl	= 0;	/* Header level */
  unsigned		 i	= 0;	/* Create spaces */
  int			 tocpr	= 0;	/* Flag: Page TOC already printed */
  int			 back	= 0;
  

#line 697 "hbcont.ctr"
  if((job->options) & HB_JOB_OPT_CHM) { tocpr = 1; }
  nptr  = job->currentnode;
  i_toc = dk3sto_it_open(nptr->s_lines);
  if(i_toc) {
    dk3sto_it_reset(nptr->i_lines);
    dk3sto_it_reset(i_toc);
    back = 1;
    do {
      lptr = (hb_line_t *)dk3sto_it_next(nptr->i_lines);
      if(lptr) {
        dk3app_set_source_line(job->app, lptr->lineno);
        if(lptr->lt) {
	  /* Header line */
	  if((0 == tocpr) && ((nptr->options) & HB_NODE_OPT_PAGE_TOC)) {
	    tocpr = 1;		

#line 712 "hbcont.ctr"
	    fputs(hbcont_c8_kw[17], job->of);
	    if(!hbhtml_output_for_text(job, (job->msg)[55])) { back = 0; }
	    fputs(hbcont_c8_kw[46], job->of);
	    fputs(hbcont_c8_kw[0], job->of);
	    do {
	      tocptr = (hb_line_t *)dk3sto_it_next(i_toc);
	      if(tocptr) {
	        if(tocptr->lt) {
		  dk3app_set_source_line(job->app, tocptr->lineno);
		  sp = 0;
#if 0
		  if(tocptr->headlevel < proc->maxheader) {
		    sp = proc->maxheader - tocptr->headlevel;
		  }
#endif
		  if(tocptr->headlevel > 0) {
		    sp = tocptr->headlevel - 1;
		  }
		  cs = proc->maxheader - sp;
		  fputs(hbcont_c8_kw[19], job->of);
		  for(i = 0; i < sp; i++) {
		    fputs(hbcont_c8_kw[21], job->of);
		  }
		  fprintf(job->of, hbcont_c8_kw[22], cs);
		  fputs(hbcont_c8_kw[24], job->of);
		  if(!hbcont_write_anchor_name_for_header(job, tocptr)) {
		    back = 0;
		  }
		  fputs(hbcont_c8_kw[25], job->of);
		  if(!hbhtml_output_for_text(job, tocptr->realtext)) {
		    back = 0;
		  }
		  fputs(hbcont_c8_kw[26], job->of);
		  if(!hbhtml_output_for_text(job, tocptr->realtext)) {
		    back = 0;
		  }
		  fputs(hbcont_c8_kw[27], job->of);
		  fputs(hbcont_c8_kw[23], job->of);
		  fputs(hbcont_c8_kw[20], job->of);
                  dk3app_set_source_line(job->app, lptr->lineno);
		}
	      }
	    } while(tocptr);
	    fputs(hbcont_c8_kw[18], job->of);
	  }
	  hl = 1 + lptr->headlevel;
	  if(6 < hl) {
	    hl = 6;
	    /* Warning: Header level corrected to 6! */
	    dk3app_log_1(job->app,DK3_LL_ERROR,job->msg,37);
	  }
	  fprintf(job->of, hbcont_c8_kw[14], hl);
	  if(!hbcont_write_anchor_name_for_header(job, lptr)) {
	    back = 0;			

#line 766 "hbcont.ctr"
	  }
	  fprintf(job->of, hbcont_c8_kw[15], hl);
	  fprintf(job->of, hbcont_c8_kw[12], hl);
	  if(!hbhtml_output_for_text(job, lptr->realtext)) {
	    back = 0;			

#line 771 "hbcont.ctr"
	  }
	  fprintf(job->of, hbcont_c8_kw[13], hl);
	} else {
	  myproc.job = job;
	  myproc.in_template = 0;
	  myproc.stm = 0;
	  myproc.p = p;
	  myproc.n = n;	

#line 779 "hbcont.ctr"
	  if(1 != hbhtml_line_handler((void *)(&myproc), lptr->text)) {
	    back = 0;	

#line 781 "hbcont.ctr"
	  }
	}
      }
    } while(lptr);
    dk3sto_it_close(i_toc);
  } 

#line 787 "hbcont.ctr"
  return back;
}



/**	Write list of external links for current node.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbcont_write_link_list(hb_job_t *job)
{
  hb_link_t		*linkptr;	/* Current link to process */
  hb_node_t		*nptr;		/* Current node to process */
  int			 back = 1;
  

#line 804 "hbcont.ctr"
  nptr = job->currentnode;
  if(nptr->nextlink) {
    dk3sto_it_reset(nptr->i_lbylno);
    fputs(hbcont_c8_kw[28], job->of);
    if(!hbhtml_output_for_text(job, (job->msg)[23])) { back = 0; }
    fputs(hbcont_c8_kw[29], job->of);
    fputs(hbcont_c8_kw[31], job->of);
    if(!hbhtml_output_for_text(job, (job->msg)[56])) { back = 0; }
    fputs(hbcont_c8_kw[46], job->of);
    fputs(hbcont_c8_kw[0], job->of);
    while(NULL != (linkptr = (hb_link_t *)dk3sto_it_next(nptr->i_lbylno))) {
      fputs(hbcont_c8_kw[33], job->of);
      /* Number */
      fputs(hbcont_c8_kw[35], job->of);
      fprintf(job->of, hbcont_c8_kw[37], (1UL + linkptr->lno));
      fputs(hbcont_c8_kw[36], job->of);
      /* URL */
      fputs(hbcont_c8_kw[38], job->of);
      if(!hbhtml_url_output_for_text(job, linkptr->url)) { back = 1; }
      fputs(hbcont_c8_kw[36], job->of);
      fputs(hbcont_c8_kw[34], job->of);
    }
    fputs(hbcont_c8_kw[32], job->of);
    fputs(hbcont_c8_kw[30], job->of);
  } 

#line 829 "hbcont.ctr"
  return back;
}



/**	Create project table of contents.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbcont_create_toc(hb_job_t *job)
{
  dkChar		 ofn[DK3_MAX_PATH];	/* Output file name */
  hb_node_t		*nptr;			/* Current node to process */
  hb_node_t		*dest;			/* Print node for cur node */
  dkChar const		*oldsourcefile;		/* Old source file name saved */
  unsigned long		 oldsourceline;		/* Old source file line saved */
  int			 res;			/* Result from file name cr */
  int			 i;
  int			 back = 1;
  

#line 851 "hbcont.ctr"
  oldsourcefile = dk3app_get_source_file(job->app);
  oldsourceline = dk3app_get_source_line(job->app);
  dk3app_set_source_file(job->app, job->infilename);
  dk3app_set_source_line(job->app, 0UL);
  fputs(hbcont_c8_kw[47], job->of);
  if(!hbhtml_output_for_text(job, (job->msg)[45])) { back = 0; }
  fputs(hbcont_c8_kw[48], job->of);
  fputs(hbcont_c8_kw[39], job->of);
  if(!hbhtml_output_for_text(job, (job->msg)[57])) { back = 0; }
  fputs(hbcont_c8_kw[46], job->of);
  fputs(hbcont_c8_kw[0], job->of);
  nptr = job->rootnode;
  while(nptr) {
    

#line 865 "hbcont.ctr"
    dk3app_set_source_line(job->app, nptr->lineno);
    switch(nptr->tocstate) {
      case HB_TOC_STATE_INIT: {	

#line 868 "hbcont.ctr"
        if(nptr->parent) {
	  /* Write TOC entry */
	  dest = NULL;
	  if(nptr->filename) {
	    dest = nptr;
	  } else {
	    if(nptr->jumpnode) {
	      dest = nptr->jumpnode;
	    }
	  }
	  if(dest) {	

#line 879 "hbcont.ctr"
	    res =
	    hbhtml_create_output_filename(ofn,DK3_SIZEOF(ofn,dkChar),job,dest);
	    if(res) {
	      fputs(hbcont_c8_kw[41], job->of);
	      for(i = 1; i < nptr->depth; i++) {
	        fputs(hbcont_c8_kw[43], job->of);
	      }
	      fprintf(
	        job->of, hbcont_c8_kw[44], ((job->maxdepth) - (nptr->depth) + 1)
	      );
	      fputs(hbcont_c8_kw[45], job->of);
	      if(!hbhtml_url_output_for_text(job, ofn)) { back = 0; }
	      fputs(hbcont_c8_kw[25], job->of);
	      if(hbtool_write_header_number(job, nptr)) {
	        fputs(hbcont_c8_kw[1], job->of);
	      }
	      if(!hbhtml_output_for_text(job, nptr->title)) { back = 0; }
	      fputs(hbcont_c8_kw[46], job->of);
	      if(hbtool_write_header_number(job, nptr)) {
	        fputs(hbcont_c8_kw[1], job->of);
	      }
	      if(!hbhtml_output_for_text(job, nptr->title)) { back = 0; }
	      fputs(hbcont_c8_kw[27], job->of);
	      fputs(hbcont_c8_kw[9], job->of);
	      fputs(hbcont_c8_kw[42], job->of);
	    } else {
	      /* ERROR: Failed to create output file name */
	      back = 0;
	    }
	  } else {			

#line 909 "hbcont.ctr"
	    /* ERROR: No destination found */
	    back = 0;
	    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 51);
	  }
	}
	dk3sto_it_reset(nptr->i_subnodes);
	nptr->tocstate = HB_TOC_STATE_IN_PROGRESS;
      } break;
      case HB_TOC_STATE_IN_PROGRESS: {	

#line 918 "hbcont.ctr"
        nptr->curchild = dk3sto_it_next(nptr->i_subnodes);
	if(nptr->curchild) {
	  nptr = nptr->curchild;
	} else {
	  nptr->tocstate = HB_TOC_STATE_FINISHED;
	}
      } break;
      case HB_TOC_STATE_FINISHED: {	

#line 926 "hbcont.ctr"
        nptr = nptr->parent;
      } break;
    }
  }
  fputs(hbcont_c8_kw[40], job->of);
  dk3app_set_source_file(job->app, oldsourcefile);
  dk3app_set_source_line(job->app, oldsourceline);
  

#line 934 "hbcont.ctr"
  return back;
}



/**	Create keyword index.
	@param	job	Job structure
	@return	1 on success, 0 on error.
*/
static
int
hbcont_create_keyword_index(hb_job_t *job)
{
  hb_index_entry_t	*pp	= NULL;	/* Previous pointer */
  hb_index_entry_t	*cp	= NULL;	/* Current pointer */
  dk3_c32_t		 pstc	= 0UL;	/* Previous start character */
  dk3_c32_t		 cstc	= 0UL;	/* Start character */
  int			 nkw	= 0;	/* Flag: Open new keyword */
  int			 hh2	= 0;	/* Flag: Have division and h2 */
  int			 back	= 1;
  

#line 955 "hbcont.ctr"
  dk3sto_it_reset(job->i_index);
  while(NULL != (cp = (hb_index_entry_t *)dk3sto_it_next(job->i_index))) {
    

#line 958 "hbcont.ctr"
    if(!(hh2)) {	

#line 959 "hbcont.ctr"
      hh2 = 1;
      fputs(hbcont_c8_kw[50], job->of);
      fputs(hbcont_c8_kw[51], job->of);
      if(!hbhtml_output_for_text(job, (job->msg)[46])) { back = 0; }
      fputs(hbcont_c8_kw[29], job->of);
      fputs(hbcont_c8_kw[52], job->of);
    }
    /*	Process entry.
    */
    nkw = 0;
    if(pp) {					

#line 970 "hbcont.ctr"
      if(dk3str_cmp(pp->tx, cp->tx)) {		

#line 971 "hbcont.ctr"
        nkw = 1;
	fputs(hbcont_c8_kw[57], job->of);
      }
    } else {
      nkw = 1;
    }
    if(nkw) {
      fputs(hbcont_c8_kw[54], job->of);
      if(!hbhtml_output_for_text(job, cp->tx)) { back = 0; }
      fputs(hbcont_c8_kw[55], job->of);
      fputs(hbcont_c8_kw[56], job->of);
    }
    fputs(hbcont_c8_kw[58], job->of);
    fputs(hbcont_c8_kw[60], job->of);
    if(!hbhtml_url_output_for_text(job, cp->fn)) { back = 0; }
    fputs(hbcont_c8_kw[61], job->of);
    if(!hb_index_write_anchor(job, cp)) { back = 0; }
#if (!(VERSION_BEFORE_20140412))
    fputs(hbcont_c8_kw[25], job->of);
    (void)hbtool_write_all_titles(job, cp->no, 1);
#endif
    fputs(hbcont_c8_kw[46], job->of);
    if(cp->no) {
      if((cp->no)->title) {
#if (!(VERSION_BEFORE_20140412))
	if ((job->options) & HB_JOB_OPT_NUM_IN_IDX) {
	  if (hbtool_write_header_number(job, cp->no)) {
	    hbhtml_output_for_text(job, dkT(" "));
	  }
	}
#endif
        if(!hbhtml_output_for_text(job, (cp->no)->title)) { back = 0; }
      } else back = 0;
    } else { back = 0; }
    fputs(hbcont_c8_kw[27], job->of);
    fputs(hbcont_c8_kw[59], job->of);
    pp = cp; pstc = cstc;
  }
  if(hh2) {
    fputs(hbcont_c8_kw[57], job->of);
    fputs(hbcont_c8_kw[53], job->of);
    fputs(hbcont_c8_kw[30], job->of);
    fputs(hbcont_c8_kw[0], job->of);
  } 

#line 1015 "hbcont.ctr"
  return back;
}



int
hbcont_process(hb_job_t *job, hb_node_t *p, hb_node_t *n)
{
  hb_contents_line_processor_t	 proc;
  dkChar const			*oldsourcefile;
  unsigned long			 oldsourceline;
  int				 back = 0;
  

#line 1028 "hbcont.ctr"
  oldsourcefile = dk3app_get_source_file(job->app);
  oldsourceline = dk3app_get_source_line(job->app);
  proc.job = job;
  proc.nptr = job->currentnode;
  proc.lineno = 0UL;
  proc.nheader = 0UL;
  proc.maxheader = 0;

  dk3app_set_source_file(job->app, job->infilename);
  dk3app_set_source_line(job->app, (job->currentnode)->lineno);
  if(hbcont_prepare(job)) {
    dk3app_set_source_file(job->app, (job->currentnode)->filename);
    dk3app_set_source_line(job->app, 0UL);
    if(hbcont_read(job, &proc)) {
      back = 1;

      /*	For the root node we do not write a position.
      */
      if((0UL != (job->currentnode)->objno) && ((job->currentnode)->filename)) {
        if(!((job->options) & HB_JOB_OPT_CHM)) {
          if(((job->currentnode)->options) & HB_NODE_OPT_HEADER_CHAIN) {
            dk3app_set_source_file(job->app, job->infilename);
            if(!hbcont_write_position(job)) { back = 0; }
          }
	}
      }

      dk3app_set_source_file(job->app, job->infilename);
      dk3app_set_source_line(job->app, (job->currentnode)->lineno);
      if(!hbcont_write_title(job)) { back = 0; }

      /*	We can write contents only if an input file is specified.
      */
      if((job->currentnode)->filename) {
        dk3app_set_source_file(job->app, (job->currentnode)->filename);
        dk3app_set_source_line(job->app, 0UL);
        if(!hbcont_write_contents(job, &proc, p, n)) { back = 0; }
  
        dk3app_set_source_file(job->app, (job->currentnode)->filename);
        dk3app_set_source_line(job->app, 0UL);
        if((job->currentnode)->nextlink) {
          if(!hbcont_write_link_list(job)) { back = 0; }
        }
      }

      if(0UL == (job->currentnode)->objno) {	

#line 1074 "hbcont.ctr"
        if(!((job->options) & HB_JOB_OPT_CHM)) {
	  if((job->options) & HB_JOB_OPT_CREATE_TOC) {	

#line 1076 "hbcont.ctr"
	    if(!hbcont_create_toc(job)) { back = 0; }
	  }
	  if((job->options) & HB_JOB_OPT_CREATE_INDEX) { 

#line 1079 "hbcont.ctr"
	    /* Eventually create index */
	    if(!hbcont_create_keyword_index(job)) { back = 0; }
	  }
	}
      }
    }
    dk3app_set_source_file(job->app, job->infilename);
    dk3app_set_source_line(job->app, (job->currentnode)->lineno);
  }
  hbcont_cleanup(job);
  dk3app_set_source_file(job->app, oldsourcefile);
  dk3app_set_source_line(job->app, oldsourceline);
  

#line 1092 "hbcont.ctr"
  return back;
}


