/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: hbconf.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file hbconf.h Header file for the hbconf module.
*/

#ifndef HBCONF_H_INCLUDED
/** Avoid multiple inclusions. */
#define HBCONF_H_INCLUDED 1


#line 9 "hbconf.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Read configuration files.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
hbconf_read_files(hb_job_t *job);

/**	Read one configuration file.
	@param	job	Job structure.
	@param	fn	Configuration file name.
	@return	1 on success, 0 on error.
*/
int
hbconf_read_one_file(hb_job_t *job, dkChar const *fn);

/**	Process one configuration line.
	@param	job	Job structure.
	@param	il	Input line to process, stored also in ilfile.
	@param	st	Section type.
	@return	1 on success, 0 on error (can continue), -1 on error (exit).
*/
int
hbconf_process_line(hb_job_t *job, dkChar *il, int st);

/**	Find template name for a node.
	@param	job	Job structure.
	@param	node	Node to find template for.
	@return	Template file name on success, NULL on error.
*/
dkChar const *
hbconf_node_template(hb_job_t *job, hb_node_t *node);

/**	Find icon file name.
	@param	job	Job structure.
	@param	node	Node to find icon for.
	@param	icno	Icon number (0=TOC, 1=previous, 2=next, 3=index).
	@return	File name pointer.
*/
dkChar const *
hbconf_node_icon(hb_job_t *job, hb_node_t *node, int icno);

/**	Find title for current node.
	@param	node	Node to find title for.
	@return	Title on success, NULL on error.
*/
dkChar const *
hbconf_title(hb_node_t *node);

/**	Find CSS style file for current node.
	@param	node	Node to find style file for.
	@return	File name on success, NULL on error.
*/
dkChar const *
hbconf_stylefile(hb_node_t *node);

/**	Find author for current node.
	@param	node	Node to find author for.
	@return	Author name on success, NULL on error.
*/
dkChar const *
hbconf_author(hb_node_t *node);

/**	Find shortcut icon file name.
	@param	node	Node to find file name for.
	@return	File name on success, NULL on error.
*/
dkChar const *
hbconf_favicon(hb_node_t *node);

/**	Find location (city).
	@param	node	Node to find location for.
	@return	Location on success, NULL on error.
*/
dkChar const *
hbconf_location(hb_node_t *node);

#ifdef __cplusplus
}
#endif


#endif
