/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: hbconf.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file hbconf.c The hbconf module.
*/


#line 95 "hbconf.ctr"

#include "dk3all.h"
#include "htmlbook.h"





#line 102 "hbconf.ctr"



/**	Names of configuration file options.
*/
dkChar const * const	hbconf_options[] = {
/* 0 */
dkT("author"),

/* 1 */
dkT("title"),

/* 2 */
dkT("url"),

/* 3 */
dkT("output directory"),

/* 4 */
dkT("output script"),

/* 5 */
dkT("html charset"),

/* 6 */
dkT("template"),

/* 7 */
dkT("style"),

/* 8 */
dkT("page toc"),

/* 9 */
dkT("index file"),

/* 10 */
dkT("create index"),

/* 11 */
dkT("replace ampersand"),

/* 12 */
dkT("tidy"),

/* 13 */
dkT("location"),

/* 14 */
dkT("write position"),

/* 15 */
dkT("navigation"),

/* 16 */
dkT("short"),

/* 17 */
dkT("file"),

/* 18 */
dkT("suffix"),

/* 19 */
dkT("icon toc"),

/* 20 */
dkT("icon previous"),

/* 21 */
dkT("icon next"),

/* 22 */
dkT("icon index"),

/* 23 */
dkT("create toc"),

/* 24 */
dkT("shortcut icon"),

/* 25 */
dkT("var"),

/* 26 */
dkT("impressum link"),

/* 27 */
dkT("impressum page"),

/* 28 */
dkT("chm"),

/* 29 */
dkT("ln"),

/* 30 */
dkT("input encoding"),

/* 31 */
dkT("chm language"),

/* 32 */
dkT("js file"),

/* 33 */
dkT("inherit js"),

/* 34 */
dkT("section numbers in position"),

/* 35 */
dkT("section numbers in index"),

/* 36 */
dkT("section numbers in page header"),

/* 37 */
dkT("context number"),

/* 38 */
dkT("chm full text search"),

/* 39 */
dkT("code line numbers"),

NULL


#line 270 "hbconf.ctr"
};



/**	Character sets for HTML output.
*/
dkChar const * const	hbconf_charsets[] = {
/* 0 */
dkT("utf-8"),

/* 1 */
dkT("ascii"),

/* 2 */
dkT("us-ascii"),

NULL


#line 282 "hbconf.ctr"
};



/**	Set jump node for the nodes parents.
	@param	nodeptr	Text node.
*/
static
void
hbconf_set_jump_node(hb_node_t *nodeptr)
{
  hb_node_t	*parent;	/* Parent node */
  int		 cc;		/* Flag: Can continue */
  

#line 296 "hbconf.ctr"
  parent = nodeptr->parent;
  cc = 1;
  while(cc) {
    if(parent) {
      if(parent->jumpnode) {
        cc = 0;
      } else {
        if(-1 != parent->indent) {
          parent->jumpnode = nodeptr;
	  parent = parent->parent;
	} else {
	  cc = 0;
	}
      }
    } else {
      cc = 0;
    }
  } 

#line 314 "hbconf.ctr"
}



/**	Process one configuration line from configuration file.
	@param	job	Job structure.
	@param	il	Input line to process.
	@param	st	Current section type.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
int
hbconf_process_line(hb_job_t *job, dkChar *il, int st)
{
  dk3_key_value_t	*kvp;		/* New key value pair */
  hb_link_t		*linkptr;	/* New data for JS file */
  dkChar		*kp;		/* Key */
  dkChar		*vp;		/* Value */
  dkChar		*ap;		/* Argument */
  dkChar		*nc;		/* New text for existing key/value */
  dkChar		*ptr;		/* Traverse string */
  int			 newie;		/* Input encoding */
  int			 back	= 1;
  

#line 337 "hbconf.ctr"
  kp = dk3str_start(il, NULL);
  if(kp) {
    if(dkT('#') != *kp) {
      vp = dk3str_chr(kp, dkT('='));
      if(vp) {
        *(vp++) = dkT('\0');
	vp = dk3str_start(vp, NULL);
	if(vp) {
	  dk3str_normalize(kp, NULL, dkT(' '));
	  dk3str_chomp(vp, NULL);
	  switch(dk3str_array_index(hbconf_options, kp, 0)) {
	    case  0: {		/* author */
	      if(job->currentnode) {
	        ptr = dk3str_dup_app(vp,job->app);
		if(ptr) {
		  if((job->currentnode)->author) {
		    if(0UL != (job->currentnode)->objno) {
		      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 69);
		    }
		  }
		  dk3_release((job->currentnode)->author);
		  (job->currentnode)->author = ptr;
		} else {
		  back = -1;	/* REPORTED */
		}
	      }
	    } break;
	    case  1: {		/* title */
	      if(job->currentnode) {
	        ptr = dk3str_dup_app(vp,job->app);
		if(ptr) {
		  if((job->currentnode)->title) {
		    if(0UL != (job->currentnode)->objno) {
		      /* Overwriting title */
		      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 70);
		    }
		  }
		  dk3_release((job->currentnode)->title);
		  (job->currentnode)->title = ptr;
		} else {
		  back = -1;	/* REPORTED */
		}
	      }
	    } break;
	    case  2: {		/* url */
	      if(HB_SECTION_OPTIONS == st) {
	        ptr = dk3str_dup_app(vp,job->app);
	        if(ptr) {
	          dk3_release(job->url);
		  job->url = ptr;
	        } else {
	          back = -1;	/* REPORTED */
	        }
	      } else {
	        /* ERROR: Only allowed in options section */
		dk3app_log_1(job->app,DK3_LL_ERROR,job->msg,38);
		back = -1;
	      }
	    } break;
	    case  3: {		/* output directory */
	      if(HB_SECTION_OPTIONS == st) {
	        ptr = dk3str_dup_app(vp,job->app);
	        if(ptr) {
		  dk3str_correct_filename(ptr);
		  if(job->outputdir) {
		    /* Overwrite output directory */
		    dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 71);
		  }
	          dk3_release(job->outputdir);
		  job->outputdir = ptr;
		  /* CHECK FILENAME CHARACTERS */
		  if(!hbtool_check_filename_encoding(job, ptr)) {
		    back = -1;
		  }
	        } else {
	          back = -1;	/* REPORTED */
	        }
	      } else {
	        /* ERROR: Only allowed in options section */
		dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 10);
	      }
	    } break;
	    case  4: {		/* output script */
	      if(HB_SECTION_OPTIONS == st) {
	        ptr = dk3str_dup_app(vp,job->app);
	        if(ptr) {
		  if(job->outputscript) {
		    /* Overwrite output script */
		    dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 72);
		  }
	          dk3_release(job->outputscript);
		  job->outputscript = ptr;
		  /* CHECK FILENAME CHARACTERS */
		  if(!hbtool_check_filename(job, ptr)) {
		    back = -1;
		  }
	        } else {
	          back = -1;	/* REPORTED */
	        }
	      } else {
	        /* ERROR: Only allowed in options section */
		dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 10);
	      }
	    } break;
	    case  5: {		/* html charset */
	      if(job->currentnode) {
	        switch(dk3str_array_index(hbconf_charsets, vp, 0)) {
		  case 0: {
		    job->cs = HB_CS_UTF_8;
		  } break;
		  case 1: case 2: {
		    job->cs = HB_CS_ASCII;
		  } break;
		  default: {
		    /* WARNING: Unknown charset! */
		    dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 11);
		  } break;
		}
	      }
	    } break;
	    case  6: {		/* template */
	      if(job->currentnode) {
	        ptr = dk3str_dup_app(vp,job->app);
		if(ptr) {
		  dk3str_correct_filename(ptr);
		  if((job->currentnode)->template) {
		    if(0UL != (job->currentnode)->objno) {
		      /* Overwriting template */
		      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 73);
		    }
		  }
		  dk3_release((job->currentnode)->template);
		  (job->currentnode)->template = ptr;
		} else {
		  back = -1;	/* REPORTED */
		}
	      }
	    } break;
	    case  7: {		/* style */
	      if(job->currentnode) {
	        ptr = dk3str_dup_app(vp,job->app);
		if(ptr) {
		  dk3str_correct_filename(ptr);
		  if(!hbtool_check_filename(job, ptr)) { back = -1; }
		  if((job->currentnode)->stylefile) {
		    if(0UL != (job->currentnode)->objno) {
		      /* Overwriting style */
		      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 74);
		    }
		  }
		  dk3_release((job->currentnode)->stylefile);
		  (job->currentnode)->stylefile = ptr;
		} else {
		  back = -1;	/* REPORTED */
		}
	      }
	    } break;
	    case  8: {		/* page toc */
	      if(job->currentnode) {
	        if(dk3str_is_bool(vp)) {
		  if(dk3str_is_on(vp)) {
		    (job->currentnode)->options =
		    ((job->currentnode)->options) | HB_NODE_OPT_PAGE_TOC;
		  } else {
		    (job->currentnode)->options =
		    ((job->currentnode)->options) & (~(HB_NODE_OPT_PAGE_TOC));
		  }
		} else {
		  /* WARNING: Not a boolean value! */
		  dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 144, vp);
		}
	      }
	    } break;
	    case  9: {		/* toc file */
	      if(HB_SECTION_OPTIONS == st) {
	        if(job->rootnode) {
	          ptr = dk3str_dup_app(vp,job->app);
		  if(ptr) {
		    dk3str_correct_filename(ptr);
		    if(!hbtool_check_filename(job, ptr)) { back = -1; }
		    dk3_release((job->rootnode)->filename);
		    (job->rootnode)->filename = ptr;
		  } else {
		    back = -1;	/* REPORTED */
		  }
	        }
	      } else {
	        /* ERROR: Only allowed in options section */
		dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 10);
	      }
	    } break;
	    case 10: {		/* create index */
	      if(HB_SECTION_OPTIONS == st) {
	        if(dk3str_is_bool(vp)) {
	          if(dk3str_is_on(vp)) {
		    job->options = (job->options) | HB_JOB_OPT_CREATE_INDEX;
		  } else {
		    job->options = (job->options) & (~(HB_JOB_OPT_CREATE_INDEX));
		  }
	        } else {
	          /* WARNING: Not a boolean */
		  dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 144, vp);
	        }
	      } else {
	        /* ERROR: Only allowed in options section */
		dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 10);
	      }
	    } break;
	    case 11: {		/* replace ampersand */
	      if(job->currentnode) {
	        if(dk3str_is_bool(vp)) {
		  if(dk3str_is_on(vp)) {
		    (job->currentnode)->options =
		    ((job->currentnode)->options)
		    | HB_NODE_OPT_REPLACE_AMPERSAND;
		  } else {
		    (job->currentnode)->options =
		    ((job->currentnode)->options)
		    & (~(HB_NODE_OPT_REPLACE_AMPERSAND));
		  }
		} else {
		  /* WARNING: Not a boolean. */
		  dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 144, vp);
		}
	      }
	    } break;
	    case 12: {		/* use tidy */
	      if(job->currentnode) {
	        if(dk3str_is_bool(vp)) {
		  if(dk3str_is_on(vp)) {
		    (job->currentnode)->options =
		    ((job->currentnode)->options)
		    | HB_NODE_OPT_USE_TIDY;
		  } else {
		    (job->currentnode)->options =
		    ((job->currentnode)->options)
		    & (~(HB_NODE_OPT_USE_TIDY));
		  }
		} else {
		  /* WARNING: Not a boolean. */
		  dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 144, vp);
		}
	      }
	    } break;
	    case 13: {		/* location */
	      if(job->currentnode) {
	        ptr = dk3str_dup_app(vp,job->app);
		if(ptr) {
		  dk3_release((job->currentnode)->location);
		  (job->currentnode)->location = ptr;
		} else {
		  back = -1;	/* REPORTED */
		}
	      }
	    } break;
	    case 14: {		/* write header chain */
	      if(job->currentnode) {
	        if(dk3str_is_bool(vp)) {
		  if(dk3str_is_on(vp)) {
		    (job->currentnode)->options =
		    ((job->currentnode)->options)
		    | HB_NODE_OPT_HEADER_CHAIN;
		  } else {
		    (job->currentnode)->options =
		    ((job->currentnode)->options)
		    & (~(HB_NODE_OPT_HEADER_CHAIN));
		  }
		} else {
		  /* WARNING: Not a boolean */
		  dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 144, vp);
		}
	      }
	    } break;
	    case 15: {		/* navigation */
	      /* navigation is now configured via arguments to special cmd */
	    } break;
	    case 16: {		/* short */
	      if(job->currentnode) {
	        ptr = dk3str_dup_app(vp,job->app);
		if(ptr) {
		  if((job->currentnode)->shorttitle) {
		    if(0UL != (job->currentnode)->objno) {
		      /* Overwriting short */
		      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 75);
		    }
		  }
		  dk3_release((job->currentnode)->shorttitle);
		  (job->currentnode)->shorttitle = ptr;
		} else {
		  back = -1;	/* REPORTED */
		}
	      }
	    } break;
	    case 17: {		/* file */
	      if(job->currentnode) {
	        ptr = dk3str_dup_app(vp,job->app);
		if(ptr) {
		  dk3str_correct_filename(ptr);
		  if(!hbtool_check_filename(job, ptr)) { back = -1; }
		  if((job->currentnode)->filename) {
		    if(0UL != (job->currentnode)->objno) {
		      /* Overwriting file */
		      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 76);
		    }
		  }
		  dk3_release((job->currentnode)->filename);
		  (job->currentnode)->filename = ptr;
		  hbconf_set_jump_node(job->currentnode);
		  if(!(dk3sto_it_find_like(job->i_pnodes,job->currentnode,0))) {
		    if(!(dk3sto_add(job->s_pnodes, job->currentnode))) {
		      back = -1;	/* REPORTED */
		    }
		  }
		} else {
		  back = -1;		/* REPORTED */
		}
	      }
	    } break;
	    case 18: {		/* suffix */
	      if(job->currentnode) {
	        ptr = dk3str_dup_app(vp,job->app);
		if(ptr) {
		  if((job->currentnode)->suffix) {
		    if(0UL != (job->currentnode)->objno) {
		      /* Overwriting suffix */
		      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 77);
		    }
		  }
		  dk3_release((job->currentnode)->suffix);
		  (job->currentnode)->suffix = ptr;
		  /* CHECK FILENAME CHARACTERS */
		  if(!hbtool_check_filename_encoding(job, ptr)) { back = -1; }
		} else {
		  back = -1;		/* REPORTED */
		}
	      }
	    } break;
	    case 19: {
	      if(job->currentnode) {
	        ptr = dk3str_dup_app(vp,job->app);
		if(ptr) {
		  dk3str_correct_filename(ptr);
		  if(!hbtool_check_filename(job, ptr)) { back = -1; }
		  if((job->currentnode)->icontoc) {
		    if(0UL != (job->currentnode)->objno) {
		      /* Overwriting icon toc */
		      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 78);
		    }
		  }
		  dk3_release((job->currentnode)->icontoc);
		  (job->currentnode)->icontoc = ptr;
		  /* CHECK FILENAME CHARACTERS */
		} else {
		  back = -1;		/* REPORTED */
		}
	      }
	    } break;
	    case 20: {
	      if(job->currentnode) {
	        ptr = dk3str_dup_app(vp,job->app);
		if(ptr) {
		  dk3str_correct_filename(ptr);
		  if(!hbtool_check_filename(job, ptr)) { back = -1; }
		  if((job->currentnode)->iconprev) {
		    if(0UL != (job->currentnode)->objno) {
		      /* Overwriting icon previous */
		      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 79);
		    }
		  }
		  dk3_release((job->currentnode)->iconprev);
		  (job->currentnode)->iconprev = ptr;
		  /* CHECK FILENAME CHARACTERS */
		} else {
		  back = -1;		/* REPORTED */
		}
	      }
	    } break;
	    case 21: {
	      if(job->currentnode) {
	        ptr = dk3str_dup_app(vp,job->app);
		if(ptr) {
		  dk3str_correct_filename(ptr);
		  if(!hbtool_check_filename(job, ptr)) { back = -1; }
		  if((job->currentnode)->iconnext) {
		    if(0UL != (job->currentnode)->objno) {
		      /* Overwriting icon next */
		      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 80);
		    }
		  }
		  dk3_release((job->currentnode)->iconnext);
		  (job->currentnode)->iconnext = ptr;
		  /* CHECK FILENAME CHARACTERS */
		} else {
		  back = -1;		/* REPORTED */
		}
	      }
	    } break;
	    case 22: {
	      if(job->currentnode) {
	        ptr = dk3str_dup_app(vp,job->app);
		if(ptr) {
		  dk3str_correct_filename(ptr);
		  if(!hbtool_check_filename(job, ptr)) { back = -1; }
		  if((job->currentnode)->iconindex) {
		    if(0UL != (job->currentnode)->objno) {
		      /* Overwriting icon index */
		      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 81);
		    }
		  }
		  dk3_release((job->currentnode)->iconindex);
		  (job->currentnode)->iconindex = ptr;
		  /* CHECK FILENAME CHARACTERS */
		} else {
		  back = -1;		/* REPORTED */
		}
	      }
	    } break;
	    case 23: {
	      if(dk3str_is_bool(vp)) {
	        if(dk3str_is_on(vp)) {
		  job->options = ((job->options) | HB_JOB_OPT_CREATE_TOC);
		} else {
		  job->options = ((job->options) & (~(HB_JOB_OPT_CREATE_TOC)));
		}
	      } else {
	        /* Warning: Not a boolean! */
		dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, vp);
	      }
	    } break;
	    case 24: {
	        if(job->currentnode) {
		  ptr = dk3str_dup_app(vp,job->app);
		  if(ptr) {
		    dk3str_correct_filename(ptr);
		    hbtool_correct_backslash_to_slash(ptr);
		    if((job->currentnode)->favicon) {
		      if(0UL != (job->currentnode)->objno) {
		        /* Overwriting shortcut icon */
		        dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 82);
		      }
		    }
		    dk3_release((job->currentnode)->favicon);
		    (job->currentnode)->favicon = ptr;
		    /* ADD TO LIST OF ADDITIONAL FILES */
		    if (!(hbtool_add_file(job, ptr))) {
		      back = -1;
		    }
		    /* CHECK FILENAME CHARACTERS */
		    if(!hbtool_check_filename_encoding(job, ptr)) { back = -1; }
		  } else {
		    back = -1;	/* REPORTED */
		  }
		}
	    } break;
	    case 25: {			

#line 792 "hbconf.ctr"
	      if(job->currentnode) {	

#line 793 "hbconf.ctr"
		ap = dk3str_next(vp, NULL);
		if(ap) {		

#line 795 "hbconf.ctr"
		  kvp = dk3sto_it_find_like(
		    (job->currentnode)->i_variables, vp, 1
		  );
		  if(kvp) {		

#line 799 "hbconf.ctr"
		    nc = dk3str_dup_app(ap, job->app);
		    if(nc) {		

#line 801 "hbconf.ctr"
		      if(kvp->val) {
		        if(0UL != (job->currentnode)->objno) {
		          /* Overwriting var */
		          dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 83);
		        }
		      }
		      dk3_release(kvp->val);
		      kvp->val = nc;
		    } else {		

#line 810 "hbconf.ctr"
		      back = -1;	/* REPORTED */
		    }
		  } else {		

#line 813 "hbconf.ctr"
		    kvp = dk3kv_new_app(vp, ap, job->app);
		    if(kvp) {		

#line 815 "hbconf.ctr"
		      if(!(dk3sto_add((job->currentnode)->s_variables, kvp))) {
		        dk3kv_delete(kvp);	

#line 817 "hbconf.ctr"
			back = -1;	/* REPORTED */
		      }
		    } else {		

#line 820 "hbconf.ctr"
		      back = -1;	/* REPORTED */
		    }
		  }
		} else {		

#line 824 "hbconf.ctr"
		  kvp = dk3sto_it_find_like(
		    (job->currentnode)->i_variables, vp, 1
		  );
		  if(kvp) {		

#line 828 "hbconf.ctr"
		    dk3sto_remove((job->currentnode)->s_variables, kvp);
		    dk3kv_delete(kvp);
		  }
		}
	      } else {			

#line 833 "hbconf.ctr"
	      }
	    } break;
	    case 26: {			

#line 836 "hbconf.ctr"
	      if(HB_SECTION_OPTIONS == st) {
	        ptr = dk3str_dup_app(vp, job->app);
	        if(ptr) {
	          dk3_release(job->impressumlink);
		  job->impressumlink = ptr;
	        } else {
	          back = -1;	/* REPORTED */
	        }
	      } else {
	        /* ERROR: Only allowed in options section */
		dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 10);
	      }
	    } break;
	    case 27: {			

#line 850 "hbconf.ctr"
	      if(HB_SECTION_OPTIONS == st) {	

#line 851 "hbconf.ctr"
	        job->impressumnode = hb_node_new(
		  job, job->rootnode, job->lineno, job->nextobj, 0
		);
		job->nextobj += 1UL;
		if(job->impressumnode) {	

#line 856 "hbconf.ctr"
		  if((job->impressumnode)->depth > job->maxdepth) {
		    job->maxdepth = (job->impressumnode)->depth;
		  }
		  (job->impressumnode)->options |= HB_NODE_OPT_IMPRESSUM;
		  if(dk3sto_add(job->s_nodes, (void *)(job->impressumnode))) {
		    

#line 862 "hbconf.ctr"
		    (job->impressumnode)->title =
		    dk3str_dup_app((job->msg)[0], job->app);
		    if((job->impressumnode)->title) {	

#line 865 "hbconf.ctr"
		      dk3str_correct_filename(vp);
		      if(!hbtool_check_filename(job, vp)) { back = -1; }
		      /* CHECK FILENAME CHARACTERS */
		      (job->impressumnode)->filename =
		      dk3str_dup_app(vp, job->app);
		      if(!((job->impressumnode)->filename)) {
		        back = -1;
		      }
		    } else {				

#line 874 "hbconf.ctr"
		      back = -1;	/* REPORTED */
		    }
		    if(1 == back) {			

#line 877 "hbconf.ctr"
		      if(!dk3sto_add(job->s_pnodes,(void*)(job->impressumnode)))
		      {	

#line 879 "hbconf.ctr"
		        back = -1;	/* REPORTED */
		      }
		    }
		  } else {			

#line 883 "hbconf.ctr"
		    hb_node_delete(job->impressumnode);
		    job->impressumnode = NULL;
		    back = -1;		/* REPORTED */
		  }
		} else {			

#line 888 "hbconf.ctr"
		  back = -1;		/* REPORTED */
		}
	      } else {			

#line 891 "hbconf.ctr"
	        /* ERROR: Only allowed in options section */
		dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 10);
	      }
	    } break;
	    case 28: {
	      if(HB_SECTION_OPTIONS == st) {
	        if(dk3str_is_bool(vp)) {
	          if(dk3str_is_on(vp)) {
		    job->options |= HB_JOB_OPT_CHM;
		  } else {
		    job->options &= (~(HB_JOB_OPT_CHM));
		  }
	        } else {
	          /* Warning: Not a boolean */
		  dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, vp);
	        }
	      } else {
	        /* ERROR: Only allowed in options section */
		dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 10);
	      }
	    } break;
	    case 29: {
	      if(HB_SECTION_OPTIONS == st) {
		if(dk3str_is_bool(vp)) {
		  if(dk3str_is_on(vp)) {
		    job->options |= HB_JOB_OPT_LN;
		  } else {
		    job->options &= (~(HB_JOB_OPT_LN));
		  }
		} else {
		  /* Warning: Not a boolean */
		  dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, vp);
		}
	      } else {
	        /* ERROR: Only allowed in options section */
		dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 10);
	      }
	    } break;
	    case 30: {
	      newie = dk3enc_get_text_encoding_app(vp, NULL);
	      if(0 <= newie) {
	        if(HB_SECTION_OPTIONS == st) {
		  job->iecmd = newie;
		  (job->rootnode)->inenc = newie;
		}
		(job->currentnode)->inenc = newie;
	      } else {
	        if(dk3str_casecmp((job->kwnl)[25], vp) == 0) {
		  if(HB_SECTION_OPTIONS == st) {
		    job->iecmd = -1;
		    (job->rootnode)->inenc = -1;
		  }
		  (job->currentnode)->inenc = -1;
		} else {
		  back = 0;
		  dk3app_log_i3(job->app, DK3_LL_ERROR, 129, 130, vp);
		}
	      }
	    } break;
	    case 31: {
	      if(HB_SECTION_OPTIONS == st) {
	        ptr = dk3str_dup_app(vp, job->app);
		if(ptr) {
		  dk3_release(job->chmlang);
		  job->chmlang = ptr;
		} else {
		  back = -1;
		}
	      } else {
	        /* ERROR: Only allowed in options section */
		dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 10);
	      }
	    } break;
	    case 32: {	/* js file */
	      if((job->currentnode) && (vp)) {
	        if(!((job->currentnode)->s_jsfiles)) {
		  (job->currentnode)->s_jsfiles =
		  dk3sto_open_app(job->app);
		  if((job->currentnode)->s_jsfiles) {
		    dk3sto_set_comp(
		      (job->currentnode)->s_jsfiles,
		      hbnode_link_compare, 2
		    );
		  }
		}
		if(!((job->currentnode)->i_jsfiles)) {
		  if((job->currentnode)->s_jsfiles) {
		    (job->currentnode)->i_jsfiles = dk3sto_it_open(
		      (job->currentnode)->s_jsfiles
		    );
		  }
		}
		if((job->currentnode)->s_jsfiles) {
		  if((job->currentnode)->i_jsfiles) {
		    linkptr = hbnode_link_new(
		      vp, (job->currentnode)->nextjs, job->app
		    );
		    if(linkptr) {
		      if(dk3sto_add((job->currentnode)->s_jsfiles, linkptr)) {
		        (job->currentnode)->nextjs += 1UL;
		      } else {
		        hbnode_link_delete(linkptr);
		      }
		    } else {
		      back = -1;
		    }
		  } else {
		    back = -1;
		  }
		} else {
		  back = -1;
		}
	      }
	      if(vp) {
	        if(!hbtool_add_url(job, vp)) { back = -1; }
	      }
	    } break;
	    case 33: {	/* inherit js */
	      if(vp) {
	        if(dk3str_is_bool(vp)) {
		  if(dk3str_is_on(vp)) {
		    (job->currentnode)->options &=
		    (~(HB_NODE_OPT_STOP_JS_INHERITANCE));
		  } else {
		    (job->currentnode)->options |=
		    HB_NODE_OPT_STOP_JS_INHERITANCE;
		  }
		} else {
		  /* Warning: Not a boolean */
		  dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, vp);
		}
	      } else {
	        if(job->currentnode) {
		  (job->currentnode)->options &=
		  (~(HB_NODE_OPT_STOP_JS_INHERITANCE));
		}
	      }
	    } break;
	    case 34: {	

#line 1030 "hbconf.ctr"
	      if (vp) {
	        if (dk3str_is_bool(vp)) {
		  if (dk3str_is_on(vp)) {
		    job->options |= HB_JOB_OPT_NUM_IN_POS;
		  } else {
		    job->options &= (~(HB_JOB_OPT_NUM_IN_POS));
		  }
		} else {
		  /* Warning: Not a boolean */
		  dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, vp);
		}
	      } else {
	        job->options |= HB_JOB_OPT_NUM_IN_POS;
	      }
	    } break;
	    case 35: {
	      if (vp) {
	        if (dk3str_is_bool(vp)) {
		  if (dk3str_is_on(vp)) {
		    job->options |= HB_JOB_OPT_NUM_IN_IDX;
		  } else {
		    job->options &= (~(HB_JOB_OPT_NUM_IN_IDX));
		  }
		} else {
		  dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, vp);
		}
	      } else {
	        job->options |= HB_JOB_OPT_NUM_IN_IDX;
	      }
	    } break;
	    case 36: {
	      if (vp) {
	        if (dk3str_is_bool(vp)) {
		  if (dk3str_is_on(vp)) {
		    job->options |= HB_JOB_OPT_NUM_IN_PAGE_HEADER;
		  } else {
		    job->options &= (~(HB_JOB_OPT_NUM_IN_PAGE_HEADER));
		  }
		} else {
		  dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, vp);
		}
	      } else {
	        job->options |= HB_JOB_OPT_NUM_IN_PAGE_HEADER;
	      }
	    } break;
	    case 37: {
	      long cn;
	      if (vp) {
#if VERSION_BEFORE_20140716
	        if (1 == dk3sf_sscanf3(vp, dkT("%ld"), &cn))
#else
		if (0 != dk3ma_l_from_string(&cn, vp, NULL))
#endif
		{
		  if (job->currentnode) {
		    (job->currentnode)->contnum = cn;
		  } else {
		    /* BUG: No current node set! */
		  }
		} else {
		  /* ERROR: Not a number */
		  dk3app_log_i1(job->app, DK3_LL_ERROR, 141);
		}
	      } else {
	        /* ERROR: No context number specified */
		dk3app_log_i3(job->app, DK3_LL_ERROR, 133, 134, kp);
	      }
	    } break;
	    case 38: {
	      if (vp) {
	        if (dk3str_is_bool(vp)) {
		  if (dk3str_is_on(vp)) {
		    job->options |= HB_JOB_OPT_CHM_FULL_TEXT_SEARCH;
		  } else {
		    job->options &= (~(HB_JOB_OPT_CHM_FULL_TEXT_SEARCH));
		  }
		} else {
		  dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, vp);
		}
	      } else {
	        job->options |= HB_JOB_OPT_CHM_FULL_TEXT_SEARCH;
	      }
	    } break;
	    case 39: {
	      if (vp) {
	        if (dk3str_is_bool(vp)) {
		  if (dk3str_is_on(vp)) {
		    job->options |= HB_JOB_OPT_CODE_LINE_NUMBERS;
		  } else {
		    job->options &= (~(HB_JOB_OPT_CODE_LINE_NUMBERS));
		  }
		} else {
		  dk3app_log_i3(job->app, DK3_LL_WARNING, 146, 144, vp);
		}
	      } else {
	        job->options |= HB_JOB_OPT_CODE_LINE_NUMBERS;
	      }
	    } break;
	    default: {
	      dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 43, 44, kp);
	    } break;
	  }
	} else {
	  /* Warning: Syntax error! */
	  dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 9);
	}
      } else {
        /* Warning: Syntax error in configuration file */
	dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 8);
      }
    } else {			

#line 1141 "hbconf.ctr"
    }
  } else {			

#line 1143 "hbconf.ctr"
  }
  

#line 1145 "hbconf.ctr"
  return back;
}



/**	Line handler function to process a configuration file.
	@param	obj	Pointer to a job structure.
	@param	il	Input line to process.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
static
int
hbconf_line_reader_handler(void *obj, dkChar *il)
{
  int			back;
  

#line 1161 "hbconf.ctr"
  back = hbconf_process_line((hb_job_t *)obj, il, HB_SECTION_OPTIONS);
  

#line 1163 "hbconf.ctr"
  return back;
}



/**	Process one configuration file.
	@param	job	Job structure.
	@param	fn	File name to process.
	@return	1 on success, 0 on error (continue), -1 on error (exit).
*/
int
hbconf_read_one_file(hb_job_t *job, dkChar const *fn)
{
  int			back	= 0;
  

#line 1178 "hbconf.ctr"
  back = dk3stream_process_filename_lines_app(
    (void *)job, hbconf_line_reader_handler, fn,
    job->ilfile, job->bs,
    dk3app_get_encoding(job->app),
    dk3app_get_input_file_encoding(job->app),
    job->app
  );
  if(1 != back) { back = 0; /* REPORTED */ }
  

#line 1187 "hbconf.ctr"
  return back;
}



int
hbconf_read_files(hb_job_t *job)
{
  dk3_search_t		*sr = NULL;	/* File search result */
  dkChar const		*fn;		/* One config file name */
  int			 back = 1;
  

#line 1199 "hbconf.ctr"
  sr = dk3app_find_config_file(job->app, (job->kwnl)[3], 0);
  if(sr) {
    dk3search_reset(sr);
    while(NULL != (fn = dk3search_next(sr))) {
      if(back) {
        if(!hbconf_read_one_file(job, fn)) {
	  back = 0;	/* REPORTED */
	}
      }
    }
    dk3search_close(sr);
  } 

#line 1211 "hbconf.ctr"
  return back;
}



dkChar const *
hbconf_node_template(hb_job_t *job, hb_node_t *node)
{
  dkChar const	*back	= NULL;
  hb_node_t	*nptr;		/* Traverse node and parent nodes */
  

#line 1222 "hbconf.ctr"
  nptr = node;
  while((nptr) && (NULL == back)) {
    if(nptr->template) {
      back = nptr->template;
    } else {
      nptr = nptr->parent;
    }
  } 

#line 1230 "hbconf.ctr"
  return back;
}



dkChar const *
hbconf_node_icon(hb_job_t *job, hb_node_t *node, int icno)
{
  dkChar const	*back	= NULL;
  hb_node_t	*nptr;		/* Traverse node and parent nodes */
  

#line 1241 "hbconf.ctr"
  nptr = node;
  while((nptr) && (NULL == back)) {
    switch(icno) {
      case 0: {
        if(nptr->icontoc) {
	  back = nptr->icontoc;
	} else {
	  nptr = nptr->parent;
	}
      } break;
      case 1: {
        if(nptr->iconprev) {
	  back = nptr->iconprev;
	} else {
	  nptr = nptr->parent;
	}
      } break;
      case 2: {
        if(nptr->iconnext) {
	  back = nptr->iconnext;
	} else {
	  nptr = nptr->parent;
	}
      } break;
      default: {
        if(nptr->iconindex) {
	  back = nptr->iconindex;
	} else {
	  nptr = nptr->parent;
	}
      } break;
    }
  }
  if(!(back)) {
    back = (job->kwnl)[4 + icno];
  } 

#line 1277 "hbconf.ctr"
  return back;
}



dkChar const *
hbconf_title(hb_node_t *node)
{
  dkChar const	*back = NULL;
  

#line 1287 "hbconf.ctr"
  while((NULL == back) && (node)) {
    if(node->title) {
      back = node->title;
    } else {
      node = node->parent;
    }
  } 

#line 1294 "hbconf.ctr"
  return back;
}



dkChar const *
hbconf_stylefile(hb_node_t *node)
{
  dkChar const	*back = NULL;
  

#line 1304 "hbconf.ctr"
  while((NULL == back) && (node)) {
    if(node->stylefile) {
      back = node->stylefile;
    } else {
      node = node->parent;
    }
  } 

#line 1311 "hbconf.ctr"
  return back;
}



dkChar const *
hbconf_author(hb_node_t *node)
{
  dkChar const	*back = NULL;
  

#line 1321 "hbconf.ctr"
  while((NULL == back) && (node)) {
    if(node->author) {
      back = node->author;
    } else {
      node = node->parent;
    }
  } 

#line 1328 "hbconf.ctr"
  return back;
}



dkChar const *
hbconf_location(hb_node_t *node)
{
  dkChar const	*back = NULL;
  

#line 1338 "hbconf.ctr"
  while((NULL == back) && (node)) {
    if(node->location) {
      back = node->location;
    } else {
      node = node->parent;
    }
  } 

#line 1345 "hbconf.ctr"
  return back;
}



dkChar const *
hbconf_favicon(hb_node_t *node)
{
  dkChar const	*back = NULL;
  

#line 1355 "hbconf.ctr"
  while((NULL == back) && (node)) {
    if(node->favicon) {
      back = node->favicon;
    } else {
      node = node->parent;
    }
  } 

#line 1362 "hbconf.ctr"
  return back;
}


