/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: hbchm.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file hbchm.c The hbchm module.
*/


#line 34 "hbchm.ctr"


#include "dk3all.h"
#include "htmlbook.h"





#line 42 "hbchm.ctr"



/**	8-bit character keywords, not localized.
*/
static char const * const	hbchm_c8_kw[] = {
/* 0 */
"\r\n",

/* 1 */
"[OPTIONS]",

/* 2 */
"Compiled file=index.chm",

/* 3 */
"Contents file=contents.hhc",

/* 4 */
"Index file=index.hhk",

/* 5 */
"Compatibility=1.1 or later",

/* 6 */
"Display compile progress=Yes",

/* 7 */
"Language=",

/* 8 */
"Title=",

/* 9 */
"Default topic=",

/* 10 */
"0x409 English (USA)",

/* 11 */
"[FILES]",

/* 12 */
"[INFOTYPES]",

/* 13 */
"<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">",

/* 14 */
"<HTML>",

/* 15 */
"<HEAD>",

/* 16 */
"<meta name=\"GENERATOR\" content=\"Microsoft&reg; HTML Help Workshop 4.1\">",

/* 17 */
"<!-- Sitemap 1.0 -->",

/* 18 */
"</HEAD><BODY>",

/* 19 */
"<UL>",

/* 20 */
"</UL>",

/* 21 */
"</BODY></HTML>",

/* 22 */
"<LI><OBJECT type=\"text/sitemap\">",

/* 23 */
"\t<param name=\"Name\" value=\"",

/* 24 */
"\t<param name=\"Local\" value=\"",

/* 25 */
"\">",

/* 26 */
"#",

/* 27 */
"<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">",

/* 28 */
"<HTML>",

/* 29 */
"<HEAD>",

/* 30 */
"<meta name=\"GENERATOR\" content=\"Microsoft&reg; HTML Help Workshop 4.1\">",

/* 31 */
"<!-- Sitemap 1.0 -->",

/* 32 */
"</HEAD><BODY>",

/* 33 */
"<OBJECT type=\"text/site properties\">",

/* 34 */
"\t<param name=\"Window Styles\" value=\"0x800025\">",

/* 35 */
"\t<param name=\"ImageType\" value=\"Folder\">",

/* 36 */
"</OBJECT>",

/* 37 */
"</BODY></HTML>",

/* 38 */
"    ",

/* 39 */
"<LI><OBJECT type=\"text/sitemap\">",

/* 40 */
"    </OBJECT>",

/* 41 */
"        <param name=\"Name\" value=\"",

/* 42 */
"        <param name=\"Local\" value=\"",

/* 43 */
"<UL>",

/* 44 */
"</UL>",

/* 45 */
"<?xml version=\"1.0\" encoding=\"utf-8\"?>",

/* 46 */
"<CONFIG>",

/* 47 */
"</CONFIG>",

/* 48 */
"  <Files>",

/* 49 */
"  </Files>",

/* 50 */
"  <OtherFiles>",

/* 51 */
"  </OtherFiles>",

/* 52 */
"    <Count Value=\"0\"/>",

/* 53 */
"  <Windows>",

/* 54 */
"  </Windows>",

/* 55 */
"  <MergeFiles>",

/* 56 */
"  </MergeFiles>",

/* 57 */
"  <Settings>",

/* 58 */
"  </Settings>",

/* 59 */
"    <IndexFile Value=\"",

/* 60 */
"\"/>",

/* 61 */
"    <TOCFile Value=\"",

/* 62 */
"    <MakeBinaryTOC Value=\"False\"/>",

/* 63 */
"    <MakeBinaryIndex Value=\"True\"/>",

/* 64 */
"    <AutoFollowLinks Value=\"False\"/>",

/* 65 */
"    <MakeSearchable Value=\"True\"/>",

/* 66 */
"    <DefaultPage Value=\"index.html\"/>",

/* 67 */
"    <Title Value=\"",

/* 68 */
"    <OutputFileName Value=\"index.chm\"/>",

/* 69 */
"    <DefaultFont Value=\"\"/>",

/* 70 */
"    <DefaultWindow Value=\"\"/>",

/* 71 */
"    <ScanHtmlContents Value=\"True\"/>",

/* 72 */
"    <Count Value=\"%lu\"/>",

/* 73 */
"    <FileName%lu Value=\"",

/* 74 */
"\" ContextName=\"\" ContextNumber=\"0\"/>",

/* 75 */
"Test",

/* 76 */
"            <param name=\"ID\" value=\"%ld\">",

/* 77 */
"Binary TOC=No",

/* 78 */
"Binary Index=Yes",

/* 79 */
"Default Window=",

/* 80 */
"Default Font=",

/* 81 */
"Full-text search=Yes",

/* 82 */
"Auto Index=Yes",

/* 83 */
"Create CHI file=No",

/* 84 */
"Full text search stop list file=",

/* 85 */
"Display compile progress=Yes",

/* 86 */
"Display compile notes=Yes",

/* 87 */
"Full-text search=No",

NULL


#line 234 "hbchm.ctr"
};



int
hbchm_have_index_entries(hb_job_t *job)
{
  int		 back = 0;
  

#line 243 "hbchm.ctr"
  if ((job->i_index) && (job->s_index)) {
    dk3sto_it_reset(job->i_index);
    if(dk3sto_it_next(job->i_index)) { back = 1; }
  }
  

#line 248 "hbchm.ctr"
  return back;
}



/**	Write hhp file (project).
	@param	job		Job structure.
	@param	haveindex	Flag: Need to write an index file.
	@return	1 on success, 0 on error.
*/
static
int
hbchm_write_hhp(hb_job_t *job, int haveindex)
{
  dkChar	 fn[DK3_MAX_PATH];	/* Name of output file */
  dkChar	 of[DK3_MAX_PATH];	/* Output file name */
  dkChar const	*onefn;			/* Resource file name */
  hb_node_t	*nptr;			/* Root node or first node */
  int		 res;			/* Operation result */
  int		 back = 0;
  

#line 269 "hbchm.ctr"
  job->of = dk3sf_fopen_app((job->kwnl)[26], (job->kwnl)[30], job->app);
  if(job->of) {
    back = 1;
    /*	Write options section
    */
    fputs(hbchm_c8_kw[1], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[77], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[78], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[2], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[3], job->of); fputs(hbchm_c8_kw[0], job->of);
    if(haveindex) {
      fputs(hbchm_c8_kw[4], job->of); fputs(hbchm_c8_kw[0], job->of);
    }
    fputs(hbchm_c8_kw[79], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[80], job->of); fputs(hbchm_c8_kw[0], job->of);
    if ((job->options) & HB_JOB_OPT_CHM_FULL_TEXT_SEARCH) {
      fputs(hbchm_c8_kw[81], job->of);
    } else {
      fputs(hbchm_c8_kw[87], job->of);
    }
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[82], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[83], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[84], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[85], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[86], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[5], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[6], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[7], job->of);
    /* Language */
    if(job->chmlang) {
      res = dk3se_ansi_fputs(
        job->chmlang, dk3app_get_encoding(job->app), job->of, job->app
      );
      if(!(res)) { back = 0; }
    } else {
      fputs(hbchm_c8_kw[10], job->of);
    }
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[8], job->of);
    if (job->rootnode) {
      if ((job->rootnode)->title) {
        res = dk3se_ansi_fputs(
	  (job->rootnode)->title, dk3app_get_encoding(job->app),
	  job->of, job->app
	);
	if(!(res)) { back = 0; }
      } else {
        fputs(hbchm_c8_kw[75], job->of);
      }
    } else {
      fputs(hbchm_c8_kw[75], job->of);
    }
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[9], job->of);
    /* Default topic */
    nptr = job->rootnode;
    if(!(nptr->filename)) { nptr = nptr->jumpnode; }
    if(nptr) {
      if(hbhtml_create_output_filename(fn, DK3_SIZEOF(fn,dkChar), job, nptr)) {
        res = dk3se_ansi_fputs(
	  fn, dk3app_get_encoding(job->app), job->of, job->app
	);
	if(!(res)) { back = 0; }
      } else {
        back = 0;
      }
    } else {
      back = 0;
      /* ERROR: No default topic found! */
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 47);
    }
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    /*	Write files section - files mentioned explicitly
    */
    fputs(hbchm_c8_kw[11], job->of); fputs(hbchm_c8_kw[0], job->of);
    dk3sto_it_reset(job->i_files);
    while(NULL != (onefn = (dkChar const *)dk3sto_it_next(job->i_files))) {
      res = dk3se_ansi_fputs(
        onefn, dk3app_get_encoding(job->app), job->of, job->app
      );
      if(!(res)) { back = 0; }
      fputs(hbchm_c8_kw[0], job->of);
    }
#if (!(VERSION_BEFORE_20140416))
    /*	2014-04-16
	Write files section - HTML files not mentioned explicitly.
    */
    dk3sto_it_reset(job->i_pnodes);
    while (NULL != (nptr = (hb_node_t *)dk3sto_it_next(job->i_pnodes))) {
      if (!(nptr->jumpnode)) {
        if (hbhtml_create_output_filename(of,DK3_SIZEOF(of,dkChar),job,nptr)) {
          if (!(dk3sto_it_find_like(job->i_files, of, 0))) {
	    res = dk3se_ansi_fputs(
	      of, dk3app_get_encoding(job->app), job->of, job->app
	    );
	    if(!(res)) { back = 0; }
	    fputs(hbchm_c8_kw[0], job->of);
	  }
        }
      }
    }
#endif
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[12], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    if(!dk3sf_fclose_fn_app(job->of, (job->kwnl)[26], job->app)) { back = 0; }
  }
  if(!hbtool_add_file(job, (job->kwnl)[26])) { back = 0; }
  if(!hbtool_add_file(job, (job->kwnl)[28])) { back = 0; }
  if(haveindex) {
    if(!hbtool_add_file(job, (job->kwnl)[29])) { back = 0; }
  } 

#line 384 "hbchm.ctr"
  return back;
}



/**	Write hhc file (table of contents).
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbchm_write_hhc(hb_job_t *job)
{
  dkChar	 bu[DK3_MAX_PATH];	/* Name of output file */
  hb_node_t	*cnptr;			/* Current node to process */
  hb_node_t	*nnptr;			/* Next node to process */
  int		 i;			/* Used to print spaces */
  int		 res;			/* Operation result */
  int		 mwrn = 1;		/* Flag: Must write root node */
  int		 back = 0;
  

#line 405 "hbchm.ctr"
  job->of = dk3sf_fopen_app((job->kwnl)[28], (job->kwnl)[30], job->app);
  if(job->of) {
    back = 1;
    fputs(hbchm_c8_kw[27], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[28], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[29], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[30], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[31], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[32], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[33], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[34], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[35], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[36], job->of); fputs(hbchm_c8_kw[0], job->of);
    dk3sto_it_reset(job->i_nodes);
    while(NULL != (cnptr = (hb_node_t *)dk3sto_it_next(job->i_nodes))) {
      cnptr->tocstate = HB_TOC_STATE_INIT;
    }
    cnptr = job->rootnode;
    while(cnptr) {
      switch(cnptr->tocstate) {
        case HB_TOC_STATE_INIT: {
	  if(cnptr->parent) {
	    /* Write OBJECT for node */
	    for(i = 0;i < cnptr->depth;i++) { fputs(hbchm_c8_kw[38],job->of); }
	    fputs(hbchm_c8_kw[39],job->of); fputs(hbchm_c8_kw[0],job->of);
	    for(i = 0;i < cnptr->depth;i++) { fputs(hbchm_c8_kw[38],job->of); }
	    fputs(hbchm_c8_kw[41],job->of);
	    if(!hbhtml_output_for_text(job, cnptr->title)) { back = 0; }
	    fputs(hbchm_c8_kw[25],job->of);
	    fputs(hbchm_c8_kw[0],job->of);
	    if (0L != cnptr->contnum) {
	      fprintf(job->of, hbchm_c8_kw[76], cnptr->contnum);
	      fputs(hbchm_c8_kw[0],job->of);
	    }
	    if(cnptr->filename) {
	      res = hbhtml_create_output_filename(
	        bu, DK3_SIZEOF(bu,dkChar), job, cnptr
	      );
	      if(res) {
	        for(i = 0;i < cnptr->depth;i++) {
		  fputs(hbchm_c8_kw[38],job->of);
		}
		fputs(hbchm_c8_kw[42],job->of);
		if(!hbhtml_url_output_for_text(job, bu)) { back = 0; }
		fputs(hbchm_c8_kw[25],job->of);
		fputs(hbchm_c8_kw[0],job->of);
	      } else {
	        back = 0;
	      }
	    }
	    for(i = 0;i < cnptr->depth;i++) { fputs(hbchm_c8_kw[38],job->of); }
	    fputs(hbchm_c8_kw[40],job->of); fputs(hbchm_c8_kw[0],job->of);
	  } else {		

#line 458 "hbchm.ctr"
	  }
	  dk3sto_it_reset(cnptr->i_subnodes);
	  nnptr = (hb_node_t *)dk3sto_it_next(cnptr->i_subnodes);
	  if(nnptr) {
	    /* Write UL */
	    for(i = 0;i < cnptr->depth;i++) {
	      fputs(hbchm_c8_kw[38],job->of);
	    }
	    fputs(hbchm_c8_kw[43],job->of);
	    fputs(hbchm_c8_kw[0],job->of);
	    if (mwrn) {
	      mwrn = 0;
	      if ((!(cnptr->parent)) && (job->rootnode)) {
	        if (cnptr->objno == (job->rootnode)->objno) {
	          if (cnptr->filename) {
	            res = hbhtml_create_output_filename(
		      bu, DK3_SIZEOF(bu,dkChar), job, cnptr
		    );
		    if (res) {
		      fputs(hbchm_c8_kw[38],job->of);
	              fputs(hbchm_c8_kw[39],job->of);
	              fputs(hbchm_c8_kw[0],job->of);
		      fputs(hbchm_c8_kw[38],job->of);
		      fputs(hbchm_c8_kw[41],job->of);
		      /* Title */
		      if (cnptr->title) {
		        if(!hbhtml_output_for_text(job, cnptr->title)) {
			  back = 0;
			}
		      } else {
		        if(!hbhtml_output_for_text(job, (job->msg)[87])) {
		          back = 0;
		        }
		      }
		      fputs(hbchm_c8_kw[25],job->of);
		      fputs(hbchm_c8_kw[0],job->of);
		      fputs(hbchm_c8_kw[38],job->of);
		      fputs(hbchm_c8_kw[42],job->of);
		      /* File name */
		      if(!hbhtml_url_output_for_text(job, bu)) { back = 0; }
		      fputs(hbchm_c8_kw[25],job->of);
		      fputs(hbchm_c8_kw[0],job->of);
		      fputs(hbchm_c8_kw[38],job->of);
	              fputs(hbchm_c8_kw[40],job->of);
	              fputs(hbchm_c8_kw[0],job->of);
		    }
	          }
		}
	      }
	    }
	    cnptr->tocstate = HB_TOC_STATE_IN_PROGRESS;
	    cnptr = nnptr;
	  } else {
	    cnptr->tocstate = HB_TOC_STATE_FINISHED;
	    cnptr = cnptr->parent;
	  }
	} break;
	case HB_TOC_STATE_IN_PROGRESS: {
	  nnptr = (hb_node_t *)dk3sto_it_next(cnptr->i_subnodes);
	  if(nnptr) {
	    cnptr = nnptr;
	  } else {
	    /*  Write /UL */
	    for(i = 0;i < cnptr->depth;i++) {
	      fputs(hbchm_c8_kw[38],job->of);
	    }
	    fputs(hbchm_c8_kw[44],job->of);
	    fputs(hbchm_c8_kw[0],job->of);
	    cnptr->tocstate = HB_TOC_STATE_FINISHED;
	    cnptr = cnptr->parent;
	  }
	} break;
	case HB_TOC_STATE_FINISHED: {
	  cnptr = cnptr->parent;
	} break;
      }
    }
    fputs(hbchm_c8_kw[37], job->of); fputs(hbchm_c8_kw[0], job->of);
    if(!dk3sf_fclose_fn_app(job->of, (job->kwnl)[28], job->app)) { back = 0; }
  } 

#line 538 "hbchm.ctr"
  return back;
}



/**	Write hhk file (Keyword index).
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbchm_write_hhk(hb_job_t *job)
{
  hb_index_entry_t	*ie;		/* Current index entry to process */
  int		 	 back = 0;
  

#line 554 "hbchm.ctr"
  job->of = dk3sf_fopen_app((job->kwnl)[29], (job->kwnl)[30], job->app);
  if(job->of) {
    back = 1;
    fputs(hbchm_c8_kw[13], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[14], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[15], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[16], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[17], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[18], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[19], job->of); fputs(hbchm_c8_kw[0], job->of);
    dk3sto_it_reset(job->i_index);
    while(NULL != (ie = (hb_index_entry_t *)dk3sto_it_next(job->i_index))) {
      fputs(hbchm_c8_kw[22], job->of); fputs(hbchm_c8_kw[0], job->of);
      fputs(hbchm_c8_kw[23], job->of);
      if(!hbhtml_output_for_text(job, ie->tx)) { back = 0; }
      fputs(hbchm_c8_kw[25], job->of);
      fputs(hbchm_c8_kw[0], job->of);
      fputs(hbchm_c8_kw[24], job->of);
      if(ie->fn) {
        if(!hbhtml_url_output_for_text(job, ie->fn)) { back = 0; }
      }
      fputs(hbchm_c8_kw[26], job->of);
      if(!hb_index_write_anchor(job, ie)) { back = 0; }
      fputs(hbchm_c8_kw[25], job->of);
      fputs(hbchm_c8_kw[0], job->of);
      fputs(hbchm_c8_kw[40], job->of);
      fputs(hbchm_c8_kw[0], job->of);
    }
    fputs(hbchm_c8_kw[20], job->of); fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[21], job->of); fputs(hbchm_c8_kw[0], job->of);
    if(!dk3sf_fclose_fn_app(job->of, (job->kwnl)[29], job->app)) { back = 0; }
  } 

#line 586 "hbchm.ctr"
  return back;
}



/**	Write XML project file for chmcmd.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hbchm_write_xml(hb_job_t *job)
{
  dkChar		 of[DK3_MAX_PATH];	/* XML output file name */
  dkChar const		*fn;			/* File name in list */
  hb_node_t		*nptr;			/* Current node */
  unsigned long		 count;			/* Number of files in list */
  unsigned long		 cu;			/* Current file number */
  int			 back = 0;
  job->of = dk3sf_fopen_app((job->kwnl)[36], (job->kwnl)[30], job->app);
  if (job->of) {
    back = 1;
    /* xml */
    fputs(hbchm_c8_kw[45], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    /* CONFIG */
    fputs(hbchm_c8_kw[46], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    /* Files */
    fputs(hbchm_c8_kw[48], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    count = 0UL;
    cu = 0UL;
    dk3sto_it_reset(job->i_files);
    while (NULL != (fn = (dkChar const *)dk3sto_it_next(job->i_files))) {
      count++;
    }
    dk3sto_it_reset(job->i_pnodes);
    while (NULL != (nptr = (hb_node_t *)dk3sto_it_next(job->i_pnodes))) {
      if (!(nptr->jumpnode)) {
        if (hbhtml_create_output_filename(of,DK3_SIZEOF(of,dkChar),job,nptr)) {
	  if (!(dk3sto_it_find_like(job->i_files, of, 0))) {
	    count++;
	  }
	}
      }
    }
    fprintf(job->of, hbchm_c8_kw[72], count);
    fputs(hbchm_c8_kw[0], job->of);
    dk3sto_it_reset(job->i_files);
    while (NULL != (fn = (dkChar const *)dk3sto_it_next(job->i_files))) {
      fprintf(job->of, hbchm_c8_kw[73], cu++);
      if (!(hbtool_write_text_utf(job, fn))) { back = 0; }
      fputs(hbchm_c8_kw[74], job->of);
      fputs(hbchm_c8_kw[0], job->of);
    }
    dk3sto_it_reset(job->i_pnodes);
    while (NULL != (nptr = (hb_node_t *)dk3sto_it_next(job->i_pnodes))) {
      if (!(nptr->jumpnode)) {
        if (hbhtml_create_output_filename(of,DK3_SIZEOF(of,dkChar),job,nptr)) {
	  if (!(dk3sto_it_find_like(job->i_files, of, 0))) {
	    fprintf(job->of, hbchm_c8_kw[73], cu++);
	    if (!(hbtool_write_text_utf(job, of))) { back = 0; }
	    fputs(hbchm_c8_kw[74], job->of);
	    fputs(hbchm_c8_kw[0], job->of);
	  }
	}
      }
    }
    /* /Files */
    fputs(hbchm_c8_kw[49], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    /* OtherFiles */
    fputs(hbchm_c8_kw[50], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[52], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[51], job->of);
    fputs(hbchm_c8_kw[0], job->of);

    /* Windows */
    fputs(hbchm_c8_kw[53], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[52], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[54], job->of);
    fputs(hbchm_c8_kw[0], job->of);

    /* MergeFiles */
    fputs(hbchm_c8_kw[55], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[52], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[56], job->of);
    fputs(hbchm_c8_kw[0], job->of);

    /* Settings */
    fputs(hbchm_c8_kw[57], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    if ((job->options) & HB_JOB_OPT_CREATE_INDEX) {
      fputs(hbchm_c8_kw[59], job->of);
      if (!(hbtool_write_text_utf(job, (job->kwnl)[29]))) { back = 0; }
      fputs(hbchm_c8_kw[60], job->of);
      fputs(hbchm_c8_kw[0], job->of);
    }
    fputs(hbchm_c8_kw[61], job->of);
    if (!(hbtool_write_text_utf(job, (job->kwnl)[28]))) { back = 0; }
    fputs(hbchm_c8_kw[60], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[62], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[63], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[64], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[65], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[66], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[67], job->of);
    if (job->rootnode) {
      if ((job->rootnode)->title) {
        if (!(hbtool_write_text_utf(job, (job->rootnode)->title))) { back = 0; }
      }
    }
    fputs(hbchm_c8_kw[60], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[68], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[69], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[70], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[71], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    fputs(hbchm_c8_kw[58], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    /* /CONFIG */
    fputs(hbchm_c8_kw[47], job->of);
    fputs(hbchm_c8_kw[0], job->of);
    if(!dk3sf_fclose_fn_app(job->of, (job->kwnl)[36], job->app)) { back = 0; }
  } else {
  }
  return back;
}



int
hbchm_write_project(hb_job_t *job)
{
  int		 haveindex;	/* Flag: Must write index */
  int		 back = 1;
  

#line 740 "hbchm.ctr"
  haveindex = hbchm_have_index_entries(job);
  if(!hbchm_write_xml(job)) { back = 0; }
  if(!hbchm_write_hhp(job, haveindex)) { back = 0; }
  if(!hbchm_write_hhc(job)) { back = 0; }
  if(haveindex) {
    if(!hbchm_write_hhk(job)) { back = 0; }
  } 

#line 747 "hbchm.ctr"
  return back;
}


