/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: fig2lat.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file fig2lat.h Header file for the fig2lat module.
*/

#ifndef FIG2LAT_H_INCLUDED
/** Avoid multiple inclusions. */
#define FIG2LAT_H_INCLUDED 1


#line 10 "fig2lat.ctr"

#include "dk3fig.h"
#include "dk3figrd.h"
#include "dk3figpr.h"


/**	To draw a quadrant of a circle we do not use 1/3 of the
	derivative, we use another factor instead.
*/
#define	FIG2LAT_CIRCLE_QUADRANT_BEZIER	0.5522847498307932



/**	Conversion configuration.
*/
typedef struct {
  double	nts;	/**< Normal text size (scale factor or -1.0). */
  int		ntf;	/**< Normal text font (0=similar, 1=fig). */
} fig2lat_config_t;



/**	How to handle a text.
*/
typedef struct {
  double	fontSize;	/**< Font size in pt. */
  unsigned long	fontNumber;	/**< Unique font number for LaTeX output. */
  int		psFontNo;	/**< PS font number. */
} f2l_text_handling_t;



/**	Image structure.
*/
typedef struct {
  dk3_ufi_t	 	 ufi;		/**< Unique file identifier image. */
  char const		*filename;	/**< Image file name. */
  dk3_pdf_xobject_t	*xo;		/**< PDF X object. */
  dk3_bif_coord_t	 width;		/**< Image width. */
  dk3_bif_coord_t	 height;	/**< Image height. */
  double		 xres;		/**< X resolution. */
  double		 yres;		/**< Y resolution. */
  unsigned long		 imageNumber;	/**< Unique number of image. */
  unsigned long		 lineno;	/**< Line number of object. */
} f2l_image_t;



/**	Fig2lat job structure.
*/
typedef struct {
  /*	@DRIVER@
  	You can add driver-specific configuration compomenents here.
	For alignment reasons the order of elements is in decreasing
	type size.
	Remember to re-compile all modules after changing data types.
	Initialize the new components in fig2lat_job_init(),
	release allocated resources in fig2lat_job_end().
  */
  dk3_graphics_state_t	 gs;		/**< Graphics state. */
  dk3_ct_2d_t		 ct2d;		/**< Coordinates transformation data. */
  dk3_fig_drawing_t	*drw;		/**< Fig drawing to convert. */
  dk3_app_t		*app;		/**< Application structure. */
  dk3_option_set_t	*opt;		/**< Options and cmd arguments. */
  FILE			*of1;		/**< Output file 1. */
  FILE			*of2;		/**< Output file 2. */
  dkChar const		*on1;		/**< Output file name 1. */
  dkChar const		*on2;		/**< Output file name 2. */
  dkChar const * const	*msg;		/**< Localized text messages. */
  dkChar const * const	*figmsg;	/**< Localized messages dk3fig mod. */
  double		 width;		/**< Width (typically in bp). */
  double		 height;	/**< Height (typically in bp). */
  double		 w2;		/**< Secondary width information. */
  double		 h2;		/**< Secondary height information. */
  double		 nts;		/**< Normal text size. */
  double		 tts;		/**< TeX text size. */
  double		 arcspp;	/**< Spline points per arc. */
  double		 splspp;	/**< Spline points per interval. */
  double		 xsprec;	/**< Iteration precision. */
  double		 lwbp;		/**< Line width in bp. */
  long			 lwidth;	/**< Width in bp. */
  long			 lheight;	/**< Height in bp. */
  size_t		 xssbs;		/**< X-spline segement Bezier segs. */
  size_t		 minspp;	/**< Minimum spline points. */
  size_t		 qbs;		/**< Quadrant Bezier segments. */
  size_t		 codi;		/**< Color digits. */
  int			 ntf;		/**< Text font (0=similar, 1=fig). */
  int			 dr;		/**< Driver, see @ref fig2latdrivers. */
  int			 exval;		/**< Exit, see @ref fig2latexitcodes. */
  int			 mm;		/**< Flag: Make mode. */
  int			 cmd;		/**< Command to execute. */
  int			 cosp;		/**< Flag: Spline compatibility. */
  int			 coah;		/**< Flag: Arrowhead compatibility. */
  int			 xsah;		/**< Flag: X-spline arrowhead. */
  int			 debug;		/**< Flag: Write debug information. */
  int			 showpage;	/**< Flag: Write showpage operator. */
  int			 pslevel;	/**< PS language level. */
  int			 dsc;		/**< Flag: Write PS DSC. */
  int			 srctype;	/**< Source file type. */
  int			 smash;		/**< Flag: Use smash instruction. */
  int			 mbox;		/**< Flag: Use mbox instruction. */
  int			 resfont;	/**< Flag: Use reset@font. */
  int			 css;		/**< Flag: CSS-styled SVG. */
  int			 fragment;	/**< Flag: Write SVG fragment only. */
  int			 svgfontbase;	/**< SVG font base: 0=none, 1=local, 2=web. */
  int			 group;		/**< Flag: Group SVG object with ahs. */
  int			 miterlim;	/**< Flag: Write miterlimit. */
  int			 cols;		/**< Flag: Compatible line styles. */
  int			 otherfonts;	/**< Flag: Use additional fonts SVG. */
  int			 bbts;		/**< Flag: Use text size for bb. */
  int			 stu8;		/**< Flag: Special text uses UTF-8. */
  int			 cofop;		/**< Flag: Compat fill open paths. */
  int			 lwauto;	/**< Flag: Automatic line width. */
} f2l_job_t;



/**	@defgroup	fig2latexitcodes	Exit codes for fig2lat.
*/
/**@{*/

/**	Program succeeded.
*/
#define	FIG2LAT_EXIT_SUCCESS		0

/**	Error occured, no detailed description.
*/
#define	FIG2LAT_EXIT_ERROR_UNKNOWN	1

/**	Error, no file found to convert.
*/
#define FIG2LAT_EXIT_ERROR_NO_SUCH_FILE	2

/**	File name is too long for processing.
*/
#define	FIG2LAT_EXIT_FILENAME_TOO_LONG	3

/**	Resources problem or system error.
*/
#define	FIG2LAT_EXIT_ERROR_SYSTEM	4

/**	Mathematical error.
*/
#define	FIG2LAT_EXIT_ERROR_MATH		5

/**	Syntax error in input file.
*/
#define	FIG2LAT_EXIT_ERROR_SYNTAX	6
/**@}*/



/**	@defgroup	fig2latdrivers		Fig2lat output drivers.
*/

/**@{*/

/**	Produce PGF output file (default driver).
*/
#define	FIG2LAT_DRIVER_PGF		0

/**	Produce full *.tex file, image as embedded PGF.
*/
#define	FIG2LAT_DRIVER_TEX_FULL_PGF	1

/**	Produce full *.tex file, image as included external PDF.
*/
#define	FIG2LAT_DRIVER_TEX_FULL_PDF	2

/**	Produce *.tex file including an external EPS.
*/
#define	FIG2LAT_DRIVER_EPS_WITH_TEX	3

/**	Produce *.tex file including an external PDF.
*/
#define	FIG2LAT_DRIVER_PDF_WITH_TEX	4

/**	Produce standalone EPS file.
*/
#define	FIG2LAT_DRIVER_EPS_STANDALONE	5

/**	Produce standalone SVG file.
*/
#define	FIG2LAT_DRIVER_SVG_STANDALONE	6

/*	@DRIVER@
	Add new driver numbers above this comment.
	The driver numbers must correspond to the order of
	driver names in f2lopt.ctr in the f2lopt_language_names array.
*/

/**@}*/



#include "f2lopt.h"
#include "f2lto.h"


#endif
