/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: f2lud.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file f2lud.h Header file for the f2lud module.
*/

#ifndef F2LUD_H_INCLUDED
/** Avoid multiple inclusions. */
#define F2LUD_H_INCLUDED 1


#line 10 "f2lud.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Produce output.
	@param	job	Job structure.
*/
void
f2lud_output(f2l_job_t *job);

/**	Issue "newpath" command.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lud_newpath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Issue "moveto" command.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	x	New point x in output space.
	@param	y	New point y in output space.
*/
void
f2lud_moveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
);

/**	Issue "lineto" command.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	x	New point x in output space.
	@param	y	New point y in output space.
*/
void
f2lud_lineto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
);

/**	Issue "curveto" command.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	xcs	Control point at start x in output space.
	@param	ycs	Control point at start y in output space.
	@param	xce	Control point at end x in output space.
	@param	yce	Control point at end y in output space.
	@param	xe	End point x in output space.
	@param	ye	End point y in output space.

*/
void
f2lud_curveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 xcs,
  double		 ycs,
  double		 xce,
  double		 yce,
  double		 xe,
  double		 ye
);

/**	Issue "moveto" command.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	x	New point x in Fig space.
	@param	y	New point y in Fig space.
	@param	ec	Pointer to error code variable, may be NULL.
*/
void
f2lud_fig_moveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y,
  int			*ec
);

/**	Issue "lineto" command.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	x	New point x in Fig space.
	@param	y	New point y in Fig space.
	@param	ec	Pointer to error code variable, may be NULL.
*/
void
f2lud_fig_lineto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y,
  int			*ec
);

/**	Issue "curveto" command.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	xcs	Control point at start x in Fig space.
	@param	ycs	Control point at start y in Fig space.
	@param	xce	Control point at end x in Fig space.
	@param	yce	Control point at end y in Fig space.
	@param	xe	End point x in Fig space.
	@param	ye	End point y in Fig space.
	@param	ec	Pointer to error code variable, may be NULL.
*/
void
f2lud_fig_curveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 xcs,
  double		 ycs,
  double		 xce,
  double		 yce,
  double		 xe,
  double		 ye,
  int			*ec
);

/**	Issue "closepath" command.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lud_closepath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Issue "stroke" command.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lud_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Issue "fill" command.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lud_fill(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Check whether a spline object is an interpolated spline
	(only s=-1 and/or s=0 points).
	@param	obj	Object to check.
	@return	1 for pure interpolated spline, 0 otherwise.
*/
int
f2lud_is_interpolated_spline(dk3_fig_obj_t *obj);

#ifdef __cplusplus
}
#endif




#endif
