/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: f2lto.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file f2lto.h Header file for the f2lto module.
*/

#ifndef F2LTO_H_INCLUDED
/** Avoid multiple inclusions. */
#define F2LTO_H_INCLUDED 1


#line 9 "f2lto.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Register PS font in a storage.
	@param	sFonts		Fonts storage.
	@param	iFonts		Storage iterator.
	@param	nFonts		Pointer to variable for total number of used
				fonts.
	@param	fontno		PS font number.
	@param	fontsize	Font size.
	@param	app		Application structure for diagnostics.
	@return	Pointer to text handling on success, NULL on error.
*/
f2l_text_handling_t *
f2l_tool_register_font(
  dk3_sto_t		*sFonts,
  dk3_sto_it_t		*iFonts,
  unsigned long		*nFonts,
  int			 fontno,
  double		 fontsize,
  dk3_app_t		*app
);

/**	Start LaTeX part of EPS+TEX or PDF+TEX.
	@param	of		Output file.
	@param	job		Job structure.
	@param	drw		Drawing structure.
	@param	shortOutFile	Short output file name of EPS or PDF file.
	@param	iFonts		Font storage iterator.
	@param	nFonts		Total number of fonts.
*/
void
f2l_tool_start_tex_part(
  FILE			*of,
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  char const		*shortOutFile,
  dk3_sto_it_t		*iFonts,
  unsigned long		 nFonts
);

/**	Start LaTeX part of EPS+TEX, PDF+TEX or PGF.
	@param	of		Output file.
	@param	job		Job structure.
	@param	drw		Drawing structure.
	@param	shortOutFile	Short output file name of EPS or PDF file.
	@param	iFonts		Font storage iterator.
	@param	nFonts		Total number of fonts.
	@param	wp		Flag: With picture environments.
*/
void
f2l_tool_start_tex_part_with_picture(
  FILE			*of,
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  char const		*shortOutFile,
  dk3_sto_it_t		*iFonts,
  unsigned long		 nFonts,
  int			 wp
);

/**	End LaTeX part of EPS+TEX or PDF+TEX.
	@param	of	Output file.
*/
void
f2l_tool_end_tex_part(
  FILE			*of
);

/**	Write one font name.
	@param	of	Output file.
	@param	fontno	Number of font to write.
	@param	nFonts	Total number of font definitions.
*/
void
f2l_tool_write_font_name(
  FILE			*of,
  unsigned long		 fontno,
  unsigned long		 nFonts
);

/**	Write inner part of text object.
	This function is used both for writing to a picture environment
	in a *.tex file and pgf text labels.
	@param	of	Output file.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Text object.
	@param	nFonts	Total number of PS fonts.
*/
void
f2l_tool_inner_text_object(
  FILE			*of,
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  unsigned long		 nFonts
);

/**	Write one text object to LaTeX output in a picture environment.
	@param	of	Output file.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Text object.
	@param	x	X position.
	@param	y	Y position.
	@param	nFonts	Total number of PS fonts.
*/
void
f2l_tool_text_object(
  FILE			*of,
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y,
  unsigned long		 nFonts
);

/**	Write commands to choose a font.
	@param	of	Output file.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Text object.
	@param	nFonts	Total number of PS fonts.
*/
void
f2l_tool_font_selection(
  FILE			*of,
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  unsigned long		 nFonts
);

/**	Write string to LaTeX output.
	@param	of	Output file.
	@param	txt	String, ISO-LATIN-1 encoded.
*/
void
f2l_tool_tex_string(
  FILE			*of,
  char const		*txt
);

/**	Write instruction to select a font by features to LaTeX output.
	@param	of		Output file.
	@param	job		Job structure.
	@param	drw		Drawing structure.
	@param	obj		Text object.
	@param	fontSize	Font size.
	@param	fontFeatures	Font features.
	@param	useFamily	Flag: Choose font family.
*/
void
f2l_tool_font_select_by_features(
  FILE			*of,
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 fontSize,
  int			 fontFeatures,
  int			 useFamily
);

/**	Create image file data.
	@param	filename	File name.
	@param	app		Application structure for diagnostics.
	@param	li		Line number of object definition.
	@return	Pointer to image file data on success, NULL on error.
*/
f2l_image_t *
f2l_tool_image_new(char const *filename, dk3_app_t *app, unsigned long li);

/**	Destroy image data.
	@param	im	Image data to destroy.
*/
void
f2l_tool_image_delete(f2l_image_t *im);

/**	Compare two image entries.
	@param	l	Left image entry.
	@param	r	Right image entry or unique file identifier.
	@param	cr	Comparison criteria (0=image/image, 1=image/ufi).
	@return	Comparison result.
*/
int
f2l_tool_compare_images(void const *l, void const *r, int cr);

/**	Set exit status code to error code if exit status indicates success.
	@param	job	Job structure.
	@param	exval	Error code.
*/
void
f2l_tool_set_exit_status(f2l_job_t *job, int exval);

/**	Begin LaTeX document (write document preamble and begin document line).
	@param	of	Output file.
	@param	job	Job structure.
	@param	drw	Drawing structure.
*/
void
f2l_tool_begin_latex_document(
  FILE			*of,
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw
);

/**	End LaTeX document (write end document line).
	@param	of	Output file.
	@param	job	Job structure.
	@param	drw	Drawing structure.
*/
void
f2l_tool_end_latex_document(
  FILE			*of,
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw
);

/**	Find drawing direction for embedded image.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Drawing direction.
*/
int
f2lto_find_draw_direction(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			*ec
);

/**	Find suitable length for gaps in line styles.
	@param	job	Job structure.
	@param	lw	Line width.
	@param	lsv	Style value.
	@return	Gap length.
*/
double
f2lto_find_gap_length(f2l_job_t *job, double lw, double lsv);

#ifdef __cplusplus
}
#endif




#endif
