/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: f2lsvgst.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file f2lsvgst.h Header file for the f2lsvgst module.
*/

#ifndef F2LSVGST_H_INCLUDED
/** Avoid multiple inclusions. */
#define F2LSVGST_H_INCLUDED 1


#line 10 "f2lsvgst.ctr"

#include "dk3all.h"
#include "dk3font.h"
#include "fig2lat.h"
#include "f2lsvg.h"
#include "f2lsvgst.h"
#include "dk3figto.h"



/**	@defgroup	svgstyleflags	SVG style flags */
/**@{*/

/**	Stroke color defined.
*/
#define	DK3_SVG_FLAGS_COLOR_STROKE		1

/**	Fill color defined.
*/
#define	DK3_SVG_FLAGS_COLOR_FILL		2

/**	Text align defined.
*/
#define	DK3_SVG_FLAGS_TEXT_ALIGN		4

/**	Font defined.
*/
#define	DK3_SVG_FLAGS_FONT			8

/**	Font is a PS font (LaTeX font otherwise).
*/
#define	DK3_SVG_FLAGS_PS_FONT			16

/**	Line width defined.
*/
#define	DK3_SVG_FLAGS_LINEWIDTH			32

/**	Line style defined.
*/
#define	DK3_SVG_FLAGS_LINESTYLE			64

/**	Line cap defined.
*/
#define	DK3_SVG_FLAGS_LINE_CAP			128

/**	Line join defined.
*/
#define	DK3_SVG_FLAGS_LINE_JOIN			256

/**@}*/


/**	Fill pattern.
*/
typedef struct {
  unsigned long pn;		/**< Pattern number. */
  int		fn;		/**< Fig pattern number 41 - 62. */
  int		sr;		/**< Stroke color red. */
  int		sg;		/**< Stroke color green. */
  int		sb;		/**< Stroke color blue. */
  int		fr;		/**< Fill color red. */
  int		fg;		/**< Fill color green. */
  int		fb;		/**< Fill color blue. */
} f2l_svg_fill_pattern_t;



/**	SVG object style information.
*/
typedef struct {
  f2l_svg_fill_pattern_t	*fp;	/**< Fill pattern. */
  double			 ts;	/**< Text size. */
  double			 lw;	/**< Line width. */
  double			 lsv;	/**< Line style value. */
  unsigned long			 sn;	/**< Style number. */
  int				 tf;	/**< Text font. */
  int				 flags;	/**< Flags, see @ref svgstyleflags. */
  int				 sr;	/**< Stroke color red. */
  int				 sg;	/**< Stroke color green. */
  int				 sb;	/**< Stroke color blue. */
  int				 fr;	/**< Fill color red. */
  int				 fg;	/**< Fill color green. */
  int				 fb;	/**< Fill color blue. */
  int				 ls;	/**< Line style. */
  int				 al;	/**< Text align. */
  int				 lc;	/**< Line cap. */
  int				 lj;	/**< Line join. */
} f2l_svg_style_t;



/**	Complete collection of style information for an SVG object.
*/
typedef struct {
  dk3_sto_t	*sPatterns;	/**< Storage for fill patterns. */
  dk3_sto_it_t	*iPatterns;	/**< Iterator through fill patterns storage. */
  dk3_sto_t	*sStyles;	/**< Storage for object styles. */
  dk3_sto_it_t	*iStyles;	/**< Iterator through object styles storage. */
  unsigned long	 nPatterns;	/**< Number of patterns in storage. */
  unsigned long	 nStyles;	/**< Number of styles in storage. */
  int		*psFontsUsed;	/**< Flag for 35 PS fonts, used or not. */
  int		 ec;		/**< Error code. */
} f2l_svg_t;


#ifdef __cplusplus
extern "C" {
#endif

/**	Compare two fill pattern structures.
	@param	l	Left fill pattern structure.
	@param	r	Right fill pattern structure.
	@param	cr	Comparison criteria (ignored).
	@return	Comparison result.
*/
int
f2lsvgst_compare_pattern(void const *l, void const *r, int cr);

/**	Compare two object styles.
	@param	l	Left object.
	@param	r	Right object.
	@param	cr	Comparison criteria (ignored).
	@return	Comparison result.
*/
int
f2lsvgst_compare_object_styles(void const *l, void const *r, int cr);

/**	Create new SVG structure.
	@param	app	Application structure for diagnostics.
	@return	Pointer to new structure on success, NULL on error.
*/
f2l_svg_t *
f2lsvgst_new_app(dk3_app_t *app);

/**	Delete SVG structure.
	@param	psvg	Structure to delete.
*/
void
f2lsvgst_delete(f2l_svg_t *psvg);

/**	Retrieve error code for last error and reset error code.
	@param	psvg	SVG structure to retrieve error for.
*/
int
f2lsvgst_get_error_code(f2l_svg_t *psvg);

/**	Create fill pattern structure, allocate memory.
	@param	psvg	Pointer to SVG structure.
	@return	Pointer to new structure on success, NULL on error.
*/
f2l_svg_fill_pattern_t *
f2lsvgst_pattern_new(f2l_svg_t *psvg);

/**	Destroy fill pattern structure, release memory.
	@param pa	Structure to release.
*/
void
f2lsvgst_pattern_delete(f2l_svg_fill_pattern_t *pa);

/**	Create object style structure, allocate memory.
	@param	psvg	Pointer to SVG structure.
	@return	Pointer to new structure on success, NULL on error.
*/
f2l_svg_style_t *
f2lsvgst_style_new(f2l_svg_t *psvg);

/**	Destroy object style structure, release memory.
	@param	st	Structure to release.
*/
void
f2lsvgst_style_delete(f2l_svg_style_t *st);

/**	Initialize style structure.
	@param	st	Style structure to initialize.
*/
void
f2lsvgst_style_initialize(f2l_svg_style_t *st);

/**	Add new pattern to SVG structure if necessary.
	@param	psvg	SVG structure to modify.
	@param	src	New pattern.
	@return	Pointer to new or existing pattern on success, NULL on error.
*/
f2l_svg_fill_pattern_t *
f2lsvgst_pattern_add(f2l_svg_t *psvg, f2l_svg_fill_pattern_t *src);

/**	Add new style to SVG structure if necessary.
	@param	psvg	SVG structure to modify.
	@param	src	New style.
	@return	Pointer to new or existing style on success, NULL on error.
*/
f2l_svg_style_t *
f2lsvgst_style_add(f2l_svg_t *psvg, f2l_svg_style_t *src);

/**	Set font for style.
	@param	psvg	SVG style collection.
	@param	pst	SVG style to modify.
	@param	ps	Flag: PS font (1) or LaTeX font (0).
	@param	tf	Text font (PS font or LaTeX font, depending on ps).
	@param	ts	Text size.
*/
void
f2lsvgst_style_set_text(
  f2l_svg_t		*psvg,
  f2l_svg_style_t	*pst,
  int			 ps,
  int			 tf,
  double		 ts
);

/**	Set text align for a style.
	@param	pst	SVG style to modify.
	@param	al	New text alignment value.
*/
void
f2lsvgst_style_set_text_align(f2l_svg_style_t *pst, int al);

/**	Set line width for strokes.
	@param	pst	Style to modify.
	@param	lw	New line width.
*/
void
f2lsvgst_style_set_line_width(
  f2l_svg_style_t	*pst,
  double		 lw
);

/**	Set line style for strokes.
	@param	pst	Style to modify.
	@param	ls	New line style.
	@param	lsv	Style value (gap and segment length).
*/
void
f2lsvgst_style_set_line_style(
  f2l_svg_style_t		*pst,
  int				 ls,
  double			 lsv
);

/**	Set line color for strokes.
	@param	pst	Style to modify.
	@param	r	Red.
	@param	g	Green.
	@param	b	Blue.
*/
void
f2lsvgst_style_set_line_color(
  f2l_svg_style_t		*pst,
  int				 r,
  int				 g,
  int				 b
);

/**	Set fill color.
	@param	pst	Style to modify.
	@param	r	Red.
	@param	g	Green.
	@param	b	Blue.
*/
void
f2lsvgst_style_set_fill_color(
  f2l_svg_style_t		*pst,
  int				 r,
  int				 g,
  int				 b
);

/**	Set fill pattern.
	@param	psvg	SVG structure to modify.
	@param	pst	Style to modify.
	@param	ppat	Pattern for fill operations.
	@return	1 on success, 0 on error.
*/
int
f2lsvgst_style_set_pattern(
  f2l_svg_t			*psvg,
  f2l_svg_style_t		*pst,
  f2l_svg_fill_pattern_t	*ppat
);

/**	Set line cap for a style.
	@param	pst	SVG style to modify.
	@param	lc	New line cap value.
*/
void
f2lsvgst_style_set_text_line_cap(f2l_svg_style_t *pst, int lc);

/**	Set line join for a style.
	@param	pst	SVG style to modify.
	@param	lj	New line joint style.
*/
void
f2lsvgst_style_set_text_line_join(f2l_svg_style_t *pst, int lj);

/**	Check whether any PS font is used in an SVG style collection.
	@param	psvg	SVG style collection.
	@return	1 if any PS font is in use, 0 otherwise.
*/
int
f2lsvgst_any_ps_font_used(f2l_svg_t *psvg);

/**	Write all patterns used to the SVG output file.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	psvg	SVG style collection.
*/
void
f2lsvgst_write_patterns(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  f2l_svg_t		*psvg
);

/**	Write pattern ID.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	psvg	SVG style collection.
	@param	pat	Pattern to write.
*/
void
f2lsvgst_pattern_id(
  f2l_job_t			*job,
  dk3_fig_drawing_t		*drw,
  f2l_svg_t			*psvg,
  f2l_svg_fill_pattern_t	*pat
);

/**	Write styles to output file.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	psvg	SVG style collection.
*/
void
f2lsvgst_write_styles(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  f2l_svg_t		*psvg
);

/**	Write style ID.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	psvg	SVG style collection.
	@param	pst	Style.
*/
void
f2lsvgst_style_id(
  f2l_job_t			*job,
  dk3_fig_drawing_t		*drw,
  f2l_svg_t			*psvg,
  f2l_svg_style_t		*pst
);

/**	Write style information for current object.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	psvg	SVG style collection.
	@param	pobj	Current object in processing.
*/
void
f2lsvgst_write_style_for_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  f2l_svg_t		*psvg,
  dk3_fig_obj_t		*pobj
);

/**	Write pattern ID.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	psvg	SVG style collection.
	@param	pat	Pattern used for current object.
*/
void
f2lsvgst_write_pattern_id(
  f2l_job_t			*job,
  dk3_fig_drawing_t		*drw,
  f2l_svg_t			*psvg,
  f2l_svg_fill_pattern_t	*pat
);

/**	Write style ID.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	psvg	SVG style collection.
	@param	pst	Style used by current object.
*/
void
f2lsvgst_write_style_id(
  f2l_job_t			*job,
  dk3_fig_drawing_t		*drw,
  f2l_svg_t			*psvg,
  f2l_svg_style_t		*pst
);

#ifdef __cplusplus
}
#endif


#endif
