/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: f2lpgf.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file f2lpgf.h Header file for the f2lpgf module.
*/

#ifndef F2LPGF_H_INCLUDED
/** Avoid multiple inclusions. */
#define F2LPGF_H_INCLUDED 1


#line 10 "f2lpgf.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Driver initialization for tex output.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@return	1 on success, 0 on error.
*/
int
f2lpgf_tex_initialize(f2l_job_t *job, dk3_fig_drawing_t *drw);

/**	Driver cleanup for tex driver.
	@param	job	Job structure.
	@param	drw	Drawing structure.
*/
void
f2lpgf_tex_end(f2l_job_t *job, dk3_fig_drawing_t *drw);

/**	Open output files for tex driver.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
f2lpgf_tex_open_output_files(f2l_job_t *job);

/**	Close output files for tex driver.
	@param	job	Job structure.
*/
void
f2lpgf_tex_close_output_files(f2l_job_t *job);

/**	Write start of output for tex driver.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@return	1 on success, 0 on error.
*/
int
f2lpgf_tex_start_processing(f2l_job_t *job, dk3_fig_drawing_t *drw);

/**	Write end of output for tex driver.
	@param	job	Job structure.
	@param	drw	Drawing structure.
*/
void
f2lpgf_tex_end_processing(f2l_job_t *job, dk3_fig_drawing_t *drw);

/**	Process one text object.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	x	Point x.
	@param	y	Point y.
*/
void
f2lpgf_tex_text_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
);

/**	Process one image object.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	outbb	Bounding box for image.
	@param	drawdir	Drawing direction.
	@param	ec	Pointer to error code variable, may be NULL.
*/
void
f2lpgf_tex_image_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_bb_t		*outbb,
  int			 drawdir,
  int			*ec
);

/**	Start new path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_tex_newpath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Move to point.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	x	Point x.
	@param	y	Point y.
*/
void
f2lpgf_tex_moveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
);

/**	Draw line to point.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	x	Point x.
	@param	y	Point y.
*/
void
f2lpgf_tex_lineto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
);

/**	Draw curve to point.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	xcs	Start control point y.
	@param	ycs	Start control point y.
	@param	xce	End control point x.
	@param	yce	End control point y.
	@param	xe	End point x.
	@param	ye	End point y.
*/
void
f2lpgf_tex_curveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 xcs,
  double		 ycs,
  double		 xce,
  double		 yce,
  double		 xe,
  double		 ye
);

/**	Close path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_tex_closepath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Fill path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_tex_fill(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Fill and stroke path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_tex_fill_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Fill and clip path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_tex_fill_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Fill, stroke and clip path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_tex_fill_stroke_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Clip drawing operations to path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_tex_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Stroke path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_tex_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Save graphics state.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_tex_gsave(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Restore graphics state.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_tex_grestore(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Set color.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	r	Red.
	@param	g	Green.
	@param	b	Blue.
*/
void
f2lpgf_tex_setcolor(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 r,
  double		 g,
  double		 b
);

/**	Set line width.
	The line width is not set again if we already
	have a current line width equal to the new line width.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Fig object.
	@param	lw	New line width in output coordinates.
*/
void
f2lpgf_tex_set_line_width(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 lw
);

/**	Set line style.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Object to set up.
	@param	ls	Line style, see @ref dk3figlinestyles.
	@param	sv	Style value in output coordinates.
	@param	lw	Dot length in output coordinates.
*/
void
f2lpgf_tex_set_line_style(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 ls,
  double		 sv,
  double		 lw
);

/**	Set line end.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Fig object.
	@param	le	Line end, see @ref dk3figlinecap.
*/
void
f2lpgf_tex_set_line_end(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 le
);

/**	Set line join.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Fig object.
	@param	lj	Line join style, see @ref dk3figlinejoin.
*/
void
f2lpgf_tex_set_line_join(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 lj
);

/**	Set current color or stroking color (PGF, PDF).
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	rgb	New color value.
*/
void
f2lpgf_tex_set_color_1(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
);

/**	Set non-stroking color (PGF, PDF).
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	rgb	New color value.
*/
void
f2lpgf_tex_set_color_2(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
);

/**	Write debugging line to output file.
	@param	job	Job structure.
	@param	msg	Message to write to output file.
*/
void
f2lpgf_tex_debug(
  f2l_job_t		*job,
  char const		*msg
);

/**	Driver initialization for pgf output.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@return	1 on success, 0 on error.
*/
int
f2lpgf_pgf_initialize(f2l_job_t *job, dk3_fig_drawing_t *drw);

/**	Driver cleanup for pgf driver.
	@param	job	Job structure.
	@param	drw	Drawing structure.
*/
void
f2lpgf_pgf_end(f2l_job_t *job, dk3_fig_drawing_t *drw);

/**	Open output files for pgf driver.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
f2lpgf_pgf_open_output_files(f2l_job_t *job);

/**	Close output files for tex driver.
	@param	job	Job structure.
*/
void
f2lpgf_pgf_close_output_files(f2l_job_t *job);

/**	Write start of output for pgf driver.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@return	1 on success, 0 on error.
*/
int
f2lpgf_pgf_start_processing(f2l_job_t *job, dk3_fig_drawing_t *drw);

/**	Write end of output for pgf driver.
	@param	job	Job structure.
	@param	drw	Drawing structure.
*/
void
f2lpgf_pgf_end_processing(f2l_job_t *job, dk3_fig_drawing_t *drw);

/**	Process one text object.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	x	Point x.
	@param	y	Point y.
*/
void
f2lpgf_pgf_text_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
);

/**	Process one image object.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	outbb	Bounding box for image.
	@param	drawdir	Drawing direction.
	@param	ec	Pointer to error code variable, may be NULL.
*/
void
f2lpgf_pgf_image_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_bb_t		*outbb,
  int			 drawdir,
  int			*ec
);

/**	Start new path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_pgf_newpath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Move to point.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	x	Point x.
	@param	y	Point y.
*/
void
f2lpgf_pgf_moveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
);

/**	Draw line to point.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	x	Point x.
	@param	y	Point y.
*/
void
f2lpgf_pgf_lineto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
);

/**	Draw curve to point.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	xcs	Start control point y.
	@param	ycs	Start control point y.
	@param	xce	End control point x.
	@param	yce	End control point y.
	@param	xe	End point x.
	@param	ye	End point y.
*/
void
f2lpgf_pgf_curveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 xcs,
  double		 ycs,
  double		 xce,
  double		 yce,
  double		 xe,
  double		 ye
);

/**	Close path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_pgf_closepath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Fill path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_pgf_fill(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Fill and stroke path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_pgf_fill_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Fill and clip path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_pgf_fill_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Fill,stroke and clip path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_pgf_fill_stroke_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Clip drawing operations to path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_pgf_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Stroke path.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_pgf_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Save graphics state.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_pgf_gsave(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Restore graphics state.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
*/
void
f2lpgf_pgf_grestore(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
);

/**	Set color.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Current object to process.
	@param	r	Red.
	@param	g	Green.
	@param	b	Blue.
*/
void
f2lpgf_pgf_setcolor(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 r,
  double		 g,
  double		 b
);

/**	Set line width.
	The line width is not set again if we already
	have a current line width equal to the new line width.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Fig object.
	@param	lw	New line width in output coordinates.
*/
void
f2lpgf_pgf_set_line_width(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 lw
);

/**	Set line style.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Object to set up.
	@param	ls	Line style, see @ref dk3figlinestyles.
	@param	sv	Style value in output coordinates.
	@param	lw	Dot length in output coordinates.
*/
void
f2lpgf_pgf_set_line_style(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 ls,
  double		 sv,
  double		 lw
);

/**	Set line end.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Fig object.
	@param	le	Line end, see @ref dk3figlinecap.
*/
void
f2lpgf_pgf_set_line_end(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 le
);

/**	Set line join.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Fig object.
	@param	lj	Line join style, see @ref dk3figlinejoin.
*/
void
f2lpgf_pgf_set_line_join(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 lj
);

/**	Set current color or stroking color (PGF, PDF).
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	rgb	New color value.
*/
void
f2lpgf_pgf_set_color_1(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
);

/**	Set non-stroking color (PGF, PDF).
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	rgb	New color value.
*/
void
f2lpgf_pgf_set_color_2(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
);

/**	Write debugging line to output file.
	@param	job	Job structure.
	@param	msg	Message to write to output file.
*/
void
f2lpgf_pgf_debug(
  f2l_job_t		*job,
  char const		*msg
);

#ifdef __cplusplus
}
#endif




#endif
