/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: f2lpgf.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file f2lpgf.c The f2lpgf module.
*/


#line 756 "f2lpgf.ctr"

#include "dk3all.h"
#include "dk3bezcu.h"
#include "fig2lat.h"
#include "f2lud.h"
#include "f2lsvg.h"
#include "f2lpgf.h"
#include "dk3figto.h"
#include "dkt-version.h"
#include "dk3bif.h"
#include "dk3bm.h"
#include "dk3figto.h"





#line 772 "f2lpgf.ctr"



/**	Driver specific details for entire drawing.
*/
typedef struct {
  dk3_sto_t		*sFonts;	/**< Storage for fonts. */
  dk3_sto_it_t		*iFonts;	/**< Iterator for font storage. */
  unsigned long		 nFonts;	/**< Number of fonts in sFonts. */
} f2l_pgf_drawing_info_t;



/**	Keywords used by the module.
*/
static char const * const	f2lpgf_c8_kw[] = {
/* 0 */
"\n",

/* 1 */
" ",

/* 2 */
"\\begin{pgfpicture}\n",

/* 3 */
"\\end{pgfpicture}%\n",

/* 4 */
"\\begin{pgfscope}\n",

/* 5 */
"\\end{pgfscope}\n",

/* 6 */
"\\pgfpathrectangle{\\pgfpointorigin}{",

/* 7 */
"}\n",

/* 8 */
"\\pgfpoint{",

/* 9 */
",",

/* 10 */
"}",

/* 11 */
"\\pgfpoint{%ldbp}{%ldbp}",

/* 12 */
"bp",

/* 13 */
"\\pgfusepath{use as bounding box}\n",

/* 14 */
"\\pgfusepath{clip}\n",

/* 15 */
"\\pgfseteorule\n",

/* 16 */
"\\pgfpathmoveto{",

/* 17 */
"\\pgfpathlineto{",

/* 18 */
"\\pgfpathcurveto{",

/* 19 */
"}{",

/* 20 */
"\\pgfpathclose\n",

/* 21 */
"\\pgfusepath{fill}\n",

/* 22 */
"\\pgfusepath{fill,stroke}\n",

/* 23 */
"\\pgfusepath{fill,clip}\n",

/* 24 */
"\\pgfusepath{fill,stroke,clip}\n",

/* 25 */
"\\pgfusepath{stroke}\n",

/* 26 */
"\\pgfsetlinewidth{",

/* 27 */
"\\pgfsetdash{",

/* 28 */
"{",

/* 29 */
"\\pgfsetrectcap\n",

/* 30 */
"\\pgfsetroundcap\n",

/* 31 */
"\\pgfsetbuttcap\n",

/* 32 */
"\\pgfsetbeveljoin\n",

/* 33 */
"\\pgfsetroundjoin\n",

/* 34 */
"\\pgfsetmiterjoin\n",

/* 35 */
"\\definecolor{FigToLatColorS}{rgb}{",

/* 36 */
"\\definecolor{FigToLatColorN}{rgb}{",

/* 37 */
"\\pgfsetstrokecolor{FigToLatColorS}\n",

/* 38 */
"\\pgfsetfillcolor{FigToLatColorN}\n",

/* 39 */
"% ",

/* 40 */
"\\pgftransformshift{",

/* 41 */
"\\pgftransformrotate{%d}\n",

/* 42 */
"\\pgftransformxscale{",

/* 43 */
"\\pgftransformyscale{",

/* 44 */
"\\pgftext[left,base,at={\\pgfpointorigin}]{\\pgfimage[interpolate=true,width=1bp,height=1bp]{",

/* 45 */
"}}\n",

/* 46 */
"\\pgftext[",

/* 47 */
"]{",

/* 48 */
"base,left",

/* 49 */
"base",

/* 50 */
"base,right",

/* 51 */
",at={",

/* 52 */
",rotate=",

NULL


#line 1002 "f2lpgf.ctr"
};


/* ************************************************************************ */
/* *                                                                      * */
/* *         Tool functions                                               * */
/* *                                                                      * */
/* ************************************************************************ */


#line 1008 "f2lpgf.ctr"



/**	Delete driver-specific details.
	@param	ptr	Details structure to delete.
*/
static
void
f2lpgf_pdi_delete(f2l_pgf_drawing_info_t *ptr)
{
  void *vptr;		/* Current text handling structure to delete. */

  if(ptr) {
    if(ptr->sFonts) {
      if(ptr->iFonts) {
        dk3sto_it_reset(ptr->iFonts);
	while(NULL != (vptr = dk3sto_it_next(ptr->iFonts))) {
	  dk3_delete(vptr);
	}
        dk3sto_it_close(ptr->iFonts);
      }
      dk3sto_close(ptr->sFonts);
    } ptr->sFonts = NULL; ptr->iFonts = NULL; ptr->nFonts = 0UL;
    dk3_delete(ptr);
  }
}



/**	Create structure for driver-specific details.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@return	Pointer to new structure on success, NULL on error.
*/
static
f2l_pgf_drawing_info_t *
f2lpgf_pdi_new(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  f2l_pgf_drawing_info_t	*back = NULL;
  int				 ok   = 0;
  back = dk3_new_app(f2l_pgf_drawing_info_t,1,job->app);
  if(back) {
    back->sFonts = NULL; back->iFonts = NULL; back->nFonts = 0UL;
    back->sFonts = dk3sto_open_app(job->app);
    if(back->sFonts) {
      dk3sto_set_comp(back->sFonts, dk3fig_tool_text_handling_compare, 0);
      back->iFonts = dk3sto_it_open(back->sFonts);
      if(back->iFonts) {
        ok = 1;
      }
    }
    if(!(ok)) {
      f2lpgf_pdi_delete(back);
      back = NULL;
    }
  } else {
  }
  return back;
}



/**	Write point (long coordinates).
	@param	of	Output file.
	@param	x	X position.
	@param	y	X position.
*/
static
void
f2lpgf_write_point_long(FILE *of, long x, long y)
{
  fprintf(of, f2lpgf_c8_kw[11], x, y);
}



/**	Write point (double coordinates).
	@param	of	Output file.
	@param	x	X position.
	@param	y	Y position.
*/
static
void
f2lpgf_write_point_double(FILE *of, double x, double y)
{
  fputs(f2lpgf_c8_kw[8], of);
  dk3ma_print_double_c8_no_sci(of, x);
  fputs(f2lpgf_c8_kw[12], of);
  fputs(f2lpgf_c8_kw[19], of);
  dk3ma_print_double_c8_no_sci(of, y);
  fputs(f2lpgf_c8_kw[12], of);
  fputs(f2lpgf_c8_kw[10], of);
}



/**	Set line dash.
	@param	of	Output file.
	@param	xsv	Stroke and gap lengths.
	@param	nsv	Number of elements in xsv.
	@param	ph	Phase (Used length at start of line).
*/
static
void
f2lpgf_set_line_dash(FILE *of, double *xsv, size_t nsv, double ph)
{
  size_t	i;	/* Index to traverse xsv. */

  fputs(f2lpgf_c8_kw[27], of);
  for(i = 0; i < nsv; i++) {
    fputs(f2lpgf_c8_kw[28], of);
    dk3ma_print_double_c8_no_sci(of, xsv[i]);
    fputs(f2lpgf_c8_kw[12], of);
    fputs(f2lpgf_c8_kw[10], of);
  }
  fputs(f2lpgf_c8_kw[19], of);
  dk3ma_print_double_c8_no_sci(of, ph);
  fputs(f2lpgf_c8_kw[12], of);
  fputs(f2lpgf_c8_kw[7], of);
}



/**	Define current color.
	@param	of	Output file.
	@param	tp	Color type.
	@param	rgb	RGB color structure.
*/
static
void
f2lpgf_define_color(FILE *of, int tp, dk3_rgb_color_t *rgb)
{
  fputs(f2lpgf_c8_kw[((tp) ? 36 : 35)], of);
  dk3ma_print_double_c8_no_sci(of, rgb->r);
  fputs(f2lpgf_c8_kw[9], of);
  dk3ma_print_double_c8_no_sci(of, rgb->g);
  fputs(f2lpgf_c8_kw[9], of);
  dk3ma_print_double_c8_no_sci(of, rgb->b);
  fputs(f2lpgf_c8_kw[10], of);
}



/**	Write image file name to output file.
	@param	of	Output file.
	@param	fn	File name.
*/
static
void
fl2pgf_image_file_name(FILE *of, char const *fn)
{
  char const		*ptr;	/* Current character to process. */

  ptr = fn;
  while(*ptr) {
    switch(*ptr) {
      case '\\': {
        fputc('/', of);
      } break;
      default: {
        fputc(*ptr, of);
      } break;
    }
    ptr++;
  }
}



/**	Write text rotation angle.	
	@param	of	Output file.
	@param	rot	Rotation in radians.
	@param	job	Job structure.
*/
static
void
f2lpgf_write_text_rotation(FILE *of, double rot, f2l_job_t *job)
{
  int			 ec = 0;	/* Mathematical error code. */
  double		 an;		/* Rotation in degree. */
  double		 ri;		/* Integer value of an. */

  if(1.0e-6 < fabs(rot)) {
    an = dk3ma_d_mul_ok(rot, 180.0, &ec) / M_PI;
    ri = dk3ma_d_rint(an);
#if 0
    if(1.0e-3 > fabs(dk3ma_d_rint(dk3ma_d_sub_ok(an, ri, &ec)))) {
      an = ri;
    }
#else
    /*	2013-01-27: The rint result in the code above is always 0.
    */
    if(1.0e-3 > fabs(dk3ma_d_sub_ok(an, ri, &ec))) {
      an = ri;
    }
#endif
    fputs(f2lpgf_c8_kw[52], of);
    dk3ma_print_double_c8_no_sci(of, an);
    if(ec) {
      /* ERROR: Math error */
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 35);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_MATH); 

#line 1210 "f2lpgf.ctr"
    }
  }
}



/* ************************************************************************ */
/* *                                                                      * */
/* *         PGF output driver functions                                  * */
/* *                                                                      * */
/* ************************************************************************ */


#line 1219 "f2lpgf.ctr"

int
f2lpgf_pgf_initialize(f2l_job_t *job, dk3_fig_drawing_t *drw)
{

  f2l_pgf_drawing_info_t	*pdi = NULL;		/* Driver spec det. */
  dkChar const			*oldsourcefile = NULL;	/* Source file name. */
  dk3_fig_obj_t			*pobj;			/* Current object. */
  unsigned long			 oldsourceline = 0UL;	/* Source file line. */
  int				 ff = 0;		/* Font flags. */
  int				 back = 0;
  

#line 1231 "f2lpgf.ctr"
  if((job) && (drw)) {
    pdi = f2lpgf_pdi_new(job, drw);
    if(pdi) {
      drw->dsd = (void *)pdi;
      back = 1;
      oldsourcefile = dk3app_get_source_file(job->app);
      oldsourceline = dk3app_get_source_line(job->app);
      dk3sto_it_reset(drw->iobj);
      while(NULL != (pobj = (dk3_fig_obj_t *)dk3sto_it_next(drw->iobj))) {
        dk3app_set_source_line(job->app, pobj->li);
	switch(pobj->ot) {
	  case DK3_FIG_OBJ_TEXT: {		

#line 1243 "f2lpgf.ctr"
	    ff = (pobj->dt).txt.ff;
	    if(!(ff & DK3_FIG_FONT_FLAG_HIDDEN)) {	

#line 1245 "f2lpgf.ctr"
	      if(!(ff & DK3_FIG_FONT_FLAG_SPECIAL)) {	

#line 1246 "f2lpgf.ctr"
	        if(ff & DK3_FIG_FONT_FLAG_PS) {		

#line 1247 "f2lpgf.ctr"
		  if(job->ntf) {		

#line 1248 "f2lpgf.ctr"
		    pobj->dsd = (void *)f2l_tool_register_font(
		      pdi->sFonts, pdi->iFonts, &(pdi->nFonts),
		      (pobj->dt).txt.fo, (pobj->dt).txt.fs, job->app
		    );
		    if(!(pobj->dsd)) {
		      back = 0;
		      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1255 "f2lpgf.ctr"
		    }
		  } else {			

#line 1257 "f2lpgf.ctr"
		  }
		}
	      }
	    }
	  }
	}
      }
      dk3app_set_source_file(job->app, oldsourcefile);
      dk3app_set_source_line(job->app, oldsourceline);
    } else {
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1268 "f2lpgf.ctr"
    }
  } 

#line 1270 "f2lpgf.ctr"
  return back;
}



void
f2lpgf_pgf_end(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  

#line 1279 "f2lpgf.ctr"
  if((job) && (drw)) {
    if(drw->dsd) {
      f2lpgf_pdi_delete((f2l_pgf_drawing_info_t *)(drw->dsd));
    }
  } 

#line 1284 "f2lpgf.ctr"
}



int
f2lpgf_pgf_open_output_files(f2l_job_t *job)
{
  int		 back = 0;
  

#line 1293 "f2lpgf.ctr"
  job->of1 = dk3sf_fopen_app(job->on1, dkT("w"), job->app);
  if(job->of1) {
    back = 1;
  } else {
    f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1298 "f2lpgf.ctr"
  }
  

#line 1300 "f2lpgf.ctr"
  return back;
}



void
f2lpgf_pgf_close_output_files(f2l_job_t *job)
{
  

#line 1309 "f2lpgf.ctr"
  if(job->of1) {
    dk3sf_fclose_app(job->of1, job->app);
  }
  

#line 1313 "f2lpgf.ctr"
}



int
f2lpgf_pgf_start_processing(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  f2l_pgf_drawing_info_t	*pdi;		/* Driver specific details. */
  int				 back = 0;
  

#line 1323 "f2lpgf.ctr"
  pdi = (f2l_pgf_drawing_info_t *)(drw->dsd);
  if(pdi) {		

#line 1325 "f2lpgf.ctr"
    back = 1;
    /* Font definitions */
    f2l_tool_start_tex_part_with_picture(
      job->of1, job, drw, NULL, pdi->iFonts, pdi->nFonts, 0
    );
  } else {		

#line 1331 "f2lpgf.ctr"
  }
  fputs(f2lpgf_c8_kw[2], job->of1);
  /* Bounding box */
  fputs(f2lpgf_c8_kw[6], job->of1);
  f2lpgf_write_point_long(job->of1, job->lwidth, job->lheight);
  fputs(f2lpgf_c8_kw[7], job->of1);
  fputs(f2lpgf_c8_kw[13], job->of1);
  fputs(f2lpgf_c8_kw[15], job->of1);
  /* Begin PGF scope */
  fputs(f2lpgf_c8_kw[4], job->of1);
  /* Clip path */
  fputs(f2lpgf_c8_kw[6], job->of1);
  f2lpgf_write_point_long(job->of1, job->lwidth, job->lheight);
  fputs(f2lpgf_c8_kw[7], job->of1);
  fputs(f2lpgf_c8_kw[14], job->of1);
  

#line 1347 "f2lpgf.ctr"
  return back;
}



void
f2lpgf_pgf_end_processing(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  

#line 1356 "f2lpgf.ctr"
  /* End PGF scope */
  fputs(f2lpgf_c8_kw[5], job->of1);
  /* End PGF picture */
  fputs(f2lpgf_c8_kw[3], job->of1);
  

#line 1361 "f2lpgf.ctr"
}



void
f2lpgf_pgf_text_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  f2l_pgf_drawing_info_t	*pdi = NULL;	/* Driver specific details. */
  unsigned long			 nFonts = 0UL;	/* Number of text handlings. */
  

#line 1377 "f2lpgf.ctr"
  pdi = (f2l_pgf_drawing_info_t *)(drw->dsd);
  if(pdi) { nFonts = pdi->nFonts; }
  fputs(f2lpgf_c8_kw[46], job->of1);
  /* align */
  switch(obj->st) {
    case 2: {
      fputs(f2lpgf_c8_kw[50], job->of1);
    } break;
    case 1: {
      fputs(f2lpgf_c8_kw[49], job->of1);
    } break;
    default: {
      fputs(f2lpgf_c8_kw[48], job->of1);
    } break;
  }
  /* position */
  fputs(f2lpgf_c8_kw[51], job->of1);
  f2lpgf_write_point_double(job->of1, x, y);
  fputs(f2lpgf_c8_kw[10], job->of1);
  /* rotation */
  f2lpgf_write_text_rotation(job->of1, (obj->dt).txt.an, job);
  fputs(f2lpgf_c8_kw[47], job->of1);
  /* text */
  f2l_tool_inner_text_object(job->of1, job, drw, obj, nFonts);
  fputs(f2lpgf_c8_kw[7], job->of1);
  (job->gs).hc1 = 0; (job->gs).hc2 = 0;
  

#line 1404 "f2lpgf.ctr"
}



void
f2lpgf_pgf_image_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_bb_t		*outbb,
  int			 drawdir,
  int			*ec
)
{
  dk3_coordinates_transformation_t	 trans;		/* Graphics state tr. */
  dk3_bif_t		*bif;		/* Bitmap image file. */
  double		 w = 0.0;	/* Image width. */
  double		 h = 0.0;	/* Image height. */
  double		 xres = -1.0;	/* X resolution, none by default. */
  double		 yres = -1.0;	/* Y resolution, none by default. */
  int			 res = 0;	/* Result from transformation search. */
  

#line 1426 "f2lpgf.ctr"
  if((obj->dt).pol.fn) {
    bif = dk3bif_open_c8_filename_app(
      (obj->dt).pol.fn, DK3_BIF_IMAGE_TYPE_UNKNOWN, job->app
    );
    if(bif) {
      w = (double)dk3bif_get_width(bif);
      h = (double)dk3bif_get_height(bif);
      xres = dk3bif_get_xres(bif);
      yres = dk3bif_get_yres(bif);
      dk3bif_close(bif);
      res = dk3bm_find_transformation(
        &trans, outbb, drawdir, w, h, xres, yres, ec
      );
      if(res) {
	/* gsave */
	fputs(f2lpgf_c8_kw[4], job->of1);
	/* translate */
	fputs(f2lpgf_c8_kw[40], job->of1);
	f2lpgf_write_point_double(
	  job->of1, trans.x_translate, trans.y_translate
	);
	fputs(f2lpgf_c8_kw[7], job->of1);
	/* rotate */
	if(trans.rot) {
	  fprintf(job->of1, f2lpgf_c8_kw[41], 90 * trans.rot);
	}
	/* scale */
	fputs(f2lpgf_c8_kw[42], job->of1);
	dk3ma_print_double_c8_no_sci(job->of1, trans.x_scale);
	fputs(f2lpgf_c8_kw[7], job->of1);
	fputs(f2lpgf_c8_kw[43], job->of1);
	dk3ma_print_double_c8_no_sci(job->of1, trans.y_scale);
	fputs(f2lpgf_c8_kw[7], job->of1);
	/* image */
	fputs(f2lpgf_c8_kw[44], job->of1);
	fl2pgf_image_file_name(job->of1, (obj->dt).pol.fn);
	fputs(f2lpgf_c8_kw[45], job->of1);
	/* grestore */
	fputs(f2lpgf_c8_kw[5], job->of1);
      } else {
        /* ERROR: Failed to calculate graphics state transformation */
        dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 40);
	f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_MATH); 

#line 1469 "f2lpgf.ctr"
      }
    } else {
      /* ERROR: Failed to open bitmap image! */
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1473 "f2lpgf.ctr"
    }
  }
  

#line 1476 "f2lpgf.ctr"
}



void
f2lpgf_pgf_newpath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  

#line 1488 "f2lpgf.ctr"
  /* Nothing to do here, new paths are automatically started by moveto. */
  

#line 1490 "f2lpgf.ctr"
}



void
f2lpgf_pgf_moveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  

#line 1504 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[16], job->of1);
  f2lpgf_write_point_double(job->of1, x, y);
  fputs(f2lpgf_c8_kw[7], job->of1);
  

#line 1508 "f2lpgf.ctr"
}



void
f2lpgf_pgf_lineto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  

#line 1522 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[17], job->of1);
  f2lpgf_write_point_double(job->of1, x, y);
  fputs(f2lpgf_c8_kw[7], job->of1);
  

#line 1526 "f2lpgf.ctr"
}



void
f2lpgf_pgf_curveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 xcs,
  double		 ycs,
  double		 xce,
  double		 yce,
  double		 xe,
  double		 ye
)
{
  

#line 1544 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[18], job->of1);
  f2lpgf_write_point_double(job->of1, xcs, ycs);
  fputs(f2lpgf_c8_kw[19], job->of1);
  f2lpgf_write_point_double(job->of1, xce, yce);
  fputs(f2lpgf_c8_kw[19], job->of1);
  f2lpgf_write_point_double(job->of1, xe, ye);
  fputs(f2lpgf_c8_kw[7], job->of1);
  

#line 1552 "f2lpgf.ctr"
}



void
f2lpgf_pgf_closepath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  

#line 1564 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[20], job->of1);
  

#line 1566 "f2lpgf.ctr"
}



void
f2lpgf_pgf_fill(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  

#line 1578 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[21], job->of1);
  

#line 1580 "f2lpgf.ctr"
}



void
f2lpgf_pgf_fill_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  

#line 1592 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[22], job->of1);
  

#line 1594 "f2lpgf.ctr"
}



void
f2lpgf_pgf_fill_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  

#line 1606 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[23], job->of1);
  

#line 1608 "f2lpgf.ctr"
}



void
f2lpgf_pgf_fill_stroke_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  

#line 1620 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[24], job->of1);
  

#line 1622 "f2lpgf.ctr"
}



void
f2lpgf_pgf_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  

#line 1634 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[14], job->of1);
  

#line 1636 "f2lpgf.ctr"
}



void
f2lpgf_pgf_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  

#line 1648 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[25], job->of1);
  

#line 1650 "f2lpgf.ctr"
}



void
f2lpgf_pgf_gsave(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  

#line 1662 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[4], job->of1);
  

#line 1664 "f2lpgf.ctr"
}



void
f2lpgf_pgf_grestore(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  

#line 1676 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[5], job->of1);
  

#line 1678 "f2lpgf.ctr"
}



void
f2lpgf_pgf_set_line_width(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 lw
)
{
  

#line 1691 "f2lpgf.ctr"

  fputs(f2lpgf_c8_kw[26], job->of1);
  dk3ma_print_double_c8_no_sci(job->of1, lw);
  fputs(f2lpgf_c8_kw[12], job->of1);
  fputs(f2lpgf_c8_kw[7], job->of1);
  

#line 1697 "f2lpgf.ctr"
}



void
f2lpgf_pgf_set_line_style(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 ls,
  double		 sv,
  double		 lw
)
{
  double	xsv[32];	/* Lengths of strokes and gaps. */
  double	ph;		/* Phase (used length at start). */
  double	gw;		/* Gap width. */
  size_t	nsv;		/* Number of elements in xsv. */
  

#line 1716 "f2lpgf.ctr"
  ph = 0.0; nsv = 0; xsv[0] = 0.0;
  gw = f2lto_find_gap_length(job, lw, sv);
  switch(ls) {
      case DK3_FIG_LS_DASH_TRIPLE_DOTTED: {
        xsv[0] = sv;
	xsv[1] = gw;
	xsv[2] = lw;
	xsv[3] = gw;
	xsv[4] = lw;
	xsv[5] = gw;
	xsv[6] = lw;
	xsv[7] = gw;
	nsv = 8;
      } break;
      case DK3_FIG_LS_DASH_DOUBLE_DOTTED: {
        xsv[0] = sv;
	xsv[1] = gw;
	xsv[2] = lw;
	xsv[3] = gw;
	xsv[4] = lw;
	xsv[5] = gw;
	nsv = 6;
      } break;
      case DK3_FIG_LS_DASH_DOTTED: {
        xsv[0] = sv;
	xsv[1] = gw;
	xsv[2] = lw;
	xsv[3] = gw;
	nsv = 4;
      } break;
      case DK3_FIG_LS_DOTTED: {
        xsv[0] = lw; xsv[1] = gw;
	nsv = 2;
      } break;
      case DK3_FIG_LS_DASHED: {
        xsv[0] = sv; xsv[1] = gw;
	nsv = 2;
      } break;
  }
  f2lpgf_set_line_dash(job->of1, xsv, nsv, ph);
  

#line 1757 "f2lpgf.ctr"
}



void
f2lpgf_pgf_set_line_end(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 le
)
{
  

#line 1770 "f2lpgf.ctr"
  switch(le) {
    case DK3_FIG_LC_PROJECTING: {
      fputs(f2lpgf_c8_kw[29], job->of1);
    } break;
    case DK3_FIG_LC_ROUND: {
      fputs(f2lpgf_c8_kw[30], job->of1);
    } break;
    default: {
      fputs(f2lpgf_c8_kw[31], job->of1);
    } break;
  }
  

#line 1782 "f2lpgf.ctr"
}



void
f2lpgf_pgf_set_line_join(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 lj
)
{
  

#line 1795 "f2lpgf.ctr"
  switch(lj) {
    case DK3_FIG_LJ_BEVEL: {
      fputs(f2lpgf_c8_kw[32], job->of1);
    } break;
    case DK3_FIG_LJ_ROUND: {
      fputs(f2lpgf_c8_kw[33], job->of1);
    } break;
    default: {
      fputs(f2lpgf_c8_kw[34], job->of1);
    } break;
  }
  

#line 1807 "f2lpgf.ctr"
}



void
f2lpgf_pgf_set_color_1(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
)
{
  

#line 1819 "f2lpgf.ctr"
  f2lpgf_define_color(job->of1, 0, rgb);
  fputs(f2lpgf_c8_kw[37], job->of1);
  

#line 1822 "f2lpgf.ctr"
}



void
f2lpgf_pgf_set_color_2(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
)
{
  

#line 1834 "f2lpgf.ctr"
  f2lpgf_define_color(job->of1, 1, rgb);
  fputs(f2lpgf_c8_kw[38], job->of1);
  

#line 1837 "f2lpgf.ctr"
}



void
f2lpgf_pgf_setcolor(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 r,
  double		 g,
  double		 b
)
{
  dk3_rgb_color_t	 rgb;	/* Color cell. */
  

#line 1853 "f2lpgf.ctr"
  rgb.r = r; rgb.g = g; rgb.b = b;
  f2lpgf_pgf_set_color_1(job, drw, &rgb);
  rgb.r = r; rgb.g = g; rgb.b = b;
  f2lpgf_pgf_set_color_2(job, drw, &rgb);
  

#line 1858 "f2lpgf.ctr"
}


void
f2lpgf_pgf_debug(
  f2l_job_t		*job,
  char const		*msg
)
{
  

#line 1868 "f2lpgf.ctr"
  fputs(f2lpgf_c8_kw[39], job->of1);
  fputs(msg, job->of1);
  fputc('\n', job->of1);
  

#line 1872 "f2lpgf.ctr"
}



/* ************************************************************************ */
/* *                                                                      * */
/* *         TeX output driver functions.                                 * */
/* *                                                                      * */
/* ************************************************************************ */


#line 1879 "f2lpgf.ctr"

int
f2lpgf_tex_initialize(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  int		 back = 0;
  back = f2lpgf_pgf_initialize(job, drw);
  return back;
}



void
f2lpgf_tex_end(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  f2lpgf_pgf_end(job, drw);
}



int
f2lpgf_tex_open_output_files(f2l_job_t *job)
{
  int		 back = 0;
  back = f2lpgf_pgf_open_output_files(job);
  return back;
}



void
f2lpgf_tex_close_output_files(f2l_job_t *job)
{
  f2lpgf_pgf_close_output_files(job);
}



int
f2lpgf_tex_start_processing(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  int		 back = 0;
  f2l_tool_begin_latex_document(job->of1, job, drw);
  back = f2lpgf_pgf_start_processing(job, drw);
  return back;
}



void
f2lpgf_tex_end_processing(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  f2lpgf_pgf_end_processing(job, drw);
  f2l_tool_end_latex_document(job->of1, job, drw);
}



void
f2lpgf_tex_text_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  f2lpgf_pgf_text_object(job, drw, obj, x, y);
}



void
f2lpgf_tex_image_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_bb_t		*outbb,
  int			 drawdir,
  int			*ec
)
{
  f2lpgf_pgf_image_object(job, drw, obj, outbb, drawdir, ec);
}



void
f2lpgf_tex_newpath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpgf_pgf_newpath(job, drw, obj);
}



void
f2lpgf_tex_moveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  f2lpgf_pgf_moveto(job, drw, obj, x, y);
}



void
f2lpgf_tex_lineto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  f2lpgf_pgf_lineto(job, drw, obj, x, y);
}



void
f2lpgf_tex_curveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 xcs,
  double		 ycs,
  double		 xce,
  double		 yce,
  double		 xe,
  double		 ye
)
{
  f2lpgf_pgf_curveto(job, drw, obj, xcs, ycs, xce, yce, xe, ye);
}



void
f2lpgf_tex_closepath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpgf_pgf_closepath(job, drw, obj);
}



void
f2lpgf_tex_fill(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpgf_pgf_fill(job, drw, obj);
}



void
f2lpgf_tex_fill_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpgf_pgf_fill_stroke(job, drw, obj);
}



void
f2lpgf_tex_fill_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpgf_pgf_fill_clip(job, drw, obj);
}



void
f2lpgf_tex_fill_stroke_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpgf_pgf_fill_stroke_clip(job, drw, obj);
}



void
f2lpgf_tex_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpgf_pgf_clip(job, drw, obj);
}



void
f2lpgf_tex_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpgf_pgf_stroke(job, drw, obj);
}



void
f2lpgf_tex_gsave(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpgf_pgf_gsave(job, drw, obj);
}



void
f2lpgf_tex_grestore(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpgf_pgf_grestore(job, drw, obj);
}



void
f2lpgf_tex_setcolor(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 r,
  double		 g,
  double		 b
)
{
  f2lpgf_pgf_setcolor(job, drw, obj, r, g, b);
}



void
f2lpgf_tex_set_line_width(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 lw
)
{
  f2lpgf_pgf_set_line_width(job, drw, obj, lw);
}



void
f2lpgf_tex_set_line_style(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 ls,
  double		 sv,
  double		 lw
)
{
  f2lpgf_pgf_set_line_style(job, drw, obj, ls, sv, lw);
}



void
f2lpgf_tex_set_line_end(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 le
)
{
  f2lpgf_pgf_set_line_end(job, drw, obj, le);
}



void
f2lpgf_tex_set_line_join(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 lj
)
{
  f2lpgf_pgf_set_line_join(job, drw, obj, lj);
}



void
f2lpgf_tex_set_color_1(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
)
{
  f2lpgf_pgf_set_color_1(job, drw, rgb);
}



void
f2lpgf_tex_set_color_2(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
)
{
  f2lpgf_pgf_set_color_2(job, drw, rgb);
}



void
f2lpgf_tex_debug(
  f2l_job_t		*job,
  char const		*msg
)
{
  f2lpgf_pgf_debug(job, msg);
}

