/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: f2lpdf.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file f2lpdf.c The f2lpdf module.
*/


#line 699 "f2lpdf.ctr"

#include "dk3all.h"
#include "dk3bezcu.h"
#include "fig2lat.h"
#include "f2lud.h"
#include "f2lsvg.h"
#include "f2lpdf.h"
#include "dk3figto.h"
#include "dkt-version.h"
#include "dk3bmeo.h"
#include "dk3bm.h"
#include "dk3pdf.h"
#include "dk3bif.h"





#line 716 "f2lpdf.ctr"



/**	Driver specific details for entire drawing.
*/
typedef struct {
  dk3_pdf_t		*opdf;		/**< Output PDF. */
  dk3_sto_t		*sFonts;	/**< Storage for fonts. */
  dk3_sto_it_t		*iFonts;	/**< Iterator for font storage. */
  dk3_sto_t		*sImages;	/**< Storage for image data. */
  dk3_sto_it_t		*iImages;	/**< Iterator for images storage. */
  char const		*shortOutFile;	/**< Short output file name. */
  unsigned long		 nFonts;	/**< Number of fonts in sFonts. */
  unsigned long		 nImages;	/**< Number of images in sImages. */
} f2l_pdf_drawing_info_t;






/* ************************************************************************ */
/* *                                                                      * */
/* *         Tool functions.                                              * */
/* *                                                                      * */
/* ************************************************************************ */


#line 740 "f2lpdf.ctr"



/**	Delete driver-specific details.
	@param	ptr	Structure to delete.
*/
static
void
f2lpdf_drawing_info_delete(f2l_pdf_drawing_info_t *ptr)
{
  f2l_text_handling_t		*th;
  f2l_image_t			*im;
  

#line 753 "f2lpdf.ctr"
  if(ptr) {
    dk3_release(ptr->shortOutFile);
    if(ptr->opdf) {
      dk3pdf_close(ptr->opdf);
    } ptr->opdf = NULL;
    if(ptr->sFonts) {
      if(ptr->iFonts) {
        dk3sto_it_reset(ptr->iFonts);
	while(NULL != (th = (f2l_text_handling_t *)dk3sto_it_next(ptr->iFonts)))
	{
	  dk3_delete(th);
	}
	dk3sto_it_close(ptr->iFonts);
      }
      dk3sto_close(ptr->sFonts);
    } ptr->sFonts = NULL; ptr->iFonts = NULL;
    if(ptr->sImages) {
      if(ptr->iImages) {
        dk3sto_it_reset(ptr->iImages);
	while(NULL != (im = (f2l_image_t *)dk3sto_it_next(ptr->iImages))) {
	  f2l_tool_image_delete(im);
	}
	dk3sto_it_close(ptr->iImages);
      }
      dk3sto_close(ptr->sImages);
    } ptr->sImages = NULL; ptr->iImages = NULL;
    ptr->nFonts = 0UL;
    ptr->nImages = 0UL;
    dk3_delete(ptr);
  } 

#line 783 "f2lpdf.ctr"
}



/**	Create structure for driver-specific details.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@return	Pointer to new structure on success, NULL on error.
*/
static
f2l_pdf_drawing_info_t *
f2lpdf_drawing_info_new(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw
)
{
  f2l_pdf_drawing_info_t	*back	= NULL;
  int				 ok	= 0;	/* Flag: No error. */
  

#line 802 "f2lpdf.ctr"
  if((job) && (drw)) {
    back = dk3_new_app(f2l_pdf_drawing_info_t,1,job->app);
    if(back) {
      back->shortOutFile = NULL;
      back->opdf = NULL;
      back->sFonts = NULL;
      back->iFonts = NULL;
      back->sImages = NULL;
      back->iImages = NULL;
      back->nFonts = 0UL;
      back->nImages = 0UL;
      back->sFonts = dk3sto_open_app(job->app);
      if(back->sFonts) {
        dk3sto_set_comp(back->sFonts, dk3fig_tool_text_handling_compare, 0);
        back->iFonts = dk3sto_it_open(back->sFonts);
	if(back->iFonts) {
	  back->sImages = dk3sto_open_app(job->app);
	  if(back->sImages) {
	    dk3sto_set_comp(back->sImages, f2l_tool_compare_images, 0);
	    back->iImages = dk3sto_it_open(back->sImages);
	    if(back->iImages) {
	      back->opdf = dk3pdf_open_app(job->app);
	      if(back->opdf) {
	        ok = 1;
	      }
	    }
	  }
	}
      }
      if(!(ok)) {
        f2lpdf_drawing_info_delete(back);
	back = NULL;
      }
    } else {
    }
  } 

#line 838 "f2lpdf.ctr"
  return back;
}



/* ************************************************************************ */
/* *                                                                      * */
/* *         PDF with LaTeX output driver.                                * */
/* *         This driver creates .tex/.pdf combinations to be included    * */
/* *         in a .tex source.                                            * */
/* *                                                                      * */
/* ************************************************************************ */


#line 848 "f2lpdf.ctr"



/**	Register image file name in pdi for later use.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	pdi	PDF information structure.
	@param	fn	Image file name to add.
	@param	li	Line number of image object definition.
	@return	1 on success, 0 on error.
*/
static
f2l_image_t *
f2lpdf_register_image(
  f2l_job_t			*job,
  dk3_fig_drawing_t		*drw,
  f2l_pdf_drawing_info_t	*pdi,
  char const			*fn,
  unsigned long			 li
)
{
  dk3_ufi_t		 ufi;		/* Unique file identifier. */
  f2l_image_t		*back = NULL;	/* Image information structure. */

  if(dk3ufi_c8_get_app(&ufi, fn, job->app)) {
    back = (f2l_image_t *)dk3sto_it_find_like(pdi->iImages, (void *)(&ufi), 1);
    if(!(back)) {
      back = f2l_tool_image_new(fn, job->app, li);
      if(back) {
        if(dk3sto_add(pdi->sImages, (void *)back)) {
	  back->imageNumber = pdi->nImages;
	  pdi->nImages += 1UL;
	} else {
	  f2l_tool_image_delete(back);
	  back = NULL;
	  f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 884 "f2lpdf.ctr"
	}
      } else {
	f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 887 "f2lpdf.ctr"
      }
    }
  } else {
    f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 891 "f2lpdf.ctr"
  }
  return back;
}



/**	Add image XObject data to PDF.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	pdi	PDF information structure.
	@param	im	Image information to add.
	@return	1 on success, 0 on error.
*/
static
int
f2lpdf_add_image_to_pdf(
  f2l_job_t			*job,
  dk3_fig_drawing_t		*drw,
  f2l_pdf_drawing_info_t	*pdi,
  f2l_image_t			*im
)
{
  dk3_bm_eps_options_t	 options;	/* Options for PDF conversion. */
  dk3_bif_t		*bif;		/* Bitmap image file. */
  int			 back = 0;
  

#line 917 "f2lpdf.ctr"
  bif = dk3bif_open_c8_filename_app(
    im->filename, DK3_BIF_IMAGE_TYPE_UNKNOWN, job->app
  );
  if(bif) {
    dk3bmeo_init(&options);
    options.app = job->app;
    options.ip = 1;
    options.jip = 0;
    options.mode = DK3_BMEPS_MODE_PLACED_OBJECT;
    options.szmode = DK3_BMEPS_SIZE_1_1;	

#line 927 "f2lpdf.ctr"
    options.dr = DK3_BMEPS_DRIVER_PDF;
    options.rbpc = 1;
    options.dct = 1;
    options.color = 1;
    if(dk3bif_read_data(bif)) {
      im->xo = dk3pdf_create_ixobject_progress(pdi->opdf,bif,&options,NULL,0,0);
      im->width = dk3bif_get_width(bif);
      im->height = dk3bif_get_height(bif);
      im->xres = dk3bif_get_xres(bif);
      im->yres = dk3bif_get_yres(bif);
      if(im->xo) {
        back = 1;
      } else {
	f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 941 "f2lpdf.ctr"
      }
    } else {
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 944 "f2lpdf.ctr"
    }
    dk3bif_close(bif);
  } else {
    f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 948 "f2lpdf.ctr"
  }
  

#line 950 "f2lpdf.ctr"
  return back;
}



int
f2lpdf_pdf_with_tex_initialize(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  f2l_pdf_drawing_info_t	*pdi;			/* Driver spec det. */
  dk3_fig_obj_t			*pobj;			/* Current object. */
  f2l_image_t			*im;			/* Current image. */
  dkChar const			*oldsourcefile = NULL;	/* Old source file. */
  unsigned long			 oldsourceline = 0UL;	/* Old source line. */
  int		 		 back = 0;
  int				 ff;			/* Font flags. */
  

#line 966 "f2lpdf.ctr"
  pdi = f2lpdf_drawing_info_new(job, drw);
  if(pdi) {
    drw->dsd = (void *)pdi;
    pdi->shortOutFile = dk3fig_tool_short_output_file_name(job->on2, job->app);
    if(pdi->shortOutFile) {
      back = 1;
      dk3pdf_set_next_mediabox(pdi->opdf, 0L, job->lwidth, 0L, job->lheight);
        oldsourcefile = dk3app_get_source_file(job->app);
        oldsourceline = dk3app_get_source_line(job->app);
        dk3sto_it_reset(drw->iobj);
        while(NULL != (pobj = (dk3_fig_obj_t *)dk3sto_it_next(drw->iobj))) {
          

#line 978 "f2lpdf.ctr"
	  dk3app_set_source_line(job->app, pobj->li);
	  switch(pobj->ot) {
	    case DK3_FIG_OBJ_TEXT: {
	      ff = (pobj->dt).txt.ff;
	      if(!(ff & DK3_FIG_FONT_FLAG_HIDDEN)) {	

#line 983 "f2lpdf.ctr"
	        if(!(ff & DK3_FIG_FONT_FLAG_SPECIAL)) {	

#line 984 "f2lpdf.ctr"
	          if(ff & DK3_FIG_FONT_FLAG_PS) {		

#line 985 "f2lpdf.ctr"
	            if(job->ntf) {			

#line 986 "f2lpdf.ctr"
		      pobj->dsd = (void *)f2l_tool_register_font(
		        pdi->sFonts, pdi->iFonts, &(pdi->nFonts),
		        (pobj->dt).txt.fo, (pobj->dt).txt.fs, job->app
		      );
		      if(!(pobj->dsd)) {
		        back = 0;			

#line 992 "f2lpdf.ctr"
			f2l_tool_set_exit_status(job,FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 993 "f2lpdf.ctr"
		      }
		    } else {				

#line 995 "f2lpdf.ctr"
		    }
	          }
	        }
	      }
	    } break;
	    case DK3_FIG_OBJ_POLYLINE: {
	      if(5 == pobj->st) {				

#line 1002 "f2lpdf.ctr"
	        pobj->dsd = 
		(void *)f2lpdf_register_image(
		  job, drw, pdi, (pobj->dt).pol.fn, pobj->li
		);
		if(!(pobj->dsd)) {
		  back = 0;
		  f2l_tool_set_exit_status(job,FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1009 "f2lpdf.ctr"
		}
	      }
	    } break;
	  }
        }
        dk3sto_it_reset(pdi->iImages);
        while(NULL != (im = (f2l_image_t *)dk3sto_it_next(pdi->iImages))) {
	  if(!f2lpdf_add_image_to_pdf(job, drw, pdi, im)) {	

#line 1017 "f2lpdf.ctr"
	    back = 0;
	    f2l_tool_set_exit_status(job,FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1019 "f2lpdf.ctr"
	  }
        }
        dk3app_set_source_file(job->app, oldsourcefile);
        dk3app_set_source_line(job->app, oldsourceline);
    } else {
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1025 "f2lpdf.ctr"
    }
  } else {
    f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1028 "f2lpdf.ctr"
  } 

#line 1029 "f2lpdf.ctr"
  return back;
}



void
f2lpdf_pdf_with_tex_end(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  if(drw->dsd) {
    f2lpdf_drawing_info_delete((f2l_pdf_drawing_info_t *)(drw->dsd));
    drw->dsd = NULL;
  }
}



int
f2lpdf_pdf_with_tex_open_output_files(f2l_job_t *job)
{
  int		 back = 0;
  job->of1 = dk3sf_fopen_app(job->on1, dkT("w"), job->app);
  if(job->of1) {
    job->of2 = dk3sf_fopen_app(job->on2, dkT("wb"), job->app);
    if(job->of2) {
      back = 1;
    } else {
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1056 "f2lpdf.ctr"
    }
  } else {
    f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1059 "f2lpdf.ctr"
  }
  return back;
}



void
f2lpdf_pdf_with_tex_close_output_files(f2l_job_t *job)
{
  if(job->of2) {
    dk3sf_fclose_app(job->of2, job->app);
  }
  if(job->of1) {
    dk3sf_fclose_app(job->of1, job->app);
  }
}



int
f2lpdf_pdf_with_tex_start_processing(f2l_job_t *job, dk3_fig_drawing_t *drw)
{

  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int		 back = 0;

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  f2l_tool_start_tex_part(
    job->of1, job, drw, pdi->shortOutFile, pdi->iFonts, pdi->nFonts
  );
  if(dk3pdf_open_page_with_clip(pdi->opdf, 1)) {
    back = 1;
  } else {
    f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1093 "f2lpdf.ctr"
  }
  return back;
}



void
f2lpdf_pdf_with_tex_end_processing(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  f2l_tool_end_tex_part(job->of1);
  dk3pdf_close_page(pdi->opdf);
  if(!dk3pdf_write_file(pdi->opdf, job->of2)) {
    /* ERROR: Failed to write PDF output file! */
    f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1110 "f2lpdf.ctr"
  }
}



void
f2lpdf_pdf_with_tex_text_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    f2l_tool_text_object(job->of1, job, drw, obj, x, y, pdi->nFonts);
  }
}



void
f2lpdf_pdf_with_tex_image_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_bb_t		*outbb,
  int			 drawdir,
  int			*ec
)
{
  dk3_coordinates_transformation_t	 trans;	/* Graphics state transform. */
  f2l_pdf_drawing_info_t		*pdi;	/* Driver specific details. */
  f2l_image_t				*im;	/* Current image. */
  int					 res;	/* Search result. */
  

#line 1149 "f2lpdf.ctr"
  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  im = (f2l_image_t *)(obj->dsd);
  if((im) && (pdi)) {		

#line 1152 "f2lpdf.ctr"
    if(im->xo) {		

#line 1153 "f2lpdf.ctr"
      res = dk3bm_find_transformation(
        &trans, outbb, drawdir, (double)(im->width), (double)(im->height),
	im->xres, im->yres, ec
      );
      if(res) {			

#line 1158 "f2lpdf.ctr"
        res = dk3pdf_gsave(pdi->opdf);
	if(!(res)) {		

#line 1160 "f2lpdf.ctr"
	  /* ERROR */
          dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
	  f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1163 "f2lpdf.ctr"
	}
	res =
	dk3pdf_translate_double(pdi->opdf,trans.x_translate,trans.y_translate);
	if(!(res)) {		

#line 1167 "f2lpdf.ctr"
	  /* ERROR */
          dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
	  f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1170 "f2lpdf.ctr"
	}
	if(trans.rot) {
	  res = dk3pdf_rotate_int(pdi->opdf, (90 * trans.rot));
	  if(!(res)) {		

#line 1174 "f2lpdf.ctr"
	    /* ERROR */
            dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
	    f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1177 "f2lpdf.ctr"
	  }
	}
	res = dk3pdf_scale_double(pdi->opdf, trans.x_scale, trans.y_scale);
	if(!(res)) {		

#line 1181 "f2lpdf.ctr"
	  /* ERROR */
          dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
	  f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1184 "f2lpdf.ctr"
	}
	res = dk3pdf_add_xobject_to_page(pdi->opdf, im->xo);
	if(!(res)) {		

#line 1187 "f2lpdf.ctr"
	  /* ERROR */
          dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
	  f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1190 "f2lpdf.ctr"
	}
	res = dk3pdf_grestore(pdi->opdf);
	if(!(res)) {		

#line 1193 "f2lpdf.ctr"
	  /* ERROR */
          dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
	  f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1196 "f2lpdf.ctr"
	}
      } else {			

#line 1198 "f2lpdf.ctr"
        /* ERROR: Math error while searching transformation! */
        dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 35);
        f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_MATH); 

#line 1201 "f2lpdf.ctr"
      }
    } else {			

#line 1203 "f2lpdf.ctr"
    }
  } else {			

#line 1205 "f2lpdf.ctr"
  } 

#line 1206 "f2lpdf.ctr"
}



void
f2lpdf_pdf_with_tex_newpath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  /* Do nothing, in PDF the moveto operator includes newpath. */
}



void
f2lpdf_pdf_with_tex_moveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_newpath_moveto(pdi->opdf, x, y);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1240 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_lineto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Ouutput operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_lineto(pdi->opdf, x, y);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1264 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_curveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 xcs,
  double		 ycs,
  double		 xce,
  double		 yce,
  double		 xe,
  double		 ye
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */
  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_curveto(pdi->opdf, xcs, ycs, xce, yce, xe, ye);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1291 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_closepath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_closepath(pdi->opdf);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1313 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_fill(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_fill_eo(pdi->opdf);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1335 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_clip_eo(pdi->opdf);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1357 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_stroke(pdi->opdf);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1379 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_gsave(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_gsave(pdi->opdf);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1401 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_grestore(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_grestore(pdi->opdf);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1423 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_setcolor(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 r,
  double		 g,
  double		 b
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_nonstroking_rgb(pdi->opdf, r, g, b);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1448 "f2lpdf.ctr"
    }
    res = dk3pdf_stroking_rgb(pdi->opdf, r, g, b);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1453 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_set_line_width(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 lw
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_set_linewidth(pdi->opdf, lw);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1476 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_set_line_style(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 ls,
  double		 sv,
  double		 lw
)
{
  double		 	 xsv[32];	/* Strokes and gaps lengths. */
  f2l_pdf_drawing_info_t	*pdi;		/* Driver specific details. */
  double			 ph;		/* Phase. */
  double			 gw;		/* Gap width. */
  size_t			 nsv;		/* Number of elements xsv. */
  int				 res;		/* Output operation result. */

  ph = 0.0;
  nsv = 0;
  xsv[0] = 0.0;
  gw = f2lto_find_gap_length(job, lw, sv);
  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    switch(ls) {
      case DK3_FIG_LS_DASH_TRIPLE_DOTTED: {
        xsv[0] = sv;
	xsv[1] = gw;
	xsv[2] = lw;
	xsv[3] = gw;
	xsv[4] = lw;
	xsv[5] = gw;
	xsv[6] = lw;
	xsv[7] = gw;
	nsv = 8;
      } break;
      case DK3_FIG_LS_DASH_DOUBLE_DOTTED: {
        xsv[0] = sv;
	xsv[1] = gw;
	xsv[2] = lw;
	xsv[3] = gw;
	xsv[4] = lw;
	xsv[5] = gw;
	nsv = 6;
      } break;
      case DK3_FIG_LS_DASH_DOTTED: {
        xsv[0] = sv;
	xsv[1] = gw;
	xsv[2] = lw;
	xsv[3] = gw;
	nsv = 4;
      } break;
      case DK3_FIG_LS_DOTTED: {
        xsv[0] = lw; xsv[1] = gw;
	nsv = 2;
      } break;
      case DK3_FIG_LS_DASHED: {
        xsv[0] = sv; xsv[1] = gw;
	nsv = 2;
      } break;
    }
    res = dk3pdf_set_line_dash(pdi->opdf, xsv, nsv, ph);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1546 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_set_line_end(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 le
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_set_linecap(pdi->opdf, le);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1569 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_set_line_join(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 lj
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_set_linejoin(pdi->opdf, lj);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1592 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_set_color_1(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_stroking_rgb(pdi->opdf, rgb->r, rgb->g, rgb->b);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1614 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_set_color_2(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)(drw->dsd);
  if(pdi) {
    res = dk3pdf_nonstroking_rgb(pdi->opdf, rgb->r, rgb->g, rgb->b);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1636 "f2lpdf.ctr"
    }
  }
}



void
f2lpdf_pdf_with_tex_debug(
  f2l_job_t		*job,
  char const		*msg
)
{
  f2l_pdf_drawing_info_t	*pdi;	/* Driver specific details. */
  int				 res;	/* Output operation result. */

  pdi = (f2l_pdf_drawing_info_t *)((job->drw)->dsd);
  if(pdi) {
    res = dk3pdf_write_debug_line(pdi->opdf, msg);
    if(!(res)) {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1657 "f2lpdf.ctr"
    }
  }
}



/* ************************************************************************ */
/* *                                                                      * */
/* *         LaTeX with PDF output driver.                                * */
/* *         This driver combines .tex/.pdf combinations to be            * */
/* *         processed with pdflatex directly.                            * */
/* *                                                                      * */
/* ************************************************************************ */


#line 1668 "f2lpdf.ctr"



int
f2lpdf_tex_with_pdf_initialize(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  int		 back = 0;
  back = f2lpdf_pdf_with_tex_initialize(job, drw);
  return back;
}



void
f2lpdf_tex_with_pdf_end(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  f2lpdf_pdf_with_tex_end(job, drw);
}



int
f2lpdf_tex_with_pdf_open_output_files(f2l_job_t *job)
{
  int		 back = 0;
  back = f2lpdf_pdf_with_tex_open_output_files(job);
  return back;
}



void
f2lpdf_tex_with_pdf_close_output_files(f2l_job_t *job)
{
  f2lpdf_pdf_with_tex_close_output_files(job);
}



int
f2lpdf_tex_with_pdf_start_processing(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  int		 back = 0;
  f2l_tool_begin_latex_document(job->of1, job, drw);
  back = f2lpdf_pdf_with_tex_start_processing(job, drw);
  return back;
}



void
f2lpdf_tex_with_pdf_end_processing(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  f2lpdf_pdf_with_tex_end_processing(job, drw);
  f2l_tool_end_latex_document(job->of1, job, drw);
}



void
f2lpdf_tex_with_pdf_text_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  f2lpdf_pdf_with_tex_text_object(job, drw, obj, x, y);
}



void
f2lpdf_tex_with_pdf_image_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_bb_t		*outbb,
  int			 drawdir,
  int			*ec
)
{
  f2lpdf_pdf_with_tex_image_object(job, drw, obj, outbb, drawdir, ec);
}



void
f2lpdf_tex_with_pdf_newpath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpdf_pdf_with_tex_newpath(job, drw, obj);
}



void
f2lpdf_tex_with_pdf_moveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  f2lpdf_pdf_with_tex_moveto(job, drw, obj, x, y);
}



void
f2lpdf_tex_with_pdf_lineto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  f2lpdf_pdf_with_tex_lineto(job, drw, obj, x, y);
}



void
f2lpdf_tex_with_pdf_curveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 xcs,
  double		 ycs,
  double		 xce,
  double		 yce,
  double		 xe,
  double		 ye
)
{
  f2lpdf_pdf_with_tex_curveto(job, drw, obj, xcs, ycs, xce, yce, xe, ye);
}



void
f2lpdf_tex_with_pdf_closepath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpdf_pdf_with_tex_closepath(job, drw, obj);
}



void
f2lpdf_tex_with_pdf_fill(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpdf_pdf_with_tex_fill(job, drw, obj);
}



void
f2lpdf_tex_with_pdf_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpdf_pdf_with_tex_clip(job, drw, obj);
}



void
f2lpdf_tex_with_pdf_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpdf_pdf_with_tex_stroke(job, drw, obj);
}



void
f2lpdf_tex_with_pdf_gsave(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpdf_pdf_with_tex_gsave(job, drw, obj);
}



void
f2lpdf_tex_with_pdf_grestore(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  f2lpdf_pdf_with_tex_grestore(job, drw, obj);
}



void
f2lpdf_tex_with_pdf_setcolor(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 r,
  double		 g,
  double		 b
)
{
  f2lpdf_pdf_with_tex_setcolor(job, drw, obj, r, g, b);
}



void
f2lpdf_tex_with_pdf_set_line_width(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 lw
)
{
  f2lpdf_pdf_with_tex_set_line_width(job, drw, obj, lw);
}



void
f2lpdf_tex_with_pdf_set_line_style(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 ls,
  double		 sv,
  double		 lw
)
{
  f2lpdf_pdf_with_tex_set_line_style(job, drw, obj, ls, sv, lw);
}



void
f2lpdf_tex_with_pdf_set_line_end(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 le
)
{
  f2lpdf_pdf_with_tex_set_line_end(job, drw, obj, le);
}



void
f2lpdf_tex_with_pdf_set_line_join(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 lj
)
{
  f2lpdf_pdf_with_tex_set_line_join(job, drw, obj, lj);
}



void
f2lpdf_tex_with_pdf_set_color_1(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
)
{
  f2lpdf_pdf_with_tex_set_color_1(job, drw, rgb);
}



void
f2lpdf_tex_with_pdf_set_color_2(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
)
{
  f2lpdf_pdf_with_tex_set_color_2(job, drw, rgb);
}



void
f2lpdf_tex_with_pdf_debug(
  f2l_job_t		*job,
  char const		*msg
)
{
  f2lpdf_pdf_with_tex_debug(job, msg);
}

