/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: f2lpara.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file f2lpara.h Header file for the f2lpara module.
*/

#ifndef F2LPARA_H_INCLUDED
/** Avoid multiple inclusions. */
#define F2LPARA_H_INCLUDED 1


#line 10 "f2lpara.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Get left point first derivative value for parabola
	through x=-1, x=0, and x=1.
	@param	yneg	Y value for x=-1.
	@param	y0	Y value for x=0.
	@param	ypos	Y value for x=1.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Result.
*/
double
f2lpara_derived_left(double yneg, double y0, double ypos, int *ec);

/**	Get center point first derivative value for parabola
	through x=-1, x=0, and x=1.
	@param	yneg	Y value for x=-1.
	@param	y0	Y value for x=0.
	@param	ypos	Y value for x=1.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Result.
*/
double
f2lpara_derived_center(double yneg, double y0, double ypos, int *ec);

/**	Get right point first derivative value for parabola
	through x=-1, x=0, and x=1.
	@param	yneg	Y value for x=-1.
	@param	y0	Y value for x=0.
	@param	ypos	Y value for x=1.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Result.
*/
double
f2lpara_derived_right(double yneg, double y0, double ypos, int *ec);


#ifdef __cplusplus
}
#endif


#endif
