/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: f2lpara.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file f2lpara.c The f2lpara module.
*/


#line 54 "f2lpara.ctr"


#include "dk3ma.h"
#include "f2lpara.h"


double
f2lpara_derived_left(double yneg, double y0, double ypos, int *ec)
{
  double		back	= 0.0;
  int			myec	= 0;
  /* back = 2 * y0 - 0.5 * ypos - 1.5 * yneg */
  back = dk3ma_d_sub_ok(
    dk3ma_d_mul_ok(2.0, y0, &myec),
    dk3ma_d_add_ok(
      (0.5 * ypos),
      dk3ma_d_mul_ok(1.5, yneg, &myec),
      &myec
    ),
    &myec
  );
  if (myec) { if (ec) { *ec = myec; } }
  return back;
}


double
f2lpara_derived_center(double yneg, double y0, double ypos, int *ec)
{
  double		back	= 0.0;
  int			myec	= 0;
  /* back = 0.5 * (ypos - yneg)  */
  back = 0.5 * dk3ma_d_sub_ok(ypos, yneg, &myec);
  if (myec) { if (ec) { *ec = myec; } }
  return back;
}


double
f2lpara_derived_right(double yneg, double y0, double ypos, int *ec)
{
  double		back	= 0.0;
  int			myec	= 0;
  /* back = 1.5 * ypos + 0.5 * yneg - 2 * y0 */
  back = dk3ma_d_sub_ok(
    dk3ma_d_add_ok(
      dk3ma_d_mul_ok(1.5, ypos, &myec),
      (0.5 * yneg),
      &myec
    ),
    dk3ma_d_mul_ok(2.0, y0, &myec),
    &myec
  );
  if (myec) { if (ec) { *ec = myec; } }
  return back;
}

