/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: f2lopt.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file f2lopt.c The f2lopt module.
*/


#line 29 "f2lopt.ctr"

#include "fig2lat.h"





#line 35 "f2lopt.ctr"



/**	Options for the fig2lat program.
*/
static dk3_option_t const f2lopt_options[] = {
  { dkT('h'), dkT("help"), 0 },
  { dkT('v'), dkT("version"), 0 },
  { dkT('L'), dkT("license-terms"), 0 },
  { dkT('l'), dkT("language"), 1 },
  { dkT('m'), dkT("make"), 0 }
};

/**	Number of options in f2lopt_options.
*/
static size_t const f2lopt_sz_options =
sizeof(f2lopt_options)/sizeof(dk3_option_t);



/**	Key names for key/value pairs.
*/
static dkChar const * f2lopt_key_names[] = {
/* 0 */
dkT("tf"),

/* 1 */
dkT("ts"),

/* 2 */
dkT("cosp"),

/* 3 */
dkT("coah"),

/* 4 */
dkT("xsss"),

/* 5 */
dkT("qbs"),

/* 6 */
dkT("lw"),

/* 7 */
dkT("debug"),

/* 8 */
dkT("showpage"),

/* 9 */
dkT("level"),

/* 10 */
dkT("dsc"),

/* 11 */
dkT("xfig"),

/* 12 */
dkT("jfig"),

/* 13 */
dkT("winfig"),

/* 14 */
dkT("ahas"),

/* 15 */
dkT("ahss"),

/* 16 */
dkT("ahms"),

/* 17 */
dkT("ahip"),

/* 18 */
dkT("smash"),

/* 19 */
dkT("mbox"),

/* 20 */
dkT("reset@font"),

/* 21 */
dkT("codi"),

/* 22 */
dkT("dcts"),

/* 23 */
dkT("css"),

/* 24 */
dkT("fragment"),

/* 25 */
dkT("fontbase"),

/* 26 */
dkT("group"),

/* 27 */
dkT("miterlimit"),

/* 28 */
dkT("cols"),

/* 29 */
dkT("replacementfonts"),

/* 30 */
dkT("bbts"),

/* 31 */
dkT("ste"),

/* 32 */
dkT("cofop"),

/* 33 */
dkT("xsah"),

NULL


#line 197 "f2lopt.ctr"
};



/**	Values for font base choices.
*/
static dkChar const * const f2lopt_svg_font_bases[] = {
/* 0 */
dkT("none"),

/* 1 */
dkT("local"),

/* 2 */
dkT("web"),

NULL


#line 209 "f2lopt.ctr"
};


/**	Fixed keywords used by the module, not localized.
*/
static dkChar const * const f2lopt_kw[] = {
/* 0 */
dkT("none"),

/* 1 */
dkT("lighten"),

/* 2 */
dkT("auto$matic"),

NULL


#line 229 "f2lopt.ctr"
};



/**	Units for line width specification.
*/
static dkChar const * const	f2lopt_units[] = {
/* 0 */
dkT("bp"),

/* 1 */
dkT("pt"),

/* 2 */
dkT("in"),

/* 3 */
dkT("mm"),

/* 4 */
dkT("cm"),

NULL


#line 243 "f2lopt.ctr"
};


/**	Language (output driver) names.
	The order of names must correspond the the numbers defined
	in fig2lat.ctr, see @ref fig2latdrivers.
*/
static dkChar const * const	f2lopt_language_names[] = {
/* 0 */
dkT("pgf"),

/* 1 */
dkT("tex"),

/* 2 */
dkT("tex.pdf"),

/* 3 */
dkT("eps.tex"),

/* 4 */
dkT("pdf.tex"),

/* 5 */
dkT("eps"),

/* 6 */
dkT("svg"),

NULL


#line 264 "f2lopt.ctr"
};



/**	Keywords for font name decision.
*/
static dkChar const * f2lopt_text_font_names[] = {
/* 0 */
dkT("similar"),

/* 1 */
dkT("fig"),

NULL


#line 281 "f2lopt.ctr"
};



/**	Set default options depending on the driver just configured.
	@param	job	Job structure.
*/
static
void
f2lopt_set_default_options_for_language(f2l_job_t *job)
{
  

#line 293 "f2lopt.ctr"
  job->ntf =    0;
  job->nts = -1.0;
  job->showpage = 0;
  job->dsc = 0;
  job->smash = 1;
  job->mbox = 0;
  job->resfont = 0;
  switch(job->dr) {
    case FIG2LAT_DRIVER_EPS_STANDALONE: {
      job->ntf =    1;
      job->showpage = 1;
      job->dsc = 1;
      job->smash = 0;
      job->mbox = 0;
      job->resfont = 0;
    } break;
    case FIG2LAT_DRIVER_SVG_STANDALONE:
    {
      job->smash = 0; job->mbox = 0; job->resfont = 0;
    }
    case FIG2LAT_DRIVER_TEX_FULL_PGF:
    case FIG2LAT_DRIVER_TEX_FULL_PDF:
    {
      job->ntf =    1;
    } break;
  }
  

#line 320 "f2lopt.ctr"
}



/**	Set language.
	@param	job	Job structure to configure.
	@param	lstr	Language name without trailing options.
	@return	1 on success, 0 on error.
*/
static
int
f2lopt_apply_language(f2l_job_t *job, dkChar const *lstr)
{
  int			 back = 0;
  

#line 335 "f2lopt.ctr"
  job->dr = dk3str_array_index(f2lopt_language_names, lstr, 0);
  if(job->dr > -1) {
    back = 1;
    f2lopt_set_default_options_for_language(job);
  } else {						

#line 340 "f2lopt.ctr"
    /* ERROR: Unknown language ... */
    dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 7, 8, lstr);
    job->exval = FIG2LAT_EXIT_ERROR_SYNTAX; 

#line 343 "f2lopt.ctr"
  } 

#line 344 "f2lopt.ctr"
  return back;
}



/**	Set text font.
	@param	job	Job structure.
	@param	vptr	Font specification (similar or fig).
	@return	1 on success, 0 on error.
*/
static
int
f2lopt_set_text_font(f2l_job_t *job, dkChar const *vptr)
{
  int	 i;		/* Decision for font handling. */
  int	 back = 0;
  

#line 361 "f2lopt.ctr"
  switch((i = dk3str_array_index(f2lopt_text_font_names, vptr, 0))) {
    case 0: case 1: {		

#line 363 "f2lopt.ctr"
      job->ntf = i;
      back = 1;
    } break;
    default: {			

#line 367 "f2lopt.ctr"
      /* ERROR: No such text font selection! */
      dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 9, 10, vptr);
    } break;
  }
  

#line 372 "f2lopt.ctr"
  return back;
}



/**	Set text size.
	@param	job	Job structure.
	@param	vptr	Text size as string (none or scale factor).
	@return	1 on success, 0 on error.
*/
static
int
f2lopt_set_text_size(f2l_job_t *job, dkChar const *vptr)
{
  double	 d;		/* Font size factor. */
  int		 back = 0;
  

#line 389 "f2lopt.ctr"
  if(dk3str_cmp(vptr, f2lopt_kw[0]) == 0) {		

#line 390 "f2lopt.ctr"
    job->nts = -1.0;
    back = 1;
  } else {
#if VERSION_BEFORE_20140716
    if(dk3sf_sscanf3(vptr, dkT("%lf"), &d) == 1)
#else
    if (0 != dk3ma_d_from_string(&d, vptr, NULL))
#endif
    {	

#line 399 "f2lopt.ctr"
      job->nts = d;
      back = 1;
    } else {						

#line 402 "f2lopt.ctr"
      /* ERROR: Invalid font size specification! */
      dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 11, 12, vptr);
    }
  }
  

#line 407 "f2lopt.ctr"
  return back;
}



/**	Read a size_t from text.
	@param	dptr	Pointer to destination variable.
	@param	vptr	Source text.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
f2lopt_read_size_t(size_t *dptr, dkChar const *vptr, f2l_job_t *job)
{
#if VERSION_BEFORE_20140809
  unsigned	u;		/* Conversion result. */
  int	 	back = 0;
  if(1 == dk3sf_sscanf3(vptr, dkT("%u"), &u)) {
    *dptr = (size_t)u;
    back = 1;
    if((unsigned)(*dptr) != u) {
      back = 0;
      /* ERROR: Range overflow */
      dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 13, 14, vptr);
    }
  } else {
    /* ERRROR: Not a number! */
    dk3app_log_i3(job->app, DK3_LL_ERROR, 141, 142, vptr);
  }
  return back;
#else
  dk3_um_t	um	= DK3_UM_0;
  int		back	= 0;
  int		mec	= 0;

  if (dk3ma_um_from_string(&um, vptr, NULL)) {		/* OK: Number */
    *dptr = dk3ma_um_to_sz(um, &mec);
    if (0 == mec) {				/* OK: Converted */
      back = 1;
    } else {					/* Overflow */
      dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 13, 14, vptr);
    }
  } else {					/* Not a number */
    dk3app_log_i3(job->app, DK3_LL_ERROR, 141, 142, vptr);
  }
  return back;
#endif
}



/**	Read double value from string to configuration variable.
	@param	job	Job structure.
	@param	dvar	Pointer to destination variable.
	@param	src	Source text.
	@param	min	Minimum value.
	@param	max	Maximum value.
	@param	tp	Type (1=check minimum, 2=positive number + check max).
	@param	optnr	Option index, used for error messages.
	@return	1 on success, 0 on error.
*/
static
int
f2lopt_read_double(
  f2l_job_t		*job,
  double		*dvar,
  dkChar const		*src,
  double		 min,
  double		 max,
  int			 tp,
  size_t		 optnr
)
{
  dkChar	buf[128];	/* Conversion buffer. */
  double	dval	= 0.0;	/* Conversion result. */
  int		back	= 0;
  if(src) {
#if VERSION_BEFORE_20140716
    if(dk3sf_sscanf3(src, dkT("%lg"), &dval) == 1)
#else
    if (0 != dk3ma_d_from_string(&dval, src, NULL))
#endif
    {
      switch(tp) {
        case 1: {
	  if(dval >= min) {
	    *dvar = dval;
	    back = 1;
	  } else {
	    /* ERROR: Minimum for option ... is ...! */
#if VERSION_BEFORE_20140716
	    dk3sf_sprintf3(buf, dkT("%lg"), min);
	    dk3app_log_5(
	      job->app, DK3_LL_ERROR, job->msg, 15, 16, 17, src, buf
	    );
#else
	    if (0 != dk3ma_d_to_string(buf, DK3_SIZEOF(buf,dkChar), min)) {
	      dk3app_log_5(
	        job->app, DK3_LL_ERROR, job->msg, 15, 16, 17, src, buf
	      );
	    }
#endif
	  }
	} break;
	case 2: {
	  if(dval > 0) {
	    if(dval < max) {
	      *dvar = dval;
	      back = 1;
	    } else {
	      /* ERROR: Maximum for option ... is ...! */
#if VERSION_BEFORE_20140716
	      dk3sf_sprintf3(buf, dkT("%lg"), max);
	      dk3app_log_5(job->app,DK3_LL_ERROR,job->msg,15,18,17,src,buf);
#else
	      if (0 != dk3ma_d_to_string(buf, DK3_SIZEOF(buf,dkChar), max)) {
	        dk3app_log_5(job->app,DK3_LL_ERROR,job->msg,15,18,17,src,buf);
	      }
#endif
	    }
	  } else {
	    /* ERROR: Option ... requires positive value! */
	    dk3app_log_3(
	      job->app, DK3_LL_ERROR, job->msg, 19, 20,
	      f2lopt_key_names[optnr]
	    );
	  }
	} break;
      }
    } else {
      /* ERROR: Option argument is not numeric! */
      dk3app_log_i3(job->app, DK3_LL_ERROR, 141, 142, src);
    }
  } else {
    /* ERROR: Option requires an argument. */
    dk3app_log_3(
      job->app, DK3_LL_ERROR, job->msg, 21, 22,
      f2lopt_key_names[optnr]
    );
  }
  return back;
}


/**	Process one option.
	@param	job	Job structure to configure.
	@param	str	Key=value text.
	@return	1 on success, 0 on error.
*/
static
int
f2lopt_apply_option(f2l_job_t *job, dkChar const *str)
{
  dkChar		 bu[1024];	/* Private copy of str. */
  dkChar		*kptr;		/* Key pointer. */
  dkChar		*vptr;		/* Value pointer. */
  int			 back = 0;
  

#line 566 "f2lopt.ctr"
  if(dk3str_len(str) < DK3_SIZEOF(bu,dkChar)) {
    dk3str_cpy_not_overlapped(bu, str);
    kptr = dk3str_start(bu, NULL);
    if(kptr) {
      vptr = dk3str_chr(kptr, dkT('='));
      if(vptr) {
        *(vptr++) = dkT('\0');
	vptr = dk3str_start(vptr, NULL);
      }
      switch(dk3str_array_index(f2lopt_key_names, kptr, 0)) {
        case 0: {	

#line 577 "f2lopt.ctr"
	  if(vptr) {
	    back = f2lopt_set_text_font(job, vptr);
	  } else {
	    /* ERRROR: Key needs an argument! */
	    dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 21, 22, kptr);
	  }
	} break;
	case 1: {	

#line 585 "f2lopt.ctr"
	  if(vptr) {
	    back = f2lopt_set_text_size(job, vptr);
	  } else {
	    job->nts = -1.0;
	    back = 1;
	  }
	} break;
	case 2: {	

#line 593 "f2lopt.ctr"
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->cosp = (dk3str_is_on(vptr) ? 1 : 0);
	      back = 1;
	    } else {
	      /* ERROR: Not a boolean */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->cosp = 1; back = 1;
	  }
	} break;
	case 3: {	

#line 606 "f2lopt.ctr"
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->coah = (dk3str_is_on(vptr) ? 1 : 0);
	      back = 1;
	    } else {
	      /* ERROR: Not a boolean */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->coah = 1; back = 1;
	  }
	} break;
	case 4: {	

#line 619 "f2lopt.ctr"
	  if(vptr) {
	    back = f2lopt_read_size_t(&(job->xssbs), vptr, job);
	  } else {
	    /* ERROR: Argument required! */
            dk3app_log_i3(job->app, DK3_LL_ERROR, 133, 134, kptr);
	  }
	} break;
	case 5: {	

#line 627 "f2lopt.ctr"
	  if(vptr) {
	    back = f2lopt_read_size_t(&(job->qbs), vptr, job);
	  } else {
	    /* ERROR: Argument required! */
	    dk3app_log_i3(job->app, DK3_LL_ERROR, 133, 134, kptr);
	  }
	} break;
	case 6: {
#if VERSION_BEFORE_20140330
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->lighten = ((dk3str_is_on(vptr)) ? 1 : 0);
	      back = 1;
	    } else {
	      /* ERROR: Not a boolean value! */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    back = 1;
	    job->lighten = 1;
	  }
#else
	  job->lwbp = 0.9;
	  job->lwauto = 0;
	  if (vptr) {
	    double	x;
	    size_t	vplen;
	    vplen = dk3str_len(vptr);
	    if (0 == dk3str_cmp(f2lopt_kw[1], vptr)) {
	      job->lwbp = 0.45;
	      job->lwauto = 0;
	      back = 1;
	    } else {
	      if (dk3str_is_abbr(vptr,f2lopt_kw[2],dkT('$'), 0)) {
	        job->lwauto = 1;
		back = 1;
	      } else {
	        if (2 < vplen) {
		  switch (dk3str_array_index(f2lopt_units, &(vptr[vplen-2]), 0))
		  {
		    case 0: {	/* bp */
		      vptr[vplen - 2] = dkT('\0');
#if VERSION_BEFORE_20140716
		      if (dk3sf_sscanf3(vptr, dkT("%lg"), &x) == 1)
#else
		      if (0 != dk3ma_d_from_string(&x, vptr, NULL))
#endif
		      {
		        job->lwbp = x;
			back = 1;
		      } else {
		        /* ERROR: Failed to process */
			dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,45,46,vptr);
		      }
		    } break;
		    case 1: {	/* pt */
		      vptr[vplen - 2] = dkT('\0');
#if VERSION_BEFORE_20140716
		      if (dk3sf_sscanf3(vptr, dkT("%lg"), &x) == 1)
#else
		      if (0 != dk3ma_d_from_string(&x, vptr, NULL))
#endif
		      {
		        job->lwbp = x * 72.0 / 72.27;
			back = 1;
		      } else {
		        /* ERROR: Failed to process */
			dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,45,46,vptr);
		      }
		    } break;
		    case 2: {	/* in */
		      vptr[vplen - 2] = dkT('\0');
#if VERSION_BEFORE_20140716
		      if (dk3sf_sscanf3(vptr, dkT("%lg"), &x) == 1)
#else
		      if (0 != dk3ma_d_from_string(&x, vptr, NULL))
#endif
		      {
		        job->lwbp = x * 72.0;
			back = 1;
		      } else {
		        /* ERROR: Failed to process */
			dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,45,46,vptr);
		      }
		    } break;
		    case 3: {	/* mm */
		      vptr[vplen - 2] = dkT('\0');
#if VERSION_BEFORE_20140716
		      if (dk3sf_sscanf3(vptr, dkT("%lg"), &x) == 1)
#else
		      if (0 != dk3ma_d_from_string(&x, vptr, NULL))
#endif
		      {
		        job->lwbp = x * 72.0 / 25.4;
			back = 1;
		      } else {
		        /* ERROR: Failed to process */
			dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,45,46,vptr);
		      }
		    } break;
		    case 4: {	/* cm */
		      vptr[vplen - 2] = dkT('\0');
#if VERSION_BEFORE_20140716
		      if (dk3sf_sscanf3(vptr, dkT("%lg"), &x) == 1)
#else
		      if (0 != dk3ma_d_from_string(&x, vptr, NULL))
#endif
		      {
		        job->lwbp = x * 72.0 / 2.54;
			back = 1;
		      } else {
		        /* ERROR: Failed to process */
			dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,45,46,vptr);
		      }
		    } break;
		    default: {
#if VERSION_BEFORE_20140716
		      if (dk3sf_sscanf3(vptr, dkT("%lg"), &x) == 1)
#else
		      if (0 != dk3ma_d_from_string(&x, vptr, NULL))
#endif
		      {
		        job->lwbp = x;
			back = 1;
		      } else {
		        /* ERROR: Failed to process */
			dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,45,46,vptr);
		      }
		    } break;
		  }
		} else {
#if VERSION_BEFORE_20140716
		  if (dk3sf_sscanf3(vptr, dkT("%lg"), &x) == 1)
#else
		  if (0 != dk3ma_d_from_string(&x, vptr, NULL))
#endif
		  {
		    job->lwbp = x;
		    back = 1;
		  } else {
		    /* ERROR: Failed to process */
		    dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,45,46,vptr);
		  }
		}
	      }
	    }
	  } else {
	    job->lwbp = 0.9;
	    job->lwauto = 1;
	    back = 1;
	    if (job->lwbp < 0.001) {
	      job->lwbp = 0.001;
	    }
	  } 

#line 781 "f2lopt.ctr"
#endif
	} break;
	case 7: {
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      back = 1;
	      job->debug = ((dk3str_is_on(vptr)) ? 1 : 0);
	    } else {
	      /* ERROR: Not a boolean value! */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    back = 1;
	    job->debug = 1;
	  }
	} break;
	case 8: {
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->showpage = ((dk3str_is_on(vptr)) ? 1 : 0);
	      back = 1;
	    } else {
	      /* ERROR: Not a boolean value! */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->showpage = 1;
	    back = 1;
	  }
	} break;
	case 9: {
	  if(vptr) {
	    int i;
#if VERSION_BEFORE_20140716
	    if(dk3sf_sscanf3(vptr, dkT("%d"), &i) == 1)
#else
	    if (0 != dk3ma_i_from_string(&i, vptr, NULL))
#endif
	    {
	      if((i >= 2) && (i <= 3)) {
	        job->pslevel = i;
	      } else {
	        /* ERROR: Must be 2 or 3! */
		dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 33);
	      }
	    } else {
	      /* ERROR: Argument not a number! */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 141, 142, vptr);
	    }
	  } else {
	    /* ERROR: Argument required! */
	    dk3app_log_i3(job->app, DK3_LL_ERROR, 133, 134, kptr);
	  }
	} break;
	case 10: {
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->dsc = ((dk3str_is_on(vptr)) ? 1 : 0);
	      back = 1;
	    } else {
	      /* ERROR: Not a boolean argument. */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->dsc = 1;
	    back = 1;
	  }
	} break;
	case 11: {
	  if(DK3_FIG_SRCTYPE_UNKNOWN == job->srctype) {
	    job->srctype = DK3_FIG_SRCTYPE_XFIG;
	    back = 1;
	  } else {
	    /* ERROR: Source type already set! */
	    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 23);
	  }
	} break;
	case 12: {
	  if(DK3_FIG_SRCTYPE_UNKNOWN == job->srctype) {
	    job->srctype = DK3_FIG_SRCTYPE_JFIG;
	    back = 1;
	  } else {
	    /* ERROR: Source type already set! */
	    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 23);
	  }
	} break;
	case 13: {
	  if(DK3_FIG_SRCTYPE_UNKNOWN == job->srctype) {
	    job->srctype = DK3_FIG_SRCTYPE_WINFIG;
	    back = 1;
	  } else {
	    /* ERROR: Source type already set! */
	    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 23);
	  }
	} break;
	case 14: {	/* Arrowhead arc segments */
	  back = f2lopt_read_double(job,&(job->arcspp),vptr,2.0,-1.0,1,14);
	} break;
	case 15: {	/* Arrowhead spline segments */
	  back = f2lopt_read_double(job,&(job->splspp),vptr,2.0,-1.0,1,15);
	} break;
	case 16: {	/* Arrowhead min segments. */
	  unsigned u = 2;
	  if(vptr) {
#if VERSION_BEFORE_20140716
	    if(dk3sf_sscanf3(vptr, dkT("%u"), &u) == 1)
#else
	    if (0 != dk3ma_ui_from_string(&u, vptr, NULL))
#endif
	    {
	      if(2 <= u) {
	        job->minspp = (size_t)u;
		back = 1;
	      } else {
	        /* Warning: Must be at least 2! */
		job->minspp = 2;
		dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 34);
		back = 1;
	      }
	    } else {
	      /* ERROR: Argument is not numeric */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 141, 142, vptr);
	    }
	  } else {
	    /* ERROR: Option requires an argument! */
	    dk3app_log_i3(job->app, DK3_LL_ERROR, 133, 134, kptr);
	  }
	} break;
	case 17: {	/* Arrowhead interpolation precision. */
	  back = f2lopt_read_double(job,&(job->xsprec),vptr,0.0,0.1,2,17);
	} break;
	case 18: {	/* smash */
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->smash = ((dk3str_is_on(vptr)) ? 1 : 0);
	      back = 1;
	    } else {
	      /* ERROR: Option requires boolean argument */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->smash = 1;
	    back = 1;
	  }
	} break;
	case 19: {	/* mbox */
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->mbox = ((dk3str_is_on(vptr)) ? 1 : 0);
	      back = 1;
	    } else {
	      /* ERROR: Option requires boolean argument! */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->mbox = 1;
	    back = 1;
	  }
	} break;
	case 20: {
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->resfont = ((dk3str_is_on(vptr)) ? 1 : 0);
	      back = 1;
	    } else {
	      /* ERROR: Option requires boolean argument! */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->resfont = 1;
	    back = 1;
	  }
	} break;
	case 21: {
	  if(vptr) {
	    unsigned u;
#if VERSION_BEFORE_20140716
	    if(dk3sf_sscanf3(vptr, dkT("%u"), &u) == 1)
#else
	    if (0 != dk3ma_ui_from_string(&u, vptr, NULL))
#endif
	    {
	      job->codi = (size_t)u;
	      back = 1;
	    } else {
	      /* ERROR: Option requires an unsigned numeric argument! */
	      dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 24, 25, kptr);
	    }
	  } else {
	    job->codi = 0;
	    back = 1;
	  }
	} break;
	case 22: {
	  if(vptr) {
	    double d;
#if VERSION_BEFORE_20140716
	    if(dk3sf_sscanf3(vptr, dkT("%lg"), &d) == 1)
#else
	    if (0 != dk3ma_d_from_string(&d, vptr, NULL))
#endif
	    {
	      if(d > 0.0) {
	        job->tts = d; back = 1;
	      } else {
	        /* ERROR: Cannot handle negative font size! */
		dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 26);
	      }
	    } else {
	      /* ERROR: Option requires a floating point number arg! */
	      dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 12, 22, kptr);
	    }
	  } else {
	    job->tts = 12.0; back = 1;
	  }
	} break;
	case 23: {
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->css = ((dk3str_is_on(vptr)) ? 1 : 0); back = 1;
	    } else {
	      /* ERROR: Option requires boolean argument! */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->css = 1; back = 1;
	  }
	} break;
	case 24: {
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->fragment = ((dk3str_is_on(vptr)) ? 1 : 0); back = 1;
	    } else {
	      /* ERROR: Option requires boolean argument! */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->fragment = 1; back = 1;
	  }
	} break;
	case 25: {
	  if(vptr) {
	    job->svgfontbase = dk3str_array_index(f2lopt_svg_font_bases, vptr, 0);
	    if(0 <= job->svgfontbase) {
	      back = 1;
	    } else {
	      /* ##### ERROR: Illegal font base name! */
	    }
	  } else {
	    job->svgfontbase = 0; back = 1;
	  }
	} break;
	case 26: {
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->group = ((dk3str_is_on(vptr)) ? 1 : 0); back = 1;
	    } else {
	      /* ERROR: Option requires boolean argument! */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->group = 1; back = 1;
	  }
	} break;
	case 27: {
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->miterlim = ((dk3str_is_on(vptr)) ? 1 : 0); back = 1;
	    } else {
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->miterlim = 1; back = 1;
	  }
	} break;
	case 28: {
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->cols = ((dk3str_is_on(vptr)) ? 1 : 0); back = 1;
	    } else {
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->cols = 1; back = 1;
	  }
	} break;
	case 29: {
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->otherfonts = ((dk3str_is_on(vptr)) ? 1 : 0); back = 1;
	    } else {
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->otherfonts = 1; back = 1;
	  }
	} break;
	case 30: {
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->bbts = ((dk3str_is_on(vptr)) ? 1 : 0); back = 1;
	    } else {
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->bbts = 1; back = 1;
	  }
	} break;
	case 31: {
	  int enc;
	  if(vptr) {
	    enc = dk3enc_get_text_encoding_app(vptr, job->app);
	  } else {
	    if(DK3_ENCODING_UTF8 == dk3app_get_encoding(job->app)) {
	      enc = DK3_ENCODING_PLAIN;
	    } else {
	      enc = DK3_ENCODING_UTF8;
	    }
	  }
	  back = 1;
	  switch(enc) {
	    case DK3_ENCODING_UTF8: {
	      job->stu8 = 1;
	    } break;
	    case DK3_ENCODING_PLAIN: {
	      job->stu8 = 0;
	    } break;
	    default: {
	      job->stu8 = 0;
	      /* ##### WARNING Only ascii and utf-8 allowed. */
	    } break;
	  }
	} break;
	case 32: {
	  if(vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->cofop = ((dk3str_is_on(vptr)) ? 1 : 0);
	      back = 1;
	    } else {
	      /* ERROR: Not a boolean! */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->cofop = 1;
	    back = 1;
	  }
	} break;
	case 33: {
	  if (vptr) {
	    if(dk3str_is_bool(vptr)) {
	      job->xsah = ((dk3str_is_on(vptr)) ? 1 : 0);
	      back = 1;
	    } else {
	      /* ERROR: Not a boolean! */
	      dk3app_log_i3(job->app, DK3_LL_ERROR, 146, 147, kptr);
	    }
	  } else {
	    job->xsah = 1;
	    back = 1;
	  }
	} break;
	default: {
	  /* ERROR: Unknown key name! */
	  dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 27, 28, kptr);
	} break;
      }
    } else {					

#line 1148 "f2lopt.ctr"
      back = 1;
    }
    if(!(back)) {
      job->exval = FIG2LAT_EXIT_ERROR_SYNTAX; 

#line 1152 "f2lopt.ctr"
    }
  } else {
    /* ERROR: Option ... too long! */
    dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 29, 30, str);
    job->exval = FIG2LAT_EXIT_ERROR_SYNTAX; 

#line 1157 "f2lopt.ctr"
  } 

#line 1158 "f2lopt.ctr"
  return back;
}



/**	Set language, apply options if any.
	@param	job	Job structure to set up.
	@param	optarg	Language, optionally with further options.
	@return	1 on success, 0 on error.
*/
static
int
f2lopt_set_language(f2l_job_t *job, dkChar const *optarg)
{
  dkChar		 bu[1024];	/* Private copy of optarg. */
  dkChar		*pc;		/* Current string. */
  dkChar		*pn;		/* Next string. */
  int			 back = 0;
  

#line 1177 "f2lopt.ctr"
  if(dk3str_len(optarg) < DK3_SIZEOF(bu,dkChar)) {
    dk3str_cpy_not_overlapped(bu, optarg);
    pc = dk3str_chr(bu, dkT(','));
    if(pc) {
      *(pc++) = dkT('\0');
      pc = dk3str_start(pc, NULL);
    }
    if(f2lopt_apply_language(job, bu)) {
      back = 1;
      while(pc) {		

#line 1187 "f2lopt.ctr"
        pn = dk3str_chr(pc, dkT(','));
	if(pn) { *(pn++) = dkT('\0'); pn = dk3str_start(pn, NULL); }
	if(!f2lopt_apply_option(job, pc)) {
	  back = 0;		

#line 1191 "f2lopt.ctr"
	  pn = NULL;
	}
	pc = pn;
      }
    }
  } else {
    /* ERROR: Option argument too long! */
    dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 31, 30, optarg);
  } 

#line 1200 "f2lopt.ctr"
  return back;
}



int
f2lopt_process(f2l_job_t *job)
{
  dkChar const		*optarg;	/* Option argument. */
  int			 back = 0;
  int			 i;		/* Current file name. */
  

#line 1212 "f2lopt.ctr"
  job->opt = dk3opt_open_from_app(
    f2lopt_options, f2lopt_sz_options,
    dkT('o'), dkT("option"),
    job->app
  );
  if(job->opt) {					

#line 1218 "f2lopt.ctr"
    if(0 == dk3opt_get_error_code(job->opt)) {		

#line 1219 "f2lopt.ctr"
      back = 1;
      if(dk3opt_is_set(job->opt, dkT('h'))) {
        job->cmd |= DK3_APP_CMD_HELP;
      }
      if(dk3opt_is_set(job->opt, dkT('v'))) {
        job->cmd |= DK3_APP_CMD_VERSION;
      }
      if(dk3opt_is_set(job->opt, dkT('L'))) {
        job->cmd |= DK3_APP_CMD_LICENSE;
      }
      if(0 == job->cmd) {
        if(dk3opt_is_set(job->opt, dkT('m'))) {
	  job->mm = 1;
	}
        if(dk3opt_is_set(job->opt, dkT('l'))) {
	  optarg = dk3opt_get_short_arg(job->opt, dkT('l'));
	  if(optarg) {					

#line 1236 "f2lopt.ctr"
	    if(f2lopt_set_language(job, optarg)) {
	      for(i = 0; i < dk3opt_get_num_fo(job->opt); i++) {
	        optarg = dk3opt_get_fo(job->opt, i);
		if(optarg) {
		  if(!f2lopt_apply_option(job, optarg)) {
		    back = 0;
		  }
		}
	      }
	    } else {
	      back = 0;
	    }
	  } else {					

#line 1249 "f2lopt.ctr"
	    back = 0;
	    /* ERROR: Option requires an argument! */
	    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 32);
	  }
	} else {
	}
      }
      /*	Automatically calculate line width in points
      		from TeX text size.
      */
      if (job->lwauto) {
        job->lwbp = 0.4 * 72.0 * job->tts / (10 * 72.27);
	

#line 1262 "f2lopt.ctr"
      }
    } else {						

#line 1264 "f2lopt.ctr"
    }
  } else {						

#line 1266 "f2lopt.ctr"
    job->exval = FIG2LAT_EXIT_ERROR_SYSTEM; 

#line 1267 "f2lopt.ctr"
  } 

#line 1268 "f2lopt.ctr"
  return back;
}


