/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: f2leps.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file f2leps.c The f2leps module.
*/


#line 686 "f2leps.ctr"

#include "dk3all.h"
#include "dk3bezcu.h"
#include "fig2lat.h"
#include "f2lud.h"
#include "f2lsvg.h"
#include "f2leps.h"
#include "dk3figto.h"
#include "dkt-version.h"
#include "dk3font.h"
#include "dk3bm.h"
#include "dk3bmeps.h"




#line 701 "f2leps.ctr"



/**	Drawing-related information for EPS output.
*/
typedef struct {
  char const	*shortOutFile;	/**< Short output file name. */
  dk3_sto_t	*sFonts;	/**< Fonts and sizes (dk3_fig_font_t). */
  dk3_sto_it_t	*iFonts;	/**< Fonts storage iterator. */
  int		*fonts;		/**< 35 flags: Font used. */
  unsigned long	 nFonts;	/**< Number of fonts in sFonts. */
  int		 havetext;	/**< Flag: Text to show as PS text. */
  int		 alignedright;	/**< Flag: Right-aligned text found. */
  int		 alignedcenter;	/**< Flag: Centered text found. */
  int		 dictsize;	/**< Size of dictionary. */
} f2leps_drawing_info_t;



#if 0
/**	Font reencoding to write ISO-LATIN-1 encoded strings.
*/
static char const * const	f2leps_font_reencode_2[] = {
"/FontReEncode\t\t% originalname encodedname --",
"{",
"  5 dict begin /nn exch def /an exch def an findfont dup",
"  length dict /nf exch def",
"  {",
"    1 index /FID ne",
"    { nf 3 1 roll put }",
"    { pop pop }",
"    ifelse",
"  }",
"  forall",
"  nf /Encoding ISOLatin1Encoding put nn nf end definefont pop",
"}",
"def",
NULL


#line 740 "f2leps.ctr"
};
#else
/**	Font reencoding to write ISO-LATIN-1 encoded strings.
*/
static char const * const	f2leps_font_reencode_2[] = {
"/FontReEncode\t\t\t\t% originalname newname --",
"{\t\t\t\t\t% on nn",
"  exch\t\t\t\t\t% nn on",
"  findfont\t\t\t\t% nn of",
"  dup\t\t\t\t\t% nn of of",
"  length\t\t\t\t% nn of length",
"  1 add\t\t\t\t\t% nn of length",
"  dict\t\t\t\t\t% nn of nf",
"  exch\t\t\t\t\t% nn nf of",
"  {\t\t\t\t\t% nn nf key value",
"    1 index\t\t\t\t% nn nf key value key",
"    /FID eq\t\t\t\t% nn nf key value flag",
"    {\t\t\t\t\t% nn nf key value",
"      pop pop\t\t\t\t% nn nf",
"    }",
"    {\t\t\t\t\t% nn nf key value",
"      2 index\t\t\t\t% nn nf key value nf",
"      3 1 roll\t\t\t\t% nn nf nf key value",
"      put\t\t\t\t% nn nf",
"    }",
"    ifelse\t\t\t\t% nn nf",
"  }",
"  forall\t\t\t\t% nn nf",
"  dup\t\t\t\t\t% nn nf nf",
"  /Encoding ISOLatin1Encoding put\t% nn nf",
"  definefont\t\t\t\t% nf",
"  pop\t\t\t\t\t%",
"}",
"def",
NULL


#line 776 "f2leps.ctr"
};
#endif

#if 0

/**	Procedure for right aligned text.
*/
static char const * const	f2leps_right_aligned_text[] = {
"/TextAlignedRight \t% text --",
"{",
"  currentpoint\t\t% text x y",
"  3 -1 roll\t\t% x y text",
"  dup\t\t\t% x y text text",
"  true charpath\t\t% x y text",
"  flattenpath\t\t% x y text",
"  pathbbox\t\t% x y text x1 y1 x2 y2",
"  pop exch pop\t\t% x y text x1 x2",
"  exch sub abs\t\t% x y text length",
"  newpath 4 -2 roll\t% text length x y",
"  moveto\t\t% text length",
"  0 exch sub\t\t% text distance",
"  0 rmoveto\t\t% text",
"  show\t\t\t%",
"} def",
NULL


#line 802 "f2leps.ctr"
};



/**	Procedure for centered text.
*/
static char const * const	f2leps_centered_aligned_text[] = {
"/TextAlignedCentered \t% text --",
"{",
"  currentpoint\t\t% text x y",
"  3 -1 roll\t\t% x y text",
"  dup\t\t\t% x y text text",
"  true charpath\t\t% x y text",
"  flattenpath\t\t% x y text",
"  pathbbox\t\t% x y text x1 y1 x2 y2",
"  pop exch pop\t\t% x y text x1 x2",
"  exch sub abs\t\t% x y text length",
"  newpath 4 -2 roll\t% text length x y",
"  moveto\t\t% text length",
"  0.5 mul\t\t% text distance",
"  0 exch sub\t\t% text xshift",
"  0 rmoveto\t\t% text",
"  show\t\t\t%",
"} def",
NULL


#line 828 "f2leps.ctr"
};

#else

/**	Procedure for right aligned text.
*/
static char const * const	f2leps_right_aligned_text[] = {
"/TextAlignedRight \t% x y text --",
"{",
"  dup\t\t\t% x y text text",
"  newpath\t\t% x y text text",
"  0 0 moveto\t\t% x y text text",
"  true charpath\t\t% x y text",
"  pathbbox\t\t% x y text x1 y1 x2 y2",
"  pop\t\t\t% x y text x1 y1 x2",
"  exch\t\t\t% x y text x1 x2 y1",
"  pop\t\t\t% x y text x1 x2",
"  exch\t\t\t% x y text x2 x1",
"  pop\t\t\t% x y text width",
"  newpath\t\t% x y text width",
"  4 3 roll\t\t% y text width x",
"  exch\t\t\t% y text x width",
"  sub\t\t\t% y text x",
"  3 2 roll\t\t% text x y",
"  moveto\t\t% text",
"  show\t\t\t% -",
"} def",
NULL


#line 857 "f2leps.ctr"
};



/**	Procedure for centered text.
*/
static char const * const	f2leps_centered_aligned_text[] = {
"/TextAlignedCentered \t% x y text --",
"{",
"  dup\t\t\t% x y text text",
"  newpath\t\t% x y text text",
"  0 0 moveto\t\t% x y text text",
"  true charpath\t\t% x y text",
"  pathbbox\t\t% x y text x1 y1 x2 y2",
"  pop\t\t\t% x y text x1 y1 x2",
"  exch\t\t\t% x y text x1 x2 y1",
"  pop\t\t\t% x y text x1 x2",
"  exch\t\t\t% x y text x2 x1",
"  pop\t\t\t% x y text width",
"  0.5 mul\t\t% x y text width/2",
"  newpath\t\t% x y text width/2",
"  4 3 roll\t\t% y text width/2 x",
"  exch\t\t\t% y text x width/2",
"  sub\t\t\t% y text x",
"  3 2 roll\t\t% text x y",
"  moveto\t\t% text",
"  show\t\t\t% -",
"} def",
NULL


#line 887 "f2leps.ctr"
};

#endif



/**	Keywords used by the module.
*/
static
char const * const	f2leps_c8_kw[] = {
/* 0 */
"\n",

/* 1 */
" ",

/* 2 */
"%!PS-Adobe-3.0 EPSF-3.0\n",

/* 3 */
"%!PS-Adobe-2.0 EPSF-2.0\n",

/* 4 */
"%%LanguageLevel: 3\n",

/* 5 */
"%%LanguageLevel: 2\n",

/* 6 */
"%%BoundingBox: ",

/* 7 */
"0 0 %ld %ld\n",

/* 8 */
"%%Creator: http://dktools.sourceforge.net\n",

/* 9 */
"%%Title: Converted Fig image\n",

/* 10 */
"%%Pages: 1\n",

/* 11 */
"%%PageOrder: Ascend\n",

/* 12 */
"%%DocumentData: Clean7Bit\n",

/* 13 */
"%%EndComments\n",

/* 14 */
"%%Page: 1 1\n",

/* 15 */
"gsave\n",

/* 16 */
"grestore\n",

/* 17 */
"%d dict begin\n",

/* 18 */
"end\n",

/* 19 */
"showpage\n",

/* 20 */
"%%Trailer\n%%EOF\n",

/* 21 */
"newpath\n",

/* 22 */
"0 0 moveto %ld 0 lineto %ld %ld lineto 0 %ld lineto 0 0 lineto\n",

/* 23 */
"closepath clip\n",

/* 24 */
"/%s /fnt%02d FontReEncode\n",

/* 25 */
"%lg %lg moveto\n",

/* 26 */
"%lg %lg lineto\n",

/* 27 */
"%lg %lg %lg %lg %lg %lg curveto\n",

/* 28 */
"closepath\n",

/* 29 */
"eofill\n",

/* 30 */
"eoclip\n",

/* 31 */
"stroke\n",

/* 32 */
"%lg %lg %lg setrgbcolor\n",

/* 33 */
"%lg setlinewidth\n",

/* 34 */
"%d setlinecap\n",

/* 35 */
"%d setlinejoin\n",

/* 36 */
"[] 0 setdash\n",

/* 37 */
"[%lg %lg] 0 setdash\n",

/* 38 */
"[%lg %lg %lg %lg] 0 setdash\n",

/* 39 */
"[%lg %lg %lg %lg %lg %lg] 0 setdash\n",

/* 40 */
"[%lg %lg %lg %lg %lg %lg %lg %lg] 0 setdash\n",

/* 41 */
"(",

/* 42 */
")",

/* 43 */
"/fnt%02d findfont %lg scalefont setfont\n",

/* 44 */
" show\n",

/* 45 */
" TextAlignedCentered\n",

/* 46 */
" TextAlignedRight\n",

/* 47 */
"%lg %lg translate\n",

/* 48 */
"%lg rotate\n",

/* 49 */
"0 0 moveto\n",

/* 50 */
" 3 -2 roll newpath moveto show\n",

/* 51 */
"0 0 ",

/* 52 */
"% ",

NULL


#line 1111 "f2leps.ctr"
};


/* ************************************************************************ */
/* *                                                                      * */
/* * Tool functions                                                       * */
/* *                                                                      * */
/* ************************************************************************ */


#line 1117 "f2leps.ctr"



/**	Destroy drawing info structure.
	@param 	pdi	Structure to destroy.
*/
static
void
f2leps_drawing_info_delete(
  f2leps_drawing_info_t	*pdi
)
{
  void		*ptr;	/* Current text handling information to delete. */

  if(pdi) {
    dk3_release(pdi->shortOutFile);
    if(pdi->sFonts) {
      if(pdi->iFonts) {
        dk3sto_it_reset(pdi->iFonts);
	while(NULL != (ptr = dk3sto_it_next(pdi->iFonts))) {
	  dk3_delete(ptr);
	}
        dk3sto_it_close(pdi->iFonts);
      }
      dk3sto_close(pdi->sFonts);
    } pdi->sFonts = NULL; pdi->iFonts = NULL;
    dk3_release(pdi->fonts);
    dk3_delete(pdi);
  }
}



/**	Create drawing information structure.
	@param	job		Job structure.
	@param	withFonts	Flag: Gather LaTeX font information.
	This flag is set to 1 for EPS/LaTeX and set to 0 for
	pure EPS.
	@return	Pointer to new structure on success, NULL on error.
*/
static
f2leps_drawing_info_t *
f2leps_drawing_info_new(
  f2l_job_t		*job,
  int			 withFonts
)
{
  f2leps_drawing_info_t	*back;
  int			 ok	= 0;
  back = dk3_new_app(f2leps_drawing_info_t,1,job->app);
  if(back) {
    back->nFonts = 0UL;
    back->sFonts = NULL;
    back->iFonts = NULL;
    back->fonts = NULL;
    back->havetext = 0;
    back->alignedright = 0;
    back->alignedcenter = 0;
    back->dictsize = 0;
    back->shortOutFile = NULL;
    if(withFonts) {
        back->sFonts = dk3sto_open_app(job->app);
	if(back->sFonts) {
	  dk3sto_set_comp(back->sFonts, dk3fig_tool_font_compare, 0);
	  back->iFonts = dk3sto_it_open(back->sFonts);
	  if(back->iFonts) {
	    ok = 1;
	  }
	}
    } else {
        back->fonts = dk3_new_app(int,35,job->app);
	if(back->fonts) {
	  ok = 1;
	}
    }
    if(!(ok)) {
      f2leps_drawing_info_delete(back);
      back = NULL;
    }
  }
  return back;
}



/**	Write a text section to the output file.
	@param	of	Output file.
	@param	ta	String array to write.
*/
static
void
f2leps_write_text_section(
  FILE			*of,
  char const * const	*ta
)
{
  char const * const	*ptr;
  ptr = ta;
  while(*ptr) {
    fputs(*(ptr++), of);
    fputc('\n', of);
  }
}



/**	Write EPS file header.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	of	Output file.
	@param	pure	Flag: Pure EPS (1) or EPS/LaTeX (0).
*/
static
void
f2leps_file_header(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  FILE			*of,
  int			 pure
)
{
  f2leps_drawing_info_t	*pdi;
  int			 i;
  pdi = (f2leps_drawing_info_t *)(drw->dsd);
  /* %!PS-Adobe-3.0 EPSF-3.0 */
  if(2 < job->pslevel) {
    fputs(f2leps_c8_kw[2], of);
    fputs(f2leps_c8_kw[4], of);
  } else {
    fputs(f2leps_c8_kw[3], of);
    fputs(f2leps_c8_kw[5], of);
  }
  /* bounding box */
  fputs(f2leps_c8_kw[6], of);
  fprintf(of, f2leps_c8_kw[7], job->lwidth, job->lheight);
  if(job->dsc) {
    /* Creator */
    fputs(f2leps_c8_kw[8], of);
    /* Title */
    fputs(f2leps_c8_kw[9], of);
    /* Pages */
    fputs(f2leps_c8_kw[10], of);
    /* PageOrder */
    fputs(f2leps_c8_kw[11], of);
    /* DocumentData */
    fputs(f2leps_c8_kw[12], of);
    if(pure) {
      /* ##### HIER WEITER: DocumentNeededFonts */
    }
    /* EndComments */
    fputs(f2leps_c8_kw[13], of);
    /* Page */
    fputs(f2leps_c8_kw[14], of);
  }
  fputs(f2leps_c8_kw[15], of);
  fputs(f2leps_c8_kw[21], of);
  fprintf(
    of, f2leps_c8_kw[22],
    job->lwidth, job->lwidth, job->lheight, job->lheight
  );
  fputs(f2leps_c8_kw[23], of);
  if(pure) {
    /* xxx dict begin */
    fprintf(of, f2leps_c8_kw[17], pdi->dictsize);
  }
  /* Text procedures */
  if(pdi->havetext) {
    f2leps_write_text_section(of, f2leps_font_reencode_2);
    if(pdi->alignedcenter) {
      f2leps_write_text_section(of, f2leps_centered_aligned_text);
    }
    if(pdi->alignedright) {
      f2leps_write_text_section(of, f2leps_right_aligned_text);
    }
    /* Font reencodings */
    for(i = 0; i < 35; i++) {
      if((pdi->fonts)[i]) {
        fprintf(of, f2leps_c8_kw[24], dk3font_get_ps_font_name(i), i);
      }
    }
  }
}



/**	Write EPS file header.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	of	Output file.
	@param	pure	Flag: Pure EPS (1) or EPS/LaTeX (0).
*/
static
void
f2leps_file_footer(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  FILE			*of,
  int			 pure
)
{
  if(pure) {
    /* end */
    fputs(f2leps_c8_kw[18], of);
  }
  /* grestore */
  fputs(f2leps_c8_kw[16], of);
  if(job->showpage) {
    /* showpage */
    fputs(f2leps_c8_kw[19], of);
  }
  if(job->dsc) {
    /* Trailer, EOF */
    fputs(f2leps_c8_kw[20], of);
  }
}



/**	Check whether a text character is literal.
	@param	c	Character to check.
	@return	1 to issue character as is, 0 for octal encoding.
*/
static
int
f2leps_is_literal(char c)
{
  int		 back = 0;
  if(('A' <= c) && ('Z' >= c)) {
    back = 1;
  } else {
    if(('a' <= c) && ('z' >= c)) {
      back = 1;
    } else {
      if(('0' <= c) && ('9' >= c)) {
        back = 1;
      } else {
        switch(c) {
	  case ' ':
	  {
	    back = 1;
	  } break;
	}
      }
    }
  }
  return back;
}



/**	Write string PS-encoded to output.
	@param	of	Output file.
	@param	str	String to write.
*/
static
void
f2leps_encode_string(
  FILE		*of,
  char const	*str
)
{
  char			 buf[32];
  char const		*ptr;
  char			 c;
  unsigned char		 uc;
  unsigned		 u;
  ptr = str;
  fputs(f2leps_c8_kw[41], of);
  while(*ptr) {
    c = *(ptr++);
    if(f2leps_is_literal(c)) {
      fputc(c, of);
    } else {
      uc = (unsigned char)c;
      u  = (unsigned)uc;
      while(255 < u) { u = u - 256; }
      sprintf(buf, "\\%03o", u);
      fputs(buf, of);
    }
  }
  fputs(f2leps_c8_kw[42], of);
}



/**	Process an embedded bitmap image.
	@param	of	Output file.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Image object.
	@param	outbb	Destination image area.
	@param	drawdir	Drawing direction / coordinates origin.
	@param	ec	Pointer to error code variable.
*/
static
void
f2leps_image_object(
  FILE			*of,
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_bb_t		*outbb,
  int			 drawdir,
  int			*ec
)
{
  int		res = 0;
  res = dk3bm_ps_place_object(
    of,outbb,drawdir,(obj->dt).pol.fn,job->app,job->pslevel,ec
  );
  if(!(res)) {
    job->exval = FIG2LAT_EXIT_ERROR_UNKNOWN; 

#line 1429 "f2leps.ctr"
  }
}



/**	Set line style.
	@param	of	Output file.
	@param	job	Job structure.
	@param	drw	Drawing structure.
	@param	obj	Object using the line style.
	@param	ls	Line style.
	@param	sv	Style value (gap length).
	@param	lw	Line width.
*/
static
void
f2leps_set_line_style(
  FILE			*of,
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 ls,
  double		 sv,
  double		 lw
)
{
  double		gw;	/* Gap width. */
  gw = f2lto_find_gap_length(job, lw, sv);
  switch(ls) {
    case DK3_FIG_LS_DASHED: {
      fprintf(of, f2leps_c8_kw[37], sv, gw);
    } break;
    case DK3_FIG_LS_DOTTED: {
      fprintf(of, f2leps_c8_kw[37], lw, gw);
    } break;
    case DK3_FIG_LS_DASH_DOTTED: {
      fprintf(of, f2leps_c8_kw[38], sv, gw, lw, gw);
    } break;
    case DK3_FIG_LS_DASH_DOUBLE_DOTTED: {
      fprintf(of, f2leps_c8_kw[39], sv, gw, lw, gw, lw, gw);
    } break;
    case DK3_FIG_LS_DASH_TRIPLE_DOTTED: {
      fprintf(of, f2leps_c8_kw[40], sv, gw, lw, gw, lw, gw, lw, gw);
    } break;
    default: {
      fputs(f2leps_c8_kw[36], of);
    } break;
  }
}



/**	Write debug line to output.
	@param	of	Output file.
	@param	job	Job structure.
	@param	msg	Message text to write.
*/
static
void
f2leps_debug(
  FILE			*of,
  f2l_job_t		*job,
  char const		*msg
)
{
  if((job) && (msg)) {
    fputs(f2leps_c8_kw[52], of);
    fputs(msg, of);
    fputs(f2leps_c8_kw[0], of);
  }
}



/* ************************************************************************ */
/* *                                                                      * */
/* * Driver: EPS with LaTeX                                               * */
/* *                                                                      * */
/* ************************************************************************ */


#line 1506 "f2leps.ctr"


int
f2leps_eps_with_tex_initialize(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  f2leps_drawing_info_t	*pdi;
  dk3_fig_obj_t		*pobj;
  dkChar const		*oldsourcename = NULL;
  unsigned long		 oldsourceline = 0UL;
  int			 back = 0;
  int			 ff;
  

#line 1518 "f2leps.ctr"
  drw->dsd = (void *)(pdi = f2leps_drawing_info_new(job, 1));
  if(drw->dsd) {			

#line 1520 "f2leps.ctr"
    oldsourcename = dk3app_get_source_file(job->app);
    oldsourceline = dk3app_get_source_line(job->app);
    pdi->shortOutFile = dk3fig_tool_short_output_file_name(job->on2, job->app);
    if(pdi->shortOutFile) {		

#line 1524 "f2leps.ctr"
      back = 1;				

#line 1525 "f2leps.ctr"
      dk3sto_it_reset(drw->iobj);
      while(NULL != (pobj = (dk3_fig_obj_t *)dk3sto_it_next(drw->iobj))) {
        

#line 1528 "f2leps.ctr"
	dk3app_set_source_line(job->app, pobj->li);
        switch(pobj->ot) {
          case DK3_FIG_OBJ_TEXT: {	

#line 1531 "f2leps.ctr"
	    ff = (pobj->dt).txt.ff;
	    if(!(ff & DK3_FIG_FONT_FLAG_HIDDEN)) {	

#line 1533 "f2leps.ctr"
	      if(!(ff & DK3_FIG_FONT_FLAG_SPECIAL)) {	

#line 1534 "f2leps.ctr"
	        if(ff & DK3_FIG_FONT_FLAG_PS) {		

#line 1535 "f2leps.ctr"
	          if(job->ntf) {			

#line 1536 "f2leps.ctr"
		    pobj->dsd = (void *)f2l_tool_register_font(
		      pdi->sFonts, pdi->iFonts, &(pdi->nFonts),
		      (pobj->dt).txt.fo, (pobj->dt).txt.fs, job->app
		    );
		    if(!(pobj->dsd)) {
		      back = 0;
		      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1543 "f2leps.ctr"
		    }
		  } else {				

#line 1545 "f2leps.ctr"
		  }
	        }
	      }
	    }
	  } break;
        }
      }
    } else {				

#line 1553 "f2leps.ctr"
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1554 "f2leps.ctr"
    }
    dk3app_set_source_file(job->app, oldsourcename);
    dk3app_set_source_line(job->app, oldsourceline);
  } else {				

#line 1558 "f2leps.ctr"
    f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1559 "f2leps.ctr"
  } 

#line 1560 "f2leps.ctr"
  return back;
}



void
f2leps_eps_with_tex_end(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  

#line 1569 "f2leps.ctr"
  if(drw->dsd) {
    f2leps_drawing_info_delete((f2leps_drawing_info_t *)(drw->dsd));
  }
  

#line 1573 "f2leps.ctr"
}



int
f2leps_eps_with_tex_open_output_files(f2l_job_t *job)
{
  int		 back = 0;
  

#line 1582 "f2leps.ctr"
  job->of1 = dk3sf_fopen_app(job->on1, dkT("w"), job->app);
  if(job->of1) {
    job->of2 = dk3sf_fopen_app(job->on2, dkT("wb"), job->app);
    if(job->of2) {
      back = 1;
    } else {
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1589 "f2leps.ctr"
    }
  } else {
    f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1592 "f2leps.ctr"
  }
  

#line 1594 "f2leps.ctr"
  return back;
}



void
f2leps_eps_with_tex_close_output_files(f2l_job_t *job)
{
  

#line 1603 "f2leps.ctr"
  if(job->of2) {
    dk3sf_fclose_app(job->of2, job->app);
  } job->of2 = NULL;
  if(job->of1) {
    dk3sf_fclose_app(job->of1, job->app);
  } job->of1 = NULL;
  

#line 1610 "f2leps.ctr"
}



int
f2leps_eps_with_tex_start_processing(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  f2leps_drawing_info_t	*pdi;
  int			 back = 1;
  

#line 1620 "f2leps.ctr"
  pdi = (f2leps_drawing_info_t *)(drw->dsd);
  f2leps_file_header(job, drw, job->of2, 0);
  f2l_tool_start_tex_part(
    job->of1, job, drw, pdi->shortOutFile, pdi->iFonts, pdi->nFonts
  );
  

#line 1626 "f2leps.ctr"
  return back;
}



void
f2leps_eps_with_tex_end_processing(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  

#line 1635 "f2leps.ctr"
  f2leps_file_footer(job, drw, job->of2, 0);
  f2l_tool_end_tex_part(job->of1);
  

#line 1638 "f2leps.ctr"
}



void
f2leps_eps_with_tex_text_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  f2leps_drawing_info_t	*pdi;
  pdi = (f2leps_drawing_info_t *)(drw->dsd);
  f2l_tool_text_object(job->of1, job, drw, obj, x, y, pdi->nFonts);
}



void
f2leps_eps_with_tex_image_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_bb_t		*outbb,
  int			 drawdir,
  int			*ec
)
{
  f2leps_image_object(job->of2, job, drw, obj, outbb, drawdir, ec);
}


void
f2leps_eps_with_tex_newpath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[21], job->of2);
}



void
f2leps_eps_with_tex_moveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  fprintf(job->of2, f2leps_c8_kw[25], x, y);
}



void
f2leps_eps_with_tex_lineto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  fprintf(job->of2, f2leps_c8_kw[26], x, y);
}



void
f2leps_eps_with_tex_curveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 xcs,
  double		 ycs,
  double		 xce,
  double		 yce,
  double		 xe,
  double		 ye
)
{
  fprintf(job->of2, f2leps_c8_kw[27], xcs, ycs, xce, yce, xe, ye);
}



void
f2leps_eps_with_tex_closepath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[28], job->of2);
}



void
f2leps_eps_with_tex_fill(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[29], job->of2);
}



void
f2leps_eps_with_tex_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[30], job->of2);
}



void
f2leps_eps_with_tex_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[31], job->of2);
}



void
f2leps_eps_with_tex_gsave(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[15], job->of2);
}



void
f2leps_eps_with_tex_grestore(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[16], job->of2);
}



void
f2leps_eps_with_tex_setcolor(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 r,
  double		 g,
  double		 b
)
{
  fprintf(job->of2, f2leps_c8_kw[32], r, g, b);
}



void
f2leps_eps_with_tex_set_line_width(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 lw
)
{
  fprintf(job->of2, f2leps_c8_kw[33], lw);
}


void
f2leps_eps_with_tex_set_line_style(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 ls,
  double		 sv,
  double		 lw
)
{
  f2leps_set_line_style(job->of2, job, drw, obj, ls, sv, lw);
}



void
f2leps_eps_with_tex_set_line_end(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 le
)
{
  fprintf(job->of2, f2leps_c8_kw[34], le);
}



void
f2leps_eps_with_tex_set_line_join(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 lj
)
{
  fprintf(job->of2, f2leps_c8_kw[35], lj);
}



void
f2leps_eps_with_tex_set_color_1(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
)
{
  fprintf(job->of2, f2leps_c8_kw[32], rgb->r, rgb->g, rgb->b);
}



void
f2leps_eps_with_tex_set_color_2(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
)
{
  fprintf(job->of2, f2leps_c8_kw[32], rgb->r, rgb->g, rgb->b);
}



void
f2leps_eps_with_tex_debug(
  f2l_job_t		*job,
  char const		*msg
)
{
  f2leps_debug(job->of2, job, msg);
}


/* ************************************************************************ */
/* *                                                                      * */
/* * Driver: EPS standalone file                                          * */
/* *                                                                      * */
/* ************************************************************************ */


#line 1907 "f2leps.ctr"


int
f2leps_eps_pure_initialize(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  f2leps_drawing_info_t	*pdi;
  dk3_fig_obj_t		*pobj;
  int			 back = 0;
  int			 fn;
  int			 i;
  int			 ff;
  drw->dsd = (void *)(pdi = f2leps_drawing_info_new(job, 0));
  if(drw->dsd) {
    back = 1;
    /*	Inspect all elements.
    */
    dk3sto_it_reset(drw->iobj);
    while(NULL != (pobj = (dk3_fig_obj_t *)dk3sto_it_next(drw->iobj))) {
      switch(pobj->ot) {
        case DK3_FIG_OBJ_TEXT: {
	  ff = (pobj->dt).txt.ff;
	  if(!(ff & DK3_FIG_FONT_FLAG_HIDDEN)) {
	    if(!(ff & DK3_FIG_FONT_FLAG_SPECIAL)) {
	      pdi->havetext = 1;
	      switch(pobj->st) {
	        case 1: {
	          pdi->alignedcenter = 1;
	        } break;
	        case 2: {
	          pdi->alignedright = 1;
	        } break;
	      }
	      fn = dk3fig_tool_ps_font_number(pobj);
	      if(-1 < fn) {
	        if(35 > fn) {
	          (pdi->fonts)[fn] = 1;
	        }
	      }
	    }
	  }
	} break;
	case DK3_FIG_OBJ_ELLIPSE:
	case DK3_FIG_OBJ_POLYLINE:
	case DK3_FIG_OBJ_SPLINE:
	case DK3_FIG_OBJ_ARC: {
	} break;
      }
    }
    /*	Calculate dictionary size.
    */
    for(i = 0; i < 35; i++) {
      if((pdi->fonts)[i]) {		/* Fonts */
        pdi->dictsize += 1;
      }
    }
    if(pdi->havetext) {			/* Font reencode procedure */
      pdi->dictsize += 1;
    }
    if(pdi->alignedcenter) {		/* Procedure to show centered text. */
      pdi->dictsize += 1;
    }
    if(pdi->alignedright) {		/* Procedure to show right-algigned. */
      pdi->dictsize += 1;
    }
    pdi->dictsize += 5;			/* Reserve. */
  } else {
    f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1974 "f2leps.ctr"
  }
  return back;
}



void
f2leps_eps_pure_end(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  if(drw->dsd) {
    f2leps_drawing_info_delete((f2leps_drawing_info_t *)(drw->dsd));
  }
}



int
f2leps_eps_pure_open_output_files(f2l_job_t *job)
{
  int		 back = 0;
  job->of1 = dk3sf_fopen_app(job->on1, dkT("wb"), job->app);
  if(job->of1) {
    back = 1;
  } else {
    f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYSTEM); 

#line 1999 "f2leps.ctr"
  }
  return back;
}



void
f2leps_eps_pure_close_output_files(f2l_job_t *job)
{
  if(job->of1) {
    dk3sf_fclose_app(job->of1, job->app);
  } job->of1 = NULL;
}



int
f2leps_eps_pure_start_processing(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  int		 back = 1;
  f2leps_file_header(job, drw, job->of1, 1);
  return back;
}



void
f2leps_eps_pure_end_processing(f2l_job_t *job, dk3_fig_drawing_t *drw)
{
  f2leps_file_footer(job, drw, job->of1, 1);
}



void
f2leps_eps_pure_text_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  dk3_rgb_color_t	 rgb;
  double		 fs;
  int			 ff;
  int			 fn;
  int			 muc;
  ff = (obj->dt).txt.ff;
  if(!(ff & DK3_FIG_FONT_FLAG_HIDDEN)) {
    if(!(ff & DK3_FIG_FONT_FLAG_SPECIAL)) {
      fn = dk3fig_tool_ps_font_number(obj);
      if(-1 < fn) {
        if((obj->dt).txt.st) {
	  /* Set color */
	  dk3fig_tool_find_color(&rgb, drw, (obj->pc), 20);
          muc = dk3fig_tool_must_set_color(
            (job->gs).hc1, (job->gs).c1.r, (job->gs).c1.g, (job->gs).c1.b,
            rgb.r, rgb.g, rgb.b
          );
	  if(muc) {
	    fprintf(job->of1, f2leps_c8_kw[32], rgb.r, rgb.g, rgb.b);
	    (job->gs).c1.r = rgb.r;
	    (job->gs).c1.g = rgb.g;
	    (job->gs).c1.b = rgb.b;
	    (job->gs).c2.r = rgb.r;
	    (job->gs).c2.g = rgb.g;
	    (job->gs).c2.b = rgb.b;
	    (job->gs).hc1 = 1;
	    (job->gs).hc2 = 1;
	  }
	  /* Set font */
	  fs = (obj->dt).txt.fs;
	  if(0.0 < job->nts) { fs = fs * job->nts; }
	  muc = dk3fig_tool_must_set_font(
	    (job->gs).hfn, (job->gs).fn, (job->gs).fs, fn, fs
	  );
	  if(muc) {
	    fprintf(job->of1, f2leps_c8_kw[43], fn, fs);
	    (job->gs).hfn = 1;
	    (job->gs).fn = fn;
	    (job->gs).fs = fs;
	  }
          if(1.0e-6 < fabs((obj->dt).txt.an)) {	/* rotated */
	    /* gsave */
	    fputs(f2leps_c8_kw[15], job->of1);
	    /* translate */
	    fprintf(job->of1, f2leps_c8_kw[47], x, y);
	    /* rotate */
	    fprintf(
	      job->of1, f2leps_c8_kw[48],
	      ((180.0 * (obj->dt).txt.an) / M_PI)
	    );
#if 0
	    /* newpath */
	    fputs(f2leps_c8_kw[21], job->of1);
	    /* 0 0 moveto */
	    fputs(f2leps_c8_kw[49], job->of1);
	    /* string */
	    f2leps_encode_string(job->of1, (obj->dt).txt.st);
	    /* show/show aligned */
	    switch(obj->st) {
	      case 2: {
	        fputs(f2leps_c8_kw[46], job->of1);
	      } break;
	      case 1: {
	        fputs(f2leps_c8_kw[45], job->of1);
	      } break;
	      default: {
	        fputs(f2leps_c8_kw[44], job->of1);
	      } break;
	    }
#else
	    fputs(f2leps_c8_kw[51], job->of1);
	    /* string */
	    f2leps_encode_string(job->of1, (obj->dt).txt.st);
	    /* show/show aligned */
	    switch(obj->st) {
	      case 2: {
	        fputs(f2leps_c8_kw[46], job->of1);
	      } break;
	      case 1: {
	        fputs(f2leps_c8_kw[45], job->of1);
	      } break;
	      default: {
	        fputs(f2leps_c8_kw[50], job->of1);
	      } break;
	    }
#endif
	    /* grestore */
	    fputs(f2leps_c8_kw[16], job->of1);
	  } else {				/* not rotated */
#if 0
	    /* newpath */
	    fputs(f2leps_c8_kw[21], job->of1);
	    /* moveto */
	    fprintf(job->of1, f2leps_c8_kw[25], x, y);
	    /* string */
	    f2leps_encode_string(job->of1, (obj->dt).txt.st);
	    /* show/show aligned */
	    switch(obj->st) {
	      case 2: {
	        fputs(f2leps_c8_kw[46], job->of1);
	      } break;
	      case 1: {
	        fputs(f2leps_c8_kw[45], job->of1);
	      } break;
	      default: {
	        fputs(f2leps_c8_kw[44], job->of1);
	      } break;
	    }
#else
	    fprintf(job->of1, "%lg %lg\n", x, y);
	    /* string */
	    f2leps_encode_string(job->of1, (obj->dt).txt.st);
	    /* show/show aligned */
	    switch(obj->st) {
	      case 2: {
	        fputs(f2leps_c8_kw[46], job->of1);
	      } break;
	      case 1: {
	        fputs(f2leps_c8_kw[45], job->of1);
	      } break;
	      default: {
	        fputs(f2leps_c8_kw[50], job->of1);
	      } break;
	    }
#endif
	  }
	} else {
	  /* ##### BUG: No string */
	}
      } else {
        /* ##### BUG: No font number found! */
      }
    } else {
      /* Warning: Skipping special text! */
      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 41);
      f2l_tool_set_exit_status(job, FIG2LAT_EXIT_ERROR_SYNTAX); 

#line 2178 "f2leps.ctr"
    }
  }
}



void
f2leps_eps_pure_image_object(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_bb_t		*outbb,
  int			 drawdir,
  int			*ec
)
{
  f2leps_image_object(job->of1, job, drw, obj, outbb, drawdir, ec);
}


void
f2leps_eps_pure_newpath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[21], job->of1);
}



void
f2leps_eps_pure_moveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  fprintf(job->of1, f2leps_c8_kw[25], x, y);
}



void
f2leps_eps_pure_lineto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 x,
  double		 y
)
{
  fprintf(job->of1, f2leps_c8_kw[26], x, y);
}



void
f2leps_eps_pure_curveto(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 xcs,
  double		 ycs,
  double		 xce,
  double		 yce,
  double		 xe,
  double		 ye
)
{
  fprintf(job->of1, f2leps_c8_kw[27], xcs, ycs, xce, yce, xe, ye);
}



void
f2leps_eps_pure_closepath(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[28], job->of1);
}



void
f2leps_eps_pure_fill(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[29], job->of1);
}



void
f2leps_eps_pure_clip(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[30], job->of1);
}



void
f2leps_eps_pure_stroke(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[31], job->of1);
}



void
f2leps_eps_pure_gsave(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[15], job->of1);
}



void
f2leps_eps_pure_grestore(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj
)
{
  fputs(f2leps_c8_kw[16], job->of1);
}



void
f2leps_eps_pure_setcolor(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 r,
  double		 g,
  double		 b
)
{
  fprintf(job->of1, f2leps_c8_kw[32], r, g, b);
}



void
f2leps_eps_pure_set_line_width(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  double		 lw
)
{
  fprintf(job->of1, f2leps_c8_kw[33], lw);
}



void
f2leps_eps_pure_set_line_style(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 ls,
  double		 sv,
  double		 lw
)
{
  f2leps_set_line_style(job->of1, job, drw, obj, ls, sv, lw);
}



void
f2leps_eps_pure_set_line_end(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 le
)
{
  fprintf(job->of1, f2leps_c8_kw[34], le);
}



void
f2leps_eps_pure_set_line_join(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  int			 lj
)
{
  fprintf(job->of1, f2leps_c8_kw[35], lj);
}



void
f2leps_eps_pure_set_color_1(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
)
{
  fprintf(job->of1, f2leps_c8_kw[32], rgb->r, rgb->g, rgb->b);
}



void
f2leps_eps_pure_set_color_2(
  f2l_job_t		*job,
  dk3_fig_drawing_t	*drw,
  dk3_rgb_color_t	*rgb
)
{
  fprintf(job->of1, f2leps_c8_kw[32], rgb->r, rgb->g, rgb->b);
}



void
f2leps_eps_pure_debug(
  f2l_job_t		*job,
  char const		*msg
)
{
  f2leps_debug(job->of1, job, msg);
}

