
#ifndef DKWXPQDC_H_INCLUDED
#define	DKWXPQDC_H_INCLUDED	1

#ifdef	DK3_USE_WX
#undef	DK3_USE_WX
#endif
/**	Use wxWidgets libraries to build GUI programs.
*/
#define	DK3_USE_WX	1

#include <dk3all.h>
#include <dk3sock.h>
#include <printqds.h>
#include <dkt-version.h>


/**	Data returned from quota information server.
*/
typedef struct {
  unsigned long	li;	/**< Pages limit. */
  unsigned long	pa;	/**< Pages used from limit. */
  unsigned long	ac;	/**< Pages in personal print account. */
  int		lt;	/**< Limit type: 0=denied, 1=pages, 2=unlimited. */
  int		su;	/**< Summary: 1=can print, 0=no printing. */
  int		ec;	/**< Error code: 0=no error, 1=connect failed. */
} wxpqdic_t;

#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include <wx/config.h>
#include <wx/filename.h>
#include <wx/gbsizer.h>
#include <wx/thread.h>
#include <wx/gauge.h>
#include <wx/help.h>
#include <wx/fs_zip.h>
#include <wx/cmdline.h>
#include <wx/socket.h>

#include "dk3wxs.h"
#include "DkWxAppHelper.h"
#include "DkWxFrame.h"
#include "DkWxCommunicator.h"
#include "DkWxProgressDialog.h"
#include "DkWxHelpController.h"

#include "DkWxPrintqdcApp.h"
#include "DkWxPrintqdcFrame.h"
#include "DkWxPrintqdcThread.h"


/**	@defgroup	wxdkpqdicevents	Event and other IDs. */
/**@{*/

/**	Event ID:	Quit program.
*/
#define	DkWxPrintqdc_Quit	wxID_EXIT

/**	Event ID:	Show about box.
*/
#define	DkWxPrintqdc_About	wxID_ABOUT

/**	Event ID:	Widget ID for main window.
*/
#define	DkWxPrintqdc_MainWindow	(wxID_HIGHEST + 1)

/**	Event ID:	Update view.
*/
#define	DkWxPrintqdc_Update	(DkWxPrintqdc_MainWindow + 1)

/**	Event ID:	Timer event.
*/
#define	DkWxPrintqdc_Timer	(DkWxPrintqdc_Update + 1)

/**	Event ID:	Open help.
*/
#define	DkWxPrintqdc_Help	(DkWxPrintqdc_About + 1)
/**@}*/

/**	@defgroup	wxpqdicerrors	Error codes in wxpqdic. */
/**@{*/

/**	No error occured.
*/
#define	WXPQDIC_ERROR_NONE		0

/**	Failed to set up internal data structures.
*/
#define	WXPQDIC_ERROR_INIT		1

/**	Failed to find user name (not found or too long)!
*/
#define WXPQDIC_ERROR_NO_USER_NAME	2

/**	Host name not configured.
*/
#define	WXPQDIC_ERROR_NO_HOST_NAME	3

/**	Port number not conifgured.
*/
#define	WXPQDIC_ERROR_NO_PORT_NUMBER	4

/**	Queue name not configured.
*/
#define	WXPQDIC_ERROR_NO_QUEUE_NAME	5

/**	Not enough memory.
*/
#define WXPQDIC_ERROR_MEMORY		6

/**	No request configured.
*/
#define	WXPQDIC_ERROR_NO_REQUEST	7

/**	Failed to connect to server.
*/
#define WXPQDIC_ERROR_CONNECT_FAILED	8

/**	Failed to send request to server.
*/
#define WXPQDIC_ERROR_SEND_FAILED	9

/**	Failed to shutdown server socket.
*/
#define	WXPQDIC_ERROR_SHUTDOWN		10

/**	Server did not send a response.
*/
#define WXPQDIC_ERROR_NO_RESPONSE	11

/**	Response from server invalid.
*/
#define WXPQDIC_ERROR_INVALID_RESPONSE	12

/**@}*/



#define	WXPQDI_USER_NAME_SIZE		64

#define	WXPQDI_QUEUE_NAME_SIZE		64

#endif
/* ifndef DKWXPQDC_H_INCLUDED */

