/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dkwt.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dkwt.c The dkwt module.
*/


#line 10 "dkwt.ctr"

#include "dk3all.h"
#include "dkt-version.h"
#include "dkt.h"
#include "dkwt.h"





#line 19 "dkwt.ctr"



/**	File name for string table file.
*/
static dkChar const dkwt_string_table_file_name[] = { dkT("dkwt.str") };



/**	Version number string.
*/
static dkChar const dkwt_version[] = {
dkT("dkwt ") DKT_VERSION
};



/**	License terms.
*/
static dkChar const * const dkwt_license[] = {
dkT(""),
dkT("Copyright (c) 2011-2013, Dirk Krause"),
dkT("All rights reserved."),
dkT(""),
dkT("Redistribution and use in source and binary forms,"),
dkT("with or without modification, are permitted provided"),
dkT("that the following conditions are met:"),
dkT(""),
dkT("* Redistributions of source code must retain the above"),
dkT("  copyright notice, this list of conditions and the"),
dkT("  following disclaimer."),
dkT("* Redistributions in binary form must reproduce the above "),
dkT("  copyright notice, this list of conditions and the following"),
dkT("  disclaimer in the documentation and/or other materials"),
dkT("  provided with the distribution."),
dkT("* Neither the name of the copyright holder(s) nor the names of"),
dkT("  contributors may be used to endorse or promote"),
dkT("  products derived from this software without specific"),
dkT("  prior written permission."),
dkT(""),
dkT("THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND"),
dkT("CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES,"),
dkT("INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF"),
dkT("MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE"),
dkT("DISCLAIMED."),
dkT("IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE"),
dkT("LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,"),
dkT("EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT"),
dkT("LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;"),
dkT("LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)"),
dkT("HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN"),
dkT("CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE"),
dkT("OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS"),
dkT("SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH"),
dkT("DAMAGE."),
dkT(""),
NULL


#line 77 "dkwt.ctr"
};



/**	Message texts used by the program, localized.
*/
static dkChar const * const	dkwt_message_texts[] = {
/* 0 */
dkT("Full name:     "),

/* 1 */
dkT("Comment:       "),

/* 2 */
dkT("User comment:  "),

/* 3 */
dkT("Home directory:"),

/* 4 */
dkT("User profile:  "),

/* 5 */
dkT("SID:           "),

/* 6 */
dkT("Type:          "),

/* 7 */
dkT("Guest"),

/* 8 */
dkT("User"),

/* 9 */
dkT("Administrator"),

/* 10 */
dkT("Flags:         "),

/* 11 */
dkT("Login script executed."),

/* 12 */
dkT("Account disabled."),

/* 13 */
dkT("Home directory required."),

/* 14 */
dkT("No password required."),

/* 15 */
dkT("Password can not be changed."),

/* 16 */
dkT("Account locked out."),

/* 17 */
dkT("Password does not expire."),

/* 18 */
dkT("Encrypted text password allowed."),

/* 19 */
dkT("Sensitive account, no delegation."),

/* 20 */
dkT("Smartcard required."),

/* 21 */
dkT("DES keys only."),

/* 22 */
dkT("No Kerberos pre-authentication required."),

/* 23 */
dkT("Trusted for delegation."),

/* 24 */
dkT("Password expired."),

/* 25 */
dkT("Trusted to authenticate for delegation."),

/* 26 */
dkT("Normal user account."),

/* 27 */
dkT("Duplicated account for user from another domain."),

/* 28 */
dkT("Workstation trust account."),

/* 29 */
dkT("Server trust account."),

/* 30 */
dkT("Interdomain trust account."),

/* 31 */
dkT(""),

/* 32 */
dkT("Operator:      "),

/* 33 */
dkT("Accounts operator."),

/* 34 */
dkT("Server operator."),

/* 35 */
dkT("Communications operator."),

/* 36 */
dkT("Print operator."),

/* 37 */
dkT("Country code:  "),

/* 38 */
dkT("Code page no.: "),

/* 39 */
dkT("Source:  "),

/* 40 */
dkT("Comment: "),

/* 41 */
dkT("Net"),

/* 42 */
dkT("Local"),

/* 43 */
dkT("SID:     "),

/* 44 */
dkT("Comment:         "),

/* 45 */
dkT("Description:     "),

/* 46 */
dkT("Location:        "),

/* 47 */
dkT("Server:          "),

/* 48 */
dkT("Share name:      "),

/* 49 */
dkT("Port:            "),

/* 50 */
dkT("Driver:          "),

/* 51 */
dkT("Device:          "),

/* 52 */
dkT("Separator file:  "),

/* 53 */
dkT("Print processor: "),

/* 54 */
dkT("Data type:       "),

/* 55 */
dkT("Parameters:      "),

/* 56 */
dkT("Failed to create print file \""),

/* 57 */
dkT("\"!"),

/* 58 */
dkT("Failed to schedule print job!"),

/* 59 */
dkT("Failed to add print job!"),

/* 60 */
dkT("Failed to open printer \""),

/* 61 */
dkT("\"!"),

/* 62 */
dkT("Printer name too long!"),

/* 63 */
dkT("No printer found for device \""),

/* 64 */
dkT("\"!"),

/* 65 */
dkT("Failed to find default printer!"),

/* 66 */
dkT("Redefinition of profile base directory!"),

/* 67 */
dkT("No profile base directory specified!"),

/* 68 */
dkT("Syntax error - Unknown section type!"),

/* 69 */
dkT("Syntax error - Incomplete section header!"),

/* 70 */
dkT("Syntax error - Missing section header!"),

/* 71 */
dkT("Syntax error - Redefinition of system user!"),

/* 72 */
dkT("Syntax error - Redefinition of everyone user!"),

/* 73 */
dkT("Syntax error - Unknown option!"),

/* 74 */
dkT("Syntax error - Not a key/value pair!"),

/* 75 */
dkT("Options -l and -s are exclusive!"),

/* 76 */
dkT("Arguments are ignored!"),

/* 77 */
dkT("FAILED TO SET KEEP-DATA FLAG!"),

/* 78 */
dkT("Keep-data flag was set successfully."),

/* 79 */
dkT("Exit status code indicates an error, program:\n\""),

/* 80 */
dkT(""),

/* 81 */
dkT("Failed to find name for SID \""),

/* 82 */
dkT("\"!"),

/* 83 */
dkT("Cleaning up local print queue \""),

/* 84 */
dkT("\"."),

/* 85 */
dkT("Successfully deleted job "),

/* 86 */
dkT(": \""),

/* 87 */
dkT("\"."),

/* 88 */
dkT("Unnamed print job"),

/* 89 */
dkT("Failed to delete job "),

/* 90 */
dkT(": \""),

/* 91 */
dkT("\"!"),

/* 92 */
dkT("Failed to open printer \""),

/* 93 */
dkT("\"!"),

/* 94 */
dkT("Failed to enumerate local printers!"),

/* 95 */
dkT("Missing user name!"),

/* 96 */
dkT("Print queue cleaned up successfully."),

/* 97 */
dkT("Failed to send request!"),

/* 98 */
dkT("Failed to connect to remote host!"),

/* 99 */
dkT("Failed to create network socket!"),

/* 100 */
dkT("Failed to find IP address for remote host!"),

/* 101 */
dkT("Cleaning up remote print queue \""),

/* 102 */
dkT("\"."),

/* 103 */
dkT("Request too long for buffer!"),

/* 104 */
dkT("Empty queue name in \""),

/* 105 */
dkT("\"!"),

/* 106 */
dkT("Empty host name in \""),

/* 107 */
dkT("\"!"),

/* 108 */
dkT("Not a queue@host name: \""),

/* 109 */
dkT("\"!"),

/* 110 */
dkT("Queue name \""),

/* 111 */
dkT("\" too long!"),

/* 112 */
dkT("Failed to initialize Windows sockets!"),

/* 113 */
dkT("Error code: "),

/* 114 */
dkT("."),

/* 115 */
dkT("IP address: "),

/* 116 */
dkT("."),

/* 117 */
dkT("User profile cleanup is disabled on Windows Vista and above!"),

/* 118 */
dkT("Executing command:\n"),

/* 119 */
dkT(""),

/* 120 */
dkT("Remove directory:\n"),

/* 121 */
dkT(""),

/* 122 */
dkT("Remove file:\n"),

/* 123 */
dkT(""),

/* 124 */
dkT("Delete registry key:\n"),

/* 125 */
dkT("\\"),

/* 126 */
dkT(""),

/* 127 */
dkT("Registry key \""),

/* 128 */
dkT("\" deleted."),

/* 129 */
dkT("Failed to remove registry key:\n"),

/* 130 */
dkT("\\"),

/* 131 */
dkT(""),

/* 132 */
dkT("Failed to open registry key:\n"),

/* 133 */
dkT(""),

/* 134 */
dkT("Cleaning up profiles (start)."),

/* 135 */
dkT("Internal error while retrieving directory entry name!"),

/* 136 */
dkT("Failed to expand string\n\""),

/* 137 */
dkT("\",\nresult would become too long for buffer!"),

/* 138 */
dkT("Subkey name too long:\n"),

/* 139 */
dkT(""),

/* 140 */
dkT("Skipping profile cleanup due to previous errors!"),

/* 141 */
dkT("Cleaning up profiles (finished)."),

/* 142 */
dkT("Options -u, -i, -a, and -d are mutually exlusive!"),

/* 143 */
dkT("At least one argument required!"),

/* 144 */
dkT("Missing file/directory name!"),

NULL


#line 579 "dkwt.ctr"
};



/**	Keywords used by the program, not localized.
*/
static dkChar const * const	dkwt_no_loc[] = {
/* 0 */
dkT(""),

/* 1 */
dkT("dkwt.conf"),

/* 2 */
dkT("System"),

/* 3 */
dkT("Jeder"),

/* 4 */
dkT("RD  /S /Q \""),

/* 5 */
dkT("\""),

/* 6 */
dkT("DEL /Q /F \""),

/* 7 */
dkT("CACLS.EXE \""),

/* 8 */
dkT("\" /T /E /C /G"),

/* 9 */
dkT(":F"),

/* 10 */
dkT("ICACLS.EXE \""),

/* 11 */
dkT("\" /grant "),

/* 12 */
dkT(":F /T /C /Q"),

/* 13 */
dkT(":F /C /Q"),

/* 14 */
dkT("\" /E /C /G "),

/* 15 */
dkT("SOFTWARE\\DKrause\\Shared\\dkwt"),

/* 16 */
dkT("keep"),

/* 17 */
dkT("S-1-1-0"),

/* 18 */
dkT("S-1-5-18"),

/* 19 */
dkT("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\ProfileList"),

/* 20 */
dkT("\\"),

/* 21 */
dkT("ProfileImagePath"),

NULL


#line 676 "dkwt.ctr"
};



/**	Subcommand names.
*/
static dkChar const * const	dkwt_commands[] = {
/*   0 */ dkT("boot"),
/*   1 */ dkT("shutdown"),
/*   2 */ dkT("login"),
/*   3 */ dkT("logout"),
/*   4 */ dkT("users"),
/*   5 */ dkT("groups"),
/*   6 */ dkT("printers"),
/*   7 */ dkT("print"),
/*   8 */ dkT("help"),
/*   9 */ dkT("version"),
/*  10 */ dkT("license-terms"),
/*  11 */ dkT("keep"),
/*  12 */ dkT("unkeep"),
/*  13 */ dkT("--help"),
/*  14 */ dkT("--version"),
/*  15 */ dkT("--license-terms"),
/*  16 */ dkT("--license"),
/*  17 */ dkT("license"),
/*  18 */ dkT("-h"),
/*  19 */ dkT("-v"),
/*  20 */ dkT("-L"),
/*  21 */ dkT("cleanup-profiles"),
/*  22 */ dkT("clp"),
/*  23 */ dkT("env"),
/*  24 */ dkT("environment"),
NULL
};



/**	Help file names.
*/
static dkChar const * const	dkwt_help_file_names[] = {
/*   0 */ dkT("dkwt-boot.txt"),
/*   1 */ dkT("dkwt-shutdown.txt"),
/*   2 */ dkT("dkwt-login.txt"),
/*   3 */ dkT("dkwt-logout.txt"),
/*   4 */ dkT("dkwt-users.txt"),
/*   5 */ dkT("dkwt-groups.txt"),
/*   6 */ dkT("dkwt-printers.txt"),
/*   7 */ dkT("dkwt-print.txt"),
/*   8 */ dkT("dkwt-help.txt"),
/*   9 */ dkT(""),	/* unused */
/*  10 */ dkT(""),	/* unused */
/*  11 */ dkT("dkwt-keep.txt"),
/*  12 */ dkT("dkwt-unkeep.txt"),
/*  13 */ dkT("dkwt-clp.txt"),
/*  14 */ dkT("dkwt-env.txt"),
NULL
};



/**	Help text for the boot command.
*/
static dkChar const * const	dkwt_help_boot[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt boot - Boot cleanup"),
dkT(""),
dkT("SYNOPSIS"),
dkT("  "),
dkT("  dkwt boot [-t]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The \"dkwt boot\" program should be run from the system boot script to do"),
dkT("cleanup at boot time in PC classrooms."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-t"),
dkT("\truns in test mode. The program does not perform cleanup, it only writes"),
dkT("\tmessages about files and directories to delete."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The exit status code is always 0, regardless of any error occured."),
dkT(""),
dkT("FILES"),
dkT(""),
dkT("dkwt.conf"),
dkT("\tConfiguration file for cleanup operations."),
dkT("\tRun"),
dkT("\t\tdkwt -h"),
dkT("\tto view detailed information about the dkwt.conf file."),
dkT(""),
dkT("NOTES"),
dkT(""),
dkT("After changing the dkwt.conf file you should run"),
dkT("  dkwt boot -t"),
dkT("to test the dkwt.conf file."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 793 "dkwt.ctr"
};



/**	Help text for the shutdown command.
*/
static dkChar const * const	dkwt_help_shutdown[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt shutdown - Shutdown cleanup"),
dkT(""),
dkT("SYNOPSIS"),
dkT("  "),
dkT("  dkwt shutdown [-t]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The \"dkwt shutdown\" program should be run from the system shutdown script to do"),
dkT("cleanup at shutdown time in PC classrooms."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-t"),
dkT("\truns in test mode. The program does not perform cleanup, it only writes"),
dkT("\tmessages about files and directories to delete."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The exit status code is always 0, regardless of any error occured."),
dkT(""),
dkT("FILES"),
dkT(""),
dkT("dkwt.conf"),
dkT("\tConfiguration file for cleanup operations."),
dkT("\tRun"),
dkT("\t\tdkwt -h"),
dkT("\tto view detailed information about the dkwt.conf file."),
dkT(""),
dkT("NOTES"),
dkT(""),
dkT("After changing the dkwt.conf file you should run"),
dkT("  dkwt shutdown -t"),
dkT("to test the dkwt.conf file."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 854 "dkwt.ctr"
};



/**	Help text for the login command.
*/
static dkChar const * const	dkwt_help_login[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt login - Login cleanup"),
dkT(""),
dkT("SYNOPSIS"),
dkT("  "),
dkT("  dkwt login [-t]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The \"dkwt login\" program should be run from the user login script to do"),
dkT("cleanup at login time in PC classrooms."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-t"),
dkT("\truns in test mode. The program does not perform cleanup, it only writes"),
dkT("\tmessages about files and directories to delete."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The exit status code is always 0, regardless of any error occured."),
dkT(""),
dkT("FILES"),
dkT(""),
dkT("dkwt.conf"),
dkT("\tConfiguration file for cleanup operations."),
dkT("\tRun"),
dkT("\t\tdkwt -h"),
dkT("\tto view detailed information about the dkwt.conf file."),
dkT(""),
dkT("NOTES"),
dkT(""),
dkT("After changing the dkwt.conf file you should run"),
dkT("  dkwt login -t"),
dkT("to test the dkwt.conf file."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 915 "dkwt.ctr"
};



/**	Help text for the logout command.
*/
static dkChar const * const	dkwt_help_logout[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt logout - Logout cleanup"),
dkT(""),
dkT("SYNOPSIS"),
dkT("  "),
dkT("  dkwt logout [-t]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The \"dkwt logout\" program should be run from the user logout script to do"),
dkT("cleanup at logout time in PC classrooms."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-t"),
dkT("\truns in test mode. The program does not perform cleanup, it only writes"),
dkT("\tmessages about files and directories to delete."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The exit status code is always 0, regardless of any error occured."),
dkT(""),
dkT("FILES"),
dkT(""),
dkT("dkwt.conf"),
dkT("\tConfiguration file for cleanup operations."),
dkT("\tRun"),
dkT("\t\tdkwt -h"),
dkT("\tto view detailed information about the dkwt.conf file."),
dkT(""),
dkT("NOTES"),
dkT(""),
dkT("After changing the dkwt.conf file you should run"),
dkT("  dkwt logout -t"),
dkT("to test the dkwt.conf file."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 976 "dkwt.ctr"
};



/**	Help text for the keep command.
*/
static dkChar const * const	dkwt_help_keep[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt keep - Temporarily disable automatic cleanup"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkwt keep"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("Use this program to disable automatic cleanup until (including) the next"),
dkT("user login."),
dkT("You should use this command in lectures about system programming before"),
dkT("starting to test self-made system software, drivers..."),
dkT("Use the"),
dkT("  dkwt unkeep"),
dkT("command to restore normal automatic cleanup when you are done with the tests."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns exit status code 0 on success, all other status"),
dkT("codes indicate an error."),
dkT(""),
dkT("REGISTRY"),
dkT(""),
dkT("The HKEY_LOCAL_MACHINE\\SOFTWARE\\DKrause\\Shared\\dkwt must exist, full access"),
dkT("must be possible for \"Everyone\" or \"INTERACTIVE\"."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 1028 "dkwt.ctr"
};



/**	Help text for the keep command.
*/
static dkChar const * const	dkwt_help_unkeep[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt unkeep - Restore automatic cleanup"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkwt unkeep"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("After disabling automatic cleanup temporarily using \"dkwt keep\" you can use"),
dkT("this command to restore normal automatic cleanup."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns exit status code 0 on success, all other status"),
dkT("codes indicate an error."),
dkT(""),
dkT("REGISTRY"),
dkT(""),
dkT("The HKEY_LOCAL_MACHINE\\SOFTWARE\\DKrause\\Shared\\dkwt must exist, full access"),
dkT("must be possible for \"Everyone\" or \"INTERACTIVE\"."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 1077 "dkwt.ctr"
};


/**	Help text for the cleanup-profiles command.
*/
static dkChar const * const	dkwt_help_clp[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt cleanup-profiles - Clean up profiles directories."),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkwt cleanup-profiles"),
dkT("  dkwt clp"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("On Windows Vista and above we can not clean up profile directories"),
dkT("from boot/shutdown/logon/logoff scripts as these scripts are run from"),
dkT("a user account with insufficient permissions. User profiles cleanup"),
dkT("is skipped in \"dkwt boot\", \"dkwt login\", \"dkwt logout\", and \"dkwt shutdown\"."),
dkT(""),
dkT("You can start a command prompt *as administrator* instead and run"),
dkT("\"dkwt cleanup-profiles\" from there."),
dkT("The program first attempts to use system functions to delete"),
dkT("directories, additionally it uses the \"RD\" command."),
dkT(""),
dkT("Alternatively run \"dkwtadm cleanup-profiles\", this variant of dkwt uses"),
dkT("the UAC to obtain administrative permissions."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns exit status code 0 on success, all other status"),
dkT("codes indicate an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 1131 "dkwt.ctr"
};



/**	Help text for dkwt env.
*/
static dkChar const * const	dkwt_help_env[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt env - Modify environment variables"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkwt env         [<options>] <name> [<value>]"),
dkT("  dkwt environment [<options>] <name> [<value>]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("This function can modify environment variables, both system and"),
dkT("user variables."),
dkT("This function is mainly intended for environment variables storing"),
dkT("names of directories or files (i.e. the PATH variable)."),
dkT("You can make sure a directory is listed in a variable by inserting"),
dkT("or appending the directory only if it is not yet present."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-s"),
dkT("\tProcess system environment variables."),
dkT("\tWithout this option the program processes the user environment."),
dkT(""),
dkT("-e"),
dkT("\tWhen creating a new registry value, use type REG_EXPAND_SZ"),
dkT("\tinstead of default REG_SZ."),
dkT("\tThis option is ignored when processing existing registry values."),
dkT(""),
dkT("-u"),
dkT("\tDelete registry value completely, unset variable."),
dkT(""),
dkT("-i"),
dkT("\tEnsure the variable lists the specified directory or file,"),
dkT("\tinsert at start if not present."),
dkT(""),
dkT("-a"),
dkT("\tEnsure the variable lists the specified directory or file,"),
dkT("\tappend at end if not present."),
dkT(""),
dkT("-d"),
dkT("\tRemove a directory or file from a variable listing one"),
dkT("\tor multiple directories or files."),
dkT("\tIf the variable value is empty after removal, the registry"),
dkT("\tvalue is deleted."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns exit status code 0 on success, all other status"),
dkT("codes indicate an error."),
dkT(""),
dkT("EXAMPLES"),
dkT(""),
dkT("Show value of user environment variable TEMP:"),
dkT(""),
dkT("\tdkwt env TEMP"),
dkT(""),
dkT("Show value of system environment variable PATH:"),
dkT(""),
dkT("\tdkwt env -s PATH"),
dkT(""),
dkT("Completely delete user environment variable FOO:"),
dkT(""),
dkT("\tdkwt env -u FOO"),
dkT(""),
dkT("Completely delete system environment variable BAR:"),
dkT(""),
dkT("\tdkwt env -s -u BAR"),
dkT(""),
dkT("Set user environment variable FOO:"),
dkT(""),
dkT("\tdkwt env FOO All text after variable name goes into value"),
dkT(""),
dkT("Set system environment variable BAR:"),
dkT(""),
dkT("\tdkwt env -s BAR Same procedure for system variables"),
dkT(""),
dkT("Make sure system PATH contains ``C:\\Program Files\\Nice Program''"),
dkT("(insert at start if not present):"),
dkT(""),
dkT("\tdkwt env -s -i Path C:\\Program Files\\Nice Program"),
dkT(""),
dkT("Make sure system PATH contains ``C:\\Program Files\\Other Program''"),
dkT("(append at end if not present):"),
dkT(""),
dkT("\tdkwt env -s -a Path C:\\Program Files\\Other Program"),
dkT(""),
dkT("Remove ``C:\\Program Files\\Nice Program'' from system PATH:"),
dkT(""),
dkT("\tdkwt env -s -d Path C:\\Program Files\\Nice Program"),
dkT(""),
dkT("NOTES"),
dkT(""),
dkT("``dkwt env'' does not change environment variables in cmd.exe windows"),
dkT("already opened."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 1253 "dkwt.ctr"
};



/**	Help text for the users command.
*/
static dkChar const * const	dkwt_help_users[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt users - List users"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkwt users [<option>]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program lists the users configured on the system."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-l"),
dkT("\tcreates a long (detailed) listing."),
dkT(""),
dkT("-s"),
dkT("\tcreates a short listing (just the user names)."),
dkT(""),
dkT("Either -l or -s can be used, not both."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns exit status code 0 on success, all other status"),
dkT("codes indicate an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 1304 "dkwt.ctr"
};



/**	Help text for the groups command.
*/
static dkChar const * const	dkwt_help_groups[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt groups - List groups"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkwt groups <option>"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The command lists the group on the current system."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-l"),
dkT("\tcreates a long (detailed) listing."),
dkT(""),
dkT("-s"),
dkT("\tcreates aa short listing (just the group names)."),
dkT(""),
dkT("The options -l and -s can not be used together."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns exit status code 0 on success, all other status"),
dkT("codes indicate an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 1355 "dkwt.ctr"
};



/**	Help text for dkwt help printers.
*/
static dkChar const * const	dkwt_help_printers[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt printers - List printers"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkwt printers [<option>]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The command lists the printers installed on the system."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-l"),
dkT("\tcreates a long (detailed) listing. Without this option the listing"),
dkT("\tonly shows the printer names."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns exit status code 0 on success, all other status"),
dkT("codes indicate an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 1402 "dkwt.ctr"
};


/**     Help text for the print command.
*/
static dkChar const * const	dkwt_help_print[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt print - Print a file"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkwt print [<option>] [<file(s)>]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program prints the specified files or the contents read from standard"),
dkT("input if no file name is specified."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-d <device>"),
dkT("\tchooses a printer by the device name. The device name must be specified"),
dkT("\there, not the printer name."),
dkT("\tWithout this option the system's default printer is used."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns exit status code 0 on success, all other status"),
dkT("codes indicate an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 1450 "dkwt.ctr"
};



/**	General help text.
*/
static dkChar const * const	dkwt_help_help[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkwt - Dirk Krause's Windows tool"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkwt users    [<option(s)>]"),
dkT("  dkwt groups   [<option(s)>]"),
dkT("  dkwt printers [<option(s)>]"),
dkT("  dkwt print    [<option(s)>] [<file(s)>]"),
dkT("  dkwt boot"),
dkT("  dkwt login"),
dkT("  dkwt logout"),
dkT("  dkwt shutdown"),
dkT("  dkwt keep"),
dkT("  dkwt unkeep"),
dkT("  dkwt cleanup-profiles"),
dkT("  dkwt env [<options>] <name> [<value>]"),
dkT("  dkwt help     <command>"),
dkT("  dkwt -h"),
dkT("  dkwt -v"),
dkT("  dkwt -L"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("dkwt users\t\tlists the users."),
dkT("dkwt groups\t\tlists the user groups."),
dkT("dkwt printers\t\tlists the available printers."),
dkT("dkwt print\t\tprints the specified file(s)."),
dkT("dkwt boot\t\tdoes cleanup during boot."),
dkT("dkwt login\t\tdoes cleanup during user login."),
dkT("dkwt logout\t\tdoes cleanup during user logout."),
dkT("dkwt shutdown\t\tdoes cleanup during shutdown."),
dkT("dkwt keep\t\tdisables automatic cleanup temporarily until"),
dkT("\t\t\tthe next user login is completed."),
dkT("dkwt unkeep\t\trestores normal cleanup mechanisms."),
dkT("dkwt cleanup-profiles   cleans up user profiles."),
dkT("dkwt help <command>\tprints a help text for a specific command."),
dkT("dkwt -h\t\t\tshows this help text."),
dkT("dkwt -v\t\t\tshows version information."),
dkT("dkwt -L\t\t\tshows the license conditions."),
dkT(""),
dkT("The boot, login, logout, shutdown, keep, and unkeep commands are intended for"),
dkT("use in PC classrooms, see NOTES below."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-s"),
dkT("\tswitches to short listings for the users, and groups command."),
dkT(""),
dkT("-l"),
dkT("\tswitches to long (detailed) listings for users, groups, and"),
dkT("\tprinters command."),
dkT(""),
dkT("-d <device>"),
dkT("\tchooses the printer for the print command."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns exit status code 0 on success, all other status"),
dkT("codes indicate an error."),
dkT(""),
dkT("FILES"),
dkT(""),
dkT("dkwt.conf"),
dkT("\tThe dkwt.conf file is used to configure automatic cleanup for the boot,"),
dkT("\tlogin, logout, shutdown, and cleanup-profiles command."),
dkT("\tThe file should be placed in \"C:\\Program Files\\Krause\\etc\\dkt-3-size\""),
dkT("\tor \"C:\\Program Files (x86)\\Krause\\etc\\dkt-3-size\" depending on your"),
dkT("\tWindows version (32 or 64 bit)."),
dkT("\tThe file consists of three sections: \"options\", \"public\", and"),
dkT("\t\"profiles\"."),
dkT(""),
dkT("\tIn the options section you can configure the name for the \"System\""),
dkT("\tand \"Everyone\" account, the name differs depending on the language"),
dkT("\tconfigured for your system. These settings are optional, the program"),
dkT("\tretrieves the names for SIDs \"S-1-5-18\" and \"S-1-1-0\" if the settings"),
dkT("\tare omitted."),
dkT(""),
dkT("\tIn the public section you can list public writable directories to"),
dkT("\tbe cleaned up automatically."),
dkT(""),
dkT("\tIn the start of the profiles section you configure the profile base"),
dkT("\tdirectory (the parent directory where the profile directories live in)."),
dkT("\tEach section line lists one directory to be left untouched by"),
dkT("\tautomatic cleanup."),
dkT("\tNOTE: On Windows 7 I do not recommend to manage user profile directories"),
dkT("\tusing dkwt. Use the group policy configured in gpedit.msc to remove"),
dkT("\texpired user profiles instead. Just omit the \"[profiles...]\" section."),
dkT(""),
dkT("\tExample:"),
dkT(""),
dkT("\t\t[options]"),
dkT("\t\tsystem user\t=\tSystem"),
dkT("\t\teveryone user\t=\tEveryone"),
dkT(""),
dkT("\t\t[public]"),
dkT("\t\tc:\\temp"),
dkT("\t\tc:\\lecture"),
dkT(""),
dkT("\t\t[profiles C:\\Users]"),
dkT("\t\tAll Users"),
dkT("\t\tDefault User"),
dkT("\t\tPublic"),
dkT("\t\tAdministrator"),
dkT("\t\tadmin"),
dkT("\t\tsshd_server"),
dkT(""),
dkT("NOTES"),
dkT(""),
dkT("The boot, login, logout, shutdown, and cleanup-profiles commands are"),
dkT("intended for use in computer classrooms and other educational environments."),
dkT("We assume the following:"),
dkT("- User accounts are managed centrally, i.e. in AD or a Windows domain."),
dkT("  There is only a few local accounts on each system required by the Windows"),
dkT("  system itself or by services running."),
dkT("- Each \"normal\" user has a home directory on a file server."),
dkT("- Typically all users in a class room log in and out nearly at the same time"),
dkT("  (begin and end of a lecture)."),
dkT("For the following reasons we do not store user profiles on a file server:"),
dkT("- Large parts of the user profile are not related to the lectures, saving"),
dkT("  them on a file server would be waste of disk space."),
dkT("  Although Windows allows you to exclude profile subdirectories from"),
dkT("  profile replication we don't want to use this feature. Blacklist mechanisms"),
dkT("  require research for new directories to exclude after each software"),
dkT("  installation or update."),
dkT("- Due to the simultaneous login and logout of all users there would be"),
dkT("  load peaks on server and networks on begin and end of lectures significantly"),
dkT("  higher than average load."),
dkT("So we use a setup as follows:"),
dkT("- In the group policies we allow local user profiles only, profile"),
dkT("  synchronization or propagation to the server is disabled."),
dkT("- During the lectures users write data to a public writable directory, i.e."),
dkT("  C:\\Temp or C:\\Lecture. At the end of the lecture they save valuable data"),
dkT("  to the home directory or to private storage media (i.e. USB device)."),
dkT("  After saving the data the users deletes all contents he created in the"),
dkT("  public writable directory."),
dkT("- During logout a logout script is run. This script first changes the"),
dkT("  permissions to all contents still found in the public writable directories"),
dkT("  to grant full access for everyone. Next it attempts to remove the contents."),
dkT("  The same is done for the users home directory."),
dkT("- Not all contents can be deleted during logout as some files still might be"),
dkT("  in use (i.e. the HKCU registry hive file in the user profile). So we attempt"),
dkT("  to delete these contents again at the next users login, at shutdown and"),
dkT("  at next reboot."),
dkT("To have this cleanup automatically we add"),
dkT("  dkwt boot"),
dkT("to the system boot script,"),
dkT("  dkwt login"),
dkT("to the user login script,"),
dkT("  dkwt logout"),
dkT("to the user logout script, and"),
dkT("  dkwt shutdown"),
dkT("to the system shutdown script."),
dkT(""),
dkT("On Windows Vista and above the boot, login, logout, and shutdown commands"),
dkT("do not attempt to clean up user profiles. Login scripts here do not"),
dkT("have sufficient permissions to clean up. You can start the command"),
dkT("prompt as administrator and run \"dkwt cleanup-profiles\" manually instead."),
dkT(""),
dkT("Lectures about system programming (i.e. \"How do I build a driver?\") need a"),
dkT("special setup. When testing self-made system software the system may crash"),
dkT("or hang, so a reboot with a new login will be necessary."),
dkT("We need to deactivate the automatic cleanup, otherwise all changes we made"),
dkT("in the public writable directories would be lost."),
dkT("Before starting experiments we run"),
dkT("  dkwt keep"),
dkT("to disable automatic cleanup temporarily until the next user login is finished."),
dkT("If all experiments succeeded we can run"),
dkT("  dkwt unkeep"),
dkT("after saving all our changes before logging off."),
dkT("The HKEY_LOCAL_MACHINE\\SOFTWARE\\DKrause\\Shared\\dkwt must exist, full access"),
dkT("must be possible for \"Everyone\" or \"INTERACTIVE\"."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkwt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 1650 "dkwt.ctr"
};



/**	Application group name.
*/
static dkChar const dkwt_group_name[] = { dkT("dkt-3") };



/**	Print help text.
	@param	app	Application structure.
	@param	msg	Array containing localized texts.
	@param	noloc	Array containing non-localized texts.
	@param	topic	Help topic ID.
	@return	1 on success, 0 on error.
*/
static
int
dkwt_help(
  dk3_app_t		*app,
  dkChar const * const	*msg,
  dkChar const * const	*noloc,
  int			 topic
)
{
  switch(topic) {
    case  0: {
      dk3app_help(app, dkwt_help_file_names[topic], dkwt_help_boot);
    } break;
    case  1: {
      dk3app_help(app, dkwt_help_file_names[topic], dkwt_help_shutdown);
    } break;
    case  2: {
      dk3app_help(app, dkwt_help_file_names[topic], dkwt_help_login);
    } break;
    case  3: {
      dk3app_help(app, dkwt_help_file_names[topic], dkwt_help_logout);
    } break;
    case  4: {
      dk3app_help(app, dkwt_help_file_names[topic], dkwt_help_users);
    } break;
    case  5: {
      dk3app_help(app, dkwt_help_file_names[topic], dkwt_help_groups);
    } break;
    case  6: {
      dk3app_help(app, dkwt_help_file_names[topic], dkwt_help_printers);
    } break;
    case  7: {
      dk3app_help(app, dkwt_help_file_names[topic], dkwt_help_print);
    } break;
    case  8: {
      dk3app_help(app, dkwt_help_file_names[topic], dkwt_help_help);
    } break;
    case 11: {
      dk3app_help(app, dkwt_help_file_names[topic], dkwt_help_keep);
    } break;
    case 12: {
      dk3app_help(app, dkwt_help_file_names[topic], dkwt_help_unkeep);
    } break;
    case 21: case 22: {
      dk3app_help(app, dkwt_help_file_names[13], dkwt_help_clp);
    } break;
    case 23: case 24: {
      dk3app_help(app, dkwt_help_file_names[14], dkwt_help_env);
    } break;
  }
  return 0;
}



/**	The main function.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	0 on success, any other value indicates an error.
*/
DK3_MAIN
{
  int exval = DKT_RESULT_ERR_UNSPECIFIC;
  dk3_app_t		*app = NULL;
  dkChar const * const	*msg = NULL;
  int			 xargc = 0;
  int			 topic = 0;
  dkChar const * const	*xargv = NULL;
  

#line 1736 "dkwt.ctr"
  

#line 1737 "dkwt.ctr"
  if((sizeof(dkChar) != 2) || (sizeof(TCHAR) != 2)) {
    fprintf(stderr, "Wrong compiler options were used to build this program!\n");
    fprintf(stderr, "Size of dkChar: %u\n", (unsigned)sizeof(dkChar));
    fprintf(stderr, "Size of TCHAR:  %u\n", (unsigned)sizeof(TCHAR));
    fprintf(stderr, "Please re-compile with -DDK3_CHAR_SIZE=2 -D_UNICODE=1\n");
    fflush(stderr);
    exit(DKT_RESULT_ERR_UNSPECIFIC);
  }
  app = dk3app_open_command(
    argc, (dkChar const * const *)argv, dkwt_group_name
  );
  if(app) {
    msg = dk3app_messages(
      app, dkwt_string_table_file_name, (dkChar const **)dkwt_message_texts
    );
    xargc = dk3app_get_argc(app);
    xargv = dk3app_get_argv(app);
    if(xargc > 1) {
      switch(dk3str_array_index(dkwt_commands, xargv[1], 0)) {
        case 0: {	

#line 1757 "dkwt.ctr"
	  exval = dkwt_event(app, msg, dkwt_no_loc, 0);
	} break;
	case 1: {	

#line 1760 "dkwt.ctr"
	  exval = dkwt_event(app, msg, dkwt_no_loc, 1);
	} break;
	case 2: {	

#line 1763 "dkwt.ctr"
	  exval = dkwt_event(app, msg, dkwt_no_loc, 2);
	} break;
	case 3: {	

#line 1766 "dkwt.ctr"
	  exval = dkwt_event(app, msg, dkwt_no_loc, 3);
	} break;		
	case 4: {	

#line 1769 "dkwt.ctr"
	  exval = dkwt_accounts(app, msg, dkwt_no_loc);
	} break;
	case 5: {
	  exval = dkwt_groups(app, msg, dkwt_no_loc);
	} break;
	case 6: {
	  exval = dkwt_printers(app, msg, dkwt_no_loc);
	} break;
	case 7: {
	  exval = dkwt_print(app, msg, dkwt_no_loc);
	} break;
	case 8: case 13: case 18: {
	  topic = 8;
	  if(xargc > 2) {
	    topic = dk3str_array_index(dkwt_commands, xargv[2], 0);
	    if(topic < 0) topic = 8;
	  }
	  exval = dkwt_help(app, msg, dkwt_no_loc, topic);
	} break;
	case 9: case 14: case 19: {	/* version */
	  dk3sf_initialize_stdout();
	  dk3sf_fputs(dkwt_version, stdout);
	  dk3sf_fputc(dkT('\n'), stdout);
	} break;
	case 10: case 15: case 16: case 17: case 20: {	/* license */
	  dkChar const * const *sptr;
	  sptr = dkwt_license;
	  dk3sf_initialize_stdout();
	  while(*sptr) {
	    dk3sf_fputs(*(sptr++), stdout);
	    dk3sf_fputc(dkT('\n'), stdout);
	  }
	} break;
	case 11: {
	  exval = dkwt_event_keep(app, msg, dkwt_no_loc);
	} break;
	case 12: {
	  exval = dkwt_event_unkeep(app, msg, dkwt_no_loc);
	} break;
	case 21: case 22: {
	  exval = dkwt_event(app, msg, dkwt_no_loc, 4);
	} break;
	case 23: case 24: {
	  exval = dkwt_env(app, msg, dkwt_no_loc);
	} break;
      }
    }
    dk3app_close(app);
  } else {
    fprintf(stderr, "ERROR: Not enough memory!\n");
    fflush(stderr);
  }
  

#line 1822 "dkwt.ctr"
  

#line 1823 "dkwt.ctr"
  fflush(stdout);
  exit(exval); return exval;
}

