/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dkwt-to.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dkwt-to.c The dkwt-to module.
*/


#line 10 "dkwt-to.ctr"


#include "dk3all.h"
#include "dkt.h"
#include "dkwt.h"





#line 19 "dkwt-to.ctr"



/**	Compare 2 accounts.
	@param	l	Left account pointer.
	@param	r	Right account pointer.
	@param	cr	Comparison criteria (0=account/account, 1=account/name).
	@return	Comparison result.
*/
static
int
dkwt_tool_compare_accounts(void const *l, void const *r, int cr)
{
  int back = 0;
  dkwt_account_t const	*pl;
  dkwt_account_t const	*pr;
  pl = (dkwt_account_t const *)l; pr = (dkwt_account_t const *)r;
  if(l) {
    if(r) {
      switch(cr) {
        case 1: {
	  if(pl->logname) {
	    back = dk3str_casecmp(pl->logname, (dkChar const *)r);
	  } else {
	    back = -1;
	  }
	} break;
	default: {
	  if(pl->logname) {
	    if(pr->logname) {
	      back = dk3str_casecmp(pl->logname, pr->logname);
	    } else {
	      back = 1;
	    }
	  } else {
	    if(pr->logname) {
	      back = -1;
	    }
	  }
	} break;
      }
    } else {
      back = 1;
    }
  } else {
    if(r) {
      back = -1;
    }
  }
  if(back > 1) back = 1;
  if(back < -1) back = -1;
  return back;
}



/**	Compare two group entries.
	@param	l	Left entry.
	@param	r	Right entry.
	@param	cr	Comparison criteria
	(1=structure/name, other=sructure/structure).
	@return	Comparison result.
*/
static
int
dkwt_tool_compare_groups(void const *l, void const *r, int cr)
{
  int back = 0;
  dkwt_group_t const	*pl;
  dkwt_group_t const	*pr;

  pl = (dkwt_group_t const *)l; pr = (dkwt_group_t const *)r;
  if(l) {
    if(r) {
      switch(cr) {
        case 1: {
	  if(pl->groupname) {
	    back = dk3str_casecmp(pl->groupname, (dkChar const *)r);
	  } else { back = -1; }
	} break;
	default: {
	  if(pl->groupname) {
	    if(pr->groupname) {
	      back = dk3str_casecmp(pl->groupname, pr->groupname);
	    } else { back = 1; }
	  } else {
	    if(pr->groupname) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



/**	Change a dynamically allocated text.
	@param	destination	Pointer to string pointer.
	@param	source		Source text.
	@param	app		Application structure for diagnostics.
	@param	returnValue	Pointer to result variable.
*/
static
void
dkwt_tool_save_text(
  dkChar const	**destination,
  dkChar const	 *source,
  dk3_app_t	 *app,
  int		 *returnValue
)
{
  dkChar	*np;
  

#line 135 "dkwt-to.ctr"
  if(source) {				

#line 136 "dkwt-to.ctr"
    if(dk3str_len(source) > 0) {	

#line 137 "dkwt-to.ctr"
      np = dk3str_dup_app(source, app);
      if(np) {				

#line 139 "dkwt-to.ctr"
        if(*destination) {
	  dk3_delete(*destination);
	}
	*destination = np;		

#line 143 "dkwt-to.ctr"
      } else {
        if(returnValue) {
	  *returnValue = 0;
	}
      }
    }
  } 

#line 150 "dkwt-to.ctr"
}




void
dkwt_tool_close_account(dkwt_account_t *ap)
{
  if(ap) {
    dk3_release(ap->textsid);
    dk3_release(ap->profile);
    dk3_release(ap->homedir);
    dk3_release(ap->usrcomment);
    dk3_release(ap->comment);
    dk3_release(ap->fullname);
    dk3_release(ap->logname);
    dk3_delete(ap);
  }
}



dkwt_account_t *
dkwt_tool_open_account(dkChar const *logname, dk3_app_t *app)
{
  dkwt_account_t *back = NULL;
  if(logname) {
    back = dk3_new_app(dkwt_account_t,1,app);
    if(back) {
      back->logname = NULL; back->fullname = NULL;
      back->comment = NULL; back->textsid = NULL;
      back->usrcomment = NULL; back->homedir = NULL;
      back->profile = NULL; back->f_long = 0;
      back->logname  = dk3str_dup_app(logname, app);
      back->priv = (DWORD)0UL;
      back->flags = (DWORD)0UL;
      back->a_flags = (DWORD)0UL;
      back->coco = (DWORD)0UL;
      back->codepage = (DWORD)0UL;
      if(!(back->logname)) {
        dkwt_tool_close_account(back); back = NULL;
      }
    }
  }
  return back;
}



void
dkwt_tool_close_account_list(dkwt_account_list_t *lp)
{
  dkwt_account_t	*ap;
  if(lp) {
    if(lp->s_acc) {
      if(lp->i_acc) {
        dk3sto_it_reset(lp->i_acc);
	while((ap = (dkwt_account_t *)dk3sto_it_next(lp->i_acc)) != NULL) {
	  dkwt_tool_close_account(ap);
	}
        dk3sto_it_close(lp->i_acc);
      }
      dk3sto_close(lp->s_acc);
    }
    lp->s_acc = NULL;
    lp->i_acc = NULL;
    dk3_delete(lp);
  }
}



dkwt_account_list_t *
dkwt_tool_open_account_list(dk3_app_t *app, int f_long)
{
  dkwt_account_list_t	*back = NULL;
  dkwt_account_t	*ap = NULL;
  int			 ok = 0;
  NET_API_STATUS	 nStatus;
  LPUSER_INFO_0		 pBuf = NULL;
  LPUSER_INFO_0		 pTmpBuf = NULL;
  LPUSER_INFO_4		 pb4 = NULL;
  DWORD			 dwLevel = 0;
  DWORD			 dwEntriesRead = 0;
  DWORD			 dwTotalEntries = 0;
  DWORD			 dwResumeHandle = 0;
  DWORD			 dwPreferredLength = MAX_PREFERRED_LENGTH;
  DWORD			 dwFilter = 0; /* FILTER_NORMAL_ACCOUNT */
  DWORD			 i = 0;
  LPTSTR		 pStringSid;
  

#line 241 "dkwt-to.ctr"
  back = dk3_new_app(dkwt_account_list_t,1,app);
  if(back) {				

#line 243 "dkwt-to.ctr"
    back->s_acc = NULL; back->i_acc = NULL;
    back->s_acc = dk3sto_open_app(app);
    if(back->s_acc) {			

#line 246 "dkwt-to.ctr"
      dk3sto_set_comp(back->s_acc, dkwt_tool_compare_accounts, 0);
      back->i_acc = dk3sto_it_open(back->s_acc);
      if(back->i_acc) {			

#line 249 "dkwt-to.ctr"
        ok = 1;
        do {
	  pBuf = NULL;
	  dwEntriesRead = 0;
	  nStatus = NetUserEnum(
	    NULL,			/* Local machine */
	    dwLevel,			/* Level 0 */
	    dwFilter,			/* Normal users */
	    (LPBYTE *)(&pBuf),		/* Destination */
	    dwPreferredLength,		/* Preferred length */
	    &dwEntriesRead,
	    &dwTotalEntries,
	    &dwResumeHandle
	  );	

#line 263 "dkwt-to.ctr"
	  if((NERR_Success == nStatus) || (ERROR_MORE_DATA == nStatus)) {
	    

#line 265 "dkwt-to.ctr"
	    if(pBuf != NULL) {	

#line 266 "dkwt-to.ctr"
	      pTmpBuf = pBuf;
	      for(i = 0; i < dwEntriesRead; i++) {
	        

#line 269 "dkwt-to.ctr"
	        if(pTmpBuf->usri0_name) {	

#line 270 "dkwt-to.ctr"
		  ap = dkwt_tool_open_account(pTmpBuf->usri0_name, app);
		  if(ap) {			

#line 272 "dkwt-to.ctr"
		    if(!dk3sto_add(back->s_acc, (void *)ap)) {
		      ok = 0;
		      dkwt_tool_close_account(ap);
		    }
		  } else {		

#line 277 "dkwt-to.ctr"
		    ok = 0;
		  }
		} else {		

#line 280 "dkwt-to.ctr"
		}
	        pTmpBuf++;
	      }
	    } else {			

#line 284 "dkwt-to.ctr"
	    }
	  } else {			

#line 286 "dkwt-to.ctr"
	  }
	  if(pBuf != NULL) {
	    NetApiBufferFree(pBuf);
	    pBuf = NULL;
	  }
	} while(ERROR_MORE_DATA == nStatus);
	if(pBuf != NULL) {
	  NetApiBufferFree(pBuf);
	}
	if(ok) {
	  if(f_long) {
	  dk3sto_it_reset(back->i_acc);
	  while((ap = (dkwt_account_t *)dk3sto_it_next(back->i_acc)) != NULL) {
	    pb4 = NULL;
	    nStatus = NetUserGetInfo(NULL, ap->logname, (DWORD)4, (LPBYTE *)(&pb4));
	    if(NERR_Success == nStatus)
	    {
	      if(pb4) {	

#line 304 "dkwt-to.ctr"
	        ap->f_long = 1;
		ap->priv = pb4->usri4_priv;
		ap->flags = pb4->usri4_flags;
		ap->a_flags = pb4->usri4_auth_flags;
		ap->coco = pb4->usri4_country_code;
		ap->codepage = pb4->usri4_code_page;
	        if(pb4->usri4_full_name) {	

#line 311 "dkwt-to.ctr"
		  ap->fullname = dk3str_dup_app(pb4->usri4_full_name, app);
		  if(!(ap->fullname)) {
		    ok = 0;
		  }
		}
		if(pb4->usri4_comment) {	

#line 317 "dkwt-to.ctr"
		  ap->comment = dk3str_dup_app(pb4->usri4_comment, app);
		  if(!(ap->comment)) {
		    ok = 0;
		  }
		}
		if(pb4->usri4_usr_comment) {
		  ap->usrcomment = dk3str_dup_app(pb4->usri4_usr_comment, app);
		  if(!(ap->usrcomment)) {
		    ok = 0;
		  }
		}
		if(pb4->usri4_home_dir) {
		  ap->homedir = dk3str_dup_app(pb4->usri4_home_dir, app);
		  if(!(ap->homedir)) {
		    ok = 0;
		  }
		}
		if(pb4->usri4_profile) {
		  ap->profile = dk3str_dup_app(pb4->usri4_profile, app);
		  if(!(ap->profile)) {
		    ok = 0;
		  }
		}
		if(pb4->usri4_user_sid) {	

#line 341 "dkwt-to.ctr"
		  pStringSid = NULL;
		  if(ConvertSidToStringSid(pb4->usri4_user_sid, &pStringSid))
		  {
		    if(pStringSid) {
		      ap->textsid = dk3str_dup_app(pStringSid, app);
		      if(!(ap->textsid)) {
		        ok = 0;
		      }
		    }
		  }
		  if(pStringSid) { LocalFree(pStringSid); }
		  
		}
	      } else {		

#line 355 "dkwt-to.ctr"
	      }
	    } else {		

#line 357 "dkwt-to.ctr"
	    }
	    if(pb4) {
	      NetApiBufferFree(pb4);
	    }
	  }
	  }
	}
      } else {			

#line 365 "dkwt-to.ctr"
      }
    } else {			

#line 367 "dkwt-to.ctr"
    }
    if(!ok) {
      dkwt_tool_close_account_list(back); back = NULL;
    }
  } else {			

#line 372 "dkwt-to.ctr"
  } 

#line 373 "dkwt-to.ctr"
  return back;
}



void
dkwt_tool_reset_account_list(dkwt_account_list_t *lp)
{
  if(lp) {
    if(lp->i_acc) {
      dk3sto_it_reset(lp->i_acc);
    }
  }
}



dkwt_account_t *
dkwt_tool_get_account_from_list(dkwt_account_list_t *lp)
{
  dkwt_account_t *back = NULL;
  if(lp) {
    if(lp->i_acc) {
      back = (dkwt_account_t *)dk3sto_it_next(lp->i_acc);
    }
  }
  return back;
}



/**	Compare two group entries.
	@param	l	Left entry.
	@param	r	Right entry.
	@param	cr	Comparison criteria (0=data/data, 1=data/name).
	@return	Comparison result.
*/
static
int
dkwt_group_compare(void *l, void *r, int cr)
{
  int back = 0;
  dkwt_group_t	*pl;
  dkwt_group_t	*pr;

  pl = (dkwt_group_t *)l; pr = (dkwt_group_t *)r;
  if(l) {
    if(r) {
      switch(cr) {
        case 1: {
	  if(pl->groupname) {
	    back = dk3str_casecmp(pl->groupname, (dkChar const *)r);
	  } else {
	    back = -1;
	  }
	} break;
	default: {
	  if(pl->groupname) {
	    if(pr->groupname) {
	      back = dk3str_casecmp(pl->groupname, pr->groupname);
	    } else back = 1;
	  } else {
	    if(pr->groupname) back = -1;
	  }
	} break;
      }
    } else back = 1;
  } else {
    if(r) back = -1;
  }
  return back;
}




/**	Close group structure, release memory.
	@param	gp	Group structure to close.
*/
static
void
dkwt_tool_close_group(dkwt_group_t *gp)
{
  if(gp) {
    dk3_release(gp->groupname);
    dk3_release(gp->comment);
    dk3_release(gp->textsid);
    gp->attributes = (DWORD)0UL;
    dk3_delete(gp);
  }
}



/**	Open new group structure, allocate memory.
	@param	gn	Group name.
	@param	app	Application structure for diagnostics.
	@return	Pointer on success, NULL on error.
*/
static
dkwt_group_t *
dkwt_tool_open_group(dkChar const *gn, dk3_app_t *app)
{
  dkwt_group_t	*back = NULL;
  back = dk3_new_app(dkwt_group_t,1,app);
  if(back) {
    back->comment = NULL;
    back->textsid = NULL;
    back->attributes = (DWORD)0UL;
    back->groupname = dk3str_dup_app(gn, app);
    if(!(back->groupname)) {
      dkwt_tool_close_group(back); back = NULL;
    }
  }
  return back;
}


void
dkwt_tool_reset_group_list(dkwt_group_list_t *glp)
{
  if(glp) {
    if(glp->i_grp) {
      dk3sto_it_reset(glp->i_grp);
    }
  }
}



dkwt_group_t *
dkwt_tool_get_group_from_list(dkwt_group_list_t *glp)
{
  dkwt_group_t	*back = NULL;
  if(glp) {
    if(glp->i_grp) {
      back = (dkwt_group_t *)dk3sto_it_next(glp->i_grp);
    }
  }
  return back;
}





void
dkwt_tool_close_group_list(dkwt_group_list_t *glp)
{
  dkwt_group_t	*gp;
  if(glp) {
    if(glp->s_grp) {
      if(glp->i_grp) {
        dk3sto_it_reset(glp->i_grp);
	while((gp = (dkwt_group_t *)dk3sto_it_next(glp->i_grp)) != NULL) {
	  dkwt_tool_close_group(gp);
	}
        dk3sto_it_close(glp->i_grp);
      }
      dk3sto_close(glp->s_grp);
    } glp->s_grp = NULL; glp->i_grp = NULL;
    dk3_delete(glp);
  }
}



/**	Destroy group, release memory.
	@param	gp	Group to destroy.
*/
static
void
dkwt_tool_group_close(dkwt_group_t *gp)
{
  if(gp) {
    dk3_release(gp->groupname);
    dk3_release(gp->comment);
    dk3_release(gp->textsid);
    gp->attributes = (DWORD)0UL;
    dk3_delete(gp);
  }
}



/**	Create group, allocate memory.
	@param	gn	Group name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to new group structure on success, NULL on error.
*/
static
dkwt_group_t *
dkwt_tool_group_open(dkChar const *gn, dk3_app_t *app)
{
  dkwt_group_t	*back = NULL;
  if(gn) {
    back = dk3_new_app(dkwt_group_t,1,app);
    if(back) {
      back->comment = NULL;
      back->textsid = NULL;
      back->attributes = (DWORD)0UL;
      back->gtype = DKWT_GROUP_NET;
      back->groupname = dk3str_dup_app(gn,app);
      if(!(back->groupname)) {
        dkwt_tool_group_close(back);
	back = NULL;
      }
    }
  }
  return back;
}



/**	Read group list from system.
	@param	gl	Group list (destination).
	@param	app	Application structure for diagnostics.
	@param	f_long	Flag: Detailed (non-zero) or short (0).
	@return	1 on success, 0 on error.
*/
static
int
dkwt_tool_read_group_list(dkwt_group_list_t *gl, dk3_app_t *app, int f_long)
{
  int			back = 1;
  NET_API_STATUS	nStatus;
  DWORD			dwLevel = 0;
  DWORD			dwPrefmaxlen = MAX_PREFERRED_LENGTH;
  DWORD			dwEntries = 0;
  DWORD			dwTotal = 0;
  DWORD_PTR		dwResumeHandle = 0;
  DWORD			i;
  LPBYTE		pBuf;
  GROUP_INFO_0		*grptr;
  GROUP_INFO_3		*gr3ptr;
  LOCALGROUP_INFO_0	*lgrptr;
  LOCALGROUP_INFO_1	*lgr1ptr;
  dkwt_group_t		*newgroup;
  LPTSTR		stringsid;
  

#line 613 "dkwt-to.ctr"
  /*
	Group information for network groups
  */
  do {
    pBuf = NULL;
    dwEntries = 0;
    nStatus = NetGroupEnum(
      NULL,
      dwLevel,
      &pBuf,
      dwPrefmaxlen,
      &dwEntries,
      &dwTotal,
      &dwResumeHandle
    );
    if((ERROR_MORE_DATA == nStatus) || (NERR_Success == nStatus)) {
      if(pBuf) {	

#line 630 "dkwt-to.ctr"
        grptr = (GROUP_INFO_0 *)pBuf;
	for(i = 0; i < dwEntries; i++) {
	  if(grptr->grpi0_name) {	

#line 633 "dkwt-to.ctr"
	    newgroup = dkwt_tool_group_open(grptr->grpi0_name, app);
	    if(newgroup) {
	      if(!dk3sto_add(gl->s_grp, newgroup)) {
	        back = 0;
		dkwt_tool_group_close(newgroup);
	      }
	    } else {
	      back = 0;
	    }
	  }
	  grptr++;
	}
      }
    }
    if(pBuf) {
      NetApiBufferFree(pBuf); pBuf = NULL;
    }
  } while(ERROR_MORE_DATA == nStatus);
  /*
	Group information for local groups.
  */
  dwLevel = (DWORD)0;
  dwResumeHandle = 0;
  do {
    pBuf = NULL;
    dwEntries = (DWORD)0UL;
    nStatus = NetLocalGroupEnum(
      NULL,
      dwLevel,
      &pBuf,
      dwPrefmaxlen,
      &dwEntries,
      &dwTotal,
      &dwResumeHandle
    );
    if((ERROR_MORE_DATA == nStatus) || (NERR_Success == nStatus)) {
      if(pBuf) {
        lgrptr = (LOCALGROUP_INFO_0 *)pBuf;
	for(i = 0; i < dwEntries; i++) {
	  if(lgrptr->lgrpi0_name) {
	    newgroup = dkwt_tool_group_open(lgrptr->lgrpi0_name, app);
	    if(newgroup) {
	      newgroup->gtype = DKWT_GROUP_LOCAL;
	      if(!dk3sto_add(gl->s_grp, newgroup)) {
	        back = 0;
		dkwt_tool_group_close(newgroup);
	      }
	    } else {
	      back = 0;
	    }
	  }
	  lgrptr ++;
	}
      }
    }
    if(pBuf) {
      NetApiBufferFree(pBuf); pBuf = NULL;
    }
  } while(ERROR_MORE_DATA == nStatus);
  if(f_long) {
    if(back) {
      dk3sto_it_reset(gl->i_grp);
      while((newgroup = (dkwt_group_t *)dk3sto_it_next(gl->i_grp)) != NULL) {
        pBuf = NULL;	

#line 697 "dkwt-to.ctr"
	if(newgroup->gtype == DKWT_GROUP_LOCAL) {	

#line 698 "dkwt-to.ctr"
	  dwLevel = 1;
	  pBuf = NULL;
	  nStatus = NetLocalGroupGetInfo(
	    NULL,
	    newgroup->groupname,
	    dwLevel,
	    &pBuf
	  );
	  if(NERR_Success == nStatus) {			

#line 707 "dkwt-to.ctr"
	    if(pBuf) {
	      lgr1ptr = (LOCALGROUP_INFO_1 *)pBuf;
	      if(lgr1ptr->lgrpi1_comment) {
	        newgroup->comment = dk3str_dup_app(lgr1ptr->lgrpi1_comment, app);
		if(!(newgroup->comment)) {
		  back = 0;
		}
	      }
	    }
	  } else {
	    back = 0;
	  }
	  if(pBuf) {
	    NetApiBufferFree(pBuf); pBuf = NULL;
	  }
	} else {				

#line 723 "dkwt-to.ctr"
	  dwLevel = 3;
	  pBuf = NULL;
          nStatus = NetGroupGetInfo(
            NULL,
	    newgroup->groupname,
	    dwLevel,
	    &pBuf
          );
          if(NERR_Success == nStatus) {		

#line 732 "dkwt-to.ctr"
            if(pBuf) {
	      gr3ptr = (GROUP_INFO_3 *)pBuf;
	      if(gr3ptr->grpi3_comment) {
	        newgroup->comment = dk3str_dup_app(gr3ptr->grpi3_comment, app);
	        if(!(newgroup->comment)) { back = 0; }
	      }
	      if(gr3ptr->grpi3_group_sid) {
	        stringsid = NULL;
	        if(ConvertSidToStringSid(gr3ptr->grpi3_group_sid, &stringsid)) {
	          if(stringsid) {
		    newgroup->textsid = dk3str_dup_app(stringsid, app);
		    if(!(newgroup->textsid)) { back = 0; }
		  }
	        }
	        if(stringsid) { LocalFree(stringsid); }
	      }
	      newgroup->attributes = gr3ptr->grpi3_attributes;
	    }
          } else {
            back = 0;
          }
	  if(pBuf) {
	    NetApiBufferFree(pBuf); pBuf = NULL;
	  }
	}
      }
    }
  } 

#line 760 "dkwt-to.ctr"
  return back;
}



dkwt_group_list_t *
dkwt_tool_open_group_list(dk3_app_t *app, int f_long)
{
  dkwt_group_list_t	*back = NULL;
  int			 ok = 0;
  

#line 771 "dkwt-to.ctr"
  back = dk3_new_app(dkwt_group_list_t,1,app);
  if(back) {
    back->i_grp = NULL;
    back->s_grp = dk3sto_open_app(app);
    if(back->s_grp) {
      dk3sto_set_comp(back->s_grp, dkwt_tool_compare_groups, 0);
      back->i_grp = dk3sto_it_open(back->s_grp);
      if(back->i_grp) {
        ok = dkwt_tool_read_group_list(back, app, f_long);
      }
    }
    if(!(ok)) {
      dkwt_tool_close_group_list(back); back = NULL;
    }
  } 

#line 786 "dkwt-to.ctr"
  return back;
}



/**	Compare printer entries.
	@param	l	Left printer.
	@param	r	Right printer.
	@param	cr	Comparison criteria
	(1=structure/name, other=structure/structure).
	@return	Comparison result.
*/
static
int
dkwt_to_compare_printers(void const *l, void const *r, int cr)
{
  int back = 0;
  dkwt_printer_t const	*pl;
  dkwt_printer_t const	*pr;
  pl = (dkwt_printer_t *)l; pr = (dkwt_printer_t *)r;

  if(l) {
    if(r) {
      switch(cr) { 
        case 1: {
	  if(pl->printerName) {
	    back = dk3str_casecmp(pl->printerName, (dkChar const *)r);
	  } else back = -1;
	} break;
	default: {
	  if(pl->printerName) {
	    if(pr->printerName) {
	      back = dk3str_casecmp(pl->printerName, pr->printerName);
	    } else { back = 1; }
	  } else {
	    if(pr->printerName) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  if(back >  1) back =  1;
  if(back < -1) back = -1;
  return back;
}



/**	Delete printer structure, release memory.
	@param	pr	Structure to delete.
*/
static
void
dkwt_tool_printer_delete(dkwt_printer_t *pr)
{
  if(pr) {
    dk3_release(pr->printerName);
    dk3_release(pr->comment);
    dk3_release(pr->location);
    dk3_release(pr->serverName);
    dk3_release(pr->shareName);
    dk3_release(pr->portName);
    dk3_release(pr->driverName);
    dk3_release(pr->deviceName);
    dk3_release(pr->separatorFile);
    dk3_release(pr->printProcessor);
    dk3_release(pr->dataType);
    dk3_release(pr->parameters);
    dk3_release(pr->description);
    pr->attributes = pr->status = pr->nJobs = (DWORD)0UL;
    dk3_delete(pr);
  }
}



/**	Create printer structure, allocate memory.
	@param	pn	Printer name.
	@param	app	Application structure for diagnostics.
	@return	Pointer to new structure on success, NULL on error.
*/
static
dkwt_printer_t *
dkwt_tool_printer_new(dkChar const *pn, dk3_app_t *app)
{
  dkwt_printer_t	*back = NULL;
  back = dk3_new_app(dkwt_printer_t,1,app);
  if(back) {
    back->description = NULL;
    back->comment = NULL;
    back->location = NULL;
    back->serverName = NULL;
    back->shareName = NULL;
    back->portName = NULL;
    back->driverName = NULL;
    back->deviceName = NULL;
    back->separatorFile = NULL;
    back->printProcessor = NULL;
    back->dataType = NULL;
    back->parameters = NULL;
    back->attributes = back->status = back->nJobs = (DWORD)0UL;
    back->printerName = dk3str_dup_app(pn, app);
    if(!(back->printerName)) {
      dkwt_tool_printer_delete(back); back = NULL;
    }
  }
  return back;
}



void
dkwt_tool_close_printer_list(dkwt_printer_list_t *pl)
{
  dkwt_printer_t *pr;

  if(pl) {
    if(pl->s_prn) {
      if(pl->i_prn) {
        dk3sto_it_reset(pl->i_prn);
	while((pr = (dkwt_printer_t *)dk3sto_it_next(pl->i_prn)) != NULL) {
	  dkwt_tool_printer_delete(pr);
	}
        dk3sto_it_close(pl->i_prn);
      } pl->i_prn = NULL;
      dk3sto_close(pl->s_prn);
    } pl->s_prn = NULL;
    dk3_delete(pl);
  }
}



/**	Read printer list from system.
	@param	pl	Printer list (destination).
	@param	app	Application structure for diagnostics.
	@param	f_long	Flag: Detailed (non-zero) or short (0).
	@return	1 on success, 0 on error.
*/
static
int
dkwt_tool_read_printer_list(
  dkwt_printer_list_t *pl,
  dk3_app_t *app,
  int f_long
)
{
  int 			back = 0;
  char			*peb = NULL;
  DWORD			szpeb;
  DWORD			cbNeeded;
  DWORD			cbReturned;
  DWORD			i;
  PRINTER_INFO_2	*pi2;
  dkwt_printer_t	*pr;
  cbNeeded = (DWORD)0UL;
  cbReturned = (DWORD)0UL;
  

#line 946 "dkwt-to.ctr"
  EnumPrinters(
    PRINTER_ENUM_LOCAL, NULL, 2, NULL, 0, &cbNeeded, &cbReturned
  );
  if(cbNeeded > 0) {
    peb = dk3_new_app(char,(size_t)cbNeeded,app);
    if(peb) {
      szpeb = cbNeeded;
      cbNeeded = (DWORD)0UL;
      cbReturned = (DWORD)0UL;
      if(EnumPrinters(
        PRINTER_ENUM_LOCAL, NULL, 2, (LPBYTE)peb, szpeb, &cbNeeded, &cbReturned
         )
        )
      {
        if(cbReturned > (DWORD)0UL) {
	  pi2 = (PRINTER_INFO_2 *)peb;
	  back = 1;
	  for(i = 0; i < cbReturned; i++) {
	    if(pi2->pPrinterName) {	

#line 965 "dkwt-to.ctr"
	      pr = dkwt_tool_printer_new(pi2->pPrinterName, app);
	      if(pr) {			

#line 967 "dkwt-to.ctr"
	        if(dk3sto_add(pl->s_prn, (void *)pr)) {	

#line 968 "dkwt-to.ctr"
		  if(f_long) {		

#line 969 "dkwt-to.ctr"
		    dkwt_tool_save_text(
		      &(pr->comment),
		      pi2->pComment,
		      app,
		      &back
		    );
		    dkwt_tool_save_text(
		      &(pr->location),
		      pi2->pLocation,
		      app,
		      &back
		    );
		    dkwt_tool_save_text(
		      &(pr->serverName),
		      pi2->pServerName,
		      app,
		      &back
		    );
		    dkwt_tool_save_text(
		      &(pr->shareName),
		      pi2->pShareName,
		      app,
		      &back
		    );
		    dkwt_tool_save_text(
		      &(pr->portName),
		      pi2->pPortName,
		      app,
		      &back
		    );
		    dkwt_tool_save_text(
		      &(pr->driverName),
		      pi2->pDriverName,
		      app,
		      &back
		    );
#if 0
		    dkwt_tool_save_text(
		      &(pr->deviceName),
		      pi2->pDeviceName,
		      app,
		      &back
		    );
#endif
		    dkwt_tool_save_text(
		      &(pr->separatorFile),
		      pi2->pSepFile,
		      app,
		      &back
		    );
		    dkwt_tool_save_text(
		      &(pr->printProcessor),
		      pi2->pPrintProcessor,
		      app,
		      &back
		    );
		    dkwt_tool_save_text(
		      &(pr->dataType),
		      pi2->pDatatype,
		      app,
		      &back
		    );
		    dkwt_tool_save_text(
		      &(pr->parameters),
		      pi2->pParameters,
		      app,
		      &back
		    );
		    pr->attributes = pi2->Attributes;
		    pr->status = pi2->Status;
		    pr->nJobs = pi2->cJobs;
		  } else {	

#line 1041 "dkwt-to.ctr"
		  }
		} else {
		  dkwt_tool_printer_delete(pr);
		  back = 0;
		}
	      } else {
	        back = 0;
	      }
	    }
	    pi2++;
	  }
	}
      }
      dk3_delete(peb);
    }
  } else {
    /* ERROR: Failed to obtain byte number. */
    dk3app_log_i1(app, DK3_LL_ERROR, 244);
  } 

#line 1060 "dkwt-to.ctr"
  return back;
}



dkwt_printer_list_t *
dkwt_tool_open_printer_list(dk3_app_t *app, int f_long)
{
  dkwt_printer_list_t	*back = NULL;
  back = dk3_new_app(dkwt_printer_list_t,1,app);
  if(back) {
    back->i_prn = NULL;
    back->s_prn = dk3sto_open_app(app);
    if(back->s_prn) {
      dk3sto_set_comp(back->s_prn, dkwt_to_compare_printers, 0);
      back->i_prn = dk3sto_it_open(back->s_prn);
    }
    if((back->s_prn) && (back->i_prn)) {
      if(!dkwt_tool_read_printer_list(back, app, f_long)) {
        dkwt_tool_close_printer_list(back); back = NULL;
      }
    } else {
      dkwt_tool_close_printer_list(back); back = NULL;
    }
  }
  return back;
}


void
dkwt_tool_printer_list_reset(dkwt_printer_list_t *pl)
{
  if(pl) {
    if(pl->i_prn) {
      dk3sto_it_reset(pl->i_prn);
    }
  }
}



dkwt_printer_t *
dkwt_tool_printer_list_next(dkwt_printer_list_t *pl)
{
  dkwt_printer_t *back = NULL;
  if(pl) {
    if(pl->i_prn) {
      back = (dkwt_printer_t *)dk3sto_it_next(pl->i_prn);
    }
  }
  return back;
}



long
dkwt_tool_reg_open_key(
  HKEY		 key,
  dkChar const	*skn,
  REGSAM	 sam,
  PHKEY		 phk
)
{
  long		res;
  DWORD		dw0;

  dw0 = (DWORD)0;
#if DK3_CHAR_SIZE > 1
  res = RegOpenKeyExW(key, skn, dw0, sam, phk);
#else
  res = RegOpenKeyExA(key, skn, dw0, sam, phk);
#endif
  return res;
}



long
dkwt_tool_reg_query_value(
  HKEY			 hk,
  dkChar const		*vn,
  DWORD			*pDwTp,
  void			*buf,
  DWORD			*pDwSz
)
{
  long			 res;
#if DK3_CHAR_SIZE > 1
  res = RegQueryValueExW(
    hk, vn, NULL, pDwTp, (LPBYTE)buf, pDwSz
  );
#else
  res = RegQueryValueExA(
    hk, vn, NULL, pDwTp, (LPBYTE)buf, pDwSz
  );
#endif
  return res;
}



long
dkwt_tool_reg_delete_value(
  HKEY		 hk,
  dkChar const	*en
)
{
  long res;
#if DK3_CHAR_SIZE > 1
  res = RegDeleteValueW(hk, en);
#else
  res = RegDeleteValueA(hk, en);
#endif
  return res;
}



long
dkwt_tool_reg_delete_tree(
  HKEY		 hk,
  dkChar const	*tn
)
{
  long res;
#if DK3_CHAR_SIZE > 1
  res = RegDeleteTreeW(hk, tn);
#else
  res = RegDeleteTreeA(hk, tn);
#endif
  return res;
}


long
dkwt_tool_reg_enum_key(
  HKEY			 hk,
  DWORD			 dwIndex,
  dkChar		*pResult,
  DWORD			*pDwSzResult,
  dkChar		*pClass,
  DWORD			*pDwSzClass,
  PFILETIME		 pLastWrite
)
{
  long res;
  

#line 1207 "dkwt-to.ctr"
#if DK3_CHAR_SIZE > 1
  res = RegEnumKeyExW(
    hk, dwIndex, pResult, pDwSzResult,
    NULL, pClass, pDwSzClass, pLastWrite
  );
#else
  res = RegEnumKeyExA(
    hk, dwIndex, pResult, pDwSzResult,
    NULL, pClass, pDwSzClass, pLastWrite
  );
#endif
  

#line 1219 "dkwt-to.ctr"
  return res;
}



long
dkwt_tool_reg_create_key(
  HKEY		 hk,
  dkChar const	*kn,
  DWORD		 dwOptions,
  REGSAM	 sam,
  PHKEY		 pHkeyResult,
  LPDWORD	 lpDwDisposition
)
{
  long res;
  DWORD	dw0;

  dw0 = 0;
#if DK3_CHAR_SIZE > 1
  res = RegCreateKeyExW(
    hk, kn, dw0, NULL, dwOptions, sam,
    NULL, pHkeyResult, lpDwDisposition
  );
#else
  res = RegCreateKeyExA(
    hk, kn, dw0, NULL, dwOptions, sam,
    NULL, pHkeyResult, lpDwDisposition
  );
#endif
  return res;
}


long
dkwt_ev_reg_set_value(
  HKEY		 hk,
  dkChar const	*vn,
  DWORD		 dwType,
  void		*pData,
  DWORD		 szData
)
{
  long	res;
  DWORD dw0;

  dw0 = 0;
#if DK3_CHAR_SIZE > 1
  res = RegSetValueExW(
    hk, vn, dw0, dwType, (BYTE const *)pData, szData
  );
#else
  res = RegSetValueExA(
    hk, vn, dw0, dwType, (BYTE const *)pData, szData
  );
#endif
  return res;
}

