/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dkwt-gr.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dkwt-gr.c The dkwt-gr module.
*/


#line 10 "dkwt-gr.ctr"

#include "dk3all.h"
#include "dkt.h"
#include "dkwt.h"





#line 18 "dkwt-gr.ctr"



/**	Job structure for dkwt groups.
*/
typedef struct {
  dk3_app_t		*app;		/**< Application structure. */
  dkChar const * const	*msg;		/**< Localized message texts. */
  dkChar const * const	*kwnl;		/**< Keywords, not localized. */
  dk3_option_set_t	*opt;		/**< Options set. */
  int			 f_long;	/**< Flag: Long user listing. */
  int			 exval;		/**< Exit status code. */
} DKWT_GRP_J;



/**	Data for the option set.
*/
static dk3_option_t const dkwt_groups_options[] = {
  { dkT('l'), dkT("long"), 0 },
  { dkT('s'), dkT("short"), 0 }
};

/**	Number of options in the dkt_sort_options array.
*/
static size_t const dkwt_groups_szoptions =
sizeof(dkwt_groups_options)/sizeof(dk3_option_t);



/**	Initialize job structure.
	@param	j	Job structure.
*/
static
void
dkwt_groups_job_init(DKWT_GRP_J *j)
{
  j->app = NULL; j->msg = NULL; j->kwnl = NULL; j->opt = NULL;
  j->f_long = 1; j->exval = DKT_RESULT_ERR_UNSPECIFIC;
}




/**	Clean up job structure after use.
	@param	j	Job structure.
*/
static
void
dkwt_groups_job_cleanup(DKWT_GRP_J *j)
{
  if(j->opt) {
    dk3opt_close(j->opt);
  } j->opt = NULL;
}



/**	Process command line arguments.
	@param	j	Job structure.
	@return	1 on success (can continue), 0 on error.
*/
static
int
dkwt_groups_process_argv(DKWT_GRP_J *j)
{
  int back = 0;
  int			 xargc;
  dkChar const * const	*xargv;

  xargc = dk3app_get_argc(j->app);
  xargv = dk3app_get_argv(j->app);
  xargv++; xargv++; xargc--; xargc--;
  j->opt = dk3opt_open_app(
    dkwt_groups_options,
    dkwt_groups_szoptions,
    dkT('\0'),
    NULL,
    xargc,
    xargv,
    j->app
  );
  if(j->opt) {
    if(0 == dk3opt_get_error_code(j->opt)) {
      back = 1;
      if(dk3opt_is_set(j->opt, dkT('l'))) {
        j->f_long = 2;
	if(dk3opt_is_set(j->opt, dkT('s'))) {
	  back = 0;
	  /* ERROR: -l and -s are exclusive */
	  dk3app_log_1(j->app, DK3_LL_ERROR, j->msg, 76);
	}
      } else {
        if(dk3opt_is_set(j->opt, dkT('s'))) {
	  j->f_long = 0;
	}
      }
      if(dk3opt_get_num_args(j->opt) > 0) {
        /* Warning: Arguments ignored. */
	dk3app_log_1(j->app, DK3_LL_ERROR, j->msg, 76);
      }
    }
  }
  return back;
}



/**	Run the "list groups" operation.
	@param	j	Job structure.
*/
static
void
dkwt_groups_run(DKWT_GRP_J *j)
{
  dkwt_group_list_t	*gl;
  dkwt_group_t		*gp;
  int			 is_first = 1;
  dkChar const		*ptr;

  gl = dkwt_tool_open_group_list(j->app, j->f_long);
  if(gl) {
    dkwt_tool_reset_group_list(gl);
    dk3sf_initialize_stdout();
    while((gp = (dkwt_group_t *)dk3sto_it_next(gl->i_grp)) != NULL) {
      if(gp->groupname) {
        if((j->f_long) && (!(is_first))) {
	  dk3sf_fputc(dkT('\n'), stdout);
	} is_first = 0;
        dk3sf_fputs(gp->groupname, stdout);
	dk3sf_fputc(dkT('\n'), stdout);
	if(j->f_long) {
	  ptr = gp->groupname;
	  while(*(ptr++)) { dk3sf_fputc(dkT('-'), stdout); }
	  dk3sf_fputc(dkT('\n'), stdout);
	  dk3sf_fputs((j->msg)[39], stdout);
	  dk3sf_fputs((j->msg)[(gp->gtype) ? 42 : 41], stdout);
	  dk3sf_fputc(dkT('\n'), stdout);
	  if(gp->comment) {
	    dk3sf_fputs((j->msg)[40], stdout);
	    dk3sf_fputs(gp->comment, stdout);
	    dk3sf_fputc(dkT('\n'), stdout);
	  }
	  if(gp->textsid) {
	    dk3sf_fputs((j->msg)[43], stdout);
	    dk3sf_fputs(gp->textsid, stdout);
	    dk3sf_fputc(dkT('\n'), stdout);
	  }
	}
      }
    }
    dkwt_tool_close_group_list(gl);
  }
}



int
dkwt_groups(
  dk3_app_t		*app,
  dkChar const * const	*msg,
  dkChar const * const	*kwnl
)
{
  int back = DKT_RESULT_ERR_UNSPECIFIC;
  DKWT_GRP_J j;
  dkwt_groups_job_init(&j);
  j.app = app; j.msg = msg; j.kwnl = kwnl;
  if(dkwt_groups_process_argv(&j)) {
    back = j.exval = DKT_RESULT_OK;
    dkwt_groups_run(&j);
  }
  dkwt_groups_job_cleanup(&j);
  return back;
}

