Name:           dktools
Version:        3.17.1
Source:         file:///home/krause/work/dktools-3.17.1.tar.gz
Release:        1%{?dist}
Summary:        Dirk Krause's tools and libraries
Vendor:         Dirk Krause
# Packager:     Dirk Krause
Group:          Applications/System
License:        BSD
URL:            http://dktools.sourceforge.net/index.html
BuildRoot:      %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)

BuildRequires:  community-mysql-devel zlib-devel bzip2-devel libpng-devel openssl-devel libjpeg-devel libtiff-devel net-snmp-devel wxGTK wxGTK-devel
Requires:       bzip2 openssl net-snmp wxGTK
Prefix:         %{_prefix}

%description
A set of tools for graphics conversion, text conversion, software
development, administration and printing and some general-purpose tools.
 bmpp / wxbmpp   Convert PNG/JPEG/TIFF to PS/EPS/PDF
 fig2lat         Convert FIG to PGF,EPS+TeX,PDF+TeX,EPS,SVG
 wximgsz         Suggest good sizes to rescale bitmap images
 htmlbook        Publish HTML like a book
 dkct / wxdkct   Preprocessor for C, C++, Objective-C and Java
                 (debugging/tracing, state machines, wxWidgets GUIs)
 dkwxwiz         Create project skeleton for wxWidgets+dktools based programs
 dkt             Multi-purpose tool:
                 * File and directory listings, column order is configurable
                 * Text conversion to HTML
                 * Text conversion to LaTeX
                 * Text sorting
                 * Text re-encoding
                 * File/directory checksumming and checksum verification
                 * Show file contents in hexadecimal or octal notation
                 * Backup media management
                 * Password suggestion
                 * UID suggestion
                 * Pattern stream to erase disks or partitions
                 * Random data block generation
 dknet           Data transmission from one sender to multiple receivers
 dkdbt           Tool for simple databases
 itadmin         Use a MySQL database to manage your IT
 printqd         Print quota enforcement for LPRng print systems

%prep
%setup -q
# %setup


%build
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc README bsdlic.txt
%{_bindir}/*
%{_datadir}/applications/*
%{_datadir}/dk3app
%{_datadir}/dkt-3
%config %{_sysconfdir}/dk3app/dk3paper.conf



#
# The lib sub-package installes the shared libraries.
#

%package lib
Summary:        Shared libraries from the DK tools project
Group:          Development/Libraries
Requires:       dktools = %{version}-%{release} bzip2 openssl net-snmp wxGTK
Prefix:         %{_prefix}

%description lib
The shared libraries created from the DK tools project.

%post lib
ldconfig

%postun lib
ldconfig

%files lib
%defattr(-,root,root,-)
%{_libdir}/lib*

#
# The devel sub-package installs developer support.
#

%package devel
Summary:        Development files for libraries from the DK tools project
Group:          Development/Libraries
Requires:       dktools-lib = %{version}-%{release} community-mysql-devel zlib-devel bzip2-devel libpng-devel openssl-devel libjpeg-devel libtiff-devel net-snmp-devel gcc wxGTK wxGTK-devel
Prefix:         %{_prefix}

%description devel
If you want to use modules from the DK tools project in your programs,
you need the libraries from the dktools-lib package and the header
files provided by this project.

%files devel
%defattr(-,root,root,-)
%{_includedir}/*

%changelog

* Sat Jun 28 2014 Dirk Krause <devnull@fh-schmalkalden.de> 3.15.0-0.0.1
- Source code reorganized.

* Thu Jun 19 2014 Dirk Krause <devnull@fh-schmalkalden.de> 3.14.0-0.0.1
- Options -S... added to dkct and wxdkct.
- Memory usage reorganized for bit matrices.
- Cache friendly algorithm for bit matrix expansion.
- dktools.spec file modified to build sub-packages lib and devel.

* Mon Jul 29 2013 Dirk Krause <devnull@fh-schmalkalden.de> 3.3.1-0.0.1
- Bugfix in distribution and build system.

* Sun Jul 28 2013 Dirk Krause <devnull@fh-schmalkalden.de> 3.3.0-0.0.1
- API change, comparison and evaluation functions operate on void const *
  pointers.

* Wed Jul 24 2013 Dirk Krause <devnull@fh-schmalkalden.de> 3.2.2-0.0.1
- More useful error message for malformed path to dkt ls on Windows
  (paths in double quotes where backslash escapes closing double quote).

* Thu Mar 20 2013 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.6-0.0.1
- dkct enhanced for unknown classes.

* Wed Mar 20 2013 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.5-0.0.1
- Bugfix: Use AddButton method of wxStdButtonSizer, not Add.

* Sun Mar 17 2013 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.4-0.0.1
- The dk3sock4 module was added.

* Sat Mar 16 2013 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.3-0.0.1
- Online documentation updated for the -f option in dknet.

* Thu Mar 14 2013 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.2-0.0.1
- The dknet program is more verbose now when run as sender.

* Sun Feb 03 2013 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.1-0.0.1
- The dkwxwiz program was added.
- The winprint program (for Windows) was added.
- The wprclean program (for Windows) was added.
- The lprngcl program (for Windows) was added.
- Option bbts for fig2lat.
- Bugfix in Win32 setup: The dk3paper.conf file was not installed.

* Thu Jan 31 2013 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.0-0.0.12
- Code for 3.0.0 release.

* Tue Jan 29 2013 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.0-0.0.11
- All code completed, now preparing for the initial release.

* Sun Jan 20 2013 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.0-0.0.10
- Program fig2lat added, without SVG driver (not finished yet).
- dkwt clp is less noisy now.

* Thu Sep 27 2012 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.0-0.0.9
- New preprocessor directive TRACE_DEBUG added.

* Sun Aug 19 2012 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.0-0.0.8
- Bugfix in wximgsz: Colors now initialized correctly.

* Fri Jul 06 2012 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.0-0.0.7
- Bugfix in dknet: After receiving the first connection attempt the
  program listened on this socket only.

* Thu Jul 05 2012 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.0-0.0.6
- dknet rewritten for IPv6 support, previous version still available as dknet4.

* Thu Jun 14 2012 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.0-0.0.5
- printqd and companions added.

* Wed Nov 02 2011 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.0-0.0.4
- wxT_2() macro for wxCmdLineEntryDesc structures in wxdkct.

* Wed Nov 02 2011 Dirk Krause <devnull@fh-schmalkalden.de> 2.2.22
- Bugfix in the configure script: Unnecessary call to wx-config removed.

* Tue Nov 01 2011 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.0-0.0.3
- dkdbt program completed.

* Tue Nov 01 2011 Dirk Krause <devnull@fh-schmalkalden.de> 2.2.21
- The hostsadm.pl script now adds a netgroup triple containing
  the IP address to the netgroup.ldif file.
- The "ctrl database-cleanup" operation for prqd now removes
  print accounts and page counts with value 0.

* Sun Oct 09 2011 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.0-0.0.2
- dkt program completed.
- dkwt program completed.
- dkct program completed.
- wxdkct program completed.
- GIT repository created.

* Sun Jun 06 2011 Dirk Krause <devnull@fh-schmalkalden.de> 2.2.20
- Program imgsize renamed to chimgsize to avoid name conflicts
  with perl-Image-Size RPM.

* Sun Apr 19 2011 Dirk Krause <devnull@fh-schmalkalden.de> 2.2.19
- Bugfix in text2htm, wrong format specification.

* Sun Mar 06 2011 Dirk Krause <devnull@fh-schmalkalden.de> 3.0.0-0.0.1
- dkt uid was added.

* Sun Nov 14 2010 Dirk Krause <devnull@fh-schmalkalden.de> 2.2.18
- The function dkstr_w_cat() (a fallback implementation for systems without
  the wcscat() function) was added.
- New programs kwintool and kwindown for Windows.

* Tue Oct 26 2010 Dirk Krause <devnull@fh-schmalkalden.de> 2.2.17
- New option ``create accounts automatically'' for prqd. By default
  we avoid to create personal print accounts automatically to keep
  the database small.
- Improvements in the GUI of the PrintLimit application.

* Sun Oct 24 2010 Dirk Krause <devnull@fh-schmalkalden.de> 2.2.16
- New Java application PrintLimit for users of LPRng/prqd to show
  users print quota information.
- The dklibsj.html page was improved. A tutorial and a short reference
  were added.

* Wed Oct 20 2010 Dirk Krause <devnull@fh-schmalkalden.de> 2.2.15
- The LANG environment variable is now tested for both ".UTF-8"
  and ".utf8" to indicate the use of UTF-8 encoding.

* Wed Sep 15 2010 Dirk Krause <devnull@fh-schmalkalden.de> 2.2.14
- Documentation update: Notes about differences in the appearance of
  interpolated splines in Xfig/transfig and fig2vect. Recommendations how
  to modify the sources of Xfig and transfig.

* Tue Sep 14 2010 Dirk Krause <devnull@fh-schmalkalden.de> 2.2.13
- Corrected typographic errors in the DKrause::Diagram documentation.

* Tue Sep 13 2010 Dirk Krause <devnull@fh-schmalkalden.de> 2.2.12
- The *.jar files were missing in the Windows executable setup of
  2.2.11. Here they are back.

