/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dkt.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dkt.h Header file for the dkt module.
*/

#ifndef DKT_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKT_H_INCLUDED 1


#line 10 "dkt.ctr"


#if DK3_HAVE_OPENSSL_RAND_H
#include <openssl/rand.h>
#endif



/**	Handler function to process one configuration line.
	@param	o	Object to modify during processing.
	@param	k	Key found in the line.
	@param	v	Value found in the line or NULL if no value was found.
	@return	1 on success, 0 on error (can continue), -1 on error (abort).
*/
typedef int dkt_conf_fct_t(void *o, dkChar const *k, dkChar const *v);



#ifdef __cplusplus
extern "C" {
#endif

/**	Print current working directory.
	@param	app	Application structure.
	@param	sn	Section name for configuration file.
	@param	msg	Messages.
	@param	kwnl	Keywords, not localized.
	@return	0 on success or other exit code on errors.
*/
int
dkt_cwd(
  dk3_app_t *app,
  dkChar const	       *sn,
  dkChar const * const *msg,
  dkChar const * const *kwnl
);

/**	Sort texts line by line.
	@param	app	Application structure.
	@param	sn	Section name for configuration file.
	@param	msg	Messages.
	@param	kwnl	Keywords, not localized.
	@return	0 on success or other exit code on errors.
*/
int
dkt_sort(
  dk3_app_t *app,
  dkChar const	       *sn,
  dkChar const * const *msg,
  dkChar const * const *kwnl
);

/**	List specified files.
	@param	app	Application structure.
	@param	sn	Section name for configuration file.
	@param	msg	Message texts.
	@param	kwnl	Keywords, not localized.
	@return	Exit status code.
*/
int
dkt_ls(
  dk3_app_t *app,
  dkChar const	       *sn,
  dkChar const * const *msg,
  dkChar const * const *kwnl
);

/**	Read configuration file section.
	@param	app	Application structure.
	@param	sn	Section name.
	@param	obj	Object to store information.
	@param	fct	Function to process key/value pair.
*/
void
dkt_tool_read_conf(
  dk3_app_t *app, dkChar const *sn, void *obj, dkt_conf_fct_t *fct
);

/**	Find encoding.
	@param	app	Application structure.
	@param	enc	Pointer to encoding variable.
	@param	val	Text containing encoding.
	@param	de	Default encoding.
	@return	1 on success, 0 on error.
 */
int
dkt_tool_set_encoding(
  dk3_app_t		*app,
  int			*enc,
  dkChar const		*val,
  int			 de
);

/**	Perform checksum or checksize command.
	@param	app	Application structure.
	@param	sn	Section name for configuration file.
	@param	msg	Localized messages.
	@param	kwnl	Keywords, not localized.
	@param	what	Flag: Run for checksum (0) or checksize (1).
	@return	Exit status code.
*/
int
dkt_check(
  dk3_app_t *app,
  dkChar const	       *sn,
  dkChar const * const *msg,
  dkChar const * const *kwnl,
  int what
);

/**	Run the "uid" sub-command.
	@param	app	Application structure for diagnostics.
	@param	sn	Section name for configuration file.
	@param	msg	Localized messages.
	@param	kwnl	Keywords, not localized.
	@return	Exit status code.
*/
int
dkt_uid(
  dk3_app_t *app,
  dkChar const	       *sn,
  dkChar const * const *msg,
  dkChar const * const *kwnl
);

/**	Run the "tape" sub-command.
	@param	app	Application structure for diagnostics.
	@param	sn	Section name for configuration file.
	@param	msg	Localized messages.
	@param	kwnl	Keywords, not localized.
	@return	Exit status code.
*/
int
dkt_tape(
  dk3_app_t *app,
  dkChar const	       *sn,
  dkChar const * const *msg,
  dkChar const * const *kwnl
);

/**	Run the "tape-report" sub-command.
	@param	app	Application structure for diagnostics.
	@param	sn	Section name for configuration file.
	@param	msg	Localized messages.
	@param	kwnl	Keywords, not localized.
	@return	Exit status code.
*/
int
dkt_tapereport(
  dk3_app_t *app,
  dkChar const	       *sn,
  dkChar const * const *msg,
  dkChar const * const *kwnl
);

/**	Run the "tapeset" sub-command.
	@param	app	Application structure for diagnostics.
	@param	sn	Section name for configuration file.
	@param	msg	Localized messages.
	@param	kwnl	Keywords, not localized.
	@return	Exit status code.
*/
int
dkt_tapeset(
  dk3_app_t *app,
  dkChar const	       *sn,
  dkChar const * const *msg,
  dkChar const * const *kwnl
);

/**	Run the "dkt blocksize" sub-command.
	@param	app	Application structure for diagnostics.
	@param	sn	Section name for configuration file.
	@param	msg	Localized messages.
	@param	kwnl	Keywords, not localized.
	@return	Exit status code.
*/
int
dkt_blocksize(
  dk3_app_t *app,
  dkChar const	       *sn,
  dkChar const * const *msg,
  dkChar const * const *kwnl
);

/**	Run the "dkt hex" sub-command.
	@param	app	Application structure for diagnostics.
	@param	sn	Section name for configuration file.
	@param	msg	Localized messages.
	@param	kwnoloc	Not localized keywords.
	@param	f_oct	Flag: Show contents octal.
	@return	Exit status code.
*/
int
dkt_hex(
  dk3_app_t *app,
  dkChar const	       *sn,
  dkChar const * const *msg,
  dkChar const * const *kwnoloc,
  int			f_oct
);

/**	Create password suggestions.
	@param	app	Application structure.
	@param	sn	Section name for configuration file.
	@param	msg	Localized messages.
	@param	kwnoloc	Keywords, not localized.
	@return	Exit status code.
*/
int
dkt_create_password(
  dk3_app_t *app,
  dkChar const	       *sn,
  dkChar const * const *msg,
  dkChar const * const *kwnoloc
);

/**	Convert standard input, file or cmd argument to LaTeX.
	@param	app	Application structure.
	@param	sn	Section name for configuration file.
	@param	msg	Localized messages.
	@param	kwnoloc	Keywords, not localized.
	@return	Exit status code.
*/
int
dkt_lat(
  dk3_app_t *app,
  dkChar const	       *sn,
  dkChar const * const *msg,
  dkChar const * const *kwnoloc
);

/**	Conversion to HTML (dkt html).
	@param	app	Application structure.
	@param	sn	Section name for configuration file.
	@param	msg	Localized texts.
	@param	kwnl	Keywords, not localized.
*/
int
dkt_html(
  dk3_app_t *app,
  dkChar const		*sn,
  dkChar const * const	*msg,
  dkChar const * const	*kwnl
);

/**	Cat file(s).
	@param	app	Application structure.
	@param	sn	Configuration file section name.
	@param	msg	Localized texts.
	@param	kwnl	Keywords, not localized.
*/
int
dkt_cat(
  dk3_app_t *app,
  dkChar const		*sn,
  dkChar const * const	*msg,
  dkChar const * const	*kwnl
);

/**	Create password.
	@param	app	Application structure.
	@param	sn	Configuration file section name.
	@param	msg	Localized texts.
	@param	kwnl	Keywords, not localized.
*/
int
dkt_crp(
  dk3_app_t *app,
  dkChar const		*sn,
  dkChar const * const	*msg,
  dkChar const * const	*kwnl
);

/**	Show help text file(s).
	@param	app	Application structure.
	@param	sn	Configuration file section name.
	@param	msg	Localized texts.
	@param	kwnl	Keywords, not localized.
	@param	htp	Help topic index.
*/
int
dkt_help(
  dk3_app_t		*app,
  dkChar const		*sn,
  dkChar const * const	*msg,
  dkChar const * const	*kwnl,
  int			 htp
);

/**	Find message digest type and digest encoding.
	@param	jmdt	Pointer to result variable for digest type.
	@param	jmde	Pointer to result variable for digest encoding.
	@param	exval	Pointer to exit status code variable.
	@param	txt	Text to inspect.
	@param	app	Application structure for diagnostics.
	@param	msg	Message array for diagnostics.
	@param	verb	Flag: Verbose.
	@return	1 on success, 0 on error.
*/
int
dkt_tool_set_md_type(
  int *jmdt,
  int *jmde,
  int *exval,
  dkChar const *txt,
  dk3_app_t *app, 
  dkChar const * const *msg,
  int verb
);

/**	Set size_t value from string.
	@param	rp	Pointer to result variable.
	@param	src	String containing the value.
	@param	msg	Localized text messages for diagnostics.
	@param	kwnl	Non-localized keywords for diagnostics.
	@param	app	Application structure for diagnostics.
	@param	exc	Pointer to exit code variable.
	@return	1 on success, 0 on error.
*/
int
dkt_tool_set_size(
  size_t		*rp,
  dkChar const		*src,
  dkChar const * const	*msg,
  dkChar const * const	*kwnl,
  dk3_app_t		*app,
  int			*exc
);

/**	Run the "dkt erase-disk" sub-command.
	@param	app	Application structure for diagnostics.
	@param	sn	Section name for configuration file.
	@param	msg	Localized messages.
	@param	kwnl	Not localized keywords.
	@return	Exit status code.
*/
int
dkt_ed(
  dk3_app_t		*app,
  dkChar const		*sn,
  dkChar const * const	*msg,
  dkChar const * const	*kwnl
);

/**	Run the "dkt random" sub-command.
	@param	app	Application structure for diagnostics.
	@param	sn	Section name for configuration file.
	@param	msg	Localized messages.
	@param	kwnl	Not localized keywords.
	@return	Exit status code.
*/
int
dkt_rnd(
  dk3_app_t		*app,
  dkChar const		*sn,
  dkChar const * const	*msg,
  dkChar const * const	*kwnl
);

#ifdef __cplusplus
}
#endif



/**	@defgroup	dktresult	Exit codes for dkt.	*/
/**@{*/
/**	Result: No error occured.
*/
#define	DKT_RESULT_OK			0

/**	Error: Unspecific error.
*/
#define	DKT_RESULT_ERR_UNSPECIFIC	1

/**	Error: Aborted by signal.
*/
#define	DKT_RESULT_ERR_SIGNAL		2

/**	Error: Illegal/unknown option or problem in configuration file.
*/
#define	DKT_RESULT_ERR_OPTION		3

/**	Error: getcwd() failed.
*/
#define	DKT_RESULT_ERR_GETCWD		4

/**	Error: Memory allocation failed.
*/
#define	DKT_RESULT_ERR_MEMORY		5

/**	Error: Failed to open one of the input files.
*/
#define	DKT_RESULT_ERR_FOPEN		6

/**	Error: No such file.
*/
#define	DKT_RESULT_ERR_FILENAME		7

/**	Error: Checksum or size mismatch.
*/
#define	DKT_RESULT_ERR_MISMATCH		8

/**	Error: Failed to create or write output.
*/
#define	DKT_RESULT_ERR_OUTPUT		9

/**	Error: The PRNG was unable to deliver enough bytes.
*/
#define	DKT_RESULT_ERR_PRNG		10

/**	Error: Invalid input (Input can't be processed).
*/
#define	DKT_RESULT_ERR_INPUT		11

/**	Error: Mathematical overflow.
 */
#define	DKT_RESULT_ERR_MATH_OVERFLOW	12

/**	Error: Failed to open directory.
*/
#define	DKT_RESULT_ERR_OPENDIR		13

/**	Error: Functionality not supported on this system.
*/
#define	DKT_RESULT_ERR_UNSUPPORTED	14

/**	Error: Status code from command execution indicates error.
*/
#define	DKT_RESULT_ERR_SYSEXEC		15
/**@}*/



/**	@defgroup	dktsortcrit	Sort criteria for "dkt sort". */
/**@{*/
/** Sort criteria:	Normal text search.
*/
#define	DKT_SORT_NORMAL		0

/** Sort criteria:	Sort by leading integer.
*/
#define	DKT_SORT_INTEGER	1

/** Sort criteria:	Sort by leading unsigned integer.
*/
#define DKT_SORT_UNSIGNED	2

/** Sort criteria:	Sort by leading double.
*/
#define	DKT_SORT_DOUBLE		3

/** Sort criteria mask.
*/
#define	DKT_SORT_CRITERIA_MASK	7

/** Normalize strings before comparison.
*/
#define	DKT_SORT_NORMALIZE	8

/**	Ignore leading whitespaces.
*/
#define DKT_SORT_IGNORE_LWHS	16

/**	Do exact comparison.
*/
#define	DKT_SORT_EXACT		32

/** Merge equal strings.
*/
#define	DKT_SORT_MERGE		64

/** Invert search order.
*/
#define	DKT_SORT_INVERT		128

/**	Case insensitve comparisons.
*/
#define	DKT_SORT_CASEINS	256

/**	Show lines without value before lines with value.
*/
#define	DKT_SORT_NOVALUE_FIRST	512

/**@}*/



/**	@defgroup	dktsortmerge	Merge criteria for "dkt sort". */
/**@{*/
/**	No line merging.
*/
#define	DKT_SORT_MERGE_NONE	0

/**	Merge lines evaluating equally.
*/
#define	DKT_SORT_MERGE_EQUAL	1

/**	Merge lines exactly equally.
*/
#define	DKT_SORT_MERGE_EXACT	2
/**@}*/

/**	@defgroup	pwclasses	Password classes. */
/**@{*/

/**	Simple password.
*/
#define	DKT_PWCLASS_SIMPLE		0

/**	Hexadecimal characters.
*/
#define	DKT_PWCLASS_HEX			1

/**	ASCII-85 set password.
*/
#define	DKT_PWCLASS_A85			2
/**@}*/

/**	Default line size for the sort component.
*/
#define	DKT_SORT_LINE_SIZE	((size_t)4096U)

/**	Size of builtin buffer for dkt blocksize.
*/
#define	DKT_BLOCKSIZE_OUTPUT_SIZE	((size_t)4096)

/**	Size of builtin buffer for dkt latex.
*/
#define DKT_LATEX_LINE_SIZE	((size_t)4096U)

/**	Line size for dkt html.
*/
#define DKT_HTML_LINE_SIZE	((size_t)4096U)

/**	Size for long options
*/
#define	DKT_LONGOPT_LINE_SIZE	((size_t)256)

/**	Maximum length for password.
*/
#define	DKT_PASSWORD_MAXLENGTH	4096

/**	Line size for dkt tapeset.
*/
#define	DKT_TS_LINE_SIZE	1024

/**	Buffer size for dkt ed.
*/
#define	DKT_ED_BUFFER_SIZE	((size_t)16384U)

/**	Buffer size for dkt random.
*/
#define	DKT_RND_BUFFER_SIZE	((size_t)16384U)

/**	For allocation of string pointer arrays.
*/
typedef	dkChar const	*DKT_PDKCHAR;




#endif
