/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dkt.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dkt.c The dkt module.
*/


#line 573 "dkt.ctr"

#include "dk3all.h"
#include "dkt-version.h"
#include "dkt.h"


#if DK3_HAVE_OPENSSL_MD5_H || DK3_HAVE_OPENSSL_SHA_H || DK3_HAVE_OPENSSL_RIPEMD_H || DK3_HAVE_OPENSSL_RAND_H
#ifdef DK3_SHOW_OPENSSL_LICENSE
#undef DK3_SHOW_OPENSSL_LICENSE
#endif
/**	Flag: Print OpenSSL license also when asked for license terms.
*/
#define DK3_SHOW_OPENSSL_LICENSE	1
#endif



#line 589 "dkt.ctr"



/**	Application group name.
*/
static dkChar const dkt_group_name[] = { dkT("dkt-3") };



/**	Localized texts.
*/
static dkChar const * const dkt_message_texts[] = {
/* 0 */
dkT("Options -i and -p are exclusive!"),

/* 1 */
dkT("Input contains characters outside ISO-LATIN-1!"),

/* 2 */
dkT("Options -n, -u and -f are exclusive!"),

/* 3 */
dkT("Options -w and -b are exclusive!"),

/* 4 */
dkT("Options -e and -m are exclusive!"),

/* 5 */
dkT("Illegal file type specification: \""),

/* 6 */
dkT("\"!"),

/* 7 */
dkT("Missing message digest type name!"),

/* 8 */
dkT("Message digest type name too long!: \""),

/* 9 */
dkT("\"!"),

/* 10 */
dkT("Illegal symlink depth: \""),

/* 11 */
dkT("\"!"),

/* 12 */
dkT("Directories: "),

/* 13 */
dkT("Files: "),

/* 14 */
dkT("Bytes: "),

/* 15 */
dkT("Block size too large: \""),

/* 16 */
dkT("\"!"),

/* 17 */
dkT("OK"),

/* 18 */
dkT("FAILED!"),

/* 19 */
dkT("Options -v and -q are exclusive!"),

/* 20 */
dkT("Missing message digest name!"),

/* 21 */
dkT("Unknown control instruction \""),

/* 22 */
dkT("\"!"),

/* 23 */
dkT("Not a regular file: \""),

/* 24 */
dkT("\"!"),

/* 25 */
dkT("No filename specified!"),

/* 26 */
dkT("There were failed tests!"),

/* 27 */
dkT("Syntax error, not a \"dkt tape\" file!"),

/* 28 */
dkT("Backup period (200 times) completed.\nPlease change media set!"),

/* 29 */
dkT("No set names in line!"),

/* 30 */
dkT("Too many input lines!"),

/* 31 */
dkT("Syntax error in input file!"),

/* 32 */
dkT("Options -e and -x are exclusive!"),

/* 33 */
dkT("No LaTeX encoding found for \""),

/* 34 */
dkT("\"!"),

/* 35 */
dkT("Not a hexadecimal number: \""),

/* 36 */
dkT("\"!"),

/* 37 */
dkT("Unknown command \""),

/* 38 */
dkT("\"!"),

/* 39 */
dkT("No command specified!"),

/* 40 */
dkT("Missing range specification!"),

/* 41 */
dkT("Unknown password type \""),

/* 42 */
dkT("\"!"),

/* 43 */
dkT("Missing class name!"),

/* 44 */
dkT("Missing configuration text!"),

/* 45 */
dkT("Missing configuration text!"),

/* 46 */
dkT("Line too long: \""),

/* 47 */
dkT("\"!"),

/* 48 */
dkT("No such class: \""),

/* 49 */
dkT("\"!"),

/* 50 */
dkT("Inconsistent password class setup!"),

/* 51 */
dkT("Invalid range for number of upper-case characters!"),

/* 52 */
dkT("Invalid range for number of special characters!"),

/* 53 */
dkT("Invalid range for number digits!"),

/* 54 */
dkT("Invalid range for length!"),

/* 55 */
dkT("Password length too large!"),

/* 56 */
dkT("Function is not supported on this system!"),

/* 57 */
dkT("This command is not available on Windows systems!"),

/* 58 */
dkT("Missing maximum UID!"),

/* 59 */
dkT("Missing minimum UID!"),

/* 60 */
dkT("No free user ID available in the specified range!"),

/* 61 */
dkT("Invalid buffer size!"),

/* 62 */
dkT("Options -i and -d are exclusive!"),

/* 63 */
dkT("Illegal option \""),

/* 64 */
dkT("\"!"),

/* 65 */
dkT("Options -f and -p are exclusive!"),

/* 66 */
dkT("Option -f requires an argument!"),

/* 67 */
dkT("Unknown subcommand \""),

/* 68 */
dkT("\"!"),

/* 69 */
dkT("Too few arguments for command!"),

/* 70 */
dkT("Error in command line options!"),

/* 71 */
dkT("Current tape: "),

/* 72 */
dkT("   (previous cycle)"),

/* 73 */
dkT("Probably a problem with backslash escape sequences."),

/* 74 */
dkT("When using C:\\ in quotes, you probably must use \"C:\\\\\",\nnot \"C:\\\"."),

/* 75 */
dkT("Option -l ignored, can not be used in conjunction with -e!"),

/* 76 */
dkT("Too many text lines, only 999 allowed!"),

NULL


#line 866 "dkt.ctr"
};



/**	String table file name.
*/
static dkChar const dkt_string_table_file_name[] = { dkT("dkt3.str") };



/**	Keywords, not localized.
*/
static dkChar const * const dkt_kw_no_loc[] = {
/* 0 */
dkT("%u"),

/* 1 */
dkT("%lf"),

/* 2 */
dkT("unlimited"),

/* 3 */
dkT("mtpn"),

/* 4 */
dkT("."),

/* 5 */
dkT("# message digest = "),

/* 6 */
dkT("-------------------"),

/* 7 */
dkT("0"),

/* 8 */
dkT("0000-00-00"),

/* 9 */
dkT("00:00:00"),

/* 10 */
dkT(".bck"),

/* 11 */
dkT("user,type=simple,length=6-8,digits=1-2,specials=1-2,upper-case=1-2"),

/* 12 */
dkT("admin,type=ascii-85,length=10-12"),

/* 13 */
dkT("wpa,type=hex,length=32"),

/* 14 */
dkT("user"),

/* 15 */
dkT("--------------------------"),

/* 16 */
dkT("---------------------------------"),

/* 17 */
dkT("-----------------"),

NULL


#line 953 "dkt.ctr"
};



/**	Commands.
*/
static dkChar const * const dkt_commands[] = {
/*  0 */ dkT("blocksize"),
/*  1 */ dkT("blks"),
/*  2 */ dkT("checksum"),
/*  3 */ dkT("cs"),
/*  4 */ dkT("create-password"),
/*  5 */ dkT("crp"),
/*  6 */ dkT("pwd"),
/*  7 */ dkT("hex"),
/*  8 */ dkT("hexadecimal"),
/*  9 */ dkT("octal"),
/* 10 */ dkT("oct"),
/* 11 */ dkT("html"),
/* 12 */ dkT("ht"),
/* 13 */ dkT("latex"),
/* 14 */ dkT("lat"),
/* 15 */ dkT("ls"),
/* 16 */ dkT("sort"),
/* 17 */ dkT("tape-set"),
/* 18 */ dkT("ts"),
/* 19 */ dkT("tape"),
/* 20 */ dkT("uid"),
/* 21 */ dkT("help"),
/* 22 */ dkT("--help"),
/* 23 */ dkT("version"),
/* 24 */ dkT("--version"),
/* 25 */ dkT("license-terms"),
/* 26 */ dkT("--license-terms"),
/* 27 */ dkT("cat"),
/* 28 */ dkT("checksize"),
/* 29 */ dkT("erase-disk"),
/* 30 */ dkT("ed"),
/* 31 */ dkT("random"),
/* 32 */ dkT("rand"),
/* 33 */ dkT("rnd"),
/* 34 */ dkT("license"),
/* 35 */ dkT("--license"),
/* 36 */ dkT("-L"),
/* 37 */ dkT("-h"),
/* 38 */ dkT("-v"),
/* 39 */ dkT("tape-report"),
/* 40 */ dkT("tr"),
NULL
};



/**	Version number string.
*/
static dkChar const dkt_version[] = {
dkT("dkt ") DKT_VERSION
};



/**	Licensing overview, list of all sources.
*/
static dkChar const * const dkt_overview_license[] = {
dkT("This software uses code from the following projects either directly"),
dkT("or as a library:"),
dkT(""),
dkT("dktools\t\tDirk Krause's tools and libraries."),
dkT("\t\tSee http://dktools.sourceforge.net for more information."),
dkT("OpenSSL\t\tCryptographic toolkit implementing the Secure Sockets Layer"),
dkT("\t\tprotocols and related cryptography standards required"),
dkT("\t\tby them."),
dkT("\t\tSee http://www.openssl.org for more information."),
dkT(""),
dkT(""),
NULL
};



/**	License terms for the dktools project itself.
*/
static dkChar const * const dkt_license[] = {
dkT("License for the dktools project"),
dkT("==============================="),
dkT("Copyright (c) 2011-2013, Dirk Krause"),
dkT("All rights reserved."),
dkT(""),
dkT("Redistribution and use in source and binary forms,"),
dkT("with or without modification, are permitted provided"),
dkT("that the following conditions are met:"),
dkT(""),
dkT("* Redistributions of source code must retain the above"),
dkT("  copyright notice, this list of conditions and the"),
dkT("  following disclaimer."),
dkT("* Redistributions in binary form must reproduce the above "),
dkT("  copyright notice, this list of conditions and the following"),
dkT("  disclaimer in the documentation and/or other materials"),
dkT("  provided with the distribution."),
dkT("* Neither the name of the copyright holder(s) nor the names of"),
dkT("  contributors may be used to endorse or promote"),
dkT("  products derived from this software without specific"),
dkT("  prior written permission."),
dkT(""),
dkT("THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND"),
dkT("CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES,"),
dkT("INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF"),
dkT("MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE"),
dkT("DISCLAIMED."),
dkT("IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE"),
dkT("LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,"),
dkT("EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT"),
dkT("LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;"),
dkT("LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)"),
dkT("HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN"),
dkT("CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE"),
dkT("OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS"),
dkT("SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH"),
dkT("DAMAGE."),
dkT(""),
NULL


#line 1075 "dkt.ctr"
};



/**	License terms for teh OpenSSL library.
*/
static dkChar const * const dkt_openssl_license[] = {
dkT(""),
dkT("OpenSSL library license"),
dkT("======================="),
dkT(""),
dkT("The OpenSSL toolkit stays under a dual license, i.e. both the conditions of"),
dkT("the OpenSSL License and the original SSLeay license apply to the toolkit."),
dkT("See below for the actual license texts. Actually both licenses are BSD-style"),
dkT("Open Source licenses. In case of any license issues related to OpenSSL"),
dkT("please contact openssl-core@openssl.org."),
dkT(""),
dkT("OpenSSL License"),
dkT("---------------"),
dkT("Copyright (c) 1998-2011 The OpenSSL Project.  All rights reserved."),
dkT(""),
dkT("Redistribution and use in source and binary forms, with or without"),
dkT("modification, are permitted provided that the following conditions"),
dkT("are met:"),
dkT(""),
dkT("1. Redistributions of source code must retain the above copyright"),
dkT("   notice, this list of conditions and the following disclaimer. "),
dkT(""),
dkT("2. Redistributions in binary form must reproduce the above copyright"),
dkT("   notice, this list of conditions and the following disclaimer in"),
dkT("   the documentation and/or other materials provided with the"),
dkT("   distribution."),
dkT(""),
dkT("3. All advertising materials mentioning features or use of this"),
dkT("   software must display the following acknowledgment:"),
dkT("   \"This product includes software developed by the OpenSSL Project"),
dkT("   for use in the OpenSSL Toolkit. (http://www.openssl.org/)\""),
dkT(""),
dkT("4. The names \"OpenSSL Toolkit\" and \"OpenSSL Project\" must not be used to"),
dkT("   endorse or promote products derived from this software without"),
dkT("   prior written permission. For written permission, please contact"),
dkT("   openssl-core@openssl.org."),
dkT(""),
dkT("5. Products derived from this software may not be called \"OpenSSL\""),
dkT("   nor may \"OpenSSL\" appear in their names without prior written"),
dkT("   permission of the OpenSSL Project."),
dkT(""),
dkT("6. Redistributions of any form whatsoever must retain the following"),
dkT("   acknowledgment:"),
dkT("   \"This product includes software developed by the OpenSSL Project"),
dkT("   for use in the OpenSSL Toolkit (http://www.openssl.org/)\""),
dkT(""),
dkT("THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY"),
dkT("EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE"),
dkT("IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR"),
dkT("PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR"),
dkT("ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,"),
dkT("SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT"),
dkT("NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;"),
dkT("LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)"),
dkT("HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,"),
dkT("STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)"),
dkT("ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED"),
dkT("OF THE POSSIBILITY OF SUCH DAMAGE."),
dkT("===================================================================="),
dkT(""),
dkT("This product includes cryptographic software written by Eric Young"),
dkT("(eay@cryptsoft.com).  This product includes software written by Tim"),
dkT("Hudson (tjh@cryptsoft.com)."),
dkT(""),
dkT(""),
dkT("Original SSLeay License"),
dkT("-----------------------"),
dkT(""),
dkT("Copyright (C) 1995-1998 Eric Young (eay@cryptsoft.com)"),
dkT("All rights reserved."),
dkT(""),
dkT("This package is an SSL implementation written"),
dkT("by Eric Young (eay@cryptsoft.com)."),
dkT("The implementation was written so as to conform with Netscapes SSL."),
dkT(""),
dkT("This library is free for commercial and non-commercial use as long as"),
dkT("the following conditions are aheared to.  The following conditions"),
dkT("apply to all code found in this distribution, be it the RC4, RSA,"),
dkT("lhash, DES, etc., code; not just the SSL code.  The SSL documentation"),
dkT("included with this distribution is covered by the same copyright terms"),
dkT("except that the holder is Tim Hudson (tjh@cryptsoft.com)."),
dkT(""),
dkT("Copyright remains Eric Young's, and as such any Copyright notices in"),
dkT("the code are not to be removed."),
dkT("If this package is used in a product, Eric Young should be given attribution"),
dkT("as the author of the parts of the library used."),
dkT("This can be in the form of a textual message at program startup or"),
dkT("in documentation (online or textual) provided with the package."),
dkT(""),
dkT("Redistribution and use in source and binary forms, with or without"),
dkT("modification, are permitted provided that the following conditions"),
dkT("are met:"),
dkT("1. Redistributions of source code must retain the copyright"),
dkT("   notice, this list of conditions and the following disclaimer."),
dkT("2. Redistributions in binary form must reproduce the above copyright"),
dkT("   notice, this list of conditions and the following disclaimer in the"),
dkT("   documentation and/or other materials provided with the distribution."),
dkT("3. All advertising materials mentioning features or use of this software"),
dkT("   must display the following acknowledgement:"),
dkT("   \"This product includes cryptographic software written by"),
dkT("    Eric Young (eay@cryptsoft.com)\""),
dkT("   The word 'cryptographic' can be left out if the rouines from the library"),
dkT("   being used are not cryptographic related :-)."),
dkT("4. If you include any Windows specific code (or a derivative thereof) from "),
dkT("   the apps directory (application code) you must include an acknowledgement:"),
dkT("   \"This product includes software written by Tim Hudson (tjh@cryptsoft.com)\""),
dkT(""),
dkT("THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND"),
dkT("ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE"),
dkT("IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE"),
dkT("ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE"),
dkT("FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL"),
dkT("DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS"),
dkT("OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)"),
dkT("HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT"),
dkT("LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY"),
dkT("OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF"),
dkT("SUCH DAMAGE."),
dkT(""),
dkT("The licence and distribution terms for any publically available version or"),
dkT("derivative of this code cannot be changed.  i.e. this code cannot simply be"),
dkT("copied and put under another distribution licence"),
dkT("[including the GNU Public Licence.]"),
dkT(""),
NULL


#line 1207 "dkt.ctr"
};



/**	The main() function.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	0 on success, any other value indicates an error.
*/
DK3_MAIN
{
  dk3_app_t		*app = NULL;
  dkChar const * const	*msg = NULL;	/* Localized messages. */
  int			 exval = DKT_RESULT_ERR_UNSPECIFIC; /* Exit code. */
  int			 xargc; /* Cmd arguments number. */
  int			 htp	= -1;	/* Help topic. */
  dkChar const * const	*xargv;	/* Cmd arguments array. */
  

#line 1225 "dkt.ctr"
  

#line 1226 "dkt.ctr"
#if DK3_HAVE_TZSET
  tzset();
#endif
  app = dk3app_open_command(
    argc, (dkChar const * const *)argv, dkt_group_name
  );
  if(app) {
    msg = dk3app_messages(
      app, dkt_string_table_file_name, (dkChar const **)dkt_message_texts
    );
    xargc = dk3app_get_argc(app);
    xargv = dk3app_get_argv(app);
    if(xargc > 1) {
      switch(dk3str_array_index(dkt_commands, xargv[1], 0)) {
        case 0: case 1: {	

#line 1241 "dkt.ctr"
	  exval = dkt_blocksize(app, dkt_commands[0], msg, dkt_kw_no_loc);
	} break;
	case 2: case 3: {	

#line 1244 "dkt.ctr"
	  exval = dkt_check(app, dkt_commands[2], msg, dkt_kw_no_loc, 0);
	} break;
	case 4: case 5: {	

#line 1247 "dkt.ctr"
	  exval = dkt_crp(app, dkt_commands[4], msg, dkt_kw_no_loc);
	} break;
	case 6: {		

#line 1250 "dkt.ctr"
	  exval = dkt_cwd(app, dkt_commands[6], msg, dkt_kw_no_loc);
	} break;
	case 7: case 8: {	

#line 1253 "dkt.ctr"
	  exval = dkt_hex(app, dkt_commands[7], msg, dkt_kw_no_loc, 0);
	} break;
	case 9: case 10: {	

#line 1256 "dkt.ctr"
	  exval = dkt_hex(app, dkt_commands[7], msg, dkt_kw_no_loc, 1);
	} break;
	case 11: case 12: {	

#line 1259 "dkt.ctr"
	  exval = dkt_html(app, dkt_commands[11], msg, dkt_kw_no_loc);
	} break;
	case 13: case 14: {	

#line 1262 "dkt.ctr"
	  exval = dkt_lat(app, dkt_commands[13], msg, dkt_kw_no_loc);
	} break;
	case 15: {		

#line 1265 "dkt.ctr"
	  exval = dkt_ls(app, dkt_commands[15], msg, dkt_kw_no_loc);
	} break;
	case 16: {		

#line 1268 "dkt.ctr"
	  exval = dkt_sort(app, dkt_commands[16], msg, dkt_kw_no_loc);
	} break;
	case 17: case 18: {	

#line 1271 "dkt.ctr"
	  exval = dkt_tapeset(app, dkt_commands[17], msg, dkt_kw_no_loc);
	} break;
	case 19: {		

#line 1274 "dkt.ctr"
	  exval = dkt_tape(app, dkt_commands[19], msg, dkt_kw_no_loc);
	} break;
	case 39: case 40: {
	  exval = dkt_tapereport(app, dkt_commands[39], msg, dkt_kw_no_loc);
	} break;
	case 20: {		

#line 1280 "dkt.ctr"
	  dkt_uid(app, dkt_commands[20], msg, dkt_kw_no_loc);
	} break;
	case 21: case 22: case 37: {	

#line 1283 "dkt.ctr"
	  if(xargc > 2) {
	    htp = dk3str_array_index(dkt_commands, xargv[2], 0);
	  }
	  exval = dkt_help(app, dkt_commands[21], msg, dkt_kw_no_loc, htp);
	} break;
	case 23: case 24: case 38: {	

#line 1289 "dkt.ctr"
	  dk3sf_initialize_stdout();
	  dk3sf_fputs(dkt_version, stdout);
	  dk3sf_fputc(dkT('\n'), stdout);
	} break;
	case 25: case 26: case 34: case 35: case 36: {
	  dkChar const * const *sptr;	

#line 1295 "dkt.ctr"

	  sptr = dkt_overview_license;
	  dk3sf_initialize_stdout();
	  while(*sptr) {
	    dk3sf_fputs(*(sptr++), stdout);
	    dk3sf_fputc(dkT('\n'), stdout);
	  }
	  sptr = dkt_license;
	  while(*sptr) {
	    dk3sf_fputs(*(sptr++), stdout);
	    dk3sf_fputc(dkT('\n'), stdout);
	  }
#if DK3_SHOW_OPENSSL_LICENSE
	  sptr = dkt_openssl_license;
	  while(*sptr) {
	    dk3sf_fputs(*(sptr++), stdout);
	    dk3sf_fputc(dkT('\n'), stdout);
	  }
#endif
	} break;
	case 27: {
	  exval = dkt_cat(app, dkt_commands[27], msg, dkt_kw_no_loc);
	} break;
	case 28: {
	  exval = dkt_check(app, dkt_commands[28], msg, dkt_kw_no_loc, 1);
	} break;
	case 29: case 30: {
	  exval = dkt_ed(app, dkt_commands[29], msg, dkt_kw_no_loc);
	} break;
	case 31: case 32: case 33: {
	  exval = dkt_rnd(app, dkt_commands[31], msg, dkt_kw_no_loc);
	} break;
	default: {
	  dk3app_log_3(app, DK3_LL_ERROR, msg, 37, 38, xargv[1]);
	  exval = dkt_help(app, dkt_commands[21], msg, dkt_kw_no_loc, htp);
	} break;
      }
    } else {
      dk3app_log_1(app, DK3_LL_ERROR, msg, 39);
      /* Print help. */
      exval = dkt_help(app, dkt_commands[21], msg, dkt_kw_no_loc, htp);
    }
    dk3app_close(app);
  } else {
    /* ERROR: Memory */
    fputs("dkt: ERROR: Not enough memory!\n", stderr);
    fflush(stderr);
  }
  

#line 1344 "dkt.ctr"
  

#line 1345 "dkt.ctr"
  fflush(stdout);
  exit(exval); return exval;
}



/* vim: set ai sw=2 : */

