/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dkt-xxx.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dkt-xxx.c The dkt-xxx module.
*/


#line 10 "dkt-xxx.ctr"

#include "dk3all.h"
#include "dkt.h"





#line 17 "dkt-xxx.ctr"



/**	Job structure.
*/
typedef struct {
  dk3_app_t		*app;	/**< Application. */
  dk3_option_set_t	*opt;	/**< Option set. */
  dkChar const * const	*msg;	/**< Localized messages. */
  dkChar const * const	*kwnl;	/**< Keywords, not localized. */
  int			 exval;	/**< Exit status code. */
  int			 enc_s;	/**< Encoding for stdin. */
  int			 enc_f;	/**< Encoding for files. */
} DKT_HTML_J;



/**	Long options / configuration file keywords.
*/
static dkChar const * const	dkt_html_long_opt[] = {
dkT("stdin-encoding"),
dkT("file-encoding"),
dkT("reset"),
NULL
};



/**	Options processed by the subcommand.
*/
static dk3_option_t const dkt_html_options[] = {
  { dkT('R'), dkT("reset"), 0 },
  { dkT('i'), dkT("input-encoding"), 1 },
  { dkT('p'), dkT("plain"), 0 },
};

/**	Number of entries in @ref dkt_html_options. */
static size_t const dkt_html_szoptions =
sizeof(dkt_html_options)/sizeof(dk3_option_t);

/**	Reset the job structure.
	@param	j	Job structure.
*/
static
void
dkt_html_job_reset(DKT_HTML_J *j)
{
  

#line 65 "dkt-xxx.ctr"
  j->enc_f = dk3app_get_default_file_encoding(j->app); 

#line 66 "dkt-xxx.ctr"
  j->enc_s = dk3app_get_default_stdin_encoding(j->app); 

#line 67 "dkt-xxx.ctr"
  

#line 68 "dkt-xxx.ctr"
}



/**	Initialize job structure.
	@param	j	Job structure.
*/
static
void
dkt_html_job_init(DKT_HTML_J *j)
{
  

#line 80 "dkt-xxx.ctr"
  j->exval = DKT_RESULT_ERR_UNSPECIFIC;
  j->opt = NULL;
  dkt_html_job_reset(j);
  j->enc_f = dk3app_get_input_file_encoding(j->app);  

#line 84 "dkt-xxx.ctr"
  j->enc_s = dk3app_get_input_stdin_encoding(j->app); 

#line 85 "dkt-xxx.ctr"
  

#line 86 "dkt-xxx.ctr"
}



/**	Clean up job structure.
	@param	j	Job structure.
*/
static
void
dkt_html_job_cleanup(DKT_HTML_J *j)
{
  int i;
  

#line 99 "dkt-xxx.ctr"
  /* Release option set. */
  if(j->opt) {
    dk3opt_close(j->opt);
  } j->opt = NULL;
  

#line 104 "dkt-xxx.ctr"
}



/**	Process one key/value pair, either long option or config file line.
	@param	job	Job structure.
	@param	key	Key (option name).
	@param	val	Value.
	@param	ori	Original text.
	@param	verb	Flag: Verbose.
	@return	1 on success, 0 on error.
*/
static
int
dkt_html_long_opt_handler(
  DKT_HTML_J *job,
  dkChar const *key,
  dkChar const *val,
  dkChar const *ori,
  int		verb
)
{
  int back = 0;
  int i;
  

#line 129 "dkt-xxx.ctr"
  if((job) && (key) && (ori)) {
    i = dk3str_array_index(dkt_html_long_opt, key, 0);
    switch(i) {
      case 0: {
        back = dkt_tool_set_encoding(
	  job->app, &(job->enc_s), val,
	  dk3app_get_input_stdin_encoding(job->app)
	); 

#line 137 "dkt-xxx.ctr"
      } break;
      case 1: {
        back = dkt_tool_set_encoding(
	  job->app, &(job->enc_f), val,
	  dk3app_get_input_file_encoding(job->app)
	); 

#line 143 "dkt-xxx.ctr"
      } break;
      case 2: {
        dkt_html_job_reset(job);
        back = 1;
      } break;
      default: {
        if(verb) {
	  /* ERROR: Unknown option */
	  if((job->app) && (job->msg)) {
	    dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 63, 64, key);
	  }
	}
      } break;
    }
  } 

#line 158 "dkt-xxx.ctr"
  return back;
}



/**	Handle one configuration line.
	@param	jv	Job structure as void pointer.
	@param	k	Key part.
	@param	v	Value part.
	@return	1 on success, 0 on error.
*/
static
int
dkt_html_conf_line(void *jv, dkChar const *k, dkChar const *v)
{
  

#line 174 "dkt-xxx.ctr"
  (void)dkt_html_long_opt_handler((DKT_HTML_J *)jv, k, v, k, 0);
  

#line 176 "dkt-xxx.ctr"
  return 1;
}



/**	Process command line arguments.
	@param	j	Job structure.
	@return	1 on success (can continue), 0 on error.
*/
static
int
dkt_html_process_arguments(DKT_HTML_J *j)
{
  int back = 0;
  int			 xargc;
  dkChar const * const	*xargv;
  dkChar const		*x;
  int			 res;
  

#line 195 "dkt-xxx.ctr"
  xargc = dk3app_get_argc(j->app);
  xargv = dk3app_get_argv(j->app);
  xargv++; xargv++; xargc--; xargc--;
  j->opt = dk3opt_open_app(
    dkt_html_options,
    dkt_html_szoptions,
    dkT('\0'),
    NULL,
    xargc,
    xargv,
    j->app
  );
  if(j->opt) {
    back = 1;
    if(dk3opt_is_set(j->opt, dkT('R'))) {
      dkt_html_job_reset(j);
    }
    if(dk3opt_is_set(j->opt, dkT('i'))) {
      x = dk3opt_get_short_arg(j->opt, dkT('i'));
      if(x) {
        res = dkt_tool_set_encoding(
	  j->app, &(j->enc_s), x,
	  dk3app_get_input_stdin_encoding(j->app)
	); 

#line 219 "dkt-xxx.ctr"
	if(res) {
	  j->enc_f = j->enc_s;
	} else {
	  back = 0; j->exval = DKT_RESULT_ERR_OPTION;
	}
      } else {
        back = 0; j->exval = DKT_RESULT_ERR_OPTION;
      }
    } else {
      if(dk3opt_is_set(j->opt, dkT('p'))) {
        j->enc_f = j->enc_s = DK3_FILE_ENCODING_ASCII;
      }
    }
  } else {
    j->exval = DKT_RESULT_ERR_MEMORY;
  } 

#line 235 "dkt-xxx.ctr"
  return back;
}



/**	Run the command.
	@param	j	Job structure.
*/
static
void
dkt_html_run(DKT_HTML_J *j)
{
  

#line 248 "dkt-xxx.ctr"
  

#line 249 "dkt-xxx.ctr"
}



int
dkt_html(
  dk3_app_t		*app,
  dkChar const		*sn,
  dkChar const * const	*msg,
  dkChar const * const	*kwnl
)
{
  int back = DKT_RESULT_ERR_UNSPECIFIC;
  DKT_HTML_J	j;
  

#line 264 "dkt-xxx.ctr"
  j.app = app; j.msg = msg; j.kwnl = kwnl;
  dkt_html_job_init(&j);
  dkt_tool_read_conf(app, sn, (void *)(&j), dkt_html_conf_line);
  

#line 268 "dkt-xxx.ctr"
  if(dkt_html_process_arguments(&j)) {
    j.exval = DKT_RESULT_OK;
    dkt_html_run(&j);
  }
  back = j.exval;
  dkt_html_job_cleanup(&j);
  

#line 275 "dkt-xxx.ctr"
  return back;
}



/* vim: set ai sw=2 : */

