/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dkt-tool.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dkt-tool.c The dkt-tool module.
*/


#line 10 "dkt-tool.ctr"

#include "dk3all.h"
#include "dkt.h"





#line 17 "dkt-tool.ctr"



/**	Data to read configuration file.
*/
typedef struct {
  void			*obj;	/**< Object to configure. */
  dkt_conf_fct_t	*fct;	/**< Handler function. */
  dkChar const		*sn;	/**< Section name. */
  int			 ins;	/**< Flag: In scope. */
} dkt_tool_config_reader_t;



/**	Keywords used by this module.
*/
static dkChar const * const dkt_tool_kwnl[] = {
/*  0 */ dkT("dkt.conf"),
NULL
};


/**	Configuration file line handler function.
	@param	vo	Object to modify during processing.
	@param	il	Input line.
	@return	1 on success, 0 on error (can continue), -1 on error (abort).
*/
static
int
dkt_tool_conf_line_handler(
  void		*vo,
  dkChar	*il
)
{
  int back = 0;
  dkt_tool_config_reader_t      *rdr	= NULL;
  dkChar			*p1	= NULL;
  dkChar			*p2	= NULL;
  

#line 56 "dkt-tool.ctr"
  rdr = (dkt_tool_config_reader_t *)vo;
  if(rdr) {			

#line 58 "dkt-tool.ctr"
    if(il) {			

#line 59 "dkt-tool.ctr"
      back = 1;
      dk3str_delnl(il);			

#line 61 "dkt-tool.ctr"
      p1 = dk3str_start(il, NULL);	

#line 62 "dkt-tool.ctr"
      if(p1) {
        if(*p1 != dkT('#')) {				

#line 64 "dkt-tool.ctr"
	  if(*p1 == dkT('[')) {				

#line 65 "dkt-tool.ctr"
	    rdr->ins = 0;
	    p2 = dk3str_chr(p1, dkT(']'));
	    if(p2) {
	      *p2 = dkT('\0');
	      p1++;
	      p1 = dk3str_start(p1, NULL);
	      if(p1) {	

#line 72 "dkt-tool.ctr"
	        if(dk3str_casecmp(p1, rdr->sn) == 0) {
		  rdr->ins = 1;		

#line 74 "dkt-tool.ctr"
		}
	      } else {
	        /* ERROR: Syntax */
	      }
	    } else {
	      /* ERROR: Syntax */
	    }
	  } else {			

#line 82 "dkt-tool.ctr"
	    if(rdr->ins) {		

#line 83 "dkt-tool.ctr"
	      p2 = dk3str_chr(p1, dkT('='));
	      if(p2) {
	        *(p2++) = dkT('\0');
		p2 = dk3str_start(p2, NULL);
		if(p2) {
		  dk3str_chomp(p2, NULL);
		}
	      }
	      dk3str_chomp(p1, NULL);
	      dk3str_normalize(p1, NULL, dkT('-'));	

#line 93 "dkt-tool.ctr"
	      back = (*(rdr->fct))(rdr->obj, p1, p2);
	    }
	  }
	}
      }
    }
  } 

#line 100 "dkt-tool.ctr"
  return back;
}



void
dkt_tool_read_conf(
  dk3_app_t		*app,
  dkChar const		*sn,
  void			*obj,
  dkt_conf_fct_t	*fct
)
{
  dk3_search_t			*res	= NULL;	/* File search results. */
  dkChar const			*fn	= NULL;	/* Current file name. */
  dkt_tool_config_reader_t	rdr;		/* Configuration reader. */
  dkChar		buffer[1024];		/* Input line buffer. */
  

#line 118 "dkt-tool.ctr"
  if((app) && (sn) && (obj) && (fct)) {
    res = dk3app_find_config_file(app, dkt_tool_kwnl[0], 0);
    if(res) {
      rdr.obj = obj;
      rdr.fct = fct;
      rdr.ins = 0;
      rdr.sn = sn;
      dk3search_reset(res);
      while((fn = dk3search_next(res)) != NULL) {
        (void)dk3stream_process_filename_lines_app(
	  (void *)(&rdr),
	  dkt_tool_conf_line_handler,
	  fn,
	  buffer,
	  DK3_SIZEOF(buffer,dkChar),
	  dk3app_get_encoding(app),
	  dk3app_get_input_file_encoding(app),
	  app
	);
      }
      dk3search_close(res);
    }
  } 

#line 141 "dkt-tool.ctr"
}



int
dkt_tool_set_encoding(
  dk3_app_t		*app,
  int			*enc,
  dkChar const		*val,
  int			 de
)
{
  int back	=  0;
  int i		= -1;	/* Index of string in array of encodings. */

  if((app) && (enc)) {
    if(val) {
      i = dk3enc_get_text_encoding_app(val, app);
      if(i > -1) {
        *enc = i;
	back = 1;
      } else {
        *enc = de;
      }
    } else {
      *enc = de;
      back = 1;
    }
  }
  return back;
}



int
dkt_tool_set_md_type(
  int *jmdt,
  int *jmde,
  int *exval,
  dkChar const *txt,
  dk3_app_t *app, 
  dkChar const * const *msg,
  int verb
)
{
  int 		back = 0;
  int		mdt = DK3_MD_TYPE_SHA_1;	/* New message digest type. */
  int		mde = DK3_DATA_ENCODING_HEX;	/* New encoding. */
  dkChar	bu[DK3_MAX_PATH];		/* Private copy of txt. */
  dkChar	*p1	= NULL;			/* Digest. */
  dkChar	*p2	= NULL;			/* Encoding. */

  if(dk3str_len(txt) < DK3_SIZEOF(bu,dkChar)) {
    dk3str_cpy_not_overlapped(bu, txt);
    p1 = dk3str_start(bu, NULL);
    if(p1) {
      p2 = dk3str_chr(p1, dkT('.'));
      if(p2) {
        *(p2++) = dkT('\0');
	p2 = dk3str_start(p2, NULL);
      }
      dk3str_chomp(p1, NULL);
      if(p2) { dk3str_chomp(p2, NULL); }
      if((mdt = dk3checksum_get_type_app(p1, app)) > -1) {
        back = 1;
	if(p2) {
	  back = 0;
	  if((mde = dk3enc_get_type_app(p2, app)) > -1) {
	    back = 1;
	  } else {
	    if(verb) {
	      dk3app_log_i3(app, DK3_LL_ERROR, 129, 130, p2);
	      *exval = DKT_RESULT_ERR_OPTION;
	    }
	  }
	}
      } else {
        if(verb) {
	  dk3app_log_i3(app, DK3_LL_ERROR, 127, 128, p1);
	  *exval = DKT_RESULT_ERR_OPTION;
	}
      }
    } else {
      if(verb) {
        dk3app_log_1(app, DK3_LL_ERROR, msg, 7);
	*exval = DKT_RESULT_ERR_OPTION;
      }
    }
    if(back) {
      *jmdt = mdt; *jmde = mde;
    }
  } else {
    if(verb) {
      /* ERROR: String too long! */
      dk3app_log_3(app, DK3_LL_ERROR, msg, 8, 9, txt);
      *exval = DKT_RESULT_ERR_OPTION;
    }
  }
  return back;
}



int
dkt_tool_set_size(
  size_t		*rp,
  dkChar const		*src,
  dkChar const * const	*msg,
  dkChar const * const	*kwnl,
  dk3_app_t		*app,
  int			*exc
)
{
  dkChar const	*ptr;
  int		 back = 0;
  int		 myec = 0;
  if ((NULL != rp) && (NULL != src) && (NULL != msg) && (NULL != kwnl)
      && (NULL != app) && (NULL != exc)) {
    ptr = dk3str_start(src, NULL);
    if (NULL != ptr) {
      back = dk3ma_sz_from_string(rp, src, &myec);
      if (0 == back) {
        switch (myec) {
	  case DK3_ERROR_MATH_OVERFLOW: {
	    dk3app_log_3(app, DK3_LL_ERROR, msg, 15, 16, src);
	    *exc = DKT_RESULT_ERR_OPTION;
	  } break;
	  case DK3_ERROR_INVALID_ARGS: {
	    dk3app_log_i3(app, DK3_LL_ERROR, 141, 142, src);
	    *exc = DKT_RESULT_ERR_OPTION;
	  } break;
	  case DK3_ERROR_SYNTAX: {
	    dk3app_log_i3(app, DK3_LL_ERROR, 141, 142, src);
	    *exc = DKT_RESULT_ERR_OPTION;
	  } break;
	  default: {
	    dk3app_log_i3(app, DK3_LL_ERROR, 141, 142, src);
	    *exc = DKT_RESULT_ERR_OPTION;
	  } break;
	}
      }
    } else {
      /* ##### ERROR: No text in string */
    }
  }
  return back;
}


/* vim: set ai sw=2 : */

