/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dkt-help.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dkt-help.c The dkt-help module.
*/


#line 10 "dkt-help.ctr"

#include "dk3all.h"
#include "dkt.h"





#line 17 "dkt-help.ctr"



/**	Default help text for dkt.
*/
static dkChar const * const dkt_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt - Dirk Krause's tool"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt <command> <options> <arguments>"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The dkt program is a multipurpose tool. The command chooses the function"),
dkT("to perform. For some commands with long names there are abbreviations"),
dkT("available."),
dkT("The following commands can be used:"),
dkT(""),
dkT("sort"),
dkT("\tsorts input line by line, different sort criteria can be used."),
dkT(""),
dkT("html"),
dkT("ht"),
dkT("\tconverts input to HTML."),
dkT(""),
dkT("latex"),
dkT("lat"),
dkT("\tconverts input to LaTeX."),
dkT(""),
dkT("cat"),
dkT("\twrite input to standard output with optional conversion."),
dkT(""),
dkT("pwd"),
dkT("\tshows the current working directory."),
dkT(""),
dkT("ls"),
dkT("\tshows informations about the specified files."),
dkT(""),
dkT("checksum"),
dkT("cs"),
dkT("\tcreates checksums and compares current checksums against given lists."),
dkT(""),
dkT("checksize"),
dkT("\tcreates a file size list and compares current file sizes against"),
dkT("\ta given list."),
dkT(""),
dkT("blocksize"),
dkT("blks"),
dkT("\tbuffers an input stream and writes a data chunk sequence of fixed"),
dkT("\tsize chunks."),
dkT(""),
dkT("hexadecimal"),
dkT("hex"),
dkT("\tshows file contents in hexadecimal notation."),
dkT(""),
dkT("octal"),
dkT("oct"),
dkT("\tshows file contents in octal notation."),
dkT(""),
dkT("tape-set"),
dkT("ts"),
dkT("\tchooses the next tape set for backup or confirms the current"),
dkT("\ttape set."),
dkT(""),
dkT("tape"),
dkT("\tchooses the next tape from the current set for backup or confirms"),
dkT("\tthe current tape set."),
dkT(""),
dkT("create-password"),
dkT("crp"),
dkT("\tsuggests a password."),
dkT(""),
dkT("uid"),
dkT("\tsearches for the first free user ID in a range."),
dkT(""),
dkT("erase-disk"),
dkT("ed"),
dkT("\tcreates a data stream to wipe a hard disk."),
dkT(""),
dkT("random"),
dkT("rnd"),
dkT("\tcreates random data."),
dkT(""),
dkT(""),
dkT("Use"),
dkT("\tdkt help <command>"),
dkT("to obtained detailed information for a command, i.e."),
dkT("\tdkt help ls"),
dkT("for the ls command."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("The options depend on the command choosen, options are documented in the"),
dkT("help for the commands."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns exit status code 0 on success, all other status"),
dkT("codes indicate an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  dkt --license-terms"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("http://dktools.sourceforge.net"),
dkT(""),
NULL


#line 137 "dkt-help.ctr"
};



/**	Default help text for dkt sort.
*/
static dkChar const * const dkt_sort_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt sort - Sort input line by line."),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt sort [<options>] [<arguments>]"),
dkT(""),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program sorts input data line by line. Different sort criteria can"),
dkT("be used:"),
dkT(""),
dkT("- Case-sensitive text sorting,"),
dkT(""),
dkT("- Case-insensitive text sorting."),
dkT(""),
dkT("- Sorting by leading numbers in a line (signed and unsigned integers or"),
dkT("  floating point numbers."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-R"),
dkT("\tskips all settings from dkt.conf configuration files."),
dkT(""),
dkT("-i encoding"),
dkT("\tsets up the default input encoding. This encoding is used if no"),
dkT("\tbyte order marker is found at the beginning of input."),
dkT(""),
dkT("-p"),
dkT("\tshortcut for \"-i ascii\"."),
dkT(""),
dkT("-c"),
dkT("\tsets up case-insensitive text comparison."),
dkT(""),
dkT("-b"),
dkT("\tignores leading whitespaces (spaces and tabulators) at the beginning"),
dkT("\tof lines."),
dkT(""),
dkT("-w"),
dkT("\tuses a whitespace-normalized version of each line for comparison."),
dkT("\tLeading and trailing whitespace sequences are removed, all other"),
dkT("\twhitespace sequences are replaced by one space."),
dkT(""),
dkT("-n"),
dkT("\tsets up comparison by leading signed integers at the beginning"),
dkT("\tof lines."),
dkT(""),
dkT("-u"),
dkT("\tsets up comparison by leading unsigned integers at the beginning"),
dkT("\tof lines."),
dkT(""),
dkT("-f"),
dkT("\tsets up comparison by leading floating point numbers at the"),
dkT("\tbeginning of lines."),
dkT(""),
dkT("-s"),
dkT("\tprints lines without a leading number before the lines with"),
dkT("\ta number (when -n, -u or -f is used). By default lines without"),
dkT("\ta number are printed after lines with numbers."),
dkT(""),
dkT("-m"),
dkT("\tmerges lines evaluated as equally in comparisons."),
dkT(""),
dkT("-e"),
dkT("\tmerges lines exactly equal."),
dkT(""),
dkT("-r"),
dkT("\tuses reverse sort order."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt sort\" command replaces the program ksort from former dktools"),
dkT("versions."),
dkT(""),
NULL


#line 231 "dkt-help.ctr"
};



/**	Default help text for dkt html.
*/
static dkChar const * const dkt_html_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt html - Convert text to HTML"),
dkT(""),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt html [<options>] [<arguments>]"),
dkT(""),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program converts input data to HTML."),
dkT(""),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-R"),
dkT("\tskips all settings from dkt.conf configuration files."),
dkT(""),
dkT("-i encoding"),
dkT("\tsets up the default input encoding. This encoding is used if no"),
dkT("\tbyte order marker is found at the beginning of input."),
dkT(""),
dkT("-p"),
dkT("\tshortcut for \"-i ascii\"."),
dkT(""),
dkT("-l"),
dkT("\tadd <code> tags containing line number (max. 999 lines)."),
dkT(""),
dkT("-f"),
dkT("\tcreates a full HTML file."),
dkT(""),
dkT("-t title"),
dkT("\tspecifies the title for a full HTML file."),
dkT(""),
dkT("-e"),
dkT("\tsets echo mode, the command line arguments are the input text"),
dkT("\tto process."),
dkT(""),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt html\" function replaces the text2htm program from previous"),
dkT("dktools versions."),
dkT(""),
NULL


#line 295 "dkt-help.ctr"
};



/**	Default help text for dkt latex.
*/
static dkChar const * const dkt_latex_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt latex - Convert text to LaTeX"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt latex [<options>] [<arguments>]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program converts input text to LaTeX."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-R"),
dkT("\tskips all settings from dkt.conf configuration files."),
dkT(""),
dkT("-i encoding"),
dkT("\tsets up the default input encoding. This encoding is used if no"),
dkT("\tbyte order marker is found at the beginning of input."),
dkT(""),
dkT("-p"),
dkT("\tshortcut for \"-i ascii\"."),
dkT(""),
dkT("-e"),
dkT("\tEcho mode, the command line arguments are the text to convert."),
dkT(""),
dkT("-x"),
dkT("\tHexadecimal mode, command line arguments are hexadecimal"),
dkT("\trepresentations of the characters to convert."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt latex\" function replaces the text2lat and echo2lat programs from"),
dkT("previous dktools versions."),
dkT(""),
NULL


#line 350 "dkt-help.ctr"
};



/**	Default help text for dkt cat.
*/
static dkChar const * const dkt_cat_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt cat - Show files, change encoding if required"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt cat [<options>] [<arguments>]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program shows files, normally the sytems default encoding is used"),
dkT("for output."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-R"),
dkT("\tskips all settings from dkt.conf configuration files."),
dkT(""),
dkT("-i encoding"),
dkT("\tsets up the default input encoding. This encoding is used if no"),
dkT("\tbyte order marker is found at the beginning of input."),
dkT(""),
dkT("-p"),
dkT("\tshortcut for \"-i ascii\"."),
dkT(""),
dkT("-o encoding"),
dkT("\tchooses an output encoding."),
dkT(""),
dkT("-c"),
dkT("\twrites carriage return + newline combination at line ends."),
dkT("\tNormally (without the -c option) only a newline is written."),
dkT(""),
dkT("-w"),
dkT("\tnormalizes text. Leading and trailing whitespace sequences are"),
dkT("\tremoved, all other whitespace sequences are replaced by one"),
dkT("\tspace."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
NULL


#line 405 "dkt-help.ctr"
};



/**	Default help text for dkt pwd.
*/
static dkChar const * const dkt_pwd_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt pwd - Print working directory"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt pwd <option>"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program prints the current working directory."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-l"),
dkT("\tshow last part only."),
dkT(""),
dkT("-b"),
dkT("\treplace backslashes by slashes."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt pwd\" function replaces the dkpwd program from previous dktools"),
dkT("versions."),
dkT(""),
NULL


#line 448 "dkt-help.ctr"
};



/**	Default help text for dkt ls.
*/
static dkChar const * const dkt_ls_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt ls - List files"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt ls [<options>] [<arguments>]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program shows information about the specified files."),
dkT("Command line options allow to configure which information is shown in which"),
dkT("order."),
dkT("The size reported for directories includes the size of the directory itself"),
dkT("and the size of all contents."),
dkT(""),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-R"),
dkT("\tskips all settings from dkt.conf configuration files."),
dkT(""),
dkT("-p <print-order>"),
dkT("\tspecifies which information to print in which order."),
dkT("\tSee PRINT ORDER below."),
dkT(""),
dkT("-r"),
dkT("\tlists recursively."),
dkT(""),
dkT("-d"),
dkT("\tdereferences symbolic links. Without this option the program shows"),
dkT("\tinformation about the links, if \"-d\" is used the program shows"),
dkT("\tinformation about the link target."),
dkT("\tWhen listing recursively the program follows directory symlinks"),
dkT("\tif \"-d\" is used and following the directory symlink is not denied"),
dkT("\tby \"-l\" or \"-f\"."),
dkT(""),
dkT("-l <depth>"),
dkT("\tspecifies the number of directory symlinks to follow. Specify"),
dkT("\ta number or \"unlimited\"."),
dkT(""),
dkT("-f"),
dkT("\tstays in the current file system when listing recursively."),
dkT("\tThe program does not follow directory symlinks to other filesystems"),
dkT("\tand stops on mount points."),
dkT(""),
dkT("-t <types>"),
dkT("\tshows information only for the specified file types."),
dkT("\tSee FILE TYPES below."),
dkT(""),
dkT("-m <digest.encoding>"),
dkT("\tchooses a message digest algorithm and an encoding for checksums."),
dkT("\tThe following message digest algorithms can be used:"),
dkT("\tMD5\t\tRSA Data Security, Inc. MD5 Message Digest Algorithm"),
dkT("\t\t\t(RFC 1321)"),
dkT("\tSHA-1\t\tSHA-Algorithms"),
dkT("\tSHA-224\t\t(FIPS publications)"),
dkT("\tSHA-256"),
dkT("\tSHA-384"),
dkT("\tSHA-512"),
dkT("\tRIPEMD-160\tCryptographic hash function by Hans Dobbertin,"),
dkT("\t\t\tAntoon Bosselaers and Bart Preneel."),
dkT("\tThe following encodings can be used to convert the binary message"),
dkT("\tdigest data to text:"),
dkT("\tHEX\t\tHexadecimal representation"),
dkT("\t\t\t(creates 2 text bytes for each binary byte)."),
dkT("\tASCII-85\tASCII-85-Encoding"),
dkT("\t\t\t(creates 5 text bytes for each four binary bytes)."),
dkT("\tR-ASCII-85\tReverse ASCII-85-Encoding"),
dkT("\t\t\t(creates 5 text bytes for each four binary bytes)."),
dkT(""),
dkT("-s"),
dkT("\tprints a summary."),
dkT(""),
dkT("PRINT ORDER"),
dkT(""),
dkT("The argument to the \"-p\" option can contain the following key characters:"),
dkT(""),
dkT("n\tFile name"),
dkT("s\tFile size"),
dkT("t\tFile type"),
dkT("p\tFile permissions"),
dkT("x\tChecksum (message digest converted to text)"),
dkT("l\tNumber of links"),
dkT("c\tCreation timestamp"),
dkT("m\tModification timestamp"),
dkT("a\tAccess timestamp"),
dkT("u\tUser ID of owner"),
dkT("g\tGroup ID of owner group"),
dkT("d\tDevice number"),
dkT("r\tRelative device number"),
dkT("i\tInode number"),
dkT("f\tUnique file identifier (device+inode or volume serial + index)."),
dkT("w\tWindows reparse point tag (Windows only)"),
dkT(""),
dkT("FILE TYPES"),
dkT(""),
dkT("The following key characters are used to specify file types:"),
dkT(""),
dkT("f\tRegular file (\"-\" is used in output)"),
dkT("d\tDirectory"),
dkT("l\tSymbolic Link (in output \"L\" is used for symbolic links into another"),
dkT("\tfile system, \"!\" is used for symbolic links with non-existing"),
dkT("\ttargets)"),
dkT("p\tPipe / FIFO"),
dkT("c\tCharacter device"),
dkT("b\tBlock device"),
dkT("s\tSocket"),
dkT("D\tDoor"),
dkT("e\tEvent port"),
dkT("O\tXenix special file"),
dkT("N\tXenix semaphore"),
dkT("M\tXenix shared data"),
dkT("C\tMultiplexed character device"),
dkT("B\tMultiplexed block device"),
dkT("v\tVXFS compressed file"),
dkT("n\tNetwork special file"),
dkT("w\tWhiteout"),
dkT("a\tACL shadow entry"),
dkT(""),
dkT("On Windows information about a reparse point is shown immediately after"),
dkT("the file type in one character:"),
dkT(""),
dkT("-\tNo reparse point attached."),
dkT("m\tMount point."),
dkT("l\tSymbolic link."),
dkT("r\tAny other reparse point type."),
dkT(""),
dkT("QUOTED FILE NAMES ON WINDOWS"),
dkT(""),
dkT("On Windows the backslash is used both as separator between path components"),
dkT("and to escape certain characters in the shell. Enclosing command arguments"),
dkT("(i.e. file names) in double quotes ensures to pass the text pieces as one"),
dkT("string to the command but additionally activates processing of backslash"),
dkT("escape sequences. The table below gives some examples of processing results"),
dkT("(tested on Windows 7 Prof., 2013-07-23):"),
dkT(""),
dkT("Typed text\t\tPassed to the command as argument"),
dkT("    C:\t\t\t\tC:"),
dkT("    \"C:\"\t\t\tC:"),
dkT("    C:\\\t\t\t\tC:\\"),
dkT("    \"C:\\\"\t\t\tC:\""),
dkT("    C:\\\\\t\t\tC:\\\\"),
dkT("    \"C:\\\\\"\t\t\tC:\\"),
dkT(""),
dkT("In example 4 we want to specify the root directory of a disk drive, enclosed"),
dkT("in double quotes. Unfortunately the end of the directory name (the backslash)"),
dkT("and the closing quote are recognized as a backslash escape sequence by cmd.exe."),
dkT("After processing the backslash escape sequence, a double quote is placed in"),
dkT("the argument string."),
dkT("If you type"),
dkT("  dkt ls \"C:\\\""),
dkT("cmd.exe provides C:\" as file name to the dkt program."),
dkT("So when using double quotes for file names take care of backslash escape"),
dkT("sequences,"),
dkT("  dkt ls \"C:\\\\\""),
dkT("would be correct here as the result of processing the two backslashes"),
dkT("is one remaining backslash."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt ls\" function replaces the kls program from previous dktools versions."),
dkT(""),
NULL


#line 629 "dkt-help.ctr"
};



/**	Default help text for dkt checksum and dkt checksize.
*/
static dkChar const * const dkt_checksum_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt checksum  - Create and verify checksum lists"),
dkT("  dkt checksize - Create and verify file size lists"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt checksum  [<options>] [<arguments>]"),
dkT("  dkt checksize [<options>] [<arguments>]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program creates checksum lists (checksum) or file size lists (checksize)"),
dkT("and verifies actual checksums/sizes against a given list."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-R"),
dkT("\tskips all settings from dkt.conf configuration files."),
dkT(""),
dkT("-i encoding"),
dkT("\tsets up the default input encoding for checksum lists."),
dkT("\tThis encoding is used if no byte order marker is found at the"),
dkT("\tbeginning of input."),
dkT(""),
dkT("-p"),
dkT("\tshortcut for \"-i ascii\"."),
dkT(""),
dkT("-c"),
dkT("\tverify checksums against a given list. Command line arguments are"),
dkT("\tfile names containing checksum lists. If no file name is specified"),
dkT("\ton the command line the checksum list is read from standard input."),
dkT("\tWithout the \"-c\" option the program generates a checksum list."),
dkT("\tCommand line arguments are file names of files to checksum"),
dkT("\texcept the \"-l\" option is used."),
dkT(""),
dkT("-l"),
dkT("\tWhen generating checksum lists the command line arguments are"),
dkT("\tfiles containing file name lists. If no command line arguments"),
dkT("\tare specified the file name list is read from standard input."),
dkT(""),
dkT("-m digest.encoding"),
dkT("\tchooses a message digest algorithm and an encoding for checksums."),
dkT("\tThe following message digest algorithms can be used:"),
dkT("\tMD5\t\tRSA Data Security, Inc. MD5 Message Digest Algorithm"),
dkT("\t\t\t(RFC 1321)"),
dkT("\tSHA-1\t\tSHA-Algorithms"),
dkT("\tSHA-224\t\t(FIPS publications)"),
dkT("\tSHA-256"),
dkT("\tSHA-384"),
dkT("\tSHA-512"),
dkT("\tRIPEMD-160\tCryptographic hash function by Hans Dobbertin,"),
dkT("\t\t\tAntoon Bosselaers and Bart Preneel."),
dkT("\tThe following encodings can be used to convert the binary message"),
dkT("\tdigest data to text:"),
dkT("\tHEX\t\tHexadecimal representation"),
dkT("\t\t\t(creates 2 text bytes for each binary byte)."),
dkT("\tASCII-85\tASCII-85-Encoding"),
dkT("\t\t\t(creates 5 text bytes for each four binary bytes)."),
dkT("\tR-ASCII-85\tReverse ASCII-85-Encoding"),
dkT("\t\t\t(creates 5 text bytes for each four binary bytes)."),
dkT(""),
dkT("-v"),
dkT("\tchooses verbose mode for checksum list verification."),
dkT("\tMessages are printed for both succeeded and failed tests."),
dkT("\tWithout this option the program prints messages for failed tests"),
dkT("\tonly."),
dkT(""),
dkT("-q"),
dkT("\tchooses quiet mode for checksum list verification."),
dkT("\tNo messages are printed, only the exit status code is set."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt checksum\" and \"dkt checksize\" functions replace the fchksum and"),
dkT("fchksize programs from previous dktools versions."),
dkT(""),
NULL


#line 724 "dkt-help.ctr"
};



/**	Default help text for dkt blocksize.
*/
static dkChar const * const dkt_blocksize_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt blocksize - Adjust block size"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt blocksize <option(s)>"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program reads input from standard input or from the named files"),
dkT("and write output to standard output as a sequence of fixed-size blocks."),
dkT("This can be used to provide input data for the \"dd\" program."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-R"),
dkT("\tskips all settings from dkt.conf configuration files."),
dkT(""),
dkT("-b size"),
dkT("\tspecifies the block size."),
dkT("\tYou can apppend `k', `M' or `G' to the size for"),
dkT("\tKibibypte (1024 bytes) or Mibibyte (1048576 bytes)"),
dkT("\tor Gigibyte (1073741824 bytes)."),
dkT("\tThe recommended size is 4k for traditional hard disks,"),
dkT("\t1M for SSD."),
dkT(""),
dkT("-s"),
dkT("\tuses simple file I/O functions (read()/write())."),
dkT("\tThis might result in a better performance than using the default"),
dkT("\tdk3sf_read_app()/dk3sf_write_app() functions but on errors the"),
dkT("\tdiagnostic messages will be less informative."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt blocksize\" function replaces the blksize or blks program from"),
dkT("previous dktools versions."),
dkT(""),
NULL


#line 780 "dkt-help.ctr"
};



/**	Default help text for dkt hex and dkt octal.
*/
static dkChar const * const dkt_hex_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt hex   - Show file contents in hexadecimal representation"),
dkT("  dkt octal - Show file contents in octal representation"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt hex   [<option(s)>] [<file(s)>]"),
dkT("  dkt octal [<option(s)>] [<file(s)>]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program shows the contents of the specified file(s) in hexadecimal"),
dkT("or octal representation."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-a"),
dkT("\tshow address information."),
dkT(""),
dkT("-t"),
dkT("\tshow printable characters as text too."),
dkT(""),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt hex\" and \"dkt octal\" functions replace the showhex program from"),
dkT("previous dktools versions."),
dkT(""),
NULL


#line 827 "dkt-help.ctr"
};



/**	Default help text for dkt tape-set and dkt tape.
*/
static dkChar const * const dkt_tape_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt tape-set    - Tape set management"),
dkT("  dkt tape        - Tape management"),
dkT("  dkt tape-report - Report backup media use."),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt tape-set    get|confirm [<option(s)>] <file>"),
dkT("  dkt tape        get|confirm [<option(s)>] <file>"),
dkT("  dkt tape-report [<options>] <file>"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program can be used for backup media management."),
dkT(""),
dkT("A backup set is a group of files/directories written together to one"),
dkT("backup media."),
dkT("For each backup set there is a corresponding media set (tape set) of"),
dkT("10 backup media (tapes, CD-RWs, DVD-RWs...)."),
dkT(""),
dkT("In a cycle of 200 backups each of the media is used 20 times. Order of"),
dkT("media usage varies, so we some backups of the last few days and some older"),
dkT("backups at each time. The rotation scheme is known as \"10 tape rotation scheme\""),
dkT("in the literature."),
dkT(""),
dkT("On a computer you might have different backup sets (i.e. one set \"A\" for the"),
dkT("configuration files and another set \"B\" for user home directories)."),
dkT("We can write a tape set file \"tapeset.txt\" listing the order of backup sets."),
dkT("To back up A once a week and B four times a week we write"),
dkT(""),
dkT("A B B B B"),
dkT(""),
dkT("Now we can use"),
dkT(""),
dkT("  dkt tape-set get tapeset.txt"),
dkT(""),
dkT("to find the current tape set."),
dkT("The program writes the name of the current set to standard output."),
dkT("After doing a backup successfully we use"),
dkT(""),
dkT("  dkt tape-set confirm tapeset.txt"),
dkT(""),
dkT("to confirm the backup. The file is rewritten, number of the next set index"),
dkT("is in the second line."),
dkT(""),
dkT("If we want to find the current tape number for set A we use"),
dkT(""),
dkT("  dkt tape get tape-A.txt"),
dkT(""),
dkT("The program writes the number to standard output. If the file \"tape-A.txt\""),
dkT("does not yet exist the program assumes no backup was made yet for this set."),
dkT("After doing a backup successfully we use"),
dkT(""),
dkT("  dkt tape confirm tape-A.txt"),
dkT(""),
dkT("to confirm the backup. The file is rewritten, the number of the next tape"),
dkT("and the usage date for the current tape are updated."),
dkT(""),
dkT("The"),
dkT(""),
dkT("  dkt tape-report tape-A.txt"),
dkT(""),
dkT("command lists the backup media numbers by last confirmation timestamp."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-R"),
dkT("\tskips all settings from dkt.conf configuration files."),
dkT(""),
dkT("-f encoding"),
dkT("\tsets up the default file encoding. This encoding is used if no"),
dkT("\tbyte order marker is found at the beginning of the file."),
dkT(""),
dkT("-p"),
dkT("\tshortcut for \"-i ascii\"."),
dkT(""),
dkT("-a"),
dkT("\tuse ASCII encoding when printing set name or media number"),
dkT("\tto standard output (only tape and tapeset commands)."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt tape\" and \"dkt tape-set\" functions replace the tape program from"),
dkT("previous dktools versions."),
dkT(""),
NULL


#line 931 "dkt-help.ctr"
};



/**	Default help text for dkt create-password.
*/
static dkChar const * const dkt_crp_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt create-password - Suggest password"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt create-password [<options>]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program suggests passwords."),
dkT("Different password types are available:"),
dkT(""),
dkT("- simple"),
dkT("  Password length, number of digits, number of special characters and"),
dkT("  number of upper-case characters must be specified."),
dkT(""),
dkT("- hex"),
dkT("  The program uses a pseudo random number generator (PRNG) to obtain"),
dkT("  binary random data. The ASCII-Hex encoding is used to convert the binary"),
dkT("  data to text. Passwords contain the digits '0'...'9' and the characters"),
dkT("  'a'...'f'."),
dkT(""),
dkT("- ascii-85"),
dkT("  The program obtains binary random data from a PRNG and converts it to text"),
dkT("  using the reverse ASCII-85 encoding. The alphabet for passwords contains"),
dkT("  85 characters."),
dkT(""),
dkT("A password class contains all information needed to build a password (type,"),
dkT("length and - for the \"simple\" type - number of digits, special characters"),
dkT("and upper-case characters)."),
dkT("The classes \"user\", \"admin\" and \"wpa\" are predefined, you can define your own"),
dkT("classes in the dkt.conf configuration file."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-R"),
dkT("\tskips all settings from dkt.conf configuration files."),
dkT(""),
dkT("-c class"),
dkT("\tchooses a password class."),
dkT(""),
dkT("-t type"),
dkT("\tchooses a password type."),
dkT(""),
dkT("-l length"),
dkT("\tsets the password length."),
dkT(""),
dkT("-d digits"),
dkT("\tsets the number of digits."),
dkT(""),
dkT("-s specials"),
dkT("\tsets the number of special characters."),
dkT(""),
dkT("-u upper-case"),
dkT("\tsets the number of upper-case characters."),
dkT(""),
dkT("Length, digits, specials and upper-case can be specified as number (i.e. \"2\")"),
dkT("or range (i.e. \"2-4\")."),
dkT("The minimum length must be at least the summary of the maximum values for"),
dkT("digits, specials and upper-case."),
dkT(""),
dkT(""),
dkT("FILES"),
dkT(""),
dkT("dkt.conf"),
dkT("  You can define additional password classes in the dkt.conf configuration"),
dkT("  file, i.e."),
dkT(""),
dkT("  [create-password]"),
dkT("  class=pin6,type=simple,length=6,digits=6,specials=0,upper-case=0"),
dkT(""),
dkT("  The \"class=\" text introduces a class definition, \"pin6\" is the name of the"),
dkT("  new class here."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt create-password\" functionality replaces the createp program from"),
dkT("previous dktools versions."),
dkT(""),
NULL


#line 1029 "dkt-help.ctr"
};



/**	Default help text for dkt uid.
*/
static dkChar const * const dkt_uid_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt uid - Find free user ID in a range"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt uid [<option>] <minimum> <maximum>"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program searches for the first free user ID in a given range and prints"),
dkT("it to standard output."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-a"),
dkT("\tprints all free UIDs in the range."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt uid\" function replaces the uid program from previous dktools"),
dkT("versions."),
dkT(""),
NULL


#line 1070 "dkt-help.ctr"
};



/**	Default help text for dkt erase-disk.
*/
static dkChar const * const dkt_ed_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt erase-disk - Generate data stream to overwrite a hard disk"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt erase-disk [<options>]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program creates a data stream which can be used as input to \"dd\" to"),
dkT("overwrite an entire disk."),
dkT("A pass number can be specified to choose a byte value written to the disk:"),
dkT(""),
dkT("Pass\tByte"),
dkT("  0\t0x00"),
dkT("  1\t0xFF"),
dkT("  2\t0x0F"),
dkT("  3\t0xF0"),
dkT("  4\t0x33"),
dkT("  5\t0xCC"),
dkT("  6\t0x55"),
dkT("  7\t0xAA"),
dkT(""),
dkT("Use pass numbers from 7 ... 0 to set and reset each bit several times."),
dkT("For normal usage scenarios one pass using pass number 0 should be sufficient."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-p pass"),
dkT("\tchooses the pass number."),
dkT(""),
dkT("-b size"),
dkT("\tspecifies the block size (default: 512)."),
dkT(""),
dkT("-n number"),
dkT("\tspecifies the number of blocks (default: 0 for an \"endless\" sequence)."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt erase-disk\" function replaces the edbp program from previous"),
dkT("dktools versions."),
dkT(""),
NULL


#line 1132 "dkt-help.ctr"
};



/**	Default help text for dkt random.
*/
static dkChar const * const dkt_rand_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("  dkt random - Generate random data"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  dkt random [<option(s)>]"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program produces a data stream of pseudo random data."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-b size"),
dkT("\tsets the block size (default: 512)."),
dkT(""),
dkT("-n number"),
dkT("\tsets the number of blocks (default: 1)."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns 0 on success, any other value indicates an error."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dirk Krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("The \"dkt random\" functionality replaces the rndbytes program from previous"),
dkT("dktools versions."),
dkT(""),
NULL


#line 1175 "dkt-help.ctr"
};



int
dkt_help(
  dk3_app_t		*app,
  dkChar const		*sn,
  dkChar const * const	*msg,
  dkChar const * const	*kwnl,
  int			 htp
)
{
  int back	= DKT_RESULT_OK;
  

#line 1190 "dkt-help.ctr"
  switch(htp) {
    case 0: case 1: {			

#line 1192 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3blks.txt"), dkt_blocksize_help_text);
    } break;
    case 2: case 3: {			

#line 1195 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3chks.txt"), dkt_checksum_help_text);
    } break;
    case 4: case 5: {			

#line 1198 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3crp.txt"), dkt_crp_help_text);
    } break;
    case 6: {				

#line 1201 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3pwd.txt"), dkt_pwd_help_text);
    } break;
    case 7: case 8: {			

#line 1204 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3hex.txt"), dkt_hex_help_text);
    } break;
    case 9: case 10: {			

#line 1207 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3hex.txt"), dkt_hex_help_text);
    } break;
    case 11: case 12: {			

#line 1210 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3html.txt"), dkt_html_help_text);
    } break;
    case 13: case 14: {			

#line 1213 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3lat.txt"), dkt_latex_help_text);
    } break;
    case 15: {				

#line 1216 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3ls.txt"), dkt_ls_help_text);
    } break;	
    case 16: {				

#line 1219 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3sort.txt"), dkt_sort_help_text);
    } break;
    case 17: case 18: {			

#line 1222 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3tape.txt"), dkt_tape_help_text);
    } break;
    case 19 :{				

#line 1225 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3tape.txt"), dkt_tape_help_text);
    } break;
    case 39: case 40: {
      dk3app_help(app, dkT("dkt3tape.txt"), dkt_tape_help_text);
    } break;
    case 20: {				

#line 1231 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3uid.txt"), dkt_uid_help_text);
    } break;
    case 21: case 22: {			

#line 1234 "dkt-help.ctr"
    } break;
    case 23: case 24: {			

#line 1236 "dkt-help.ctr"
    } break;
    case 25: case 26: {			

#line 1238 "dkt-help.ctr"
    } break;
    case 27: {				

#line 1240 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3cat.txt"), dkt_cat_help_text);
    } break;
    case 28: {				

#line 1243 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3chks.txt"), dkt_checksum_help_text);
    } break;
    case 29: case 30: {			

#line 1246 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3ed.txt"), dkt_ed_help_text);
    } break;
    case 31: case 32: case 33: {	

#line 1249 "dkt-help.ctr"
      dk3app_help(app, dkT("dkt3rand.txt"), dkt_rand_help_text);
    } break;
    default: {
      dk3app_help(app, dkT("dkt3.txt"), dkt_help_text);
    } break;
  } 

#line 1255 "dkt-help.ctr"
  return back;
}



/* vim: set ai sw=2 : */
