/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dknet.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dknet.h Header file for the dknet module.
*/

#ifndef DKNET_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKNET_H_INCLUDED 1


#line 10 "dknet.ctr"

#include "dk3all.h"
#include "dkt-version.h"
#include "dk3sock.h"



/**	Job structue for dknet.
*/
typedef struct {
  dk3_app_t		*app;	/**< Application structure. */
  dkChar const * const	*msg;	/**< Localized message texts. */
  dk3_sto_t		*ssess;	/**< Storage for sessions. */
  dk3_sto_it_t		*isess;	/**< Iterator through sessions storage. */
  dk3_sto_t		*sacl;	/**< Storage for acceptable clients. */
  dk3_sto_it_t		*iacl;	/**< Iterator for acceptable clients storage. */
  dkChar const		*hn;	/**< Host name to connect to. */
  dkChar const		*fn;	/**< File name to send or receive. */
  dkChar const		*rfn;	/**< Real file name (after expansion). */
  FILE			*fipo;	/**< Input file. */
  unsigned long		 flush;	/**< Number of network reads per file flush. */
  int			 cmd;	/**< Command to execute, see @ref dknetcmd. */
  int			 exval;	/**< Exit status code. */
  int			 clmax;	/**< Maximum number of clients. */
  int			 clcur;	/**< Current number of connected clients. */
  int			 stt;	/**< Flag: Start transfer. */
  int			 blog;	/**< Listen backlog. */
  int			 llerr;	/**< Log level for stderr. */
  unsigned short	 nport;	/**< Port number to connect to. */
} dknet_job;



/**	One session connection.
*/
typedef struct {
  dk3_socket_t		ss;	/**< Session socket. */
  int			ec;	/**< Error code (0 on success). */
} dknet_session;



/**	@defgroup	dknetcmd	Command to execute during dknet job.
*/
/**@{*/

/**	Operation:	Receive data.
*/
#define	DKNET_CMD_RECEIVE		1

/**	Operation:	Send data.
*/
#define	DKNET_CMD_SEND			2

/**	Operation:	Show help text.
*/
#define	DKNET_CMD_HELP			4

/**	Operation:	Show version number.
*/
#define	DKNET_CMD_VERSION		8

/**	Operation:	Show license terms.
*/
#define	DKNET_CMD_LICENSE		16
/**@}*/



/**	@defgroup	dknetexitcodes	Exit codes for dknet.
*/
/**@{*/

/**	Exit status code: No error.
*/
#define	DKNET_EXIT_OK			0

/**	Exit status code: Error occured, no further information.
*/
#define	DKNET_EXIT_ERROR_ANY		1

/**	Exit status code: Not enough memory.
*/
#define	DKNET_EXIT_ERROR_MEMORY		2

/**	Exit status code: Error in command line arguments.
*/
#define	DKNET_EXIT_ERROR_OPTIONS	3

/**	Exit status code: Failed to open/read/write input or output file.
*/
#define	DKNET_EXIT_ERROR_IO		4

/**	Exit status code: Failed to initialize WinSock.
*/
#define	DKNET_EXIT_ERROR_WINSOCK	5

/**	Exit status code: Error in network operation.
*/
#define	DKNET_EXIT_ERROR_NETWORK	6

/**@}*/




#endif
