
#ifndef DKCT_H_INCLUDED
#define DKCT_H_INCLUDED 1

#define	DKCT_STYLE_GCC		0


#include "dk3all.h"
#include "dkt.h"
#include "dkt-version.h"


/**	Option set for dkct.
 * 	The configuration dialog of dkwxtrace must set this.
 */
typedef struct {
  int		deb;	/**< Debug: 0=no debug, 1=file, 2=stdout. */
  int		deben;	/**< Flag: Debugging enabled. */
  int		lnn;	/**< Show line numbers. */
  int		mak;	/**< Make mode. */
  int		sty;	/**< Style for Output to stdout (DKCT_STYLE_xxx). */
  int		bw;	/**< Box width. */
  int		tkw;	/**< Flag: Add trace keyword. */
  int		ts;	/**< Flag: Print timestamp. */
  int		win;	/**< Flag: Add support for Windows wide chars. */
  int		tip;	/**< Flag: trace include printed. */
  char		spls;	/**< Splint special character. */
} DKCT_OPTION_SET;



/**	Job structure for dkct.
*/
typedef struct {
  DKCT_OPTION_SET	dkcto;	/**< Conversion options. */
  dk3_app_t		*app;	/**< Application. */
  dkChar const * const	*msg;	/**< Localized texts. */
  dkChar const * const	*nlc;	/**< Non-localized keywords. */
  dk3_option_set_t	*opt;	/**< Command line options. */
  dkChar const		*sCwd;	/**< Current working directory. */
  int			 exval;	/**< Exit status code. */
  int			 cmd;	/**< Command. */
  int			 curdi;	/**< Flag: Processing the current directory. */
} DKCT_J;



#include "dkct-tr.h"
#include "dkct-to.h"
#include "dkct-gui.h"
#include "dkct-str.h"



/**	Buffer size for input lines.
*/
#define	DKCT_LINE_SIZE	4096


#endif

