/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dkct-gui.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dkct-gui.h Header file for the dkct-gui module.
*/

#ifndef DKCT_GUI_H_INCLUDED
/** Avoid multiple inclusions. */
#define DKCT_GUI_H_INCLUDED 1


#line 8 "dkct-gui.ctr"

/**	@defgroup	dkctguiconst	Constants for GUI layout.
The alignment decides where to place an object if there is more
room available for the object than necessary.
*/
/**@{*/

/**	Mask to retrieve horizontal alignment.
*/
#define	DKCT_GUI_ALIGN_H_MASK	0x03

/**	Horizontal alignment: Left.
*/
#define	DKCT_GUI_ALIGN_H_LEFT	0x01

/**	Horizontal alignment: Centered.
*/
#define	DKCT_GUI_ALIGN_H_CENTER	0x02

/**	Horizontal alignment: Right.
*/
#define	DKCT_GUI_ALIGN_H_RIGHT	0x03

/**	Mask to find vertical alignment.
*/
#define	DKCT_GUI_ALIGN_V_MASK	0x0C

/**	Vertical alignment: Top.
*/
#define	DKCT_GUI_ALIGN_V_TOP	0x04

/**	Vertical alignment: Centered.
*/
#define	DKCT_GUI_ALIGN_V_CENTER	0x08

/**	Vertical alignment: bottom.
*/
#define	DKCT_GUI_ALIGN_V_BOTTOM	0x0C

/**	Processing state for element: Nothing done yet.
*/
#define	DKCT_GUI_PROCESSING_STATE_START		0

/**	Processing state for element: Processing the menu bar.
*/
#define DKCT_GUI_PROCESSING_STATE_MENU		1

/**	Processing state for element: Processing the tool bar.
*/
#define	DKCT_GUI_PROCESSING_STATE_TOOL		2

/**	Processing state for element: Processing the contents.
*/
#define	DKCT_GUI_PROCESSING_STATE_CONTENTS	3

/**	Processing state for element: Finished processing.
*/
#define	DKCT_GUI_PROCESSING_STATE_DONE		4

/**	Left to right sizer.
*/
#define	DKCT_GUI_DIRECTION_HORIZONTAL	0x00

/**	Top to bottom sizer.
*/
#define	DKCT_GUI_DIRECTION_VERTICAL	0x01

/**	Scrollbars for both directions.
*/
#define	DKCT_GUI_DIRECTION_BOTH		0x02

/**	Don't set border pixel number.
*/
#define	DKCT_GUI_BORDER_POSITION_NONE		0x00

/**	Set border pixel number on top side.
*/
#define DKCT_GUI_BORDER_POSITION_TOP		0x01

/**	Set border pixel number on left side.
*/
#define DKCT_GUI_BORDER_POSITION_LEFT		0x02

/**	Set border pixel number on right side.
*/
#define DKCT_GUI_BORDER_POSITION_RIGHT		0x04

/**	Set border pixel number on bottom side.
*/
#define DKCT_GUI_BORDER_POSITION_BOTTOM		0x08

/**	Set border pixel number on all sides.
*/
#define DKCT_GUI_BORDER_POSITION_ALL		0x0F

/**	List selection: Allow selection of only one element.
*/
#define	DKCT_GUI_SELECTION_STYLE_SINGLE		0x00

/**	List selection: Allow selection of multiple elements.
*/
#define	DKCT_GUI_SELECTION_STYLE_MULTIPLE	0x01

/**	List selection: Allow CTRL/SHIFT-click.
*/
#define	DKCT_GUI_SELECTION_STYLE_EXTENDED	0x02

/**	Radio box max dimension: columns.
*/
#define	DKCT_GUI_RB_DIR_COLUMNS			0x00

/**	Radio box max dimension: rows.
*/
#define	DKCT_GUI_RB_DIR_ROWS			0x01

/**	Slider style: Automatic tics.
*/
#define	DKCT_GUI_SL_STYLE_AUTOTICKS		0x01

/**	Slider style: Show labels
*/
#define DKCT_GUI_SL_STYLE_LABELS		0x02

/**	Slider style: Tics left.
*/
#define DKCT_GUI_SL_STYLE_LEFT			0x04

/**	Slider style: Tics right.
*/
#define DKCT_GUI_SL_STYLE_RIGHT			0x08

/**	Slider style: Tics top.
*/
#define DKCT_GUI_SL_STYLE_TOP			0x10

/**	Slider style: Tics bottom.
*/
#define DKCT_GUI_SL_STYLE_BOTTOM		0x20

/**	Slider style: Range selection allowed.
*/
#define DKCT_GUI_SL_STYLE_SELRANGE		0x40

/**	Slider style: Inverse endpoints.
*/
#define DKCT_GUI_SL_STYLE_INVERSE		0x80

/**	Text control style: Enter is line break, not OK command.
*/
#define	DKCT_GUI_TEXT_ENTER			0x00001UL

/**	Text control style: Insert tabulators in text, do not pass to next ctrl.
*/
#define DKCT_GUI_TEXT_TAB			0x00002UL

/**	Text control style: Multiple lines of text.
*/
#define DKCT_GUI_TEXT_MULTILINE			0x00004UL

/**	Text control style: Text shown as asterisks.
*/
#define DKCT_GUI_TEXT_PASSWORD			0x00008UL

/**	Text control style: Not editable.
*/
#define DKCT_GUI_TEXT_READONLY			0x00010UL

/**	Text control style: Rich-text control.
*/
#define DKCT_GUI_TEXT_RICH			0x00020UL

/**	Text control style: Richt-text control, higher version.
*/
#define DKCT_GUI_TEXT_RICH2			0x00040UL

/**	Text control style: Show URLs.
*/
#define DKCT_GUI_TEXT_URL			0x00080UL

/**	Text control style: Always show selection.
*/
#define DKCT_GUI_TEXT_SHOWSEL			0x00100UL

/**	Text control style: Left aligned.
*/
#define DKCT_GUI_TEXT_LEFT			0x00200UL

/**	Text control style: Centered.
*/
#define DKCT_GUI_TEXT_CENTRE			0x00400UL

/**	Text control style: Right aligned.
*/
#define DKCT_GUI_TEXT_RIGHT			0x00800UL

/**	Text control style: Do not wrap text.
*/
#define DKCT_GUI_TEXT_NOWRAP			0x01000UL

/**	Text control style: Wrap characters.
*/
#define DKCT_GUI_TEXT_CHARWRAP			0x02000UL

/**	Text control style: Wrap at word boundaries.
*/
#define DKCT_GUI_TEXT_WORDWRAP			0x04000UL

/**	Text control style: Best wrapping.
*/
#define	DKCT_GUI_TEXT_BESTWRAP			0x08000UL

/**	Text control style: Capitalized first letters.
*/
#define DKCT_GUI_TEXT_CAPITALIZE		0x10000UL

/**	Text control style: No auto-resize.
*/
#define	DKCT_GUI_TEXT_NO_AUTORESIZE		0x20000UL

/**	Notebook style: Tabs on top.
*/
#define	DKCT_GUI_NB_TOP				0x0001U

/**	Notebook style: Tabs on left side.
*/
#define	DKCT_GUI_NB_LEFT			0x0002U

/**	Notebook style: Tabs on right side.
*/
#define DKCT_GUI_NB_RIGHT			0x0004U

/**	Notebook style: Tabs on bottom.
*/
#define DKCT_GUI_NB_BOTTOM			0x0008U

/**	Notebook style: Same width for all tabs.
*/
#define DKCT_GUI_NB_FIXEDWIDTH			0x0010U

/**	Notebook style: Tabs in multiple lines.
*/
#define DKCT_GUI_NB_MULTILINE			0x0020U

/**	Notebook style: Sold color on notebook pages.
*/
#define DKCT_GUI_NB_NOPAGETHEME			0x0040U

/**	Notebook style: Show tabs in a flat style.
*/
#define DKCT_GUI_NB_FLAT			0x0080U

/**	Button style: Label left-justified.
*/
#define	DKCT_GUI_BUTTON_LEFT			0x01

/**	Button style: Label top-justified.
*/
#define DKCT_GUI_BUTTON_TOP			0x02

/**	Button style: Label right-justified.
*/
#define DKCT_GUI_BUTTON_RIGHT			0x04

/**	Button style: Label bottom-justified.
*/
#define DKCT_GUI_BUTTON_BOTTOM			0x08

/**	Button style: Size as small as possible.
*/
#define DKCT_GUI_BUTTON_EXACTFIT		0x10

/**	Button style: No border.
*/
#define DKCT_GUI_BUTTON_NO_BORDER		0x20

/**	Splitter window style: 3D border and sash.
*/
#define	DKCT_GUI_SPLITTERW_3D			0x0001U

/**	Splitter window style: 3D sash.
*/
#define DKCT_GUI_SPLITTERW_3D_SASH		0x0002U

/**	Splitter window style: 3D border.
*/
#define DKCT_GUI_SPLITTERW_3D_BORDER		0x0004U

/**	Splitter window style: Standard border.
*/
#define DKCT_GUI_SPLITTERW_BORDER		0x0008U

/**	Splitter window style: No border.
*/
#define DKCT_GUI_SPLITTERW_NO_BORDER		0x0010U

/**	Splitter window style: No windows XP themes.
*/
#define DKCT_GUI_SPLITTERW_NO_XP_THEME		0x0020U

/**	Splitter window style: Allow to unsplit.
*/
#define DKCT_GUI_SPLITTERW_PERMIT_UNSPLIT	0x0040U

/**	Splitter window style: No xor line, resize children immediately.
*/
#define DKCT_GUI_SPLITTERW_LIVE_UPDATE		0x0080U

/**	Button style: Automatic drawing.
*/
#define	DKCT_GUI_BBUTTON_AUTODRAW		0x01

/**	Button style: Bitmap left-aligned.
*/
#define DKCT_GUI_BBUTTON_LEFT			0x02

/**	Button style: Bitmap top-aligned.
*/
#define DKCT_GUI_BBUTTON_TOP			0x04

/**	Button style: Bitmap right-aligned.
*/
#define DKCT_GUI_BBUTTON_RIGHT			0x08

/**	Button style: Bitmap bottom-aligned.
*/
#define DKCT_GUI_BBUTTON_BOTTOM			0x10

/**	Gauge style: Smooth.
*/
#define	DKCT_GUI_GAUGE_SMOOTH			0x01

/**	Menu item style: normal.
*/
#define	DKCT_GUI_MENU_ITEM_NORMAL		0x00

/**	Menu item style: separator.
*/
#define DKCT_GUI_MENU_ITEM_SEPARATOR		0x01

/**	Menu item style: check button.
*/
#define DKCT_GUI_MENU_ITEM_CHECK		0x02

/**	Menu item style: radio button.
*/
#define DKCT_GUI_MENU_ITEM_RADIO		0x03

/**	Toolbar style: Flat look (no border).
*/
#define	DKCT_GUI_TOOLBAR_FLAT			0x0001U

/**	Toolbar style: Dockable and floatable.
*/
#define	 DKCT_GUI_TOOLBAR_DOCKABLE		0x0002U

/**	Toolbar style: Show text additionally to icons.
*/
#define  DKCT_GUI_TOOLBAR_TEXT			0x0004U

/**	Toolbar style: No icons.
*/
#define  DKCT_GUI_TOOLBAR_NOICONS		0x0008U

/**	Toolbar style: No border above toolbar.
*/
#define  DKCT_GUI_TOOLBAR_NODIVIDER		0x0010U

/**	Toolbar style: No align (not very useful).
*/
#define  DKCT_GUI_TOOLBAR_NOALIGN		0x0020U

/**	Toolbar style: Texts beside icons, not below.
*/
#define  DKCT_GUI_TOOLBAR_HORZ_LAYOUT		0x0040U

/**	Toolbar style: Do not show tool tips.
*/
#define  DKCT_GUI_TOOLBAR_NO_TOOLTIPS		0x0080U

/**	Toolbar style: Bottom side of parent window.
*/
#define  DKCT_GUI_TOOLBAR_BOTTOM		0x0100U

/**	Toolbar style: Right side of parent window.
*/
#define  DKCT_GUI_TOOLBAR_RIGHT			0x0200U

/**@}*/


/**	Grid head (row head or column head in wxGrid).
*/
typedef struct {
  char		*text;	/**< Label text. */
  int		 elno;	/**< Element number. */
} DKCT_GRID_HEAD;



/**	Description for one GUI element.
*/
typedef struct {
  char			*name;		/**< Variable name. */
  char			*cname;		/**< Class name. */
  char			*idname;	/**< ID as text. */
  char			*text;		/**< Element text (label/button). */
  char			*constructor;	/**< Constructor arguments. */
  char			*tipText;	/**< Tool tip text. */
  char			*icon;		/**< Icon for frame. */
  char			*bitmapVarName;	/**< Bitmap variable. */
  char			*bitmapDisabled;	/**< Disabled bitmap. */
  char			*bitmapSelected;	/**< Selected bitmap. */
  char			*bitmapFocus;		/**< Focus bitmap. */
  char			*bitmapHover;		/**< Mouse-over bitmap. */
  char			*choices;	/**< Choices variable. */
  char			*stbText;	/**< Status bar text. */
  char			*validator;	/**< Validator. */
  char			*gridTable;	/**< Table for grid. */
  void			*parent;	/**< Element's parent. */
  void			*menubar;	/**< Menu bar. */
  void			*toolbar;	/**< Tool bar. */
  dk3_sto_t		*s_contents;	/**< Contents elements storage. */
  dk3_sto_it_t		*i_contents;	/**< Contents elements iterator. */
  dk3_sto_t		*sRowHeads;	/**< Row heads in wxGrid. */
  dk3_sto_it_t		*iRowHeads;	/**< Row heads in wxGrid. */
  dk3_sto_t		*sColumnHeads;	/**< Column heads in wxGrid. */
  dk3_sto_it_t		*iColumnHeads;	/**< Column heads in wxGrid. */
  dk3_sto_t		*sGrowRow;	/**< Growable rows. */
  dk3_sto_it_t		*iGrowRow;	/**< Iterator for growable rows. */
  dk3_sto_t		*sGrowCol;	/**< Growable columns. */
  dk3_sto_it_t		*iGrowCol;	/**< Iterator for growable columns. */
  unsigned long		 lndecl;	/**< Line number declaration. */
  unsigned long		 lndef;		/**< Line number definition. */
  unsigned long		 textStyle;	/**< Style for text control. */
  size_t		 number;	/**< Internal dkct object number. */
  size_t		 passno;	/**< Pass number. */
  int			 cln;		/**< Class number. */
  int			 pseudoobj;	/**< Pseudo object code. */
  int			 posx;		/**< X position in gridbag. */
  int			 posy;		/**< Y position in gridbag. */
  int			 spanx;		/**< X span (number of columns) in gridbag. */
  int			 spany;		/**< Y span (number of ows) in gridbag. */
  int			 curx;		/**< Current x position in grid bag. */
  int			 cury;		/**< Current y position in grid bag. */
  int			 sizex;		/**< Object x size (pixels). */
  int			 sizey;		/**< Object y size (pixels). */
  int			 sizemx;	/**< Minimum object x size (pixels). */
  int			 sizemy;	/**< Minimum object y size (pixels). */
  int			 stbsz;		/**< Status bar size. */
  int			 prost;		/**< Processing state. */
  int			 border;	/**< Border pixel number. */
  int			 proportion;	/**< Growth proportion. */
  int			 gridcolumns;	/**< Columns for grid/flexgrid. */
  int			 gridrows;	/**< Rows for grid/flexgrid. */
  int			 gridgapx;	/**< X gap. */
  int			 gridgapy;	/**< Y gap. */
  int			 sash;		/**< Sash for splitter window. */
  int			 minPaneSize;	/**< Minimum splitter pane size. */
  int			 nChoices;	/**< Number of choices. */
  int			 maxRowsCols;	/**< Max rows/columns in radio box. */
  int			 spinMin;	/**< Minimum for spin control. */
  int			 spinMax;	/**< Maximum for spin control. */
  int			 spinVal;	/**< Spin value. */
  int			 nRows;		/**< Number of rows in wxGrid. */
  int			 nColumns;	/**< Number of columns in wxGrid. */
  int			 nRowHeads;	/**< Number of row heads in wxGrid. */
  int			 nColumnHeads;	/**< Number of col heads in wxGrid. */
  unsigned		 notebookStyle;	/**< Notebook style. */
  unsigned		 splitterStyle;	/**< Splitter window style. */
  unsigned		 toolbarStyle;	/**< Toolbar style. */
  unsigned char		 align;		/**< Alignment. */
  unsigned char		 direction;	/**< Box sizer direction. */
  unsigned char		 borderPos;	/**< Border position. */
  unsigned char		 expandFlag;	/**< Flag: Expand object. */
  unsigned char		 nStates;	/**< Number of states for checkbox. */
  unsigned char		 state;		/**< Checkbox state. */
  unsigned char		 selStyle;	/**< Selection style. */
  unsigned char		 rbDirection;	/**< Direction for max size. */
  unsigned char		 startGroup;	/**< Flag: Start radio button group. */
  unsigned char		 spinWrap;	/**< Flag: Wrap spin control. */
  unsigned char		 useKeys;	/**< Flag: Use keys. */
  unsigned char		 sliderStyle;	/**< Slider style. */
  unsigned char		 buttonStyle;	/**< Button style. */
  unsigned char		 bitmapbStyle;	/**< Bitmap button style. */
  unsigned char		 gaugeStyle;	/**< Gauge style. */
  unsigned char		 menuItemStyle;	/**< Menu item style. */
  unsigned char		 tableOwner;	/**< Flag: Grid is table owner. */
  unsigned char		 compConst;	/**< Flag: Complete constructor. */
} DKCT_GUI_ELEMENT;



/**	Description for one frame or dialog.
*/
typedef struct {
  DKCT_SRC		*psrc;		/**< Source structure. */
  DKCT_GUI_ELEMENT	*c_el;		/**< Current element to configure. */
  DKCT_GUI_ELEMENT	*r_el;		/**< Root element. */
  dk3_sto_t		*s_el_by_name;	/**< Storage for elements by name. */
  dk3_sto_it_t		*i_el_by_name;	/**< Iterator for elements by name. */
  dk3_sto_t		*s_el_by_num;	/**< Storage for elements by number. */
  dk3_sto_it_t		*i_el_by_num;	/**< Iterator for elements by number. */
  size_t		 no;		/**< Number of objects already found. */
  unsigned char		 align;		/**< Default align. */
} DKCT_GUI;


#ifdef __cplusplus
extern "C" {
#endif

/**	Create new GUI description, allocate memory.
	@param	psrc	Source structure.
	@return	Pointer to new GUI description on success, NULL on error.
*/
DKCT_GUI *
dkct_gui_new(DKCT_SRC *psrc);

/**	Destroy GUI description, release memory.
	@param	pg	GUI description to destroy.
*/
void
dkct_gui_delete(DKCT_GUI *pg);

/**	Add one input line.
	@param	gui	GUI description.
	@param	il	Input line to add.
	@return	1 on success, 0 on error.
*/
int
dkct_gui_add_line(DKCT_GUI *gui, char *il);

/**	Check GUI consistency.
	@param	psrc	Source structure.
	@return	1 on success, 0 on error.
*/
int
dkct_gui_check(DKCT_SRC *psrc);

/**	Write class member variables.
	@param	psrc	Source structure.
*/
void
dkct_gui_class_variables(DKCT_SRC *psrc);

/**	Write constructor for current  class.
	@param	psrc	Source structure.
*/
void
dkct_gui_write_constructor(DKCT_SRC *psrc);

#ifdef __cplusplus
}
#endif




#endif
