/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dkct-gui.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dkct-gui.c The dkct-gui module.
*/


#line 566 "dkct-gui.ctr"

#if DK3_USE_WX
#include "dkwxtrace.h"
#else
#include "dkct.h"
#endif



#line 574 "dkct-gui.ctr"



/**	Class names for GUI elements.
*/
static char const * const dkct_gui_class_names[] = {
/*   0 */ "wxFrame",
/*   1 */ "wxDialog",
/*   2 */ "wxMDIParentFrame",
/*   3 */ "wxMDIChildFrame",
/*   4 */ "wxPopupWindow",
/*   5 */ "wxBoxSizer",
/*   6 */ "wxFlexGridSizer",
/*   7 */ "wxGridBagSizer",
/*   8 */ "wxGridSizer",
/*   9 */ "wxStaticBoxSizer",
/*  10 */ "wxStdDialogButtonSizer",
/*  11 */ "wxPanel",
/*  12 */ "wxNotebook",
/*  13 */ "wxScrolledWindow",
/*  14 */ "wxSplitterWindow",
/*  15 */ "wxButton",
/*  16 */ "wxBitmapButton",
/*  17 */ "wxChoice",
/*  18 */ "wxComboBox",
/*  19 */ "wxCheckBox",
/*  20 */ "wxListBox",
/*  21 */ "wxCheckListBox",
/*  22 */ "wxRadioBox",
/*  23 */ "wxRadioButton",
/*  24 */ "wxScrollBar",
/*  25 */ "wxSpinButton",
/*  26 */ "wxSpinCtrl",
/*  27 */ "wxSlider",
/*  28 */ "wxTextCtrl",
/*  29 */ "wxToggleButton",
/*  30 */ "wxGauge",
/*  31 */ "wxStaticText",
/*  32 */ "wxStaticBitmap",
/*  33 */ "wxStaticLine",
/*  34 */ "wxStaticBox",
/*  35 */ "wxMenuBar",
/*  36 */ "wxMenu",
/*  37 */ "wxMenuItem",
/*  38 */ "wxToolBar",
/*  39 */ "wxStatusBar",
/*  40 */ "wxToolBarToolBase",	/* Not a wxWidgets class! */
/*  41 */ "wxGrid",
NULL
};



/**	Option names.
*/
static char const * const dkct_gui_option_keys[] = {
/*   0 */ "align",
NULL
};



/**	Checkbox state names.
*/
static char const * const dkct_gui_db_state_names[] = {
/*  0 */ "unchecked",
/*  1 */ "checked",
/*  2 */ "undetermined",
NULL
};



/**	Table selection mode names.
*/
static char const * const dkct_gui_cb_sel_names[]= {
/*  0 */ "single",
/*  1 */ "multiple",
/*  2 */ "extended",
NULL
};



/**	Style property names for slider.
*/
static char const * const dkct_gui_slider_style_names[] = {
/*  0 */ "ticks",
/*  1 */ "labels",
/*  2 */ "left",
/*  3 */ "right",
/*  4 */ "top",
/*  5 */ "bottom",
/*  6 */ "range",
/*  7 */ "inverse",
NULL
};



/**	Style property names for text control.
*/
static char const * const dkct_gui_text_style_names[] = {
/*  0 */ "enter",
/*  1 */ "tab",
/*  2 */ "multiline",
/*  3 */ "password",
/*  4 */ "readonly",
/*  5 */ "rich",
/*  6 */ "rich2",
/*  7 */ "url",
/*  8 */ "selection",
/*  9 */ "left",
/* 10 */ "centered",
/* 11 */ "right",
/* 12 */ "no-wrap",
/* 13 */ "char-wrap",
/* 14 */ "word-wrap",
/* 15 */ "best-wrap",
/* 16 */ "capitalize",
/* 17 */ "no-auto-resize",
NULL
};



/**	Style property names for notebook.
*/
static char const * const dkct_gui_notebook_style_names[] = {
/*  0 */ "top",
/*  1 */ "left",
/*  2 */ "right",
/*  3 */ "bottom",
/*  4 */ "fixed-width",
/*  5 */ "multiline",
/*  6 */ "no-theme",
/*  7 */ "flat",
NULL
};



/**	Style property names for splitter window.
*/
static char const * const dkct_gui_splitterw_style_names[] = {
/*   0 */ "3d",
/*   1 */ "3d-sash",
/*   2 */ "3d-border",
/*   3 */ "border",
/*   4 */ "no-border",
/*   5 */ "no-xp-theme",
/*   6 */ "permit-unsplit",
/*   7 */ "live-update",
NULL
};



/**	Style property names for bitmap button.
*/
static char const * const dkct_gui_bitmapb_style_names[] = {
/*  0 */ "auto-draw",
/*  1 */ "left",
/*  2 */ "top",
/*  3 */ "right",
/*  4 */ "bottom",
NULL
};



/**	Style property names for gauge.
*/
static char const * const dkct_gui_gauge_style_names[] = {
/*  0 */ "smooth",
NULL
};



/**	Style property names for menu item.
*/
static char const * const dkct_gui_menu_item_style_names[] = {
/*  0 */ "normal",
/*  1 */ "separator",
/*  2 */ "check",
/*  3 */ "radio",
NULL
};



/**	Style property names for toolbar.
*/
static char const * const dkct_gui_toolbar_style_names[] = {
/*  0 */ "flat",
/*  1 */ "dockable",
/*  2 */ "text",
/*  3 */ "no-icons",
/*  4 */ "no-divider",
/*  5 */ "horizontal-layout",
/*  6 */ "no-tooltips",
/*  7 */ "bottom",
/*  8 */ "right",
NULL
};



/**	Style property names for button.
*/
static char const * const dkct_gui_notebook_button_names[] = {
/*  0 */ "left",
/*  1 */ "top",
/*  2 */ "right",
/*  3 */ "bottom",
/*  4 */ "fit",
/*  5 */ "no-border",
NULL
};



/**	Names for alignment.
*/
static char const * const dkct_gui_align_names[] = {
/* 0 */ "left",
/* 1 */ "right",
/* 2 */ "top",
/* 3 */ "bottom",
/* 4 */ "centered",
/* 5 */ "centered-x",
/* 6 */ "centered-y",
NULL
};



/**	Names for border positions.
*/
static char const * const dkct_gui_border_position_names[] = {
/*  0 */ "all",
/*  1 */ "top",
/*  2 */ "left",
/*  3 */ "right",
/*  4 */ "bottom",
NULL
};



/**	Names of pseudo objects.
*/
static char const * const dkct_gui_pseudo_object_names[] = {
/*   0 */ "$stretch",		/* Stretch spacer. */
/*   1 */ "$space",		/* Spacer. */
/*   2 */ "$separator",		/* Separator in menus. */
NULL
};



/**	Base type names for the root object.
*/
static char const * const dkct_gui_base_type_names[] = {
"frame",
"dialog",
NULL
};



/**	Attribute names.
*/
static char const * const dkct_gui_attribute_keys[] = {
/*   0 */ "expand",
/*   1 */ "type",
/*   2 */ "menu-bar",
/*   3 */ "tool-bar",
/*   4 */ "status-bar",
/*   5 */ "contents",
/*   6 */ "text",
/*   7 */ "id",
/*   8 */ "tip",
/*   9 */ "proportion",
/*  10 */ "status-text",
/*  11 */ "border",
/*  12 */ "constructor",
/*  13 */ "grid",		/* Grid for wxFlexGridSizer/wxGridSizer. */
/*  14 */ "sash",		/* Sash value for splitter window. */
/*  15 */ "minimum-pane-size",	/* Minimum pane size for splitter window. */
/*  16 */ "bitmap",		/* Bitmap expression for bitmap button. */
/*  17 */ "choices",		/* Choices expression. */
/*  18 */ "states",	/* Number of states + current state for checkbox. */
/*  19 */ "size",		/* Element default size. */
/*  20 */ "selection",		/* Selection style for list box. */
/*  21 */ "rows",		/* Max number of rows for radio box. */
/*  22 */ "columns",		/* Max number of columns for radio box. */
/*  23 */ "grow",		/* Alias for expand. */
/*  24 */ "start-group",	/* Start radio button group. */
/*  25 */ "direction",		/* Spin/slider/scrollbar  control direction. */
/*  26 */ "range",		/* Spin/slider  min and max value. */
/*  27 */ "wrap",		/* Flag: Wrap spin control. */
/*  28 */ "keys",		/* Flag: Use keys. */
/*  29 */ "validator",		/* Set validator object. */
/*  30 */ "value",		/* Spin/slider value. */
/*  31 */ "slider-style",	/* Style for sliders. */
/*  32 */ "notebook-style",	/* Style for notebooks. */
/*  33 */ "text-style",		/* Style for text controls. */
/*  34 */ "button-style",	/* Style for buttons. */
/*  35 */ "splitter-window-style",	/* Style for splitter window. */
/*  36 */ "bitmap-button-style",	/* Style for bitmap button. */
/*  37 */ "bitmap-disabled",	/* Bitmap in disabled state. */
/*  38 */ "bitmap-selected",	/* Bitmap in selected state. */
/*  39 */ "bitmap-focus",	/* Bitmap when focused. */
/*  40 */ "bitmap-hover",	/* Bitmap when mouse-over. */
/*  41 */ "gauge-style",	/* Gauge style. */
/*  42 */ "menu-item-style",	/* Menu item style. */
/*  43 */ "toolbar-style",	/* Toolbar style. */
/*  44 */ "toolbar-button-style",	/* Toolbar button style. */
/*  45 */ "icon",		/* Icon for window. */
/*  46 */ "column-head",	/* Column head for wxGrid. */
/*  47 */ "row-head",		/* Row head for wxGrid. */
/*  48 */ "table",		/* Table for wxGrid. */
/*  49 */ "minimum-size",	/* Minimum size. */
/*  50 */ "growable-row",	/* Growable row in wxGridBagSizer. */
/*  51 */ "growable-column",	/* Growable column. */
/*  52 */ "complete-constructor-specified",	/* Have complete constructor. */
NULL
};



/**	Keywords used to produce output file.
*/
char const * const dkct_gui_out_kw[] = {
/*   0 */ "\n",
/*   1 */ " ",
/*   2 */ "    ",
/*   3 */ "*",
/*   4 */ ";",
/*   5 */ "    /**\tGUI element ",
/*   6 */ ".\n    */\n",
/*   7 */ "    /**\tFlag: GUI ok.\n    */\n    bool dkctGUILayoutOK;\n\n",
/*   8 */ "  ",
/*   9 */ "dkctGUILayoutOK = false;\n",
/*  10 */ "dkctGUILayoutOK = true;\n",
/*  11 */ "dkctGUILayoutFinished",
/*  12 */ ":",
/*  13 */ "goto",
/*  14 */ " = NULL;\n",
/*  15 */ ".",
/*  16 */ "%d",
/*  17 */
"    /**\tContents panel.\n    */\n    wxPanel *dkctGUIContentsPanel;\n\n",
/*  18 */ "dkctGUIContentsPanel = NULL;\n",
/*  19 */ "#if wxUSE_MENUS\n",
/*  20 */ "#if wxUSE_TOOLBAR\n",
/*  21 */ "#if wxUSE_STATUSBAR\n",
/*  22 */ "#endif\n",
/*  23 */ " = new ",
/*  24 */ ");",
/*  25 */ "  if(!(",
/*  26 */ ")) {\n",
/*  27 */ "    goto dkctGUILayoutFinished;\n",
/*  28 */ "  }\n",
/*  29 */ "(\n",
/*  30 */ "dkctGUIContentsPanel",
/*  31 */ "->",
/*  32 */ "SetSizer(",
/*  33 */ "dkctGUIContentsPanel = new wxPanel(this);\n",
/*  34 */ "wxHORIZONTAL",
/*  35 */ "wxVERTICAL",
/*  36 */ "Add(\n",
/*  37 */ "  );\n",
/*  38 */ ",\n",
/*  39 */ "wxALL",
/*  40 */ "wxTOP",
/*  41 */ "wxLEFT",
/*  42 */ "wxRIGHT",
/*  43 */ "wxBOTTOM",
/*  44 */ "|",
/*  45 */ "wxALIGN_LEFT",
/*  46 */ "wxALIGN_CENTER_HORIZONTAL",
/*  47 */ "wxALIGN_RIGHT",
/*  48 */ "wxALIGN_TOP",
/*  49 */ "wxALIGN_CENTER_VERTICAL",
/*  50 */ "wxALIGN_BOTTOM",
/*  51 */ "wxGROW",
/*  52 */ "0",
/*  53 */ "wxGBPosition(",
/*  54 */ "wxGBSpan(",
/*  55 */ ", ",
/*  56 */ ")",
/*  57 */ "SetMenuBar(",
/*  58 */ "SetToolBar(",
/*  59 */ "  if(dkctGUILayoutOK) {\n",
/*  60 */ "->SetSizeHints(this);\n",
/*  61 */ "",	/* UNUSED */
/*  62 */ "    SetClientSize(dkctGUIMinSize);\n",
/*  63 */ "->Fit(this);\n",
/*  64 */ "  }\n",
/*  65 */ "this",
/*  66 */ "wxID_ANY",
/*  67 */ "  if((",
/*  68 */ ") && (",
/*  69 */ ")) {\n",
/*  70 */ "SplitVertically(",
/*  71 */ "SplitHorizontally(",
/*  72 */ "->SetMinimumPaneSize(",
/*  73 */ "wxEmptyString",
/*  74 */ "wxDefaultPosition",
/*  75 */ "wxDefaultSize",
/*  76 */ "wxCHK_3STATE",
/*  77 */ "->SetValue(true);\n",
/*  78 */ "->Set3StateValue(wxCHK_UNDETERMINED);\n",
/*  79 */ "->Set3StateValue(wxCHK_CHECKED);\n",
/*  80 */ "->Realize();\n",
/*  81 */ "wxSize(",
/*  82 */ "wxLB_SINGLE",
/*  83 */ "wxLB_MULTIPLE",
/*  84 */ "wxLB_EXTENDED",
/*  85 */ "|wxLB_HSCROLL|wxLB_NEEDED_SB",
/*  86 */ "wxRA_SPECIFY_ROWS",
/*  87 */ "wxRA_SPECIFY_COLS",
/*  88 */ "wxRB_GROUP",
/*  89 */ "    wxSize const dkctGUIMinSize(",
/*  90 */ "    CreateStatusBar(",
/*  91 */ "    SetStatusText(",
/*  92 */ "wxSP_HORIZONTAL",
/*  93 */ "wxSP_VERTICAL",
/*  94 */ "|wxSP_ARROW_KEYS",
/*  95 */ "|wxSP_WRAP",
/*  96 */ "wxSP_ARROW_KEYS|wxSP_WRAP",
/*  97 */ "wxSP_ARROW_KEYS",
/*  98 */ "wxSP_WRAP",
/*  99 */ "",
/* 100 */ "NULL",
/* 101 */ "wxSB_HORIZONTAL",
/* 102 */ "wxSB_VERTICAL",
/* 103 */ "wxSL_HORIZONTAL",
/* 104 */ "wxSL_VERTICAL",
/* 105 */ "wxSL_AUTOTICKS",
/* 106 */ "wxSL_LABELS",
/* 107 */ "wxSL_LEFT",
/* 108 */ "wxSL_RIGHT",
/* 109 */ "wxSL_TOP",
/* 110 */ "wxSL_BOTTOM",
/* 111 */ "wxSL_SELRANGE",
/* 112 */ "wxSL_INVERSE",
/* 113 */ "wxNB_TOP",
/* 114 */ "wxNB_LEFT",
/* 115 */ "wxNB_RIGHT",
/* 116 */ "wxNB_BOTTOM",
/* 117 */ "wxNB_FIXEDWIDTH",
/* 118 */ "wxNB_MULTILINE",
/* 119 */ "wxNB_NOPAGETHEME",
/* 120 */ "wxNB_FLAT",
/* 121 */ "wxTE_PROCESS_ENTER",
/* 122 */ "wxTE_PROCESS_TAB",
/* 123 */ "wxTE_MULTILINE",
/* 124 */ "wxTE_PASSWORD",
/* 125 */ "wxTE_READONLY",
/* 126 */ "wxTE_RICH",
/* 127 */ "wxTE_RICH2",
/* 128 */ "wxTE_AUTO_URL",
/* 129 */ "wxTE_NOHIDESEL",
/* 130 */ "wxTE_LEFT",
/* 131 */ "wxTE_CENTRE",
/* 132 */ "wxTE_RIGHT",
/* 133 */ "wxTE_DONTWRAP",
/* 134 */ "wxTE_CHARWRAP",
/* 135 */ "wxTE_WORDWRAP",
/* 136 */ "wxTE_BESTWRAP",
/* 137 */ "wxTE_CAPITALIZE",
/* 138 */ "wxHSCROLL",
/* 139 */ "wxVSCROLL",
/* 140 */ "wxHSCROLL|wxVSCROLL",
/* 141 */ "wxBU_LEFT",
/* 142 */ "wxBU_TOP",
/* 143 */ "wxBU_RIGHT",
/* 144 */ "wxBU_BOTTOM",
/* 145 */ "wxBU_EXACTFIT",
/* 146 */ "wxNO_BORDER",
/* 147 */ "wxSP_3D",
/* 148 */ "wxSP_3DSASH",
/* 149 */ "wxSP_3DBORDER",
/* 150 */ "wxSP_BORDER",
/* 151 */ "wxSP_NOBORDER",
/* 152 */ "wxSP_NO_XP_THEME",
/* 153 */ "wxSP_PERMIT_UNSPLIT",
/* 154 */ "wxSP_LIVE_UPDATE",
/* 155 */ "wxBU_AUTODRAW",
/* 156 */ "->SetBitmapDisabled(",
/* 157 */ "->SetBitmapSelected(",
/* 158 */ "->SetBitmapFocus(",
/* 159 */ "->SetBitmapHover(",
/* 160 */ "wxGA_HORIZONTAL",
/* 161 */ "wxGA_VERTICAL",
/* 162 */ "|wxGA_SMOOTH",
/* 163 */ "wxALIGN_CENTRE",
/* 164 */ "wxST_NO_AUTORESIZE",
/* 165 */ "wxLI_HORIZONTAL",
/* 166 */ "wxLI_VERTICAL",
/* 167 */ "wxITEM_NORMAL",
/* 168 */ "wxITEM_SEPARATOR",
/* 169 */ "wxITEM_CHECK",
/* 170 */ "wxITEM_RADIO",
/* 171 */ "wxID_SEPARATOR",
/* 172 */ "wxTB_HORIZONTAL",
/* 173 */ "wxTB_VERTICAL",
/* 174 */ "|wxTB_FLAT",
/* 175 */ "|wxTB_DOCKABLE",
/* 176 */ "|wxTB_TEXT",
/* 177 */ "|wxTB_NOICONS",
/* 178 */ "|wxTB_NODIVIDER",
/* 179 */ "|wxTB_NOALIGN",
/* 180 */ "|wxTB_HORZ_LAYOUT",
/* 181 */ "|wxTB_NO_TOOTIPS",
/* 182 */ "|wxTB_BOTTOM",
/* 183 */ "|wxTB_RIGHT",
/* 184 */ "->Append(",
/* 185 */ "->AddTool(\n",
/* 186 */ "wxNullBitmap",
/* 187 */ "->AddControl(",
/* 188 */ "AppendSeparator();\n",
/* 189 */ "AddSeparator();\n",
/* 190 */ "SetToolTip(",
/* 191 */ "->AppendCheckItem(",
/* 192 */ "->AppendRadioItem(",
/* 193 */ "->AppendSeparator(",
/* 194 */ " = ",
/* 195 */ "SetIcon(",
/* 196 */ "Add(",
/* 197 */ "<none>",
/* 198 */ "->SetTable(",
/* 199 */ "true",
/* 200 */ "->CreateGrid(",
/* 201 */ "->SetColLabelValue(",
/* 202 */ "->SetRowLabelValue(",
/* 203 */ "->EnableEditing(false);",
/* 204 */ "->SetMinSize(wxSize(",
/* 205 */ "));",
/* 206 */ "->AddGrowableCol(",
/* 207 */ "->AddGrowableRow(",
/* 208 */ "AddButton(\n",
/* 209 */ ",",
/* 210 */ "SetLabel(",
/* 211 */ "SetValidator(",
/* 212 */ "SetSize(",
/* 213 */ "SetMinSize(",
NULL
};



/**	Names for directions.
*/
static char const * const dkct_gui_direction_names[] = {
/*  0 */ "horizontal",
/*  1 */ "vertical",
/*  2 */ "both",
NULL
};



/**	Delete grid header data.
	@param	gh	Header data to delete.
*/
static
void
dkct_grid_head_delete(DKCT_GRID_HEAD *gh)
{
  if(gh) {
    dk3_release(gh->text);
    gh->elno = 0;
    dk3_delete(gh);
  }
}



/**	Create new grid header data.
	@param	txt	Text for row or column label.
	@param	no	Index number of grid row or column.
	@param	psrc	Source structure.
*/
static
DKCT_GRID_HEAD *
dkct_grid_head_new(char const *txt, int no, DKCT_SRC *psrc)
{
  DKCT_GRID_HEAD	*back	= NULL;
  if(txt) {
    back = dk3_new_app(DKCT_GRID_HEAD,1,psrc->app);
    if(back) {
      back->elno = no;
      back->text = dk3str_c8_dup_app(txt, psrc->app);
      if(!(back->text)) {
        dkct_grid_head_delete(back);
	back = NULL;
      }
    }
  }
  return back;
}



/**	Compare two row/column heads.
	@param	l	Left object.
	@param	r	Right object.
	@param	cr	Comparison criteria (ignored).
	@return	Comparison result.
*/
static
int
dkct_grid_head_compare(void const *l, void const *r, int cr)
{
  int			 back = 0;
  DKCT_GRID_HEAD const	*pl;
  DKCT_GRID_HEAD const	*pr;
  if(l) {
    if(r) {
      pl = (DKCT_GRID_HEAD const *)l; pr = (DKCT_GRID_HEAD const *)r;
      if(pl->elno > pr->elno) {
        back = 1;
      } else {
        if(pl->elno < pr->elno) {
	  back = -1;
	}
      }
    } else back = 1;
  } else {
    if(r) back = -1;
  }
  return back;
}



/**	Compare two GUI elements.
	@param	l	Left element.
	@param	r	Right element.
	@param	cr	Comparison criteria (0=elem/elem by name, 1=elem/name,
	2=elem/elem by number, 3=elem/number).
	@return	Comparison result.
*/
static
int
dkct_gui_element_compare(void const *l, void const *r, int cr)
{
  int back = 0;			/* Result. */
  DKCT_GUI_ELEMENT const	*pl;	/* Left object pointer. */
  DKCT_GUI_ELEMENT const	*pr;	/* Right object pointer. */
  size_t const			*pn;	/* Right number. */
  if(l) {
    if(r) {
      pl = (DKCT_GUI_ELEMENT const *)l;
      pr = (DKCT_GUI_ELEMENT const *)r;
      pn = (size_t const *)r;
      switch(cr) {
        case 3: {
	  if(pl->number > *pn) {
	    back = 1;
	  } else {
	    if(pl->number < *pn) {
	      back = -1;
	    }
	  }
	} break;
	case 2: {
	  if(pl->number > pr->number) {
	    back = 1;
	  } else {
	    if(pl->number < pr->number) {
	      back = -1;
	    }
	  }
	} break;
	case 1: {
	  if(pl->name) {
	    back = dk3str_c8_cmp(pl->name, (char const *)r);
	  } else { back = -1; }
	} break;
	default: {
	  if(pl->name) {
	    if(pr->name) {
	      back = dk3str_c8_cmp(pl->name, pr->name);
	    } else { back = 1; }
	  } else {
	    if(pr->name) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  if(back < -1) { back = -1; }
  if(back >  1) { back =  1; }
  return back;
}



/**	Remove all grid heads (row or column heads) from storage
	and close storage.
	@param	sHeads	Storage containing the heads.
	@param	iHeads	Iterator through storage.
*/
static
void
dkct_remove_grid_heads(dk3_sto_t *sHeads, dk3_sto_it_t *iHeads)
{
  DKCT_GRID_HEAD	*gh;

  if(sHeads) {
    if(iHeads) {
      dk3sto_it_reset(iHeads);
      while(NULL != (gh = (DKCT_GRID_HEAD *)dk3sto_it_next(iHeads))) {
        dkct_grid_head_delete(gh);
      }
      dk3sto_it_close(iHeads);
    }
    dk3sto_close(sHeads);
  }
}



/**	Remove growable row or column information.
	@param	st	Storage containing growable row or column data.
	@param	it	Iterator through storage.
*/
static
void
dkct_remove_grow_row_col(dk3_sto_t *st, dk3_sto_it_t *it)
{
  void	*ip;
  if(st) {
    if(it) {
      dk3sto_it_reset(it);
      while(NULL != (ip = dk3sto_it_next(it))) {
        dk3_delete(ip);
      }
      dk3sto_it_close(it);
    }
    dk3sto_close(st);
  }
}


/**	Destroy GUI element, release memory.
	@param	elp	Element to destroy.
*/
static
void
dkct_gui_elem_delete(DKCT_GUI_ELEMENT *elp)
{
  

#line 1335 "dkct-gui.ctr"
  if(elp) {
    dkct_remove_grid_heads(elp->sRowHeads, elp->iRowHeads);
    dkct_remove_grid_heads(elp->sColumnHeads, elp->iColumnHeads);
    elp->sRowHeads = NULL; elp->iRowHeads = NULL;
    elp->sColumnHeads = NULL; elp->iColumnHeads = NULL;
    dkct_remove_grow_row_col(elp->sGrowRow, elp->iGrowRow);
    dkct_remove_grow_row_col(elp->sGrowCol, elp->iGrowCol);
    elp->sGrowRow = NULL; elp->iGrowRow = NULL;
    elp->sGrowCol = NULL; elp->iGrowCol = NULL;
    if(elp->s_contents) {
      if(elp->i_contents) {
        dk3sto_it_close(elp->i_contents);
      }
      dk3sto_close(elp->s_contents);
    } elp->s_contents = NULL; elp->i_contents = NULL;
    dk3_release(elp->gridTable);
    dk3_release(elp->validator);
    dk3_release(elp->choices);
    dk3_release(elp->stbText);
    dk3_release(elp->bitmapHover);
    dk3_release(elp->bitmapFocus);
    dk3_release(elp->bitmapSelected);
    dk3_release(elp->bitmapDisabled);
    dk3_release(elp->bitmapVarName);
    dk3_release(elp->icon);
    dk3_release(elp->tipText);
    dk3_release(elp->name);
    dk3_release(elp->cname);
    dk3_release(elp->constructor);
    dk3_release(elp->text);
    dk3_release(elp->idname);
    elp->parent = NULL;		

#line 1367 "dkct-gui.ctr"
    elp->number = 0;		

#line 1368 "dkct-gui.ctr"
    elp->lndef = 0UL;		

#line 1369 "dkct-gui.ctr"
    elp->lndecl = 0UL;
    elp->cln = 0;
    elp->align = 0x00;
    dk3_delete(elp);
  } 

#line 1374 "dkct-gui.ctr"
}



/**	Create GUI element, allocate memory.
	@param	parent	Parent GUI element.
	@param	name	New GUI elements name.
	@param	number	Number of new element.
	@param	psrc	Source structure, used for diagnostics.
	@param	gui	GUI description.
	@return	Pointer to new element on success, NULL on error.
*/
static
DKCT_GUI_ELEMENT *
dkct_gui_elem_new(
  DKCT_GUI_ELEMENT	*parent,
  char const		*name,
  size_t		 number,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui

)
{
  DKCT_GUI_ELEMENT	*back = NULL;
  int			 ok = 0;	/* Flag: OK so far. */
  

#line 1400 "dkct-gui.ctr"
  back = dk3_new_app(DKCT_GUI_ELEMENT,1,psrc->app);
  if(back) {
    /*
    	Initialize empty object.
    */
    back->name = NULL;
    back->cname = NULL;
    back->idname = NULL;
    back->text = NULL;
    back->constructor = NULL;
    back->tipText = NULL;
    back->icon = NULL;
    back->bitmapVarName = NULL;
    back->bitmapDisabled = NULL;
    back->bitmapSelected = NULL;
    back->bitmapFocus = NULL;
    back->bitmapHover = NULL;
    back->stbText = NULL;
    back->choices = NULL;
    back->validator = NULL;
    back->gridTable = NULL;
    back->parent = NULL;
    back->number = 0;
    back->align = 0x00;
    if(gui) { back->align = gui->align; }
    back->cln = -1;
    back->menubar = NULL;
    back->toolbar = NULL;
    back->passno = 0;
    back->posx = 0;
    back->posy = 0;
    back->spanx = 0;
    back->spany = 0;
    back->gridcolumns = 1;
    back->gridrows = 1;
    back->gridgapx = -1;
    back->gridgapy = -1;
    back->sash = 0;
    back->minPaneSize = 0;
    back->nChoices = 0;
    back->maxRowsCols = 1;
    back->rbDirection = DKCT_GUI_RB_DIR_COLUMNS;
    back->startGroup = 0x00;
    back->curx = 0;
    back->cury = 0;
    back->sizex = 0;
    back->sizey = 0;
    back->sizemx = 0;
    back->sizemy = 0;
    back->stbsz = 0;
    back->s_contents = NULL;
    back->i_contents = NULL;
    back->sRowHeads = NULL;
    back->iRowHeads = NULL;
    back->sColumnHeads = NULL;
    back->iColumnHeads = NULL;
    back->sGrowRow = NULL;
    back->iGrowRow = NULL;
    back->sGrowCol = NULL;
    back->iGrowCol = NULL;
    back->pseudoobj = 0;
    back->lndef = 0UL;
    back->lndecl = 0UL;
    if(psrc) { back->lndecl = psrc->lineno; }
    back->border = -1;
    back->borderPos = 0x00;
    back->expandFlag = 0x00;
    back->nStates = 0x02;
    back->state = 0x00;
    back->selStyle = DKCT_GUI_SELECTION_STYLE_SINGLE;
    back->prost = DKCT_GUI_PROCESSING_STATE_START;
    back->proportion = 0;
    back->direction = DKCT_GUI_DIRECTION_HORIZONTAL;
    back->spinMin = 0;
    back->spinMax = 100;
    back->spinVal = 0;
    back->nRows = 0;
    back->nColumns = 0;
    back->nRowHeads = 0;
    back->nColumnHeads = 0;
    back->spinWrap = 0x00;
    back->useKeys = 0x00;
    back->sliderStyle = 0x00;
    back->buttonStyle = 0x00;
    back->bitmapbStyle = DKCT_GUI_BBUTTON_AUTODRAW;
    back->gaugeStyle = 0x00;
    back->menuItemStyle = 0x00;
    back->tableOwner = 0x00;
    back->notebookStyle = 0U;
    back->splitterStyle = DKCT_GUI_SPLITTERW_3D;
    back->toolbarStyle = DKCT_GUI_TOOLBAR_FLAT;
    back->textStyle = 0UL;
    back->compConst = 0x00;
    /*
    	Allocate memory.
    */
    back->s_contents = dk3sto_open_app(psrc->app);
    if(back->s_contents) {
      /* Sorting by number needed. */
      dk3sto_set_comp(back->s_contents, dkct_gui_element_compare, 2);
      back->i_contents = dk3sto_it_open(back->s_contents);
      if(back->i_contents) {
        ok = 1;
      }
    }
    /*
    	Use arguments.
    */
    back->parent = parent;
    if(name) {
      back->name = dk3str_c8_dup_app(name, psrc->app);
      if(!(back->name)) { ok = 0; }
    }
    back->number = number;
    if(!(ok)) {	

#line 1515 "dkct-gui.ctr"
      dkct_gui_elem_delete(back); back = NULL;
    }
  } 

#line 1518 "dkct-gui.ctr"
  return back;
}



/**	Create next object in GUI description.
	@param	gui	GUI description.
	@param	name	New object name.
	@return	Pointer to new object on success, NULL on error.
*/
static
DKCT_GUI_ELEMENT *
dkct_gui_elem_next(DKCT_GUI *gui, char const *name)
{
  DKCT_GUI_ELEMENT	*back = NULL;

  if(name) {
    if(*name != '$') {
      back = (DKCT_GUI_ELEMENT *)dk3sto_it_find_like(
        gui->i_el_by_name, (void *)name, 1
      );
    }
  }
  if(back) {
    /* Warning: Object already declared! 95/96 */
    dkct_to_log_3(gui->psrc, 1, DK3_LL_WARNING, 95, 96, name);
  } else {
    back = dkct_gui_elem_new(gui->c_el, name, gui->no, gui->psrc, gui);
    if(back) {
      if(dk3sto_add(gui->s_el_by_name, (void *)back)) {
        gui->no += 1;
        if(!dk3sto_add(gui->s_el_by_num, (void *)back)) {
          back = NULL;
	  (gui->psrc)->ec = DK3_ERROR_MEMORY;
        }
      } else {
        dkct_gui_elem_delete(back); back = NULL;
        (gui->psrc)->ec = DK3_ERROR_MEMORY;
	/* ERROR: Memory! */
	dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
      }
    } else {
      (gui->psrc)->ec = DK3_ERROR_MEMORY;
      /* ERROR: Memory! */
      dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
    }
  }
  return back;
}



DKCT_GUI *
dkct_gui_new(DKCT_SRC *psrc)
{
  DKCT_GUI		*back	= NULL;
  int			 ok	= 0;	/* FLag: Success. */
  DKCT_GUI_ELEMENT	*el;		/* New element. */
  

#line 1577 "dkct-gui.ctr"
  back = dk3_new_app(DKCT_GUI,1,psrc->app);
  if(back) {
    /*
    	Initialize.
    */
    back->psrc = psrc;
    back->c_el = NULL;
    back->r_el = NULL;
    back->s_el_by_name = NULL; back->i_el_by_name = NULL;
    back->s_el_by_num = NULL; back->i_el_by_num = NULL;
    back->no = 0;
    back->align = 0x00;
    /*
    	Allocate storages.
    */
    back->s_el_by_name = dk3sto_open_app(psrc->app);
    if(back->s_el_by_name) {
      dk3sto_set_comp(back->s_el_by_name, dkct_gui_element_compare, 0);
      back->i_el_by_name = dk3sto_it_open(back->s_el_by_name);
      if(back->i_el_by_name) {
        back->s_el_by_num = dk3sto_open_app(psrc->app);
	if(back->s_el_by_num) {
	  dk3sto_set_comp(back->s_el_by_num, dkct_gui_element_compare, 2);
	  back->i_el_by_num = dk3sto_it_open(back->s_el_by_num);
	  if(back->i_el_by_num) {
	    el = dkct_gui_elem_new(NULL, NULL, 0, psrc, back);
	    if(el) {
	      back->no = 1;
	      if(dk3sto_add(back->s_el_by_name, el)) {
	        if(dk3sto_add(back->s_el_by_num, el)) {
		  ok = 1;
		  back->c_el = el;
		  back->r_el = el;
		  el->cln = 0;
		}
	      } else {
	        dkct_gui_elem_delete(el); el = NULL;
	      }
	    }
	  }
	}
      }
    }
    if(!(ok)) {
      dkct_gui_delete(back); back = NULL;
    }
  } 

#line 1624 "dkct-gui.ctr"
  return back;
}



void
dkct_gui_delete(DKCT_GUI *pg)
{
  DKCT_GUI_ELEMENT	*el;	/* Current element to process. */
  

#line 1634 "dkct-gui.ctr"
  if(pg) {
    pg->psrc = NULL;
    pg->c_el = NULL;
    pg->no = 0;
    if(pg->s_el_by_num) {
      if(pg->i_el_by_num) {
        dk3sto_it_close(pg->i_el_by_num);
      }
      dk3sto_close(pg->s_el_by_num);
    } pg->s_el_by_num = NULL; pg->i_el_by_num = NULL;
    if(pg->s_el_by_name) {
      if(pg->i_el_by_name) {
        dk3sto_it_reset(pg->i_el_by_name);
	while((el = (DKCT_GUI_ELEMENT *)dk3sto_it_next(pg->i_el_by_name))
	      != NULL)
	{
	  dkct_gui_elem_delete(el);
	}
        dk3sto_it_close(pg->i_el_by_name);
      }
      dk3sto_close(pg->s_el_by_name);
    } pg->s_el_by_name = NULL; pg->i_el_by_name = NULL;
    dk3_delete(pg);
  } 

#line 1658 "dkct-gui.ctr"
}



/**	Class-depending attribute setup.
	@param	el	New object to set up.
*/
static
void
dkct_gui_initialize_object_for_class(DKCT_GUI_ELEMENT *el)
{
  switch(el->cln) {
    case 13: {
      el->direction = DKCT_GUI_DIRECTION_BOTH;
    } break;
  }
}



/**	Start processing of a new object.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_start_new_object_definition(DKCT_GUI *gui, char *il)
{
  int			 back	= 0;
  char			*p2	= NULL;	/* Closing square bracket. */
  DKCT_GUI_ELEMENT	*elp;		/* Element to process. */
  

#line 1691 "dkct-gui.ctr"
  gui->c_el = NULL;
  p2 = dk3str_c8_rchr(il, ']');
  if(p2) {
    *p2 = '\0';
    p2 = dk3str_c8_next(il, NULL);
    if(p2) {
      elp = (DKCT_GUI_ELEMENT *)dk3sto_it_find_like(gui->i_el_by_name, p2, 1);
      if(!(elp)) {
        /* Warning: Undefined element ! */
	elp = dkct_gui_elem_new(NULL, p2, gui->no, gui->psrc, gui);
	if(elp) {
	  if(dk3sto_add(gui->s_el_by_name, (void *)elp)) {
	    gui->no += 1;
	    if(!dk3sto_add(gui->s_el_by_num, (void *)elp)) {
	      elp = NULL;
	    }
	  } else {
	    dkct_gui_elem_delete(elp); elp = NULL;
	  }
	}
      }
      if(elp) {
        if(elp->cname) {
	  /* ERROR: Class name already defined! */
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 45);
	} else {
	  elp->lndef = (gui->psrc)->lineno;
	  if(elp->lndecl == 0UL) { elp->lndecl = (gui->psrc)->lineno; }
	  elp->cname = dk3str_c8_dup_app(il, (gui->psrc)->app);
	  elp->cln = dk3str_c8_array_index(dkct_gui_class_names, il, 1);
	  dkct_gui_initialize_object_for_class(elp);
	  if(elp->cname) {
	    back = 1;
	    gui->c_el = elp;
	  } else {
	    dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
	  }
	}
      } else {
        (gui->psrc)->ec = DK3_ERROR_MEMORY;
        /* ERROR: Memory! */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
      }
    } else {
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      /* ERROR: Syntax (missing object name) */#
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 58);
    }
  } else {
    (gui->psrc)->ec = DK3_ERROR_SYNTAX;
    /* ERROR: Syntax (missing ']') */
    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 59);
  }
  

#line 1745 "dkct-gui.ctr"
  return back;
}



/**	Set menu bar.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_menu_bar(DKCT_GUI *gui, char *il)
{
  int			back	= 0;
  DKCT_GUI_ELEMENT	*elp;		/* Element to modify. */
  

#line 1762 "dkct-gui.ctr"
  if(gui->c_el) {
    if(((gui->c_el)->number != 0) && (!((gui->c_el)->parent))) {
      

#line 1765 "dkct-gui.ctr"
      /* Warning: Attribute applicable to root element only! */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 55);
    }
    if(!((gui->c_el)->menubar)) {
      elp = (DKCT_GUI_ELEMENT *)dk3sto_it_find_like(gui->i_el_by_name, il, 1);
      if(!(elp)) {
        elp = dkct_gui_elem_next(gui, il);
      }
      if(elp) {
        (gui->c_el)->menubar = (void *)elp;
	back = 1;
      } else {
	(gui->psrc)->ec = DK3_ERROR_MEMORY;
        /* ERROR: Memory */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
      }
    } else {
      DKCT_GUI_ELEMENT *e;
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      e = (DKCT_GUI_ELEMENT *)((gui->c_el)->menubar);
      if(e->name) {
        dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 74, 75, e->name);
      }
    }
  } 

#line 1790 "dkct-gui.ctr"
  return back;
}



/**	Set tool bar.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_tool_bar(DKCT_GUI *gui, char *il)
{
  int			back	= 0;
  DKCT_GUI_ELEMENT	*elp;		/* Toolbar object. */
  

#line 1807 "dkct-gui.ctr"
  if(gui->c_el) {
    if(((gui->c_el)->number != 0) && (!((gui->c_el)->parent))) {
      

#line 1810 "dkct-gui.ctr"
      /* Warning: Attribute applicable to root object only! */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 55);
    }
    if(!((gui->c_el)->toolbar)) {
      elp = (DKCT_GUI_ELEMENT *)dk3sto_it_find_like(gui->i_el_by_name, il, 1);
      if(!(elp)) {
        elp = dkct_gui_elem_next(gui, il);
      }
      if(elp) {
        (gui->c_el)->toolbar = (void *)elp;
	back = 1;
      } else {
	(gui->psrc)->ec = DK3_ERROR_MEMORY;
        /* ERROR: Memory */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
      }
    } else {
      DKCT_GUI_ELEMENT *e;
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      /* ERROR: Redefinition */
      e = (DKCT_GUI_ELEMENT *)((gui->c_el)->toolbar);
      if(e->name) {
        dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 74, 75, e->name);
      }
    }
  }
  

#line 1837 "dkct-gui.ctr"
  return back;
}



/**	Set status bar.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_status_bar(DKCT_GUI *gui, char *il)
{
  int back = 0;
  int num = 0;	/* Number of status bar labels. */
  char	*p1;	/* Number of status bar labels. */
  char	*p2;	/* Initial status text. */
  

#line 1856 "dkct-gui.ctr"
  if(gui->c_el) {
    if(((gui->c_el)->number != 0) && (!((gui->c_el)->parent))) {
      

#line 1859 "dkct-gui.ctr"
      /* Warning: Attribute applicable to root element only! */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 55);
    }
    p1 = dk3str_c8_start(il, NULL);
    if(p1) {
      p2 = dk3str_c8_next(p1, NULL);
      if(sscanf(p1, "%d", &num) == 1) {
        if(num >= 0) {
	  back = 1;
	  (gui->c_el)->stbsz = num;
	  if(p2) {
	    back = 0;
	    dk3_release((gui->c_el)->stbText);
	    (gui->c_el)->stbText = dk3str_c8_dup_app(p2, (gui->psrc)->app);
	    if((gui->c_el)->stbText) {
	      back = 1;
	    } else {
	      (gui->psrc)->ec = DK3_ERROR_MEMORY;
	      /* ERROR: Memory */
	      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
	    }
	  }
	} else {
	  (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	  /* ERROR: Out of range! */
	  dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 82, 83, p1);
	}
      } else {
	(gui->psrc)->ec = DK3_ERROR_SYNTAX;
	/* ERROR: Not a number! */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 31);
      }
    }
  }
  

#line 1894 "dkct-gui.ctr"
  return back;
}



/**	Set text for Window ID.
	@param	gui	GUI description.
	@param	il	Value part of input line.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_id(DKCT_GUI *gui, char *il)
{
  int back = 0;
  char	*p1;	/* Start of text. */
  

#line 1911 "dkct-gui.ctr"
  if(gui->c_el) {
    switch((gui->c_el)->cln) {
      case 5: case 6: case 7: case 8: case 9: case 10: {
        

#line 1915 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    if(!((gui->c_el)->idname)) {
      p1 = dk3str_c8_start(il, NULL);
      if(p1) {
        dk3str_c8_delnl(il);
	(gui->c_el)->idname = dk3str_c8_dup_app(p1, (gui->psrc)->app);
	if((gui->c_el)->idname) {
	  back = 1;
	} else {
	  (gui->psrc)->ec = DK3_ERROR_MEMORY;
	  dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
	}
      } else {
        /* ERROR: Syntax, empty ID */
	(gui->psrc)->ec = DK3_ERROR_SYNTAX;
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 71);
      }
    } else {
      /* ERROR: Syntax, ID already defined! */
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 60);
    }
  }
  

#line 1942 "dkct-gui.ctr"
  return back;
}



/**	Set constructor arguments.
	@param	gui	GUI description.
	@param	il	Value part of input line.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_constructor(DKCT_GUI *gui, char *il)
{
  int back = 0;
  char	*p1;	/* Start of text. */
  

#line 1959 "dkct-gui.ctr"
  if(gui->c_el) {
    if((gui->c_el)->cln >= 0) {	

#line 1961 "dkct-gui.ctr"
      /* Warning: Constructor attribute  not recommended for class! */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
    }
    if(!((gui->c_el)->constructor)) {
      p1 = dk3str_c8_start(il, NULL);
      if(p1) {
        dk3str_c8_delnl(il);
	(gui->c_el)->constructor = dk3str_c8_dup_app(p1, (gui->psrc)->app);
	if((gui->c_el)->constructor) {
	  back = 1;
	} else {
	  (gui->psrc)->ec = DK3_ERROR_MEMORY;
	  /* ERROR: Memory */
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
	}
      } else {
        /* ERROR: Syntax, empty ID */
	(gui->psrc)->ec = DK3_ERROR_SYNTAX;
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 61);
      }
    } else {
      /* ERROR: Syntax, ID already defined! */
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 60);
    }
  } 

#line 1987 "dkct-gui.ctr"
  return back;
}



/**	Set border.
	@param	gui	GUI description.
	@param	il	Value part of input line.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_border(DKCT_GUI *gui, char *il)
{
  int			back	= 0;
  int			i	= 0;	/* Number of pixels for border. */
  char			*p1	= NULL;	/* Current string to process. */
  char			*p2	= NULL;	/* Next string to process. */
  

#line 2006 "dkct-gui.ctr"
  if(gui->c_el) {
    switch((gui->c_el)->cln) {
      case 0: case 1: case 2: case 3: case 4: {	

#line 2009 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    p1 = dk3str_c8_start(il, NULL);
    if(p1) {
      p2 = dk3str_c8_next(p1, NULL);
      if(sscanf(p1, "%d", &i) == 1) {
        if(i >= 0) {
	  (gui->c_el)->border = i;
	  back = 1;
	  if(p2) {
	    (gui->c_el)->borderPos = DKCT_GUI_BORDER_POSITION_NONE;
	    while(p2) {
	      p1 = dk3str_c8_next(p2, NULL);
	      i = dk3str_c8_array_index(dkct_gui_border_position_names, p2, 0);
	      switch(i) {
	        case 0: {
		  (gui->c_el)->borderPos |= DKCT_GUI_BORDER_POSITION_ALL;
		} break;
	        case 1: {
		  (gui->c_el)->borderPos |= DKCT_GUI_BORDER_POSITION_TOP;
		} break;
	        case 2: {
		  (gui->c_el)->borderPos |= DKCT_GUI_BORDER_POSITION_LEFT;
		} break;
	        case 3: {
		  (gui->c_el)->borderPos |= DKCT_GUI_BORDER_POSITION_RIGHT;
		} break;
	        case 4: {
		  (gui->c_el)->borderPos |= DKCT_GUI_BORDER_POSITION_BOTTOM;
		} break;
		default: {
		  back = 0;
		  (gui->psrc)->ec = DK3_ERROR_SYNTAX;
		  dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p2);
		} break;
	      }
	      p2 = p1;
	    }
	  } else {
	    (gui->c_el)->borderPos = DKCT_GUI_BORDER_POSITION_ALL;
	  }
	}
      }
    }
  }
  

#line 2057 "dkct-gui.ctr"
  return back;
}



/**	Set proportion to grow the object.
	@param	gui	GUI description.
	@param	il	Value part of input line.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_proportion(DKCT_GUI *gui, char *il)
{
  int			back	= 0;
  int			i;		/* Proportion value. */
  

#line 2074 "dkct-gui.ctr"
  if(gui->c_el) {
    switch((gui->c_el)->cln) {
      case 0: case 1: case 2: case 3: {	

#line 2077 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    if(sscanf(il, "%d", &i) == 1) {
      if(i >= 0) {
        back = 1;
	(gui->c_el)->proportion = i;
      }
    } else {
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      dkct_to_log_3(gui->psrc, 1, DK3_LL_WARNING, 76, 77, il);
    }
  }
  

#line 2092 "dkct-gui.ctr"
  return back;
}



/**	Set status text.
	@param	gui	GUI description.
	@param	il	Value part of input line.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_status_text(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Start of text. */
  int			 back = 0;
  

#line 2110 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 0:
      case 1:
      case 2:
      case 3:
      {
      } break;
      default: {	

#line 2120 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
      p1 = dk3str_c8_start(il, NULL);
      if(p1) {
        if(el->stbText) {
          dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 74, 75, el->stbText);
        }
	dk3_release(el->stbText);
        el->stbText = dk3str_c8_dup_app(p1, (gui->psrc)->app);
        if(el->stbText) {
          back = 1;
        } else {
          (gui->psrc)->ec = DK3_ERROR_MEMORY;
	  /* ERROR: Memory */
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
        }
      }
    }
  }
  

#line 2143 "dkct-gui.ctr"
  return back;
}



/**	Set expand flag.
	@param	gui	GUI description.
	@param	il	Value part of input line.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_expand(DKCT_GUI *gui, char *il)
{
  int		back	= 0;
  char		*p1;		/* Start of text. */
  

#line 2160 "dkct-gui.ctr"
  if(gui->c_el) {
    p1 = dk3str_c8_start(il, NULL);
    if(p1) {
      (void)dk3str_c8_next(p1, NULL);
      if(dk3str_c8_is_bool(p1)) {
        back = 1;
        if(dk3str_c8_is_on(p1)) {
	  (gui->c_el)->expandFlag = 0x01;
	} else {
	  (gui->c_el)->expandFlag = 0x00;
	}
      } else {
        (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	/* ERROR: Not a boolean! */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 70);
      }
    }
  } 

#line 2178 "dkct-gui.ctr"
  return back;
}


/**	Set text for label or button.
	@param	gui	GUI description.
	@param	il	Value part of input line.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_text(DKCT_GUI *gui, char *il)
{
  int back = 0;
  char	*p1;	/* Start of text. */
  

#line 2194 "dkct-gui.ctr"
  if(gui->c_el) {
    switch((gui->c_el)->cln) {
      case -1:
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 9:
      case 15:
      case 16:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 28:
      case 29:
      case 31:
      case 36:
      case 37:
      case 40:
      {
      } break;
      default: {	

#line 2219 "dkct-gui.ctr"
        /* Warning: Attribute not applicable for class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    if(!((gui->c_el)->text)) {
      p1 = dk3str_c8_start(il, NULL);
      if(p1) {
        dk3str_c8_delnl(il);
	(gui->c_el)->text = dk3str_c8_dup_app(p1, (gui->psrc)->app);
	if((gui->c_el)->text) {
	  back = 1;
	} else {
	  (gui->psrc)->ec = DK3_ERROR_MEMORY;
	  /* ERROR: Memory */
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
	}
      } else {
        /* ERROR: Syntax, empty ID */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 71);
	(gui->psrc)->ec = DK3_ERROR_SYNTAX;
      }
    } else {
      /* ERROR: Syntax, ID already defined! */
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 60);
    }
  } 

#line 2246 "dkct-gui.ctr"
  return back;
}



/**	Set text for label or button.
	@param	gui	GUI description.
	@param	il	Value part of input line.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_tip_text(DKCT_GUI *gui, char *il)
{
  int back = 0;
  char	*p1;	/* Start of text. */
  

#line 2263 "dkct-gui.ctr"
  if(gui->c_el) {
    switch((gui->c_el)->cln) {
      case -1:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 36:
      case 37:	/* wxMenuItem */
      case 39:
      case 40:
      {
      } break;
      default: {	

#line 2288 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    if(!((gui->c_el)->tipText)) {
      p1 = dk3str_c8_start(il, NULL);
      if(p1) {
        dk3str_c8_delnl(il);
	(gui->c_el)->tipText = dk3str_c8_dup_app(p1, (gui->psrc)->app);
	if((gui->c_el)->tipText) {
	  back = 1;
	} else {
	  (gui->psrc)->ec = DK3_ERROR_MEMORY;
	  /* ERROR: Memory */
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
	}
      } else {
        /* ERROR: Syntax, empty ID */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 71);
	(gui->psrc)->ec = DK3_ERROR_SYNTAX;
      }
    } else {
      /* ERROR: Syntax, tip text already defined! */
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 62);
    }
  } 

#line 2315 "dkct-gui.ctr"
  return back;
}



/**	Set root object type (frame or dialog).
	@param	gui	GUI structure.
	@param	il	 Value part of input line.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_type(DKCT_GUI *gui, char *il)
{
  int back = 0;
  

#line 2331 "dkct-gui.ctr"
  if(gui->c_el) {
    if(((gui->c_el)->number == 0) && (!((gui->c_el)->parent))) {
      switch(dk3str_c8_array_index(dkct_gui_base_type_names, il, 0)) {
        case 0: {
	  (gui->c_el)->cln = 0;
	  back = 1;
	} break;
	case 1: {
	  (gui->c_el)->cln = 1;
	  back = 1;
	} break;
	default: {
	  /* ERROR: Illegal type */
	  (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 63);
	} break;
      }
    } else {	

#line 2349 "dkct-gui.ctr"
      /* ERROR: Attribute applicable to root element only! */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 55);
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
    }
  } 

#line 2354 "dkct-gui.ctr"
  return back;
}



/**	Read placement int value from text.
	The text may be an absolute or relative number or a dot.
	@param	dest	Pointer to destination variable.
	@param	gui	GUI structure.
	@param	tptr	Text to process.
	@param	oldval	Previous value.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_read_number_from_string(
  int			*dest,
  DKCT_GUI		*gui,
  char			*tptr,
  int			 oldval
)
{
  int	back = 0;
  int	i;		/* Number read. */

  if(dk3str_c8_cmp(tptr, dkct_gui_out_kw[15]) == 0) {
    *dest = oldval; back = 1;
  } else {
    if(*tptr == '+') {
      if(sscanf(&(tptr[1]), dkct_gui_out_kw[16], &i) == 1) {
        *dest = oldval + i; back = 1;
      }
    } else {
      if(*tptr == '-') {
        if(sscanf(&(tptr[1]), dkct_gui_out_kw[16], &i) == 1) {
	  *dest = oldval - i; back = 1;
	}
      } else {
        if(sscanf(tptr, dkct_gui_out_kw[16], &i) == 1) {
	  *dest = i; back = 1;
	}
      }
    }
  }
  if(!(back)) {
    /* ERROR: Syntax: Not a numeric value! */
    dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 64, 65, tptr);
  }
  return back;
}



/**	Apply align specified as text to an object.
	@param	gui	GUI description.
	@param	oa	Alignment as found so far.
	@param	ptext	Text to process.
	@return	Updated alignment.
*/
static
unsigned char
dkct_gui_apply_align(DKCT_GUI *gui, unsigned char oa, char *ptext)
{
  unsigned char back;
  back = oa;

  switch(dk3str_c8_array_index(dkct_gui_align_names, ptext, 0)) {
    case 0: {
      back = (back & (~(DKCT_GUI_ALIGN_H_MASK))) | DKCT_GUI_ALIGN_H_LEFT;
    } break;
    case 1: {
      back = (back & (~(DKCT_GUI_ALIGN_H_MASK))) | DKCT_GUI_ALIGN_H_RIGHT;
    } break;
    case 2: {
      back = (back & (~(DKCT_GUI_ALIGN_V_MASK))) | DKCT_GUI_ALIGN_V_TOP;
    } break;
    case 3: {
      back = (back & (~(DKCT_GUI_ALIGN_V_MASK))) | DKCT_GUI_ALIGN_V_BOTTOM;
    } break;
    case 4: {
      back = DKCT_GUI_ALIGN_H_CENTER | DKCT_GUI_ALIGN_V_CENTER;
    } break;
    case 5: {
      back = (back & (~(DKCT_GUI_ALIGN_H_MASK))) | DKCT_GUI_ALIGN_H_CENTER;
    } break;
    case 6: {
      back = (back & (~(DKCT_GUI_ALIGN_V_MASK))) | DKCT_GUI_ALIGN_V_CENTER;
    } break;
    default: {
      dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, ptext);
      /* ERROR: Illegal keyword */
    } break;
  }
  return back;
}



/**	Register additional placement information.
	Process value part of "contents = element  0  0  1  1  left top" line.
	@param	gui	GUI structure.
	@param	parent	Parent element.
	@param	gel	Element to add.
	@param	p	Texts, starting with element name.
	@param	szp	Number of elements used in \a p.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_add_additional_placement_info(
  DKCT_GUI		*gui,
  DKCT_GUI_ELEMENT	*parent,
  DKCT_GUI_ELEMENT	*gel,
  char			**p,
  size_t		szp
)
{
  int	back = 1;
  int	x;		/* Start column. */
  int	y;		/* Start row. */
  int	w;		/* Number of columns. */
  int	h;		/* Number of rows. */
  

#line 2477 "dkct-gui.ctr"
  switch((gui->c_el)->cln) {
    case 5: case 9: {
      /*
    	  Box sizer / static box sizer.
	  contents = element [align]
      */
      if(szp > 1) {
        gel->align = 0x00;
        gel->align = dkct_gui_apply_align(gui, gel->align, p[1]);
	if(szp > 2) {
	  gel->align = dkct_gui_apply_align(gui, gel->align, p[2]);
	}
      }
    } break;
    case 6: case 8: {
      /*
      	Flex grid sizer.
	Grid sizer.
	contents = element x y [align [align]]
      */
      back = 0;
      if(szp >= 3) {
        if(dkct_gui_read_number_from_string(&x, gui, p[1], parent->curx)) {
	  if(dkct_gui_read_number_from_string(&y, gui, p[2], parent->cury)) {
	    gel->posx = x; gel->posy = y;
	    parent->curx = x; parent->cury = y;
	    back = 1;
	    if(szp > 3) {
	      gel->align = 0x00;
	      gel->align = dkct_gui_apply_align(gui, gel->align, p[3]);
	      if(szp > 4) {
	        gel->align = dkct_gui_apply_align(gui, gel->align, p[4]);
	      }
	    }
	  }
	}
      }
    } break;
    case 7: {
      /*
    	  Gridbag sizer.
	  contents = element x y w h [align [align]]
      */
      back = 0;
      if(szp >= 5) {
        if(dkct_gui_read_number_from_string(&y, gui, p[1], parent->cury)) {
	if(dkct_gui_read_number_from_string(&x, gui, p[2], parent->curx)) {
	  gel->posx = x; gel->posy = y; parent->curx = x; parent->cury = y;
	  if(sscanf(p[3], dkct_gui_out_kw[16], &h) == 1) {
	  if(sscanf(p[4], dkct_gui_out_kw[16], &w) == 1) {
	    gel->spanx = w; gel->spany = h; back = 1;
	    if(szp > 5) {
	      gel->align = 0x00;
	      gel->align = dkct_gui_apply_align(gui, gel->align, p[5]);
	      if(szp > 6) {
	        gel->align = dkct_gui_apply_align(gui, gel->align, p[6]);
	      }
	    }
	  }
	  }
	}
	}
      }
    } break;
    case 10: {
      /*
    	  Standard dialog button sizer.
	  Ignore anything but the element name.
	  contents = element
      */
    } break;
    default: {
      /*
    	  We don't know whether or not we are a sizer or anything
	  else. So we ignore anything but the element name.
      */
    } break;
  } 

#line 2555 "dkct-gui.ctr"
  return back;
}



/**	Add one contents line.
	@param	gui	GUI structure.
	@param	il	Value part of input line.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_add_contents(DKCT_GUI *gui, char *il)
{
  int			back	= 0;
  char			*p[16];		/* Strings in text. */
  char			*p1;		/* Pseudo-object start. */
  char			*p2;		/* Pseudo-object args start. */
  char			*p3;		/* Pseudo-object next arg. */
  DKCT_GUI_ELEMENT	*gel;		/* Element to add. */
  size_t		szp;		/* Number of strings in text. */
  int			pso;		/* Pseudo object value. */
  int			i;
  

#line 2579 "dkct-gui.ctr"
  if(gui->c_el) {
    switch((gui->c_el)->cln) {
      case 0:	/* wxFrame */
      case 1:	/* wxDiaglog */
      case 2:	/* wxMDIParentFrame */
      case 3:	/* wxMDIChildFrame */
      case 5:	/* wxBoxSizer */
      case 6:	/* wxFlexGridSizer */
      case 7:	/* wxGridBagSizer */
      case 8:	/* wxGridSizer */
      case 9:	/* wxStaticBoxSizer */
      case 10:	/* wxStdDialogButtonSizer */
      case 11:	/* wxPanel */
      case 12:	/* wxNotebook */
      case 13:	/* wxScrolledWindow */
      case 14:	/* wxSplitterWindow */
      case 35:	/* wxMenuBar */
      case 36:	/* wxMenu */
      case 38:	/* wxToolBar */
      case 39:	/* wxStatusBar */
      {
      } break;
      default: {	

#line 2602 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to this class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    for(szp = 0; szp < 16; szp++) { p[szp] = NULL; }
    szp = dk3str_c8_explode(p, 15, il, NULL);
    if(szp > 0) {			

#line 2609 "dkct-gui.ctr"
      gel = dkct_gui_elem_next(gui, p[0]);
      if(gel) {					

#line 2611 "dkct-gui.ctr"
        if(dk3sto_add((gui->c_el)->s_contents, gel)) {	

#line 2612 "dkct-gui.ctr"
	  if(*(p[0]) == '$') {			

#line 2613 "dkct-gui.ctr"
	    p1 = p[0]; p2 = NULL; p3 = NULL;
	    p2 = dk3str_c8_chr(p1, '(');
	    if(p2) {				

#line 2616 "dkct-gui.ctr"
	      *(p2++) = '\0';
	      p3 = dk3str_c8_rchr(p2, ')');
	      if(p3) {				

#line 2619 "dkct-gui.ctr"
	        *p3 = '\0';
	      }
	    }
	    pso = dk3str_c8_array_index(dkct_gui_pseudo_object_names, p[0], 0);
	    if(pso >= 0) {
	      gel->pseudoobj = 1 + pso;
	      back = 1;
	    }
	    if(back) {
	      switch(pso) {
	        case 0: case 1: {
		  if(pso == 0) {	

#line 2631 "dkct-gui.ctr"
		    gel->proportion = 1;
#if 0
		    /*
		    	2011-07-30: No wxGROW for stretch/spacer.
		    */
		    gel->expandFlag = 0x01;
#endif
		  }
	          if(p2) {		

#line 2640 "dkct-gui.ctr"
	            p3 = dk3str_c8_chr(p2, ',');
	            if(p3) *(p3++) = '\0';
	            if(sscanf(p2, "%d", &i) == 1) {	

#line 2643 "dkct-gui.ctr"
	              gel->sizex = i;
		      gel->sizey = i;
	            } else {
	              /* ERROR: Not an integer! */
		      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
		      dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 64, 65, p2);
		      back = 0;
	            }
	            if(p3) {				

#line 2652 "dkct-gui.ctr"
	              p2 = dk3str_c8_chr(p3, ',');
		      if(p2) *(p2++) = '\0';
		      if(sscanf(p3, "%d", &i) == 1) {	

#line 2655 "dkct-gui.ctr"
		        gel->sizey = i;
		      } else {
		        /* ERROR: Not an integer! */
			(gui->psrc)->ec = DK3_ERROR_SYNTAX;
			dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 64, 65, p2);
		        back = 0;
		      }
		      if(p2) {				

#line 2663 "dkct-gui.ctr"
		        if(sscanf(p2, "%d", &i) == 1) {	

#line 2664 "dkct-gui.ctr"
		          gel->proportion = i;
		        } else {
		          /* ERROR: Not an integer! */
			  (gui->psrc)->ec = DK3_ERROR_SYNTAX;
			  dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 64, 65, p2);
		          back = 0;
		        }
		      }
	            }
	          }
	        } break;
	      }
	    }
	    if(back) {
	      back = dkct_gui_add_additional_placement_info(
	        gui, gui->c_el, gel, p, szp
	      );
	    }
	  } else {				

#line 2683 "dkct-gui.ctr"
	    back = dkct_gui_add_additional_placement_info(
	      gui, gui->c_el, gel, p, szp
	    );
	  }
	} else {				

#line 2688 "dkct-gui.ctr"
	  /* ERROR: Memory */
	  (gui->psrc)->ec = DK3_ERROR_MEMORY;
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
	}
      } else {					

#line 2693 "dkct-gui.ctr"
        /* ERROR: Memory */
	(gui->psrc)->ec = DK3_ERROR_MEMORY;
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
      }
    } else {					

#line 2698 "dkct-gui.ctr"
      /* ERROR: Empty line */
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 66);
    }
  } else {					

#line 2703 "dkct-gui.ctr"
  } 

#line 2704 "dkct-gui.ctr"
  return back;
}



/**	Set up grid for current GUI object.
	@param	gui	GUI description.
	@param	pv	Text describing the grid.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_grid(DKCT_GUI *gui, char *pv)
{
  int back = 0;
  char *p1 = NULL;		/* First text string. */
  char *p2 = NULL;		/* Second text string. */
  char *p3 = NULL;		/* Third text string. */
  char *p4 = NULL;		/* Fourth text string. */
  DKCT_GUI_ELEMENT	*co;	/* Current object to modify. */
  int	v  = 0;			/* Number read from string. */
  int	i1 = 0;			/* First int value. */
  int	i2 = 0;			/* Second int value. */
  int	i3 = 0;			/* Third int value. */
  int	i4 = 0;			/* Fourth int value. */
  

#line 2730 "dkct-gui.ctr"
  co = gui->c_el;
  if(co) {
    switch(co->cln) {
      case 6: case 7: case 8:
      {
      } break;
      default: {	

#line 2737 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    p1 = dk3str_c8_start(pv, NULL);
    if(p1) {
      p2 = dk3str_c8_next(p1, NULL);
      if(p2) {
        p3 = dk3str_c8_next(p2, NULL);
        if(p3) {
          p4 = dk3str_c8_next(p3, NULL);
	  if(p4) {
	    dk3str_c8_next(p4, NULL);
	  }
        }
      }
    }
    if(p1) {
      if(sscanf(p1, "%d", &i1) == 1) {
        if(i1 > 0) {
          v = 1;
	  if(p2) {
	    if(sscanf(p2, "%d", &i2) == 1) {
	      if(i2 > 0) {
	        v = 2;
		if(p3) {
		  if(sscanf(p3, "%d", &i3) == 1) {
		    if(i3 >= 0) {
		      v = 3;
		      if(p4) {
		        if(sscanf(p4, "%d", &i4) == 1) {
			  if(i4 >= 0) {
			    v = 4;
			  }
			}
		      }
		    }
		  }
		}
	      }
	    }
	  }
        }
      }
    }
    switch(co->cln) {
      case 6: case 8: {	/* grid/flexgrid */
        if(v >= 2) {
	  back = 1;
	  co->gridrows = i1;
	  co->gridcolumns = i2;
	  if(v >= 3) {
	    co->gridgapy = i3;
	    if(v >= 4) {
	      co->gridgapx = i4;
	    }
	  }
	}
	if(!(back)) {
	  /* Syntax error. */
	  (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 67);
	}
      } break;
      case 7: {		/* gridbag */
        back = 1;
	if(v >= 1) {
	  co->gridgapy = i1;
	  if(v >= 2) {
	    co->gridgapx = i2;
	  }
	}
      } break;
      default: { back = 1; }
    }
  } else {
    /* ERROR: No current element yet */
    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 68);
    (gui->psrc)->ec = DK3_ERROR_SYNTAX;
  } 

#line 2817 "dkct-gui.ctr"
  return back;
}



/**	Set sash for splitter window.
	@param	gui	GUI description.
	@param	pv	Text describing the grid.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_sash(DKCT_GUI *gui, char *pv)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  int			 i;		/* Number read from string. */
  int			 back = 0;
  

#line 2835 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 14: {
      } break;
      default: {	

#line 2841 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
      i = 0;
      if(sscanf(pv, "%d", &i) == 1) {
	back = 1;
	el->sash = i;
      }
    }
  }
  

#line 2854 "dkct-gui.ctr"
  return back;
}



/**	Set minimum pane size for splitter window.
	@param	gui	GUI description.
	@param	pv	Text describing the grid.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_min_pane_size(DKCT_GUI *gui, char *pv)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  int			 i;		/* Number read from string. */
  int			 back = 0;
  

#line 2872 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 14: {
      } break;
      default: {	

#line 2878 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    i = 0;
    if(sscanf(pv, "%d", &i) == 1) {
      back = 1;
      el->minPaneSize = i;
    } else {
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, pv);
    }
  }
  

#line 2892 "dkct-gui.ctr"
  return back;
}



/**	Set flag whether or not the current button is the
	start of a new radio button group.
	@param	gui	GUI description.
	@param	pv	Text to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_start_radio_button_group(DKCT_GUI *gui, char *pv)
{
  int back = 0;
  DKCT_GUI_ELEMENT	*co;	/* Element to modify. */
  char			*p1;	/* Start of text. */
  

#line 2911 "dkct-gui.ctr"
  co = gui->c_el;
  if(co) {
    p1 = dk3str_c8_start(pv, NULL);
    if(p1) {
      dk3str_c8_delnl(p1);
      if(dk3str_c8_is_bool(p1)) {
        back = 1;
	if(dk3str_c8_is_on(p1)) {
	  co->startGroup = 0x01;
	} else {
	  co->startGroup = 0x00;
	}
      } else {
        (gui->psrc)->ec = DK3_ERROR_SYNTAX;
        dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 70);
      }
    } else {
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 69);
    }
  } else {
    (gui->psrc)->ec = DK3_ERROR_SYNTAX;
    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 68);
  }
  

#line 2936 "dkct-gui.ctr"
  return back;
}



/**	Set size of current GUI object.
	@param	gui	GUI description.
	@param	pv	Text containing the size.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_size_for_object(DKCT_GUI *gui, char *pv)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Width. */
  char			*p2;		/* Height. */
  int			i1 = 0;		/* Width. */
  int			i2 = 0;		/* Height. */
  int			back = 0;
  

#line 2957 "dkct-gui.ctr"
  if(gui->c_el) {
    el = gui->c_el;
    p1 = dk3str_c8_start(pv, NULL);
    if(p1) {
      p2 = dk3str_c8_next(p1, NULL);
      if(p2) {
        if(sscanf(p1, "%d", &i1) == 1) {
	  if(sscanf(p2, "%d", &i2) == 1) {
	    if((i1 >= 0) && (i2 >= 0)) {
	      back = 1;
	      el->sizex = i1; el->sizey = i2;
	    }
	  } else {
	    (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	    dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p2);
	  }
	} else {
	  (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	  dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	}
      }
    }
  }
  

#line 2981 "dkct-gui.ctr"
  return back;
}



/**	Set spin control direction.
	@param	gui	GUI description.
	@param	il	Value to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_direction(DKCT_GUI *gui, char *il)
{
  int back = 0;
  DKCT_GUI_ELEMENT	*el;	/* Element to modify. */
  char			*p1;	/* Start of text. */
  

#line 2999 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    p1 = dk3str_c8_start(il, NULL);
    if(p1) {
      dk3str_c8_next(p1, NULL);
      switch(el->cln) {
        case 5:		/* box sizer */
	case 9:		/* static box sizer */
	case 25:	/* spin button */
	case 26:	/* spin control */
	case 13:	/* scrolled window */
	case 30:	/* gauge */
	case 33:	/* static line */
	{
        } break;
	default: {	

#line 3015 "dkct-gui.ctr"
	  /* Warning: Direction ignored for this class! */
          dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
	} break;
      }
      switch(dk3str_c8_array_index(dkct_gui_direction_names, p1, 0)) {
        case 0: {
	  el->direction = DKCT_GUI_DIRECTION_HORIZONTAL;
	  back = 1;
	} break;
	case 1: {
	  el->direction = DKCT_GUI_DIRECTION_VERTICAL;
	  back = 1;
	} break;
	case 2: {
	  if(el->cln == 13) {
	    el->direction = DKCT_GUI_DIRECTION_BOTH;
	    back = 1;
	  } else {
	    /* ERROR: Only one direction allowed here! */
	    (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 72);
	  }
	} break;
	default: {
	  /* ERROR: Unknown direction! */
	  (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 73);
	} break;
      }
    }
  }
  

#line 3047 "dkct-gui.ctr"
  return back;
}



/**	Set spin control range.
	@param	gui	GUI description.
	@param	il	Value to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_range(DKCT_GUI *gui, char *il)
{
  int back = 0;
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Minimum. */
  char			*p2;		/* Maximum. */
  int			 i1 = 0;	/* Minimum. */
  int			 i2 = 100;	/* Maximum. */
  

#line 3068 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 25:	/* spin */
      case 26:	/* spin */
      case 27:	/* slider */
      case 30:	/* gauge */
      {
      } break;
      default: {
        /* Warning: Range ignored for this class! */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    p1 = dk3str_c8_start(il, NULL);
    if(p1) {
      p2 = dk3str_c8_next(p1, NULL);
      if(p2) {
	if(sscanf(p1, "%d", &i1) == 1) {
	  if(sscanf(p2, "%d", &i2) == 1) {
	    el->spinMin = i1; el->spinMax = i2; back = 1;
          } else {
	    (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	    dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p2);
	  }
        } else {
	  (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	  dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	}
      } else {
        if(el->cln == 30) {	/* Gauge has only one value */
	  if(sscanf(p1, "%d", &i1) == 1) {
	    el->spinMax = i1; el->spinMin = 0; back = 1;
	  } else {
	    (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	    dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	  }
	}
      }
    }
  }
  

#line 3110 "dkct-gui.ctr"
  return back;
}



/**	Set spin control value.
	@param	gui	GUI description.
	@param	il	Value to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_value(DKCT_GUI *gui, char *il)
{
  int back = 0;
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Start of text. */
  int			 i1 = 0;	/* Value. */
  

#line 3129 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 25:	/* spin */
      case 26:	/* spin */
      case 27:	/* slider */
      case 30:	/* gauge */
      {
      } break;
      default: {
        /* Warning: Range ignored for this class! */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    p1 = dk3str_c8_start(il, NULL);
    if(p1) {
      dk3str_c8_next(p1, NULL);
      if(sscanf(p1, "%d", &i1) == 1) {
        el->spinVal = i1;
	back = 1;
      } else {
        (gui->psrc)->ec = DK3_ERROR_SYNTAX;
        dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
      }
    }
  }
  

#line 3156 "dkct-gui.ctr"
  return back;
}



/**	Set spin control wrap flag.
	@param	gui	GUI description.
	@param	il	Value to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_wrap(DKCT_GUI *gui, char *il)
{
  int back = 0;
  char			*p1;	/* Start of text. */
  DKCT_GUI_ELEMENT	*el;	/* Element to modify. */
  

#line 3174 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 25:	/* spin button */
      case 26:	/* spin control */
      {
      } break;
      default: {
        /* ERROR: Wrap ignored for this class! */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    p1 = dk3str_c8_start(il, NULL);
    if(p1) {
      dk3str_c8_next(p1, NULL);
      if(dk3str_c8_is_bool(p1)) {
        back = 1;
        if(dk3str_c8_is_on(p1)) {
	  el->spinWrap = 0x01;
        } else {
          el->spinWrap = 0x00;
        }
      } else {
        /* ERROR: Not a boolean value! */
	(gui->psrc)->ec = DK3_ERROR_SYNTAX;
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 70);
      }
    }
  } 

#line 3203 "dkct-gui.ctr"
  return back;
}



/**	Set spin use keys flag.
	@param	gui	GUI description.
	@param	il	Value to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_keys(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;	/* Element to modify. */
  char			*p1;	/* Start of text. */
  int back = 0;
  

#line 3221 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 25: /* spin button */
      case 26: /* spin control */
      {
      } break;
      default: {	

#line 3229 "dkct-gui.ctr"
        /* Warning: Keys setting ignored for this class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    p1 = dk3str_c8_start(il, NULL);
    if(p1) {
      dk3str_c8_next(p1, NULL);
      if(dk3str_c8_is_bool(p1)) {
        back = 1;
        if(dk3str_c8_is_on(p1)) {
	  el->useKeys = 0x01;
	} else {
	  el->useKeys = 0x00;
	}
      } else {
        /* ERROR: Not a boolean! */
	(gui->psrc)->ec = DK3_ERROR_SYNTAX;
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 70);
      }
    }
  } 

#line 3250 "dkct-gui.ctr"
  return back;
}



/**	Set validator for object.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_validator(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*co;		/* Element to modify. */
  int			back = 0;
  

#line 3267 "dkct-gui.ctr"
  co = gui->c_el;
  if(co) {
    switch(co->cln) {
      case 15:	/* wxButton */
      case 16:	/* wxBitmapButton */
      case 17:	/* wxChoice */
      case 18:	/* wxComboBox */
      case 19:	/* wxCheckBox */
      case 20:	/* wxListBox */
      case 21:	/* wxCheckListBox */
      case 22:	/* wxRadioBox */
      case 23:	/* wxRadioButton */
      case 24:	/* wxScrollBar */
      case 25:	/* wxSpinButton  */
      case 26:	/* wxSpinCtrl */
      case 27:	/* wxSlider */
      case 28:	/* wxTextCtrl */
      case 29:	/* wxToggleButton */
      case 30:	/* wxGauge */
      {
      } break;
      default: {	

#line 3289 "dkct-gui.ctr"
        /* Warning: Setting a validator is not recommended! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    if(co->validator) {
      /* Warning: Redefinition of validator */
      dkct_to_log_3(gui->psrc, 1, DK3_LL_WARNING, 74, 75, co->validator);
    }
    dk3_release(co->validator);
    co->validator = dk3str_c8_dup_app(il, (gui->psrc)->app);
    if(co->validator) {
      back = 1;
    } else{
      (gui->psrc)->ec = DK3_ERROR_MEMORY;
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 29);
    }
  }
  

#line 3307 "dkct-gui.ctr"
  return back;
}



/**	Set text style.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_text_style(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Current string to process. */
  char			*p2;		/* Next string to process. */
  int			back = 0;
  

#line 3326 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 28:	/* wxTextCtrl */
      case 31:	/* wxStaticText */
      case 41:	/* wxGrid (readonly) */
      {
      } break;
      default: {	

#line 3335 "dkct-gui.ctr"
        /* Warning: Attribute not applicable for class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
        p1 = dk3str_c8_start(il, NULL);
        if(p1) {
          back = 1;
          while(p1) {
            p2 = dk3str_c8_next(p1, NULL);
	    switch(dk3str_c8_array_index(dkct_gui_text_style_names, p1, 0)) {
	      case  0: {	/* enter */
	        el->textStyle |= DKCT_GUI_TEXT_ENTER;
	      } break;
	      case  1: {	/* tab */
	        el->textStyle |= DKCT_GUI_TEXT_TAB;
	      } break;
	      case  2: {	/* multi */
	        el->textStyle |= DKCT_GUI_TEXT_MULTILINE;
	      } break;
	      case  3: {	/* password */
	        el->textStyle |= DKCT_GUI_TEXT_PASSWORD;
	      } break;
	      case  4: {	/* readonly */
	        el->textStyle |= DKCT_GUI_TEXT_READONLY;
	      } break;
	      case  5: {	/* rich */
	        el->textStyle |= DKCT_GUI_TEXT_RICH;
	      } break;
	      case  6: {	/* rich2 */
	        el->textStyle |= DKCT_GUI_TEXT_RICH2;
	      } break;
	      case  7: {	/* url */
	        el->textStyle |= DKCT_GUI_TEXT_URL;
	      } break;
	      case  8: {	/* selection */
	        el->textStyle |= DKCT_GUI_TEXT_SHOWSEL;
	      } break;
	      case  9: {	/* left */
	        el->textStyle |= DKCT_GUI_TEXT_LEFT;
	      } break;
	      case 10: {	/* centered */
	        el->textStyle |= DKCT_GUI_TEXT_CENTRE;
	      } break;
	      case 11: {	/* right */
	        el->textStyle |= DKCT_GUI_TEXT_RIGHT;
	      } break;
	      case 12: {	/* nowrap */
	        el->textStyle |= DKCT_GUI_TEXT_NOWRAP;
	      } break;
	      case 13: {	/* charwrap */
	        el->textStyle |= DKCT_GUI_TEXT_CHARWRAP;
	      } break;
	      case 14: {	/* wordwrap */
	        el->textStyle |= DKCT_GUI_TEXT_WORDWRAP;
	      } break;
	      case 15: {	/* bestwrap */
	        el->textStyle |= DKCT_GUI_TEXT_BESTWRAP;
	      } break;
	      case 16: {	/* capitalize */
	        if(el->cln == 31) {
	          el->textStyle |= DKCT_GUI_TEXT_CAPITALIZE;
		}
	      } break;
	      case 17: {
	        el->textStyle |= DKCT_GUI_TEXT_NO_AUTORESIZE;
	      } break;
	      default: {
	        back = 0;
		(gui->psrc)->ec = DK3_ERROR_SYNTAX;
		dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	      } break;
	    }
	    p1 = p2;
          }
        }
    }
  }
  

#line 3414 "dkct-gui.ctr"
  return back;
}



/**	Set button style.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_button_style(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Current string to process. */
  char			*p2;		/* Next string to process. */
  int			 back = 0;
  

#line 3433 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    p1 = dk3str_c8_start(il, NULL);
    if(p1) {
      back = 1;
      while(p1) {
        p2 = dk3str_c8_next(p1, NULL);
	switch(dk3str_c8_array_index(dkct_gui_notebook_button_names, p1, 0)) {
	  case 0: {	/* left */
	    el->buttonStyle |= DKCT_GUI_BUTTON_LEFT;
	  } break;
	  case 1: {	/* top */
	    el->buttonStyle |= DKCT_GUI_BUTTON_TOP;
	  } break;
	  case 2: {	/* right */
	    el->buttonStyle |= DKCT_GUI_BUTTON_RIGHT;
	  } break;
	  case 3: {	/* bottom */
	    el->buttonStyle |= DKCT_GUI_BUTTON_BOTTOM;
	  } break;
	  case 4: {	/* fit */
	    el->buttonStyle |= DKCT_GUI_BUTTON_EXACTFIT;
	  } break;
	  case 5: {	/* no border */
	    el->buttonStyle |= DKCT_GUI_BUTTON_NO_BORDER;
	  } break;
	  default: {
	    back = 0;
	    /* ERROR: Unknown keyword. */
	    (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	    dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	  } break;
	}
	p1 = p2;
      }
    }
  }
  

#line 3471 "dkct-gui.ctr"
  return back;
}



/**	Set notebook style.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_notebook_style(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Current string to process. */
  char			*p2;		/* Next string to process. */
  int			 back = 0;
  

#line 3490 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 12: {
      } break;
      default: {	

#line 3496 "dkct-gui.ctr"
        /* Warning: Attribute not applicable for class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
        p1 = dk3str_c8_start(il, NULL);
	if(p1) {
	  back = 1;
	  while(p1) {
	    p2 = dk3str_c8_next(p1, NULL);
	    switch(dk3str_c8_array_index(dkct_gui_notebook_style_names, p1, 0))
	    {
	      case 0: {	/* top */
	        el->notebookStyle |= DKCT_GUI_NB_TOP;
	      } break;
	      case 1: {	/* left */
	        el->notebookStyle |= DKCT_GUI_NB_LEFT;
	      } break;
	      case 2: {	/* right */
	        el->notebookStyle |= DKCT_GUI_NB_RIGHT;
	      } break;
	      case 3: {	/* bottom */
	        el->notebookStyle |= DKCT_GUI_NB_BOTTOM;
	      } break;
	      case 4: {	/* fixed-width */
	        el->notebookStyle |= DKCT_GUI_NB_FIXEDWIDTH;
	      } break;
	      case 5: {	/* multiline */
	        el->notebookStyle |= DKCT_GUI_NB_MULTILINE;
	      } break;
	      case 6: {	/* no-theme */
	        el->notebookStyle |= DKCT_GUI_NB_NOPAGETHEME;
	      } break;
	      case 7: {	/* flat */
	        el->notebookStyle |= DKCT_GUI_NB_FLAT;
	      } break;
	      default: {
	        back = 0;
		(gui->psrc)->ec = DK3_ERROR_SYNTAX;
		dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	      } break;
	    }
	    p1 = p2;
	  }
	}
    }
  }
  

#line 3544 "dkct-gui.ctr"
  return back;
}



/**	Set slider style.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_slider_style(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Current string to process. */
  char			*p2;		/* Next string to process. */
  int			back = 0;
  

#line 3563 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 27: {
      } break;
      default: {	

#line 3569 "dkct-gui.ctr"
        /* Warning: Attribute not applicable for class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    p1 = dk3str_c8_start(il, NULL);
    if(p1) {
      back = 1;
      while(p1) {
        p2 = dk3str_c8_next(p1, NULL);
	switch(dk3str_c8_array_index(dkct_gui_slider_style_names, p1, 0)) {
	  case 0: {
	    el->sliderStyle |= DKCT_GUI_SL_STYLE_AUTOTICKS;
	  } break;
	  case 1: {
	    el->sliderStyle |= DKCT_GUI_SL_STYLE_LABELS;
	  } break;
	  case 2: {
	    el->sliderStyle |= DKCT_GUI_SL_STYLE_LEFT;
	  } break;
	  case 3: {
	    el->sliderStyle |= DKCT_GUI_SL_STYLE_RIGHT;
	  } break;
	  case 4: {
	    el->sliderStyle |= DKCT_GUI_SL_STYLE_TOP;
	  } break;
	  case 5: {
	    el->sliderStyle |= DKCT_GUI_SL_STYLE_BOTTOM;
	  } break;
	  case 6: {
	    el->sliderStyle |= DKCT_GUI_SL_STYLE_SELRANGE;
	  } break;
	  case 7: {
	    el->sliderStyle |= DKCT_GUI_SL_STYLE_INVERSE;
	  } break;
	  default: {
	    back = 0;
	    /* ERROR: Syntax, unknown slider style name! */
	    (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	    dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	  } break;
	}
	p1 = p2;
      }
    }
  }
  

#line 3615 "dkct-gui.ctr"
  return back;
}



/**	Set splitter window style.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_splitter_window_style(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Current string to process. */
  char			*p2;		/* Next string to process .*/
  int			 back = 0;
  

#line 3634 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 14: {
      } break;
      default: {	

#line 3640 "dkct-gui.ctr"
        /* Warning: Attribute not applicable for class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
        p1 = dk3str_c8_start(il, NULL);
	if(p1) {
	  back = 1;
	  el->splitterStyle = 0U;
	  while(p1) {
	    p2 = dk3str_c8_next(p1, NULL);
	    switch(dk3str_c8_array_index(dkct_gui_splitterw_style_names,p1,0)) {
	      case 0: {
	        el->splitterStyle |= DKCT_GUI_SPLITTERW_3D;
	      } break;
	      case 1: {
	        el->splitterStyle |= DKCT_GUI_SPLITTERW_3D_SASH;
	      } break;
	      case 2: {
	        el->splitterStyle |= DKCT_GUI_SPLITTERW_3D_BORDER;
	      } break;
	      case 3: {
	        el->splitterStyle |= DKCT_GUI_SPLITTERW_BORDER;
	      } break;
	      case 4: {
	        el->splitterStyle |= DKCT_GUI_SPLITTERW_NO_BORDER;
	      } break;
	      case 5: {
	        el->splitterStyle |= DKCT_GUI_SPLITTERW_NO_XP_THEME;
	      } break;
	      case 6: {
	        el->splitterStyle |= DKCT_GUI_SPLITTERW_PERMIT_UNSPLIT;
	      } break;
	      case 7: {
	        el->splitterStyle |= DKCT_GUI_SPLITTERW_LIVE_UPDATE;
	      } break;
	      default: {
	        (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	        dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	      } break;
	    }
	    p1 = p2;
	  }
	}
    }
  }
  

#line 3687 "dkct-gui.ctr"
  return back;
}



/**	Set bitmap button style.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_bitmap_button_style(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Current string to process. */
  char			*p2;		/* Next string to process. */
  int			 back = 0;
  

#line 3706 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 16:
      case 32:
      case 40:
      {
      } break;
      default: {	

#line 3715 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to object! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
        p1 = dk3str_c8_start(il, NULL);
	if(p1) {
	  back = 1;
	  el->bitmapbStyle = 0x00;
	  while(p1) {
	    p2 = dk3str_c8_next(p1, NULL);
	    switch(dk3str_c8_array_index(dkct_gui_bitmapb_style_names, p1, 0)) {
	      case 0: {
	        el->bitmapbStyle |= DKCT_GUI_BBUTTON_AUTODRAW;
	      } break;
	      case 1: {
	        el->bitmapbStyle |= DKCT_GUI_BBUTTON_LEFT;
	      } break;
	      case 2: {
	        el->bitmapbStyle |= DKCT_GUI_BBUTTON_TOP;
	      } break;
	      case 3: {
	        el->bitmapbStyle |= DKCT_GUI_BBUTTON_RIGHT;
	      } break;
	      case 4: {
	        el->bitmapbStyle |= DKCT_GUI_BBUTTON_BOTTOM;
	      } break;
	      default: {
	        /* ERROR: Unknown style entry! */
		(gui->psrc)->ec = DK3_ERROR_SYNTAX;
		dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
		back = 0;
	      } break;
	    }
	    p1 = p2;
	  }
	}
    }
  }
  

#line 3755 "dkct-gui.ctr"
  return back;
}



/**	Set gauge style.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_gauge_style(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Current string to process. */
  char			*p2;		/* Next string to process. */
  int			 back = 0;
  

#line 3774 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 30: {
      } break;
      default: {
        /* Only allowed for gauge elements! */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
        p1 = dk3str_c8_start(il, NULL);
	if(p1) {
	  back = 1;
	  while(p1) {
	    p2 = dk3str_c8_next(p1, NULL);
	    switch(dk3str_c8_array_index(dkct_gui_gauge_style_names, p1, 0)) {
	      case 0: {
	        el->gaugeStyle |= DKCT_GUI_GAUGE_SMOOTH;
	      } break;
	      default: {
	        /* Illegal keyword */
		(gui->psrc)->ec = DK3_ERROR_SYNTAX;
		dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
		back = 0;
	      } break;
	    }
	    p1 = p2;
	  }
	}
    }
  }
  

#line 3807 "dkct-gui.ctr"
  return back;
}



/**	Set icon.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_icon(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;
  char			*p1;
  int			 back = 0;
  

#line 3825 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    dk3_release(el->icon);
    p1 = dk3str_c8_start(il, NULL);
    if(p1) {
      dk3str_c8_delnl(p1);
      el->icon = dk3str_c8_dup_app(p1, (gui->psrc)->app);
      if((el->parent) || (el->number)) {
        /* Warning: Icon is recommended for top level windows only! */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 63);
      }
      if(el->icon) {
        back = 1;
      } else {
        (gui->psrc)->ec = DK3_ERROR_MEMORY;
	/* ERROR: Memory */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
      }
    } else {
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 33);
    }
  }
  

#line 3849 "dkct-gui.ctr"
  return back;
}



/**	Set menu item style.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_menu_item_style(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Current string to process. */
  char			*p2;		/* Next string to process. */
  int			 back = 0;
  

#line 3868 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 37:
      case 40:
      {
      } break;
      default: {	

#line 3876 "dkct-gui.ctr"
        /* Warning: Attribute not applicable for class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
        p1 = dk3str_c8_start(il, NULL);
	if(p1) {
	  back = 1;
	  while(p1) {
	    p2 = dk3str_c8_next(p1, NULL);
	    switch(dk3str_c8_array_index(dkct_gui_menu_item_style_names, p1, 0))
	    {
	      case 0: {
	        el->menuItemStyle = DKCT_GUI_MENU_ITEM_NORMAL;
	      } break;
	      case 1: {
	        el->menuItemStyle = DKCT_GUI_MENU_ITEM_SEPARATOR;
		if(el->cln == 40) {
		  back = 0;
		  /* ERROR: Not allowed for tool bar buttons */
		  (gui->psrc)->ec = DK3_ERROR_SYNTAX;
		  dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
		}
	      } break;
	      case 2: {
	        el->menuItemStyle = DKCT_GUI_MENU_ITEM_CHECK;
	      } break;
	      case 3: {
	        el->menuItemStyle = DKCT_GUI_MENU_ITEM_RADIO;
	      } break;
	      default: {
	        back = 0;
		/* ERROR: Unknown style! */
		(gui->psrc)->ec = DK3_ERROR_SYNTAX;
		dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	      } break;
	    }
	    p1 = p2;
	  }
	}
    }
  }
  

#line 3919 "dkct-gui.ctr"
  return back;
}



/**	Set toolbar style.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_toolbar_style(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Current string to process. */
  char			*p2;		/* Next string to process. */
  int			 back = 0;
  

#line 3938 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 38: {
      } break;
      default: {	

#line 3944 "dkct-gui.ctr"
        /* Warning: Attribute not applicable for class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
        p1 = dk3str_c8_start(il, NULL);
	if(p1) {
	  back = 1;
	  while(p1) {
	    p2 = dk3str_c8_next(p1, NULL);
	    switch(dk3str_c8_array_index(dkct_gui_toolbar_style_names,p1,0)) {
	      case 0: {
	        el->toolbarStyle |= DKCT_GUI_TOOLBAR_FLAT;
	      } break;
	      case 1: {
	        el->toolbarStyle |= DKCT_GUI_TOOLBAR_DOCKABLE;
	      } break;
	      case 2: {
	        el->toolbarStyle |= DKCT_GUI_TOOLBAR_TEXT;
	      } break;
	      case 3: {
	        el->toolbarStyle |= DKCT_GUI_TOOLBAR_NOICONS;
	      } break;
	      case 4: {
	        el->toolbarStyle |= DKCT_GUI_TOOLBAR_NODIVIDER;
	      } break;
	      case 5: {
	        el->toolbarStyle |= DKCT_GUI_TOOLBAR_HORZ_LAYOUT;
	      } break;
	      case 6: {
	        el->toolbarStyle |= DKCT_GUI_TOOLBAR_NO_TOOLTIPS;
	      } break;
	      case 7: {
	        el->toolbarStyle |= DKCT_GUI_TOOLBAR_BOTTOM;
	      } break;
	      case 8: {
	        el->toolbarStyle |= DKCT_GUI_TOOLBAR_RIGHT;
	      } break;
	      default: {
	        back = 0;
		/* ERROR: Unknown style keyword */
		(gui->psrc)->ec = DK3_ERROR_SYNTAX;
		dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	      } break;
	    }
	    p1 = p2;
	  }
	}
    }
  }
  

#line 3995 "dkct-gui.ctr"
  return back;
}



/**	Set choices for combo, list etc.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_choices(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Current string to process. */
  char			*p2;		/* Next string to process. */
  int			 i;		/* Number read from text. */
  int			 back = 0;
  

#line 4015 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 17:	/* wxChoice */
      case 18:	/* wxComboBox */
      case 20:	/* wxListBox */
      case 21:	/* wxCheckListBox */
      case 22:  /* wxRadioBox */
      {
      } break;
      default: {	

#line 4026 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
        p1 = dk3str_c8_start(il, NULL);
        if(p1) {
          p2 = dk3str_c8_next(p1, NULL);
	  if(p2) {	

#line 4035 "dkct-gui.ctr"
	    if(sscanf(p1, "%i", &i) == 1) {
	      if(i > 0) {
	        el->nChoices = i;
	        if(el->choices) {
	          /* Warning: Redefinition */
		  dkct_to_log_3(gui->psrc,1,DK3_LL_WARNING,74,75,el->choices);
	        }
		dk3_release(el->choices);
	        el->choices = dk3str_c8_dup_app(p2, (gui->psrc)->app);
	        if(el->choices) {
	          back = 1;
	        } else {
	          /* ERROR: Memory */
	  	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 29);
		  (gui->psrc)->ec = DK3_ERROR_MEMORY;
	        }
	      }
	    }
	  } else {	

#line 4054 "dkct-gui.ctr"
	    if(el->choices) {
	      /* Warning: Redefinition */
	      dkct_to_log_3(gui->psrc,1,DK3_LL_WARNING,74,75,el->choices);
	    }
	    dk3_release(el->choices);
	    el->nChoices = -1;
	    el->choices = dk3str_c8_dup_app(p1, (gui->psrc)->app);
	    if(el->choices) {
	      back = 1;
	    } else {
	      /* ERROR: Memory */
	      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 29);
	      (gui->psrc)->ec = DK3_ERROR_MEMORY;
	    }
	  }
        }
    }
  }
  

#line 4073 "dkct-gui.ctr"
  return back;
}



/**	Set style for list box.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_list_box_style(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Start of text. */
  int			 back = 0;
  

#line 4091 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 20:	/* list box */
      case 21:	/* check list box */
      {
      } break;
      default: {	

#line 4099 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
        p1 = dk3str_c8_start(il, NULL);
	if(p1) {
	  switch(dk3str_c8_array_index(dkct_gui_cb_sel_names, p1, 0)) {
	    case 0: {
	      el->selStyle = DKCT_GUI_SELECTION_STYLE_SINGLE; back = 1;
	    } break;
	    case 1: {
	      el->selStyle = DKCT_GUI_SELECTION_STYLE_MULTIPLE; back = 1;
	    } break;
	    case 2: {
	      el->selStyle = DKCT_GUI_SELECTION_STYLE_EXTENDED; back = 1;
	    } break;
	    default: {
	      /* ERROR: Illegal argument! */
	      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	      dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	    } break;
	  }
	}
    }
  }
  

#line 4126 "dkct-gui.ctr"
  return back;
}



/**	Set max number of rows/columns for radio box.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@param	how	Rows (0), columns (1).
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_rb_max(DKCT_GUI *gui, char *il, int how)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Start of text. */
  int			 i;		/* Number read from text. */
  int			 back = 0;
  

#line 4146 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 22: case 41:
      {
      } break;
      default: {	

#line 4153 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
      switch(el->cln) {
        case 22: {
          p1 = dk3str_c8_start(il, NULL);
	  if(p1) {
	    if(sscanf(p1, "%d", &i) == 1) {
	      if(i > 0) {
	        back = 1;
	        el->maxRowsCols = i;
	        if(how) {
	          el->rbDirection = DKCT_GUI_RB_DIR_COLUMNS;
	        } else {
	          el->rbDirection = DKCT_GUI_RB_DIR_ROWS;
	        }
	      } else {
	        (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	        /* ERROR: Out of range. */
	        dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 82, 83, p1);
	      }
	    } else {
	      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	      dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	    }
	  } else {
	    /* ERROR: Missing argument */
	  }
	} break;
	case 41: {
	  p1 = dk3str_c8_start(il, NULL);	

#line 4186 "dkct-gui.ctr"
	  if(p1) {
	    if(sscanf(p1, "%d", &i) == 1) {
	      if(i > 0) {
	        back = 1;
	        if(how) {
		  el->nColumns = i;
		} else {
		  el->nRows = i;
		}
	      } else {				

#line 4196 "dkct-gui.ctr"
	        (gui->psrc)->ec = DK3_ERROR_SYNTAX;
		dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 82, 83, p1);
	      }
	    } else {			

#line 4200 "dkct-gui.ctr"
	      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	      dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p1);
	    }
	  }				

#line 4204 "dkct-gui.ctr"
	} break;
      }
    }
  }
  

#line 4209 "dkct-gui.ctr"
  return back;
}



/**	Set states for checkbox.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_states(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Current string to process. */
  char			*p2;		/* Next string to process. */
  int			 i;		/* Number read from text. */
  int			 back = 0;
  

#line 4229 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 19:	/* wxCheckBox */
      {
      } break;
      default: {	

#line 4236 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
        i = 0;
        p1 = dk3str_c8_start(il, NULL);
	if(p1) {
	  p2 = dk3str_c8_next(p1, NULL);
	  if(sscanf(p1, "%d", &i) == 1) {
	    if((i == 2) || (i == 3)) {
	      if(i == 3) el->nStates = 0x03;
	      else el->nStates = 0x02;
	      back = 1;
	      if(p2) {
	        switch(dk3str_c8_array_index(dkct_gui_db_state_names, p2, 0)) {
		  case 0: {
		    el->state = 0x00;
		  } break;
		  case 1: {
		    el->state = 0x01;
		  } break;
		  case 2: {
		    if(el->nStates == 0x03) {
		      el->state = 0x02;
		    } else {
		      back = 0;
		    }
		  } break;
		  default: {
		    back = 0;
		    /* ERROR: Invalid state */
		    (gui->psrc)->ec = DK3_ERROR_SYNTAX;
		    dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 76, 77, p2);
		  } break;
		}
	      }
	    } else {
	      /* ERROR: Out of range! */
	      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	      dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 82, 83, p1);
	    }
	  } else {
	    /* ERROR: Not a number */
	    (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 31);
	  }
	}
    }
  }
  

#line 4287 "dkct-gui.ctr"
  return back;
}



/**	Set bitmap for bitmap button.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_bitmap(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Start of text. */
  int			 back = 0;
  

#line 4305 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    switch(el->cln) {
      case 16:
      case 32:
      case 37:
      case 40:
      {
      } break;
      default: {	

#line 4315 "dkct-gui.ctr"
        /* Warning: Attribute not applicable to class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
    {
        p1 = dk3str_c8_start(il, NULL);
        if(p1) {
          dk3str_c8_delnl(p1);
	  dk3_release(el->bitmapVarName);
          el->bitmapVarName = dk3str_c8_dup_app(il, (gui->psrc)->app);
          if(el->bitmapVarName) {
            back = 1;
          } else {
            (gui->psrc)->ec = DK3_ERROR_MEMORY;
	    /* ERROR: Memory */
	    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
          }
        }
    }
  }
  

#line 4336 "dkct-gui.ctr"
  return back;
}



/**	Set disabled bitmap for bitmap button.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_bitmap_disabled(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Start of text. */
  int			 back = 0;
  

#line 4354 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    if(!((el->cln == 16) || (el->cln == 40))) { 

#line 4357 "dkct-gui.ctr"
      /* Warning: Attribute not applicable to class! */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
    }
    p1 = dk3str_c8_start(il, NULL);
    if(p1) {
      dk3str_c8_delnl(p1);
      dk3_release(el->bitmapDisabled);
      el->bitmapDisabled = dk3str_c8_dup_app(il, (gui->psrc)->app);
      if(el->bitmapDisabled) {
        back = 1;
      } else {
        (gui->psrc)->ec = DK3_ERROR_MEMORY;
	/* ERROR: Memory */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
      }
    }
  }
  

#line 4375 "dkct-gui.ctr"
  return back;
}



/**	Set selected bitmap for bitmap button.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_bitmap_selected(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Value for bitmap. */
  int			 back = 0;
  

#line 4393 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    if(el->cln != 16) {	

#line 4396 "dkct-gui.ctr"
      /* Warning: Attribute not applicable for class! */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
    }
    {
      p1 = dk3str_c8_start(il, NULL);
      if(p1) {
        dk3str_c8_delnl(p1);
	dk3_release(el->bitmapSelected);
        el->bitmapSelected = dk3str_c8_dup_app(il, (gui->psrc)->app);
        if(el->bitmapSelected) {
          back = 1;
        } else {
          (gui->psrc)->ec = DK3_ERROR_MEMORY;
	  /* ERROR: Memory */
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
        }
      }
    }
  }
  

#line 4416 "dkct-gui.ctr"
  return back;
}



/**	Set focus bitmap for bitmap button.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_bitmap_focus(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Bitmap value. */
  int			 back = 0;
  

#line 4434 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    if(el->cln != 16) {	

#line 4437 "dkct-gui.ctr"
      /* Warning: Attribute not applicable for class! */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
    }
    {
      p1 = dk3str_c8_start(il, NULL);
      if(p1) {
        dk3str_c8_delnl(p1);
	dk3_release(el->bitmapFocus);
        el->bitmapFocus = dk3str_c8_dup_app(il, (gui->psrc)->app);
        if(el->bitmapFocus) {
          back = 1;
        } else {
          (gui->psrc)->ec = DK3_ERROR_MEMORY;
	  /* ERROR: Memory */
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
        }
      }
    }
  }
  

#line 4457 "dkct-gui.ctr"
  return back;
}



/**	Set hover bitmap for bitmap button.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_set_bitmap_hover(DKCT_GUI *gui, char *il)
{
  DKCT_GUI_ELEMENT	*el;		/* Element to modify. */
  char			*p1;		/* Bitmap value. */
  int			 back = 0;
  

#line 4475 "dkct-gui.ctr"
  el = gui->c_el;
  if(el) {
    if(el->cln != 16) {	

#line 4478 "dkct-gui.ctr"
      /* Warning: Attribute not applicable for class! */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
    }
    {
      p1 = dk3str_c8_start(il, NULL);
      if(p1) {
        dk3str_c8_delnl(p1);
	dk3_release(el->bitmapHover);
        el->bitmapHover = dk3str_c8_dup_app(il, (gui->psrc)->app);
        if(el->bitmapHover) {
          back = 1;
        } else {
          (gui->psrc)->ec = DK3_ERROR_MEMORY;
	  /* ERROR: Memory */
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 57);
        }
      }
    }
  }
  

#line 4498 "dkct-gui.ctr"
  return back;
}



/**	Add row/column head.
	@param	gui	GUI description.
	@param	pv	Text for head.
	@param	how	Direction (0=row head, 1=column head).
	@return	1 on success, 0 on error.
*/
static
int
dkct_add_grid_head(DKCT_GUI *gui, char const *pv, int how)
{
  DKCT_GRID_HEAD	*gh;
  int			 back = 0;
  

#line 4516 "dkct-gui.ctr"
  if((gui->c_el) && (pv)) {
    switch((gui->c_el)->cln) {
      case 41: {
        if(how) {		

#line 4520 "dkct-gui.ctr"
          if(!((gui->c_el)->sColumnHeads)) {
            (gui->c_el)->sColumnHeads = dk3sto_open_app((gui->psrc)->app);
	    if((gui->c_el)->sColumnHeads) {
	      dk3sto_set_comp(
	        (gui->c_el)->sColumnHeads, dkct_grid_head_compare, 0
	      );
	    }
          }
          if(!((gui->c_el)->iColumnHeads)) {
            if((gui->c_el)->sColumnHeads) {
	      (gui->c_el)->iColumnHeads =
	      dk3sto_it_open((gui->c_el)->sColumnHeads);
	    }
          }
          if(((gui->c_el)->sColumnHeads) && ((gui->c_el)->iColumnHeads)) {
            gh = dkct_grid_head_new(pv, (gui->c_el)->nColumnHeads, gui->psrc);
	    if(gh) {
	      if(dk3sto_add((gui->c_el)->sColumnHeads, gh)) {
	        back = 1    ;
	        (gui->c_el)->nColumnHeads += 1;
	      } else {
	        dkct_grid_head_delete(gh);
		dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
	      }
            } else {
	      dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
	    }
          } else {
	    dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
	  }
        } else {		

#line 4551 "dkct-gui.ctr"
          if(!((gui->c_el)->sRowHeads)) {
            (gui->c_el)->sRowHeads = dk3sto_open_app((gui->psrc)->app);
	    if((gui->c_el)->sRowHeads) {
	      dk3sto_set_comp((gui->c_el)->sRowHeads,dkct_grid_head_compare,0);
	    }
          }
          if(!((gui->c_el)->iRowHeads)) {
            if((gui->c_el)->sRowHeads) {
	      (gui->c_el)->iRowHeads = dk3sto_it_open((gui->c_el)->sRowHeads);
	    }
          }
          if(((gui->c_el)->sRowHeads) && ((gui->c_el)->iRowHeads)) {
            gh = dkct_grid_head_new(pv, (gui->c_el)->nRowHeads, gui->psrc);
	    if(gh) {
	      if(dk3sto_add((gui->c_el)->sRowHeads, gh)) {
	        back = 1;
	        (gui->c_el)->nRowHeads += 1;
	      } else {
	        dkct_grid_head_delete(gh);
		dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
	      }
	    } else {
	      dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
	    }
          } else {
	    dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
	  }
        }
      } break;
      default: {
        /* Warning: Attribute not applicable for class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
  } 

#line 4586 "dkct-gui.ctr"
  return back;
}



/**	Set gridTable entry for current object.
	@param	gui	GUI description.
	@param	pv	Text to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_set_table_for_grid(DKCT_GUI *gui, char *pv)
{
  char			*p1 = NULL;
  char			*p2 = NULL;
  int			 back = 0;
  if(gui->c_el) {
    switch((gui->c_el)->cln) {
      case 41: {
        p1 = dk3str_c8_start(pv, NULL);
	if(p1) {
	  p2 = dk3str_c8_next(p1, NULL);
	  if((gui->c_el)->gridTable) {
	    dkct_to_log_3(
	      gui->psrc, 1, DK3_LL_ERROR, 74, 75, (gui->c_el)->gridTable
	    );
	  }
	  dk3_release((gui->c_el)->gridTable);
	  (gui->c_el)->gridTable = dk3str_c8_dup_app(pv, (gui->psrc)->app);
	  if((gui->c_el)->gridTable) {
	    back = 1;
	    if(p2) {
	      if(dk3str_c8_is_on(p2)) {
	        (gui->c_el)->tableOwner = 0x01;
	      }
	    }
	  } else {
	    dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
	  }
	} else {
	  /* ERROR: Empty text! */
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 69);
	}
      } break;
      default: {
        /* Warning: Attribute not applicable for class! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 56);
      } break;
    }
  }
  return back;
}



/**	Set minimum size for an object.
	@param	gui	GUI description.
	@param	pv	Text containing the size in pixels.
	@return	1 on success, 0 on error.
*/
static
int
dkct_set_minimum_size(DKCT_GUI *gui, char *pv)
{
  char			*p1;
  char			*p2;
  int			 i1;
  int			 i2;
  int			 back = 0;
  p1 = dk3str_c8_start(pv, NULL);
  if(p1) {
    p2 = dk3str_c8_next(p1, NULL);
    if(p2) {
      if(1 == sscanf(p1, "%d", &i1)) {
        if(1 == sscanf(p2, "%d", &i2)) {
	  if(i1 < 0) i1 = 0;
	  if(i2 < 0) i2 = 0;
	  back = 1;
	  if(gui->c_el) {
	    (gui->c_el)->sizemx = i1;
	    (gui->c_el)->sizemy = i2;
	  }
	} else {
	  dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 64, 65, p2);
	}
      } else {
        dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 64, 65, p1);
      }
    } else {
      dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
    }
  } else {
    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 69);
  }
  return back;
}



/**	Compare two int pointers by number, reverse sort order.
	@param	l	Left pointer.
	@param	r	Right pointer.
	@param	cr	Comparison criteria, ignored.
	@return	Comparison result for inverted sort order.
*/
static
int
dkct_int_compare(void const *l, void const *r, int cr)
{
  int const	*pl;
  int const	*pr;
  int		 back = 0;
  pl = (int const *)l; pr = (int const *)r;
  if(pl) {
    if(pr) {
      if(*pl > *pr) back = -1;
      else {
        if(*pl < *pr) back = 1;
      }
    } else back = -1;
  } else {
    if(pr) back = 1;
  }
  return back;
}



/**	Note information about a growable row.
	@param	gui	GUI description.
	@param	pv	Text containing the row number.
	@return	1 on success, 0 on error.
*/
static
int
dkct_add_growable_row(DKCT_GUI *gui, char *pv)
{
  int			*ip;
  int			 back = 0;
  int			 i;
  if(gui->c_el) {
  if(1 == sscanf(pv, "%d", &i)) {
    if(i >= 0) {
      if(!((gui->c_el)->sGrowRow)) {
        (gui->c_el)->sGrowRow = dk3sto_open_app((gui->psrc)->app);
        if((gui->c_el)->sGrowRow) {
          dk3sto_set_comp((gui->c_el)->sGrowRow, dkct_int_compare, 0);
        }
      }
      if(!((gui->c_el)->iGrowRow)) {
        if((gui->c_el)->sGrowRow) {
          (gui->c_el)->iGrowRow = dk3sto_it_open((gui->c_el)->sGrowRow);
        }
      }
      if(((gui->c_el)->sGrowRow) && ((gui->c_el)->iGrowRow)) {
        ip = dk3_new_app(int,1,(gui->psrc)->app);
        if(ip) {
          *ip = i;
	  if(dk3sto_add((gui->c_el)->sGrowRow, (void *)ip)) {
	    back = 1;
	  } else {
	    dk3_delete(ip);
	    /* ERROR: Memory */
	    dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
	  }
        } else {
          /* ERROR: Memory */
	  dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
        }
      } else {
        /* ERROR: Memory */
	dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
      }
    } else {
      /* ERROR: Syntax */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 112);
    }
  } else {
    /* ERROR: Not a number! */
    dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 64, 65, pv);
  }
  }
  return back;
}



/**	Note information about a growable row.
	@param	gui	GUI description.
	@param	pv	Text containing the row number.
	@return	1 on success, 0 on error.
*/
static
int
dkct_add_growable_column(DKCT_GUI *gui, char *pv)
{
  int			*ip;
  int			 back = 0;
  int			 i;
  if(gui->c_el) {
  if(1 == sscanf(pv, "%d", &i)) {
    if(i >= 0) {
      if(!((gui->c_el)->sGrowCol)) {
        (gui->c_el)->sGrowCol = dk3sto_open_app((gui->psrc)->app);
        if((gui->c_el)->sGrowCol) {
          dk3sto_set_comp((gui->c_el)->sGrowCol, dkct_int_compare, 0);
        }
      }
      if(!((gui->c_el)->iGrowCol)) {
        if((gui->c_el)->sGrowCol) {
          (gui->c_el)->iGrowCol = dk3sto_it_open((gui->c_el)->sGrowCol);
        }
      }
      if(((gui->c_el)->sGrowCol) && ((gui->c_el)->iGrowCol)) {
        ip = dk3_new_app(int,1,(gui->psrc)->app);
        if(ip) {
          *ip = i;
	  if(dk3sto_add((gui->c_el)->sGrowCol, (void *)ip)) {
	    back = 1;
	  } else {
	    dk3_delete(ip);
	    /* ERROR: Memory */
	    dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
	  }
        } else {
          /* ERROR: Memory */
	  dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
        }
      } else {
        /* ERROR: Memory */
	dkct_to_log_1(gui->psrc, 0, DK3_LL_ERROR, 29);
      }
    } else {
      /* ERROR: Syntax */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 112);
    }
  } else {
    /* ERROR: Not numeric! */
    dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 64, 65, pv);
  }
  }
  return back;
}



/**	Set "complete constructor specified" attribute.
	@param	gui	GUI description.
	@param	pv	Text to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_set_complete_constructor_specified(DKCT_GUI *gui, char *pv)
{
  int		back = 0;
  if(gui->c_el) {
    if(pv) {
      if(dk3str_c8_is_bool(pv)) {
        back = 1;
        if(dk3str_c8_is_on(pv)) {
          (gui->c_el)->compConst = 0x01;
        } else {
          (gui->c_el)->compConst = 0x00;
        }
      } else {
        /* ERROR: Not a boolean value! */
        dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 70);
      }
    } else {
      (gui->c_el)->compConst = 0x00;
      back = 1;
    }
  }
  return back;
}



/**	Process one line containing object details.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_process_object_line(DKCT_GUI *gui, char *il)
{
  int		 back	= 1;
  char		*pv;		/* Value. */
  int		 action;	/* Attribute index. */
  

#line 4879 "dkct-gui.ctr"
  if(gui->c_el) {
    pv = dk3str_c8_chr(il, '=');
    if(pv) {
      *(pv++) = '\0';
      pv = dk3str_c8_start(pv, NULL);
      if(pv) {
        dk3str_c8_normalize(il, NULL, '-');
	action = dk3str_c8_array_index(dkct_gui_attribute_keys, il, 0);
	switch(action) {
	  case 0: case 23: {		

#line 4889 "dkct-gui.ctr"
	    back = dkct_gui_set_expand(gui, pv);
	  } break;
	  case 1: {		

#line 4892 "dkct-gui.ctr"
	    back = dkct_gui_set_type(gui, pv);
	  } break;
	  case 2: {		

#line 4895 "dkct-gui.ctr"
	    back = dkct_gui_set_menu_bar(gui, pv);
	  } break;
	  case 3: {		

#line 4898 "dkct-gui.ctr"
	    back = dkct_gui_set_tool_bar(gui, pv);
	  } break;
	  case 4: {		

#line 4901 "dkct-gui.ctr"
	    back = dkct_gui_set_status_bar(gui, pv);
	  } break;
	  case 5: {		

#line 4904 "dkct-gui.ctr"
	    back = dkct_gui_add_contents(gui, pv);
	  } break;
	  case 6: {		

#line 4907 "dkct-gui.ctr"
	    back = dkct_gui_set_text(gui, pv);
	  } break;
	  case 7: {		

#line 4910 "dkct-gui.ctr"
	    back = dkct_gui_set_id(gui, pv);
	  } break;
	  case 8: {		

#line 4913 "dkct-gui.ctr"
	    back = dkct_gui_set_tip_text(gui, pv);
	  } break;
	  case 9: {		

#line 4916 "dkct-gui.ctr"
	    back = dkct_gui_set_proportion(gui, pv);
	  } break;
	  case 10: {		

#line 4919 "dkct-gui.ctr"
	    back = dkct_gui_set_status_text(gui, pv);
	  } break;
	  case 11: {		

#line 4922 "dkct-gui.ctr"
	    back = dkct_gui_set_border(gui, pv);
	  } break;
	  case 12: {		

#line 4925 "dkct-gui.ctr"
	    back = dkct_gui_set_constructor(gui, pv);
	  } break;
	  case 13: {
	    back = dkct_gui_set_grid(gui, pv);
	  } break;
	  case 14: {
	    back = dkct_gui_set_sash(gui, pv);
	  } break;
	  case 15: {
	    back = dkct_gui_set_min_pane_size(gui, pv);
	  } break;
	  case 16: {
	    back = dkct_gui_set_bitmap(gui, pv);
	  } break;
	  case 17: {
	    back = dkct_gui_set_choices(gui, pv);
	  } break;
	  case 18: {
	    back = dkct_gui_set_states(gui, pv);
	  } break;
	  case 19: {
	    back = dkct_gui_set_size_for_object(gui, pv);
	  } break;
	  case 20: {
	    back = dkct_gui_set_list_box_style(gui, pv);
	  } break;
	  case 21: {
	    back = dkct_gui_set_rb_max(gui, pv, 0);
	  } break;
	  case 22: {
	    back = dkct_gui_set_rb_max(gui, pv, 1);
	  } break;
	  case 24: {
	    back = dkct_gui_start_radio_button_group(gui, pv);
	  } break;
	  case 25: {
	    back = dkct_gui_set_direction(gui, pv);
	  } break;
	  case 26: {
	    back = dkct_gui_set_range(gui, pv);
	  } break;
	  case 27: {
	    back = dkct_gui_set_wrap(gui, pv);
	  } break;
	  case 28: {
	    back = dkct_gui_set_keys(gui, pv);
	  } break;
	  case 29: {
	    back = dkct_gui_set_validator(gui, pv);
	  } break;
	  case 30: {
	    back = dkct_gui_set_value(gui, pv);
	  } break;
	  case 31: {
	    back = dkct_gui_set_slider_style(gui, pv);
	  } break;
	  case 32: {
	    back = dkct_gui_set_notebook_style(gui, pv);
	  } break;
	  case 33: {
	    back = dkct_gui_set_text_style(gui, pv);
	  } break;
	  case 34: {
	    back = dkct_gui_set_button_style(gui, pv);
	  } break;
	  case 35: {
	    back = dkct_gui_set_splitter_window_style(gui, pv);
	  } break;
	  case 36: {
	    back = dkct_gui_set_bitmap_button_style(gui, pv);
	  } break;
	  case 37: {
	    back = dkct_gui_set_bitmap_disabled(gui, pv);
	  } break;
	  case 38: {
	    back = dkct_gui_set_bitmap_selected(gui, pv);
	  } break;
	  case 39: {
	    back = dkct_gui_set_bitmap_focus(gui, pv);
	  } break;
	  case 40: {
	    back = dkct_gui_set_bitmap_hover(gui, pv);
	  } break;
	  case 41: {
	    back = dkct_gui_set_gauge_style(gui, pv);
	  } break;
	  case 42: case 44: {
	    back = dkct_gui_set_menu_item_style(gui, pv);
	  } break;
	  case 43: {
	    back = dkct_gui_set_toolbar_style(gui, pv);
	  } break;
	  case 45: {
	    back = dkct_gui_set_icon(gui, pv);
	  } break;
	  case 46: {
	    back = dkct_add_grid_head(gui, pv, 1);
	  } break;
	  case 47: {
	    back = dkct_add_grid_head(gui, pv, 0);
	  } break;
	  case 48: {
	    back = dkct_set_table_for_grid(gui, pv);
	  } break;
	  case 49: {
	    back = dkct_set_minimum_size(gui, pv);
	  } break;
	  case 50: {
	    back = dkct_add_growable_row(gui, pv);
	  } break;
	  case 51: {
	    back = dkct_add_growable_column(gui, pv);
	  } break;
	  case 52: {
	    back = dkct_set_complete_constructor_specified(gui, pv);
	  } break;
	  default: {
	    /* ERROR: Syntax */
	    (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	    dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 10, 11, il);
	  } break;
	}
	if(action >= 0) {
	  if(!(back)) {
	    if(!((gui->psrc)->ec)) {
	      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	      /* ERROR: Syntax */
	      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 33);
	    }
	  }
	}
      } else {
        (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	/* ERROR: Syntax */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 9);
      }
    } else {
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      /* ERROR: Syntax */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 9);
    }
  }
  

#line 5068 "dkct-gui.ctr"
  return back;
}



/**	Process one input line containing an option.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_process_option(DKCT_GUI *gui, char *il)
{
  int		 back = 1;
  char		*pv;		/* Attribute value. */
  char		*p1;		/* Current string to process. */
  char		*p2;		/* Next string to process. */
  

#line 5087 "dkct-gui.ctr"
  if(gui->c_el) {
    pv = dk3str_c8_chr(il, '=');
    if(pv) {
      *(pv++) = '\0';
      pv = dk3str_c8_start(pv, NULL);
      if(pv) {
        dk3str_c8_normalize(il, NULL, '-');
	switch(dk3str_c8_array_index(dkct_gui_option_keys, il, 0)) {
	  case 0: {
	    gui->align = 0x00;
	    p1 = dk3str_c8_start(pv, NULL);
	    while(p1) {
	      p2 = dk3str_c8_next(p1, NULL);
	      gui->align = dkct_gui_apply_align(gui, gui->align, p1);
	      p1 = p2;
	    }
	  } break;
	  default: {
	    /* ERROR: Unknown option "..."! */
	    dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 10, 11, il);
	  } break;
	}
      } else {
        (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	/* ERROR: Syntax */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 9);
      }
    } else {
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      /* ERROR: Syntax */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 9);
    }
  }
  

#line 5121 "dkct-gui.ctr"
  return back;
}



/**	Add one input file line to GUI description.
	@param	gui	GUI description.
	@param	il	Input line to process.
	@return	1 on success, 0 on error.
*/
int
dkct_gui_add_line(DKCT_GUI *gui, char *il)
{
  int back = 1;
  char		*p1;	/* Start of input line. */
  

#line 5137 "dkct-gui.ctr"
  p1 = dk3str_c8_start(il, NULL);
  if(p1) {
    switch(*p1) {
      case '#': {		

#line 5141 "dkct-gui.ctr"
        back = 1;
      } break;
      case '.': {		

#line 5144 "dkct-gui.ctr"
        p1++;
	p1 = dk3str_c8_start(p1, NULL);
	if(p1) {
          back = dkct_gui_process_option(gui, p1);
	} else {
	  (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	  /* ERROR: Syntax */
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 9);
	}
      } break;
      case '[': {		

#line 5155 "dkct-gui.ctr"
        p1++;
	p1 = dk3str_c8_start(p1, NULL);
	if(p1) {
          back = dkct_gui_start_new_object_definition(gui, p1);
	} else {
	  (gui->psrc)->ec = DK3_ERROR_SYNTAX;
	  /* ERROR: Syntax */
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 37);
	}
      } break;
      default: {		

#line 5166 "dkct-gui.ctr"
        back = dkct_gui_process_object_line(gui, p1);
      } break;
    }
  }
  

#line 5171 "dkct-gui.ctr"
  return back;
}



/**	Get number of content elements.
	@param	el	Element to check.
	@return	Number of content elements.
*/
static
size_t
dkct_gui_get_number_contents(DKCT_GUI_ELEMENT *el) 
{
  size_t	back = 0;
  dk3sto_it_reset(el->i_contents);
  while(dk3sto_it_next(el->i_contents)) { back++; }
  dk3sto_it_reset(el->i_contents);
  return back;
}



/**	Report illegal child.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	psrc	Source structure.
*/
static
void
dkct_gui_report_illegal_parent_child(
  DKCT_GUI_ELEMENT	*co,	
  DKCT_GUI_ELEMENT	*dp,
  DKCT_SRC		*psrc
)
{
  char const	*cname;
  char const	*pname;
  

#line 5209 "dkct-gui.ctr"
  cname = pname = dkct_gui_out_kw[197];
  if(co) {
    if(co->cln >= 0) {
      cname = dkct_gui_class_names[co->cln];
    }
  }
  if(dp) {
    if(dp->cln >= 0) {
      pname = dkct_gui_class_names[dp->cln];
    }
  } 
  dkct_to_log_5(psrc, 1, DK3_LL_ERROR, 88, 89, 90, pname, cname);
  

#line 5222 "dkct-gui.ctr"
}



/**	Check GUI element setup.
	@param	el	Element to check.
	@param	psrc	Source structure.
	@return	1 on success (element setup ok), 0 on error.
*/
static
int
dkct_gui_element_check(DKCT_GUI_ELEMENT *el, DKCT_SRC *psrc)
{
  size_t		 nco;		/* Number of contents elements. */
  DKCT_GUI_ELEMENT	*dp;		/* Direct parent. */
  DKCT_GUI_ELEMENT	*sizer = NULL;	/* Sizer. */
  int			 back = 1;
  int			 szfound = 0;	/* Flag: Sizer found. */
  

#line 5241 "dkct-gui.ctr"
  dp = (DKCT_GUI_ELEMENT *)(el->parent);
  psrc->lineno = ((el->lndef) > 0UL) ? (el->lndef) : (el->lndecl);
  dk3app_set_source_line(psrc->app, psrc->lineno);
  /*
  	Check contents.
  */
  switch(el->cln) {
    case 0: case 1: case 2: case 3: case 4: case 5: case 6: case 7: case 8:
    case 9: case 10: case 11: case 12: case 13: case 14: case 35: case 36:
    case 38:
    {
      back = 0;
      nco = dkct_gui_get_number_contents(el);
      if(nco > 0) {
        if(el->cln == 14) {
	  if(nco == 2) {
	    back = 1;
	  } else {
	    /* ERROR: Splitter window must have exactly 2 children! */
	    dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 47);
	  }
	} else {
	  back = 1;
	}
      } else {
        /* ERROR: Missing contents! */
	dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 48);
      }
      if(!(back)) {	

#line 5270 "dkct-gui.ctr"
      }
    } break;
  }
  /*
  	Text.
  */
  if(back) {
    switch(el->cln) {
      case 15: case 19: case 23: case 25: case 28: case 29: 
      case 31: case 36: case 37: case 40:
      {
        if(!(el->text)) {
	  if(((el->cln != 37) && (el->cln != 40))
	     || (el->menuItemStyle != DKCT_GUI_MENU_ITEM_SEPARATOR)
	  )
	  {
	    if(el->cln == 28) {
	      /* ERROR: Missing text! */
	      dkct_to_log_1(psrc, 1, DK3_LL_INFO, 49);
	    } else {
	      back = 0;	

#line 5291 "dkct-gui.ctr"
	      /* ERROR: Missing text! */
	      dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 49);
	    }
	  }
	}
      } break;
    }
  }
  /*
  	ID.
  */
  if(back) {
    switch(el->cln) {
      case 15: case 16: case 23: case 25: case 29: case 37: case 40:
      {
        if(!(el->idname)) {
	  back = 0;	

#line 5308 "dkct-gui.ctr"
	  /* ERROR: Missing ID! */
	  dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 46);
	}
      } break;
    }
  }
  /*
  	Grid.
  */
  if(back) {
    switch(el->cln) {
      case 6: case 8: {
	if(el->gridcolumns == 0) {
	  back = 0;	

#line 5322 "dkct-gui.ctr"
	  /* ERROR: Missing grid! */
	  dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 50);
	}
      } break;
    }
  }
  /*
  	Bitmap.
  */
  if(back) {
    switch(el->cln) {
      case 16:	/* wxBitmapButton */
      case 40:	/* wxToolBarToolBase */
      {
        if(!(el->bitmapVarName)) {
	  if((el->cln != 40)
	     || (el->menuItemStyle != DKCT_GUI_MENU_ITEM_SEPARATOR)
	  )
	  {
	    back = 0;	

#line 5342 "dkct-gui.ctr"
	    /* ERROR: Missing bitmap! */
	    dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 51);
	  }
	}
      } break;
    }
  }
  /*
  	Choices.
  */
  if(back) {
    switch(el->cln) {
      case 17: case 18: case 20: case 21: {
	if((!(el->choices)) || (el->nChoices == 0)) {
	  back = 0;	

#line 5357 "dkct-gui.ctr"
	  /* ERROR: Missing choices! */
	  dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 52);
	}
      } break;
    }
  }
  /*
  	Size.
  */
  if(back) {
    switch(el->cln) {
      case 12: case 13: case 28: {
        if(!((el->sizex > 0) && (el->sizey > 0))) {	

#line 5370 "dkct-gui.ctr"
	  if(el->cln == 28) {
	    /*	
	    	Warning: Missing size.
	    	Not for single-line text with given text.
	    */
	    if(((el->textStyle) & DKCT_GUI_TEXT_MULTILINE) || (!(el->text))) {
	      dkct_to_log_1(psrc, 1, DK3_LL_WARNING, 53);
	    }
	  } else {
	    back = 0;
	    /* ERROR: Missing size! */
	    dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 53);
	  }
	}
      } break;
    }
  }
  /*
  	Rows or columns for radio box.
  */
  if(back) {
    switch(el->cln) {
      case 22: {
        if(el->maxRowsCols < 1) {
	  back = 0;	

#line 5395 "dkct-gui.ctr"
	  /* ERROR: Missing rows or columns maximum! */
	  dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 54);
	}
      } break;
    }
  }
  /*
	Parent/child relationships
  */
  switch(el->cln) {
    case 40: {	/* wxToolBarToolBase */
      if(dp) {
        if(dp->cln == 38) {
	  if(dp->name) {
	  } else {
	    back = 0;
	    /* ERROR: Missing name for parent */
	    dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 91);
	  }
	} else {
	  back = 0;	

#line 5416 "dkct-gui.ctr"
	  /* ERROR: Illegal parent/child combination. */
	  dkct_gui_report_illegal_parent_child(el, dp, psrc);
	}
      } else {
        back = 0;
        /* ERROR: No parent. */
	dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 92);
      }
    } break;
    case 37: {	/* wxMenuItem */
      if(dp) {
        if(dp->cln == 36) {
	  if(dp->name) {
	  } else {
	    back = 0;
	    /* ERROR: Missing name for parent */
	    dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 91);
	  }
	} else {
	  back = 0;	

#line 5436 "dkct-gui.ctr"
	  /* ERROR: Illegal parent/child combination. */
	  dkct_gui_report_illegal_parent_child(el, dp, psrc);
	}
      } else {
        back = 0;
        /* ERROR: No parent */
	dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 92);
      }
    } break;
    case 36: {	/* wxMenu */
      if(dp) {
        if((dp->cln == 35) || (dp->cln == 36)) {
	} else {	

#line 5449 "dkct-gui.ctr"
	  /* ERROR: Illegal parent/child combination. */
	  dkct_gui_report_illegal_parent_child(el, dp, psrc);
	}
      } else {
        back = 0;
	/* ERROR: No parent */
	dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 92);
      }
    } break;
  }
  /*
	Root element must have a sizer as the only content.
  */
  if((el->number == 0) && (!(el->parent))) {
    sizer = NULL; szfound = 0;
    if(dkct_gui_get_number_contents(el) == 1) {
      dk3sto_it_reset(el->i_contents);
      sizer = (DKCT_GUI_ELEMENT *)dk3sto_it_next(el->i_contents);
      if(sizer) {
        switch(sizer->cln) {
	  case 5: case 6: case 7: case 8: case 9: case 10: {
	    szfound = 1;
	  } break;
	}
      }
    }
    if(!(szfound)) {
      back = 0;
      /* ERROR: Root element must have one sizer as contents */
      dkct_to_log_1(psrc, 1, DK3_LL_ERROR, 97);
    }
  } 

#line 5481 "dkct-gui.ctr"
  return back;
}



/**	Check whether each object has a class name.
	@param	psrc	Source structure.
	@return	1 on success, 0 on error.
*/
static
int
dkct_gui_classnames_check(DKCT_SRC *psrc)
{
  DKCT_GUI		*gui;	/* GUI description. */
  DKCT_GUI_ELEMENT	*el;	/* Current element to check. */
  int back = 1;
  

#line 5498 "dkct-gui.ctr"
  if(psrc->gui) {
    gui = (DKCT_GUI *)(psrc->gui);
    dk3sto_it_reset(gui->i_el_by_num);
    while((el = (DKCT_GUI_ELEMENT *)dk3sto_it_next(gui->i_el_by_num)) != NULL) {
      psrc->lineno = ((el->lndef) > 0UL) ? (el->lndef) : (el->lndecl);
      dk3app_set_source_line(psrc->app, psrc->lineno);
      if(el->number != 0) {
        if(el->pseudoobj == 0) {
          if(!(el->name)) {
	    back = 0;
	    /* ERROR: Missing object name! */
	    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 58);
	  }
	  if(!(el->cname)) {
	    back = 0;	

#line 5513 "dkct-gui.ctr"
	    /* ERROR: Missing object class name! */
	    if(el->name) {
	      dkct_to_log_3(gui->psrc, 1, DK3_LL_ERROR, 93, 94, el->name);
	    } else {
	      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 78);
	    }
	  }
	}
      }
      if(!dkct_gui_element_check(el, psrc)) {
        back = 0;
	psrc->ec = DK3_ERROR_SYNTAX;
      }
    }
  } 

#line 5528 "dkct-gui.ctr"
  return back;
}



/**	Check for circular dependencies.
	@param	psrc	Source structure.
	@return	1 on success (no circular dependencies), 0 on error.
*/
static
int
dkct_gui_dependency_check(DKCT_SRC *psrc)
{
  int			back	= 0;
  dk3_bm_t		*bm;		/* Dependency matrix. */
  DKCT_GUI		*gui;		/* GUI description. */
  DKCT_GUI_ELEMENT	*gel;		/* Element to check. */
  DKCT_GUI_ELEMENT	*pp;		/* Parent element. */
  DKCT_GUI_ELEMENT	*pm;		/* Menu bar/contents element. */
  DKCT_GUI_ELEMENT	*pt;		/* Toolbar element. */
  size_t		 i;		/* Current index to check. */
  

#line 5550 "dkct-gui.ctr"
  if(psrc->gui) {
    gui = (DKCT_GUI *)(psrc->gui);
    bm = dk3bm_open(gui->no, gui->no, psrc->app);
    if(bm) {
      back = 1;
      dk3sto_it_reset(gui->i_el_by_name);
      while(
        (gel = (DKCT_GUI_ELEMENT *)dk3sto_it_next(gui->i_el_by_name))
        != NULL
      )
      {

	psrc->lineno = ((gel->lndef) > 0UL) ? (gel->lndef) : (gel->lndecl);
	dk3app_set_source_line(psrc->app, psrc->lineno);
        pp = pm = pt = NULL;
        if(gel->parent) { pp = (DKCT_GUI_ELEMENT *)(gel->parent); }
        if(gel->menubar) { pm = (DKCT_GUI_ELEMENT *)(gel->menubar); }
        if(gel->toolbar) { pt = (DKCT_GUI_ELEMENT *)(gel->toolbar); }
        if(pp) {
          dk3bm_set(bm, pp->number, gel->number, 1);
        }
        if(pm) {
          dk3bm_set(bm, gel->number, pm->number, 1);
        }
        if(pt) {
          dk3bm_set(bm, gel->number, pt->number, 1);
        }
        dk3sto_it_reset(gel->i_contents);
        while(
	  (pm = (DKCT_GUI_ELEMENT *)dk3sto_it_next(gel->i_contents))
	  != NULL
	)
        {
          dk3bm_set(bm, gel->number, pm->number, 1);
        }
      }
      dk3bm_expand(bm);
      for(i = 0; i < gui->no; i++) {
        if(dk3bm_get(bm, i, i)) {
	  psrc->lineno = 0UL;
	  dk3app_set_source_line(psrc->app, 0UL);
          /* ERROR: Dependency loop */
	  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 79);
	  back = 0;
        }
      }
      dk3bm_close(bm);
    }
  } 

#line 5599 "dkct-gui.ctr"
  return back;
}



int
dkct_gui_check(DKCT_SRC *psrc)
{
  int back = 0;
  

#line 5609 "dkct-gui.ctr"
  if(dkct_gui_classnames_check(psrc)) {
    if(dkct_gui_dependency_check(psrc)) {
      back = 1;
    }
  } 

#line 5614 "dkct-gui.ctr"
  return back;
}



/**	Check whether we need a wxPanel in the root object.
	@param	gui	GUI description.
	@return	1 for wxPanel needed (frame), 0 for not needed (wxDialog).
*/
static
int
dkct_gui_need_contents_panel(DKCT_GUI *gui)
{
  int back = 1;
  if(gui->r_el) {
    if((gui->r_el)->cln ==  1) {
      back = 0;
    }
  }
  return back;
}



/**	Decide whether or not to write a class member and a
	constructor method.
	@param	co	Current object.
	@return	1 to write a constructor, 0 for no constructor.
*/
static
int
dkct_gui_need_element_constructor(
  DKCT_GUI_ELEMENT		*co
#if 0
  DKCT_GUI_ELEMENT		*dp,
  DKCT_GUI_ELEMENT		*pw,
  DKCT_SRC			*psrc,
  DKCT_GUI			*gui
#endif
)
{
  int back = 1;
  switch(co->cln) {
    case 37:		/* wxMenuItem */
    case 40:		/* wxToolBarTool */
    {
      if(co->menuItemStyle == DKCT_GUI_MENU_ITEM_SEPARATOR) {
        back = 0;
      }
    } break;
  }
  return back;
}



void
dkct_gui_class_variables(DKCT_SRC *psrc)
{
  DKCT_GUI		*gui;	/* GUI description. */
  DKCT_GUI_ELEMENT	*el;	/* Current element to check. */
  if(psrc->gui) {
    gui = (DKCT_GUI *)(psrc->gui);
    dk3sto_it_reset(gui->i_el_by_num);
    fputs(dkct_gui_out_kw[7], psrc->fipo);
    if(dkct_gui_need_contents_panel(gui)) {
      fputs(dkct_gui_out_kw[17], psrc->fipo);
    }
    while((el = (DKCT_GUI_ELEMENT *)dk3sto_it_next(gui->i_el_by_num)) != NULL) {
      if(el->number != 0) {
        if(el->pseudoobj == 0) {
	  if(dkct_gui_need_element_constructor(el)) {
            if((el->name) && (el->cname)) {
	      fputs(dkct_gui_out_kw[5], psrc->fipo);
	      fputs(el->name, psrc->fipo);
	      fputs(dkct_gui_out_kw[6], psrc->fipo);
	      if((psrc->dkcto).lnn) {
    	        psrc->lineno = el->lndef;
    	        dkct_tr_show_source_line(psrc, 0);
	      }
	      fputs(dkct_gui_out_kw[2], psrc->fipo);
	      fputs(el->cname, psrc->fipo);
	      fputs(dkct_gui_out_kw[1], psrc->fipo);
	      fputs(dkct_gui_out_kw[3], psrc->fipo);
	      fputs(el->name, psrc->fipo);
	      fputs(dkct_gui_out_kw[4], psrc->fipo);
	      fputs(dkct_gui_out_kw[0], psrc->fipo);
	      fputs(dkct_gui_out_kw[0], psrc->fipo);
	    }
	  }
	}
      }
    }
    /*
    	Write line number.
    */
  }
}



/**	Check whether an object is a sizer.
	@param	gel	Object to check.
	@return	1 for sizer, 0 for non-sizer object.
*/
static
int
dkct_gui_is_sizer(DKCT_GUI_ELEMENT *gel)
{
  int back = 0;
  if(gel) {
    if(gel->cln < 11) {
      if(gel->cln > 4) {
        back = 1;
      }
    }
  }
  return back;
}



/**	Find parent window object.
	@param	startelem	Direct parent of object.
	@return	Parent representing a non-sizer object or NULL.
*/
static
DKCT_GUI_ELEMENT *
dkct_gui_find_real_parent(DKCT_GUI_ELEMENT *startelem)
{
  DKCT_GUI_ELEMENT	*back	= NULL;
  DKCT_GUI_ELEMENT	*c;		/* Element to check. */
  c = startelem;
  while((!(back)) && (c)) {
    if(dkct_gui_is_sizer(c)) {
      c = (DKCT_GUI_ELEMENT *)(c->parent);
    } else {
      back = c;
    }
  }
  return back;
}



/**	Write flags to add object to sizer.
	@param	fipo	Output file.
	@param	co	Current object.
*/
static
void
dkct_gui_write_flags(FILE *fipo, DKCT_GUI_ELEMENT *co)
{
  int		found	= 0;	/* Flag: Already found. */

  if((co->border >= 0) && (co->borderPos)) {
    if(co->borderPos == DKCT_GUI_BORDER_POSITION_ALL) {
      fputs(dkct_gui_out_kw[39], fipo);
      found = 1;
    } else {
      if((co->borderPos) & DKCT_GUI_BORDER_POSITION_TOP) {
        if(found) { fputs(dkct_gui_out_kw[44], fipo); }
        found = 1;
	fputs(dkct_gui_out_kw[40], fipo);
      }
      if((co->borderPos) & DKCT_GUI_BORDER_POSITION_LEFT) {
        if(found) { fputs(dkct_gui_out_kw[44], fipo); }
        found = 1;
	fputs(dkct_gui_out_kw[41], fipo);
      }
      if((co->borderPos) & DKCT_GUI_BORDER_POSITION_RIGHT) {
        if(found) { fputs(dkct_gui_out_kw[44], fipo); }
        found = 1;
	fputs(dkct_gui_out_kw[42], fipo);
      }
      if((co->borderPos) & DKCT_GUI_BORDER_POSITION_BOTTOM) {
        if(found) { fputs(dkct_gui_out_kw[44], fipo); }
        found = 1;
	fputs(dkct_gui_out_kw[43], fipo);
      }
    }
  }
  if((co->align) & DKCT_GUI_ALIGN_H_MASK) {
    switch((co->align) & DKCT_GUI_ALIGN_H_MASK) {
      case DKCT_GUI_ALIGN_H_LEFT: {
        if(found) { fputs(dkct_gui_out_kw[44], fipo); }
        found = 1;
        fputs(dkct_gui_out_kw[45], fipo);
      } break;
      case DKCT_GUI_ALIGN_H_CENTER: {
        if(found) { fputs(dkct_gui_out_kw[44], fipo); }
        found = 1;
        fputs(dkct_gui_out_kw[46], fipo);
      } break;
      case DKCT_GUI_ALIGN_H_RIGHT: {
        if(found) { fputs(dkct_gui_out_kw[44], fipo); }
        found = 1;
        fputs(dkct_gui_out_kw[47], fipo);
      } break;
    }
  }
  if((co->align) & DKCT_GUI_ALIGN_V_MASK) {
    switch((co->align) & DKCT_GUI_ALIGN_V_MASK) {
      case DKCT_GUI_ALIGN_V_TOP: {
        if(found) { fputs(dkct_gui_out_kw[44], fipo); }
        found = 1;
        fputs(dkct_gui_out_kw[48], fipo);
      } break;
      case DKCT_GUI_ALIGN_V_CENTER: {
        if(found) { fputs(dkct_gui_out_kw[44], fipo); }
        found = 1;
        fputs(dkct_gui_out_kw[49], fipo);
      } break;
      case DKCT_GUI_ALIGN_V_BOTTOM: {
        if(found) { fputs(dkct_gui_out_kw[44], fipo); }
        found = 1;
        fputs(dkct_gui_out_kw[50], fipo);
      } break;
    }
  }
  if(co->expandFlag) {
    if(found) { fputs(dkct_gui_out_kw[44], fipo); }
    found = 1;
    fputs(dkct_gui_out_kw[51], fipo);
  }
  if(!(found)) {
    fputs(dkct_gui_out_kw[52], fipo);
  }
}



/**	Check whether we need to write commands for flags.
	@param	co	Current object.
	@return	1 to configure flags, 0 to skip.
*/
static
int
dkct_gui_need_flags(DKCT_GUI_ELEMENT *co)
{
  int back = 0;
  if((co->border >= 0) && (co->borderPos)) {
    back = 0;
  }
  if((co->borderPos) & DKCT_GUI_BORDER_POSITION_TOP) {
    back = 1;
  }
  if((co->borderPos) & DKCT_GUI_BORDER_POSITION_LEFT) {
    back = 1;
  }
  if((co->borderPos) & DKCT_GUI_BORDER_POSITION_RIGHT) {
    back = 1;
  }
  if((co->borderPos) & DKCT_GUI_BORDER_POSITION_BOTTOM) {
    back = 1;
  }
  if((co->align) & DKCT_GUI_ALIGN_H_MASK) {
    back = 1;
  }
  if((co->align) & DKCT_GUI_ALIGN_V_MASK) {
    back = 1;
  }
  if(co->expandFlag) {
    back = 1;
  }
  return back;
}



/**	Write border for object.
	@param	fipo	Output file.
	@param	co	Current object.
*/
static
void
dkct_gui_write_border(FILE *fipo, DKCT_GUI_ELEMENT *co)
{
  int		b = 0;		/* Border size. */
  char		bu[32];		/* Buffer for integer variables. */

  if((co->border >= 0) && (co->borderPos)) {
    b = co->border;
  }
  sprintf(bu, "%d", b);
  fputs(bu, fipo);
}



/**	Write growable rows and columns.
	@param	co	Current object.
	@param	st	Storage for growable rows/columns.
	@param	it	Iterator for growable rows/columns.
	@param	rowcol	Flag: Row=0 or column=1.
	@param	psrc	Source structure.
*/
static
void
dkct_write_growable_rows_cols(
  DKCT_GUI_ELEMENT	*co,
  dk3_sto_t		*st,
  dk3_sto_it_t		*it,
  int			 rowcol,
  DKCT_SRC		*psrc
)
{
  int			*ip;
  if((st) && (it)) {
    dk3sto_it_reset(it);
    while(NULL != (ip = (int *)dk3sto_it_next(it))) {
      fputs(dkct_gui_out_kw[8], psrc->fipo);
      fputs(co->name, psrc->fipo);
      fputs(dkct_gui_out_kw[(rowcol) ? 206 : 207], psrc->fipo);
      fprintf(psrc->fipo, "%d", *ip);
      fputs(dkct_gui_out_kw[24], psrc->fipo);
      fputs(dkct_gui_out_kw[0], psrc->fipo);
    }
  }
}



/**	Add one object to the parent which is a sizer.
	@param	co	Current object.
	@param	pa	Parent (a sizer object).
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_add_object_to_sizer(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*pa,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  char		bu[64];		/* Buffer for integer values. */
  int		det = 0;	/* Details to use. */
  

#line 5955 "dkct-gui.ctr"
  /*
  	Last modifications to object before adding it to parent.
  */
  switch(co->cln) {
    case 7: {
      /* Growable rows and columns for wxGridBagSizer */
      dkct_write_growable_rows_cols(co, co->sGrowRow, co->iGrowRow, 0, psrc);
      dkct_write_growable_rows_cols(co, co->sGrowCol, co->iGrowCol, 1, psrc);
    } break;
  }
  /*
  	Add object to parent.
  */
  switch(pa->cln) {
    case 7: {	

#line 5970 "dkct-gui.ctr"
      /* sizer */
      if(dkct_gui_need_flags(co)) {
        det = 1;		

#line 5973 "dkct-gui.ctr"
      }
      if((co->border >= 0) && (co->borderPos)) {
        det = 2;		

#line 5976 "dkct-gui.ctr"
      }
      fputs(dkct_gui_out_kw[8], psrc->fipo);
      fputs(pa->name, psrc->fipo);
      /* -> */
      fputs(dkct_gui_out_kw[31], psrc->fipo);
      /* Add( */
      fputs(dkct_gui_out_kw[36], psrc->fipo);
      /* object */
      fputs(dkct_gui_out_kw[2], psrc->fipo);
      fputs(co->name, psrc->fipo);
      /* ,  */
      fputs(dkct_gui_out_kw[38], psrc->fipo);
      /* wxGBPosition */
      fputs(dkct_gui_out_kw[2], psrc->fipo);
      fputs(dkct_gui_out_kw[53], psrc->fipo);
      sprintf(bu, "%d", co->posy);
      fputs(bu, psrc->fipo);
      fputs(dkct_gui_out_kw[55], psrc->fipo);
      sprintf(bu, "%d", co->posx);
      fputs(bu, psrc->fipo);
      fputs(dkct_gui_out_kw[56], psrc->fipo);
      /* ,  */
      fputs(dkct_gui_out_kw[38], psrc->fipo);
      /* wxGBSpan */
      fputs(dkct_gui_out_kw[2], psrc->fipo);
      fputs(dkct_gui_out_kw[54], psrc->fipo);
      sprintf(bu, "%d", co->spany);
      fputs(bu, psrc->fipo);
      fputs(dkct_gui_out_kw[55], psrc->fipo);
      sprintf(bu, "%d", co->spanx);
      fputs(bu, psrc->fipo);
      fputs(dkct_gui_out_kw[56], psrc->fipo);
#if 0
      /* ,  */
      fputs(dkct_gui_out_kw[38], psrc->fipo);
      /*
      	Proportion not printed for wxGridBagSizer elements.
      */
      /* proportion */
      fputs(dkct_gui_out_kw[2], psrc->fipo);
      sprintf(bu, "%d", ((co->proportion >= 0) ? (co->proportion) : 0));
      fputs(bu, psrc->fipo);
#endif
      if(det) {
        /* ,  */
        fputs(dkct_gui_out_kw[38], psrc->fipo);
        /* flags */
        fputs(dkct_gui_out_kw[2], psrc->fipo);
        dkct_gui_write_flags(psrc->fipo, co);
	if(det > 1) {
          /* ,  */
          fputs(dkct_gui_out_kw[38], psrc->fipo);
          /* border */
          fputs(dkct_gui_out_kw[2], psrc->fipo);
          dkct_gui_write_border(psrc->fipo, co);
	}
      }
      /* ); */
      fputs(dkct_gui_out_kw[0], psrc->fipo);
      fputs(dkct_gui_out_kw[37], psrc->fipo);
    } break;
    case 5: case 6: case 8: case 9: case 10: {	

#line 6038 "dkct-gui.ctr"
      /*
      	sizer->Add(object, proportion, flags, border);
      */
      /* sizer */
      if(co->proportion) {
        det = 1;		

#line 6044 "dkct-gui.ctr"
      }
      if(dkct_gui_need_flags(co)) {
        det = 2;		

#line 6047 "dkct-gui.ctr"
      }
      if((co->border >= 0) && (co->borderPos)) {
        det = 3;		

#line 6050 "dkct-gui.ctr"
      }
      fputs(dkct_gui_out_kw[8], psrc->fipo);
      fputs(pa->name, psrc->fipo);
      /* -> */
      fputs(dkct_gui_out_kw[31], psrc->fipo);
      /* Add( */
      switch(pa->cln) {
        /*
		wxStdButtonSizer.
	*/
        case 10: {
	  switch(co->cln) {
	    case 15: case 16: {		/* Buttons. */
	      fputs(dkct_gui_out_kw[208], psrc->fipo);
	    } break;
	    default: {			/* Other elements. */
	      fputs(dkct_gui_out_kw[36], psrc->fipo);
	    } break;
	  }
	} break;
	/*
		All other containers and sizers.
	*/
	default: {
	  fputs(dkct_gui_out_kw[36], psrc->fipo);
	} break;
      }
      /* object */
      fputs(dkct_gui_out_kw[2], psrc->fipo);
      fputs(co->name, psrc->fipo);
      if(det) {
        /* ,  */
        fputs(dkct_gui_out_kw[38], psrc->fipo);
        /* proportion */
        fputs(dkct_gui_out_kw[2], psrc->fipo);
        sprintf(bu, "%d", ((co->proportion >= 0) ? (co->proportion) : 0));
        fputs(bu, psrc->fipo);
	if(det > 1) {
          /* ,  */
          fputs(dkct_gui_out_kw[38], psrc->fipo);
          /* flags */
          fputs(dkct_gui_out_kw[2], psrc->fipo);
          dkct_gui_write_flags(psrc->fipo, co);
	  if(det > 2) {
            /* ,  */
            fputs(dkct_gui_out_kw[38], psrc->fipo);
            /* border */
            fputs(dkct_gui_out_kw[2], psrc->fipo);
            dkct_gui_write_border(psrc->fipo, co);
	  }
	}
      }
      /* ); */
      fputs(dkct_gui_out_kw[0], psrc->fipo);
      fputs(dkct_gui_out_kw[37], psrc->fipo);
    } break;
  }
  

#line 6108 "dkct-gui.ctr"
}



/**	Use the current object as the parents sizer object.
	@param	co	Current object.
	@param	pa	Parent (a sizer object).
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_set_parents_sizer(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*pa,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  char const		*pname = NULL;	/* Parent object name. */
  

#line 6129 "dkct-gui.ctr"
  if(pa) { pname = pa->name; }
  if(!(pname)) {
    if(pa->cln != 1) { pname = dkct_gui_out_kw[30]; }
  }
  fputs(dkct_gui_out_kw[8], psrc->fipo);
  if(pname) {
    fputs(pname, psrc->fipo);
    fputs(dkct_gui_out_kw[31], psrc->fipo);
  }
  fputs(dkct_gui_out_kw[32], psrc->fipo);
  fputs(co->name, psrc->fipo);
  fputs(dkct_gui_out_kw[24], psrc->fipo);
  fputs(dkct_gui_out_kw[0], psrc->fipo);
  

#line 6143 "dkct-gui.ctr"
}



/**	Write objects parents name.
	@param	pw	Parent object.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_write_parent_name(
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  char *pname = NULL;	/* Parent object name. */

  if(pw) { pname = pw->name; }
  if(pname) {
    fputs(pname, psrc->fipo);
  } else {
    if(dkct_gui_need_contents_panel(gui)) {
      fputs(dkct_gui_out_kw[30], psrc->fipo);
    } else {
      fputs(dkct_gui_out_kw[65], psrc->fipo);
    }
  }
}



/**	Switch to next argument.
	@param	psrc	Source structure.
*/
static
void
dkct_gui_next_argument(DKCT_SRC *psrc)
{
  fputs(dkct_gui_out_kw[38], psrc->fipo);
  fputs(dkct_gui_out_kw[2], psrc->fipo);
}



/**	Write ID attribute.
	@param	co	Current object.
	@param	psrc	Source structure.
*/
static
void
dkct_gui_write_idname(DKCT_GUI_ELEMENT *co, DKCT_SRC *psrc)
{
  if(co->idname) {
    fputs(co->idname, psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[66], psrc->fipo);
  }
}



/**	Write size attribute.
	@param	psrc	Source structure.
	@param	w	Object width.
	@param	h	Object height.
	@param	rec	Flag: Size attribute recommended.
	@param	co	Current object.
*/
static
void
dkct_gui_write_size(DKCT_SRC *psrc, int w, int h, int rec, DKCT_GUI_ELEMENT *co)
{
  char	bu[256];
  if((w > 0) && (h > 0)) {
    sprintf(bu, "%d, %d", w, h);
    fputs(dkct_gui_out_kw[81], psrc->fipo);
    fputs(bu, psrc->fipo);
    fputs(dkct_gui_out_kw[56], psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[75], psrc->fipo);
    if(rec) {
      /* WARNING: Size not specified! */
      dkct_to_log_1(psrc, 1, DK3_LL_WARNING, 53);
    }
  }
}



/**	Write constructor arguments for wxFrame or wxDialog.
*/
static
void
dkct_gui_constructor_frame_dialog(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int	det = 0;	/* Details level. */

  if(co->text) det = 1;
  if((co->sizex > 0) && (co->sizey > 0)) det = 2;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(det) {
    dkct_gui_next_argument(psrc);
    if(co->text) {
      fputs(co->text, psrc->fipo);
    } else {
      fputs(dkct_gui_out_kw[73], psrc->fipo);
    }
    if(det > 1) {
      dkct_gui_next_argument(psrc);
      fputs(dkct_gui_out_kw[74], psrc->fipo);
      dkct_gui_next_argument(psrc);
      dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write constructor for box sizer.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window object.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_boxsizer(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  switch(co->direction) {
    case DKCT_GUI_DIRECTION_VERTICAL: {
      fputs(dkct_gui_out_kw[35], psrc->fipo);
    } break;
    default: {
      fputs(dkct_gui_out_kw[34], psrc->fipo);
    } break;
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



#if 0
/**	Write constructor arguments for wxPanel.
*/
static
void
dkct_gui_constructor_parent_and_id(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}
#endif



/**	Write constructor for grid sizer.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window object.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_gridsizer(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  char	bu[256];	/* Buffer for integer values. */
  int c = 0;		/* Columns. */
  int r = 0;		/* Rows. */
  int y = 0;		/* Start row. */
  int x = 0;		/* Start column. */

  c = co->gridcolumns;
  r = co->gridrows;
  x = co->gridgapx;
  y = co->gridgapy;
  bu[0] = '\0';
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  if(r > 0) {
    if(x < 0) { x = 0; } if(y < 0) { y = 0; }
    sprintf(bu, "%d, %d, %d, %d", c, r, y, x);
  } else {
    if((x > -1) || (y > -1)) {
      if(x > -1) {
        sprintf(bu, "%d, %d, %d", c, ((y > -1) ? y : 0), ((x > -1) ? x : 0));
      } else {
        sprintf(bu, "%d, %d", c, y);
      }
    } else {
      sprintf(bu, "%d", c);
    }
  }
  fputs(bu, psrc->fipo);
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write constructor for gridbag sizer.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window object.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_gridbagsizer(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  char	bu[128];	/* Buffer for integer values. */

  bu[0] = '\0';
  if((co->gridgapy > -1) || (co->gridgapy > -1)) {
    fputs(dkct_gui_out_kw[2], psrc->fipo);
    if(co->gridgapx > -1) {
      sprintf(
        bu, "%d, %d",
	((co->gridgapy > -1) ? co->gridgapy : 0),
	((co->gridgapx > -1) ? co->gridgapx : 0)
      );
    } else {
      sprintf(bu, "%d", co->gridgapy);
    }
    fputs(bu, psrc->fipo);
    fputs(dkct_gui_out_kw[0], psrc->fipo);
  }
}



/**	Write element constructor for static box sizer.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_staticboxsizer(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  fputs(dkct_gui_out_kw[(co->direction) ? 35 : 34], psrc->fipo);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_parent_name(pw, psrc, gui);
  if(co->text) {
    dkct_gui_next_argument(psrc);
    fputs(co->text, psrc->fipo);
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write constructor for a panel.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window object.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_panel(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int det = 0;		/* Details level. */

  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(det > 1) {
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write constructor for notebook.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window object.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_notebook(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int	det = 0;	/* Details level. */
  int	fe = 0;		/* Flag: Found elements. */

  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  if(co->notebookStyle) det = 2;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(det > 1) {
      if((co->notebookStyle) & DKCT_GUI_NB_TOP) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[113], psrc->fipo);
      }
      if((co->notebookStyle) & DKCT_GUI_NB_LEFT) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[114], psrc->fipo);
      }
      if((co->notebookStyle) & DKCT_GUI_NB_RIGHT) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[115], psrc->fipo);
      }
      if((co->notebookStyle) & DKCT_GUI_NB_BOTTOM) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[116], psrc->fipo);
      }
      if((co->notebookStyle) & DKCT_GUI_NB_FIXEDWIDTH) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[117], psrc->fipo);
      }
      if((co->notebookStyle) & DKCT_GUI_NB_MULTILINE) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[118], psrc->fipo);
      }
      if((co->notebookStyle) & DKCT_GUI_NB_NOPAGETHEME) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[119], psrc->fipo);
      }
      if((co->notebookStyle) & DKCT_GUI_NB_FLAT) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[120], psrc->fipo);
      }
      if(!(fe)) { fputs(dkct_gui_out_kw[52], psrc->fipo); }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write constructor for scrolled window.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window object.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_scrolledwindow(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int	det = 0;	/* Details level. */

  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  if(co->direction != DKCT_GUI_DIRECTION_BOTH) det = 2;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 1, co);
    if(det > 1) {
      dkct_gui_next_argument(psrc);
      switch(co->direction) {
        case DKCT_GUI_DIRECTION_HORIZONTAL: {
	  fputs(dkct_gui_out_kw[138], psrc->fipo);
	} break;
	case DKCT_GUI_DIRECTION_VERTICAL: {
	  fputs(dkct_gui_out_kw[139], psrc->fipo);
	} break;
	default: {
	  fputs(dkct_gui_out_kw[140], psrc->fipo);
	} break;
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write constructor for splitter window.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window object.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_splitterwindow(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int	det = 0;	/* Details level. */
  int	fe = 0;		/* Flag: Found an element. */

  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  if(co->splitterStyle != DKCT_GUI_SPLITTERW_3D) det = 2;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 1, co);
    if(det > 1) {
      dkct_gui_next_argument(psrc);
      if((co->splitterStyle) & DKCT_GUI_SPLITTERW_3D) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[147], psrc->fipo);
      } else {
        if((co->splitterStyle) & DKCT_GUI_SPLITTERW_3D_SASH) {
          if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[148], psrc->fipo);
	}
	if((co->splitterStyle) & DKCT_GUI_SPLITTERW_3D_BORDER) {
          if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[149], psrc->fipo);
	}
      }
      if((co->splitterStyle) & DKCT_GUI_SPLITTERW_BORDER) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[150], psrc->fipo);
      }
      if((co->splitterStyle) & DKCT_GUI_SPLITTERW_NO_BORDER) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[151], psrc->fipo);
      }
      if((co->splitterStyle) & DKCT_GUI_SPLITTERW_NO_XP_THEME) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[152], psrc->fipo);
      }
      if((co->splitterStyle) & DKCT_GUI_SPLITTERW_PERMIT_UNSPLIT) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[153], psrc->fipo);
      }
      if((co->splitterStyle) & DKCT_GUI_SPLITTERW_LIVE_UPDATE) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	fputs(dkct_gui_out_kw[154], psrc->fipo);
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write constructor for button.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window object.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_button(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int	det = 0;	/* Details level. */
  int	fe = 0;		/* Flag: Found an entry. */

  if(co->text) det = 1;
  if((co->sizex > 0) && (co->sizey > 0)) det = 2;
  if(co->buttonStyle) det = 3;
  if(co->validator) det = 4;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(det) {
    dkct_gui_next_argument(psrc);
    if(co->text) {
      fputs(co->text, psrc->fipo);
    } else {
      fputs(dkct_gui_out_kw[73], psrc->fipo);
    }
    if(det > 1) {
      dkct_gui_next_argument(psrc);
      fputs(dkct_gui_out_kw[74], psrc->fipo);
      dkct_gui_next_argument(psrc);
      dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
      if(det > 2) {
        dkct_gui_next_argument(psrc);
	if((co->buttonStyle) & DKCT_GUI_BUTTON_LEFT) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[141], psrc->fipo);
	}
	if((co->buttonStyle) & DKCT_GUI_BUTTON_TOP) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[142], psrc->fipo);
	}
	if((co->buttonStyle) & DKCT_GUI_BUTTON_RIGHT) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[143], psrc->fipo);
	}
	if((co->buttonStyle) & DKCT_GUI_BUTTON_BOTTOM) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[144], psrc->fipo);
	}
	if((co->buttonStyle) & DKCT_GUI_BUTTON_EXACTFIT) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[145], psrc->fipo);
	}
	if((co->buttonStyle) & DKCT_GUI_BUTTON_NO_BORDER) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[146], psrc->fipo);
	}
        if(det > 3) {
	  dkct_gui_next_argument(psrc);
	}
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write constructor for bitmap button.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window object.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_bitmapbutton(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int	det = 0;	/* Details level. */
  int	fe = 0;		/* Flag: Found entry. */

  if(co->bitmapVarName) {
    det = 1;
    if((co->sizex > 0) && (co->sizey > 0)) det = 2;
    if(co->bitmapbStyle != DKCT_GUI_BBUTTON_AUTODRAW) det = 3;
    if(co->validator) det = 4;

    fputs(dkct_gui_out_kw[2], psrc->fipo);
    dkct_gui_write_parent_name(pw, psrc, gui);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_idname(co, psrc);
    dkct_gui_next_argument(psrc);
    fputs(co->bitmapVarName, psrc->fipo);
    if(det > 1) {
      dkct_gui_next_argument(psrc);
      fputs(dkct_gui_out_kw[74], psrc->fipo);
      dkct_gui_next_argument(psrc);
      dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
      if(det > 2) {
        if((co->bitmapbStyle) & DKCT_GUI_BBUTTON_AUTODRAW) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[155], psrc->fipo);
	}
        if((co->bitmapbStyle) & DKCT_GUI_BBUTTON_LEFT) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[141], psrc->fipo);
	}
        if((co->bitmapbStyle) & DKCT_GUI_BBUTTON_TOP) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[142], psrc->fipo);
	}
        if((co->bitmapbStyle) & DKCT_GUI_BBUTTON_RIGHT) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[143], psrc->fipo);
	}
        if((co->bitmapbStyle) & DKCT_GUI_BBUTTON_BOTTOM) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[144], psrc->fipo);
	}
	if(!(fe)) { fputs(dkct_gui_out_kw[52], psrc->fipo); }
        if(det > 3) {
          dkct_gui_next_argument(psrc);
	  fputs(co->validator, psrc->fipo);
	}
      }
    }
    fputs(dkct_gui_out_kw[0], psrc->fipo);
  } else {
    /* ERROR: No bitmap name specified! */
    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 51);
  }
}



/**	Write element constructor for choice and combo box.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
	@param	iscombo	Flag: Combo box.
*/
static
void
dkct_gui_constructor_choice_combo(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui,
  int			 iscombo
)
{
  char	bu[64];		/* Buffer for integer values. */
  int	details = 0;	/* Details level. */
  /*
  	parent, id, pos, size (1) , n (2), texts (3), validator (4)
	parent, id, text, pos, size (1), n (2), texts (3), validator (4)
  */
  if((co->sizex > 0) && (co->sizey > 0)) details = 1;
  if((co->nChoices > 0) || (co->nChoices == -1)) details = 2;
  if(co->choices) details = 3;
  if(co->validator) details = 4;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(iscombo) {
    dkct_gui_next_argument(psrc);
    if(co->text) {
      fputs(co->text, psrc->fipo);
    } else {
      fputs(dkct_gui_out_kw[73], psrc->fipo);
    }
  }
  if(details) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(details > 1) {
      if(co->nChoices != -1) {
        dkct_gui_next_argument(psrc);
        sprintf(bu, "%d", co->nChoices);
        fputs(bu, psrc->fipo);
      }
      if(details > 2) {
        dkct_gui_next_argument(psrc);
	if(co->choices) {
          fputs(co->choices, psrc->fipo);
	} else {
	  fputs(dkct_gui_out_kw[100], psrc->fipo);
	}
	if(details > 3) {
	  dkct_gui_next_argument(psrc);
	  fputs(co->validator, psrc->fipo);
	}
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for checkbox.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_checkbox(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int	need_full_arguments = 0;	/* Details level. */

  if(co->text) need_full_arguments = 1;
  if((co->sizex > 0) && (co->sizey > 0)) { need_full_arguments = 2; }
  if(co->nStates == 0x03) {
    need_full_arguments = 3;
  }
  if(((co->align) & DKCT_GUI_ALIGN_H_MASK) == DKCT_GUI_ALIGN_H_RIGHT) {
    need_full_arguments = 3;
  }
  if(co->validator) need_full_arguments = 4;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(need_full_arguments) {
    dkct_gui_next_argument(psrc);
    if(co->text) {
      fputs(co->text, psrc->fipo);
    } else {
      fputs(dkct_gui_out_kw[73], psrc->fipo);
    }
    if(need_full_arguments > 1) {
      dkct_gui_next_argument(psrc);
      fputs(dkct_gui_out_kw[74], psrc->fipo);
      dkct_gui_next_argument(psrc);
      dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
      if(need_full_arguments > 2) {
        dkct_gui_next_argument(psrc);
	if(co->nStates == 0x03) {
	  fputs(dkct_gui_out_kw[76], psrc->fipo);
	  if(((co->align) & DKCT_GUI_ALIGN_H_MASK) == DKCT_GUI_ALIGN_H_RIGHT) {
	    fputs(dkct_gui_out_kw[44], psrc->fipo);
	     fputs(dkct_gui_out_kw[47], psrc->fipo);
	  } else {
	  }
	} else {
	  if(((co->align) & DKCT_GUI_ALIGN_H_MASK) == DKCT_GUI_ALIGN_H_RIGHT) {
	    fputs(dkct_gui_out_kw[47], psrc->fipo);
	  } else {
	    fputs(dkct_gui_out_kw[52], psrc->fipo);
	  }
	}
	if(need_full_arguments > 3) {
	  dkct_gui_next_argument(psrc);
	  fputs(co->validator, psrc->fipo);
	}
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for listbox.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_listbox(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  char	bu[64];		/* Buffer for numeric values. */

  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  dkct_gui_next_argument(psrc);
  fputs(dkct_gui_out_kw[74], psrc->fipo);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_size(psrc, co->sizex, co->sizey, 1, co);
  if(co->nChoices != -1) {
    dkct_gui_next_argument(psrc);
    sprintf(bu, "%d", co->nChoices);
    fputs(bu, psrc->fipo);
  }
  dkct_gui_next_argument(psrc);
  if(co->choices) {
    fputs(co->choices, psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[100], psrc->fipo);
  }
  /* Style */
  dkct_gui_next_argument(psrc);
  switch(co->selStyle) {
    case DKCT_GUI_SELECTION_STYLE_EXTENDED: {
      fputs(dkct_gui_out_kw[84], psrc->fipo);
    } break;
    case DKCT_GUI_SELECTION_STYLE_MULTIPLE: {
      fputs(dkct_gui_out_kw[83], psrc->fipo);
    } break;
    default: {
      fputs(dkct_gui_out_kw[82], psrc->fipo);
    } break;
  }
  fputs(dkct_gui_out_kw[85], psrc->fipo);
  if(co->validator) {
    dkct_gui_next_argument(psrc);
    fputs(co->validator, psrc->fipo);
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for checklistbox.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_checklistbox(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  dkct_gui_constructor_listbox(co, dp, pw, psrc, gui);
}



/**	Write element constructor for radio box.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_radiobox(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  /*
  	parent, id, label, pos, size (1), n (2), choices (3),
  	majordim (4), style (5), validator (6)
  */
  int	det = 0;	/* Details level. */
  char	bu[64];		/* Buffer for numeric values. */

  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  if((co->nChoices > 0) || (co->nChoices == -1)) det = 2;
  if(co->choices) det = 3;
  if(co->maxRowsCols > 0) det = 4;
  if(co->rbDirection != DKCT_GUI_RB_DIR_COLUMNS) det = 5;
  if(co->validator) det = 6;

  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  dkct_gui_next_argument(psrc);
  if(co->text) {
    fputs(co->text, psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[73], psrc->fipo);
  }
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(det > 1) {
      if(co->nChoices != -1) {
        dkct_gui_next_argument(psrc);
        sprintf(bu, "%d", ((co->nChoices > 0) ? co->nChoices : 0));
        fputs(bu, psrc->fipo);
      }
      if(det > 2) {
        dkct_gui_next_argument(psrc);
	if(co->choices) {
          fputs(co->choices, psrc->fipo);
	} else {
	  fputs(dkct_gui_out_kw[100], psrc->fipo);
	}
	if(det > 3) {
          /* Majordim */
          dkct_gui_next_argument(psrc);
          sprintf(bu, "%d", (co->maxRowsCols >= 0) ? co->maxRowsCols : 0);
          fputs(bu, psrc->fipo);
	  if(det > 4) {
            /* Style */
            dkct_gui_next_argument(psrc);
            if(co->rbDirection == DKCT_GUI_RB_DIR_COLUMNS) {
              fputs(dkct_gui_out_kw[87], psrc->fipo);
            } else {
              fputs(dkct_gui_out_kw[86], psrc->fipo);
            }
	    if(det > 5) {
	      dkct_gui_next_argument(psrc);
	      fputs(co->validator, psrc->fipo);
	    }
	  }
	}
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for radio button.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_radiobutton(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int det = 0;		/* Details level. */

  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  if(co->startGroup) det = 2;
  if(co->validator) det = 3;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  dkct_gui_next_argument(psrc);
  if(co->text) {
    fputs(co->text, psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[73], psrc->fipo);
  }
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(det > 1) {
      dkct_gui_next_argument(psrc);
      if(co->startGroup) {
        fputs(dkct_gui_out_kw[88], psrc->fipo);
      } else {
        fputs(dkct_gui_out_kw[52], psrc->fipo);
      }
      if(det > 2) {
        dkct_gui_next_argument(psrc);
	fputs(co->validator, psrc->fipo);
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for scrollbar.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_scrollbar(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int must_write_details = 0;	/* Details level. */

  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  must_write_details = 0;
  if((co->sizex > 0) && (co->sizey > 0)) {
    must_write_details = 1;
  }
  if(co->direction != DKCT_GUI_DIRECTION_HORIZONTAL) {
    must_write_details = 2;
  }
  if(co->validator) {
     must_write_details = 3;
  }
  if(must_write_details) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(must_write_details > 1) {
      dkct_gui_next_argument(psrc);
      if(co->direction == DKCT_GUI_DIRECTION_HORIZONTAL) {
        fputs(dkct_gui_out_kw[101], psrc->fipo);
      } else {
        fputs(dkct_gui_out_kw[102], psrc->fipo);
      }
      if(must_write_details > 2) {
        dkct_gui_next_argument(psrc);
	fputs(co->validator, psrc->fipo);
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for spin button.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_spinbutton(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int		need_details = 0;	/* Details level. */

  if(co->sizex > 0) { need_details = 1; }
  if(co->sizey > 0) { need_details = 1; }
  if(co->direction != DKCT_GUI_DIRECTION_HORIZONTAL) { need_details = 2; }
  if(co->useKeys) { need_details = 2; }
  if(co->spinWrap) { need_details = 2; }
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(need_details) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(need_details > 1) {
      dkct_gui_next_argument(psrc);
      if(co->direction == DKCT_GUI_DIRECTION_HORIZONTAL) {
        fputs(dkct_gui_out_kw[92], psrc->fipo);
      } else {
        fputs(dkct_gui_out_kw[93], psrc->fipo);
      }
      if(co->useKeys) {
        fputs(dkct_gui_out_kw[94], psrc->fipo);
      }
      if(co->spinWrap) {
        fputs(dkct_gui_out_kw[95], psrc->fipo);
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for spin control.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_spincontrol(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  char			bu[64];	/* Buffer for numeric values. */
  int need_details	= 0;	/* Details level. */

  if(co->text) { need_details = 1; }
  if((co->sizex > 0) && (co->sizey > 0)) { need_details = 2; }
  if(co->useKeys) { need_details = 3; }
  if(co->spinWrap) { need_details = 3; }
  if(co->spinMin != 0) { need_details = 4; }
  if(co->spinMax != 100) { need_details = 5; }
  if(co->spinVal != 0) { need_details = 6; }
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(need_details) {
    dkct_gui_next_argument(psrc);
    if(co->text) {
      fputs(co->text, psrc->fipo);
    } else {
      fputs(dkct_gui_out_kw[73], psrc->fipo);
    }
    if(need_details > 1) {
      dkct_gui_next_argument(psrc);
      fputs(dkct_gui_out_kw[74], psrc->fipo);
      dkct_gui_next_argument(psrc);
      dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
      if(need_details > 2) {
        dkct_gui_next_argument(psrc);
	if(co->useKeys) {
	  if(co->spinWrap) {
	    fputs(dkct_gui_out_kw[96], psrc->fipo);
	  } else {
	    fputs(dkct_gui_out_kw[97], psrc->fipo);
	  }
	} else {
	  if(co->spinWrap) {
	    fputs(dkct_gui_out_kw[98], psrc->fipo);
	  } else {
	    fputs(dkct_gui_out_kw[52], psrc->fipo);
	  }
	}
        if(need_details > 3) {
	  dkct_gui_next_argument(psrc);
	  sprintf(bu, "%d", co->spinMin);
	  fputs(bu, psrc->fipo);
	  if(need_details > 4) {
	    dkct_gui_next_argument(psrc);
	    sprintf(bu, "%d", co->spinMax);
	    fputs(bu, psrc->fipo);
	    if(need_details > 5) {
	      dkct_gui_next_argument(psrc);
	      sprintf(bu, "%d", co->spinVal);
	      fputs(bu, psrc->fipo);
	    }
	  }
	}
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write integer value.
	@param	fipo	Output file.
	@param	i	Value to write.
*/
static
void
dkct_gui_write_int_arg(FILE *fipo, int i)
{
  char bu[64];
  sprintf(bu, "%d", i);
  fputs(bu, fipo);
}





/**	Write element constructor for slider.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_slider(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int	det = 0;	/* Details level. */
  /*
  	parent, id, value, min, max, pos, size (1), style (2), validator (3)
  */
  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  if(co->sliderStyle) det = 2;
  if(co->direction != DKCT_GUI_DIRECTION_HORIZONTAL) det = 2;
  if(co->validator) det = 3;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_int_arg(psrc->fipo, co->spinVal);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_int_arg(psrc->fipo, co->spinMin);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_int_arg(psrc->fipo, co->spinMax);
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(det > 1) {
      if(co->direction == DKCT_GUI_DIRECTION_HORIZONTAL) {
        fputs(dkct_gui_out_kw[103], psrc->fipo);
      } else {
        fputs(dkct_gui_out_kw[104], psrc->fipo);
      }
      if((co->sliderStyle) & DKCT_GUI_SL_STYLE_AUTOTICKS) {
        fputs(dkct_gui_out_kw[105], psrc->fipo);
      }
      if((co->sliderStyle) & DKCT_GUI_SL_STYLE_LABELS) {
        fputs(dkct_gui_out_kw[106], psrc->fipo);
      }
      if((co->sliderStyle) & DKCT_GUI_SL_STYLE_LEFT) {
        fputs(dkct_gui_out_kw[107], psrc->fipo);
      }
      if((co->sliderStyle) & DKCT_GUI_SL_STYLE_RIGHT) {
        fputs(dkct_gui_out_kw[108], psrc->fipo);
      }
      if((co->sliderStyle) & DKCT_GUI_SL_STYLE_TOP) {
        fputs(dkct_gui_out_kw[109], psrc->fipo);
      }
      if((co->sliderStyle) & DKCT_GUI_SL_STYLE_BOTTOM) {
        fputs(dkct_gui_out_kw[110], psrc->fipo);
      }
      if((co->sliderStyle) & DKCT_GUI_SL_STYLE_SELRANGE) {
        fputs(dkct_gui_out_kw[111], psrc->fipo);
      }
      if((co->sliderStyle) & DKCT_GUI_SL_STYLE_INVERSE) {
        fputs(dkct_gui_out_kw[112], psrc->fipo);
      }
      if(det > 2) {
        dkct_gui_next_argument(psrc);
	fputs(co->validator, psrc->fipo);
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor text control
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_textctrl(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int	det = 0;	/* Details level. */
  int	fe = 0;		/* Flag: Found entry. */
  /*
  	parent, id, value (1), pos, size (2), style (3), validator (4)
  */
  if(co->text) det = 1;
  if((co->sizex > 0) && (co->sizey > 0)) det = 2;
  if(co->textStyle) det = 3;
  if(co->validator) det = 4;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(det) {
    dkct_gui_next_argument(psrc);
    if(co->text) {
      fputs(co->text, psrc->fipo);
    } else {
      fputs(dkct_gui_out_kw[73], psrc->fipo);
    }
    if(det > 1) {
      dkct_gui_next_argument(psrc);
      fputs(dkct_gui_out_kw[74], psrc->fipo);
      dkct_gui_next_argument(psrc);
      dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
      if(det > 2) {
        dkct_gui_next_argument(psrc);
        if((co->textStyle) & DKCT_GUI_TEXT_ENTER) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[121], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_TAB) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[122], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_MULTILINE) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[123], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_PASSWORD) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[124], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_READONLY) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[125], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_RICH) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[126], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_RICH2) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[127], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_URL) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[128], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_SHOWSEL) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[129], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_LEFT) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[130], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_CENTRE) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[131], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_RIGHT) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[132], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_NOWRAP) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[133], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_CHARWRAP) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[134], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_WORDWRAP) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[135], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_BESTWRAP) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[136], psrc->fipo);
	}
        if((co->textStyle) & DKCT_GUI_TEXT_CAPITALIZE) {
	  if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); } fe = 1;
	  fputs(dkct_gui_out_kw[137], psrc->fipo);
	}
	if(!(fe)) { fputs(dkct_gui_out_kw[52], psrc->fipo); }
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor toggle button.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_togglebutton(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int	det = 0;	/* Details level. */
  /*
  	parent, id, label, pos, size (1), style (2), validator (3)
  */
  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  if(co->validator) det = 3;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  dkct_gui_next_argument(psrc);
  if(co->text) {
    fputs(co->text, psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[73], psrc->fipo);
  }
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(det > 1) {
      dkct_gui_next_argument(psrc);
      fputs(dkct_gui_out_kw[52], psrc->fipo);
      if(det > 2) {
        dkct_gui_next_argument(psrc);
        fputs(co->validator, psrc->fipo);
      }
    }
  }
}



/**	Write element constructor for gauge.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_gauge(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int	det = 0;	/* Details level. */
  char	bu[64];		/* Buffer for numeric values. */
  /*
  	parent, id, range, pos, size (1), style (2), validator (3)
  */
  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  if(co->direction != DKCT_GUI_DIRECTION_HORIZONTAL) det = 2;
  if(co->gaugeStyle) det = 2;
  if(co->validator) det = 3;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  sprintf(bu, "%d", co->spinMax);
  dkct_gui_next_argument(psrc);
  fputs(bu, psrc->fipo);
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(det > 1) {
      dkct_gui_next_argument(psrc);
      if(co->direction == DKCT_GUI_DIRECTION_HORIZONTAL) {
	fputs(dkct_gui_out_kw[160], psrc->fipo);
      } else {
	fputs(dkct_gui_out_kw[161], psrc->fipo);
      }
      if((co->gaugeStyle) & DKCT_GUI_GAUGE_SMOOTH) {
	fputs(dkct_gui_out_kw[162], psrc->fipo);
      }
      if(det > 2) {
        dkct_gui_next_argument(psrc);
	fputs(co->validator, psrc->fipo);
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for static text.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_statictext(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  unsigned long mask;	/* Mask for check. */
  int det = 0;		/* Details level. */
  int fe  = 0;		/* Flag: Found entry. */
  /*
  	parent, id, label, pos, size (1), style (2)
  */
  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  mask =  DKCT_GUI_TEXT_LEFT;
  mask |= DKCT_GUI_TEXT_CENTRE;
  mask |= DKCT_GUI_TEXT_RIGHT;
  mask |= DKCT_GUI_TEXT_NO_AUTORESIZE;
  if((co->textStyle) & mask) det = 2;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  dkct_gui_next_argument(psrc);
  if(co->text) {
    fputs(co->text, psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[73], psrc->fipo);
  }
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(det > 1) {
      dkct_gui_next_argument(psrc);
      if((co->textStyle) & DKCT_GUI_TEXT_LEFT) {
        fputs(dkct_gui_out_kw[45], psrc->fipo); fe = 1;
      } else {
        if((co->textStyle) & DKCT_GUI_TEXT_CENTRE) {
	  fputs(dkct_gui_out_kw[163], psrc->fipo); fe = 1;
	} else {
	  if((co->textStyle) & DKCT_GUI_TEXT_RIGHT) {
	    fputs(dkct_gui_out_kw[47], psrc->fipo); fe = 1;
	  }
	}
      }
      if((co->textStyle) &  DKCT_GUI_TEXT_NOWRAP) {
        if(fe) { fputs(dkct_gui_out_kw[44], psrc->fipo); }
	fputs(dkct_gui_out_kw[164], psrc->fipo);
	fe = 1;
      }
      if(!(fe)) { fputs(dkct_gui_out_kw[52], psrc->fipo); }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for static bitmap.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_staticbitmap(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int det = 0;		/* Details level. */
  /*
  	parent, id, bitmap, pos, size (1), style (2)
  */
  if((co->sizex  > 0) && (co->sizey > 0)) det = 1;
  if(co->bitmapVarName) {
    fputs(dkct_gui_out_kw[2], psrc->fipo);
    dkct_gui_write_parent_name(pw, psrc, gui);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_idname(co, psrc);
    dkct_gui_next_argument(psrc);
    fputs(co->bitmapVarName, psrc->fipo);
    if(det) {
      dkct_gui_next_argument(psrc);
      fputs(dkct_gui_out_kw[74], psrc->fipo);
      dkct_gui_next_argument(psrc);
      dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    }
    fputs(dkct_gui_out_kw[0], psrc->fipo);
  } else {
    /* ERROR: No bitmap specified! */
    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 51);
  }
}



/**	Write element constructor for static line.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_staticline(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int det = 0;		/* Details level. */
  /*
  	parent, id, pos, size (1), style (2)
  */
  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  if(co->direction != DKCT_GUI_DIRECTION_HORIZONTAL) det = 2;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(det > 1) {
      dkct_gui_next_argument(psrc);
       if(co->direction == DKCT_GUI_DIRECTION_HORIZONTAL) {
         fputs(dkct_gui_out_kw[165], psrc->fipo);
       } else {
         fputs(dkct_gui_out_kw[166], psrc->fipo);
       }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for static box.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_staticbox(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int det = 0;		/* Details level. */
  /*
	parent, id, label, pos, size (1), style (2)
  */
  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(det > 1) {
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for menu bar.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_menubar(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  /*
	No constructor arguments.
  */
}



/**	Write element constructor for menu.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_menu(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  /*
	No constructor arguments.
  */
}



/**	Write element constructor for menu item.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_menuitem(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  /*
	parent->Append(id, label, helpstring, kind);
  */
#if 0
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  if(co->menuItemStyle == DKCT_GUI_MENU_ITEM_SEPARATOR) {
    fputs(dkct_gui_out_kw[171], psrc->fipo);
  } else {
    if(co->idname) {
      fputs(co->idname, psrc->fipo);
    } else {
      fputs(dkct_gui_out_kw[171], psrc->fipo);
    }
  }
  dkct_gui_next_argument(psrc);
  if(co->text) {
    fputs(co->text, psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[73], psrc->fipo);
  }
  dkct_gui_next_argument(psrc);
  if(co->tipText) {
    fputs(co->tipText, psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[73], psrc->fipo);
  }
  dkct_gui_next_argument(psrc);
  switch(co->menuItemStyle) {
    case DKCT_GUI_MENU_ITEM_SEPARATOR: {
      fputs(dkct_gui_out_kw[168], psrc->fipo);
    } break;
    case DKCT_GUI_MENU_ITEM_CHECK: {
      fputs(dkct_gui_out_kw[169], psrc->fipo);
    } break;
    case DKCT_GUI_MENU_ITEM_RADIO: {
      fputs(dkct_gui_out_kw[170], psrc->fipo);
    } break;
    default: {
      fputs(dkct_gui_out_kw[167], psrc->fipo);
    } break;
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
#else
  if(dp) {
    if((dp->name) && (co->name)) {
      fputs(dkct_gui_out_kw[8], psrc->fipo);
      fputs(co->name, psrc->fipo);
      fputs(dkct_gui_out_kw[194], psrc->fipo);
      fputs(dp->name, psrc->fipo);
      switch(co->menuItemStyle) {
        case DKCT_GUI_MENU_ITEM_SEPARATOR: {
          fputs(dkct_gui_out_kw[193], psrc->fipo);
        } break;
        case DKCT_GUI_MENU_ITEM_CHECK: {
          fputs(dkct_gui_out_kw[191], psrc->fipo);
        } break;
        case DKCT_GUI_MENU_ITEM_RADIO: {
          fputs(dkct_gui_out_kw[192], psrc->fipo);
        } break;
        default: {
          fputs(dkct_gui_out_kw[184], psrc->fipo);
        } break;
      }
      if(co->menuItemStyle != DKCT_GUI_MENU_ITEM_SEPARATOR) {
	fputs(dkct_gui_out_kw[0], psrc->fipo);
	fputs(dkct_gui_out_kw[2], psrc->fipo);
        if(co->idname) {
          fputs(co->idname, psrc->fipo);
        } else {
          fputs(dkct_gui_out_kw[171], psrc->fipo);
        }
	dkct_gui_next_argument(psrc);
	if(co->text) {
  	  fputs(co->text, psrc->fipo);
	} else {
  	  fputs(dkct_gui_out_kw[73], psrc->fipo);
	}
	dkct_gui_next_argument(psrc);
	if(co->tipText) {
  	  fputs(co->tipText, psrc->fipo);
	} else {
  	  fputs(dkct_gui_out_kw[73], psrc->fipo);
	}
        fputs(dkct_gui_out_kw[0], psrc->fipo);
	fputs(dkct_gui_out_kw[8], psrc->fipo);
      }
      fputs(dkct_gui_out_kw[24], psrc->fipo);
      fputs(dkct_gui_out_kw[0], psrc->fipo);
    }
  }
#endif
}



/**	Write element constructor for menu item.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_toolbartoolbase(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  /*
	id, text, bitmap, disbitmap (1), kind (2), tip (3)
  */
  fputs(dkct_gui_out_kw[8], psrc->fipo);
  if(co->menuItemStyle != DKCT_GUI_MENU_ITEM_SEPARATOR) {
    fputs(co->name, psrc->fipo);
    fputs(dkct_gui_out_kw[194], psrc->fipo);
  }
  fputs(dp->name, psrc->fipo);
  fputs(dkct_gui_out_kw[185], psrc->fipo);
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_idname(co, psrc);
  dkct_gui_next_argument(psrc);
  if(co->text) {
    fputs(co->text, psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[73], psrc->fipo);
  }
  dkct_gui_next_argument(psrc);
  fputs(co->bitmapVarName, psrc->fipo);
  dkct_gui_next_argument(psrc);
  if(co->bitmapDisabled) {
    fputs(co->bitmapDisabled, psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[186], psrc->fipo);
  }
  /* ITEM KIND */
  dkct_gui_next_argument(psrc);
  switch(co->menuItemStyle) {
    case DKCT_GUI_MENU_ITEM_SEPARATOR: {
      fputs(dkct_gui_out_kw[169], psrc->fipo);
    } break;
    case DKCT_GUI_MENU_ITEM_CHECK: {
      fputs(dkct_gui_out_kw[169], psrc->fipo);
    } break;
    case DKCT_GUI_MENU_ITEM_RADIO: {
      fputs(dkct_gui_out_kw[170], psrc->fipo);
    } break;
    default: {
      fputs(dkct_gui_out_kw[167], psrc->fipo);
    } break;
  }
  if(co->tipText) {
    dkct_gui_next_argument(psrc);
    fputs(co->tipText, psrc->fipo);
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
  fputs(dkct_gui_out_kw[8], psrc->fipo);
  fputs(dkct_gui_out_kw[24], psrc->fipo);
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for tool bar.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_toolbar(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  int det = 0;		/* Details level. */
  /*
	parent, id, pos, size (1), style (2)
  */
  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  if(co->direction != DKCT_GUI_DIRECTION_HORIZONTAL) det = 2;
  if(co->toolbarStyle != DKCT_GUI_TOOLBAR_FLAT) det = 2;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
#if 0
  dkct_gui_write_parent_name(pw, psrc, gui);
#endif
  if(dp) {
    if(dp->name) {
      fputs(dp->name, psrc->fipo);
    } else {
      fputs(dkct_gui_out_kw[65], psrc->fipo);
    }
  } else {
    fputs(dkct_gui_out_kw[65], psrc->fipo);
  }
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(det > 1) {
      dkct_gui_next_argument(psrc);
      switch(co->direction) {
        case DKCT_GUI_DIRECTION_VERTICAL: {
	  fputs(dkct_gui_out_kw[173], psrc->fipo);
	} break;
	default: {
	  fputs(dkct_gui_out_kw[172], psrc->fipo);
	} break;
      }
      if((co->toolbarStyle) & DKCT_GUI_TOOLBAR_FLAT) {
        fputs(dkct_gui_out_kw[174], psrc->fipo);
      }
      if((co->toolbarStyle) & DKCT_GUI_TOOLBAR_DOCKABLE) {
        fputs(dkct_gui_out_kw[175], psrc->fipo);
      }
      if((co->toolbarStyle) & DKCT_GUI_TOOLBAR_TEXT) {
        fputs(dkct_gui_out_kw[176], psrc->fipo);
      }
      if((co->toolbarStyle) & DKCT_GUI_TOOLBAR_NOICONS) {
        fputs(dkct_gui_out_kw[177], psrc->fipo);
      }
      if((co->toolbarStyle) & DKCT_GUI_TOOLBAR_NODIVIDER) {
        fputs(dkct_gui_out_kw[178], psrc->fipo);
      }
      if((co->toolbarStyle) & DKCT_GUI_TOOLBAR_HORZ_LAYOUT) {
        if((co->toolbarStyle) & DKCT_GUI_TOOLBAR_TEXT) {
	  if(!((co->toolbarStyle) & DKCT_GUI_TOOLBAR_NOICONS)) {
            fputs(dkct_gui_out_kw[180], psrc->fipo);
	  }
	}
      }
      if((co->toolbarStyle) & DKCT_GUI_TOOLBAR_NO_TOOLTIPS) {
        fputs(dkct_gui_out_kw[181], psrc->fipo);
      }
      if((co->toolbarStyle) & DKCT_GUI_TOOLBAR_BOTTOM) {
        fputs(dkct_gui_out_kw[182], psrc->fipo);
      }
      if((co->toolbarStyle) & DKCT_GUI_TOOLBAR_RIGHT) {
        fputs(dkct_gui_out_kw[183], psrc->fipo);
      }
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



/**	Write element constructor for grid.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_grid(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  /* parent, id, pos, size (1), style, name */
  int			 det = 0;
  if((co->sizex > 0) && (co->sizey > 0)) det = 1;
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(det) {
    dkct_gui_next_argument(psrc);
    fputs(dkct_gui_out_kw[74], psrc->fipo);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
    if(det > 1) {
    }
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}



#if 0
/**	Write element constructor (parent, id and text).
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_parent_id_and_text(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  dkct_gui_next_argument(psrc);
  dkct_gui_write_idname(co, psrc);
  if(co->text) {
    dkct_gui_next_argument(psrc);
    fputs(co->text, psrc->fipo);
  }
  fputs(dkct_gui_out_kw[0], psrc->fipo);
}
#endif


#if 0
/**	Write element constructor (parent, id and bitmap).
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_constructor_parent_id_and_bitmap(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  if(co->bitmapVarName) {
    fputs(dkct_gui_out_kw[2], psrc->fipo);
    dkct_gui_write_parent_name(pw, psrc, gui);
    dkct_gui_next_argument(psrc);
    dkct_gui_write_idname(co, psrc);
    if(co->bitmapVarName) {
      dkct_gui_next_argument(psrc);
      fputs(co->bitmapVarName, psrc->fipo);
    }
    fputs(dkct_gui_out_kw[0], psrc->fipo);
  } else {
    /* ERROR: No bitmap expression specified! */
    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 51);
  }
}
#endif



/**	Write instruction to set bitmap.
	@param	co	Current object.
	@param	psrc	Source structure.
	@param	szind	Index of method name.
	@param	bm	Bitmap value.
*/
static
void
dkct_gui_write_set_bitmap(
  DKCT_GUI_ELEMENT	*co,
  DKCT_SRC		*psrc,
  size_t		 szind,
  char			*bm
)
{
  if(co->name) {
    fputs(dkct_gui_out_kw[8], psrc->fipo);
    fputs(co->name, psrc->fipo);
    fputs(dkct_gui_out_kw[szind], psrc->fipo);
    fputs(bm, psrc->fipo);
    fputs(dkct_gui_out_kw[24], psrc->fipo);
    fputs(dkct_gui_out_kw[0], psrc->fipo);
  }
}



/**	Write element constructor and add element to parent
	object or sizer.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_finalize_after_constructor(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  DKCT_GRID_HEAD	*gh	= NULL;
  char const		*fnptr = NULL;	/* File to use for debug output. */
  int			 rows;
  int			 columns;
  

#line 8392 "dkct-gui.ctr"
  /*
  	Jump to end if construction failed.
	if(!(object)) {
	  goto dkctGUILayoutFinished;
	}
  */
  fnptr = dkct_tr_get_kw8(((psrc->dkcto).deb == 2) ? 28 : 29);
  fputs(dkct_gui_out_kw[25], psrc->fipo);
  fputs(co->name, psrc->fipo);
  fputs(dkct_gui_out_kw[26], psrc->fipo);
  if((psrc->dkcto).deb) {
    

#line 8404 "dkct-gui.ctr"
    fputs(dkct_tr_get_kw8(24), psrc->fipo);
    if((psrc->dkcto).win) {
      fputs(dkct_tr_get_kw8(21), psrc->fipo);
      /* 16-bit begin */
      if((psrc->dkcto).deb != 2) {
        fputs(dkct_tr_get_kw8(30), psrc->fipo);
      }
      if((psrc->dkcto).ts) {
        if((psrc->dkcto).deb == 2) {
          fputs(dkct_tr_get_kw8(72), psrc->fipo);
        } else {
          fputs(dkct_tr_get_kw8(71), psrc->fipo);
        }
      }
      fputs(dkct_tr_get_kw8(61), psrc->fipo);
      dkct_tr_show_filename_and_lineno(psrc);
      fputs(dkct_tr_get_kw8(35), psrc->fipo);
      fputs(fnptr, psrc->fipo);
      fputs(dkct_tr_get_kw8(34), psrc->fipo);
      fputs(dkct_tr_get_kw8(61), psrc->fipo);
      fputs(dkct_tr_get_kw8(73), psrc->fipo);
      if(co->name) {
        fputs(co->name, psrc->fipo);
      }
      fputs(dkct_tr_get_kw8(74), psrc->fipo);
      fputs(dkct_tr_get_kw8(35), psrc->fipo);
      fputs(fnptr, psrc->fipo);
      fputs(dkct_tr_get_kw8(34), psrc->fipo);
      if((psrc->dkcto).deb != 2) {
        fputs(dkct_tr_get_kw8(31), psrc->fipo);
      }
      /* 16-bit end */
      fputs(dkct_tr_get_kw8(22), psrc->fipo);
    }
    /* 8-bit begin */
    if((psrc->dkcto).deb != 2) {
      fputs(dkct_tr_get_kw8(30), psrc->fipo);
    }
    if((psrc->dkcto).ts) {
      if((psrc->dkcto).deb == 2) {
        fputs(dkct_tr_get_kw8(70), psrc->fipo);
      } else {
        fputs(dkct_tr_get_kw8(32), psrc->fipo);
      }
    }
    fputs(dkct_tr_get_kw8(33), psrc->fipo);
    dkct_tr_show_filename_and_lineno(psrc);
    fputs(dkct_tr_get_kw8(35), psrc->fipo);
    fputs(fnptr, psrc->fipo);
    fputs(dkct_tr_get_kw8(34), psrc->fipo);
    fputs(dkct_tr_get_kw8(33), psrc->fipo);
    fputs(dkct_tr_get_kw8(73), psrc->fipo);
    if(co->name) {
      fputs(co->name, psrc->fipo);
    }
    fputs(dkct_tr_get_kw8(74), psrc->fipo);
    fputs(dkct_tr_get_kw8(35), psrc->fipo);
    fputs(fnptr, psrc->fipo);
    fputs(dkct_tr_get_kw8(34), psrc->fipo);
    if((psrc->dkcto).deb != 2) {
      fputs(dkct_tr_get_kw8(31), psrc->fipo);
    }
    /* 8-bit end */
    if((psrc->dkcto).win) {
      fputs(dkct_tr_get_kw8(23), psrc->fipo);
    }
    fputs(dkct_tr_get_kw8(25), psrc->fipo);
  }
  

#line 8473 "dkct-gui.ctr"
  fputs(dkct_gui_out_kw[27], psrc->fipo);
  fputs(dkct_gui_out_kw[28], psrc->fipo);
  /* SUCCESS DEBUG CODE */
  if((psrc->dkcto).deb) {
    

#line 8478 "dkct-gui.ctr"
    fputs(dkct_tr_get_kw8(24), psrc->fipo);
    if((psrc->dkcto).win) {
      fputs(dkct_tr_get_kw8(21), psrc->fipo);
      /* 16-bit begin */
      if((psrc->dkcto).deb != 2) {
        fputs(dkct_tr_get_kw8(30), psrc->fipo);
      }
      if((psrc->dkcto).ts) {
        if((psrc->dkcto).deb == 2) {
          fputs(dkct_tr_get_kw8(72), psrc->fipo);
        } else {
          fputs(dkct_tr_get_kw8(71), psrc->fipo);
        }
      }
      fputs(dkct_tr_get_kw8(61), psrc->fipo);
      dkct_tr_show_filename_and_lineno(psrc);
      fputs(dkct_tr_get_kw8(35), psrc->fipo);
      fputs(fnptr, psrc->fipo);
      fputs(dkct_tr_get_kw8(34), psrc->fipo);
      fputs(dkct_tr_get_kw8(61), psrc->fipo);
      fputs(dkct_tr_get_kw8(76), psrc->fipo);
      if(co->name) {
        fputs(co->name, psrc->fipo);
      }
      fputs(dkct_tr_get_kw8(74), psrc->fipo);
      fputs(dkct_tr_get_kw8(35), psrc->fipo);
      fputs(fnptr, psrc->fipo);
      fputs(dkct_tr_get_kw8(34), psrc->fipo);
      if((psrc->dkcto).deb != 2) {
        fputs(dkct_tr_get_kw8(31), psrc->fipo);
      }
      /* 16-bit end */
      fputs(dkct_tr_get_kw8(22), psrc->fipo);
    }
    /* 8-bit begin */
    if((psrc->dkcto).deb != 2) {
      fputs(dkct_tr_get_kw8(30), psrc->fipo);
    }
    if((psrc->dkcto).ts) {
      if((psrc->dkcto).deb == 2) {
        fputs(dkct_tr_get_kw8(70), psrc->fipo);
      } else {
        fputs(dkct_tr_get_kw8(32), psrc->fipo);
      }
    }
    fputs(dkct_tr_get_kw8(33), psrc->fipo);
    dkct_tr_show_filename_and_lineno(psrc);
    fputs(dkct_tr_get_kw8(35), psrc->fipo);
    fputs(fnptr, psrc->fipo);
    fputs(dkct_tr_get_kw8(34), psrc->fipo);
    fputs(dkct_tr_get_kw8(33), psrc->fipo);
    fputs(dkct_tr_get_kw8(76), psrc->fipo);
    if(co->name) {
      fputs(co->name, psrc->fipo);
    }
    fputs(dkct_tr_get_kw8(74), psrc->fipo);
    fputs(dkct_tr_get_kw8(35), psrc->fipo);
    fputs(fnptr, psrc->fipo);
    fputs(dkct_tr_get_kw8(34), psrc->fipo);
    if((psrc->dkcto).deb != 2) {
      fputs(dkct_tr_get_kw8(31), psrc->fipo);
    }
    /* 8-bit end */
    if((psrc->dkcto).win) {
      fputs(dkct_tr_get_kw8(23), psrc->fipo);
    }
    fputs(dkct_tr_get_kw8(25), psrc->fipo);
  }
  /*
  	Further element setup, done *before* we deal with contents.
  */
  switch(co->cln) {
    case  0: {	

#line 8551 "dkct-gui.ctr"
    } break;
    case  1: {	

#line 8553 "dkct-gui.ctr"
    } break;
    case  2: {	

#line 8555 "dkct-gui.ctr"
    } break;
    case  3: {	

#line 8557 "dkct-gui.ctr"
    } break;
    case  4: {	

#line 8559 "dkct-gui.ctr"
    } break;
    case  5: {	

#line 8561 "dkct-gui.ctr"
    } break;
    case  6: {	

#line 8563 "dkct-gui.ctr"
    } break;
    case  7: {	

#line 8565 "dkct-gui.ctr"
    } break;
    case  8: {	

#line 8567 "dkct-gui.ctr"
    } break;
    case  9: {	

#line 8569 "dkct-gui.ctr"
    } break;
    case 10: {	

#line 8571 "dkct-gui.ctr"
    } break;
    case 11: {	

#line 8573 "dkct-gui.ctr"
    } break;
    case 12: {	

#line 8575 "dkct-gui.ctr"
    } break;
    case 13: {	

#line 8577 "dkct-gui.ctr"
      /* Set size */
    } break;
    case 14: {	

#line 8580 "dkct-gui.ctr"
    } break;
    case 15: {	

#line 8582 "dkct-gui.ctr"
    } break;
    case 16: {	

#line 8584 "dkct-gui.ctr"
      if(co->bitmapDisabled) {
        dkct_gui_write_set_bitmap(co, psrc, 156, co->bitmapDisabled);
      }
      if(co->bitmapSelected) {
        dkct_gui_write_set_bitmap(co, psrc, 157, co->bitmapSelected);
      }
      if(co->bitmapFocus) {
        dkct_gui_write_set_bitmap(co, psrc, 158, co->bitmapFocus);
      }
      if(co->bitmapHover) {
        dkct_gui_write_set_bitmap(co, psrc, 159, co->bitmapHover);
      }
    } break;
    case 17: {	

#line 8598 "dkct-gui.ctr"
    } break;
    case 18: {	

#line 8600 "dkct-gui.ctr"
    } break;
    case 19: {	

#line 8602 "dkct-gui.ctr"
      if(co->state != 0x00) {
        fputs(co->name, psrc->fipo);
        if(co->nStates == 0x03) {
	  if(co->state == 0x02) {
	    fputs(dkct_gui_out_kw[78], psrc->fipo);
	  } else {
	    fputs(dkct_gui_out_kw[79], psrc->fipo);
	  }
	} else {
	  fputs(dkct_gui_out_kw[77], psrc->fipo);
	}
      }
    } break;
    case 20: {	

#line 8616 "dkct-gui.ctr"
    } break;
    case 21: {	

#line 8618 "dkct-gui.ctr"
    } break;
    case 22: {	

#line 8620 "dkct-gui.ctr"
    } break;
    case 23: {	

#line 8622 "dkct-gui.ctr"
    } break;
    case 24: {	

#line 8624 "dkct-gui.ctr"
    } break;
    case 25: {	

#line 8626 "dkct-gui.ctr"
    } break;
    case 26: {	

#line 8628 "dkct-gui.ctr"
    } break;
    case 27: {	

#line 8630 "dkct-gui.ctr"
    } break;
    case 28: {	

#line 8632 "dkct-gui.ctr"
    } break;
    case 29: {	

#line 8634 "dkct-gui.ctr"
    } break;
    case 30: {	

#line 8636 "dkct-gui.ctr"
    } break;
    case 31: {	

#line 8638 "dkct-gui.ctr"
    } break;
    case 32: {	

#line 8640 "dkct-gui.ctr"
    } break;
    case 33: {	

#line 8642 "dkct-gui.ctr"
    } break;
    case 34: {	

#line 8644 "dkct-gui.ctr"
    } break;
    case 35: {	

#line 8646 "dkct-gui.ctr"
    } break;
    case 36: {	

#line 8648 "dkct-gui.ctr"
    } break;
    case 37: {	

#line 8650 "dkct-gui.ctr"
    } break;
    case 38: {	

#line 8652 "dkct-gui.ctr"
    } break;
    case 39: {	

#line 8654 "dkct-gui.ctr"
    } break;
    case 41: {	

#line 8656 "dkct-gui.ctr"
      if(co->gridTable) {	

#line 8657 "dkct-gui.ctr"
        fputs(dkct_gui_out_kw[8], psrc->fipo);
        fputs(co->name, psrc->fipo);
	fputs(dkct_gui_out_kw[198], psrc->fipo);
	fputs(co->gridTable, psrc->fipo);
	if(co->tableOwner) {
	  fputs(dkct_gui_out_kw[55], psrc->fipo);
	  fputs(dkct_gui_out_kw[199], psrc->fipo);
	}
	fputs(dkct_gui_out_kw[24], psrc->fipo);
	fputs(dkct_gui_out_kw[0], psrc->fipo);
      } else {			

#line 8668 "dkct-gui.ctr"
        rows = columns = 0;
        if(co->nRowHeads > co->nRows) {
	  rows = co->nRowHeads;
	} else {
	  rows = co->nRows;
	}
	if(co->nColumnHeads > co->nColumns) {
	  columns = co->nColumnHeads;
	} else {
	  columns = co->nColumns;
	}
	if(rows < 1) rows = 1;
	if(columns < 1) columns = 1;
        fputs(dkct_gui_out_kw[8], psrc->fipo);
        fputs(co->name, psrc->fipo);
	fputs(dkct_gui_out_kw[200], psrc->fipo);
	fprintf(psrc->fipo, "%d, %d", rows, columns);
	fputs(dkct_gui_out_kw[24], psrc->fipo);
	fputs(dkct_gui_out_kw[0], psrc->fipo);
      }
      if((co->sColumnHeads) && (co->iColumnHeads)) {
        dk3sto_it_reset(co->iColumnHeads);
	do {
	  gh = (DKCT_GRID_HEAD *)dk3sto_it_next(co->iColumnHeads);
	  if(gh) {
            fputs(dkct_gui_out_kw[8], psrc->fipo);
            fputs(co->name, psrc->fipo);
	    fputs(dkct_gui_out_kw[201], psrc->fipo);
	    fprintf(psrc->fipo, "%d", gh->elno);
	    fputs(dkct_gui_out_kw[55], psrc->fipo);
	    fputs(gh->text, psrc->fipo);
	    fputs(dkct_gui_out_kw[24], psrc->fipo);
	    fputs(dkct_gui_out_kw[0], psrc->fipo);
	  }
	} while(gh);
      }
      if((co->sRowHeads) && (co->iRowHeads)) {
        dk3sto_it_reset(co->iRowHeads);
	do {
	  gh = (DKCT_GRID_HEAD *)dk3sto_it_next(co->iRowHeads);
	  if(gh) {
            fputs(dkct_gui_out_kw[8], psrc->fipo);
            fputs(co->name, psrc->fipo);
	    fputs(dkct_gui_out_kw[202], psrc->fipo);
	    fprintf(psrc->fipo, "%d", gh->elno);
	    fputs(dkct_gui_out_kw[55], psrc->fipo);
	    fputs(gh->text, psrc->fipo);
	    fputs(dkct_gui_out_kw[24], psrc->fipo);
	    fputs(dkct_gui_out_kw[0], psrc->fipo);
	  }
	} while(gh);
      }
      if((DKCT_GUI_TEXT_READONLY) & (co->textStyle)) {
        fputs(dkct_gui_out_kw[8], psrc->fipo);
	fputs(co->name, psrc->fipo);
	fputs(dkct_gui_out_kw[203], psrc->fipo);
	fputs(dkct_gui_out_kw[0], psrc->fipo);
      }
    } break;
  }
  /*
  	Minimal size, if any.
  */
  if((co->sizemx > 0) && (co->sizemy > 0)) {
    fputs(dkct_gui_out_kw[8], psrc->fipo);
    fputs(co->name, psrc->fipo);
    fputs(dkct_gui_out_kw[204], psrc->fipo);
    fprintf(psrc->fipo, "%d, %d", co->sizemx, co->sizemy);
    fputs(dkct_gui_out_kw[205], psrc->fipo);
    fputs(dkct_gui_out_kw[0], psrc->fipo);
  }
  

#line 8740 "dkct-gui.ctr"
}



/**	Write constructor arguments start when constructor is given.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
	@param	comma	Flag: Write a final comma.
*/
static
void
dkct_gui_constructor_constructor(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui,
  int			 comma
)
{
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  dkct_gui_write_parent_name(pw, psrc, gui);
  fputs(dkct_gui_out_kw[209], psrc->fipo);
  if(co->idname) {
    fputs(co->idname, psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[66], psrc->fipo);
  }
  if(comma) {
    fputs(dkct_gui_out_kw[209], psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[0], psrc->fipo);
  }
}


/**	Write element constructor and add element to parent
	object or sizer.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_write_element_constructor(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  

#line 8798 "dkct-gui.ctr"
  /*
  	Write tests to check constructor prerequisitions.
  */
  switch(co->cln) {
    case 16:
    case 40:
    {
#if 0
      /*
	2011-07-30: Bitmaps are typically compiled-in.
      */
      if(co->bitmapVarName) {
        

#line 8811 "dkct-gui.ctr"
        fputs(dkct_gui_out_kw[25], psrc->fipo);
	fputs(co->bitmapVarName, psrc->fipo);
	fputs(dkct_gui_out_kw[26], psrc->fipo);
	fputs(dkct_gui_out_kw[27], psrc->fipo);
	fputs(dkct_gui_out_kw[28], psrc->fipo);
      }
#endif
    } break;
  }
  /*
  	Write constructor.
	object = new class(arguments);
  */
  switch(co->cln) {
    case 37: {
      if(dp) {
        if(dp->cln == 36) {
	  if(co->text) {
            dkct_gui_constructor_menuitem(co, dp, pw, psrc, gui);
            if(co->menuItemStyle != DKCT_GUI_MENU_ITEM_SEPARATOR) {
              dkct_gui_finalize_after_constructor(co, dp, pw, psrc, gui);
            }
	  } else {
	    /* ERROR: No text specified */
	    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 49);
	  }
	} else {	

#line 8838 "dkct-gui.ctr"
	  /* ERROR: Parent is not a menu */
	  dkct_gui_report_illegal_parent_child(co, dp, gui->psrc);
	}
      } else {
        /* ERROR: No parent */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 92);
      }
    } break;
    case 40: {
      if(dp) {
        if(dp->cln == 38) {
          if(dp->name) {
	    if(co->bitmapVarName) {
	      if(co->text) {
                dkct_gui_constructor_toolbartoolbase(co, dp, pw, psrc, gui);
                if(co->menuItemStyle != DKCT_GUI_MENU_ITEM_SEPARATOR) {
                  dkct_gui_finalize_after_constructor(co, dp, pw, psrc, gui);
                }
	      } else {
	        /* ERROR: No text */
	        dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 49);
	      }
	    } else {
	      /* ERROR: No bitmap */
	      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 51);
	    }
	  } else {
	    /* ERROR: No parent name */
	    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 91);
	  }
	} else {	

#line 8869 "dkct-gui.ctr"
	  /* ERROR: Parent is not a toolbar */
	  dkct_gui_report_illegal_parent_child(co, dp, gui->psrc);
	}
      } else {
        /* ERROR: No parent */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 92);
      }
    } break;
    default: {
      fputs(dkct_gui_out_kw[8], psrc->fipo);
      fputs(co->name, psrc->fipo);
      fputs(dkct_gui_out_kw[23], psrc->fipo);
      fputs(co->cname, psrc->fipo);
      fputs(dkct_gui_out_kw[29], psrc->fipo);
      if(co->constructor) {
        if(!(co->compConst)) {
	  dkct_gui_constructor_constructor(co,dp,pw,psrc,gui,1);
	}
        fputs(co->constructor, psrc->fipo);
	fputs(dkct_gui_out_kw[0], psrc->fipo);
        switch(co->cln) {
          case 5:
          {
            /* WARNING: Constructor specified, not recommended! */
	    dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 80);
          } break;
        }
      } else {
        switch(co->cln) {
          case  0: {	

#line 8899 "dkct-gui.ctr"
            dkct_gui_constructor_frame_dialog(co,dp,pw,psrc,gui);
          } break;
          case  1: {	

#line 8902 "dkct-gui.ctr"
            dkct_gui_constructor_frame_dialog(co,dp,pw,psrc,gui);
          } break;
          case  2: {	

#line 8905 "dkct-gui.ctr"
            dkct_gui_constructor_frame_dialog(co,dp,pw,psrc,gui);
          } break;
          case  3: {	

#line 8908 "dkct-gui.ctr"
            dkct_gui_constructor_frame_dialog(co,dp,pw,psrc,gui);
          } break;
          case  4: {	

#line 8911 "dkct-gui.ctr"
          } break;
          case  5: {	

#line 8913 "dkct-gui.ctr"
	    dkct_gui_constructor_boxsizer(co, dp, pw, psrc, gui);
          } break;
          case  6: {	

#line 8916 "dkct-gui.ctr"
            dkct_gui_constructor_gridsizer(co,dp,pw,psrc,gui);
          } break;
          case  7: {	

#line 8919 "dkct-gui.ctr"
            dkct_gui_constructor_gridbagsizer(co,dp,pw,psrc,gui);
          } break;
          case  8: {	

#line 8922 "dkct-gui.ctr"
            dkct_gui_constructor_gridsizer(co,dp,pw,psrc,gui);
          } break;
          case  9: {	

#line 8925 "dkct-gui.ctr"
            dkct_gui_constructor_staticboxsizer(co,dp,pw,psrc,gui);
          } break;
          case 10: {	

#line 8928 "dkct-gui.ctr"
            /* No constructor arguments at all. */
          } break;
          case 11: {	

#line 8931 "dkct-gui.ctr"
            dkct_gui_constructor_panel(co, dp, pw, psrc, gui);
          } break;
          case 12: {	

#line 8934 "dkct-gui.ctr"
            dkct_gui_constructor_notebook(co, dp, pw, psrc, gui);
          } break;
          case 13: {	

#line 8937 "dkct-gui.ctr"
            dkct_gui_constructor_scrolledwindow(co, dp, pw, psrc, gui);
          } break;
          case 14: {	

#line 8940 "dkct-gui.ctr"
            dkct_gui_constructor_splitterwindow(co, dp, pw, psrc, gui);
          } break;
          case 15: {	

#line 8943 "dkct-gui.ctr"
            dkct_gui_constructor_button(co, dp, pw, psrc, gui);
          } break;
          case 16: {	

#line 8946 "dkct-gui.ctr"
            dkct_gui_constructor_bitmapbutton(co, dp, pw, psrc, gui);
          } break;
          case 17: {	

#line 8949 "dkct-gui.ctr"
            dkct_gui_constructor_choice_combo(co, dp, pw, psrc, gui, 0);
          } break;
          case 18: {	

#line 8952 "dkct-gui.ctr"
            dkct_gui_constructor_choice_combo(co, dp, pw, psrc, gui, 1);
          } break;
          case 19: {	

#line 8955 "dkct-gui.ctr"
            dkct_gui_constructor_checkbox(co, dp, pw, psrc, gui);
          } break;
          case 20: {	

#line 8958 "dkct-gui.ctr"
            dkct_gui_constructor_listbox(co, dp, pw, psrc, gui);
          } break;
          case 21: {	

#line 8961 "dkct-gui.ctr"
            dkct_gui_constructor_checklistbox(co, dp, pw, psrc, gui);
          } break;
          case 22: {	

#line 8964 "dkct-gui.ctr"
            dkct_gui_constructor_radiobox(co, dp, pw, psrc, gui);
          } break;
          case 23: {	

#line 8967 "dkct-gui.ctr"
            dkct_gui_constructor_radiobutton(co, dp, pw, psrc, gui);
          } break;
          case 24: {	

#line 8970 "dkct-gui.ctr"
            dkct_gui_constructor_scrollbar(co, dp, pw, psrc, gui);
          } break;
          case 25: {	

#line 8973 "dkct-gui.ctr"
            dkct_gui_constructor_spinbutton(co, dp, pw, psrc, gui);
          } break;
          case 26: {	

#line 8976 "dkct-gui.ctr"
            dkct_gui_constructor_spincontrol(co, dp, pw, psrc, gui);
          } break;
          case 27: {	

#line 8979 "dkct-gui.ctr"
            dkct_gui_constructor_slider(co, dp, pw, psrc, gui);
          } break;
          case 28: {	

#line 8982 "dkct-gui.ctr"
            dkct_gui_constructor_textctrl(co, dp, pw, psrc, gui);
          } break;
          case 29: {	

#line 8985 "dkct-gui.ctr"
            dkct_gui_constructor_togglebutton(co, dp, pw, psrc, gui);
          } break;
          case 30: {	

#line 8988 "dkct-gui.ctr"
            dkct_gui_constructor_gauge(co, dp, pw, psrc, gui);
          } break;
          case 31: {	

#line 8991 "dkct-gui.ctr"
            dkct_gui_constructor_statictext(co, dp, pw, psrc, gui);
          } break;
          case 32: {	

#line 8994 "dkct-gui.ctr"
            dkct_gui_constructor_staticbitmap(co, dp, pw, psrc, gui);
          } break;
          case 33: {	

#line 8997 "dkct-gui.ctr"
            dkct_gui_constructor_staticline(co, dp, pw, psrc, gui);
          } break;
          case 34: {	

#line 9000 "dkct-gui.ctr"
            dkct_gui_constructor_staticbox(co, dp, pw, psrc, gui);
          } break;
          case 35: {	

#line 9003 "dkct-gui.ctr"
            dkct_gui_constructor_menubar(co, dp, pw, psrc, gui);
          } break;
          case 36: {	

#line 9006 "dkct-gui.ctr"
            dkct_gui_constructor_menu(co, dp, pw, psrc, gui);
          } break;
#if 0
          case 37: {	

#line 9010 "dkct-gui.ctr"
	    /*
	    	Never happens.
	    */
          } break;
#endif
          case 38: {	

#line 9016 "dkct-gui.ctr"
            dkct_gui_constructor_toolbar(co, dp, pw, psrc, gui);
          } break;
          case 39: {	

#line 9019 "dkct-gui.ctr"
          } break;
	  case 41: {
	    dkct_gui_constructor_grid(co, dp, pw, psrc, gui);
	  } break;
	  default: {
	    if(!(co->compConst)) {
	      dkct_gui_constructor_constructor(co,dp,pw,psrc,gui,0);
	    }
	  } break;
        }
      }
      fputs(dkct_gui_out_kw[37], psrc->fipo);
      dkct_gui_finalize_after_constructor(co, dp, pw, psrc, gui);
    } break;
  }
  

#line 9035 "dkct-gui.ctr"
}



/**	Add pseudo object.
	@param	co	Current object.
	@param	dp	Direct parent.
	@param	pw	Parent window.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_add_pseudo_object(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_GUI_ELEMENT	*pw,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  char		bu[256];	/* Buffer for numeric values. */
  

#line 9058 "dkct-gui.ctr"
  if(dp) {
    switch(dp->cln) {
      case 7: {						/* gridbag sizer */
	switch(co->pseudoobj) {
	  case 1: case 2: {	

#line 9063 "dkct-gui.ctr"
	    fputs(dkct_gui_out_kw[8], psrc->fipo);
	    if(dp->name) {
	      fputs(dp->name, psrc->fipo);
	      fputs(dkct_gui_out_kw[31], psrc->fipo);
	    }
	    fputs(dkct_gui_out_kw[196], psrc->fipo);
	    sprintf(bu, "%d", co->sizex);
	    fputs(bu, psrc->fipo);
	    fputs(dkct_gui_out_kw[55], psrc->fipo);
	    sprintf(bu, "%d", co->sizey);
	    fputs(bu, psrc->fipo);
	    fputs(dkct_gui_out_kw[55], psrc->fipo);
	    /* wxGBPosition() */
	    sprintf(bu, "%d, %d", co->posy, co->posx);
	    fputs(dkct_gui_out_kw[53], psrc->fipo);
	    fputs(bu, psrc->fipo);
	    fputs(dkct_gui_out_kw[56], psrc->fipo);
	    fputs(dkct_gui_out_kw[55], psrc->fipo);
	    sprintf(bu, "%d, %d", co->spany, co->spanx);
	    fputs(dkct_gui_out_kw[54], psrc->fipo);
	    fputs(bu, psrc->fipo);
	    fputs(dkct_gui_out_kw[56], psrc->fipo);
#if 0
	    /* 2011-07-30: No wxGROW flag for spacers. */
	    if(co->expandFlag) {
	      fputs(dkct_gui_out_kw[55], psrc->fipo);
	      fputs(dkct_gui_out_kw[51], psrc->fipo);
	    }
#endif
	    fputs(dkct_gui_out_kw[24], psrc->fipo);
	    fputs(dkct_gui_out_kw[0], psrc->fipo);
	  } break;
	  default: {
	    /* ERROR: Can not add this class to parent! */
	    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 81);
	  } break;
	}
      } break;
      case 5: case 6: case 8: case 9: case 10: {	/* other sizers */
        /*
		parent->Add(width, height, proportion, flags);
	*/
	switch(co->pseudoobj) {
	  case 1: case 2: {	

#line 9107 "dkct-gui.ctr"
	    fputs(dkct_gui_out_kw[8], psrc->fipo);
	    if(dp->name) {
	      fputs(dp->name, psrc->fipo);
	      fputs(dkct_gui_out_kw[31], psrc->fipo);
	    }
	    fputs(dkct_gui_out_kw[196], psrc->fipo);
	    sprintf(bu, "%d", co->sizex);
	    fputs(bu, psrc->fipo);
	    fputs(dkct_gui_out_kw[55], psrc->fipo);
	    sprintf(bu, "%d", co->sizey);
	    fputs(bu, psrc->fipo);
	    fputs(dkct_gui_out_kw[55], psrc->fipo);
	    sprintf(bu, "%d", co->proportion);
	    fputs(bu, psrc->fipo);
#if 0
	    /* 2011-07-30: No wxGROW flag for stretch and spacers. */
	    if(co->expandFlag) {
	      fputs(dkct_gui_out_kw[55], psrc->fipo);
	      fputs(dkct_gui_out_kw[51], psrc->fipo);
	    }
#endif
	    fputs(dkct_gui_out_kw[24], psrc->fipo);
	    fputs(dkct_gui_out_kw[0], psrc->fipo);
	  } break;
	  default: {
	    /* ERROR: Can not add this class! */
	    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 81);
	  } break;
	}
      } break;
      case 36: {					/* menu */
        switch(co->pseudoobj) {
	  case 3: {
	    fputs(dkct_gui_out_kw[8], psrc->fipo);
	    if(dp->name) {
	      fputs(dp->name, psrc->fipo);
	      fputs(dkct_gui_out_kw[31], psrc->fipo);
	    }
	    fputs(dkct_gui_out_kw[188], psrc->fipo);
	  } break;
	  default: {
	    /* ERROR: Can not add this class! */
	    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 81);
	  } break;
	}
      } break;
      case 38: {				/* tool bar */
        switch(co->pseudoobj) {
	  case 3: {
	    fputs(dkct_gui_out_kw[8], psrc->fipo);
	    if(dp->name) {
	      fputs(dp->name, psrc->fipo);
	      fputs(dkct_gui_out_kw[31], psrc->fipo);
	    }
	    fputs(dkct_gui_out_kw[189], psrc->fipo);
	  } break;
	  default: {
	    /* ERROR: Can not add this class! */
	    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 81);
	  } break;
	}
      } break;
    }
  }
  

#line 9172 "dkct-gui.ctr"
}



/**	Finish wxSplitterWindow after finishing the contents.
	@param	co	Current object.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_finish_splitter_window(
  DKCT_GUI_ELEMENT	*co,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  char			bu[64];		/* Buffer for numeric values. */
  DKCT_GUI_ELEMENT	*a	= NULL;	/* First child window. */
  DKCT_GUI_ELEMENT	*b	= NULL;	/* Second child window. */
  char			*na	= NULL;	/* Name of first child. */
  char			*nb	= NULL;	/* Name of second child. */
  char			*nc	= NULL;	/* Current objects name. */
  dk3sto_it_reset(co->i_contents);
  a = (DKCT_GUI_ELEMENT *)dk3sto_it_next(co->i_contents);
  if(a) {
    b = (DKCT_GUI_ELEMENT *)dk3sto_it_next(co->i_contents);
    if(b) {
      if(dk3sto_it_next(co->i_contents)) {
        /* ERROR: Too many elements for splitter window */
	dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 47);
      }
    }
  }
  if(a) { na = a->name; }
  if(b) { nb = b->name; }
  nc = co->name;
  if((na) && (nb)) {
    /*
  	if((na) && (nb)) {
	  nc->SplitHorizontally(na, nb, sash); 
	}
    */
  } else {
    /* ERROR: Too few contents for splitter window. */
    dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 47);
  }
  fputs(dkct_gui_out_kw[8], psrc->fipo);
  fputs(dkct_gui_out_kw[67], psrc->fipo);
  fputs(na, psrc->fipo);
  fputs(dkct_gui_out_kw[68], psrc->fipo);
  fputs(nb, psrc->fipo);
  fputs(dkct_gui_out_kw[69], psrc->fipo);
  fputs(dkct_gui_out_kw[2], psrc->fipo);
  fputs(nc, psrc->fipo);
  fputs(dkct_gui_out_kw[31], psrc->fipo);
  if(co->direction == DKCT_GUI_DIRECTION_VERTICAL) {
    fputs(dkct_gui_out_kw[70], psrc->fipo);
  } else {
    fputs(dkct_gui_out_kw[71], psrc->fipo);
  }
  fputs(na, psrc->fipo);
  fputs(dkct_gui_out_kw[55], psrc->fipo);
  fputs(nb, psrc->fipo);
  fputs(dkct_gui_out_kw[55], psrc->fipo);
  sprintf(bu, "%d", co->sash);
  fputs(bu, psrc->fipo);
  fputs(dkct_gui_out_kw[24], psrc->fipo);
  fputs(dkct_gui_out_kw[0], psrc->fipo);
  fputs(dkct_gui_out_kw[8], psrc->fipo);
  fputs(dkct_gui_out_kw[64], psrc->fipo);
  if(co->minPaneSize > 0) {
    fputs(dkct_gui_out_kw[8], psrc->fipo);
    fputs(nc, psrc->fipo);
    fputs(dkct_gui_out_kw[72], psrc->fipo);
    sprintf(bu, "%d", co->minPaneSize);
    fputs(bu, psrc->fipo);
    fputs(dkct_gui_out_kw[24], psrc->fipo);
    fputs(dkct_gui_out_kw[0], psrc->fipo);
  }
}



/**	Finish setup of current element after setting up all children.
	@param	co	Current object.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_finish_current_element(
  DKCT_GUI_ELEMENT	*co,
  DKCT_SRC		*psrc,
  DKCT_GUI		*gui
)
{
  

#line 9270 "dkct-gui.ctr"
  /*
  	Class-dependant finish.
  */
  switch(co->cln) {
    case 10:	/* standard dialog button sizer */
    case 38:	/* toolbar */
    {	

#line 9277 "dkct-gui.ctr"
      /*
	Call ->Realize() for the standard diaglog button sizer.
      */
      fputs(dkct_gui_out_kw[8], psrc->fipo);
      fputs(co->name, psrc->fipo);
      fputs(dkct_gui_out_kw[80], psrc->fipo);
    } break;
    case 14: {	

#line 9285 "dkct-gui.ctr"
      /*
	Set wxSplitterWindow children and sash.
      */
      dkct_gui_finish_splitter_window(co, psrc, gui);
    } break;
  }
  /*
	Attribute-dependant finish.
  */
  if(co->text) {
    switch(co->cln) {
      case -1: {
        fputs(dkct_gui_out_kw[8], psrc->fipo);
        if(co->name) {
          fputs(co->name, psrc->fipo);
          fputs(dkct_gui_out_kw[31], psrc->fipo);
        }
        fputs(dkct_gui_out_kw[210], psrc->fipo);
        fputs(co->text, psrc->fipo);
        fputs(dkct_gui_out_kw[24], psrc->fipo);
        fputs(dkct_gui_out_kw[0], psrc->fipo);
      } break;
    }
  }
  if(co->tipText) {			

#line 9310 "dkct-gui.ctr"
    switch(co->cln) {
      case 36:	/* wxMenu */
      case 37:	/* wxMenuItem */
      case 40:	/* $wxToolBarTool */
      {
        /* Tip text already used. */
      } break;
      default: {			

#line 9318 "dkct-gui.ctr"
	fputs(dkct_gui_out_kw[8], psrc->fipo);
	if(co->name) {
	  fputs(co->name, psrc->fipo);
	  fputs(dkct_gui_out_kw[31], psrc->fipo);
	}
	fputs(dkct_gui_out_kw[190], psrc->fipo);
	fputs(co->tipText, psrc->fipo);
	fputs(dkct_gui_out_kw[24], psrc->fipo);
	fputs(dkct_gui_out_kw[0], psrc->fipo);
      } break;
    }
  }
  if(co->icon) {
    if((co->parent) || (co->number)) {
      /* Warning: Icon only for root level windows. */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_WARNING, 55);
    }
    fputs(dkct_gui_out_kw[8], psrc->fipo);
    if(co->name) {
      fputs(co->name, psrc->fipo);
      fputs(dkct_gui_out_kw[31], psrc->fipo);
    }
    fputs(dkct_gui_out_kw[195], psrc->fipo);
    fputs(co->icon, psrc->fipo);
    fputs(dkct_gui_out_kw[24], psrc->fipo);
    fputs(dkct_gui_out_kw[0], psrc->fipo);
  }
  if(co->validator) {
    switch(co->cln) {
      case -1: {
        fputs(dkct_gui_out_kw[8], psrc->fipo);
        if(co->name) {
          fputs(co->name, psrc->fipo);
          fputs(dkct_gui_out_kw[31], psrc->fipo);
        }
        fputs(dkct_gui_out_kw[211], psrc->fipo);
        fputs(co->validator, psrc->fipo);
        fputs(dkct_gui_out_kw[24], psrc->fipo);
        fputs(dkct_gui_out_kw[0], psrc->fipo);
      } break;
    }
  }
  if((co->sizex > 0) && (co->sizey > 0)) {
    switch(co->cln) {
      case -1: {
        fputs(dkct_gui_out_kw[8], psrc->fipo);
        if(co->name) {
          fputs(co->name, psrc->fipo);
          fputs(dkct_gui_out_kw[31], psrc->fipo);
        }
        fputs(dkct_gui_out_kw[212], psrc->fipo);
	dkct_gui_write_size(psrc, co->sizex, co->sizey, 0, co);
        fputs(dkct_gui_out_kw[24], psrc->fipo);
        fputs(dkct_gui_out_kw[0], psrc->fipo);
      } break;
    }
  }
  

#line 9376 "dkct-gui.ctr"
}



#if 0
/**	Add item to toolbar.
	This function is not longer needed as the
	AddTool() method is used as the constructor
	for wxToolBarToolBase.
	@param	co	Item to add.
	@param	dp	Toolbar to add to.
	@param	psrc	Source structure.
*/
static
void
dkct_gui_add_tool_bar_item(
  DKCT_GUI_ELEMENT	*co,
  DKCT_GUI_ELEMENT	*dp,
  DKCT_SRC		*psrc
)
{
}
#endif



/**	Construct all members and add them.
	@param	psrc	Source structure.
	@param	gui	GUI description.
*/
static
void
dkct_gui_write_members(DKCT_SRC *psrc, DKCT_GUI *gui)
{
  DKCT_GUI_ELEMENT		*co;		/* Current object. */
  DKCT_GUI_ELEMENT		*dp;		/* Direct parent. */
  DKCT_GUI_ELEMENT		*pw;		/* Parent window. */
  DKCT_GUI_ELEMENT		*ne;		/* Next element. */
  char const			*fnptr = NULL;	/* File to use for debug output. */
  int				 pprost;	/* Parent output state. */
  int				 pcln;		/* Parent class name. */
  

#line 9418 "dkct-gui.ctr"
  fnptr = dkct_tr_get_kw8(((psrc->dkcto).deb == 2) ? 28 : 29);
  co = gui->r_el;
  if(co->cln != 1) {
    psrc->lineno = 1UL;
    fputs(dkct_gui_out_kw[8], psrc->fipo);
    fputs(dkct_gui_out_kw[33], psrc->fipo);
    fputs(dkct_gui_out_kw[25], psrc->fipo);
    fputs(dkct_gui_out_kw[30], psrc->fipo);
    fputs(dkct_gui_out_kw[26], psrc->fipo);
    /* DEBUG OUTPUT */
    if((psrc->dkcto).deb) {
      

#line 9430 "dkct-gui.ctr"
      fputs(dkct_tr_get_kw8(24), psrc->fipo);
      if((psrc->dkcto).win) {
        fputs(dkct_tr_get_kw8(21), psrc->fipo);
        /* 16-bit begin */
        if((psrc->dkcto).deb != 2) {
          fputs(dkct_tr_get_kw8(30), psrc->fipo);
        }
        if((psrc->dkcto).ts) {
          if((psrc->dkcto).deb == 2) {
            fputs(dkct_tr_get_kw8(72), psrc->fipo);
          } else {
            fputs(dkct_tr_get_kw8(71), psrc->fipo);
          }
        }
        fputs(dkct_tr_get_kw8(61), psrc->fipo);
        dkct_tr_show_filename_and_lineno(psrc);
        fputs(dkct_tr_get_kw8(35), psrc->fipo);
        fputs(fnptr, psrc->fipo);
        fputs(dkct_tr_get_kw8(34), psrc->fipo);
        fputs(dkct_tr_get_kw8(61), psrc->fipo);
        fputs(dkct_tr_get_kw8(73), psrc->fipo);
	fputs(dkct_tr_get_kw8(75), psrc->fipo);
        fputs(dkct_tr_get_kw8(74), psrc->fipo);
        fputs(dkct_tr_get_kw8(35), psrc->fipo);
        fputs(fnptr, psrc->fipo);
        fputs(dkct_tr_get_kw8(34), psrc->fipo);
        if((psrc->dkcto).deb != 2) {
          fputs(dkct_tr_get_kw8(31), psrc->fipo);
        }
        /* 16-bit end */
        fputs(dkct_tr_get_kw8(22), psrc->fipo);
      }
      /* 8-bit begin */
      if((psrc->dkcto).deb != 2) {
        fputs(dkct_tr_get_kw8(30), psrc->fipo);
      }
      if((psrc->dkcto).ts) {
        if((psrc->dkcto).deb == 2) {
          fputs(dkct_tr_get_kw8(70), psrc->fipo);
        } else {
          fputs(dkct_tr_get_kw8(32), psrc->fipo);
        }
      }
      fputs(dkct_tr_get_kw8(33), psrc->fipo);
      dkct_tr_show_filename_and_lineno(psrc);
      fputs(dkct_tr_get_kw8(35), psrc->fipo);
      fputs(fnptr, psrc->fipo);
      fputs(dkct_tr_get_kw8(34), psrc->fipo);
      fputs(dkct_tr_get_kw8(33), psrc->fipo);
      fputs(dkct_tr_get_kw8(73), psrc->fipo);
      fputs(dkct_tr_get_kw8(75), psrc->fipo);
      fputs(dkct_tr_get_kw8(74), psrc->fipo);
      fputs(dkct_tr_get_kw8(35), psrc->fipo);
      fputs(fnptr, psrc->fipo);
      fputs(dkct_tr_get_kw8(34), psrc->fipo);
      if((psrc->dkcto).deb != 2) {
        fputs(dkct_tr_get_kw8(31), psrc->fipo);
      }
      /* 8-bit end */
      if((psrc->dkcto).win) {
        fputs(dkct_tr_get_kw8(23), psrc->fipo);
      }
      fputs(dkct_tr_get_kw8(25), psrc->fipo);
    }
    fputs(dkct_gui_out_kw[27], psrc->fipo);
    fputs(dkct_gui_out_kw[28], psrc->fipo);
    if((psrc->dkcto).deb) {
      

#line 9498 "dkct-gui.ctr"
      fputs(dkct_tr_get_kw8(24), psrc->fipo);
      if((psrc->dkcto).win) {
        fputs(dkct_tr_get_kw8(21), psrc->fipo);
        /* 16-bit begin */
        if((psrc->dkcto).deb != 2) {
          fputs(dkct_tr_get_kw8(30), psrc->fipo);
        }
        if((psrc->dkcto).ts) {
          if((psrc->dkcto).deb == 2) {
            fputs(dkct_tr_get_kw8(72), psrc->fipo);
          } else {
            fputs(dkct_tr_get_kw8(71), psrc->fipo);
          }
        }
        fputs(dkct_tr_get_kw8(61), psrc->fipo);
        dkct_tr_show_filename_and_lineno(psrc);
        fputs(dkct_tr_get_kw8(35), psrc->fipo);
        fputs(fnptr, psrc->fipo);
        fputs(dkct_tr_get_kw8(34), psrc->fipo);
        fputs(dkct_tr_get_kw8(61), psrc->fipo);
        fputs(dkct_tr_get_kw8(76), psrc->fipo);
	fputs(dkct_tr_get_kw8(75), psrc->fipo);
        fputs(dkct_tr_get_kw8(74), psrc->fipo);
        fputs(dkct_tr_get_kw8(35), psrc->fipo);
        fputs(fnptr, psrc->fipo);
        fputs(dkct_tr_get_kw8(34), psrc->fipo);
        if((psrc->dkcto).deb != 2) {
          fputs(dkct_tr_get_kw8(31), psrc->fipo);
        }
        /* 16-bit end */
        fputs(dkct_tr_get_kw8(22), psrc->fipo);
      }
      /* 8-bit begin */
      if((psrc->dkcto).deb != 2) {
        fputs(dkct_tr_get_kw8(30), psrc->fipo);
      }
      if((psrc->dkcto).ts) {
        if((psrc->dkcto).deb == 2) {
          fputs(dkct_tr_get_kw8(70), psrc->fipo);
        } else {
          fputs(dkct_tr_get_kw8(32), psrc->fipo);
        }
      }
      fputs(dkct_tr_get_kw8(33), psrc->fipo);
      dkct_tr_show_filename_and_lineno(psrc);
      fputs(dkct_tr_get_kw8(35), psrc->fipo);
      fputs(fnptr, psrc->fipo);
      fputs(dkct_tr_get_kw8(34), psrc->fipo);
      fputs(dkct_tr_get_kw8(33), psrc->fipo);
      fputs(dkct_tr_get_kw8(76), psrc->fipo);
      fputs(dkct_tr_get_kw8(75), psrc->fipo);
      fputs(dkct_tr_get_kw8(74), psrc->fipo);
      fputs(dkct_tr_get_kw8(35), psrc->fipo);
      fputs(fnptr, psrc->fipo);
      fputs(dkct_tr_get_kw8(34), psrc->fipo);
      if((psrc->dkcto).deb != 2) {
        fputs(dkct_tr_get_kw8(31), psrc->fipo);
      }
      /* 8-bit end */
      if((psrc->dkcto).win) {
        fputs(dkct_tr_get_kw8(23), psrc->fipo);
      }
      fputs(dkct_tr_get_kw8(25), psrc->fipo);
    }
  }
  dk3sto_it_reset(co->i_contents);
  while(co) {	

#line 9565 "dkct-gui.ctr"
    psrc->lineno = ((co->lndef) > 0UL) ? (co->lndef) : (co->lndecl);
    dk3app_set_source_line(psrc->app, psrc->lineno);
    dp = pw = (DKCT_GUI_ELEMENT *)(co->parent);
    pw = dkct_gui_find_real_parent(pw);
    switch(co->prost) {
      case DKCT_GUI_PROCESSING_STATE_START: {
        if(co->pseudoobj) {
	  /*
	  	Pseudo object (stretch spacer, separator...)
	  */
	  dkct_gui_add_pseudo_object(co, dp, pw, psrc, gui);
	  co = (DKCT_GUI_ELEMENT *)(co->parent);
	} else {
	  /*
	  	Real object.
	  */
          if((co->parent) && (co->name)) {
	    if(dkct_gui_need_element_constructor(co)) {
	      

#line 9584 "dkct-gui.ctr"
	      dkct_gui_write_element_constructor(co, dp, pw, psrc, gui);
	    }
	  }
          dk3sto_it_reset(co->i_contents);
	  if(co->menubar) {	

#line 9589 "dkct-gui.ctr"
	    fputs(dkct_gui_out_kw[19], psrc->fipo);
	    co->prost = DKCT_GUI_PROCESSING_STATE_MENU;
	    co = (DKCT_GUI_ELEMENT *)(co->menubar);
	  } else {
	    if(co->toolbar) {			

#line 9594 "dkct-gui.ctr"
	      fputs(dkct_gui_out_kw[20], psrc->fipo);
	      co->prost = DKCT_GUI_PROCESSING_STATE_TOOL;
	      co = (DKCT_GUI_ELEMENT *)(co->toolbar);
	    } else {				

#line 9598 "dkct-gui.ctr"
	      co->prost = DKCT_GUI_PROCESSING_STATE_CONTENTS;
	    }
	  }
	}
      } break;
      case DKCT_GUI_PROCESSING_STATE_MENU: {
        /*
		Finish menu processing.
	*/
	fputs(dkct_gui_out_kw[22], psrc->fipo);
	if(co->toolbar) {			

#line 9609 "dkct-gui.ctr"
	  fputs(dkct_gui_out_kw[20], psrc->fipo);
	  co->prost = DKCT_GUI_PROCESSING_STATE_TOOL;
	  co = (DKCT_GUI_ELEMENT *)(co->toolbar);
	} else {				

#line 9613 "dkct-gui.ctr"
	  co->prost = DKCT_GUI_PROCESSING_STATE_CONTENTS;
	}
      } break;
      case DKCT_GUI_PROCESSING_STATE_TOOL: {
        /*
		Finish tool bar processing.
	*/
	fputs(dkct_gui_out_kw[22], psrc->fipo);
	co->prost = DKCT_GUI_PROCESSING_STATE_CONTENTS;	

#line 9622 "dkct-gui.ctr"
      } break;
      case DKCT_GUI_PROCESSING_STATE_CONTENTS: {	

#line 9624 "dkct-gui.ctr"
        ne = (DKCT_GUI_ELEMENT *)dk3sto_it_next(co->i_contents);	

#line 9625 "dkct-gui.ctr"
	if(ne) {		

#line 9626 "dkct-gui.ctr"
	  co = ne;
	} else {		

#line 9628 "dkct-gui.ctr"
	  co->prost = DKCT_GUI_PROCESSING_STATE_DONE;
	  /*
	  	Finish current element.
	  */
	  dkct_gui_finish_current_element(co, psrc, gui);
	  /*
	  	Add current element to parent.
	  */
          if(dkct_gui_is_sizer(co)) {
            if(dkct_gui_is_sizer((DKCT_GUI_ELEMENT *)(co->parent))) {
              dkct_gui_add_object_to_sizer(
	        co, (DKCT_GUI_ELEMENT *)(co->parent), psrc, gui
	      );
            } else {
              /*
      	        parent->SetSizer(object);
	        SetSizer(object);
              */
              dkct_gui_set_parents_sizer(
	        co, (DKCT_GUI_ELEMENT *)(co->parent), psrc, gui
	      );
            }
          } else {
            if(dkct_gui_is_sizer((DKCT_GUI_ELEMENT *)(co->parent))) {
              dkct_gui_add_object_to_sizer(
	        co, (DKCT_GUI_ELEMENT *)(co->parent), psrc, gui
	      );
            } else {
              /*
	      	Handle special combinations of parent/child classes.
	      */
              pprost = DKCT_GUI_PROCESSING_STATE_CONTENTS;
              if(dp) { pprost = dp->prost; }
              switch(pprost) {
	        /*
			Add menu bar to root level window.
		*/
                case DKCT_GUI_PROCESSING_STATE_MENU: {
	          fputs(dkct_gui_out_kw[8], psrc->fipo);
	          if(dp->name) {
	            fputs(dp->name, psrc->fipo);
	            fputs(dkct_gui_out_kw[31], psrc->fipo);
	          }
	          fputs(dkct_gui_out_kw[57], psrc->fipo);
	          fputs(co->name, psrc->fipo);
	          fputs(dkct_gui_out_kw[24], psrc->fipo);
	          fputs(dkct_gui_out_kw[0], psrc->fipo);
	        } break;
	        case DKCT_GUI_PROCESSING_STATE_TOOL: {
		  /*
		  	Add too lbar to root level window.
		  */
	          fputs(dkct_gui_out_kw[8], psrc->fipo);
	          if(dp->name) {
	            fputs(dp->name, psrc->fipo);
	            fputs(dkct_gui_out_kw[31], psrc->fipo);
	          }
	          fputs(dkct_gui_out_kw[58], psrc->fipo);
	          fputs(co->name, psrc->fipo);
	          fputs(dkct_gui_out_kw[24], psrc->fipo);
	          fputs(dkct_gui_out_kw[0], psrc->fipo);
	        } break;
	        default: {
		  pcln = -1;
                  if(dp) { pcln = dp->cln; }
                  switch(pcln) {
                    case 35: {	/* Appending to a menu bar. */
	              switch(co->cln) {
	                case 36: {
		          /*
		  	        Add menu to menu bar.
		          */
		          if((dp->name) && (co->name)) {
		            fputs(dkct_gui_out_kw[8], psrc->fipo);
		            fputs(dp->name, psrc->fipo);
		            fputs(dkct_gui_out_kw[184], psrc->fipo);
		            fputs(co->name, psrc->fipo);
		            fputs(dkct_gui_out_kw[55], psrc->fipo);
		            if(co->text) {
		              fputs(co->text, psrc->fipo);
		            } else {
		              fputs(dkct_gui_out_kw[73], psrc->fipo);
		            }
		            fputs(dkct_gui_out_kw[24], psrc->fipo);
		            fputs(dkct_gui_out_kw[0], psrc->fipo);
		          }
		        } break;
		        default: {
		          /* ERROR: Illegal child class! */
			  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 81);
		        } break;
	              }
	            } break;
	            case 36: {	/* Appending to a menu. */
	              switch(co->cln) {
	                case 37: {
		          /*
		  	        Add menu item to menu.
		          */
#if 0
		          if((dp->name) && (co->name)) {
		            fputs(dkct_gui_out_kw[8], psrc->fipo);
		            fputs(dp->name, psrc->fipo);
		            fputs(dkct_gui_out_kw[184], psrc->fipo);
		            fputs(co->name, psrc->fipo);
		            fputs(dkct_gui_out_kw[24], psrc->fipo);
		            fputs(dkct_gui_out_kw[0], psrc->fipo);
		          }
#endif
		        } break;
		        case 36: {
		          /*
		 	        Add sub-menu to menu.
		          */
		          if((dp->name) && (co->name)) {
		            fputs(dkct_gui_out_kw[8], psrc->fipo);
		            fputs(dp->name, psrc->fipo);
		            fputs(dkct_gui_out_kw[184], psrc->fipo);
		            dkct_gui_write_idname(co, psrc);
		            fputs(dkct_gui_out_kw[55], psrc->fipo);
		            if(co->text) {
		              fputs(co->text, psrc->fipo);
		            } else {
		              fputs(dkct_gui_out_kw[73], psrc->fipo);
		            }
		            fputs(dkct_gui_out_kw[55], psrc->fipo);
		            fputs(co->name, psrc->fipo);
		            if(co->tipText) {
		              fputs(dkct_gui_out_kw[55], psrc->fipo);
		              fputs(co->tipText, psrc->fipo);
		            }
		            fputs(dkct_gui_out_kw[24], psrc->fipo);
		            fputs(dkct_gui_out_kw[0], psrc->fipo);
		          }
		        } break;
		        default: {
		          /* ERROR: Illegal child class! */
			  dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 81);
		        } break;
	              }
	            } break;
	            case 38: {	/* Appending to a tool bar. */
	              switch(co->cln) {
	                case 40:	/* wxToolBarToolBase */
		        {
		        } break;
		        default: {	/* Any control */
			  if(co->name) {
			    if(dp->name) {
			      fputs(dkct_gui_out_kw[8], psrc->fipo);
			      fputs(dp->name, psrc->fipo);
			      fputs(dkct_gui_out_kw[187], psrc->fipo);
			      fputs(co->name, psrc->fipo);
			      fputs(dkct_gui_out_kw[24], psrc->fipo);
			      fputs(dkct_gui_out_kw[0], psrc->fipo);
			    }
			  }
		        } break;
	              }
	            } break;
		    case 14: {	/* wxSplitterWindow */
		      /*
			Do nothing, elements are added when finishing
			the splitter window.
		      */
		    } break;
		    default: {
		      if((co->number) && (co->parent)) {
		        char const *pname;
		        char const *oname;
		        /* ERROR: Don't know how to add */
		        pname = oname = dkct_gui_out_kw[197];
		        if(co->name) oname = co->name;
		        if(dp) { if(dp->name) pname = dp->name; }
		        dkct_to_log_5(
		          gui->psrc, 1, DK3_LL_ERROR, 84, 85, 86, oname, pname
		        );
		      }
		    } break;
                  }
	        } break;
              }
            }
          }
	  co = (DKCT_GUI_ELEMENT *)(co->parent);
	}
      } break;
      default: {
        co = (DKCT_GUI_ELEMENT *)(co->parent);
      } break;
    }
  } 

#line 9820 "dkct-gui.ctr"
}



/**	Write top level class constructor.
	@param	psrc	Source structure.
*/
void
dkct_gui_write_constructor(DKCT_SRC *psrc)
{
  char			bu[256];	/* Buffer for numeric values. */
  DKCT_GUI		*gui;		/* GUI description. */
  DKCT_GUI_ELEMENT	*el;		/* Current object. */
  DKCT_GUI_ELEMENT	*szmain;	/* Main sizer. */
  int			 szfound = 0;	/* Flag: Sizer found. */
  int			 w = 0;		/* Object width. */
  int			 h = 0;		/* Object height. */
  if(psrc->gui) {
    gui = (DKCT_GUI *)(psrc->gui);
    /*
  	  Flag: GUI not ok.
    */
    fputs(dkct_gui_out_kw[8], psrc->fipo);
    fputs(dkct_gui_out_kw[9], psrc->fipo);
    if(dkct_gui_need_contents_panel(gui)) {
      fputs(dkct_gui_out_kw[8], psrc->fipo);
      fputs(dkct_gui_out_kw[18], psrc->fipo);
    }
    /*
    	Initialize all member variables to NULL.
    */
    dk3sto_it_reset(gui->i_el_by_num);
    while((el = (DKCT_GUI_ELEMENT *)dk3sto_it_next(gui->i_el_by_num)) != NULL) {
      if(el->pseudoobj == 0) {
        if(dkct_gui_need_element_constructor(el)) {
          if((el->name) && (el->cname)) {
            fputs(dkct_gui_out_kw[8], psrc->fipo);
	    fputs(el->name, psrc->fipo);
	    fputs(dkct_gui_out_kw[14], psrc->fipo);
          }
	}
      }
    }
    /*
    	Construct member variables.
    */
    dkct_gui_write_members(psrc, gui);
    /*
  	  Flag: GUI ok.
    */
    el = gui->r_el;
    if(el) {				

#line 9872 "dkct-gui.ctr"
      w = el->sizex; h = el->sizey;	

#line 9873 "dkct-gui.ctr"
    }
    fputs(dkct_gui_out_kw[8], psrc->fipo);
    fputs(dkct_gui_out_kw[10], psrc->fipo);
    /*
    	End goto label.
    */
    fputs(dkct_gui_out_kw[8], psrc->fipo);
    fputs(dkct_gui_out_kw[11], psrc->fipo);
    fputs(dkct_gui_out_kw[12], psrc->fipo);
    fputs(dkct_gui_out_kw[0], psrc->fipo);
    if(el) {
      if(el->stbsz > 0) {
        /*
		if wxUSE_STATUSBAR
		if(dkctGUILayoutOK) {
		  CreateStatusBar(2);
		  SetStatusText(text);
		}
		endif
	*/
	fputs(dkct_gui_out_kw[21], psrc->fipo);
	fputs(dkct_gui_out_kw[59], psrc->fipo);
	sprintf(bu, "%d", el->stbsz);
	fputs(dkct_gui_out_kw[90], psrc->fipo);
	fputs(bu, psrc->fipo);
	fputs(dkct_gui_out_kw[24], psrc->fipo);
	fputs(dkct_gui_out_kw[0], psrc->fipo);
	if(el->stbText) {
	  fputs(dkct_gui_out_kw[91], psrc->fipo);
	  fputs(el->stbText, psrc->fipo);
	  fputs(dkct_gui_out_kw[24], psrc->fipo);
	  fputs(dkct_gui_out_kw[0], psrc->fipo);
	}
	fputs(dkct_gui_out_kw[64], psrc->fipo);
	fputs(dkct_gui_out_kw[22], psrc->fipo);
      }
    }
#if 0
    fputs(dkct_gui_out_kw[59], psrc->fipo);
    if((w > 0) && (h > 0)) {
      sprintf(bu, "%d, %d", w, h);
      fputs(dkct_gui_out_kw[89], psrc->fipo);
      fputs(bu, psrc->fipo);
      fputs(dkct_gui_out_kw[24], psrc->fipo);
      fputs(dkct_gui_out_kw[0], psrc->fipo);
    } else {
      if(dkct_gui_need_contents_panel(gui)) {
        fputs(dkct_gui_out_kw[61], psrc->fipo);
      } else {
        fputs(dkct_gui_out_kw[60], psrc->fipo);
      }
    }
    fputs(dkct_gui_out_kw[62], psrc->fipo);
    fputs(dkct_gui_out_kw[64], psrc->fipo);
#endif
    fputs(dkct_gui_out_kw[59], psrc->fipo);
    if((w > 0) && (h > 0)) {
      sprintf(bu, "%d, %d", w, h);
      fputs(dkct_gui_out_kw[89], psrc->fipo);
      fputs(bu, psrc->fipo);
      fputs(dkct_gui_out_kw[24], psrc->fipo);
      fputs(dkct_gui_out_kw[0], psrc->fipo);
      fputs(dkct_gui_out_kw[62], psrc->fipo);
    } else {
      dk3sto_it_reset(el->i_contents);
      szmain = (DKCT_GUI_ELEMENT *)dk3sto_it_next(el->i_contents);
      if(szmain) {
        switch(szmain->cln) {
	  case 5: case 6: case 7: case 8: case 9: case 10: {
	    if(szmain->name) {
	      fputs(dkct_gui_out_kw[2], psrc->fipo);
	      fputs(szmain->name, psrc->fipo);
	      fputs(dkct_gui_out_kw[63], psrc->fipo);
	    }
	  } break;
	}
      }
    }
    szmain = NULL;
    dk3sto_it_reset(el->i_contents);
    szmain = (DKCT_GUI_ELEMENT *)dk3sto_it_next(el->i_contents);
    if(szmain) {
      if(szmain->name) {
        switch(szmain->cln) {
	  case 5: case 6: case 7: case 8: case 9: case 10: {
	    fputs(dkct_gui_out_kw[2], psrc->fipo);
	    fputs(szmain->name, psrc->fipo);
	    fputs(dkct_gui_out_kw[60], psrc->fipo);
	    szfound = 1;
	  } break;
	}
      }
    }
    fputs(dkct_gui_out_kw[64], psrc->fipo);
    if(!(szfound)) {
      (gui->psrc)->ec = DK3_ERROR_SYNTAX;
      /* ERROR: No sizer found! */
      dkct_to_log_1(gui->psrc, 1, DK3_LL_ERROR, 97);
    }
  }
}



/* vim: set ai sw=2 : */

