#include <stdio.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#include "dk3confd.h"
#endif

#if HAVE_WINSOCK2_H
#include <winsock2.h>
#endif
#if HAVE_WS2TCPIP_H
#include <ws2tcpip.h>
#endif
#if HAVE_WINDOWS_H
#include <windows.h>
#endif
#if HAVE_WINBASE_H
#include <winbase.h>
#endif
#if HAVE_WINREG_H
#include <winreg.h>
#endif
#if HAVE_WINCON_H
#include <wincon.h>
#endif
#if HAVE_STDIO_H
#include <stdio.h>
#endif
#if HAVE_ERR_H
#include <err.h>
#endif
#if HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if HAVE_STDDEF_H
#include <stddef.h>
#endif
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#if HAVE_PROCESS_H
#include <process.h>
#endif
#if HAVE_LIMITS_H
#include <limits.h>
#endif
#if HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif
#if HAVE_SYS_SYSCTL_H
#include <sys/sysctl.h>
#endif
#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#if HAVE_SYS_STATVFS_H
#include <sys/statvfs.h>
#endif
#if HAVE_SYS_STROPTS_H
#include <sys/stropts.h>
#endif
#if HAVE_SYS_FILE_H
#include <sys/file.h>
#endif
#if HAVE_SYS_UIO_H
#include <sys/uio.h>
#endif
#if HAVE_SYS_UN_H
#include <sys/un.h>
#endif
#if HAVE_SYS_SUNDDI_H
#include <sys/sunddi.h>
#endif
#if HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif
#if HAVE_SYS_SYSTEMINFO_H
#include <sys/systeminfo.h>
#endif
#if HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if HAVE_TIME_H
#include <time.h>
#else
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#endif
#endif
#if HAVE_ERRNO_H
#include <errno.h>
#endif
#if HAVE_ALLOC_H
#include <alloc.h>
#endif
#if HAVE_MALLOC_H
#include <malloc.h>
#endif
#if HAVE_CTYPE_H
#include <ctype.h>
#endif
#if HAVE_STRING_H
#include <string.h>
#endif
#if HAVE_STRINGS_H
#include <strings.h>
#endif
#if HAVE_WCHAR_H
#include <wchar.h>
#endif
#if HAVE_STROPTS_H
#include <stropts.h>
#endif
#if HAVE_IO_H
#include <io.h>
#endif
#if HAVE_DOS_H
#include <dos.h>
#endif
#if HAVE_FCNTL_H
#include <fcntl.h>
#endif
#if HAVE_DIR_H
#include <dir.h>
#endif
#if HAVE_DIRENT_H
#include <dirent.h>
#endif
#if HAVE_DIRECT_H
#include <direct.h>
#endif
#if HAVE_SYSRES_H
#include <sysres.h>
#endif
#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#if HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
#if HAVE_NETDB_H
#include <netdb.h>
#endif
#if HAVE_GRP_H
#include <grp.h>
#endif
#if HAVE_PWD_H
#include <pwd.h>
#endif
#if HAVE_MATH_H
#include <math.h>
#endif
#if HAVE_FLOAT_H
#include <float.h>
#endif
#if HAVE_FENV_H
#include <fenv.h>
#endif
#if HAVE_SIGNAL_H
#include <signal.h>
#endif
#if HAVE_SYSLOG_H
#include <syslog.h>
#endif
#if HAVE_CONIO_H
#include <conio.h>
#endif
#if HAVE_STDARG_H
#include <stdarg.h>
#else
#if HAVE_VARARG_H
#include <vararg.h>
#else
#if HAVE_VARARGS_H
#include <varargs.h>
#else
#endif
#endif
#endif
#if HAVE_VARARG_H
#include <vararg.h>
#endif
#if HAVE_STDINT_H
#include <stdint.h>
#endif
#if HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#if HAVE_TERMIOS_H
#include <termios.h>
#endif
#if HAVE_SHADOW_H
#include <shadow.h>
#endif
#if HAVE_LOCALE_H
#include <locale.h>
#endif
#if HAVE_SYS_TERMIOS_H
#include <sys/termios.h>
#endif
#if HAVE_SYS_TTOLD_H
#include <sys/ttold.h>
#endif
#if HAVE_SETJMP_H
#include <setjmp.h>
#endif
#if HAVE_PTHREAD_H
#include <pthread.h>
#endif
#if HAVE_ZLIB_H
#include <zlib.h>
#endif
#if HAVE_BZLIB_H
#include <bzlib.h>
#endif

#ifndef MPL
#ifdef MAXPATHLEN
/**	Maximum path length.
*/
#define MPL MAXPATHLEN
#else
#ifdef MAX_PATH
/**	Maximum path length.
*/
#define MPL MAX_PATH
#else
#ifdef PATH_MAX
/**	Maximum path length.
*/
#define MPL PATH_MAX
#else
/**	Maximum path length.
*/
#define MPL 1024
#endif
#endif
#endif
#endif

int main(int argc, char *argv[])
{
  printf("/**\t@file dk3conf.h\tConfiguration for DK3 libraries.\n\tFeatures: Include files, functions, sizes,\n\tand endianness.\n*/\n\n");
  printf("#ifndef DK3_CONF_H_INCLUDED\n");
  printf("/** Avoid multiple inclusions. */\n");
  printf("#define DK3_CONF_H_INCLUDED 1\n\n");
  printf("#ifndef DK3_ON_WINDOWS\n");
  printf("#if defined(WIN32) || defined(_WIN32) || defined(WIN64) || defined(_WIN64)\n");
  printf("/** On a Windows system. */\n");
  printf("#define DK3_ON_WINDOWS\t1\n");
  printf("#else\n");
  printf("/** Not on a Windows system. */\n");
  printf("#define DK3_ON_WINDOWS\t0\n");
  printf("#endif\n");
  printf("#endif\n/** ifndef DK3_ON_WINDOWS */\n");
  printf("\n#if DK3_ON_WINDOWS\n");
  printf("\n#ifndef DK3_HAVE_ACOSH\n");
  printf("/**\tDK3 version of HAVE_ACOSH.\n*/\n");
  printf("#define DK3_HAVE_ACOSH 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ACOSHL\n");
  printf("/**\tDK3 version of HAVE_ACOSHL.\n*/\n");
  printf("#define DK3_HAVE_ACOSHL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ACOSL\n");
  printf("/**\tDK3 version of HAVE_ACOSL.\n*/\n");
  printf("#define DK3_HAVE_ACOSL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ALLOC_H\n");
  printf("/**\tDK3 version of HAVE_ALLOC_H.\n*/\n");
  printf("#define DK3_HAVE_ALLOC_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ARPA_INET_H\n");
  printf("/**\tDK3 version of HAVE_ARPA_INET_H.\n*/\n");
  printf("#define DK3_HAVE_ARPA_INET_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ASINH\n");
  printf("/**\tDK3 version of HAVE_ASINH.\n*/\n");
  printf("#define DK3_HAVE_ASINH 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ASINHL\n");
  printf("/**\tDK3 version of HAVE_ASINHL.\n*/\n");
  printf("#define DK3_HAVE_ASINHL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ASINL\n");
  printf("/**\tDK3 version of HAVE_ASINL.\n*/\n");
  printf("#define DK3_HAVE_ASINL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ATAN2\n");
  printf("/**\tDK3 version of HAVE_ATAN2.\n*/\n");
  printf("#define DK3_HAVE_ATAN2 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ATAN2L\n");
  printf("/**\tDK3 version of HAVE_ATAN2L.\n*/\n");
  printf("#define DK3_HAVE_ATAN2L 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ATANH\n");
  printf("/**\tDK3 version of HAVE_ATANH.\n*/\n");
  printf("#define DK3_HAVE_ATANH 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ATANHL\n");
  printf("/**\tDK3 version of HAVE_ATANHL.\n*/\n");
  printf("#define DK3_HAVE_ATANHL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ATANL\n");
  printf("/**\tDK3 version of HAVE_ATANL.\n*/\n");
  printf("#define DK3_HAVE_ATANL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_BACKSLASH\n");
  printf("/**\tDK3 version of HAVE_BACKSLASH.\n*/\n");
  printf("#define DK3_HAVE_BACKSLASH 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_BCMP\n");
  printf("/**\tDK3 version of HAVE_BCMP.\n*/\n");
  printf("#define DK3_HAVE_BCMP 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_BCOPY\n");
  printf("/**\tDK3 version of HAVE_BCOPY.\n*/\n");
  printf("#define DK3_HAVE_BCOPY 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_BZERO\n");
  printf("/**\tDK3 version of HAVE_BZERO.\n*/\n");
  printf("#define DK3_HAVE_BZERO 0\n");
  printf("#endif\n");
/* WARNING: HAVE_BZLIB_H not defined for Windows! */
  printf("\n#ifndef DK3_HAVE_CEIL\n");
  printf("/**\tDK3 version of HAVE_CEIL.\n*/\n");
  printf("#define DK3_HAVE_CEIL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CEILL\n");
  printf("/**\tDK3 version of HAVE_CEILL.\n*/\n");
  printf("#define DK3_HAVE_CEILL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CHDIR\n");
  printf("/**\tDK3 version of HAVE_CHDIR.\n*/\n");
  printf("#define DK3_HAVE_CHDIR 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CHMOD\n");
  printf("/**\tDK3 version of HAVE_CHMOD.\n*/\n");
  printf("#define DK3_HAVE_CHMOD 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CHOWN\n");
  printf("/**\tDK3 version of HAVE_CHOWN.\n*/\n");
  printf("#define DK3_HAVE_CHOWN 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CLOSEDIR\n");
  printf("/**\tDK3 version of HAVE_CLOSEDIR.\n*/\n");
  printf("#define DK3_HAVE_CLOSEDIR 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CONIO_H\n");
  printf("/**\tDK3 version of HAVE_CONIO_H.\n*/\n");
  printf("#define DK3_HAVE_CONIO_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CONST\n");
  printf("/**\tDK3 version of HAVE_CONST.\n*/\n");
  printf("#define DK3_HAVE_CONST 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_COSHL\n");
  printf("/**\tDK3 version of HAVE_COSHL.\n*/\n");
  printf("#define DK3_HAVE_COSHL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_COSL\n");
  printf("/**\tDK3 version of HAVE_COSL.\n*/\n");
  printf("#define DK3_HAVE_COSL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CTYPE_H\n");
  printf("/**\tDK3 version of HAVE_CTYPE_H.\n*/\n");
  printf("#define DK3_HAVE_CTYPE_H 1\n");
  printf("#endif\n");
/* WARNING: HAVE_DB_CURSOR_C_GET not defined for Windows! */
/* WARNING: HAVE_DB_H not defined for Windows! */
  printf("\n#ifndef DK3_HAVE_DEV_RANDOM\n");
  printf("/**\tDK3 version of HAVE_DEV_RANDOM.\n*/\n");
  printf("#define DK3_HAVE_DEV_RANDOM 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DEV_URANDOM\n");
  printf("/**\tDK3 version of HAVE_DEV_URANDOM.\n*/\n");
  printf("#define DK3_HAVE_DEV_URANDOM 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DIRECT_H\n");
  printf("/**\tDK3 version of HAVE_DIRECT_H.\n*/\n");
  printf("#define DK3_HAVE_DIRECT_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DIRENT_H\n");
  printf("/**\tDK3 version of HAVE_DIRENT_H.\n*/\n");
  printf("#define DK3_HAVE_DIRENT_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DIR_H\n");
  printf("/**\tDK3 version of HAVE_DIR_H.\n*/\n");
  printf("#define DK3_HAVE_DIR_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DOS_H\n");
  printf("/**\tDK3 version of HAVE_DOS_H.\n*/\n");
  printf("#define DK3_HAVE_DOS_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ENDGRENT\n");
  printf("/**\tDK3 version of HAVE_ENDGRENT.\n*/\n");
  printf("#define DK3_HAVE_ENDGRENT 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ENDPWENT\n");
  printf("/**\tDK3 version of HAVE_ENDPWENT.\n*/\n");
  printf("#define DK3_HAVE_ENDPWENT 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ERRNO_H\n");
  printf("/**\tDK3 version of HAVE_ERRNO_H.\n*/\n");
  printf("#define DK3_HAVE_ERRNO_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ERR_H\n");
  printf("/**\tDK3 version of HAVE_ERR_H.\n*/\n");
  printf("#define DK3_HAVE_ERR_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_EXPL\n");
  printf("/**\tDK3 version of HAVE_EXPL.\n*/\n");
  printf("#define DK3_HAVE_EXPL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FABS\n");
  printf("/**\tDK3 version of HAVE_FABS.\n*/\n");
  printf("#define DK3_HAVE_FABS 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FABSL\n");
  printf("/**\tDK3 version of HAVE_FABSL.\n*/\n");
  printf("#define DK3_HAVE_FABSL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FCLOSE\n");
  printf("/**\tDK3 version of HAVE_FCLOSE.\n*/\n");
  printf("#define DK3_HAVE_FCLOSE 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FCNTL_H\n");
  printf("/**\tDK3 version of HAVE_FCNTL_H.\n*/\n");
  printf("#define DK3_HAVE_FCNTL_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FENV_H\n");
  printf("/**\tDK3 version of HAVE_FENV_H.\n*/\n");
  printf("#define DK3_HAVE_FENV_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FEOF\n");
  printf("/**\tDK3 version of HAVE_FEOF.\n*/\n");
  printf("#define DK3_HAVE_FEOF 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FERROR\n");
  printf("/**\tDK3 version of HAVE_FERROR.\n*/\n");
  printf("#define DK3_HAVE_FERROR 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FETESTEXCEPT\n");
  printf("/**\tDK3 version of HAVE_FETESTEXCEPT.\n*/\n");
  printf("#define DK3_HAVE_FETESTEXCEPT 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FFLUSH\n");
  printf("/**\tDK3 version of HAVE_FFLUSH.\n*/\n");
  printf("#define DK3_HAVE_FFLUSH 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FLOAT_H\n");
  printf("/**\tDK3 version of HAVE_FLOAT_H.\n*/\n");
  printf("#define DK3_HAVE_FLOAT_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FLOOR\n");
  printf("/**\tDK3 version of HAVE_FLOOR.\n*/\n");
  printf("#define DK3_HAVE_FLOOR 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FLOORL\n");
  printf("/**\tDK3 version of HAVE_FLOORL.\n*/\n");
  printf("#define DK3_HAVE_FLOORL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FNCASEINS\n");
  printf("/**\tDK3 version of HAVE_FNCASEINS.\n*/\n");
  printf("#define DK3_HAVE_FNCASEINS 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FOPEN\n");
  printf("/**\tDK3 version of HAVE_FOPEN.\n*/\n");
  printf("#define DK3_HAVE_FOPEN 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FOPEN64\n");
  printf("/**\tDK3 version of HAVE_FOPEN64.\n*/\n");
  printf("#define DK3_HAVE_FOPEN64 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FORK\n");
  printf("/**\tDK3 version of HAVE_FORK.\n*/\n");
  printf("#define DK3_HAVE_FORK 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FPCLASSIFY\n");
  printf("/**\tDK3 version of HAVE_FPCLASSIFY.\n*/\n");
  printf("#define DK3_HAVE_FPCLASSIFY 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FREAD\n");
  printf("/**\tDK3 version of HAVE_FREAD.\n*/\n");
  printf("#define DK3_HAVE_FREAD 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FREE\n");
  printf("/**\tDK3 version of HAVE_FREE.\n*/\n");
  printf("#define DK3_HAVE_FREE 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FWRITE\n");
  printf("/**\tDK3 version of HAVE_FWRITE.\n*/\n");
  printf("#define DK3_HAVE_FWRITE 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GDBM_H\n");
  printf("/**\tDK3 version of HAVE_GDBM_H.\n*/\n");
  printf("#define DK3_HAVE_GDBM_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETADDRINFO\n");
  printf("/**\tDK3 version of HAVE_GETADDRINFO.\n*/\n");
  printf("#define DK3_HAVE_GETADDRINFO 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETCWD\n");
  printf("/**\tDK3 version of HAVE_GETCWD.\n*/\n");
  printf("#define DK3_HAVE_GETCWD 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETENV\n");
  printf("/**\tDK3 version of HAVE_GETENV.\n*/\n");
  printf("#define DK3_HAVE_GETENV 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETEUID\n");
  printf("/**\tDK3 version of HAVE_GETEUID.\n*/\n");
  printf("#define DK3_HAVE_GETEUID 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETGRENT\n");
  printf("/**\tDK3 version of HAVE_GETGRENT.\n*/\n");
  printf("#define DK3_HAVE_GETGRENT 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETGRGID\n");
  printf("/**\tDK3 version of HAVE_GETGRGID.\n*/\n");
  printf("#define DK3_HAVE_GETGRGID 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETGRNAM\n");
  printf("/**\tDK3 version of HAVE_GETGRNAM.\n*/\n");
  printf("#define DK3_HAVE_GETGRNAM 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETHOSTBYNAME\n");
  printf("/**\tDK3 version of HAVE_GETHOSTBYNAME.\n*/\n");
  printf("#define DK3_HAVE_GETHOSTBYNAME 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETHOSTNAME\n");
  printf("/**\tDK3 version of HAVE_GETHOSTNAME.\n*/\n");
  printf("#define DK3_HAVE_GETHOSTNAME 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETPEERNAME\n");
  printf("/**\tDK3 version of HAVE_GETPEERNAME.\n*/\n");
  printf("#define DK3_HAVE_GETPEERNAME 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETPID\n");
  printf("/**\tDK3 version of HAVE_GETPID.\n*/\n");
  printf("#define DK3_HAVE_GETPID 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETPWENT\n");
  printf("/**\tDK3 version of HAVE_GETPWENT.\n*/\n");
  printf("#define DK3_HAVE_GETPWENT 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETPWNAM\n");
  printf("/**\tDK3 version of HAVE_GETPWNAM.\n*/\n");
  printf("#define DK3_HAVE_GETPWNAM 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETPWUID\n");
  printf("/**\tDK3 version of HAVE_GETPWUID.\n*/\n");
  printf("#define DK3_HAVE_GETPWUID 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETRLIMIT\n");
  printf("/**\tDK3 version of HAVE_GETRLIMIT.\n*/\n");
  printf("#define DK3_HAVE_GETRLIMIT 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETSOCKNAME\n");
  printf("/**\tDK3 version of HAVE_GETSOCKNAME.\n*/\n");
  printf("#define DK3_HAVE_GETSOCKNAME 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETUID\n");
  printf("/**\tDK3 version of HAVE_GETUID.\n*/\n");
  printf("#define DK3_HAVE_GETUID 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GRP_H\n");
  printf("/**\tDK3 version of HAVE_GRP_H.\n*/\n");
  printf("#define DK3_HAVE_GRP_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_HTONL\n");
  printf("/**\tDK3 version of HAVE_HTONL.\n*/\n");
  printf("#define DK3_HAVE_HTONL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_IEEE_754_DOUBLE\n");
  printf("/**\tDK3 version of HAVE_IEEE_754_DOUBLE.\n*/\n");
  printf("#define DK3_HAVE_IEEE_754_DOUBLE 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_IN6_ADDR\n");
  printf("/**\tDK3 version of HAVE_IN6_ADDR.\n*/\n");
  printf("#define DK3_HAVE_IN6_ADDR 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INET_ADDR\n");
  printf("/**\tDK3 version of HAVE_INET_ADDR.\n*/\n");
  printf("#define DK3_HAVE_INET_ADDR 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INET_ATON\n");
  printf("/**\tDK3 version of HAVE_INET_ATON.\n*/\n");
  printf("#define DK3_HAVE_INET_ATON 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INET_PTON\n");
  printf("/**\tDK3 version of HAVE_INET_PTON.\n*/\n");
  printf("#define DK3_HAVE_INET_PTON 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INITSTATE\n");
  printf("/**\tDK3 version of HAVE_INITSTATE.\n*/\n");
  printf("#define DK3_HAVE_INITSTATE 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INODES\n");
  printf("/**\tDK3 version of HAVE_INODES.\n*/\n");
  printf("#define DK3_HAVE_INODES 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INTMAX_T\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_INTMAX_T.\n*/\n");
  printf("#define DK3_HAVE_INTMAX_T 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_INTMAX_T.\n*/\n");
  printf("#define DK3_HAVE_INTMAX_T 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INTTYPES_H\n");
  printf("/**\tDK3 version of HAVE_INTTYPES_H.\n*/\n");
  printf("#define DK3_HAVE_INTTYPES_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_IN_ADDR\n");
  printf("/**\tDK3 version of HAVE_IN_ADDR.\n*/\n");
  printf("#define DK3_HAVE_IN_ADDR 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_IO_H\n");
  printf("/**\tDK3 version of HAVE_IO_H.\n*/\n");
  printf("#define DK3_HAVE_IO_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ISATTY\n");
  printf("/**\tDK3 version of HAVE_ISATTY.\n*/\n");
  printf("#define DK3_HAVE_ISATTY 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ISFINITE\n");
  printf("/**\tDK3 version of HAVE_ISFINITE.\n*/\n");
  printf("#define DK3_HAVE_ISFINITE 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ISNORMAL\n");
  printf("/**\tDK3 version of HAVE_ISNORMAL.\n*/\n");
  printf("#define DK3_HAVE_ISNORMAL 0\n");
  printf("#endif\n");
/* WARNING: HAVE_JPEGLIB_H not defined for Windows! */
  printf("\n#ifndef DK3_HAVE_LABS\n");
  printf("/**\tDK3 version of HAVE_LABS.\n*/\n");
  printf("#define DK3_HAVE_LABS 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LARGEFILE64_SOURCE\n");
  printf("/**\tDK3 version of HAVE_LARGEFILE64_SOURCE.\n*/\n");
  printf("#define DK3_HAVE_LARGEFILE64_SOURCE 0\n");
  printf("#endif\n");
/* WARNING: HAVE_LIBNETSNMP not defined for Windows! */
  printf("\n#ifndef DK3_HAVE_LIMITS_H\n");
  printf("/**\tDK3 version of HAVE_LIMITS_H.\n*/\n");
  printf("#define DK3_HAVE_LIMITS_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LOCALE_H\n");
  printf("/**\tDK3 version of HAVE_LOCALE_H.\n*/\n");
  printf("#define DK3_HAVE_LOCALE_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LOCALTIME\n");
  printf("/**\tDK3 version of HAVE_LOCALTIME.\n*/\n");
  printf("#define DK3_HAVE_LOCALTIME 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LOCALTIME\n");
  printf("/**\tDK3 version of HAVE_LOCALTIME.\n*/\n");
  printf("#define DK3_HAVE_LOCALTIME 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LOCALTIME_R\n");
  printf("/**\tDK3 version of HAVE_LOCALTIME_R.\n*/\n");
  printf("#define DK3_HAVE_LOCALTIME_R 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LOGL\n");
  printf("/**\tDK3 version of HAVE_LOGL.\n*/\n");
  printf("#define DK3_HAVE_LOGL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LONG_DOUBLE\n");
  printf("/**\tDK3 version of HAVE_LONG_DOUBLE.\n*/\n");
  printf("#define DK3_HAVE_LONG_DOUBLE 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LONG_LONG\n");
  printf("/**\tDK3 version of HAVE_LONG_LONG.\n*/\n");
  printf("#define DK3_HAVE_LONG_LONG 1\n");
  printf("#endif\n");
/* WARNING: HAVE_LPRNG_H not defined for Windows! */
  printf("\n#ifndef DK3_HAVE_LRAND48\n");
  printf("/**\tDK3 version of HAVE_LRAND48.\n*/\n");
  printf("#define DK3_HAVE_LRAND48 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LSTAT\n");
  printf("/**\tDK3 version of HAVE_LSTAT.\n*/\n");
  printf("#define DK3_HAVE_LSTAT 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LSTAT32\n");
  printf("/**\tDK3 version of HAVE_LSTAT32.\n*/\n");
  printf("#define DK3_HAVE_LSTAT32 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LSTAT64\n");
  printf("/**\tDK3 version of HAVE_LSTAT64.\n*/\n");
  printf("#define DK3_HAVE_LSTAT64 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MALLOC\n");
  printf("/**\tDK3 version of HAVE_MALLOC.\n*/\n");
  printf("#define DK3_HAVE_MALLOC 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MALLOC_H\n");
  printf("/**\tDK3 version of HAVE_MALLOC_H.\n*/\n");
  printf("#define DK3_HAVE_MALLOC_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MATH_H\n");
  printf("/**\tDK3 version of HAVE_MATH_H.\n*/\n");
  printf("#define DK3_HAVE_MATH_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MEMCMP\n");
  printf("/**\tDK3 version of HAVE_MEMCMP.\n*/\n");
  printf("#define DK3_HAVE_MEMCMP 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MEMCPY\n");
  printf("/**\tDK3 version of HAVE_MEMCPY.\n*/\n");
  printf("#define DK3_HAVE_MEMCPY 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MEMSET\n");
  printf("/**\tDK3 version of HAVE_MEMSET.\n*/\n");
  printf("#define DK3_HAVE_MEMSET 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MKDIR\n");
  printf("/**\tDK3 version of HAVE_MKDIR.\n*/\n");
  printf("#define DK3_HAVE_MKDIR 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MKDIR2\n");
  printf("/**\tDK3 version of HAVE_MKDIR2.\n*/\n");
  printf("#define DK3_HAVE_MKDIR2 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MPCTL\n");
  printf("/**\tDK3 version of HAVE_MPCTL.\n*/\n");
  printf("#define DK3_HAVE_MPCTL 0\n");
  printf("#endif\n");
/* WARNING: HAVE_MYSQL_LIBRARY_END not defined for Windows! */
/* WARNING: HAVE_MYSQL_LIBRARY_INIT not defined for Windows! */
/* WARNING: HAVE_MYSQL_MYSQL_H not defined for Windows! */
/* WARNING: HAVE_MYSQL_SET_CHARACTER_SET not defined for Windows! */
  printf("\n#ifndef DK3_HAVE_NDBM_H\n");
  printf("/**\tDK3 version of HAVE_NDBM_H.\n*/\n");
  printf("#define DK3_HAVE_NDBM_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_NETDB_H\n");
  printf("/**\tDK3 version of HAVE_NETDB_H.\n*/\n");
  printf("#define DK3_HAVE_NETDB_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_NETINET_IN_H\n");
  printf("/**\tDK3 version of HAVE_NETINET_IN_H.\n*/\n");
  printf("#define DK3_HAVE_NETINET_IN_H 0\n");
  printf("#endif\n");
/* WARNING: HAVE_NETSNMP_ENABLE_FILELOG not defined for Windows! */
  printf("\n#ifndef DK3_HAVE_NRAND48\n");
  printf("/**\tDK3 version of HAVE_NRAND48.\n*/\n");
  printf("#define DK3_HAVE_NRAND48 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_OPENDIR\n");
  printf("/**\tDK3 version of HAVE_OPENDIR.\n*/\n");
  printf("#define DK3_HAVE_OPENDIR 0\n");
  printf("#endif\n");
/* WARNING: HAVE_OPENSSL_MD5_H not defined for Windows! */
/* WARNING: HAVE_OPENSSL_RAND_H not defined for Windows! */
/* WARNING: HAVE_OPENSSL_RIPEMD_H not defined for Windows! */
/* WARNING: HAVE_OPENSSL_SHA_H not defined for Windows! */
  printf("\n#ifndef DK3_HAVE_PNG_GET_PIXELS_PER_INCH\n");
  printf("/**\tDK3 version of HAVE_PNG_GET_PIXELS_PER_INCH.\n*/\n");
  printf("#define DK3_HAVE_PNG_GET_PIXELS_PER_INCH 1\n");
  printf("#endif\n");
/* WARNING: HAVE_PNG_H not defined for Windows! */
  printf("\n#ifndef DK3_HAVE_POPEN\n");
  printf("/**\tDK3 version of HAVE_POPEN.\n*/\n");
  printf("#define DK3_HAVE_POPEN 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_PROCESS_H\n");
  printf("/**\tDK3 version of HAVE_PROCESS_H.\n*/\n");
  printf("#define DK3_HAVE_PROCESS_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_PTHREAD_H\n");
  printf("/**\tDK3 version of HAVE_PTHREAD_H.\n*/\n");
  printf("#define DK3_HAVE_PTHREAD_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_PWD_H\n");
  printf("/**\tDK3 version of HAVE_PWD_H.\n*/\n");
  printf("#define DK3_HAVE_PWD_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RAND\n");
  printf("/**\tDK3 version of HAVE_RAND.\n*/\n");
  printf("#define DK3_HAVE_RAND 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RANDOM\n");
  printf("/**\tDK3 version of HAVE_RANDOM.\n*/\n");
  printf("#define DK3_HAVE_RANDOM 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_READ\n");
  printf("/**\tDK3 version of HAVE_READ.\n*/\n");
  printf("#define DK3_HAVE_READ 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_READDIR\n");
  printf("/**\tDK3 version of HAVE_READDIR.\n*/\n");
  printf("#define DK3_HAVE_READDIR 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RFC_2249\n");
  printf("/**\tDK3 version of HAVE_RFC_2249.\n*/\n");
  printf("#define DK3_HAVE_RFC_2249 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RINT\n");
  printf("/**\tDK3 version of HAVE_RINT.\n*/\n");
  printf("#define DK3_HAVE_RINT 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RINTL\n");
  printf("/**\tDK3 version of HAVE_RINTL.\n*/\n");
  printf("#define DK3_HAVE_RINTL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RMDIR\n");
  printf("/**\tDK3 version of HAVE_RMDIR.\n*/\n");
  printf("#define DK3_HAVE_RMDIR 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SEED48\n");
  printf("/**\tDK3 version of HAVE_SEED48.\n*/\n");
  printf("#define DK3_HAVE_SEED48 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SELECT\n");
  printf("/**\tDK3 version of HAVE_SELECT.\n*/\n");
  printf("#define DK3_HAVE_SELECT 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETGID\n");
  printf("/**\tDK3 version of HAVE_SETGID.\n*/\n");
  printf("#define DK3_HAVE_SETGID 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETGRENT\n");
  printf("/**\tDK3 version of HAVE_SETGRENT.\n*/\n");
  printf("#define DK3_HAVE_SETGRENT 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETJMP_H\n");
  printf("/**\tDK3 version of HAVE_SETJMP_H.\n*/\n");
  printf("#define DK3_HAVE_SETJMP_H 1\n");
  printf("#endif\n");
/* WARNING: HAVE_SETLOCALE not defined for Windows! */
  printf("\n#ifndef DK3_HAVE_SETPGRP\n");
  printf("/**\tDK3 version of HAVE_SETPGRP.\n*/\n");
  printf("#define DK3_HAVE_SETPGRP 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETPWENT\n");
  printf("/**\tDK3 version of HAVE_SETPWENT.\n*/\n");
  printf("#define DK3_HAVE_SETPWENT 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETSID\n");
  printf("/**\tDK3 version of HAVE_SETSID.\n*/\n");
  printf("#define DK3_HAVE_SETSID 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETSOCKOPT\n");
  printf("/**\tDK3 version of HAVE_SETSOCKOPT.\n*/\n");
  printf("#define DK3_HAVE_SETSOCKOPT 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETSTATE\n");
  printf("/**\tDK3 version of HAVE_SETSTATE.\n*/\n");
  printf("#define DK3_HAVE_SETSTATE 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETUID\n");
  printf("/**\tDK3 version of HAVE_SETUID.\n*/\n");
  printf("#define DK3_HAVE_SETUID 0\n");
  printf("#endif\n");
/* WARNING: HAVE_SHA224 not defined for Windows! */
/* WARNING: HAVE_SHA256 not defined for Windows! */
/* WARNING: HAVE_SHA384 not defined for Windows! */
/* WARNING: HAVE_SHA512 not defined for Windows! */
  printf("\n#ifndef DK3_HAVE_SHADOW_H\n");
  printf("/**\tDK3 version of HAVE_SHADOW_H.\n*/\n");
  printf("#define DK3_HAVE_SHADOW_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SIGACTION\n");
  printf("/**\tDK3 version of HAVE_SIGACTION.\n*/\n");
  printf("#define DK3_HAVE_SIGACTION 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SIGNAL\n");
  printf("/**\tDK3 version of HAVE_SIGNAL.\n*/\n");
  printf("#define DK3_HAVE_SIGNAL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SIGNAL_H\n");
  printf("/**\tDK3 version of HAVE_SIGNAL_H.\n*/\n");
  printf("#define DK3_HAVE_SIGNAL_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SIGSET\n");
  printf("/**\tDK3 version of HAVE_SIGSET.\n*/\n");
  printf("#define DK3_HAVE_SIGSET 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SIG_ATOMIC_T\n");
  printf("/**\tDK3 version of HAVE_SIG_ATOMIC_T.\n*/\n");
  printf("#define DK3_HAVE_SIG_ATOMIC_T 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SINHL\n");
  printf("/**\tDK3 version of HAVE_SINHL.\n*/\n");
  printf("#define DK3_HAVE_SINHL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SINL\n");
  printf("/**\tDK3 version of HAVE_SINL.\n*/\n");
  printf("#define DK3_HAVE_SINL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SNPRINTF\n");
  printf("/**\tDK3 version of HAVE_SNPRINTF.\n*/\n");
  printf("#define DK3_HAVE_SNPRINTF 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SOCKET\n");
  printf("/**\tDK3 version of HAVE_SOCKET.\n*/\n");
  printf("#define DK3_HAVE_SOCKET 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SOCKLEN_T\n");
  printf("/**\tDK3 version of HAVE_SOCKLEN_T.\n*/\n");
  printf("#define DK3_HAVE_SOCKLEN_T 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SQRTL\n");
  printf("/**\tDK3 version of HAVE_SQRTL.\n*/\n");
  printf("#define DK3_HAVE_SQRTL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SRAND\n");
  printf("/**\tDK3 version of HAVE_SRAND.\n*/\n");
  printf("#define DK3_HAVE_SRAND 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SSIZE_T\n");
  printf("/**\tDK3 version of HAVE_SSIZE_T.\n*/\n");
  printf("#define DK3_HAVE_SSIZE_T 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STAT\n");
  printf("/**\tDK3 version of HAVE_STAT.\n*/\n");
  printf("#define DK3_HAVE_STAT 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STAT32\n");
  printf("/**\tDK3 version of HAVE_STAT32.\n*/\n");
  printf("#define DK3_HAVE_STAT32 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STAT64\n");
  printf("/**\tDK3 version of HAVE_STAT64.\n*/\n");
  printf("#define DK3_HAVE_STAT64 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STDARG_H\n");
  printf("/**\tDK3 version of HAVE_STDARG_H.\n*/\n");
  printf("#define DK3_HAVE_STDARG_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STDDEF_H\n");
  printf("/**\tDK3 version of HAVE_STDDEF_H.\n*/\n");
  printf("#define DK3_HAVE_STDDEF_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STDINT_H\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_STDINT_H.\n*/\n");
  printf("#define DK3_HAVE_STDINT_H 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_STDINT_H.\n*/\n");
  printf("#define DK3_HAVE_STDINT_H 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STDIO_H\n");
  printf("/**\tDK3 version of HAVE_STDIO_H.\n*/\n");
  printf("#define DK3_HAVE_STDIO_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STDLIB_H\n");
  printf("/**\tDK3 version of HAVE_STDLIB_H.\n*/\n");
  printf("#define DK3_HAVE_STDLIB_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRCASECMP\n");
  printf("/**\tDK3 version of HAVE_STRCASECMP.\n*/\n");
  printf("#define DK3_HAVE_STRCASECMP 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRCAT\n");
  printf("/**\tDK3 version of HAVE_STRCAT.\n*/\n");
  printf("#define DK3_HAVE_STRCAT 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRCHR\n");
  printf("/**\tDK3 version of HAVE_STRCHR.\n*/\n");
  printf("#define DK3_HAVE_STRCHR 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRCMP\n");
  printf("/**\tDK3 version of HAVE_STRCMP.\n*/\n");
  printf("#define DK3_HAVE_STRCMP 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRCPY\n");
  printf("/**\tDK3 version of HAVE_STRCPY.\n*/\n");
  printf("#define DK3_HAVE_STRCPY 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRDUP\n");
  printf("/**\tDK3 version of HAVE_STRDUP.\n*/\n");
  printf("#define DK3_HAVE_STRDUP 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRERROR\n");
  printf("/**\tDK3 version of HAVE_STRERROR.\n*/\n");
  printf("#define DK3_HAVE_STRERROR 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRICMP\n");
  printf("/**\tDK3 version of HAVE_STRICMP.\n*/\n");
  printf("#define DK3_HAVE_STRICMP 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRINGS_H\n");
  printf("/**\tDK3 version of HAVE_STRINGS_H.\n*/\n");
  printf("#define DK3_HAVE_STRINGS_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRING_H\n");
  printf("/**\tDK3 version of HAVE_STRING_H.\n*/\n");
  printf("#define DK3_HAVE_STRING_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRLEN\n");
  printf("/**\tDK3 version of HAVE_STRLEN.\n*/\n");
  printf("#define DK3_HAVE_STRLEN 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRNCMP\n");
  printf("/**\tDK3 version of HAVE_STRNCMP.\n*/\n");
  printf("#define DK3_HAVE_STRNCMP 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRNCPY\n");
  printf("/**\tDK3 version of HAVE_STRNCPY.\n*/\n");
  printf("#define DK3_HAVE_STRNCPY 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STROPTS_H\n");
  printf("/**\tDK3 version of HAVE_STROPTS_H.\n*/\n");
  printf("#define DK3_HAVE_STROPTS_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRRCHR\n");
  printf("/**\tDK3 version of HAVE_STRRCHR.\n*/\n");
  printf("#define DK3_HAVE_STRRCHR 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOD\n");
  printf("/**\tDK3 version of HAVE_STRTOD.\n*/\n");
  printf("#define DK3_HAVE_STRTOD 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOIMAX\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_STRTOIMAX.\n*/\n");
  printf("#define DK3_HAVE_STRTOIMAX 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_STRTOIMAX.\n*/\n");
  printf("#define DK3_HAVE_STRTOIMAX 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOL\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_STRTOL.\n*/\n");
  printf("#define DK3_HAVE_STRTOL 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_STRTOL.\n*/\n");
  printf("#define DK3_HAVE_STRTOL 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOLL\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_STRTOLL.\n*/\n");
  printf("#define DK3_HAVE_STRTOLL 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_STRTOLL.\n*/\n");
  printf("#define DK3_HAVE_STRTOLL 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOUL\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_STRTOUL.\n*/\n");
  printf("#define DK3_HAVE_STRTOUL 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_STRTOUL.\n*/\n");
  printf("#define DK3_HAVE_STRTOUL 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOULL\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_STRTOULL.\n*/\n");
  printf("#define DK3_HAVE_STRTOULL 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_STRTOULL.\n*/\n");
  printf("#define DK3_HAVE_STRTOULL 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOUMAX\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_STRTOUMAX.\n*/\n");
  printf("#define DK3_HAVE_STRTOUMAX 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_STRTOUMAX.\n*/\n");
  printf("#define DK3_HAVE_STRTOUMAX 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRUCT_ADDRINFO\n");
  printf("/**\tDK3 version of HAVE_STRUCT_ADDRINFO.\n*/\n");
  printf("#define DK3_HAVE_STRUCT_ADDRINFO 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRUCT_SOCKADDR_IN\n");
  printf("/**\tDK3 version of HAVE_STRUCT_SOCKADDR_IN.\n*/\n");
  printf("#define DK3_HAVE_STRUCT_SOCKADDR_IN 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRUCT_SOCKADDR_IN6\n");
  printf("/**\tDK3 version of HAVE_STRUCT_SOCKADDR_IN6.\n*/\n");
  printf("#define DK3_HAVE_STRUCT_SOCKADDR_IN6 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRUCT_SOCKADDR_STORAGE\n");
  printf("/**\tDK3 version of HAVE_STRUCT_SOCKADDR_STORAGE.\n*/\n");
  printf("#define DK3_HAVE_STRUCT_SOCKADDR_STORAGE 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRUCT_SOCKADDR_UN\n");
  printf("/**\tDK3 version of HAVE_STRUCT_SOCKADDR_UN.\n*/\n");
  printf("#define DK3_HAVE_STRUCT_SOCKADDR_UN 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYSCONF\n");
  printf("/**\tDK3 version of HAVE_SYSCONF.\n*/\n");
  printf("#define DK3_HAVE_SYSCONF 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYSCTL\n");
  printf("/**\tDK3 version of HAVE_SYSCTL.\n*/\n");
  printf("#define DK3_HAVE_SYSCTL 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYSLOG\n");
  printf("/**\tDK3 version of HAVE_SYSLOG.\n*/\n");
  printf("#define DK3_HAVE_SYSLOG 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYSLOG_H\n");
  printf("/**\tDK3 version of HAVE_SYSLOG_H.\n*/\n");
  printf("#define DK3_HAVE_SYSLOG_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYSRES_H\n");
  printf("/**\tDK3 version of HAVE_SYSRES_H.\n*/\n");
  printf("#define DK3_HAVE_SYSRES_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_FILE_H\n");
  printf("/**\tDK3 version of HAVE_SYS_FILE_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_FILE_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_PARAM_H\n");
  printf("/**\tDK3 version of HAVE_SYS_PARAM_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_PARAM_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_RESOURCE_H\n");
  printf("/**\tDK3 version of HAVE_SYS_RESOURCE_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_RESOURCE_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_SOCKET_H\n");
  printf("/**\tDK3 version of HAVE_SYS_SOCKET_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_SOCKET_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_STATVFS_H\n");
  printf("/**\tDK3 version of HAVE_SYS_STATVFS_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_STATVFS_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_STAT_H\n");
  printf("/**\tDK3 version of HAVE_SYS_STAT_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_STAT_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_STROPTS_H\n");
  printf("/**\tDK3 version of HAVE_SYS_STROPTS_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_STROPTS_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_SUNDDI_H\n");
  printf("/**\tDK3 version of HAVE_SYS_SUNDDI_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_SUNDDI_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_SYSCTL_H\n");
  printf("/**\tDK3 version of HAVE_SYS_SYSCTL_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_SYSCTL_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_SYSTEMINFO_H\n");
  printf("/**\tDK3 version of HAVE_SYS_SYSTEMINFO_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_SYSTEMINFO_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_TERMIOS_H\n");
  printf("/**\tDK3 version of HAVE_SYS_TERMIOS_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_TERMIOS_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_TIME_H\n");
  printf("/**\tDK3 version of HAVE_SYS_TIME_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_TIME_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_TTOLD_H\n");
  printf("/**\tDK3 version of HAVE_SYS_TTOLD_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_TTOLD_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_TYPES_H\n");
  printf("/**\tDK3 version of HAVE_SYS_TYPES_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_TYPES_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_UIO_H\n");
  printf("/**\tDK3 version of HAVE_SYS_UIO_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_UIO_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_UN_H\n");
  printf("/**\tDK3 version of HAVE_SYS_UN_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_UN_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_WAIT_H\n");
  printf("/**\tDK3 version of HAVE_SYS_WAIT_H.\n*/\n");
  printf("#define DK3_HAVE_SYS_WAIT_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TANHL\n");
  printf("/**\tDK3 version of HAVE_TANHL.\n*/\n");
  printf("#define DK3_HAVE_TANHL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TANL\n");
  printf("/**\tDK3 version of HAVE_TANL.\n*/\n");
  printf("#define DK3_HAVE_TANL 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TCFLUSH\n");
  printf("/**\tDK3 version of HAVE_TCFLUSH.\n*/\n");
  printf("#define DK3_HAVE_TCFLUSH 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TCGETATTR\n");
  printf("/**\tDK3 version of HAVE_TCGETATTR.\n*/\n");
  printf("#define DK3_HAVE_TCGETATTR 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TERMIOS_H\n");
  printf("/**\tDK3 version of HAVE_TERMIOS_H.\n*/\n");
  printf("#define DK3_HAVE_TERMIOS_H 0\n");
  printf("#endif\n");
/* WARNING: HAVE_TIFF_H not defined for Windows! */
  printf("\n#ifndef DK3_HAVE_TIME\n");
  printf("/**\tDK3 version of HAVE_TIME.\n*/\n");
  printf("#define DK3_HAVE_TIME 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TIME_H\n");
  printf("/**\tDK3 version of HAVE_TIME_H.\n*/\n");
  printf("#define DK3_HAVE_TIME_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TWOS_COMPLEMENT\n");
  printf("/**\tDK3 version of HAVE_TWOS_COMPLEMENT.\n*/\n");
  printf("#define DK3_HAVE_TWOS_COMPLEMENT 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_UMASK\n");
  printf("/**\tDK3 version of HAVE_UMASK.\n*/\n");
  printf("#define DK3_HAVE_UMASK 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_UNISTD_H\n");
  printf("/**\tDK3 version of HAVE_UNISTD_H.\n*/\n");
  printf("#define DK3_HAVE_UNISTD_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_UNLINK\n");
  printf("/**\tDK3 version of HAVE_UNLINK.\n*/\n");
  printf("#define DK3_HAVE_UNLINK 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_USER_NAMES_CASE_INSENSITIVE\n");
  printf("/**\tDK3 version of HAVE_USER_NAMES_CASE_INSENSITIVE.\n*/\n");
  printf("#define DK3_HAVE_USER_NAMES_CASE_INSENSITIVE 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_VARARGS_H\n");
  printf("/**\tDK3 version of HAVE_VARARGS_H.\n*/\n");
  printf("#define DK3_HAVE_VARARGS_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_VARARG_H\n");
  printf("/**\tDK3 version of HAVE_VARARG_H.\n*/\n");
  printf("#define DK3_HAVE_VARARG_H 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_VOLATILE\n");
  printf("/**\tDK3 version of HAVE_VOLATILE.\n*/\n");
  printf("#define DK3_HAVE_VOLATILE 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCHAR_H\n");
  printf("/**\tDK3 version of HAVE_WCHAR_H.\n*/\n");
  printf("#define DK3_HAVE_WCHAR_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCHAR_T\n");
  printf("/**\tDK3 version of HAVE_WCHAR_T.\n*/\n");
  printf("#define DK3_HAVE_WCHAR_T 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSCAT\n");
  printf("/**\tDK3 version of HAVE_WCSCAT.\n*/\n");
  printf("#define DK3_HAVE_WCSCAT 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSCHR\n");
  printf("/**\tDK3 version of HAVE_WCSCHR.\n*/\n");
  printf("#define DK3_HAVE_WCSCHR 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSCMP\n");
  printf("/**\tDK3 version of HAVE_WCSCMP.\n*/\n");
  printf("#define DK3_HAVE_WCSCMP 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSCPY\n");
  printf("/**\tDK3 version of HAVE_WCSCPY.\n*/\n");
  printf("#define DK3_HAVE_WCSCPY 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSDUP\n");
  printf("/**\tDK3 version of HAVE_WCSDUP.\n*/\n");
  printf("#define DK3_HAVE_WCSDUP 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSICMP\n");
  printf("/**\tDK3 version of HAVE_WCSICMP.\n*/\n");
  printf("#define DK3_HAVE_WCSICMP 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSLEN\n");
  printf("/**\tDK3 version of HAVE_WCSLEN.\n*/\n");
  printf("#define DK3_HAVE_WCSLEN 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSNCMP\n");
  printf("/**\tDK3 version of HAVE_WCSNCMP.\n*/\n");
  printf("#define DK3_HAVE_WCSNCMP 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSNCPY\n");
  printf("/**\tDK3 version of HAVE_WCSNCPY.\n*/\n");
  printf("#define DK3_HAVE_WCSNCPY 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSRCHR\n");
  printf("/**\tDK3 version of HAVE_WCSRCHR.\n*/\n");
  printf("#define DK3_HAVE_WCSRCHR 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOD\n");
  printf("/**\tDK3 version of HAVE_WCSTOD.\n*/\n");
  printf("#define DK3_HAVE_WCSTOD 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOIMAX\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_WCSTOIMAX.\n*/\n");
  printf("#define DK3_HAVE_WCSTOIMAX 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_WCSTOIMAX.\n*/\n");
  printf("#define DK3_HAVE_WCSTOIMAX 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOL\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_WCSTOL.\n*/\n");
  printf("#define DK3_HAVE_WCSTOL 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_WCSTOL.\n*/\n");
  printf("#define DK3_HAVE_WCSTOL 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOLL\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_WCSTOLL.\n*/\n");
  printf("#define DK3_HAVE_WCSTOLL 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_WCSTOLL.\n*/\n");
  printf("#define DK3_HAVE_WCSTOLL 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOUL\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_WCSTOUL.\n*/\n");
  printf("#define DK3_HAVE_WCSTOUL 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_WCSTOUL.\n*/\n");
  printf("#define DK3_HAVE_WCSTOUL 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOULL\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_WCSTOULL.\n*/\n");
  printf("#define DK3_HAVE_WCSTOULL 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_WCSTOULL.\n*/\n");
  printf("#define DK3_HAVE_WCSTOULL 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOUMAX\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE_WCSTOUMAX.\n*/\n");
  printf("#define DK3_HAVE_WCSTOUMAX 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE_WCSTOUMAX.\n*/\n");
  printf("#define DK3_HAVE_WCSTOUMAX 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WINBASE_H\n");
  printf("/**\tDK3 version of HAVE_WINBASE_H.\n*/\n");
  printf("#define DK3_HAVE_WINBASE_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WINCON_H\n");
  printf("/**\tDK3 version of HAVE_WINCON_H.\n*/\n");
  printf("#define DK3_HAVE_WINCON_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WINDOWS_H\n");
  printf("/**\tDK3 version of HAVE_WINDOWS_H.\n*/\n");
  printf("#define DK3_HAVE_WINDOWS_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WINREG_H\n");
  printf("/**\tDK3 version of HAVE_WINREG_H.\n*/\n");
  printf("#define DK3_HAVE_WINREG_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WINSOCK2_H\n");
  printf("/**\tDK3 version of HAVE_WINSOCK2_H.\n*/\n");
  printf("#define DK3_HAVE_WINSOCK2_H 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WRITE\n");
  printf("/**\tDK3 version of HAVE_WRITE.\n*/\n");
  printf("#define DK3_HAVE_WRITE 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WS2TCPIP_H\n");
  printf("/**\tDK3 version of HAVE_WS2TCPIP_H.\n*/\n");
  printf("#define DK3_HAVE_WS2TCPIP_H 1\n");
  printf("#endif\n");
/* WARNING: HAVE_ZLIB_H not defined for Windows! */
  printf("\n#ifndef DK3_HAVE__CLEARFP\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of HAVE__CLEARFP.\n*/\n");
  printf("#define DK3_HAVE__CLEARFP 1\n");
  printf("#else\n");
  printf("/**\tDK3 version of HAVE__CLEARFP.\n*/\n");
  printf("#define DK3_HAVE__CLEARFP 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FCLOSE\n");
  printf("/**\tDK3 version of HAVE__FCLOSE.\n*/\n");
  printf("#define DK3_HAVE__FCLOSE 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FEOF\n");
  printf("/**\tDK3 version of HAVE__FEOF.\n*/\n");
  printf("#define DK3_HAVE__FEOF 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FERROR\n");
  printf("/**\tDK3 version of HAVE__FERROR.\n*/\n");
  printf("#define DK3_HAVE__FERROR 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FFLUSH\n");
  printf("/**\tDK3 version of HAVE__FFLUSH.\n*/\n");
  printf("#define DK3_HAVE__FFLUSH 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FOPEN\n");
  printf("/**\tDK3 version of HAVE__FOPEN.\n*/\n");
  printf("#define DK3_HAVE__FOPEN 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FREAD\n");
  printf("/**\tDK3 version of HAVE__FREAD.\n*/\n");
  printf("#define DK3_HAVE__FREAD 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FWRITE\n");
  printf("/**\tDK3 version of HAVE__FWRITE.\n*/\n");
  printf("#define DK3_HAVE__FWRITE 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__GETCWD\n");
  printf("/**\tDK3 version of HAVE__GETCWD.\n*/\n");
  printf("#define DK3_HAVE__GETCWD 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__GETPID\n");
  printf("/**\tDK3 version of HAVE__GETPID.\n*/\n");
  printf("#define DK3_HAVE__GETPID 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__LSTAT\n");
  printf("/**\tDK3 version of HAVE__LSTAT.\n*/\n");
  printf("#define DK3_HAVE__LSTAT 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__LSTAT32\n");
  printf("/**\tDK3 version of HAVE__LSTAT32.\n*/\n");
  printf("#define DK3_HAVE__LSTAT32 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__LSTAT64\n");
  printf("/**\tDK3 version of HAVE__LSTAT64.\n*/\n");
  printf("#define DK3_HAVE__LSTAT64 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__MKDIR\n");
  printf("/**\tDK3 version of HAVE__MKDIR.\n*/\n");
  printf("#define DK3_HAVE__MKDIR 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__POPEN\n");
  printf("/**\tDK3 version of HAVE__POPEN.\n*/\n");
  printf("#define DK3_HAVE__POPEN 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__READ\n");
  printf("/**\tDK3 version of HAVE__READ.\n*/\n");
  printf("#define DK3_HAVE__READ 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__RMDIR\n");
  printf("/**\tDK3 version of HAVE__RMDIR.\n*/\n");
  printf("#define DK3_HAVE__RMDIR 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__SNPRINTF\n");
  printf("/**\tDK3 version of HAVE__SNPRINTF.\n*/\n");
  printf("#define DK3_HAVE__SNPRINTF 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__STAT\n");
  printf("/**\tDK3 version of HAVE__STAT.\n*/\n");
  printf("#define DK3_HAVE__STAT 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__STAT32\n");
  printf("/**\tDK3 version of HAVE__STAT32.\n*/\n");
  printf("#define DK3_HAVE__STAT32 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__STAT64\n");
  printf("/**\tDK3 version of HAVE__STAT64.\n*/\n");
  printf("#define DK3_HAVE__STAT64 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__STRDUP\n");
  printf("/**\tDK3 version of HAVE__STRDUP.\n*/\n");
  printf("#define DK3_HAVE__STRDUP 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__STRICMP\n");
  printf("/**\tDK3 version of HAVE__STRICMP.\n*/\n");
  printf("#define DK3_HAVE__STRICMP 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__UNLINK\n");
  printf("/**\tDK3 version of HAVE__UNLINK.\n*/\n");
  printf("#define DK3_HAVE__UNLINK 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSCAT\n");
  printf("/**\tDK3 version of HAVE__WCSCAT.\n*/\n");
  printf("#define DK3_HAVE__WCSCAT 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSCHR\n");
  printf("/**\tDK3 version of HAVE__WCSCHR.\n*/\n");
  printf("#define DK3_HAVE__WCSCHR 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSCMP\n");
  printf("/**\tDK3 version of HAVE__WCSCMP.\n*/\n");
  printf("#define DK3_HAVE__WCSCMP 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSCPY\n");
  printf("/**\tDK3 version of HAVE__WCSCPY.\n*/\n");
  printf("#define DK3_HAVE__WCSCPY 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSDUP\n");
  printf("/**\tDK3 version of HAVE__WCSDUP.\n*/\n");
  printf("#define DK3_HAVE__WCSDUP 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSICMP\n");
  printf("/**\tDK3 version of HAVE__WCSICMP.\n*/\n");
  printf("#define DK3_HAVE__WCSICMP 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSLEN\n");
  printf("/**\tDK3 version of HAVE__WCSLEN.\n*/\n");
  printf("#define DK3_HAVE__WCSLEN 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSNCMP\n");
  printf("/**\tDK3 version of HAVE__WCSNCMP.\n*/\n");
  printf("#define DK3_HAVE__WCSNCMP 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSNCPY\n");
  printf("/**\tDK3 version of HAVE__WCSNCPY.\n*/\n");
  printf("#define DK3_HAVE__WCSNCPY 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSRCHR\n");
  printf("/**\tDK3 version of HAVE__WCSRCHR.\n*/\n");
  printf("#define DK3_HAVE__WCSRCHR 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WGETENV\n");
  printf("/**\tDK3 version of HAVE__WGETENV.\n*/\n");
  printf("#define DK3_HAVE__WGETENV 1\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WRITE\n");
  printf("/**\tDK3 version of HAVE__WRITE.\n*/\n");
  printf("#define DK3_HAVE__WRITE 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_TIME_WITH_SYS_TIME\n");
  printf("/**\tDK3 version of TIME_WITH_SYS_TIME.\n*/\n");
  printf("#define DK3_TIME_WITH_SYS_TIME 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_DOUBLE\n");
  printf("/**\tDK3 version of SIZEOF_DOUBLE.\n*/\n");
  printf("#define DK3_SIZEOF_DOUBLE 8\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_INT\n");
  printf("/**\tDK3 version of SIZEOF_INT.\n*/\n");
  printf("#define DK3_SIZEOF_INT 4\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_INTMAX_T\n");
  printf("#if _MSC_VER >= 1700\n");
  printf("/**\tDK3 version of SIZEOF_INTMAX_T.\n*/\n");
  printf("#define DK3_SIZEOF_INTMAX_T 8\n");
  printf("#else\n");
  printf("/**\tDK3 version of SIZEOF_INTMAX_T.\n*/\n");
  printf("#define DK3_SIZEOF_INTMAX_T 0\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_LONG\n");
  printf("/**\tDK3 version of SIZEOF_LONG.\n*/\n");
  printf("#define DK3_SIZEOF_LONG 4\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_LONG_DOUBLE\n");
  printf("/**\tDK3 version of SIZEOF_LONG_DOUBLE.\n*/\n");
  printf("#define DK3_SIZEOF_LONG_DOUBLE 8\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_LONG_LONG\n");
  printf("/**\tDK3 version of SIZEOF_LONG_LONG.\n*/\n");
  printf("#define DK3_SIZEOF_LONG_LONG 8\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_SHORT\n");
  printf("/**\tDK3 version of SIZEOF_SHORT.\n*/\n");
  printf("#define DK3_SIZEOF_SHORT 2\n");
  printf("#endif\n");
  printf("\n#if defined(WIN64) || defined(_WIN64)\n");
  printf("#ifndef DK3_SIZEOF_SIZE_T\n");
  printf("/**\tDK3 version of SIZEOF_SIZE_T.\n*/\n");
  printf("#define DK3_SIZEOF_SIZE_T 8\n");
  printf("#endif\n");
  printf("#else\n");
  printf("#ifndef DK3_SIZEOF_SIZE_T\n");
  printf("/**\tDK3 version of SIZEOF_SIZE_T.\n*/\n");
  printf("#define DK3_SIZEOF_SIZE_T 4\n");
  printf("#endif\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_WCHAR_T\n");
  printf("/**\tDK3 version of SIZEOF_WCHAR_T.\n*/\n");
  printf("#define DK3_SIZEOF_WCHAR_T 2\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RFC_2279\n");
  printf("/**\tDK3 version of HAVE_RFC_2279.\n*/\n");
  printf("#define DK3_HAVE_RFC_2279 0\n");
  printf("#endif\n");
  printf("\n#ifndef DK3_WORDS_BIGENDIAN\n");
  printf("/**\tDK3 version of WORDS_BIGENDIAN.\n*/\n");
  printf("#define DK3_WORDS_BIGENDIAN 0\n");
  printf("#endif\n");
  printf("\n#else\n/* if DK3_ON_WINDOWS */\n\n");
  printf("\n#ifndef DK3_HAVE_ACOSH\n");
  printf("/**\tDK3 version of HAVE_ACOSH.\n*/\n");
#if HAVE_ACOSH
  printf("#define DK3_HAVE_ACOSH 1\n");
#else
  printf("#define DK3_HAVE_ACOSH 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ACOSHL\n");
  printf("/**\tDK3 version of HAVE_ACOSHL.\n*/\n");
#if HAVE_ACOSHL
  printf("#define DK3_HAVE_ACOSHL 1\n");
#else
  printf("#define DK3_HAVE_ACOSHL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ACOSL\n");
  printf("/**\tDK3 version of HAVE_ACOSL.\n*/\n");
#if HAVE_ACOSL
  printf("#define DK3_HAVE_ACOSL 1\n");
#else
  printf("#define DK3_HAVE_ACOSL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ALLOC_H\n");
  printf("/**\tDK3 version of HAVE_ALLOC_H.\n*/\n");
#if HAVE_ALLOC_H
  printf("#define DK3_HAVE_ALLOC_H 1\n");
#else
  printf("#define DK3_HAVE_ALLOC_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ARPA_INET_H\n");
  printf("/**\tDK3 version of HAVE_ARPA_INET_H.\n*/\n");
#if HAVE_ARPA_INET_H
  printf("#define DK3_HAVE_ARPA_INET_H 1\n");
#else
  printf("#define DK3_HAVE_ARPA_INET_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ASINH\n");
  printf("/**\tDK3 version of HAVE_ASINH.\n*/\n");
#if HAVE_ASINH
  printf("#define DK3_HAVE_ASINH 1\n");
#else
  printf("#define DK3_HAVE_ASINH 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ASINHL\n");
  printf("/**\tDK3 version of HAVE_ASINHL.\n*/\n");
#if HAVE_ASINHL
  printf("#define DK3_HAVE_ASINHL 1\n");
#else
  printf("#define DK3_HAVE_ASINHL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ASINL\n");
  printf("/**\tDK3 version of HAVE_ASINL.\n*/\n");
#if HAVE_ASINL
  printf("#define DK3_HAVE_ASINL 1\n");
#else
  printf("#define DK3_HAVE_ASINL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ATAN2\n");
  printf("/**\tDK3 version of HAVE_ATAN2.\n*/\n");
#if HAVE_ATAN2
  printf("#define DK3_HAVE_ATAN2 1\n");
#else
  printf("#define DK3_HAVE_ATAN2 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ATAN2L\n");
  printf("/**\tDK3 version of HAVE_ATAN2L.\n*/\n");
#if HAVE_ATAN2L
  printf("#define DK3_HAVE_ATAN2L 1\n");
#else
  printf("#define DK3_HAVE_ATAN2L 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ATANH\n");
  printf("/**\tDK3 version of HAVE_ATANH.\n*/\n");
#if HAVE_ATANH
  printf("#define DK3_HAVE_ATANH 1\n");
#else
  printf("#define DK3_HAVE_ATANH 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ATANHL\n");
  printf("/**\tDK3 version of HAVE_ATANHL.\n*/\n");
#if HAVE_ATANHL
  printf("#define DK3_HAVE_ATANHL 1\n");
#else
  printf("#define DK3_HAVE_ATANHL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ATANL\n");
  printf("/**\tDK3 version of HAVE_ATANL.\n*/\n");
#if HAVE_ATANL
  printf("#define DK3_HAVE_ATANL 1\n");
#else
  printf("#define DK3_HAVE_ATANL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_BACKSLASH\n");
  printf("/**\tDK3 version of HAVE_BACKSLASH.\n*/\n");
#if HAVE_BACKSLASH
  printf("#define DK3_HAVE_BACKSLASH 1\n");
#else
  printf("#define DK3_HAVE_BACKSLASH 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_BCMP\n");
  printf("/**\tDK3 version of HAVE_BCMP.\n*/\n");
#if HAVE_BCMP
  printf("#define DK3_HAVE_BCMP 1\n");
#else
  printf("#define DK3_HAVE_BCMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_BCOPY\n");
  printf("/**\tDK3 version of HAVE_BCOPY.\n*/\n");
#if HAVE_BCOPY
  printf("#define DK3_HAVE_BCOPY 1\n");
#else
  printf("#define DK3_HAVE_BCOPY 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_BZERO\n");
  printf("/**\tDK3 version of HAVE_BZERO.\n*/\n");
#if HAVE_BZERO
  printf("#define DK3_HAVE_BZERO 1\n");
#else
  printf("#define DK3_HAVE_BZERO 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_BZLIB_H\n");
  printf("/**\tDK3 version of HAVE_BZLIB_H.\n*/\n");
#if HAVE_BZLIB_H
  printf("#define DK3_HAVE_BZLIB_H 1\n");
#else
  printf("#define DK3_HAVE_BZLIB_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CEIL\n");
  printf("/**\tDK3 version of HAVE_CEIL.\n*/\n");
#if HAVE_CEIL
  printf("#define DK3_HAVE_CEIL 1\n");
#else
  printf("#define DK3_HAVE_CEIL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CEILL\n");
  printf("/**\tDK3 version of HAVE_CEILL.\n*/\n");
#if HAVE_CEILL
  printf("#define DK3_HAVE_CEILL 1\n");
#else
  printf("#define DK3_HAVE_CEILL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CHDIR\n");
  printf("/**\tDK3 version of HAVE_CHDIR.\n*/\n");
#if HAVE_CHDIR
  printf("#define DK3_HAVE_CHDIR 1\n");
#else
  printf("#define DK3_HAVE_CHDIR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CHMOD\n");
  printf("/**\tDK3 version of HAVE_CHMOD.\n*/\n");
#if HAVE_CHMOD
  printf("#define DK3_HAVE_CHMOD 1\n");
#else
  printf("#define DK3_HAVE_CHMOD 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CHOWN\n");
  printf("/**\tDK3 version of HAVE_CHOWN.\n*/\n");
#if HAVE_CHOWN
  printf("#define DK3_HAVE_CHOWN 1\n");
#else
  printf("#define DK3_HAVE_CHOWN 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CLOSEDIR\n");
  printf("/**\tDK3 version of HAVE_CLOSEDIR.\n*/\n");
#if HAVE_CLOSEDIR
  printf("#define DK3_HAVE_CLOSEDIR 1\n");
#else
  printf("#define DK3_HAVE_CLOSEDIR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CONIO_H\n");
  printf("/**\tDK3 version of HAVE_CONIO_H.\n*/\n");
#if HAVE_CONIO_H
  printf("#define DK3_HAVE_CONIO_H 1\n");
#else
  printf("#define DK3_HAVE_CONIO_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CONST\n");
  printf("/**\tDK3 version of HAVE_CONST.\n*/\n");
#if HAVE_CONST
  printf("#define DK3_HAVE_CONST 1\n");
#else
  printf("#define DK3_HAVE_CONST 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_COSHL\n");
  printf("/**\tDK3 version of HAVE_COSHL.\n*/\n");
#if HAVE_COSHL
  printf("#define DK3_HAVE_COSHL 1\n");
#else
  printf("#define DK3_HAVE_COSHL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_COSL\n");
  printf("/**\tDK3 version of HAVE_COSL.\n*/\n");
#if HAVE_COSL
  printf("#define DK3_HAVE_COSL 1\n");
#else
  printf("#define DK3_HAVE_COSL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_CTYPE_H\n");
  printf("/**\tDK3 version of HAVE_CTYPE_H.\n*/\n");
#if HAVE_CTYPE_H
  printf("#define DK3_HAVE_CTYPE_H 1\n");
#else
  printf("#define DK3_HAVE_CTYPE_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DB_CURSOR_C_GET\n");
  printf("/**\tDK3 version of HAVE_DB_CURSOR_C_GET.\n*/\n");
#if HAVE_DB_CURSOR_C_GET
  printf("#define DK3_HAVE_DB_CURSOR_C_GET 1\n");
#else
  printf("#define DK3_HAVE_DB_CURSOR_C_GET 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DB_H\n");
  printf("/**\tDK3 version of HAVE_DB_H.\n*/\n");
#if HAVE_DB_H
  printf("#define DK3_HAVE_DB_H 1\n");
#else
  printf("#define DK3_HAVE_DB_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DEV_RANDOM\n");
  printf("/**\tDK3 version of HAVE_DEV_RANDOM.\n*/\n");
#if HAVE_DEV_RANDOM
  printf("#define DK3_HAVE_DEV_RANDOM 1\n");
#else
  printf("#define DK3_HAVE_DEV_RANDOM 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DEV_URANDOM\n");
  printf("/**\tDK3 version of HAVE_DEV_URANDOM.\n*/\n");
#if HAVE_DEV_URANDOM
  printf("#define DK3_HAVE_DEV_URANDOM 1\n");
#else
  printf("#define DK3_HAVE_DEV_URANDOM 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DIRECT_H\n");
  printf("/**\tDK3 version of HAVE_DIRECT_H.\n*/\n");
#if HAVE_DIRECT_H
  printf("#define DK3_HAVE_DIRECT_H 1\n");
#else
  printf("#define DK3_HAVE_DIRECT_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DIRENT_H\n");
  printf("/**\tDK3 version of HAVE_DIRENT_H.\n*/\n");
#if HAVE_DIRENT_H
  printf("#define DK3_HAVE_DIRENT_H 1\n");
#else
  printf("#define DK3_HAVE_DIRENT_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DIR_H\n");
  printf("/**\tDK3 version of HAVE_DIR_H.\n*/\n");
#if HAVE_DIR_H
  printf("#define DK3_HAVE_DIR_H 1\n");
#else
  printf("#define DK3_HAVE_DIR_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_DOS_H\n");
  printf("/**\tDK3 version of HAVE_DOS_H.\n*/\n");
#if HAVE_DOS_H
  printf("#define DK3_HAVE_DOS_H 1\n");
#else
  printf("#define DK3_HAVE_DOS_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ENDGRENT\n");
  printf("/**\tDK3 version of HAVE_ENDGRENT.\n*/\n");
#if HAVE_ENDGRENT
  printf("#define DK3_HAVE_ENDGRENT 1\n");
#else
  printf("#define DK3_HAVE_ENDGRENT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ENDPWENT\n");
  printf("/**\tDK3 version of HAVE_ENDPWENT.\n*/\n");
#if HAVE_ENDPWENT
  printf("#define DK3_HAVE_ENDPWENT 1\n");
#else
  printf("#define DK3_HAVE_ENDPWENT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ERRNO_H\n");
  printf("/**\tDK3 version of HAVE_ERRNO_H.\n*/\n");
#if HAVE_ERRNO_H
  printf("#define DK3_HAVE_ERRNO_H 1\n");
#else
  printf("#define DK3_HAVE_ERRNO_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ERR_H\n");
  printf("/**\tDK3 version of HAVE_ERR_H.\n*/\n");
#if HAVE_ERR_H
  printf("#define DK3_HAVE_ERR_H 1\n");
#else
  printf("#define DK3_HAVE_ERR_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_EXPL\n");
  printf("/**\tDK3 version of HAVE_EXPL.\n*/\n");
#if HAVE_EXPL
  printf("#define DK3_HAVE_EXPL 1\n");
#else
  printf("#define DK3_HAVE_EXPL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FABS\n");
  printf("/**\tDK3 version of HAVE_FABS.\n*/\n");
#if HAVE_FABS
  printf("#define DK3_HAVE_FABS 1\n");
#else
  printf("#define DK3_HAVE_FABS 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FABSL\n");
  printf("/**\tDK3 version of HAVE_FABSL.\n*/\n");
#if HAVE_FABSL
  printf("#define DK3_HAVE_FABSL 1\n");
#else
  printf("#define DK3_HAVE_FABSL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FCLOSE\n");
  printf("/**\tDK3 version of HAVE_FCLOSE.\n*/\n");
#if HAVE_FCLOSE
  printf("#define DK3_HAVE_FCLOSE 1\n");
#else
  printf("#define DK3_HAVE_FCLOSE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FCNTL_H\n");
  printf("/**\tDK3 version of HAVE_FCNTL_H.\n*/\n");
#if HAVE_FCNTL_H
  printf("#define DK3_HAVE_FCNTL_H 1\n");
#else
  printf("#define DK3_HAVE_FCNTL_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FENV_H\n");
  printf("/**\tDK3 version of HAVE_FENV_H.\n*/\n");
#if HAVE_FENV_H
  printf("#define DK3_HAVE_FENV_H 1\n");
#else
  printf("#define DK3_HAVE_FENV_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FEOF\n");
  printf("/**\tDK3 version of HAVE_FEOF.\n*/\n");
#if HAVE_FEOF
  printf("#define DK3_HAVE_FEOF 1\n");
#else
  printf("#define DK3_HAVE_FEOF 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FERROR\n");
  printf("/**\tDK3 version of HAVE_FERROR.\n*/\n");
#if HAVE_FERROR
  printf("#define DK3_HAVE_FERROR 1\n");
#else
  printf("#define DK3_HAVE_FERROR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FETESTEXCEPT\n");
  printf("/**\tDK3 version of HAVE_FETESTEXCEPT.\n*/\n");
#if HAVE_FETESTEXCEPT
  printf("#define DK3_HAVE_FETESTEXCEPT 1\n");
#else
  printf("#define DK3_HAVE_FETESTEXCEPT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FFLUSH\n");
  printf("/**\tDK3 version of HAVE_FFLUSH.\n*/\n");
#if HAVE_FFLUSH
  printf("#define DK3_HAVE_FFLUSH 1\n");
#else
  printf("#define DK3_HAVE_FFLUSH 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FLOAT_H\n");
  printf("/**\tDK3 version of HAVE_FLOAT_H.\n*/\n");
#if HAVE_FLOAT_H
  printf("#define DK3_HAVE_FLOAT_H 1\n");
#else
  printf("#define DK3_HAVE_FLOAT_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FLOOR\n");
  printf("/**\tDK3 version of HAVE_FLOOR.\n*/\n");
#if HAVE_FLOOR
  printf("#define DK3_HAVE_FLOOR 1\n");
#else
  printf("#define DK3_HAVE_FLOOR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FLOORL\n");
  printf("/**\tDK3 version of HAVE_FLOORL.\n*/\n");
#if HAVE_FLOORL
  printf("#define DK3_HAVE_FLOORL 1\n");
#else
  printf("#define DK3_HAVE_FLOORL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FNCASEINS\n");
  printf("/**\tDK3 version of HAVE_FNCASEINS.\n*/\n");
#if HAVE_FNCASEINS
  printf("#define DK3_HAVE_FNCASEINS 1\n");
#else
  printf("#define DK3_HAVE_FNCASEINS 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FOPEN\n");
  printf("/**\tDK3 version of HAVE_FOPEN.\n*/\n");
#if HAVE_FOPEN
  printf("#define DK3_HAVE_FOPEN 1\n");
#else
  printf("#define DK3_HAVE_FOPEN 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FOPEN64\n");
  printf("/**\tDK3 version of HAVE_FOPEN64.\n*/\n");
#if HAVE_FOPEN64
  printf("#define DK3_HAVE_FOPEN64 1\n");
#else
  printf("#define DK3_HAVE_FOPEN64 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FORK\n");
  printf("/**\tDK3 version of HAVE_FORK.\n*/\n");
#if HAVE_FORK
  printf("#define DK3_HAVE_FORK 1\n");
#else
  printf("#define DK3_HAVE_FORK 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FPCLASSIFY\n");
  printf("/**\tDK3 version of HAVE_FPCLASSIFY.\n*/\n");
#if HAVE_FPCLASSIFY
  printf("#define DK3_HAVE_FPCLASSIFY 1\n");
#else
  printf("#define DK3_HAVE_FPCLASSIFY 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FREAD\n");
  printf("/**\tDK3 version of HAVE_FREAD.\n*/\n");
#if HAVE_FREAD
  printf("#define DK3_HAVE_FREAD 1\n");
#else
  printf("#define DK3_HAVE_FREAD 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FREE\n");
  printf("/**\tDK3 version of HAVE_FREE.\n*/\n");
#if HAVE_FREE
  printf("#define DK3_HAVE_FREE 1\n");
#else
  printf("#define DK3_HAVE_FREE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_FWRITE\n");
  printf("/**\tDK3 version of HAVE_FWRITE.\n*/\n");
#if HAVE_FWRITE
  printf("#define DK3_HAVE_FWRITE 1\n");
#else
  printf("#define DK3_HAVE_FWRITE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GDBM_H\n");
  printf("/**\tDK3 version of HAVE_GDBM_H.\n*/\n");
#if HAVE_GDBM_H
  printf("#define DK3_HAVE_GDBM_H 1\n");
#else
  printf("#define DK3_HAVE_GDBM_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETADDRINFO\n");
  printf("/**\tDK3 version of HAVE_GETADDRINFO.\n*/\n");
#if HAVE_GETADDRINFO
  printf("#define DK3_HAVE_GETADDRINFO 1\n");
#else
  printf("#define DK3_HAVE_GETADDRINFO 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETCWD\n");
  printf("/**\tDK3 version of HAVE_GETCWD.\n*/\n");
#if HAVE_GETCWD
  printf("#define DK3_HAVE_GETCWD 1\n");
#else
  printf("#define DK3_HAVE_GETCWD 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETENV\n");
  printf("/**\tDK3 version of HAVE_GETENV.\n*/\n");
#if HAVE_GETENV
  printf("#define DK3_HAVE_GETENV 1\n");
#else
  printf("#define DK3_HAVE_GETENV 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETEUID\n");
  printf("/**\tDK3 version of HAVE_GETEUID.\n*/\n");
#if HAVE_GETEUID
  printf("#define DK3_HAVE_GETEUID 1\n");
#else
  printf("#define DK3_HAVE_GETEUID 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETGRENT\n");
  printf("/**\tDK3 version of HAVE_GETGRENT.\n*/\n");
#if HAVE_GETGRENT
  printf("#define DK3_HAVE_GETGRENT 1\n");
#else
  printf("#define DK3_HAVE_GETGRENT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETGRGID\n");
  printf("/**\tDK3 version of HAVE_GETGRGID.\n*/\n");
#if HAVE_GETGRGID
  printf("#define DK3_HAVE_GETGRGID 1\n");
#else
  printf("#define DK3_HAVE_GETGRGID 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETGRNAM\n");
  printf("/**\tDK3 version of HAVE_GETGRNAM.\n*/\n");
#if HAVE_GETGRNAM
  printf("#define DK3_HAVE_GETGRNAM 1\n");
#else
  printf("#define DK3_HAVE_GETGRNAM 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETHOSTBYNAME\n");
  printf("/**\tDK3 version of HAVE_GETHOSTBYNAME.\n*/\n");
#if HAVE_GETHOSTBYNAME
  printf("#define DK3_HAVE_GETHOSTBYNAME 1\n");
#else
  printf("#define DK3_HAVE_GETHOSTBYNAME 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETHOSTNAME\n");
  printf("/**\tDK3 version of HAVE_GETHOSTNAME.\n*/\n");
#if HAVE_GETHOSTNAME
  printf("#define DK3_HAVE_GETHOSTNAME 1\n");
#else
  printf("#define DK3_HAVE_GETHOSTNAME 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETPEERNAME\n");
  printf("/**\tDK3 version of HAVE_GETPEERNAME.\n*/\n");
#if HAVE_GETPEERNAME
  printf("#define DK3_HAVE_GETPEERNAME 1\n");
#else
  printf("#define DK3_HAVE_GETPEERNAME 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETPID\n");
  printf("/**\tDK3 version of HAVE_GETPID.\n*/\n");
#if HAVE_GETPID
  printf("#define DK3_HAVE_GETPID 1\n");
#else
  printf("#define DK3_HAVE_GETPID 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETPWENT\n");
  printf("/**\tDK3 version of HAVE_GETPWENT.\n*/\n");
#if HAVE_GETPWENT
  printf("#define DK3_HAVE_GETPWENT 1\n");
#else
  printf("#define DK3_HAVE_GETPWENT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETPWNAM\n");
  printf("/**\tDK3 version of HAVE_GETPWNAM.\n*/\n");
#if HAVE_GETPWNAM
  printf("#define DK3_HAVE_GETPWNAM 1\n");
#else
  printf("#define DK3_HAVE_GETPWNAM 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETPWUID\n");
  printf("/**\tDK3 version of HAVE_GETPWUID.\n*/\n");
#if HAVE_GETPWUID
  printf("#define DK3_HAVE_GETPWUID 1\n");
#else
  printf("#define DK3_HAVE_GETPWUID 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETRLIMIT\n");
  printf("/**\tDK3 version of HAVE_GETRLIMIT.\n*/\n");
#if HAVE_GETRLIMIT
  printf("#define DK3_HAVE_GETRLIMIT 1\n");
#else
  printf("#define DK3_HAVE_GETRLIMIT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETSOCKNAME\n");
  printf("/**\tDK3 version of HAVE_GETSOCKNAME.\n*/\n");
#if HAVE_GETSOCKNAME
  printf("#define DK3_HAVE_GETSOCKNAME 1\n");
#else
  printf("#define DK3_HAVE_GETSOCKNAME 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GETUID\n");
  printf("/**\tDK3 version of HAVE_GETUID.\n*/\n");
#if HAVE_GETUID
  printf("#define DK3_HAVE_GETUID 1\n");
#else
  printf("#define DK3_HAVE_GETUID 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_GRP_H\n");
  printf("/**\tDK3 version of HAVE_GRP_H.\n*/\n");
#if HAVE_GRP_H
  printf("#define DK3_HAVE_GRP_H 1\n");
#else
  printf("#define DK3_HAVE_GRP_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_HTONL\n");
  printf("/**\tDK3 version of HAVE_HTONL.\n*/\n");
#if HAVE_HTONL
  printf("#define DK3_HAVE_HTONL 1\n");
#else
  printf("#define DK3_HAVE_HTONL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_IEEE_754_DOUBLE\n");
  printf("/**\tDK3 version of HAVE_IEEE_754_DOUBLE.\n*/\n");
#if HAVE_IEEE_754_DOUBLE
  printf("#define DK3_HAVE_IEEE_754_DOUBLE 1\n");
#else
  printf("#define DK3_HAVE_IEEE_754_DOUBLE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_IN6_ADDR\n");
  printf("/**\tDK3 version of HAVE_IN6_ADDR.\n*/\n");
#if HAVE_IN6_ADDR
  printf("#define DK3_HAVE_IN6_ADDR 1\n");
#else
  printf("#define DK3_HAVE_IN6_ADDR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INET_ADDR\n");
  printf("/**\tDK3 version of HAVE_INET_ADDR.\n*/\n");
#if HAVE_INET_ADDR
  printf("#define DK3_HAVE_INET_ADDR 1\n");
#else
  printf("#define DK3_HAVE_INET_ADDR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INET_ATON\n");
  printf("/**\tDK3 version of HAVE_INET_ATON.\n*/\n");
#if HAVE_INET_ATON
  printf("#define DK3_HAVE_INET_ATON 1\n");
#else
  printf("#define DK3_HAVE_INET_ATON 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INET_PTON\n");
  printf("/**\tDK3 version of HAVE_INET_PTON.\n*/\n");
#if HAVE_INET_PTON
  printf("#define DK3_HAVE_INET_PTON 1\n");
#else
  printf("#define DK3_HAVE_INET_PTON 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INITSTATE\n");
  printf("/**\tDK3 version of HAVE_INITSTATE.\n*/\n");
#if HAVE_INITSTATE
  printf("#define DK3_HAVE_INITSTATE 1\n");
#else
  printf("#define DK3_HAVE_INITSTATE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INODES\n");
  printf("/**\tDK3 version of HAVE_INODES.\n*/\n");
#if HAVE_INODES
  printf("#define DK3_HAVE_INODES 1\n");
#else
  printf("#define DK3_HAVE_INODES 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INTMAX_T\n");
  printf("/**\tDK3 version of HAVE_INTMAX_T.\n*/\n");
#if HAVE_INTMAX_T
  printf("#define DK3_HAVE_INTMAX_T 1\n");
#else
  printf("#define DK3_HAVE_INTMAX_T 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_INTTYPES_H\n");
  printf("/**\tDK3 version of HAVE_INTTYPES_H.\n*/\n");
#if HAVE_INTTYPES_H
  printf("#define DK3_HAVE_INTTYPES_H 1\n");
#else
  printf("#define DK3_HAVE_INTTYPES_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_IN_ADDR\n");
  printf("/**\tDK3 version of HAVE_IN_ADDR.\n*/\n");
#if HAVE_IN_ADDR
  printf("#define DK3_HAVE_IN_ADDR 1\n");
#else
  printf("#define DK3_HAVE_IN_ADDR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_IO_H\n");
  printf("/**\tDK3 version of HAVE_IO_H.\n*/\n");
#if HAVE_IO_H
  printf("#define DK3_HAVE_IO_H 1\n");
#else
  printf("#define DK3_HAVE_IO_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ISATTY\n");
  printf("/**\tDK3 version of HAVE_ISATTY.\n*/\n");
#if HAVE_ISATTY
  printf("#define DK3_HAVE_ISATTY 1\n");
#else
  printf("#define DK3_HAVE_ISATTY 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ISFINITE\n");
  printf("/**\tDK3 version of HAVE_ISFINITE.\n*/\n");
#if HAVE_ISFINITE
  printf("#define DK3_HAVE_ISFINITE 1\n");
#else
  printf("#define DK3_HAVE_ISFINITE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ISNORMAL\n");
  printf("/**\tDK3 version of HAVE_ISNORMAL.\n*/\n");
#if HAVE_ISNORMAL
  printf("#define DK3_HAVE_ISNORMAL 1\n");
#else
  printf("#define DK3_HAVE_ISNORMAL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_JPEGLIB_H\n");
  printf("/**\tDK3 version of HAVE_JPEGLIB_H.\n*/\n");
#if HAVE_JPEGLIB_H
  printf("#define DK3_HAVE_JPEGLIB_H 1\n");
#else
  printf("#define DK3_HAVE_JPEGLIB_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LABS\n");
  printf("/**\tDK3 version of HAVE_LABS.\n*/\n");
#if HAVE_LABS
  printf("#define DK3_HAVE_LABS 1\n");
#else
  printf("#define DK3_HAVE_LABS 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LARGEFILE64_SOURCE\n");
  printf("/**\tDK3 version of HAVE_LARGEFILE64_SOURCE.\n*/\n");
#if HAVE_LARGEFILE64_SOURCE
  printf("#define DK3_HAVE_LARGEFILE64_SOURCE 1\n");
#else
  printf("#define DK3_HAVE_LARGEFILE64_SOURCE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LIBNETSNMP\n");
  printf("/**\tDK3 version of HAVE_LIBNETSNMP.\n*/\n");
#if HAVE_LIBNETSNMP
  printf("#define DK3_HAVE_LIBNETSNMP 1\n");
#else
  printf("#define DK3_HAVE_LIBNETSNMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LIMITS_H\n");
  printf("/**\tDK3 version of HAVE_LIMITS_H.\n*/\n");
#if HAVE_LIMITS_H
  printf("#define DK3_HAVE_LIMITS_H 1\n");
#else
  printf("#define DK3_HAVE_LIMITS_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LOCALE_H\n");
  printf("/**\tDK3 version of HAVE_LOCALE_H.\n*/\n");
#if HAVE_LOCALE_H
  printf("#define DK3_HAVE_LOCALE_H 1\n");
#else
  printf("#define DK3_HAVE_LOCALE_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LOCALTIME\n");
  printf("/**\tDK3 version of HAVE_LOCALTIME.\n*/\n");
#if HAVE_LOCALTIME
  printf("#define DK3_HAVE_LOCALTIME 1\n");
#else
  printf("#define DK3_HAVE_LOCALTIME 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LOCALTIME\n");
  printf("/**\tDK3 version of HAVE_LOCALTIME.\n*/\n");
#if HAVE_LOCALTIME
  printf("#define DK3_HAVE_LOCALTIME 1\n");
#else
  printf("#define DK3_HAVE_LOCALTIME 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LOCALTIME_R\n");
  printf("/**\tDK3 version of HAVE_LOCALTIME_R.\n*/\n");
#if HAVE_LOCALTIME_R
  printf("#define DK3_HAVE_LOCALTIME_R 1\n");
#else
  printf("#define DK3_HAVE_LOCALTIME_R 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LOGL\n");
  printf("/**\tDK3 version of HAVE_LOGL.\n*/\n");
#if HAVE_LOGL
  printf("#define DK3_HAVE_LOGL 1\n");
#else
  printf("#define DK3_HAVE_LOGL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LONG_DOUBLE\n");
  printf("/**\tDK3 version of HAVE_LONG_DOUBLE.\n*/\n");
#if HAVE_LONG_DOUBLE
  printf("#define DK3_HAVE_LONG_DOUBLE 1\n");
#else
  printf("#define DK3_HAVE_LONG_DOUBLE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LONG_LONG\n");
  printf("/**\tDK3 version of HAVE_LONG_LONG.\n*/\n");
#if HAVE_LONG_LONG
  printf("#define DK3_HAVE_LONG_LONG 1\n");
#else
  printf("#define DK3_HAVE_LONG_LONG 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LPRNG_H\n");
  printf("/**\tDK3 version of HAVE_LPRNG_H.\n*/\n");
#if HAVE_LPRNG_H
  printf("#define DK3_HAVE_LPRNG_H 1\n");
#else
  printf("#define DK3_HAVE_LPRNG_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LRAND48\n");
  printf("/**\tDK3 version of HAVE_LRAND48.\n*/\n");
#if HAVE_LRAND48
  printf("#define DK3_HAVE_LRAND48 1\n");
#else
  printf("#define DK3_HAVE_LRAND48 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LSTAT\n");
  printf("/**\tDK3 version of HAVE_LSTAT.\n*/\n");
#if HAVE_LSTAT
  printf("#define DK3_HAVE_LSTAT 1\n");
#else
  printf("#define DK3_HAVE_LSTAT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LSTAT32\n");
  printf("/**\tDK3 version of HAVE_LSTAT32.\n*/\n");
#if HAVE_LSTAT32
  printf("#define DK3_HAVE_LSTAT32 1\n");
#else
  printf("#define DK3_HAVE_LSTAT32 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_LSTAT64\n");
  printf("/**\tDK3 version of HAVE_LSTAT64.\n*/\n");
#if HAVE_LSTAT64
  printf("#define DK3_HAVE_LSTAT64 1\n");
#else
  printf("#define DK3_HAVE_LSTAT64 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MALLOC\n");
  printf("/**\tDK3 version of HAVE_MALLOC.\n*/\n");
#if HAVE_MALLOC
  printf("#define DK3_HAVE_MALLOC 1\n");
#else
  printf("#define DK3_HAVE_MALLOC 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MALLOC_H\n");
  printf("/**\tDK3 version of HAVE_MALLOC_H.\n*/\n");
#if HAVE_MALLOC_H
  printf("#define DK3_HAVE_MALLOC_H 1\n");
#else
  printf("#define DK3_HAVE_MALLOC_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MATH_H\n");
  printf("/**\tDK3 version of HAVE_MATH_H.\n*/\n");
#if HAVE_MATH_H
  printf("#define DK3_HAVE_MATH_H 1\n");
#else
  printf("#define DK3_HAVE_MATH_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MEMCMP\n");
  printf("/**\tDK3 version of HAVE_MEMCMP.\n*/\n");
#if HAVE_MEMCMP
  printf("#define DK3_HAVE_MEMCMP 1\n");
#else
  printf("#define DK3_HAVE_MEMCMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MEMCPY\n");
  printf("/**\tDK3 version of HAVE_MEMCPY.\n*/\n");
#if HAVE_MEMCPY
  printf("#define DK3_HAVE_MEMCPY 1\n");
#else
  printf("#define DK3_HAVE_MEMCPY 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MEMSET\n");
  printf("/**\tDK3 version of HAVE_MEMSET.\n*/\n");
#if HAVE_MEMSET
  printf("#define DK3_HAVE_MEMSET 1\n");
#else
  printf("#define DK3_HAVE_MEMSET 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MKDIR\n");
  printf("/**\tDK3 version of HAVE_MKDIR.\n*/\n");
#if HAVE_MKDIR
  printf("#define DK3_HAVE_MKDIR 1\n");
#else
  printf("#define DK3_HAVE_MKDIR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MKDIR2\n");
  printf("/**\tDK3 version of HAVE_MKDIR2.\n*/\n");
#if HAVE_MKDIR2
  printf("#define DK3_HAVE_MKDIR2 1\n");
#else
  printf("#define DK3_HAVE_MKDIR2 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MPCTL\n");
  printf("/**\tDK3 version of HAVE_MPCTL.\n*/\n");
#if HAVE_MPCTL
  printf("#define DK3_HAVE_MPCTL 1\n");
#else
  printf("#define DK3_HAVE_MPCTL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MYSQL_LIBRARY_END\n");
  printf("/**\tDK3 version of HAVE_MYSQL_LIBRARY_END.\n*/\n");
#if HAVE_MYSQL_LIBRARY_END
  printf("#define DK3_HAVE_MYSQL_LIBRARY_END 1\n");
#else
  printf("#define DK3_HAVE_MYSQL_LIBRARY_END 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MYSQL_LIBRARY_INIT\n");
  printf("/**\tDK3 version of HAVE_MYSQL_LIBRARY_INIT.\n*/\n");
#if HAVE_MYSQL_LIBRARY_INIT
  printf("#define DK3_HAVE_MYSQL_LIBRARY_INIT 1\n");
#else
  printf("#define DK3_HAVE_MYSQL_LIBRARY_INIT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MYSQL_MYSQL_H\n");
  printf("/**\tDK3 version of HAVE_MYSQL_MYSQL_H.\n*/\n");
#if HAVE_MYSQL_MYSQL_H
  printf("#define DK3_HAVE_MYSQL_MYSQL_H 1\n");
#else
  printf("#define DK3_HAVE_MYSQL_MYSQL_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_MYSQL_SET_CHARACTER_SET\n");
  printf("/**\tDK3 version of HAVE_MYSQL_SET_CHARACTER_SET.\n*/\n");
#if HAVE_MYSQL_SET_CHARACTER_SET
  printf("#define DK3_HAVE_MYSQL_SET_CHARACTER_SET 1\n");
#else
  printf("#define DK3_HAVE_MYSQL_SET_CHARACTER_SET 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_NDBM_H\n");
  printf("/**\tDK3 version of HAVE_NDBM_H.\n*/\n");
#if HAVE_NDBM_H
  printf("#define DK3_HAVE_NDBM_H 1\n");
#else
  printf("#define DK3_HAVE_NDBM_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_NETDB_H\n");
  printf("/**\tDK3 version of HAVE_NETDB_H.\n*/\n");
#if HAVE_NETDB_H
  printf("#define DK3_HAVE_NETDB_H 1\n");
#else
  printf("#define DK3_HAVE_NETDB_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_NETINET_IN_H\n");
  printf("/**\tDK3 version of HAVE_NETINET_IN_H.\n*/\n");
#if HAVE_NETINET_IN_H
  printf("#define DK3_HAVE_NETINET_IN_H 1\n");
#else
  printf("#define DK3_HAVE_NETINET_IN_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_NETSNMP_ENABLE_FILELOG\n");
  printf("/**\tDK3 version of HAVE_NETSNMP_ENABLE_FILELOG.\n*/\n");
#if HAVE_NETSNMP_ENABLE_FILELOG
  printf("#define DK3_HAVE_NETSNMP_ENABLE_FILELOG 1\n");
#else
  printf("#define DK3_HAVE_NETSNMP_ENABLE_FILELOG 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_NRAND48\n");
  printf("/**\tDK3 version of HAVE_NRAND48.\n*/\n");
#if HAVE_NRAND48
  printf("#define DK3_HAVE_NRAND48 1\n");
#else
  printf("#define DK3_HAVE_NRAND48 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_OPENDIR\n");
  printf("/**\tDK3 version of HAVE_OPENDIR.\n*/\n");
#if HAVE_OPENDIR
  printf("#define DK3_HAVE_OPENDIR 1\n");
#else
  printf("#define DK3_HAVE_OPENDIR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_OPENSSL_MD5_H\n");
  printf("/**\tDK3 version of HAVE_OPENSSL_MD5_H.\n*/\n");
#if HAVE_OPENSSL_MD5_H
  printf("#define DK3_HAVE_OPENSSL_MD5_H 1\n");
#else
  printf("#define DK3_HAVE_OPENSSL_MD5_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_OPENSSL_RAND_H\n");
  printf("/**\tDK3 version of HAVE_OPENSSL_RAND_H.\n*/\n");
#if HAVE_OPENSSL_RAND_H
  printf("#define DK3_HAVE_OPENSSL_RAND_H 1\n");
#else
  printf("#define DK3_HAVE_OPENSSL_RAND_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_OPENSSL_RIPEMD_H\n");
  printf("/**\tDK3 version of HAVE_OPENSSL_RIPEMD_H.\n*/\n");
#if HAVE_OPENSSL_RIPEMD_H
  printf("#define DK3_HAVE_OPENSSL_RIPEMD_H 1\n");
#else
  printf("#define DK3_HAVE_OPENSSL_RIPEMD_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_OPENSSL_SHA_H\n");
  printf("/**\tDK3 version of HAVE_OPENSSL_SHA_H.\n*/\n");
#if HAVE_OPENSSL_SHA_H
  printf("#define DK3_HAVE_OPENSSL_SHA_H 1\n");
#else
  printf("#define DK3_HAVE_OPENSSL_SHA_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_PNG_GET_PIXELS_PER_INCH\n");
  printf("/**\tDK3 version of HAVE_PNG_GET_PIXELS_PER_INCH.\n*/\n");
#if HAVE_PNG_GET_PIXELS_PER_INCH
  printf("#define DK3_HAVE_PNG_GET_PIXELS_PER_INCH 1\n");
#else
  printf("#define DK3_HAVE_PNG_GET_PIXELS_PER_INCH 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_PNG_H\n");
  printf("/**\tDK3 version of HAVE_PNG_H.\n*/\n");
#if HAVE_PNG_H
  printf("#define DK3_HAVE_PNG_H 1\n");
#else
  printf("#define DK3_HAVE_PNG_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_POPEN\n");
  printf("/**\tDK3 version of HAVE_POPEN.\n*/\n");
#if HAVE_POPEN
  printf("#define DK3_HAVE_POPEN 1\n");
#else
  printf("#define DK3_HAVE_POPEN 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_PROCESS_H\n");
  printf("/**\tDK3 version of HAVE_PROCESS_H.\n*/\n");
#if HAVE_PROCESS_H
  printf("#define DK3_HAVE_PROCESS_H 1\n");
#else
  printf("#define DK3_HAVE_PROCESS_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_PTHREAD_H\n");
  printf("/**\tDK3 version of HAVE_PTHREAD_H.\n*/\n");
#if HAVE_PTHREAD_H
  printf("#define DK3_HAVE_PTHREAD_H 1\n");
#else
  printf("#define DK3_HAVE_PTHREAD_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_PWD_H\n");
  printf("/**\tDK3 version of HAVE_PWD_H.\n*/\n");
#if HAVE_PWD_H
  printf("#define DK3_HAVE_PWD_H 1\n");
#else
  printf("#define DK3_HAVE_PWD_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RAND\n");
  printf("/**\tDK3 version of HAVE_RAND.\n*/\n");
#if HAVE_RAND
  printf("#define DK3_HAVE_RAND 1\n");
#else
  printf("#define DK3_HAVE_RAND 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RANDOM\n");
  printf("/**\tDK3 version of HAVE_RANDOM.\n*/\n");
#if HAVE_RANDOM
  printf("#define DK3_HAVE_RANDOM 1\n");
#else
  printf("#define DK3_HAVE_RANDOM 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_READ\n");
  printf("/**\tDK3 version of HAVE_READ.\n*/\n");
#if HAVE_READ
  printf("#define DK3_HAVE_READ 1\n");
#else
  printf("#define DK3_HAVE_READ 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_READDIR\n");
  printf("/**\tDK3 version of HAVE_READDIR.\n*/\n");
#if HAVE_READDIR
  printf("#define DK3_HAVE_READDIR 1\n");
#else
  printf("#define DK3_HAVE_READDIR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RFC_2249\n");
  printf("/**\tDK3 version of HAVE_RFC_2249.\n*/\n");
#if HAVE_RFC_2249
  printf("#define DK3_HAVE_RFC_2249 1\n");
#else
  printf("#define DK3_HAVE_RFC_2249 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RINT\n");
  printf("/**\tDK3 version of HAVE_RINT.\n*/\n");
#if HAVE_RINT
  printf("#define DK3_HAVE_RINT 1\n");
#else
  printf("#define DK3_HAVE_RINT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RINTL\n");
  printf("/**\tDK3 version of HAVE_RINTL.\n*/\n");
#if HAVE_RINTL
  printf("#define DK3_HAVE_RINTL 1\n");
#else
  printf("#define DK3_HAVE_RINTL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_RMDIR\n");
  printf("/**\tDK3 version of HAVE_RMDIR.\n*/\n");
#if HAVE_RMDIR
  printf("#define DK3_HAVE_RMDIR 1\n");
#else
  printf("#define DK3_HAVE_RMDIR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SEED48\n");
  printf("/**\tDK3 version of HAVE_SEED48.\n*/\n");
#if HAVE_SEED48
  printf("#define DK3_HAVE_SEED48 1\n");
#else
  printf("#define DK3_HAVE_SEED48 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SELECT\n");
  printf("/**\tDK3 version of HAVE_SELECT.\n*/\n");
#if HAVE_SELECT
  printf("#define DK3_HAVE_SELECT 1\n");
#else
  printf("#define DK3_HAVE_SELECT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETGID\n");
  printf("/**\tDK3 version of HAVE_SETGID.\n*/\n");
#if HAVE_SETGID
  printf("#define DK3_HAVE_SETGID 1\n");
#else
  printf("#define DK3_HAVE_SETGID 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETGRENT\n");
  printf("/**\tDK3 version of HAVE_SETGRENT.\n*/\n");
#if HAVE_SETGRENT
  printf("#define DK3_HAVE_SETGRENT 1\n");
#else
  printf("#define DK3_HAVE_SETGRENT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETJMP_H\n");
  printf("/**\tDK3 version of HAVE_SETJMP_H.\n*/\n");
#if HAVE_SETJMP_H
  printf("#define DK3_HAVE_SETJMP_H 1\n");
#else
  printf("#define DK3_HAVE_SETJMP_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETLOCALE\n");
  printf("/**\tDK3 version of HAVE_SETLOCALE.\n*/\n");
#if HAVE_SETLOCALE
  printf("#define DK3_HAVE_SETLOCALE 1\n");
#else
  printf("#define DK3_HAVE_SETLOCALE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETPGRP\n");
  printf("/**\tDK3 version of HAVE_SETPGRP.\n*/\n");
#if HAVE_SETPGRP
  printf("#define DK3_HAVE_SETPGRP 1\n");
#else
  printf("#define DK3_HAVE_SETPGRP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETPWENT\n");
  printf("/**\tDK3 version of HAVE_SETPWENT.\n*/\n");
#if HAVE_SETPWENT
  printf("#define DK3_HAVE_SETPWENT 1\n");
#else
  printf("#define DK3_HAVE_SETPWENT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETSID\n");
  printf("/**\tDK3 version of HAVE_SETSID.\n*/\n");
#if HAVE_SETSID
  printf("#define DK3_HAVE_SETSID 1\n");
#else
  printf("#define DK3_HAVE_SETSID 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETSOCKOPT\n");
  printf("/**\tDK3 version of HAVE_SETSOCKOPT.\n*/\n");
#if HAVE_SETSOCKOPT
  printf("#define DK3_HAVE_SETSOCKOPT 1\n");
#else
  printf("#define DK3_HAVE_SETSOCKOPT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETSTATE\n");
  printf("/**\tDK3 version of HAVE_SETSTATE.\n*/\n");
#if HAVE_SETSTATE
  printf("#define DK3_HAVE_SETSTATE 1\n");
#else
  printf("#define DK3_HAVE_SETSTATE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SETUID\n");
  printf("/**\tDK3 version of HAVE_SETUID.\n*/\n");
#if HAVE_SETUID
  printf("#define DK3_HAVE_SETUID 1\n");
#else
  printf("#define DK3_HAVE_SETUID 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SHA224\n");
  printf("/**\tDK3 version of HAVE_SHA224.\n*/\n");
#if HAVE_SHA224
  printf("#define DK3_HAVE_SHA224 1\n");
#else
  printf("#define DK3_HAVE_SHA224 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SHA256\n");
  printf("/**\tDK3 version of HAVE_SHA256.\n*/\n");
#if HAVE_SHA256
  printf("#define DK3_HAVE_SHA256 1\n");
#else
  printf("#define DK3_HAVE_SHA256 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SHA384\n");
  printf("/**\tDK3 version of HAVE_SHA384.\n*/\n");
#if HAVE_SHA384
  printf("#define DK3_HAVE_SHA384 1\n");
#else
  printf("#define DK3_HAVE_SHA384 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SHA512\n");
  printf("/**\tDK3 version of HAVE_SHA512.\n*/\n");
#if HAVE_SHA512
  printf("#define DK3_HAVE_SHA512 1\n");
#else
  printf("#define DK3_HAVE_SHA512 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SHADOW_H\n");
  printf("/**\tDK3 version of HAVE_SHADOW_H.\n*/\n");
#if HAVE_SHADOW_H
  printf("#define DK3_HAVE_SHADOW_H 1\n");
#else
  printf("#define DK3_HAVE_SHADOW_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SIGACTION\n");
  printf("/**\tDK3 version of HAVE_SIGACTION.\n*/\n");
#if HAVE_SIGACTION
  printf("#define DK3_HAVE_SIGACTION 1\n");
#else
  printf("#define DK3_HAVE_SIGACTION 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SIGNAL\n");
  printf("/**\tDK3 version of HAVE_SIGNAL.\n*/\n");
#if HAVE_SIGNAL
  printf("#define DK3_HAVE_SIGNAL 1\n");
#else
  printf("#define DK3_HAVE_SIGNAL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SIGNAL_H\n");
  printf("/**\tDK3 version of HAVE_SIGNAL_H.\n*/\n");
#if HAVE_SIGNAL_H
  printf("#define DK3_HAVE_SIGNAL_H 1\n");
#else
  printf("#define DK3_HAVE_SIGNAL_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SIGSET\n");
  printf("/**\tDK3 version of HAVE_SIGSET.\n*/\n");
#if HAVE_SIGSET
  printf("#define DK3_HAVE_SIGSET 1\n");
#else
  printf("#define DK3_HAVE_SIGSET 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SIG_ATOMIC_T\n");
  printf("/**\tDK3 version of HAVE_SIG_ATOMIC_T.\n*/\n");
#if HAVE_SIG_ATOMIC_T
  printf("#define DK3_HAVE_SIG_ATOMIC_T 1\n");
#else
  printf("#define DK3_HAVE_SIG_ATOMIC_T 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SINHL\n");
  printf("/**\tDK3 version of HAVE_SINHL.\n*/\n");
#if HAVE_SINHL
  printf("#define DK3_HAVE_SINHL 1\n");
#else
  printf("#define DK3_HAVE_SINHL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SINL\n");
  printf("/**\tDK3 version of HAVE_SINL.\n*/\n");
#if HAVE_SINL
  printf("#define DK3_HAVE_SINL 1\n");
#else
  printf("#define DK3_HAVE_SINL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SNPRINTF\n");
  printf("/**\tDK3 version of HAVE_SNPRINTF.\n*/\n");
#if HAVE_SNPRINTF
  printf("#define DK3_HAVE_SNPRINTF 1\n");
#else
  printf("#define DK3_HAVE_SNPRINTF 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SOCKET\n");
  printf("/**\tDK3 version of HAVE_SOCKET.\n*/\n");
#if HAVE_SOCKET
  printf("#define DK3_HAVE_SOCKET 1\n");
#else
  printf("#define DK3_HAVE_SOCKET 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SOCKLEN_T\n");
  printf("/**\tDK3 version of HAVE_SOCKLEN_T.\n*/\n");
#if HAVE_SOCKLEN_T
  printf("#define DK3_HAVE_SOCKLEN_T 1\n");
#else
  printf("#define DK3_HAVE_SOCKLEN_T 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SQRTL\n");
  printf("/**\tDK3 version of HAVE_SQRTL.\n*/\n");
#if HAVE_SQRTL
  printf("#define DK3_HAVE_SQRTL 1\n");
#else
  printf("#define DK3_HAVE_SQRTL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SRAND\n");
  printf("/**\tDK3 version of HAVE_SRAND.\n*/\n");
#if HAVE_SRAND
  printf("#define DK3_HAVE_SRAND 1\n");
#else
  printf("#define DK3_HAVE_SRAND 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SSIZE_T\n");
  printf("/**\tDK3 version of HAVE_SSIZE_T.\n*/\n");
#if HAVE_SSIZE_T
  printf("#define DK3_HAVE_SSIZE_T 1\n");
#else
  printf("#define DK3_HAVE_SSIZE_T 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STAT\n");
  printf("/**\tDK3 version of HAVE_STAT.\n*/\n");
#if HAVE_STAT
  printf("#define DK3_HAVE_STAT 1\n");
#else
  printf("#define DK3_HAVE_STAT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STAT32\n");
  printf("/**\tDK3 version of HAVE_STAT32.\n*/\n");
#if HAVE_STAT32
  printf("#define DK3_HAVE_STAT32 1\n");
#else
  printf("#define DK3_HAVE_STAT32 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STAT64\n");
  printf("/**\tDK3 version of HAVE_STAT64.\n*/\n");
#if HAVE_STAT64
  printf("#define DK3_HAVE_STAT64 1\n");
#else
  printf("#define DK3_HAVE_STAT64 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STDARG_H\n");
  printf("/**\tDK3 version of HAVE_STDARG_H.\n*/\n");
#if HAVE_STDARG_H
  printf("#define DK3_HAVE_STDARG_H 1\n");
#else
  printf("#define DK3_HAVE_STDARG_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STDDEF_H\n");
  printf("/**\tDK3 version of HAVE_STDDEF_H.\n*/\n");
#if HAVE_STDDEF_H
  printf("#define DK3_HAVE_STDDEF_H 1\n");
#else
  printf("#define DK3_HAVE_STDDEF_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STDINT_H\n");
  printf("/**\tDK3 version of HAVE_STDINT_H.\n*/\n");
#if HAVE_STDINT_H
  printf("#define DK3_HAVE_STDINT_H 1\n");
#else
  printf("#define DK3_HAVE_STDINT_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STDIO_H\n");
  printf("/**\tDK3 version of HAVE_STDIO_H.\n*/\n");
#if HAVE_STDIO_H
  printf("#define DK3_HAVE_STDIO_H 1\n");
#else
  printf("#define DK3_HAVE_STDIO_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STDLIB_H\n");
  printf("/**\tDK3 version of HAVE_STDLIB_H.\n*/\n");
#if HAVE_STDLIB_H
  printf("#define DK3_HAVE_STDLIB_H 1\n");
#else
  printf("#define DK3_HAVE_STDLIB_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRCASECMP\n");
  printf("/**\tDK3 version of HAVE_STRCASECMP.\n*/\n");
#if HAVE_STRCASECMP
  printf("#define DK3_HAVE_STRCASECMP 1\n");
#else
  printf("#define DK3_HAVE_STRCASECMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRCAT\n");
  printf("/**\tDK3 version of HAVE_STRCAT.\n*/\n");
#if HAVE_STRCAT
  printf("#define DK3_HAVE_STRCAT 1\n");
#else
  printf("#define DK3_HAVE_STRCAT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRCHR\n");
  printf("/**\tDK3 version of HAVE_STRCHR.\n*/\n");
#if HAVE_STRCHR
  printf("#define DK3_HAVE_STRCHR 1\n");
#else
  printf("#define DK3_HAVE_STRCHR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRCMP\n");
  printf("/**\tDK3 version of HAVE_STRCMP.\n*/\n");
#if HAVE_STRCMP
  printf("#define DK3_HAVE_STRCMP 1\n");
#else
  printf("#define DK3_HAVE_STRCMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRCPY\n");
  printf("/**\tDK3 version of HAVE_STRCPY.\n*/\n");
#if HAVE_STRCPY
  printf("#define DK3_HAVE_STRCPY 1\n");
#else
  printf("#define DK3_HAVE_STRCPY 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRDUP\n");
  printf("/**\tDK3 version of HAVE_STRDUP.\n*/\n");
#if HAVE_STRDUP
  printf("#define DK3_HAVE_STRDUP 1\n");
#else
  printf("#define DK3_HAVE_STRDUP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRERROR\n");
  printf("/**\tDK3 version of HAVE_STRERROR.\n*/\n");
#if HAVE_STRERROR
  printf("#define DK3_HAVE_STRERROR 1\n");
#else
  printf("#define DK3_HAVE_STRERROR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRICMP\n");
  printf("/**\tDK3 version of HAVE_STRICMP.\n*/\n");
#if HAVE_STRICMP
  printf("#define DK3_HAVE_STRICMP 1\n");
#else
  printf("#define DK3_HAVE_STRICMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRINGS_H\n");
  printf("/**\tDK3 version of HAVE_STRINGS_H.\n*/\n");
#if HAVE_STRINGS_H
  printf("#define DK3_HAVE_STRINGS_H 1\n");
#else
  printf("#define DK3_HAVE_STRINGS_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRING_H\n");
  printf("/**\tDK3 version of HAVE_STRING_H.\n*/\n");
#if HAVE_STRING_H
  printf("#define DK3_HAVE_STRING_H 1\n");
#else
  printf("#define DK3_HAVE_STRING_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRLEN\n");
  printf("/**\tDK3 version of HAVE_STRLEN.\n*/\n");
#if HAVE_STRLEN
  printf("#define DK3_HAVE_STRLEN 1\n");
#else
  printf("#define DK3_HAVE_STRLEN 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRNCMP\n");
  printf("/**\tDK3 version of HAVE_STRNCMP.\n*/\n");
#if HAVE_STRNCMP
  printf("#define DK3_HAVE_STRNCMP 1\n");
#else
  printf("#define DK3_HAVE_STRNCMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRNCPY\n");
  printf("/**\tDK3 version of HAVE_STRNCPY.\n*/\n");
#if HAVE_STRNCPY
  printf("#define DK3_HAVE_STRNCPY 1\n");
#else
  printf("#define DK3_HAVE_STRNCPY 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STROPTS_H\n");
  printf("/**\tDK3 version of HAVE_STROPTS_H.\n*/\n");
#if HAVE_STROPTS_H
  printf("#define DK3_HAVE_STROPTS_H 1\n");
#else
  printf("#define DK3_HAVE_STROPTS_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRRCHR\n");
  printf("/**\tDK3 version of HAVE_STRRCHR.\n*/\n");
#if HAVE_STRRCHR
  printf("#define DK3_HAVE_STRRCHR 1\n");
#else
  printf("#define DK3_HAVE_STRRCHR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOD\n");
  printf("/**\tDK3 version of HAVE_STRTOD.\n*/\n");
#if HAVE_STRTOD
  printf("#define DK3_HAVE_STRTOD 1\n");
#else
  printf("#define DK3_HAVE_STRTOD 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOIMAX\n");
  printf("/**\tDK3 version of HAVE_STRTOIMAX.\n*/\n");
#if HAVE_STRTOIMAX
  printf("#define DK3_HAVE_STRTOIMAX 1\n");
#else
  printf("#define DK3_HAVE_STRTOIMAX 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOL\n");
  printf("/**\tDK3 version of HAVE_STRTOL.\n*/\n");
#if HAVE_STRTOL
  printf("#define DK3_HAVE_STRTOL 1\n");
#else
  printf("#define DK3_HAVE_STRTOL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOLL\n");
  printf("/**\tDK3 version of HAVE_STRTOLL.\n*/\n");
#if HAVE_STRTOLL
  printf("#define DK3_HAVE_STRTOLL 1\n");
#else
  printf("#define DK3_HAVE_STRTOLL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOUL\n");
  printf("/**\tDK3 version of HAVE_STRTOUL.\n*/\n");
#if HAVE_STRTOUL
  printf("#define DK3_HAVE_STRTOUL 1\n");
#else
  printf("#define DK3_HAVE_STRTOUL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOULL\n");
  printf("/**\tDK3 version of HAVE_STRTOULL.\n*/\n");
#if HAVE_STRTOULL
  printf("#define DK3_HAVE_STRTOULL 1\n");
#else
  printf("#define DK3_HAVE_STRTOULL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRTOUMAX\n");
  printf("/**\tDK3 version of HAVE_STRTOUMAX.\n*/\n");
#if HAVE_STRTOUMAX
  printf("#define DK3_HAVE_STRTOUMAX 1\n");
#else
  printf("#define DK3_HAVE_STRTOUMAX 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRUCT_ADDRINFO\n");
  printf("/**\tDK3 version of HAVE_STRUCT_ADDRINFO.\n*/\n");
#if HAVE_STRUCT_ADDRINFO
  printf("#define DK3_HAVE_STRUCT_ADDRINFO 1\n");
#else
  printf("#define DK3_HAVE_STRUCT_ADDRINFO 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRUCT_SOCKADDR_IN\n");
  printf("/**\tDK3 version of HAVE_STRUCT_SOCKADDR_IN.\n*/\n");
#if HAVE_STRUCT_SOCKADDR_IN
  printf("#define DK3_HAVE_STRUCT_SOCKADDR_IN 1\n");
#else
  printf("#define DK3_HAVE_STRUCT_SOCKADDR_IN 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRUCT_SOCKADDR_IN6\n");
  printf("/**\tDK3 version of HAVE_STRUCT_SOCKADDR_IN6.\n*/\n");
#if HAVE_STRUCT_SOCKADDR_IN6
  printf("#define DK3_HAVE_STRUCT_SOCKADDR_IN6 1\n");
#else
  printf("#define DK3_HAVE_STRUCT_SOCKADDR_IN6 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRUCT_SOCKADDR_STORAGE\n");
  printf("/**\tDK3 version of HAVE_STRUCT_SOCKADDR_STORAGE.\n*/\n");
#if HAVE_STRUCT_SOCKADDR_STORAGE
  printf("#define DK3_HAVE_STRUCT_SOCKADDR_STORAGE 1\n");
#else
  printf("#define DK3_HAVE_STRUCT_SOCKADDR_STORAGE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_STRUCT_SOCKADDR_UN\n");
  printf("/**\tDK3 version of HAVE_STRUCT_SOCKADDR_UN.\n*/\n");
#if HAVE_STRUCT_SOCKADDR_UN
  printf("#define DK3_HAVE_STRUCT_SOCKADDR_UN 1\n");
#else
  printf("#define DK3_HAVE_STRUCT_SOCKADDR_UN 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYSCONF\n");
  printf("/**\tDK3 version of HAVE_SYSCONF.\n*/\n");
#if HAVE_SYSCONF
  printf("#define DK3_HAVE_SYSCONF 1\n");
#else
  printf("#define DK3_HAVE_SYSCONF 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYSCTL\n");
  printf("/**\tDK3 version of HAVE_SYSCTL.\n*/\n");
#if HAVE_SYSCTL
  printf("#define DK3_HAVE_SYSCTL 1\n");
#else
  printf("#define DK3_HAVE_SYSCTL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYSLOG\n");
  printf("/**\tDK3 version of HAVE_SYSLOG.\n*/\n");
#if HAVE_SYSLOG
  printf("#define DK3_HAVE_SYSLOG 1\n");
#else
  printf("#define DK3_HAVE_SYSLOG 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYSLOG_H\n");
  printf("/**\tDK3 version of HAVE_SYSLOG_H.\n*/\n");
#if HAVE_SYSLOG_H
  printf("#define DK3_HAVE_SYSLOG_H 1\n");
#else
  printf("#define DK3_HAVE_SYSLOG_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYSRES_H\n");
  printf("/**\tDK3 version of HAVE_SYSRES_H.\n*/\n");
#if HAVE_SYSRES_H
  printf("#define DK3_HAVE_SYSRES_H 1\n");
#else
  printf("#define DK3_HAVE_SYSRES_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_FILE_H\n");
  printf("/**\tDK3 version of HAVE_SYS_FILE_H.\n*/\n");
#if HAVE_SYS_FILE_H
  printf("#define DK3_HAVE_SYS_FILE_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_FILE_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_PARAM_H\n");
  printf("/**\tDK3 version of HAVE_SYS_PARAM_H.\n*/\n");
#if HAVE_SYS_PARAM_H
  printf("#define DK3_HAVE_SYS_PARAM_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_PARAM_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_RESOURCE_H\n");
  printf("/**\tDK3 version of HAVE_SYS_RESOURCE_H.\n*/\n");
#if HAVE_SYS_RESOURCE_H
  printf("#define DK3_HAVE_SYS_RESOURCE_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_RESOURCE_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_SOCKET_H\n");
  printf("/**\tDK3 version of HAVE_SYS_SOCKET_H.\n*/\n");
#if HAVE_SYS_SOCKET_H
  printf("#define DK3_HAVE_SYS_SOCKET_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_SOCKET_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_STATVFS_H\n");
  printf("/**\tDK3 version of HAVE_SYS_STATVFS_H.\n*/\n");
#if HAVE_SYS_STATVFS_H
  printf("#define DK3_HAVE_SYS_STATVFS_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_STATVFS_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_STAT_H\n");
  printf("/**\tDK3 version of HAVE_SYS_STAT_H.\n*/\n");
#if HAVE_SYS_STAT_H
  printf("#define DK3_HAVE_SYS_STAT_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_STAT_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_STROPTS_H\n");
  printf("/**\tDK3 version of HAVE_SYS_STROPTS_H.\n*/\n");
#if HAVE_SYS_STROPTS_H
  printf("#define DK3_HAVE_SYS_STROPTS_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_STROPTS_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_SUNDDI_H\n");
  printf("/**\tDK3 version of HAVE_SYS_SUNDDI_H.\n*/\n");
#if HAVE_SYS_SUNDDI_H
  printf("#define DK3_HAVE_SYS_SUNDDI_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_SUNDDI_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_SYSCTL_H\n");
  printf("/**\tDK3 version of HAVE_SYS_SYSCTL_H.\n*/\n");
#if HAVE_SYS_SYSCTL_H
  printf("#define DK3_HAVE_SYS_SYSCTL_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_SYSCTL_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_SYSTEMINFO_H\n");
  printf("/**\tDK3 version of HAVE_SYS_SYSTEMINFO_H.\n*/\n");
#if HAVE_SYS_SYSTEMINFO_H
  printf("#define DK3_HAVE_SYS_SYSTEMINFO_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_SYSTEMINFO_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_TERMIOS_H\n");
  printf("/**\tDK3 version of HAVE_SYS_TERMIOS_H.\n*/\n");
#if HAVE_SYS_TERMIOS_H
  printf("#define DK3_HAVE_SYS_TERMIOS_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_TERMIOS_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_TIME_H\n");
  printf("/**\tDK3 version of HAVE_SYS_TIME_H.\n*/\n");
#if HAVE_SYS_TIME_H
  printf("#define DK3_HAVE_SYS_TIME_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_TIME_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_TTOLD_H\n");
  printf("/**\tDK3 version of HAVE_SYS_TTOLD_H.\n*/\n");
#if HAVE_SYS_TTOLD_H
  printf("#define DK3_HAVE_SYS_TTOLD_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_TTOLD_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_TYPES_H\n");
  printf("/**\tDK3 version of HAVE_SYS_TYPES_H.\n*/\n");
#if HAVE_SYS_TYPES_H
  printf("#define DK3_HAVE_SYS_TYPES_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_TYPES_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_UIO_H\n");
  printf("/**\tDK3 version of HAVE_SYS_UIO_H.\n*/\n");
#if HAVE_SYS_UIO_H
  printf("#define DK3_HAVE_SYS_UIO_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_UIO_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_UN_H\n");
  printf("/**\tDK3 version of HAVE_SYS_UN_H.\n*/\n");
#if HAVE_SYS_UN_H
  printf("#define DK3_HAVE_SYS_UN_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_UN_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_SYS_WAIT_H\n");
  printf("/**\tDK3 version of HAVE_SYS_WAIT_H.\n*/\n");
#if HAVE_SYS_WAIT_H
  printf("#define DK3_HAVE_SYS_WAIT_H 1\n");
#else
  printf("#define DK3_HAVE_SYS_WAIT_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TANHL\n");
  printf("/**\tDK3 version of HAVE_TANHL.\n*/\n");
#if HAVE_TANHL
  printf("#define DK3_HAVE_TANHL 1\n");
#else
  printf("#define DK3_HAVE_TANHL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TANL\n");
  printf("/**\tDK3 version of HAVE_TANL.\n*/\n");
#if HAVE_TANL
  printf("#define DK3_HAVE_TANL 1\n");
#else
  printf("#define DK3_HAVE_TANL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TCFLUSH\n");
  printf("/**\tDK3 version of HAVE_TCFLUSH.\n*/\n");
#if HAVE_TCFLUSH
  printf("#define DK3_HAVE_TCFLUSH 1\n");
#else
  printf("#define DK3_HAVE_TCFLUSH 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TCGETATTR\n");
  printf("/**\tDK3 version of HAVE_TCGETATTR.\n*/\n");
#if HAVE_TCGETATTR
  printf("#define DK3_HAVE_TCGETATTR 1\n");
#else
  printf("#define DK3_HAVE_TCGETATTR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TERMIOS_H\n");
  printf("/**\tDK3 version of HAVE_TERMIOS_H.\n*/\n");
#if HAVE_TERMIOS_H
  printf("#define DK3_HAVE_TERMIOS_H 1\n");
#else
  printf("#define DK3_HAVE_TERMIOS_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TIFF_H\n");
  printf("/**\tDK3 version of HAVE_TIFF_H.\n*/\n");
#if HAVE_TIFF_H
  printf("#define DK3_HAVE_TIFF_H 1\n");
#else
  printf("#define DK3_HAVE_TIFF_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TIME\n");
  printf("/**\tDK3 version of HAVE_TIME.\n*/\n");
#if HAVE_TIME
  printf("#define DK3_HAVE_TIME 1\n");
#else
  printf("#define DK3_HAVE_TIME 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TIME_H\n");
  printf("/**\tDK3 version of HAVE_TIME_H.\n*/\n");
#if HAVE_TIME_H
  printf("#define DK3_HAVE_TIME_H 1\n");
#else
  printf("#define DK3_HAVE_TIME_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_TWOS_COMPLEMENT\n");
  printf("/**\tDK3 version of HAVE_TWOS_COMPLEMENT.\n*/\n");
#if HAVE_TWOS_COMPLEMENT
  printf("#define DK3_HAVE_TWOS_COMPLEMENT 1\n");
#else
  printf("#define DK3_HAVE_TWOS_COMPLEMENT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_UMASK\n");
  printf("/**\tDK3 version of HAVE_UMASK.\n*/\n");
#if HAVE_UMASK
  printf("#define DK3_HAVE_UMASK 1\n");
#else
  printf("#define DK3_HAVE_UMASK 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_UNISTD_H\n");
  printf("/**\tDK3 version of HAVE_UNISTD_H.\n*/\n");
#if HAVE_UNISTD_H
  printf("#define DK3_HAVE_UNISTD_H 1\n");
#else
  printf("#define DK3_HAVE_UNISTD_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_UNLINK\n");
  printf("/**\tDK3 version of HAVE_UNLINK.\n*/\n");
#if HAVE_UNLINK
  printf("#define DK3_HAVE_UNLINK 1\n");
#else
  printf("#define DK3_HAVE_UNLINK 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_USER_NAMES_CASE_INSENSITIVE\n");
  printf("/**\tDK3 version of HAVE_USER_NAMES_CASE_INSENSITIVE.\n*/\n");
#if HAVE_USER_NAMES_CASE_INSENSITIVE
  printf("#define DK3_HAVE_USER_NAMES_CASE_INSENSITIVE 1\n");
#else
  printf("#define DK3_HAVE_USER_NAMES_CASE_INSENSITIVE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_VARARGS_H\n");
  printf("/**\tDK3 version of HAVE_VARARGS_H.\n*/\n");
#if HAVE_VARARGS_H
  printf("#define DK3_HAVE_VARARGS_H 1\n");
#else
  printf("#define DK3_HAVE_VARARGS_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_VARARG_H\n");
  printf("/**\tDK3 version of HAVE_VARARG_H.\n*/\n");
#if HAVE_VARARG_H
  printf("#define DK3_HAVE_VARARG_H 1\n");
#else
  printf("#define DK3_HAVE_VARARG_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_VOLATILE\n");
  printf("/**\tDK3 version of HAVE_VOLATILE.\n*/\n");
#if HAVE_VOLATILE
  printf("#define DK3_HAVE_VOLATILE 1\n");
#else
  printf("#define DK3_HAVE_VOLATILE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCHAR_H\n");
  printf("/**\tDK3 version of HAVE_WCHAR_H.\n*/\n");
#if HAVE_WCHAR_H
  printf("#define DK3_HAVE_WCHAR_H 1\n");
#else
  printf("#define DK3_HAVE_WCHAR_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCHAR_T\n");
  printf("/**\tDK3 version of HAVE_WCHAR_T.\n*/\n");
#if HAVE_WCHAR_T
  printf("#define DK3_HAVE_WCHAR_T 1\n");
#else
  printf("#define DK3_HAVE_WCHAR_T 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSCAT\n");
  printf("/**\tDK3 version of HAVE_WCSCAT.\n*/\n");
#if HAVE_WCSCAT
  printf("#define DK3_HAVE_WCSCAT 1\n");
#else
  printf("#define DK3_HAVE_WCSCAT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSCHR\n");
  printf("/**\tDK3 version of HAVE_WCSCHR.\n*/\n");
#if HAVE_WCSCHR
  printf("#define DK3_HAVE_WCSCHR 1\n");
#else
  printf("#define DK3_HAVE_WCSCHR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSCMP\n");
  printf("/**\tDK3 version of HAVE_WCSCMP.\n*/\n");
#if HAVE_WCSCMP
  printf("#define DK3_HAVE_WCSCMP 1\n");
#else
  printf("#define DK3_HAVE_WCSCMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSCPY\n");
  printf("/**\tDK3 version of HAVE_WCSCPY.\n*/\n");
#if HAVE_WCSCPY
  printf("#define DK3_HAVE_WCSCPY 1\n");
#else
  printf("#define DK3_HAVE_WCSCPY 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSDUP\n");
  printf("/**\tDK3 version of HAVE_WCSDUP.\n*/\n");
#if HAVE_WCSDUP
  printf("#define DK3_HAVE_WCSDUP 1\n");
#else
  printf("#define DK3_HAVE_WCSDUP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSICMP\n");
  printf("/**\tDK3 version of HAVE_WCSICMP.\n*/\n");
#if HAVE_WCSICMP
  printf("#define DK3_HAVE_WCSICMP 1\n");
#else
  printf("#define DK3_HAVE_WCSICMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSLEN\n");
  printf("/**\tDK3 version of HAVE_WCSLEN.\n*/\n");
#if HAVE_WCSLEN
  printf("#define DK3_HAVE_WCSLEN 1\n");
#else
  printf("#define DK3_HAVE_WCSLEN 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSNCMP\n");
  printf("/**\tDK3 version of HAVE_WCSNCMP.\n*/\n");
#if HAVE_WCSNCMP
  printf("#define DK3_HAVE_WCSNCMP 1\n");
#else
  printf("#define DK3_HAVE_WCSNCMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSNCPY\n");
  printf("/**\tDK3 version of HAVE_WCSNCPY.\n*/\n");
#if HAVE_WCSNCPY
  printf("#define DK3_HAVE_WCSNCPY 1\n");
#else
  printf("#define DK3_HAVE_WCSNCPY 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSRCHR\n");
  printf("/**\tDK3 version of HAVE_WCSRCHR.\n*/\n");
#if HAVE_WCSRCHR
  printf("#define DK3_HAVE_WCSRCHR 1\n");
#else
  printf("#define DK3_HAVE_WCSRCHR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOD\n");
  printf("/**\tDK3 version of HAVE_WCSTOD.\n*/\n");
#if HAVE_WCSTOD
  printf("#define DK3_HAVE_WCSTOD 1\n");
#else
  printf("#define DK3_HAVE_WCSTOD 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOIMAX\n");
  printf("/**\tDK3 version of HAVE_WCSTOIMAX.\n*/\n");
#if HAVE_WCSTOIMAX
  printf("#define DK3_HAVE_WCSTOIMAX 1\n");
#else
  printf("#define DK3_HAVE_WCSTOIMAX 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOL\n");
  printf("/**\tDK3 version of HAVE_WCSTOL.\n*/\n");
#if HAVE_WCSTOL
  printf("#define DK3_HAVE_WCSTOL 1\n");
#else
  printf("#define DK3_HAVE_WCSTOL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOLL\n");
  printf("/**\tDK3 version of HAVE_WCSTOLL.\n*/\n");
#if HAVE_WCSTOLL
  printf("#define DK3_HAVE_WCSTOLL 1\n");
#else
  printf("#define DK3_HAVE_WCSTOLL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOUL\n");
  printf("/**\tDK3 version of HAVE_WCSTOUL.\n*/\n");
#if HAVE_WCSTOUL
  printf("#define DK3_HAVE_WCSTOUL 1\n");
#else
  printf("#define DK3_HAVE_WCSTOUL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOULL\n");
  printf("/**\tDK3 version of HAVE_WCSTOULL.\n*/\n");
#if HAVE_WCSTOULL
  printf("#define DK3_HAVE_WCSTOULL 1\n");
#else
  printf("#define DK3_HAVE_WCSTOULL 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WCSTOUMAX\n");
  printf("/**\tDK3 version of HAVE_WCSTOUMAX.\n*/\n");
#if HAVE_WCSTOUMAX
  printf("#define DK3_HAVE_WCSTOUMAX 1\n");
#else
  printf("#define DK3_HAVE_WCSTOUMAX 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WINBASE_H\n");
  printf("/**\tDK3 version of HAVE_WINBASE_H.\n*/\n");
#if HAVE_WINBASE_H
  printf("#define DK3_HAVE_WINBASE_H 1\n");
#else
  printf("#define DK3_HAVE_WINBASE_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WINCON_H\n");
  printf("/**\tDK3 version of HAVE_WINCON_H.\n*/\n");
#if HAVE_WINCON_H
  printf("#define DK3_HAVE_WINCON_H 1\n");
#else
  printf("#define DK3_HAVE_WINCON_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WINDOWS_H\n");
  printf("/**\tDK3 version of HAVE_WINDOWS_H.\n*/\n");
#if HAVE_WINDOWS_H
  printf("#define DK3_HAVE_WINDOWS_H 1\n");
#else
  printf("#define DK3_HAVE_WINDOWS_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WINREG_H\n");
  printf("/**\tDK3 version of HAVE_WINREG_H.\n*/\n");
#if HAVE_WINREG_H
  printf("#define DK3_HAVE_WINREG_H 1\n");
#else
  printf("#define DK3_HAVE_WINREG_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WINSOCK2_H\n");
  printf("/**\tDK3 version of HAVE_WINSOCK2_H.\n*/\n");
#if HAVE_WINSOCK2_H
  printf("#define DK3_HAVE_WINSOCK2_H 1\n");
#else
  printf("#define DK3_HAVE_WINSOCK2_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WRITE\n");
  printf("/**\tDK3 version of HAVE_WRITE.\n*/\n");
#if HAVE_WRITE
  printf("#define DK3_HAVE_WRITE 1\n");
#else
  printf("#define DK3_HAVE_WRITE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_WS2TCPIP_H\n");
  printf("/**\tDK3 version of HAVE_WS2TCPIP_H.\n*/\n");
#if HAVE_WS2TCPIP_H
  printf("#define DK3_HAVE_WS2TCPIP_H 1\n");
#else
  printf("#define DK3_HAVE_WS2TCPIP_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE_ZLIB_H\n");
  printf("/**\tDK3 version of HAVE_ZLIB_H.\n*/\n");
#if HAVE_ZLIB_H
  printf("#define DK3_HAVE_ZLIB_H 1\n");
#else
  printf("#define DK3_HAVE_ZLIB_H 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__CLEARFP\n");
  printf("/**\tDK3 version of HAVE__CLEARFP.\n*/\n");
#if HAVE__CLEARFP
  printf("#define DK3_HAVE__CLEARFP 1\n");
#else
  printf("#define DK3_HAVE__CLEARFP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FCLOSE\n");
  printf("/**\tDK3 version of HAVE__FCLOSE.\n*/\n");
#if HAVE__FCLOSE
  printf("#define DK3_HAVE__FCLOSE 1\n");
#else
  printf("#define DK3_HAVE__FCLOSE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FEOF\n");
  printf("/**\tDK3 version of HAVE__FEOF.\n*/\n");
#if HAVE__FEOF
  printf("#define DK3_HAVE__FEOF 1\n");
#else
  printf("#define DK3_HAVE__FEOF 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FERROR\n");
  printf("/**\tDK3 version of HAVE__FERROR.\n*/\n");
#if HAVE__FERROR
  printf("#define DK3_HAVE__FERROR 1\n");
#else
  printf("#define DK3_HAVE__FERROR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FFLUSH\n");
  printf("/**\tDK3 version of HAVE__FFLUSH.\n*/\n");
#if HAVE__FFLUSH
  printf("#define DK3_HAVE__FFLUSH 1\n");
#else
  printf("#define DK3_HAVE__FFLUSH 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FOPEN\n");
  printf("/**\tDK3 version of HAVE__FOPEN.\n*/\n");
#if HAVE__FOPEN
  printf("#define DK3_HAVE__FOPEN 1\n");
#else
  printf("#define DK3_HAVE__FOPEN 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FREAD\n");
  printf("/**\tDK3 version of HAVE__FREAD.\n*/\n");
#if HAVE__FREAD
  printf("#define DK3_HAVE__FREAD 1\n");
#else
  printf("#define DK3_HAVE__FREAD 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__FWRITE\n");
  printf("/**\tDK3 version of HAVE__FWRITE.\n*/\n");
#if HAVE__FWRITE
  printf("#define DK3_HAVE__FWRITE 1\n");
#else
  printf("#define DK3_HAVE__FWRITE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__GETCWD\n");
  printf("/**\tDK3 version of HAVE__GETCWD.\n*/\n");
#if HAVE__GETCWD
  printf("#define DK3_HAVE__GETCWD 1\n");
#else
  printf("#define DK3_HAVE__GETCWD 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__GETPID\n");
  printf("/**\tDK3 version of HAVE__GETPID.\n*/\n");
#if HAVE__GETPID
  printf("#define DK3_HAVE__GETPID 1\n");
#else
  printf("#define DK3_HAVE__GETPID 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__LSTAT\n");
  printf("/**\tDK3 version of HAVE__LSTAT.\n*/\n");
#if HAVE__LSTAT
  printf("#define DK3_HAVE__LSTAT 1\n");
#else
  printf("#define DK3_HAVE__LSTAT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__LSTAT32\n");
  printf("/**\tDK3 version of HAVE__LSTAT32.\n*/\n");
#if HAVE__LSTAT32
  printf("#define DK3_HAVE__LSTAT32 1\n");
#else
  printf("#define DK3_HAVE__LSTAT32 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__LSTAT64\n");
  printf("/**\tDK3 version of HAVE__LSTAT64.\n*/\n");
#if HAVE__LSTAT64
  printf("#define DK3_HAVE__LSTAT64 1\n");
#else
  printf("#define DK3_HAVE__LSTAT64 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__MKDIR\n");
  printf("/**\tDK3 version of HAVE__MKDIR.\n*/\n");
#if HAVE__MKDIR
  printf("#define DK3_HAVE__MKDIR 1\n");
#else
  printf("#define DK3_HAVE__MKDIR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__POPEN\n");
  printf("/**\tDK3 version of HAVE__POPEN.\n*/\n");
#if HAVE__POPEN
  printf("#define DK3_HAVE__POPEN 1\n");
#else
  printf("#define DK3_HAVE__POPEN 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__READ\n");
  printf("/**\tDK3 version of HAVE__READ.\n*/\n");
#if HAVE__READ
  printf("#define DK3_HAVE__READ 1\n");
#else
  printf("#define DK3_HAVE__READ 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__RMDIR\n");
  printf("/**\tDK3 version of HAVE__RMDIR.\n*/\n");
#if HAVE__RMDIR
  printf("#define DK3_HAVE__RMDIR 1\n");
#else
  printf("#define DK3_HAVE__RMDIR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__SNPRINTF\n");
  printf("/**\tDK3 version of HAVE__SNPRINTF.\n*/\n");
#if HAVE__SNPRINTF
  printf("#define DK3_HAVE__SNPRINTF 1\n");
#else
  printf("#define DK3_HAVE__SNPRINTF 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__STAT\n");
  printf("/**\tDK3 version of HAVE__STAT.\n*/\n");
#if HAVE__STAT
  printf("#define DK3_HAVE__STAT 1\n");
#else
  printf("#define DK3_HAVE__STAT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__STAT32\n");
  printf("/**\tDK3 version of HAVE__STAT32.\n*/\n");
#if HAVE__STAT32
  printf("#define DK3_HAVE__STAT32 1\n");
#else
  printf("#define DK3_HAVE__STAT32 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__STAT64\n");
  printf("/**\tDK3 version of HAVE__STAT64.\n*/\n");
#if HAVE__STAT64
  printf("#define DK3_HAVE__STAT64 1\n");
#else
  printf("#define DK3_HAVE__STAT64 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__STRDUP\n");
  printf("/**\tDK3 version of HAVE__STRDUP.\n*/\n");
#if HAVE__STRDUP
  printf("#define DK3_HAVE__STRDUP 1\n");
#else
  printf("#define DK3_HAVE__STRDUP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__STRICMP\n");
  printf("/**\tDK3 version of HAVE__STRICMP.\n*/\n");
#if HAVE__STRICMP
  printf("#define DK3_HAVE__STRICMP 1\n");
#else
  printf("#define DK3_HAVE__STRICMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__UNLINK\n");
  printf("/**\tDK3 version of HAVE__UNLINK.\n*/\n");
#if HAVE__UNLINK
  printf("#define DK3_HAVE__UNLINK 1\n");
#else
  printf("#define DK3_HAVE__UNLINK 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSCAT\n");
  printf("/**\tDK3 version of HAVE__WCSCAT.\n*/\n");
#if HAVE__WCSCAT
  printf("#define DK3_HAVE__WCSCAT 1\n");
#else
  printf("#define DK3_HAVE__WCSCAT 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSCHR\n");
  printf("/**\tDK3 version of HAVE__WCSCHR.\n*/\n");
#if HAVE__WCSCHR
  printf("#define DK3_HAVE__WCSCHR 1\n");
#else
  printf("#define DK3_HAVE__WCSCHR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSCMP\n");
  printf("/**\tDK3 version of HAVE__WCSCMP.\n*/\n");
#if HAVE__WCSCMP
  printf("#define DK3_HAVE__WCSCMP 1\n");
#else
  printf("#define DK3_HAVE__WCSCMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSCPY\n");
  printf("/**\tDK3 version of HAVE__WCSCPY.\n*/\n");
#if HAVE__WCSCPY
  printf("#define DK3_HAVE__WCSCPY 1\n");
#else
  printf("#define DK3_HAVE__WCSCPY 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSDUP\n");
  printf("/**\tDK3 version of HAVE__WCSDUP.\n*/\n");
#if HAVE__WCSDUP
  printf("#define DK3_HAVE__WCSDUP 1\n");
#else
  printf("#define DK3_HAVE__WCSDUP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSICMP\n");
  printf("/**\tDK3 version of HAVE__WCSICMP.\n*/\n");
#if HAVE__WCSICMP
  printf("#define DK3_HAVE__WCSICMP 1\n");
#else
  printf("#define DK3_HAVE__WCSICMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSLEN\n");
  printf("/**\tDK3 version of HAVE__WCSLEN.\n*/\n");
#if HAVE__WCSLEN
  printf("#define DK3_HAVE__WCSLEN 1\n");
#else
  printf("#define DK3_HAVE__WCSLEN 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSNCMP\n");
  printf("/**\tDK3 version of HAVE__WCSNCMP.\n*/\n");
#if HAVE__WCSNCMP
  printf("#define DK3_HAVE__WCSNCMP 1\n");
#else
  printf("#define DK3_HAVE__WCSNCMP 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSNCPY\n");
  printf("/**\tDK3 version of HAVE__WCSNCPY.\n*/\n");
#if HAVE__WCSNCPY
  printf("#define DK3_HAVE__WCSNCPY 1\n");
#else
  printf("#define DK3_HAVE__WCSNCPY 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WCSRCHR\n");
  printf("/**\tDK3 version of HAVE__WCSRCHR.\n*/\n");
#if HAVE__WCSRCHR
  printf("#define DK3_HAVE__WCSRCHR 1\n");
#else
  printf("#define DK3_HAVE__WCSRCHR 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WGETENV\n");
  printf("/**\tDK3 version of HAVE__WGETENV.\n*/\n");
#if HAVE__WGETENV
  printf("#define DK3_HAVE__WGETENV 1\n");
#else
  printf("#define DK3_HAVE__WGETENV 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_HAVE__WRITE\n");
  printf("/**\tDK3 version of HAVE__WRITE.\n*/\n");
#if HAVE__WRITE
  printf("#define DK3_HAVE__WRITE 1\n");
#else
  printf("#define DK3_HAVE__WRITE 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_TIME_WITH_SYS_TIME\n");
  printf("/**\tDK3 version of TIME_WITH_SYS_TIME.\n*/\n");
#if TIME_WITH_SYS_TIME
  printf("#define DK3_TIME_WITH_SYS_TIME 1\n");
#else
  printf("#define DK3_TIME_WITH_SYS_TIME 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_DOUBLE\n");
  printf("/**\tDK3 version of SIZEOF_DOUBLE.\n*/\n");
  printf("#define DK3_SIZEOF_DOUBLE %d\n", (int)SIZEOF_DOUBLE);
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_INT\n");
  printf("/**\tDK3 version of SIZEOF_INT.\n*/\n");
  printf("#define DK3_SIZEOF_INT %d\n", (int)SIZEOF_INT);
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_INTMAX_T\n");
  printf("/**\tDK3 version of SIZEOF_INTMAX_T.\n*/\n");
  printf("#define DK3_SIZEOF_INTMAX_T %d\n", (int)SIZEOF_INTMAX_T);
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_LONG\n");
  printf("/**\tDK3 version of SIZEOF_LONG.\n*/\n");
  printf("#define DK3_SIZEOF_LONG %d\n", (int)SIZEOF_LONG);
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_LONG_DOUBLE\n");
  printf("/**\tDK3 version of SIZEOF_LONG_DOUBLE.\n*/\n");
  printf("#define DK3_SIZEOF_LONG_DOUBLE %d\n", (int)SIZEOF_LONG_DOUBLE);
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_LONG_LONG\n");
  printf("/**\tDK3 version of SIZEOF_LONG_LONG.\n*/\n");
  printf("#define DK3_SIZEOF_LONG_LONG %d\n", (int)SIZEOF_LONG_LONG);
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_SHORT\n");
  printf("/**\tDK3 version of SIZEOF_SHORT.\n*/\n");
  printf("#define DK3_SIZEOF_SHORT %d\n", (int)SIZEOF_SHORT);
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_SIZE_T\n");
  printf("/**\tDK3 version of SIZEOF_SIZE_T.\n*/\n");
  printf("#define DK3_SIZEOF_SIZE_T %d\n", (int)SIZEOF_SIZE_T);
  printf("#endif\n");
  printf("\n#ifndef DK3_SIZEOF_WCHAR_T\n");
  printf("/**\tDK3 version of SIZEOF_WCHAR_T.\n*/\n");
  printf("#define DK3_SIZEOF_WCHAR_T %d\n", (int)SIZEOF_WCHAR_T);
  printf("#endif\n");
  printf("\n#endif\n/* if DK3_ON_WINDOWS */\n");
  printf("\n#ifndef DK3_WORDS_BIGENDIAN\n");
#if WORDS_BIGENDIAN
  printf("/**\tBig-endian.\n*/\n");
  printf("#define DK3_WORDS_BIGENDIAN 1\n");
#else
  printf("/**\tLittle-endian.\n*/\n");
  printf("#define DK3_WORDS_BIGENDIAN 0\n");
#endif
  printf("#endif\n");
  printf("\n#ifndef DK3_MAX_PATH\n");
  printf("/**\tMaximum path length.\n*/\n");
  printf("#define DK3_MAX_PATH %d\n", (MPL + 1));
  printf("#endif\n");
  printf("\n#endif\n/* ifndef DK3_CONF_H_INCLUDED */\n\n");
  exit(0); return 0;
}
