/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3xsp.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3xsp.h Header file for the dk3xsp module.
*/

#ifndef DK3XSP_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3XSP_H_INCLUDED 1


#line 8 "dk3xsp.ctr"

#include "dk3all.h"

#ifdef __cplusplus
extern "C" {
#endif

/**	Reset spline segment data.
	All components - including cb - are reset.
	@param	pseg	Spline segment data to reset.
*/
void
dk3xsp_reset(dk3_xspline_segment_t *pseg);

/**	Set compatility bug flag.
	@param	pseg	Spline segment data to modify.
	@param	v	New flag value (1 or 0).
*/
void
dk3xsp_set_cb(dk3_xspline_segment_t *pseg, int v);

/**	Set control points.
	@param	pseg	Spline segment data to modify.
	@param	a	Control point A (may be NULL).
	@param	b	Control point B.
	@param	c	Control point C.
	@param	d	Control point D (may be NULL).
*/
void
dk3xsp_set(
  dk3_xspline_segment_t		*pseg,
  dk3_fig_spline_point_t const	*a,
  dk3_fig_spline_point_t const	*b,
  dk3_fig_spline_point_t const	*c,
  dk3_fig_spline_point_t const	*d
);

/**	Run calculation for a given t.
	@param	pseg	Spline segment.
	@param	t	The t parameter.
	@param	fder	Flag: Calculate derivatives (1=yes, 0=no).
	@return	1 on success, 0 on error.
*/
int
dk3xsp_calculate(
  dk3_xspline_segment_t		*pseg,
  double			 t,
  int				 fder
);

/**	Retrieve calculation result.
	@param	pseg	Spline segment.
	@return	Calculation result: x value.
*/
double
dk3xsp_get_x(dk3_xspline_segment_t const *pseg);

/**	Retrieve calculation result.
	@param	pseg	Spline segment.
	@return	Calculation result: y value.
*/
double
dk3xsp_get_y(dk3_xspline_segment_t const *pseg);

/**	Retrieve calculation result.
	@param	pseg	Spline segment.
	@return	Calculation result: dx/dt value.
*/
double
dk3xsp_get_dxdt(dk3_xspline_segment_t const *pseg);

/**	Retrieve calculation result.
	@param	pseg	Spline segment.
	@return	Calculation result: dy/dt value.
*/
double
dk3xsp_get_dydt(dk3_xspline_segment_t const *pseg);

/**	Calculate X-spline segment interval length.
	@param	pseg	Segment to calculate the length for.
	@param	prec	Precision.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length (positive value) on success, negative value on error.
*/
double
dk3xsp_segment_length(
  dk3_xspline_segment_t 	*pseg,
  double			 prec,
  int				*ec
);

/**	Calculate X-spline partial segment length.
	@param	pseg	Segment to calculate the length for.
	@param	tstart	Parameter t for start.
	@param	dir	Direction (0=forward t to 1, 1=backward 0 to t).
	@param	prec	Precision.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length (positive value) on success, negative value on error.
*/
double
dk3xsp_segment_partial_length(
  dk3_xspline_segment_t		*pseg,
  double			 tstart,
  int				 dir,
  double			 prec,
  int				*ec
);

/**	Check whether an s value is very close to 0.
	@param	s	Value to check.
	@return	1 if s==0, 0 otherwise.
*/
int
dk3xsp_is_null(double s);

/**	Calculate length of open X-spline.
	@param	points	Array of spline points.
	@param	np	Number of points in array.
	@param	prec	Numeric precision.
	@param	fslc	Full segment length cache (np - 1) elements.
	@param	cb	Flag: Compatibility bug.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length (positive value) on success, negative value on error.
*/
double
dk3xsp_open_spline_length(
  dk3_fig_spline_point_t const	*points,
  size_t			 np,
  double			 prec,
  double			*fslc,
  int				 cb,
  int				*ec
);

/**	Calculate length of open X-spline.
	@param	points	Array of spline points.
	@param	np	Number of points in array.
	@param	prec	Numeric precision.
	@param	tstart	Start/end t parameter.
	@param	fslc	Full segment length cache, (np-1) elements.
	@param	dir	Direction (0=forward t to 1, 1=backward 0 to t).
	@param	cb	Flag: Compatibility bug.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length (positive value) on success, negative value on error.
*/
double
dk3xsp_open_spline_partial_length(
  dk3_fig_spline_point_t const	*points,
  size_t			 np,
  double			 prec,
  double			 tstart,
  double			*fslc,
  int				 dir,
  int				 cb,
  int				*ec
);

/**	Calculate t value for given distance to end point.
	@param	points	X-spline points.
	@param	np	Number of x-spline points.
	@param	dist	Distance to endpoint.
	@param	prec	Precision.
	@param	fslc	Cache for full segment lengths.
	@param	dir	End-point type: 0=end of spline, 1=start of spline.
	@param	cb	Flag: Compatibility with spline bug.
	@param	ec	Pointer to error code variable.
	@return	Non-negative value on success, negative value on error.
*/
double
dk3xsp_get_t_for_distance(
  dk3_fig_spline_point_t const	*points,
  size_t			 np,
  double			 dist,
  double			 prec,
  double			*fslc,
  int				 dir,
  int				 cb,
  int				*ec
);

/**	Run calculations for a given t value in the range 0<=t<=(np-1).
	@param	pseg	Segment to use for calculation.
	@param	points	Spline points.
	@param	np	Number of points.
	@param	t	Parameter t.
	@param	cb	Flag: Compatibility for spline bug.
	@param	der	Flag: Calculate derivatives dx/dt and dy/dt too.
	@param	ec	Pointer to error code variable.
	@return	1 on success, 0 on error.
*/
int
dk3xsp_calculate_position(
  dk3_xspline_segment_t		*pseg,
  dk3_fig_spline_point_t const	*points,
  size_t			 np,
  double			 t,
  int				 cb,
  int				 der,
  int				*ec
);

/**	Find movement direction for a specified t value.
	@param	points	X-spline points.
	@param	np	Number of points.
	@param	t	The t parameter 0<=t<=(np-1).
	@param	cb	Flag: Compatibility for spline bug.
	@param	ec	Pointer to error code variable.
	@return	Non-negative value 0<=res<=2*pi on success,
	negative value on error.
*/
double
dk3xsp_direction(
  dk3_fig_spline_point_t const	*points,
  size_t			 np,
  double			 t,
  int				 cb,
  int				*ec
);

/**	Find position and movement direction for a specified t value.
	@param	xpos	Pointer to variable for x position.
	@param	ypos	Pointer to variable for y position.
	@param	points	X-spline points.
	@param	np	Number of points.
	@param	t	The t parameter 0<=t<=(np-1).
	@param	cb	Flag: Compatibility for spline bug.
	@param	ec	Pointer to error code variable.
	@return	Non-negative value 0<=res<=2*pi on success,
	negative value on error.
*/
double
dk3xsp_direction_and_position(
  double			*xpos,
  double			*ypos,
  dk3_fig_spline_point_t const	*points,
  size_t			 np,
  double			 t,
  int				 cb,
  int				*ec
);

#ifdef __cplusplus
}
#endif

#ifndef DK3XSP_MAX_ITERATION_SEGMENTS
/**	Maximum number of sub-segments in segment length iteration.
*/
#define	DK3XSP_MAX_ITERATION_SEGMENTS 1073741824L
#endif


#endif
