/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3wxs.cpt
*/

/*
Copyright (C) 2011, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3wxs.h Header file for the dk3wxs module.
*/

#ifndef DK3WXS_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3WXS_H_INCLUDED 1


#line 9 "dk3wxs.cpt"

#ifdef	DK3_USE_WX
#undef	DK3_USE_WX
#endif
/**	Use wxWidgets libraries to build GUI programs.
*/
#define	DK3_USE_WX	1


#if 0
#include <dk3all.h>
#else
#include <dk3conf.h>
#include <dk3types.h>
#include <dk3const.h>
#endif

#include "wx/wxprec.h"
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif


/**	Pointer to wxChar string.
*/
typedef	wxChar		*DK3_PWXCHAR;

/**	Pointer to constant wxChar string.
*/
typedef wxChar const	*DK3_PCWXCHAR;


#if DK3_ON_WINDOWS || DK3_HAVE_BACKSLASH
/**	File name separator.
*/
#define	DK3_WX_CHAR_SEP	wxT('\\')
#else
/**	File name separator.
*/
#define DK3_WX_CHAR_SEP wxT('/')
#endif

#ifdef __cplusplus
extern "C" {
#endif

/**	Copy string.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3wxs_cpy(wxChar *d, wxChar const *s);

/**	Copy string, cut to buffer size if necessary.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 * 	@param	n	Size of \a d (number of characters).
 */
void
dk3wxs_ncpy(wxChar *d, wxChar const *s, size_t n);

/**	Concatenate two strings.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3wxs_cat(wxChar *d, wxChar const *s);

/**	Convert to lower-case character.
 * 	@param	c	Character to convert.
 * 	@return	Conversion result.
 */
wxChar
dk3wxs_tolower(wxChar c);

/**	Convert to upper-case character.
 * 	@param	c	Character to convert.
 * 	@return	Conversion result.
 */
wxChar
dk3wxs_toupper(wxChar c);

/**	Find left-most orrucance of character in string.
 * 	@param	s	String probably containing the character.
 * 	@param	c	Character to search for.
 * 	@return	Pointer to character position on success, NULL on error.
 */
wxChar *
dk3wxs_chr(wxChar const *s, wxChar c);

/**	Find right-most orrucance of character in string.
 * 	@param	s	String probably containing the character.
 * 	@param	c	Character to search for.
 * 	@return	Pointer to character position on success, NULL on error.
 */
wxChar *
dk3wxs_rchr(wxChar const *s, wxChar c);

/**	Calculate string length.
 * 	@param	s	String to process.
 * 	@return	String length (number of characters).
 */
size_t
dk3wxs_len(wxChar const *s);

/**	Duplicate string into dynamically allocated memory.
 *	Use dk3_delete() to release the memory when done.
 * 	@param	s	String to duplicate.
 * 	@return	Pointer to new string on success, NULL on error.
 */
wxChar *
dk3wxs_dup(wxChar const *s);

/**	Duplicate string into dynamically allocated memory.
 *	Use dk3_delete() to release the memory when done.
 * 	@param	s	String to duplicate.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new string on success, NULL on error.
 */
wxChar *
dk3wxs_dup_app(wxChar const *s, dk3_app_t *app);

/**	Compare two strings, use only the first \a n characters.
 * 	@param	l	Left side string.
 * 	@param	r	Right side string.
 * 	@param	n	Number of characters to use in comparison.
 * 	@return	1 for l>r, 0 for l=r, -1 for l<r.
 */
int
dk3wxs_ncmp(wxChar const *l, wxChar const *r, size_t n);

/**	Compare two strings.
 * 	@param	l	Left side string.
 * 	@param	r	Right side string.
 * 	@return	1 for l>r, 0 for l=r, -1 for l<r.
 */
int
dk3wxs_cmp(wxChar const *l, wxChar const *r);

/**	Case-insensitve string comparison.
 * 	@param	l	Left side string.
 * 	@param	r	Right side string.
 * 	@return 1 for l>r, 0 for l=r, -1 for l<r.
 */
int
dk3wxs_casecmp(wxChar const *l, wxChar const *r);

/**	Find index of a string in an array of patterns.
 * 	@param	a	Patterns array.
 * 	@param	s	String to find.
 * 	@param	c	Flag: Case-sensitive (1) or not (0).
 * 	@return	Index of \a s in \a a on success, -1 on error (not found).
 */
int
dk3wxs_array_index(wxChar const * const *a, wxChar const *s, int c);

/**	Find file name suffix.
	@param	s	File name.
	@return	Pointer to suffix (pointer to the dot) or NULL.
*/
wxChar *
dk3wxs_get_suffix(wxChar const *s);

/**	Find start of string (first non-whitespace).
 * 	@param	s	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 * 	@return	Pointer to first non-whitespace on success, NULL on error.
 */
wxChar *
dk3wxs_start(wxChar *s, wxChar const *whsp);

/**	Find start of second text
 * 	@param	s	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 * 	@return	Pointer to second non-whitespace sequence on success, or NULL.
 */
wxChar *
dk3wxs_next(wxChar *s, wxChar const *whsp);

/**	Check whether the text represents a boolean value.
 * 	@param	s	Text to process.
 * 	@return	1 on success, 0 on error.
 */
int
dk3wxs_is_bool(wxChar const *s);

/**	Check whether the text represents the boolean value "true".
 * 	@param	s	Text to process.
 * 	@return	1 on success, 0 on error.
 */
int
dk3wxs_is_on(wxChar const *s);

/**	Explode a string (split string into array of text words).
	@param	array	Destination pointers array.
	@param	sz	Size of \a array (number of elements).
	@param	s	String to process.
	@param	whsp	Whitespaces set (may be NULL).
	@return	Number of elements set in \a array, 0 on error.
*/
size_t
dk3wxs_explode(wxChar **array, size_t sz, wxChar *s, wxChar const *whsp);

/**	Normalize text line.
	@param	l	Text line to modify.
	@param	w	Whitespaces set (may be NULL).
	@param	c	Separator character.
*/
void
dk3wxs_normalize(wxChar *l, wxChar const *w, wxChar c);

/**	Check whether a file/directory name is an absolute path.
 * 	@param	n	Name to check.
 * 	@return	1 for absolute path, 0 otherwise.
 */
int
dk3wxs_is_abs_path(wxChar const *n);

/**	Append path to a given directory.
 * 	@param	d	In: directory, out: modified path.
 * 	@param	sz	Destination buffer size (number of characters).
 * 	@param	n	Path name to append.
 * 	@return	1 on success, 0 on errors.
 */
int
dk3wxs_append_path(wxChar *d, size_t sz, wxChar const *n);

/**	Correct file name.
 * 	@param	n	File name to correct.
 */
void
dk3wxs_correct_filename(wxChar *n);

/**	Convert UTF-8 string to wxChar string.
 * 	@param	d	Destination buffer.
 * 	@param	sz	Size of \a d (number of wxChar).
 * 	@param	s	Source string.
 * 	@return	1 on success, 0 on error.
 */
int
dk3wxs_from_utf8(wxChar *d, size_t sz, char const *s);

/**	Convert ASCII string to wxChar string.
 * 	@param	d	Destination buffer.
 * 	@param	sz	Size of \a d (number of wxChar).
 * 	@param	s	Source string.
 * 	@return	1 on success, 0 on error.
 */
int
dk3wxs_from_plain(wxChar *d, size_t sz, char const *s);

/**	Convert UTF-16 string to wxChar string.
 * 	@param	d	Destination buffer.
 * 	@param	sz	Size of \a d (number of wxChar).
 * 	@param	s	Source string.
 * 	@return	1 on success, 0 on error.
 */
int
dk3wxs_from_utf16(wxChar *d, size_t sz, dk3_c16_t const *s);

/**	Convert dkChar string to wxChar string.
 * 	@param	dp	Destination buffer pointer.
 * 	@param	sz	Size of \a dp (number of wxChar).
 * 	@param	wxe	Encoding for wxChar string (for 8-bit wxChar only).
 * 	@param	src	Source string.
 * 	@param	dke	Encoding for dkChar string (for 8-bit dkChar only).
 * 	@return	1 on success, 0 on error.
 */
int
dk3wxs_from_dkstr(wxChar *dp, size_t sz, int wxe, dkChar const *src, int dke);

/**	Convert wxChar string to dkChar string.
 * 	@param	dp	Destination buffer pointer.
 * 	@param	sz	Size of \a dp (number of dkChar).
 * 	@param	dke	Encoding for dkChar string (used for 8-bit dkChar only).
 * 	@param	src	Source string.
 * 	@param	wxe	Encoding for wxChar string (used for 8-bit wxChar only).
 * 	@return	1 on success, 0 on error.
 */
int
dk3wxs_to_dkstr(dkChar *dp, size_t sz, int dke, wxChar const *src, int wxe);

/**	Convert wxChar string to 8-bit char string.
 * 	@param	dp	Destination buffer pointer.
 * 	@param	sz	Size of \a dp.
 * 	@param	c8e	Encoding for char string.
 * 	@param	src	Source string.
 * 	@param	wxe	Encoding for wxChar string (used for 8-bit wxChar only).
 * 	@return	1 on success, 0 on error.
 */
int
dk3wxs_to_c8(char *dp, size_t sz, int c8e, wxChar const *src, int wxe);

#ifdef __cplusplus
}
#endif




#endif
