/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3wreg.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3wreg.h Header file for the dk3wreg module.
*/

#ifndef DK3WREG_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3WREG_H_INCLUDED 1


#line 9 "dk3wreg.ctr"

#include <dk3all.h>


#if DK3_ON_WINDOWS && ((2 == DK3_CHAR_SIZE) || (1 == DK3_CHAR_SIZE))

#ifdef __cplusplus
extern "C" {
#endif

/**	Open registry key for access as specified.
	@param	b	Base key.
	@param	n	Key name.
	@param	p	Required access permissions.
	@param	r	Pointer to result variable.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_key_open_perms(
  HKEY b, dkChar const *n, REGSAM p, HKEY *r, dk3_app_t *app
);

/**	Open registry key for read-only access.
	@param	b	Base key.
	@param	n	Key name.
	@param	r	Pointer to result variable.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_key_open_read(HKEY b, dkChar const *n, HKEY *r, dk3_app_t *app);

/**	Open registry key for modification.
	@param	b	Base key.
	@param	n	Key name.
	@param	r	Pointer to result variable.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_key_open_modify(HKEY b, dkChar const *n, HKEY *r, dk3_app_t *app);

/**	Open registry key for access as specified, create if necessary.
	@param	b	Base key.
	@param	n	Key name.
	@param	p	Permissions for access.
	@param	r	Pointer to result variable.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_key_create_perms(
  HKEY b,dkChar const *n,REGSAM p,HKEY *r,dk3_app_t *app
);

/**	Open registry key for read-only access, create if necessary.
	@param	b	Base key.
	@param	n	Key name.
	@param	r	Pointer to result variable.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_key_create_read(HKEY b, dkChar const *n, HKEY *r, dk3_app_t *app);

/**	Open registry key for modification, create if necessary.
	@param	b	Base key.
	@param	n	Key name.
	@param	r	Pointer to result variable.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_key_create_modify(HKEY b, dkChar const *n, HKEY *r, dk3_app_t *app);

/**	Close registry key.
	@param	k	Key to close.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_key_close(HKEY k, dkChar const *n, dk3_app_t *app);

/**	Remove registry key including all contents.
	@param	b	Base key.
	@param	n	Key name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_key_delete(HKEY b, dkChar const *n, dk3_app_t *app);

/**	Set REG_EXPAND_SZ entry.
	@param	k	Registry key.
	@param	n	Entry name.
	@param	v	Value.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_set_sz(HKEY k, dkChar const *n, dkChar const *v, dk3_app_t *app);

/**	Set REG_EXPAND_SZ entry.
	@param	k	Registry key.
	@param	n	Entry name.
	@param	v	Value.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_set_expand_sz(HKEY k, dkChar const *n, dkChar const *v, dk3_app_t *app);

/**	Set DWORD entry.
	@param	k	Registry key.
	@param	n	Entry name.
	@param	v	Value to set.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_set_dword(HKEY k, dkChar const *n, DWORD v, dk3_app_t *app);

/**	Get string entry (REG_EXPAND_SZ or REG_SZ).
	@param	k	Registry key.
	@param	n	Entry name.
	@param	b	Pointer to result buffer.
	@param	s	Result buffer size (number of dkChar).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_get_sz(HKEY k, dkChar const *n, dkChar *b, size_t s, dk3_app_t *app);

/**	Get string entry (REG_EXPAND_SZ or REG_SZ), save type.
	@param	k	Registry key.
	@param	n	Entry name.
	@param	b	Pointer to result buffer.
	@param	s	Result buffer size (number of dkChar).
	@param	e	Pointer to type variable.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_get_expand_sz(
  HKEY k, dkChar const *n, dkChar *b, size_t s, DWORD *e, dk3_app_t *app
);

/**	Get string entry, expand if necessary.
	@param	k	Registry key.
	@param	n	Entry name.
	@param	dp	Destination buffer.
	@param	ds	Destination buffer size (number of dkChar).
	@param	tp	Temporary buffer for unexpanded string.
	@param	ts	Size of temporary buffer (number of dkChar).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_get_expanded_sz(
  HKEY k, dkChar const * n, dkChar *dp, size_t ds, dkChar *tp, size_t ts,
  dk3_app_t *app
);

/**	Get DWORD registry entry.
	@param	k	Registry key.
	@param	n	Entry name.
	@param	b	Pointer to result buffer.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_get_dword(HKEY k, dkChar const *n, DWORD *b, dk3_app_t *app);

/**	Delete registry entry.
	@param	k	Registry key.
	@param	n	Entry name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3wreg_entry_delete(HKEY k, dkChar const *n, dk3_app_t *app);

#ifdef __cplusplus
}
#endif

#else

#endif


#endif
