/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3wreg.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3wreg.c The dk3wreg module.
*/


#line 201 "dk3wreg.ctr"

#include "dk3all.h"
#include "dk3wreg.h"


#if DK3_ON_WINDOWS && ((2 == DK3_CHAR_SIZE) || (1 == DK3_CHAR_SIZE))



static dkChar const * const	dk3wreg_default_texts[] = {
/* 0 */
dkT("dk3wreg.str"),

/* 1 */
dkT("Failed to open registry key!"),

/* 2 */
dkT("Failed to open registry key:\n\""),

/* 3 */
dkT("\"!"),

/* 4 */
dkT("Failed to open or create registry key!"),

/* 5 */
dkT("Failed to open or create registry key:\n\""),

/* 6 */
dkT("\"!"),

/* 7 */
dkT("Failed to close registry key!"),

/* 8 */
dkT("Failed to close registry key:\n\""),

/* 9 */
dkT("\"!"),

/* 10 */
dkT("Failed to write registry entry!"),

/* 11 */
dkT("Failed to write registry entry:\n\""),

/* 12 */
dkT("\"!"),

/* 13 */
dkT("Failed to retrieve registry entry!"),

/* 14 */
dkT("Failed to retrieve registry entry:\n\""),

/* 15 */
dkT("\"!"),

/* 16 */
dkT("Registry entry is not a string!"),

/* 17 */
dkT("Registry entry is not a string:\n\""),

/* 18 */
dkT("\"!"),

/* 19 */
dkT("Registry entry is not a DWORD!"),

/* 20 */
dkT("Registry entry is not a DWORD:\n\""),

/* 21 */
dkT("\"!"),

/* 22 */
dkT("Registry entry is an incomplete DWORD!"),

/* 23 */
dkT("Registry entry is an incomplete DWORD:\n\""),

/* 24 */
dkT("\"!"),

/* 25 */
dkT("Failed to delete registry key tree!"),

/* 26 */
dkT("Failed to delete registry key tree:\n\""),

/* 27 */
dkT("\"!"),

/* 28 */
dkT("Failed to delete registry entry!"),

/* 29 */
dkT("Failed to delete registry entry:\n\""),

/* 30 */
dkT("\"!"),

/* 31 */
dkT("String to long for result buffer!"),

/* 32 */
dkT("Environment variable expansion failed!"),

/* 33 */
dkT("Can not delete registry keys when compiled for legacy versions!"),

NULL


#line 292 "dk3wreg.ctr"
};



static
void
dk3wreg_report_error(
  dk3_app_t *app, dkChar const *n, size_t m1, size_t m2, size_t o
)
{
  dkChar const * const	*lmsg;	/* Localized messages. */
  

#line 304 "dk3wreg.ctr"
  if(app) {
    lmsg = dk3app_messages(
      app, dk3wreg_default_texts[0], (dkChar const **)dk3wreg_default_texts
    );
    if(lmsg) {
      if(n) {
        dk3app_log_3(app, DK3_LL_ERROR, lmsg, m1, m2, n);
      } else {
        dk3app_log_1(app, DK3_LL_ERROR, lmsg, o);
      }
    }
  } 

#line 316 "dk3wreg.ctr"
}


int
dk3wreg_key_open_perms(
  HKEY b, dkChar const *n, REGSAM p, HKEY *r, dk3_app_t *app
)
{
  int			 back = 0;
  long			 res;
  

#line 327 "dk3wreg.ctr"
  if((n) && (r)) {
#if 2 == DK3_CHAR_SIZE
    res = RegOpenKeyExW(
      b,			/* Base key. */
      n,			/* Subkey name. */
      (DWORD)0UL,		/* Reserviced. */
      p,			/* Required access. */
      r				/* Result pointer. */
    );
#else
    res = RegOpenKeyExA(
      b,			/* Base key. */
      n,			/* Subkey name. */
      (DWORD)0UL,		/* Reserviced. */
      p,			/* Required access. */
      r				/* Result pointer. */
    );
#endif
    if(ERROR_SUCCESS == res) {
      back = 1;
    } else {
      /* ERROR: Failed to open key! */
      dk3wreg_report_error(app, n, 2, 3, 1);
    }
  } 

#line 352 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_key_open_read(HKEY b, dkChar const *n, HKEY *r, dk3_app_t *app)
{
  int			 back = 0;
  

#line 362 "dk3wreg.ctr"
  back = dk3wreg_key_open_perms(b, n, KEY_QUERY_VALUE, r, app);
  

#line 364 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_key_open_modify(HKEY b, dkChar const *n, HKEY *r, dk3_app_t *app)
{
  int			 back = 0;
  

#line 374 "dk3wreg.ctr"
  back = dk3wreg_key_open_perms(b, n, KEY_ALL_ACCESS, r, app);
  

#line 376 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_key_create_perms(HKEY b,dkChar const *n,REGSAM p,HKEY *r,dk3_app_t *app)
{
  int			 back = 0;
  long			 res;
  DWORD			 disp = (DWORD)0UL;
  

#line 388 "dk3wreg.ctr"
  if((n) && (r)) {
#if 2 == DK3_CHAR_SIZE
    res = RegCreateKeyExW(
      b,				/* Base key. */
      n,				/* Key name. */
      (DWORD)0UL,			/* Reserved. */
      NULL,				/* Key class. */
      REG_OPTION_NON_VOLATILE,		/* Options. */
      p,				/* SAM desired. */
      NULL,				/* Security descriptor. */
      r,				/* Result pointer. */
      &disp				/* Disposition. */
    );
#else
    res = RegCreateKeyExA(
      b,				/* Base key. */
      n,				/* Key name. */
      (DWORD)0UL,			/* Reserved. */
      NULL,				/* Key class. */
      REG_OPTION_NON_VOLATILE,		/* Options. */
      p,				/* SAM desired. */
      NULL,				/* Security descriptor. */
      r,				/* Result pointer. */
      &disp				/* Disposition. */
    );
#endif
    if(ERROR_SUCCESS == res) {
      back = 1;
    } else {
      /* ERROR: Failed to open/create registry key! */
      dk3wreg_report_error(app, n, 5, 6, 4);
    }
  } 

#line 421 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_key_create_read(HKEY b, dkChar const *n, HKEY *r, dk3_app_t *app)
{
  int			 back = 0;
  

#line 431 "dk3wreg.ctr"
  back = dk3wreg_key_create_perms(b, n, KEY_QUERY_VALUE, r, app);
  

#line 433 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_key_create_modify(HKEY b, dkChar const *n, HKEY *r, dk3_app_t *app)
{
  int			 back = 0;
  

#line 443 "dk3wreg.ctr"
  back = dk3wreg_key_create_perms(b, n, KEY_ALL_ACCESS, r, app);
  

#line 445 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_key_close(HKEY k, dkChar const *n, dk3_app_t *app)
{
  int			 back = 0;
  long			 res;
  

#line 456 "dk3wreg.ctr"
  res = RegCloseKey(k);
  if(ERROR_SUCCESS == res) {
    back = 1;
  } else {
    /* ERROR: Failed to close registry key!. */
    dk3wreg_report_error(app, n, 8, 9, 7);
  } 

#line 463 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_key_delete(HKEY b, dkChar const *n, dk3_app_t *app)
{
  int			 back = 0;
#if _MSC_VER >= 1700
  long			 res;
  

#line 475 "dk3wreg.ctr"
  if(n) {
#if 2 == DK3_CHAR_SIZE
    res = RegDeleteTreeW(b, n);
#else
    res = RegDeleteTreeA(b, n);
#endif
    if(ERROR_SUCCESS == res) {
      back = 1;
    } else {
      dk3wreg_report_error(app, n, 26, 27, 25);
    }
  } 

#line 487 "dk3wreg.ctr"
#else
  dk3wreg_report_error(app, n, 26, 27, 25);
  dk3wreg_report_error(app, NULL, 0, 0, 33);
#endif
  return back;
}



int
dk3wreg_set_sz(HKEY k, dkChar const *n, dkChar const *v, dk3_app_t *app)
{
  int			 back = 0;
  DWORD			 dwt = REG_SZ;
  DWORD			 dw0 = (DWORD)0UL;
  DWORD			 sz;
  long			 res;
  

#line 505 "dk3wreg.ctr"
  if(v) {
    sz = (DWORD)(1 + dk3str_len(v));
    sz *= DK3_CHAR_SIZE;
#if 2 == DK3_CHAR_SIZE
    res = RegSetValueExW(
      k,			/* Key. */
      n,			/* Entry name. */
      dw0,			/* Reserved. */
      dwt,			/* Type. */
      (const BYTE *)v,		/* Data. */
      sz			/* Number of bytes. */
    );
#else
    res = RegSetValueExA(
      k,			/* Key. */
      n,			/* Entry name. */
      dw0,			/* Reserved. */
      dwt,			/* Type. */
      (const BYTE *)v,		/* Data. */
      sz			/* Number of bytes. */
    );
#endif
    if(ERROR_SUCCESS == res) {
      back = 1;
    } else {
      /* ERROR: Failed to save registry entry. */
      dk3wreg_report_error(app, n, 11, 12, 10);
    }
  } 

#line 534 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_set_expand_sz(HKEY k, dkChar const *n, dkChar const *v, dk3_app_t *app)
{
  int			 back = 0;
  DWORD			 dwt = REG_EXPAND_SZ;
  DWORD			 dw0 = (DWORD)0UL;
  DWORD			 sz;
  long			 res;
  

#line 548 "dk3wreg.ctr"
  if(v) {
    sz = (DWORD)(1 + dk3str_len(v));
    sz *= DK3_CHAR_SIZE;
#if 2 == DK3_CHAR_SIZE
    res = RegSetValueExW(
      k,			/* Key. */
      n,			/* Entry name. */
      dw0,			/* Reserved. */
      dwt,			/* Type. */
      (const BYTE *)v,		/* Data. */
      sz			/* Number of bytes. */
    );
#else
    res = RegSetValueExA(
      k,			/* Key. */
      n,			/* Entry name. */
      dw0,			/* Reserved. */
      dwt,			/* Type. */
      (const BYTE *)v,		/* Data. */
      sz			/* Number of bytes. */
    );
#endif
    if(ERROR_SUCCESS == res) {
      back = 1;
    } else {
      /* ERROR: Failed to save registry entry. */
      dk3wreg_report_error(app, n, 11, 12, 10);
    }
  } 

#line 577 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_set_dword(HKEY k, dkChar const *n, DWORD v, dk3_app_t *app)
{
  int			 back = 0;
  DWORD			 dwt = REG_DWORD;
  DWORD			 dw0 = (DWORD)0UL;
  DWORD			 sz;
  long			 res;
  

#line 591 "dk3wreg.ctr"
  if((n) && (v)) {
    sz = (DWORD)sizeof(DWORD);
#if 2 == DK3_CHAR_SIZE
    res = RegSetValueExW(
      k,			/* Key. */
      n,			/* Entry name. */
      dw0,			/* Reserved. */
      dwt,			/* Type. */
      (const BYTE *)(&v),	/* Data. */
      sz			/* Number of bytes. */
    );
#else
    res = RegSetValueExA(
      k,			/* Key. */
      n,			/* Entry name. */
      dw0,			/* Reserved. */
      dwt,			/* Type. */
      (const BYTE *)(&v),	/* Data. */
      sz			/* Number of bytes. */
    );
#endif
    if(ERROR_SUCCESS == res) {
      back = 1;
    } else {
      /* ERROR: Failed to save registry entry. */
      dk3wreg_report_error(app, n, 11, 12, 10);
    }
  } 

#line 619 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_get_expand_sz(
  HKEY k, dkChar const *n, dkChar *b, size_t s, DWORD *e, dk3_app_t *app
)
{
  int			 back = 0;
  DWORD			 dwt = REG_SZ;
  DWORD			 dws;
  long			 res;
  

#line 634 "dk3wreg.ctr"
  if((b) && (s)) {
    dws = (DWORD)(s * DK3_CHAR_SIZE);
#if 2 == DK3_CHAR_SIZE
    res = RegQueryValueExW(
      k,			/* Key. */
      n,			/* Entry name. */
      NULL,			/* Reserved. */
      &dwt,			/* Type. */
      (BYTE *)b,		/* Result buffer. */
      &dws			/* Size (number of bytes). */
    );
#else
    res = RegQueryValueExA(
      k,			/* Key. */
      n,			/* Entry name. */
      NULL,			/* Reserved. */
      &dwt,			/* Type. */
      (BYTE *)b,		/* Result buffer. */
      &dws			/* Size (number of bytes). */
    );
#endif
    if(ERROR_SUCCESS == res) {
      switch(dwt) {
        case REG_SZ: case REG_EXPAND_SZ: {
	  if(e) { *e = dwt; }
	  back = 1;
	  if(0UL < dws) {
#if 1 < DK3_CHAR_SIZE
	    dws = dws / DK3_CHAR_SIZE;
#endif
	    if(0UL < dws) {
	      if(dws < (DWORD)s) {
	        b[dws] = dkT('\0');
	      } else {
	        b[s - 1] = dkT('\0');
	      }
	    } else {
	      *b = dkT('\0');
	    }
	  } else {
	    *b = dkT('\0');
	  }
	} break;
	default: {
	  *b = dkT('\0');
	  /* ERROR: Not a string value! */
          dk3wreg_report_error(app, n, 17, 18, 16);
	} break;
      }
    } else {
      *b = dkT('\0');
      /* ERROR: Failed to retrieve value! */
      dk3wreg_report_error(app, n, 14, 15, 13);
    }
  }
  

#line 690 "dk3wreg.ctr"
  

#line 691 "dk3wreg.ctr"
  

#line 692 "dk3wreg.ctr"
  

#line 693 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_get_sz(HKEY k, dkChar const *n, dkChar *b, size_t s, dk3_app_t *app)
{
  int			 back = 0;
  

#line 703 "dk3wreg.ctr"
  back = dk3wreg_get_expand_sz(k, n, b, s, NULL, app);
  

#line 705 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_get_expanded_sz(
  HKEY k, dkChar const * n, dkChar *dp, size_t ds, dkChar *tp, size_t ts,
  dk3_app_t *app
)
{
  DWORD			 fe;		/* Flag: Expand. */
  DWORD			 res;		/* Result from expand function. */
  int			 back = 0;
  

#line 720 "dk3wreg.ctr"
  if((n) && (dp) && (ds) && (tp) && (ts)) {
    dp[0] = dkT('\0');
    fe    = REG_SZ;
    if(dk3wreg_get_expand_sz(k, n, tp, ts, &fe, app)) {
      if(REG_EXPAND_SZ == fe) {
        res = ExpandEnvironmentStrings(tp, dp, (DWORD)ds);
	if(0 < res) {
	  if((size_t)res < ds) {
	    back = 1;
	  } else {
	    /* ERROR: String too long for final buffer! */
	    dk3wreg_report_error(app, NULL, 0, 0, 31);
	  }
	} else {
	  /* ERROR: Expansion failed! */
	  dk3wreg_report_error(app, NULL, 0, 0, 32);
	}
      } else {
        if(dk3str_len(tp) < ds) {
	  dk3str_cpy(dp, tp);
	  back = 1;
	} else {
	  /* ERROR: String too long for final buffer! */
          dk3wreg_report_error(app, NULL, 0, 0, 31);
	}
      }
    }
  }
  

#line 749 "dk3wreg.ctr"
  

#line 750 "dk3wreg.ctr"
  

#line 751 "dk3wreg.ctr"
  

#line 752 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_get_dword(HKEY k, dkChar const *n, DWORD *b, dk3_app_t *app)
{
  int			 back = 0;
  DWORD			 dwt = REG_DWORD;
  DWORD			 dws;
  DWORD			 dwres;
  long			 res;
  

#line 766 "dk3wreg.ctr"
  if((n) && (b)) {
    dws = (DWORD)sizeof(DWORD);
    dwres = (DWORD)0UL;
#if 2 == DK3_CHAR_SIZE
    res = RegQueryValueExW(
      k, n, NULL, &dwt, (BYTE *)(&dwres), &dws
    );
#else
    res = RegQueryValueExA(
      k, n, NULL, &dwt, (BYTE *)(&dwres), &dws
    );
#endif
    if(ERROR_SUCCESS == res) {
      switch(dwt) {
        case REG_DWORD: {
	  if((DWORD)sizeof(DWORD) == dws) {
	    *b = dwres;
	    back = 1;
	  } else {
	    /* ERROR: Incomplete value! */
            dk3wreg_report_error(app, n, 23, 24, 22);
	  }
	} break;
	default: {
	  /* ERROR: Not a DWORD entry! */
          dk3wreg_report_error(app, n, 20, 21, 19);
	} break;
      }
    } else {
      /* ERROR: Failed to retrieve value! */
      dk3wreg_report_error(app, n, 14, 15, 13);
    }
  } 

#line 799 "dk3wreg.ctr"
  return back;
}



int
dk3wreg_entry_delete(HKEY k, dkChar const *n, dk3_app_t *app)
{
  int			 back = 0;
  long			 res;
  

#line 810 "dk3wreg.ctr"
  if(n) {
#if 2 == DK3_CHAR_SIZE
    res = RegDeleteValueW(k, n);
#else
    res = RegDeleteValueA(k, n);
#endif
    if(ERROR_SUCCESS == res) {
      back = 1;
    } else {
      dk3wreg_report_error(app, n, 29, 30, 28);
    }
  } 

#line 822 "dk3wreg.ctr"
  return back;
}



#else

#endif

