/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3ufi.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3UFI_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3UFI_H_INCLUDED 1


#line 9 "dk3ufi.ctr"

#include "dk3types.h"

/**	Unique file identifier.
	If two files produce the same UFI they are both links
	to the same file or different file name notations
	pointing to the same file, i.e. "x.txt" and "./x.txt".
*/
typedef struct {
#if DK3_ON_WINDOWS
  DWORD		volser;		/**< Volume serial number. */
  DWORD		indhigh;	/**< Higner index part. */
  DWORD		indlow;		/**< Lower index part. */
#else
  dk3_um_t	device;		/**< Device number. */
  dk3_um_t	inode;		/**< Inode number. */
#endif
} dk3_ufi_t;



#ifdef __cplusplus
extern "C" {
#endif

/**	Obtain unique identifier for file.
	@param	pd	Result buffer pointer.
	@param	fn	File name to check.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3ufi_get_app(dk3_ufi_t *pd, dkChar const *fn, dk3_app_t *app);

/**	Obtain unique identifier for file.
	@param	pd	Result buffer pointer.
	@param	fn	File name to check (8-bit character string).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3ufi_c8_get_app(dk3_ufi_t *pd, char const *fn, dk3_app_t *app);

/**	Obtain unique identifier for file.
	@param	pd	Result buffer pointer.
	@param	fn	File name to check.
	@return	1 on success, 0 on error.
*/
int
dk3ufi_get(dk3_ufi_t *pd, dkChar const *fn);

/**	Obtain unique identifier for file.
	@param	pd	Result buffer pointer.
	@param	fn	File name to check (8-bit character string).
	@return	1 on success, 0 on error.
*/
int
dk3ufi_c8_get(dk3_ufi_t *pd, char const *fn);

/**	Compare two file identifiers.
	@param	l	Left identifier.
	@param	r	Right identifier.
	@param	cr	Comparison criteria (ignored).
	@return	Comparison result.
*/
int
dk3ufi_compare(void const *l, void const *r, int cr);

#ifdef __cplusplus
}
#endif


#endif
