/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3ufi.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3ufi.c The dk3ufi module.
*/


#line 82 "dk3ufi.ctr"

#include "dk3all.h"
#include "dk3ufi.h"





#line 89 "dk3ufi.ctr"



int
dk3ufi_get_app(dk3_ufi_t *pd, dkChar const *fn, dk3_app_t *app)
{
#if DK3_ON_WINDOWS
  BY_HANDLE_FILE_INFORMATION	bhfi;
#endif
  dk3_stat_t	 		stb;
#if DK3_ON_WINDOWS
  HANDLE			hFile;
  int				i;
#endif
  int		 		back = 0;
  

#line 105 "dk3ufi.ctr"
  if((pd) && (fn)) {
    if(dk3sf_stat_app(&stb, fn, app)) {
      switch(stb.ft & (~(DK3_FT_SYMLINK))) {
        case DK3_FT_REGULAR: {
#if DK3_ON_WINDOWS
	  for(i = 0; ((i < 2) && (0 == back)); i++) {
#if DK3_CHAR_SIZE > 2
	    hFile = INVALID_HANDLE_VALUE;
#else
#if DK3_CHAR_SIZE > 1
            

#line 116 "dk3ufi.ctr"
            hFile = CreateFileW(
              fn,
	      ((0 == i) ? (FILE_READ_ATTRIBUTES) : 0),
	      (FILE_SHARE_READ),
	      NULL,
	      OPEN_EXISTING,
	      FILE_ATTRIBUTE_NORMAL,
	      NULL
            );
#else
            

#line 127 "dk3ufi.ctr"
            hFile = CreateFileA(
              fn,
	      ((0 == i) ? (FILE_READ_ATTRIBUTES) : 0),
	      (FILE_SHARE_READ),
	      NULL,
	      OPEN_EXISTING,
	      FILE_ATTRIBUTE_NORMAL,
	      NULL
            );
#endif
#endif
	    if(INVALID_HANDLE_VALUE != hFile) {
	      if(GetFileInformationByHandle(hFile, &bhfi)) {
	        back = 1;	

#line 141 "dk3ufi.ctr"
		i = 2;
		pd->volser = bhfi.dwVolumeSerialNumber;
		pd->indhigh = bhfi.nFileIndexHigh;
		pd->indlow = bhfi.nFileIndexLow;
	      } else {
	        /* ERROR: Failed to obtain file information! */
		dk3app_log_i3(app, DK3_LL_ERROR, 366, 367, fn);
	      }
	      CloseHandle(hFile); hFile = INVALID_HANDLE_VALUE;
	    } else {
	      /* ERROR: Failed to obtain file information! */
	      dk3app_log_i3(app, DK3_LL_ERROR, 366, 367, fn);
	    }
	  }
#else
	  pd->device = stb.device;
	  pd->inode = stb.inode;
	  back = 1;
#endif
	} break;
	case DK3_FT_DIRECTORY: {		

#line 162 "dk3ufi.ctr"
#if DK3_ON_WINDOWS
	  for(i = 0; ((i < 2) && (0 == back)); i++) {
#if DK3_CHAR_SIZE > 2
	    hFile = INVALID_HANDLE_VALUE;
#else
#if DK3_CHAR_SIZE > 1
            

#line 169 "dk3ufi.ctr"
            hFile = CreateFileW(
              fn,
	      ((0 == i) ? (FILE_READ_ATTRIBUTES) : 0),
	      (FILE_SHARE_READ),
	      NULL,
	      OPEN_EXISTING,
	      (FILE_ATTRIBUTE_NORMAL | FILE_FLAG_BACKUP_SEMANTICS),
	      NULL
            );
#else
            

#line 180 "dk3ufi.ctr"
            hFile = CreateFileA(
              fn,
	      ((0 == i) ? (FILE_READ_ATTRIBUTES) : 0),
	      (FILE_SHARE_READ),
	      NULL,
	      OPEN_EXISTING,
	      (FILE_ATTRIBUTE_NORMAL | FILE_FLAG_BACKUP_SEMANTICS),
	      NULL
            );
#endif
#endif
	    if(INVALID_HANDLE_VALUE != hFile) {
	      if(GetFileInformationByHandle(hFile, &bhfi)) {
	        back = 1;	

#line 194 "dk3ufi.ctr"
		i = 2;
		pd->volser = bhfi.dwVolumeSerialNumber;
		pd->indhigh = bhfi.nFileIndexHigh;
		pd->indlow = bhfi.nFileIndexLow;
	      } else {	

#line 199 "dk3ufi.ctr"
	        /* ERROR: Failed to obtain file information! */
	        dk3app_log_i3(app, DK3_LL_ERROR, 366, 367, fn);
	      }
	      CloseHandle(hFile); hFile = INVALID_HANDLE_VALUE;
	    } else {	

#line 204 "dk3ufi.ctr"
	      /* ERROR: Failed to obtain file information */
	      dk3app_log_i3(app, DK3_LL_ERROR, 366, 367, fn);
	    }
	  }
#else
	  pd->device = stb.device;
	  pd->inode = stb.inode;
	  back = 1;
#endif
	} break;
	default: {				

#line 215 "dk3ufi.ctr"
	} break;
      }
    } else {					

#line 218 "dk3ufi.ctr"
    }
  } else {					

#line 220 "dk3ufi.ctr"
  } 

#line 221 "dk3ufi.ctr"
  return back;
}



int
dk3ufi_c8_get_app(dk3_ufi_t *pd, char const *fn, dk3_app_t *app)
{
#if DK3_ON_WINDOWS
  BY_HANDLE_FILE_INFORMATION	bhfi;
#endif
  dk3_stat_t	 		stb;
#if DK3_ON_WINDOWS
  HANDLE			hFile;
  int				i;
#endif
  int		 		back = 0;
  

#line 239 "dk3ufi.ctr"
  if((pd) && (fn)) {
    if(dk3sf_c8_stat_app(&stb, fn, app)) {
      switch(stb.ft & (~(DK3_FT_SYMLINK))) {
        case DK3_FT_REGULAR: {
#if DK3_ON_WINDOWS
	  for(i = 0; ((i < 2) && (0 == back)); i++) {
            

#line 246 "dk3ufi.ctr"
            hFile = CreateFileA(
              fn,
	      ((0 == i) ? (FILE_READ_ATTRIBUTES) : 0),
	      (FILE_SHARE_READ),
	      NULL,
	      OPEN_EXISTING,
	      FILE_ATTRIBUTE_NORMAL,
	      NULL
            );
	    if(INVALID_HANDLE_VALUE != hFile) {
	      if(GetFileInformationByHandle(hFile, &bhfi)) {
	        back = 1;	

#line 258 "dk3ufi.ctr"
		i = 2;
		pd->volser = bhfi.dwVolumeSerialNumber;
		pd->indhigh = bhfi.nFileIndexHigh;
		pd->indlow = bhfi.nFileIndexLow;
	      } else {
	        /* ERROR: Failed to obtain file information! */
#if DK3_CHAR_SIZE == 1
	        dk3app_log_i3(app, DK3_LL_ERROR, 366, 367, fn);
#else
	        dk3app_log_i1(app, DK3_LL_ERROR, 368);
#endif
	      }
	      CloseHandle(hFile); hFile = INVALID_HANDLE_VALUE;
	    } else {
	      /* ERROR: Failed to obtain file information! */
#if DK3_CHAR_SIZE == 1
	      dk3app_log_i3(app, DK3_LL_ERROR, 366, 367, fn);
#else
	      dk3app_log_i1(app, DK3_LL_ERROR, 368);
#endif
	    }
	  }
#else
	  pd->device = stb.device;
	  pd->inode = stb.inode;
	  back = 1;
#endif
	} break;
	case DK3_FT_DIRECTORY: {		

#line 287 "dk3ufi.ctr"
#if DK3_ON_WINDOWS
	  for(i = 0; ((i < 2) && (0 == back)); i++) {
            

#line 290 "dk3ufi.ctr"
            hFile = CreateFileA(
              fn,
	      ((0 == i) ? (FILE_READ_ATTRIBUTES) : 0),
	      (FILE_SHARE_READ),
	      NULL,
	      OPEN_EXISTING,
	      (FILE_ATTRIBUTE_NORMAL | FILE_FLAG_BACKUP_SEMANTICS),
	      NULL
            );
	    if(INVALID_HANDLE_VALUE != hFile) {
	      if(GetFileInformationByHandle(hFile, &bhfi)) {
	        back = 1;	

#line 302 "dk3ufi.ctr"
		i = 2;
		pd->volser = bhfi.dwVolumeSerialNumber;
		pd->indhigh = bhfi.nFileIndexHigh;
		pd->indlow = bhfi.nFileIndexLow;
	      } else {	

#line 307 "dk3ufi.ctr"
	        /* ERROR: Failed to obtain file information! */
#if DK3_CHAR_SIZE == 1
	        dk3app_log_i3(app, DK3_LL_ERROR, 366, 367, fn);
#else
	        dk3app_log_i1(app, DK3_LL_ERROR, 368);
#endif
	      }
	      CloseHandle(hFile); hFile = INVALID_HANDLE_VALUE;
	    } else {	

#line 316 "dk3ufi.ctr"
	      /* ERROR: Failed to obtain file information! */
#if DK3_CHAR_SIZE == 1
	      dk3app_log_i3(app, DK3_LL_ERROR, 366, 367, fn);
#else
	      dk3app_log_i1(app, DK3_LL_ERROR, 368);
#endif
	    }
	  }
#else
	  pd->device = stb.device;
	  pd->inode = stb.inode;
	  back = 1;
#endif
	} break;
	default: {				

#line 331 "dk3ufi.ctr"
	} break;
      }
    } else {					

#line 334 "dk3ufi.ctr"
    }
  } else {					

#line 336 "dk3ufi.ctr"
  } 

#line 337 "dk3ufi.ctr"
  

#line 338 "dk3ufi.ctr"
  return back;
}



int
dk3ufi_get(dk3_ufi_t *pd, dkChar const *fn)
{
  int back;
  back = dk3ufi_get_app(pd, fn, NULL);
  return back;
}



int
dk3ufi_c8_get(dk3_ufi_t *pd, char const *fn)
{
  int back;
  back = dk3ufi_c8_get_app(pd, fn, NULL);
  return back;
}



int
dk3ufi_compare(void const *l, void const *r, int cr)
{
  int			 back = 0;
  dk3_ufi_t const	*pl;
  dk3_ufi_t const	*pr;
  if(l) {
    if(r) {
      pl = (dk3_ufi_t const *)l; pr = (dk3_ufi_t const *)r;
#if DK3_ON_WINDOWS
      if(pl->volser < pr->volser) {
        back = -1;
      } else {
        if(pl->volser > pr->volser) {
	  back = 1;
	}
      }
      if(0 == back) {
        if(pl->indhigh < pr->indhigh) {
	  back = -1;
	} else {
	  if(pl->indhigh > pr->indhigh) {
	    back = 1;
	  }
	}
      }
      if(0 == back) {
        if(pl->indlow < pr->indlow) {
	  back = -1;
	} else {
	  if(pl->indlow > pr->indlow) {
	    back = 1;
	  }
	}
      }
#else
      if(pl->device < pr->device) {
        back = -1;
      } else {
        if(pl->device > pr->device) {
	  back = 1;
	}
      }
      if(0 == back) {
        if(pl->inode < pr->inode) {
	  back = -1;
	} else {
	  if(pl->inode > pr->inode) {
	    back = 1;
	  }
	}
      }
#endif
    } else back = 1;
  } else {
    if(r) back = -1;
  }
  return back;
}


