/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3uc2l.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3UC2L_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3UC2L_H_INCLUDED 1


#line 10 "dk3uc2l.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**	Open LaTeX encoder.
	@param	d	Directory containing the tables.
	@param	f_desc	Flag: Attempt to load glyph descriptions.
	@param	f_utf8	Flag: UTF-8 output encoding.
	@param	app	Application structurefor diagnostics, may be NULL.
	@return	Pointer to new encoder on success, NULL on error.
*/
dk3_uc2lat_t *
dk3uc2lat_open_app(dkChar const *d, int f_desc, int f_utf8, dk3_app_t *app);

/**	Close LaTeX encoder.
	@param	u	Encoder to close.
*/
void
dk3uc2lat_close(dk3_uc2lat_t *u);

/**	Retrieve LaTeX encoding for one 32-bit character.
	@param	u	LaTeX encoder.
	@param	c32	Character to obtain LaTeX encoding for.
	@param	ismath	Flag: In math mode.
	@return	Pointer to encoding on success, NULL on error.
*/
char const *
dk3uc2lat_get(dk3_uc2lat_t *u, dk3_c32_t c32, int ismath);

/**	Check whether a character can be written to a LaTeX file directly.
	@param	c32	Character to check.
	@return	1 for yes, 0 for no.
*/
int
dk3uc2lat_direct(dk3_c32_t c32);

/**	Write LaTeX encoding for a string to a stream.
	@param	u	LaTeX encoder.
	@param	st	Stream to write to.
	@param	t	Text to write (ASCII/ISO-LATIN-1 encoded).
	@return	1 on success, 0 on error.
*/
int
dk3uc2lat_c8_plain_stputs(dk3_uc2lat_t *u, dk3_stream_t *st, char const *t);

/**	Write LaTeX encoding for a string to a stream.
	@param	u	LaTeX encoder.
	@param	st	Stream to write to.
	@param	t	Text to write (UTF-8 encoded).
	@return	1 on success, 0 on error.
*/
int
dk3uc2lat_c8_utf8_stputs(dk3_uc2lat_t *u, dk3_stream_t *st, char const *t);

/**	Write LaTeX encoding for a string to a stream.
	@param	u	LaTeX encoder.
	@param	st	Stream to write to.
	@param	t	Text to write (UTF-16 encoded).
	@return	1 on success, 0 on error.
*/
int
dk3uc2lat_c16_stputs(dk3_uc2lat_t *u, dk3_stream_t *st, dk3_c16_t const *t);

/**	Write LaTeX encoding for a string to a stream.
	@param	u	LaTeX encoder.
	@param	st	Stream to write to.
	@param	t	Text to write (32-bit characters).
	@return	1 on success, 0 on error.
*/
int
dk3uc2lat_c32_stputs(dk3_uc2lat_t *u, dk3_stream_t *st, dk3_c32_t const *t);

/**	Write LaTeX encoding for a string to a stream.
	@param	u	LaTeX encoder.
	@param	st	Stream to write to.
	@param	t	Text to write (dkChar characters).
	@param	e	Encoding (only used for 8-bit characters).
	@return	1 on success, 0 on error.
*/
int
dk3uc2lat_stputs(dk3_uc2lat_t *u, dk3_stream_t *st, dkChar const *t, int e);

/**	Prepare LaTeX encoder to retrieve package information.
	@param	u	LaTeX encoder.
*/
void
dk3uc2lat_package_reset(dk3_uc2lat_t *u);

/**	Retrieve next package information from LaTeX encoder.
	@param	u	LaTeX encoder.
	@return	Pointer to next package information or NULL.
*/
dk3_uc2lat_pkg_t *
dk3uc2lat_package_next(dk3_uc2lat_t *u);

/**	Reset font encoding information.
	@param	u	LaTeX encoder.
*/
void
dk3uc2lat_font_encoding_reset(dk3_uc2lat_t *u);

/**	Check for font encoding conflicts.
	@param	u	LaTeX encoder.
	@return	1 on conflicts, 0 otherwise (no problems).
*/
int
dk3uc2lat_font_encoding_conflict(dk3_uc2lat_t *u);

/**	Report font encoding requirement conflicts.
	@param	u	LaTeX encoder.
*/
void
dk3uc2lat_font_encoding_report_conflict(dk3_uc2lat_t *u);

/**	Report font encoding requirement conflicts.
	@param	u	LaTeX encoder.
*/
void
dk3uc2lat_font_encoding_report(dk3_uc2lat_t *u);

#ifdef __cplusplus
}
#endif




#endif
