/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3trace.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3trace.c The dk3trace module.
*/


#line 142 "dk3trace.ctr"

#include "dk3all.h"
#include <stdio.h>

#if DK3_TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if DK3_HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#if DK3_HAVE_TIME_H
#include <time.h>
#endif
#endif
#endif



/**	Inside the dk3trace module.
*/
#define DK3_TRACE_C 1

#include "dk3trace.h"



/**	Output file.
*/
static FILE *trace_file = NULL;


/**	Timestamp of previous trace message.
*/
static time_t	dk3trace_last_time	= (time_t)0UL;



void
dktrace_end(void)
/* {{{ */
{
  if(trace_file) {
    (void)fclose(trace_file);
    trace_file = NULL;
  }
}
/* }}} */



void
dk_trace_end(void)
/* {{{*/
{
  dktrace_end();
}
/* }}} */



void
dktrace_init(char const *filename)
/* {{{ */
{
  FILE *x;
  if(filename) {
#if DK3_HAVE_LARGEFILE64_SOURCE && DK3_HAVE_FOPEN64
    x = fopen64(filename, "w");
#else
    x = fopen(filename, "w");
#endif
    if(x) {
      dktrace_end();
      trace_file = x;
    }
  }
}
/* }}} */



void
dk_trace_init(char const *filename)
/* {{{ */
{
  dktrace_init(filename);
}
/* }}} */


FILE *
dktrace_file(void)
/* {{{ */
{
  return trace_file;
}
/* }}} */



FILE *
dk_trace_file(void)
/* {{{ */
{
  FILE *back;
  back = dktrace_file();
  return back;
}
/* }}} */



/**	Write time to output file.
	@param	f	Output file.
*/
static
void
dk3trace_i_time(FILE *f)
/* {{{ */
{
#if DK3_HAVE_TIME_H || DK3_HAVE_SYS_TIME_H
  time_t timer;
  struct tm *tm;
  if(f) {
    (void)time(&timer);
    if(dk3trace_last_time != timer) {
      dk3trace_last_time = timer;
      tm = localtime(&timer);
      if(tm) {
        fprintf(f,
	    "# %04d/%02d/%02d %02d:%02d:%02d\n",
	    (1900 + tm->tm_year),
	    (1 + tm->tm_mon),
	    tm->tm_mday,
	    tm->tm_hour,
	    tm->tm_min,
	    tm->tm_sec
        );
      }
    }
  }
#endif
}
/* }}} */



#if DK3_ON_WINDOWS
/**	Write time to output file.
	@param	f	Output file.
*/
static
void
dk3trace_i_wtime(FILE *f)
/* {{{ */
{
#if DK3_HAVE_TIME_H || DK3_HAVE_SYS_TIME_H
  time_t timer;
  struct tm *tm;
  if(f) {
    time(&timer);
    if(dk3trace_last_time != timer) {
      dk3trace_last_time = timer;
      tm = localtime(&timer);
      if(tm) {
        fwprintf(f,
	    L"# %04d/%02d/%02d %02d:%02d:%02d\n",
	    (1900 + tm->tm_year),
	    (1 + tm->tm_mon),
	    tm->tm_mday,
	    tm->tm_hour,
	    tm->tm_min,
	    tm->tm_sec
        );
      }
    }
  }
#endif
}
/* }}} */
#endif



void
dktrace_time(void)
/* {{{ */
{
  if(trace_file) {
    dk3trace_i_time(trace_file);
  }
}
/* }}} */



void
dktrace_stdout_time(void)
/* {{{ */
{
  dk3trace_i_time(stdout);
}
/* }}} */



#if DK3_ON_WINDOWS
void
dktrace_wtime(void)
/* {{{ */
{
  if(trace_file) {
    dk3trace_i_wtime(trace_file);
  }
}
/* }}} */



void
dktrace_stdout_wtime(void)
/* {{{ */
{
  dk3trace_i_wtime(stdout);
}
/* }}} */
#endif



void
dk_trace_time(void)
/* {{{ */
{
  dktrace_time();
}
/* }}} */



/* vim: set ai sw=2 filetype=c foldmethod=marker foldopen=all : */

