/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3strmg.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3strmg.c The dk3strmg module.
*/


#line 10 "dk3strmg.ctr"

#include "dk3all.h"






#line 16 "dk3strmg.ctr"


/**	Low-level stream function to deal with gzip compression.
	Closing the stream also closes the gzip-file.
	@param	api	API structure.
*/
static
void
dk3stream_gz_fct(dk3_stream_api_t *api)
{
#if DK3_HAVE_ZLIB_H
  int		res = 0;	/* Operation result. */
  gzFile	g = NULL;	/* Low-level I/O object. */
#endif
  api->suc = 0;
  (api->res).sz = 0;
  (api->res).ec = DK3_ERROR_NOT_SUPPORTED;
#if DK3_HAVE_ZLIB_H
  (api->res).ec = 0;
  g = (gzFile)((api->arg).d);
  switch(api->cmd) {
    case DK3_STREAM_API_READ: {
      if(((api->arg).b) && ((api->arg).sz) && ((api->arg).d)) {
        res = gzread(g, (api->arg).b, (int)((api->arg).sz));
	if(res > 0) {
	  api->suc = 1; (api->res).ec = 0; (api->res).sz = (size_t)res;
	}
      }
    } break;
    case DK3_STREAM_API_WRITE: {
      if(((api->arg).b) && ((api->arg).sz) && ((api->arg).d)) {
        res = gzwrite(g, (api->arg).b, (int)((api->arg).sz));
	(api->res).sz = (size_t)res;
	if((size_t)res == (api->arg).sz) {
	  api->suc = 1; (api->res).ec = 0;
	}
      }
    } break;
    case DK3_STREAM_API_FLUSH: {
      if((api->arg).d) {
        if(gzflush(g, Z_FULL_FLUSH) == Z_OK) {
	  api->suc = 1; (api->res).ec = 0;
	}
      }
    } break;
    case DK3_STREAM_API_AT_END: {
      if((api->arg).d) {
        if(gzeof(g) == 1) {
	  api->suc = 1;
	}
      }
    } break;
    case DK3_STREAM_API_CLOSE: {
      if((api->arg).d) {
        if(gzclose(g) == Z_OK) {
	  api->suc = 1;
	}
      }
    } break;
    case DK3_STREAM_API_ZERO_IS_END: {
      api->suc = 0;
    } break;
    case DK3_STREAM_API_ERROR: {
      api->suc = 0;
    } break;
  }
#endif
}



/**	Low-level stream function to deal with gzip compression.
	Closing the stream does not close the gzip-file.
	@param	api	API structure.
*/
static
void
dk3stream_gz_fct_no_close(dk3_stream_api_t *api)
{
  if(api->cmd != DK3_STREAM_API_CLOSE) {
    dk3stream_gz_fct(api);
  } else {
    api->suc = 1; (api->res).ec = 0;
  }
}


#if DK3_HAVE_ZLIB_H

/**	Open stream for existing gzFile.
	@param	g	gzFile already opened.
	@param	fl	Read/write flags.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to new stream on success, NULL on error.
*/
dk3_stream_t *
dk3stream_open_gz_app(gzFile g, int fl, dk3_app_t *app)
{
  dk3_stream_t *back = NULL;
  if(g) {
    back = dk3stream_open_app((void *)g, dk3stream_gz_fct_no_close, fl, app);
  }
  return back;
}

#endif



/* vim: set ai sw=2 : */

