/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3strm.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3STRM_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3STRM_H_INCLUDED 1


#line 10 "dk3strm.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**	Open a stream, allocate memory.
	@param	d	Stream data object.
	@param	f	Stream low-level function.
	@param	fl	Flags to indicate read and/or write access.
	@param	app	Application structure, used for diagnostics.
	@return	Pointer to new stream on success, NULL on error.
*/
dk3_stream_t *
dk3stream_open_app(void *d, dk3_stream_api_fct_t *f, int fl, dk3_app_t *app);

/**	Close a stream, release memory.
	@param	st	Stream to close.
	@return	1 on success, 0 on error.
*/
int
dk3stream_close(dk3_stream_t *st);

/**	Set up automatic flushing when writing newlines.
	@param	st	Stream to set up.
	@param	fl	Flag value (0=no flush, 1=flush buffer,
	2=buffer and low-level object).
	@return	1 on success, 0 on error.
*/
int
dk3stream_set_line_flush(dk3_stream_t *st, int fl);

/**	Write a buffer of bytes to stream.
	@param	st	Stream to write to.
	@param	sb	Source buffer.
	@param	sz	Size of \ sb (number of bytes).
	The size must not exceed 32767 as it is converted to int
	for some compression libraries.
	@return	Number of bytes written.
*/
size_t
dk3stream_write_bytes(dk3_stream_t *st, char const *sb, size_t sz);

/**	Read bytes into buffer.
	@param	st	Stream to read from.
	@param	db	Destination buffer address.
	@param	sz	Size of \a db in bytes.
	The size must not exceed 32767 as it is converted to int
	for some compression libraries.
	@return	Number of bytes read (may be 0).
*/
size_t
dk3stream_read_bytes(dk3_stream_t *st, char *db, size_t sz);

/**	Check whether end of input data was reached.
	@param	st	Stream to check.
	@return	1 for end of input reached, 0 otherwise.
*/
int
dk3stream_feof(dk3_stream_t const *st);

/**	Get a text line (8-bit characters).
	@param	st	Stream to read from.
	@param	db	Destination buffer.
	@param	sz	Size of \a db in bytes.
	The size must not exceed 32767 as it is converted to int
	for some compression libraries.
	@return	1 on success (line found), 0 on error.
*/
int
dk3stream_c8_fgets(dk3_stream_t *st, char *db, size_t sz);

/**	Write a text line (8-bit characters) without any re-encoding.
	@param	st	Stream to write to.
	@param	str	Text to write.
	@return	1 on success, 0 on error.
*/
int
dk3stream_c8_fputs(dk3_stream_t *st, char const *str);

/**	Set output encoding.
	@param	st	Stream to set up.
	@param	oe	New output encoding.
*/
void
dk3stream_set_output_encoding(dk3_stream_t *st, int oe);

/**	Write byte order marker 0xFEFF converted to the streams
	output encoding.
	@param	st	Stream to write to.
	@return	1 on success, 0 on error.
*/
int
dk3stream_write_byte_order_marker(dk3_stream_t *st);

/**	Write byte order marker if necessary on the system.
	@param	st	Stream to write to.
	@param	se	System encoding.
	@return	1 on success, 0 on error.
*/
int
dk3stream_write_byte_order_marker_if_necessary(dk3_stream_t *st, int se);

/**	Write 8-bit character text, convert to the streams output encoding.
	@param	st	Stream to write to.
	@param	s	String to write.
	@return	1 on success, 0 on error.
*/
int
dk3stream_fputs_c8_plain(dk3_stream_t *st, char const *s);

/**	Write UTF-8 encoded text, convert to the streams output encoding.
	@param	st	Stream to write to.
	@param	s	String to write.
	@return	1 on success, 0 on error.
*/
int
dk3stream_fputs_c8_utf8(dk3_stream_t *st, char const *s);

/**	Write UTF-16 encoded text, convert to the streams output encoding.
	@param	st	Stream to write to.
	@param	s	String to write.
	@return	1 on success, 0 on error.
*/
int
dk3stream_fputs_c16(dk3_stream_t *st, dk3_c16_t const *s);

/**	Write UNICODE text, convert to the streams output encoding.
	@param	st	Stream to write to.
	@param	s	String to write.
	@return	1 on success, 0 on error.
*/
int
dk3stream_fputs_c32(dk3_stream_t *st, dk3_c32_t const *s);

/**	Write generic dkChar text, convert to the streams output encoding.
	@param	st	Stream to write to.
	@param	s	String to write.
	@param	ie	Input encoding (used for 8-bit characters only).
	@return	1 on success, 0 on error.
*/
int
dk3stream_strputs(dk3_stream_t *st, dkChar const *s, int ie);

/**	Write newline to stream.
	@param	st	Stream to write to.
	@return	1 on success, 0 on error.
*/
int
dk3stream_strnl(dk3_stream_t *st);

/**	Get number of bytes written.
	@param	st	Stream to check.
	@return	Number of bytes written to the stream.
*/
dk3_um_t
dk3stream_bytes_written(dk3_stream_t const *st);

/**	Open stream for a file. The file is not closed when the stream
	is closed.
	@param	fi	File.
	@param	fl	Read/write flags.
	@param	app	Application structure, used for diagnostics.
	@return	Stream pointer on success, NULL on error.
*/
dk3_stream_t *
dk3stream_open_file_app(FILE *fi, int fl, dk3_app_t *app);

/**	Get 16-bit text line.
	@param	st	Stream.
	@param	db	Destination buffer.
	@param	sz	Size of \a db (number of 16-bit characters).
	The size must not exceed 16383 as buffer sizes arre converted to int
	for some compression libraries.
	@param	msbfirst	Flag: MSB first.
	@return	1 on success, 0 on error.
*/
int
dk3stream_c16_fgets(dk3_stream_t *st, dk3_c16_t *db, size_t sz, int msbfirst);

/**	Get 32-bit text line.
	@param	st	Stream.
	@param	db	Destination buffer.
	@param	sz	Size of \a db (number of 32-bit characters).
	The size must not exceed 8191 as buffer sizes are converted to int
	for some compression libraries and 4*8192 exceeds the int range
	on 16-bit systems.
	@param	msbfirst	Flag: MSB first.
	@return	1 on success, 0 on error.
*/
int
dk3stream_c32_fgets(dk3_stream_t *st, dk3_c32_t *db, size_t sz, int msbfirst);

#if DK3_HAVE_ZLIB_H
/**	Open stream for a gzFile. The gzFile is not closed when the stream
	is closed.
	@param	g	gzFile.
	@param	fl	Read/write flags.
	@param	app	Application structure, used for diagnostics.
	@return	Stream pointer on success, NULL on error.
*/
dk3_stream_t *
dk3stream_open_gz_app(gzFile g, int fl, dk3_app_t *app);
#endif

#if DK3_HAVE_BZLIB_H
/**	Open stream for a BZFILE. The BZFILE is not closed when the stream
	is closed.
	@param	b	BZFILE.
	@param	fl	Read/write flags.
	@param	app	Application structure, used for diagnostics.
	@return	Stream pointer on success, NULL on error.
*/
dk3_stream_t *
dk3stream_open_bz2_app(BZFILE *b, int fl, dk3_app_t *app);
#endif

/**	Process an input stream character by character.
	@param	st	Stream containing the input data to process.
	@param	obj	Object to modify with input stream.
	@param	hf	Character handler function.
	@param	ie	Input encoding.
	@return	1 on success, 0 on error.
*/
int
dk3stream_process_chars(
  dk3_stream_t		*st,
  void			*obj,
  dk3_char_handler_t	*hf,
  int		 	 ie
);

/**	Process all characters in a file.
	NOTE: If you have the file name, you should use
	dk3stream_process_filename_chars_app() instead. The
	dk3stream_process_filename_chars_app() checks for a BOM at the
	beginning of the file and corrects the input encoding if
	necessary.
	@param	obj	Object to modify while processing the input file.
	@param	hf	Handler function.
	@param	fipo	Input file.
	@param	fn	File name.
	@param	ie	Input file encoding.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3stream_process_file_chars_app(
  void			*obj,
  dk3_char_handler_t	*hf,
  FILE			*fipo,
  dkChar const		*fn,
  int			 ie,
  dk3_app_t		*app
);

/**	Process all characters in a file.
	@param	obj	Object to modify while processing the input file.
	@param	hf	Handler function.
	@param	fn	File name.
	@param	de	Default file encoding.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3stream_process_filename_chars_app(
  void			*obj,
  dk3_char_handler_t	*hf,
  dkChar const		*fn,
  int			 de,
  dk3_app_t		*app
);

/**	Put 32-bit character to stream, convert if necessary.
	@param	st	Output stream.
	@param	c32	Character to write.
	@param	err_enc_rep	Pointer to flag: Encoding error reported.
	@return	1 on success, 0 on error.
*/
int
dk3stream_fputc_c32(dk3_stream_t *st, dk3_c32_t c32, int *err_enc_rep);

/**	Process stream contents line by line.
	@param	st	Input stream.
	@param	obj	Object to modify while processing input.
	@param	hf	Handler function.
	@param	buf	Buffer for input lines.
	@param	szbuf	Size of \a buf (number of characters).
	The size must not exceed 8191 as buffer sizes are converted to int
	for some compression libraries and 4*8192 exceeds the int range
	on 16-bit systems.
	@param	se	System character encoding (DK3_ENCODING_xxx).
	@param	ie	Input encoding (DK3_FILE_ENCODING_xxx).
	@return	1 on success, 0 on error, -1 on error with abort.
*/
int
dk3stream_process_lines(
  dk3_stream_t		*st,
  void			*obj,
  dk3_line_handler_t	*hf,
  dkChar		*buf,
  size_t		 szbuf,
  int			 se,
  int			 ie
);

/**	Process input file contents line by line.
	NOTE: If you have a file name available, you should use
	dk3stream_process_filename_lines_app() instead, as the
	dk3stream_process_filename_lines_app() function checks for a BOM
	at the start of the file and corrects the input encoding if
	necessary.
	@param	obj	Object to modify while processing input.
	@param	hf	Handler function.
	@param	fipo	Input file.
	@param	fn	File name.
	@param	buf	Input line buffer.
	@param	szbuf	Size of \a buf (number of characters).
	The size must not exceed 8191 as buffer sizes are converted to int
	for some compression libraries.
	@param	se	System character encoding (DK3_ENCODING_xxx).
	@param	ie	Input encoding (DK3_FILE_ENCODING_xxx).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error, -1 on error with abort.
*/
int
dk3stream_process_file_lines_app(
  void			*obj,
  dk3_line_handler_t	*hf,
  FILE			*fipo,
  dkChar const		*fn,
  dkChar		*buf,
  size_t		szbuf,
  int			se,
  int			ie,
  dk3_app_t		*app
);

/**	Process input file line by line.
	@param	obj	Object to modify while processing input.
	@param	hf	Handler function.
	@param	fn	File name.
	@param	buf	Input line buffer.
	@param	szbuf	Size of \a buf (number of characters).
	The size must not exceed 8191 as buffer sizes are converted to int
	for some compression libraries.
	@param	se	System character encoding (DK3_ENCODING_xxx).
	@param	de	Default file encoding (DK3_FILE_ENCODING_xxx).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error, -1 on error with abort.
*/
int
dk3stream_process_filename_lines_app(
  void			*obj,
  dk3_line_handler_t	*hf,
  dkChar const		*fn,
  dkChar		*buf,
  size_t		 szbuf,
  int			 se,
  int			 de,
  dk3_app_t		*app
);

/**	Write double value to stream as text, avoid exponential notation.
	@param	os	Stream to write to.
	@param	x	Value to write.
	@return	1 on success, 0 on error.
*/
int
dk3strm_double_c8_no_sci(dk3_stream_t *os, double x);

/**	Write double value from string buffer to stream, avoid exponential
	notation.
	@param	os	Stream to write to.
	@param	buffer	Buffer containing double converted to text.
	@return	1 on success, 0 on error.
*/
int
dk3strm_double_c8_str_no_sci(dk3_stream_t *os, char *buffer);

#ifdef __cplusplus
}
#endif




#endif
