/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3strkv.ctr
*/

/**	@file dk3strkv.c The dk3strkv module.
*/

/** @defgroup dkct_state_machine_dk3strkv_stm The dk3strkv_stm state machine. */
/**@{*/

#ifndef S_DQ_EXPECT
/** State: Expect double quoted value */
#line 41 "dk3strkv.ctr"
#define S_DQ_EXPECT 0
#else
#line 41 "dk3strkv.ctr"
#error "Redefinition of S_DQ_EXPECT"
#endif

#ifndef S_DQ_VALUE
/** State: Having double quoted value */
#line 43 "dk3strkv.ctr"
#define S_DQ_VALUE 1
#else
#line 43 "dk3strkv.ctr"
#error "Redefinition of S_DQ_VALUE"
#endif

#ifndef S_ERROR
/** State: Error occured */
#line 44 "dk3strkv.ctr"
#define S_ERROR 2
#else
#line 44 "dk3strkv.ctr"
#error "Redefinition of S_ERROR"
#endif

#ifndef S_EXPECT
/** State: Expect value */
#line 38 "dk3strkv.ctr"
#define S_EXPECT 3
#else
#line 38 "dk3strkv.ctr"
#error "Redefinition of S_EXPECT"
#endif

#ifndef S_KEY
/** State: In a key */
#line 37 "dk3strkv.ctr"
#define S_KEY 4
#else
#line 37 "dk3strkv.ctr"
#error "Redefinition of S_KEY"
#endif

#ifndef S_SQ_EXPECT
/** State: Expect single quoted value */
#line 40 "dk3strkv.ctr"
#define S_SQ_EXPECT 5
#else
#line 40 "dk3strkv.ctr"
#error "Redefinition of S_SQ_EXPECT"
#endif

#ifndef S_SQ_VALUE
/** State: Having single quoted value */
#line 42 "dk3strkv.ctr"
#define S_SQ_VALUE 6
#else
#line 42 "dk3strkv.ctr"
#error "Redefinition of S_SQ_VALUE"
#endif

#ifndef S_START
/** State: Waiting for anything to happen */
#line 36 "dk3strkv.ctr"
#define S_START 7
#else
#line 36 "dk3strkv.ctr"
#error "Redefinition of S_START"
#endif

#ifndef S_VALUE
/** State: Having value */
#line 39 "dk3strkv.ctr"
#define S_VALUE 8
#else
#line 39 "dk3strkv.ctr"
#error "Redefinition of S_VALUE"
#endif

#ifndef I_BS
/** State machine input: Backslash */
#line 50 "dk3strkv.ctr"
#define I_BS 0
#else
#line 50 "dk3strkv.ctr"
#error "Redefinition of I_BS"
#endif

#ifndef I_DQ
/** State machine input: Double quote */
#line 49 "dk3strkv.ctr"
#define I_DQ 1
#else
#line 49 "dk3strkv.ctr"
#error "Redefinition of I_DQ"
#endif

#ifndef I_EQ
/** State machine input: Equal sign */
#line 51 "dk3strkv.ctr"
#define I_EQ 2
#else
#line 51 "dk3strkv.ctr"
#error "Redefinition of I_EQ"
#endif

#ifndef I_OT
/** State machine input: Any other character */
#line 46 "dk3strkv.ctr"
#define I_OT 3
#else
#line 46 "dk3strkv.ctr"
#error "Redefinition of I_OT"
#endif

#ifndef I_SQ
/** State machine input: Single quote */
#line 48 "dk3strkv.ctr"
#define I_SQ 4
#else
#line 48 "dk3strkv.ctr"
#error "Redefinition of I_SQ"
#endif

#ifndef I_WH
/** State machine input: White space */
#line 47 "dk3strkv.ctr"
#define I_WH 5
#else
#line 47 "dk3strkv.ctr"
#error "Redefinition of I_WH"
#endif

#ifndef O_ENDCOUNT
/** State machine output: End key string and count upwards */
#line 58 "dk3strkv.ctr"
#define O_ENDCOUNT 0
#else
#line 58 "dk3strkv.ctr"
#error "Redefinition of O_ENDCOUNT"
#endif

#ifndef O_ENDKEY
/** State machine output: End key string (change to finalizer) */
#line 57 "dk3strkv.ctr"
#define O_ENDKEY 1
#else
#line 57 "dk3strkv.ctr"
#error "Redefinition of O_ENDKEY"
#endif

#ifndef O_ENDVAL
/** State machine output: End value string (change to finalizer) */
#line 59 "dk3strkv.ctr"
#define O_ENDVAL 2
#else
#line 59 "dk3strkv.ctr"
#error "Redefinition of O_ENDVAL"
#endif

#ifndef O_ERROR
/** State machine output: Error occured */
#line 53 "dk3strkv.ctr"
#define O_ERROR 3
#else
#line 53 "dk3strkv.ctr"
#error "Redefinition of O_ERROR"
#endif

#ifndef O_NO
/** State machine output: Do nothing */
#line 54 "dk3strkv.ctr"
#define O_NO 4
#else
#line 54 "dk3strkv.ctr"
#error "Redefinition of O_NO"
#endif

#ifndef O_SEVAL
/** State machine output: Start and end value */
#line 62 "dk3strkv.ctr"
#define O_SEVAL 5
#else
#line 62 "dk3strkv.ctr"
#error "Redefinition of O_SEVAL"
#endif

#ifndef O_SKEY
/** State machine output: Start key */
#line 56 "dk3strkv.ctr"
#define O_SKEY 6
#else
#line 56 "dk3strkv.ctr"
#error "Redefinition of O_SKEY"
#endif

#ifndef O_SQ
/** State machine output: Squeeze */
#line 55 "dk3strkv.ctr"
#define O_SQ 7
#else
#line 55 "dk3strkv.ctr"
#error "Redefinition of O_SQ"
#endif

#ifndef O_SQ_SVAL
/** State machine output: Squeeze and start value */
#line 61 "dk3strkv.ctr"
#define O_SQ_SVAL 8
#else
#line 61 "dk3strkv.ctr"
#error "Redefinition of O_SQ_SVAL"
#endif

#ifndef O_SVAL
/** State machine output: Start value */
#line 60 "dk3strkv.ctr"
#define O_SVAL 9
#else
#line 60 "dk3strkv.ctr"
#error "Redefinition of O_SVAL"
#endif

/**@}*/

/**	Reset dk3strkv_stm state machine.
	@param	st	Pointer to state variable.
*/
static
void
dk3strkv_stm_reset(int *st)
{
  if(st) { *st = S_START; }
}

/**	State machine dk3strkv_stm step.
	@param	st	Pointer to state variable.
	@param	in	Input.
	@return	Transition output.
*/
static
int
dk3strkv_stm_step(int *st, int in)
{
  int back = O_ERROR;
  if(st) {
    int os;
    int nf = 1;
    int ns = S_ERROR;
    os = *st;
    switch(os) {
      case S_DQ_EXPECT: {
        switch(in) {
          case I_BS: {
            ns = S_DQ_VALUE; back = O_SQ_SVAL; nf = 0;
          } break;
          case I_DQ: {
            ns = S_START; back = O_SEVAL; nf = 0;
          } break;
        }
      } break;
      case S_DQ_VALUE: {
        switch(in) {
          case I_BS: {
            ns = S_DQ_VALUE; back = O_SQ; nf = 0;
          } break;
          case I_DQ: {
            ns = S_START; back = O_ENDVAL; nf = 0;
          } break;
        }
      } break;
      case S_EXPECT: {
        switch(in) {
          case I_BS: {
            ns = S_VALUE; back = O_SQ_SVAL; nf = 0;
          } break;
          case I_DQ: {
            ns = S_DQ_EXPECT; back = O_NO; nf = 0;
          } break;
          case I_SQ: {
            ns = S_SQ_EXPECT; back = O_NO; nf = 0;
          } break;
          case I_WH: {
            ns = S_EXPECT; back = O_NO; nf = 0;
          } break;
        }
      } break;
      case S_KEY: {
        switch(in) {
          case I_EQ: {
            ns = S_EXPECT; back = O_ENDKEY; nf = 0;
          } break;
          case I_WH: {
            ns = S_START; back = O_ENDCOUNT; nf = 0;
          } break;
        }
      } break;
      case S_SQ_EXPECT: {
        switch(in) {
          case I_BS: {
            ns = S_SQ_VALUE; back = O_SQ_SVAL; nf = 0;
          } break;
          case I_SQ: {
            ns = S_START; back = O_SEVAL; nf = 0;
          } break;
        }
      } break;
      case S_SQ_VALUE: {
        switch(in) {
          case I_BS: {
            ns = S_SQ_VALUE; back = O_SQ; nf = 0;
          } break;
          case I_SQ: {
            ns = S_START; back = O_ENDVAL; nf = 0;
          } break;
        }
      } break;
      case S_START: {
        switch(in) {
          case I_OT: {
            ns = S_KEY; back = O_SKEY; nf = 0;
          } break;
          case I_WH: {
            ns = S_START; back = O_NO; nf = 0;
          } break;
        }
      } break;
      case S_VALUE: {
        switch(in) {
          case I_BS: {
            ns = S_VALUE; back = O_SQ; nf = 0;
          } break;
          case I_WH: {
            ns = S_START; back = O_ENDVAL; nf = 0;
          } break;
        }
      } break;
    }
    if(nf) {
      if(os == S_KEY) {
      ns = S_KEY; back = O_NO;
      } else {
      if(os == S_EXPECT) {
      ns = S_VALUE; back = O_SVAL;
      } else {
      if(os == S_VALUE) {
      ns = S_VALUE; back = O_NO;
      } else {
      if(os == S_SQ_EXPECT) {
      ns = S_SQ_VALUE; back = O_SVAL;
      } else {
      if(os == S_SQ_VALUE) {
      ns = S_SQ_VALUE; back = O_NO;
      } else {
      if(os == S_DQ_EXPECT) {
      ns = S_DQ_VALUE; back = O_SVAL;
      } else {
      if(os == S_DQ_VALUE) {
      ns = S_DQ_VALUE; back = O_NO;
      } else {
      }
      }
      }
      }
      }
      }
      }
    }
    *st = ns;
  } else {
  }
  return back;
}


#line 100 "dk3strkv.ctr"


#include "dk3all.h"
#include "dk3strkv.h"



/**	Classify input character
	@param	c	Character to classify.
	@return	Character class.
*/
static
int
dk3strkv_classify(dkChar c)
{
  int		 back = I_OT;
  

#line 117 "dk3strkv.ctr"
  switch(c) {
    case dkT(' '): case dkT('\t'): {
      back = I_WH;
    } break;
    case dkT('"'): {
      back = I_DQ;
    } break;
    case dkT('\''): {
      back = I_SQ;
    } break;
    case dkT('\\'): {
      back = I_BS;
    } break;
    case dkT('='): {
      back = I_EQ;
    } break;
  } 

#line 134 "dk3strkv.ctr"
  return back;
}



/**	Empty line.
*/
static dkChar const dk3strkv_empty_line[] = { dkT("") };



/**	Report error for unexpected end of text.
	@param	app	Application structure for diagnostics, may be NULL.
	@param	il	Input line to complain about.
*/
static
void
dk3strkv_error_unexpected_eot(dk3_app_t *app, dkChar *il)
{
  dkChar const 	*ptr;
  if(app) {
    ptr = il;
    if(!(ptr)) { ptr = dk3strkv_empty_line; }
    dk3app_log_i3(app, DK3_LL_ERROR, 389, 390, ptr);
  }
}



/**	Report error, too many key value items.
	@param	app	Application structure for diagnostics, may be NULL.
	@param	il	Input line to complain about.
	@param	pos	Position in line.
*/
static
void
dk3strkv_error_too_many(dk3_app_t *app, dkChar *il, unsigned long pos)
{
  dkChar		buffer[64];
  dkChar const		*ptr;
  if(app) {
    ptr = il;
    if(!(ptr)) { ptr = dk3strkv_empty_line; }
#if VERSION_BEFORE_20140716
    dk3sf_sprintf3(buffer, dkT("%lu"), pos);
    dk3app_log_i5(app, DK3_LL_ERROR, 386, 387, 388, buffer, ptr);
#else
    if (dk3ma_um_to_string(buffer, DK3_SIZEOF(buffer, dkChar), (dk3_um_t)pos)) {
      dk3app_log_i5(app, DK3_LL_ERROR, 386, 387, 388, buffer, ptr);
    }
#endif
  }
}




int
dk3str_to_key_value(
  dk3_key_value_t	*kvp,
  size_t		*szp,
  dkChar		*il,
  dk3_app_t		*app
)
{
  dkChar		*ptr;		/* Traverse string. */
  dkChar		*mycopy;	/* Private copy for diagnostics. */
  unsigned long		 charno;	/* Character number. */
  size_t		 i;		/* Current key value pair index. */
  int			 icl;		/* Input class. */
  int			 act;		/* Action to take. */
  int			 stm;		/* State machine. */
  int			 cc;		/* Flag: Can continue. */
  int			 rtm	= 0;	/* Reported too many. */
  int			 error	= 0;	/* Flag: Have error. */
  int			 back	= 0;
  

#line 211 "dk3strkv.ctr"
  if((kvp) && (szp)) {
    for(i = 0; i < *szp; i++) { kvp[i].key = NULL; kvp[i].val = NULL; }
  }
  if((kvp) && (szp) && (il)) {
    if(*szp) {
      mycopy = dk3str_dup_app(il, app);
      i = 0;
      ptr = il; cc = 1; charno = 1UL;
      dk3strkv_stm_reset(&stm);
      while(cc) {
        if(*ptr) {	

#line 222 "dk3strkv.ctr"
	  icl = dk3strkv_classify(*ptr);	

#line 223 "dk3strkv.ctr"
	  act = dk3strkv_stm_step(&stm, icl);	

#line 224 "dk3strkv.ctr"
	  switch(act) {
	    case O_ERROR: {		

#line 226 "dk3strkv.ctr"
	      error = 1;
	    } break;
	    case O_SQ: {		

#line 229 "dk3strkv.ctr"
	      dk3str_cpy(ptr, &(ptr[1]));
	      if(*ptr) {
	        charno++;
	      } else {
	        cc = 0;
		error = 1;
		dk3strkv_error_unexpected_eot(app, mycopy);
	      }
	    } break;
	    case O_SKEY: {		

#line 239 "dk3strkv.ctr"
	      if(i < (*szp)) {
	        kvp[i].key = ptr;
	      } else {
	        error = 1;
		if(0 == rtm) {
		  rtm = 1;
		  dk3strkv_error_too_many(app, mycopy, charno);
		}
	      }
	    } break;
	    case O_ENDKEY: {		

#line 250 "dk3strkv.ctr"
	      *ptr = dkT('\0');
	    } break;
	    case O_ENDCOUNT: {		

#line 253 "dk3strkv.ctr"
	      *ptr = dkT('\0');
	      i++;
	    } break;
	    case O_ENDVAL: {		

#line 257 "dk3strkv.ctr"
	      *ptr = dkT('\0');
	      i++;
	    } break;
	    case O_SVAL: {		

#line 261 "dk3strkv.ctr"
	      if(i < (*szp)) {
	        kvp[i].val = ptr;
	      } else {
	        error = 1;
		if(0 == rtm) {
		  rtm = 1;
		  dk3strkv_error_too_many(app, mycopy, charno);
		}
	      }
	    } break;
	    case O_SQ_SVAL: {		

#line 272 "dk3strkv.ctr"
	      dk3str_cpy(ptr, &(ptr[1]));
	      if(*ptr) {
	        charno++;
	        if(i < (*szp)) {
		  kvp[i].val = ptr;
		} else {
		  error = 1;
		  if(0 == rtm) {
		    rtm = 1;
		    dk3strkv_error_too_many(app, mycopy, charno);
		  }
		}
	      } else {
	        cc = 0;
		error = 1;
		dk3strkv_error_unexpected_eot(app, mycopy);
	      }
	    } break;
	    case O_SEVAL: {		

#line 291 "dk3strkv.ctr"
	      *ptr = dkT('\0');
	      if(i < (*szp)) {
	        kvp[i].val = ptr;
		i++;
	      } else {
	        error = 1;
		if(0 == rtm) {
		  rtm = 1;
		  dk3strkv_error_too_many(app, mycopy, charno);
		}
	      }
	    } break;
	  }
	  ptr++;
	  charno++;
	} else {
	  cc = 0;
	}
      }
      switch(stm) {
        case S_START: {	

#line 312 "dk3strkv.ctr"
	  if(0 == error) {
	    back = 1;
	    *szp = i;
	  }
	} break;
	case S_KEY: {	

#line 318 "dk3strkv.ctr"
	  if(0 == error) {
	    i++;
	    back = 1;
	    *szp = i;
	  }
	} break;
	case S_VALUE: {	

#line 325 "dk3strkv.ctr"
	  if(0 == error) {
	    i++;
	    back = 1;
	    *szp = i;
	  }
	} break;
      }
      dk3_release(mycopy);
    }
  } else {
    if((kvp) && (szp) && (!(il))) {
      *szp = 0;
      back = 1;
    }
  } 

#line 340 "dk3strkv.ctr"
  return back;
}



