/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3str.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3STR_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3STR_H_INCLUDED 1


#line 8 "dk3str.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**	Calculate string length.
 * 	@param	s	String to process.
 * 	@return	String length (number of characters).
 */
size_t
dk3str_c8_len(char const *s);

/**	Calculate string length.
 * 	@param	s	String to process.
 * 	@return	String length (number of characters).
 */
size_t
dk3str_c16_len(dk3_c16_t const *s);

/**	Calculate string length.
 * 	@param	s	String to process.
 * 	@return	String length (number of characters).
 */
size_t
dk3str_c32_len(dk3_c32_t const *s);

/**	Calculate string length.
 * 	@param	s	String to process.
 * 	@return	String length (number of characters).
 */
size_t
dk3str_len(dkChar const *s);

/**	Compare two strings.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@return	1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_c8_cmp(char const *s1, char const *s2);

/**	Compare two strings.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@return	1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_c16_cmp(dk3_c16_t const *s1, dk3_c16_t const *s2);

/**	Compare two strings.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@return	1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_c32_cmp(dk3_c32_t const *s1, dk3_c32_t const *s2);

/**	Compare two strings.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@return	1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_cmp(dkChar const *s1, dkChar const *s2);

/**	Case-insensitve string comparison.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@return 1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_c8_casecmp(char const *s1, char const *s2);


/**	Case-insensitve string comparison.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@return 1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_c16_casecmp(dk3_c16_t const *s1, dk3_c16_t const *s2);

/**	Case-insensitve string comparison.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@return 1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_c32_casecmp(dk3_c32_t const *s1, dk3_c32_t const *s2);

/**	Case-insensitve string comparison.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@return 1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_casecmp(dkChar const *s1, dkChar const *s2);

/**	File name comparison, case-sensitive on some systems,
 *	case-insensitive on other systems.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@return 1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_fncmp(dkChar const *s1, dkChar const *s2) ;

/**	Compare two strings, use only the first \a n characters.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@param	n	Number of characters to use in comparison.
 * 	@return	1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_c8_ncmp(char const *s1, char const *s2, size_t n);

/**	Compare two strings, use only the first \a n characters.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@param	n	Number of characters to use in comparison.
 * 	@return	1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_c16_ncmp(dk3_c16_t const *s1, dk3_c16_t const *s2, size_t n);

/**	Compare two strings, use only the first \a n characters.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@param	n	Number of characters to use in comparison.
 * 	@return	1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_c32_ncmp(dk3_c32_t const *s1, dk3_c32_t const *s2, size_t n);

/**	Compare two strings, use only the first \a n characters.
 * 	@param	s1	Left side string.
 * 	@param	s2	Right side string.
 * 	@param	n	Number of characters to use in comparison.
 * 	@return	1 for s1>s2, 0 for s1=s2, -1 for s1<s2.
 */
int
dk3str_ncmp(dkChar const *s1, dkChar const *s2, size_t n);

/**	Find left-most orrucance of character in string.
 * 	@param	s	String probably containing the character.
 * 	@param	c	Character to search for.
 * 	@return	Pointer to character position on success, NULL on error.
 */
char *
dk3str_c8_chr(char const *s, char c);

/**	Find left-most orrucance of character in string.
 * 	@param	s	String probably containing the character.
 * 	@param	c	Character to search for.
 * 	@return	Pointer to character position on success, NULL on error.
 */
dk3_c16_t *
dk3str_c16_chr(dk3_c16_t const *s, dk3_c16_t c);

/**	Find left-most orrucance of character in string.
 * 	@param	s	String probably containing the character.
 * 	@param	c	Character to search for.
 * 	@return	Pointer to character position on success, NULL on error.
 */
dk3_c32_t *
dk3str_c32_chr(dk3_c32_t const *s, dk3_c32_t c);

/**	Find left-most orrucance of character in string.
 * 	@param	s	String probably containing the character.
 * 	@param	c	Character to search for.
 * 	@return	Pointer to character position on success, NULL on error.
 */
dkChar *
dk3str_chr(dkChar const *s, dkChar c);

/**	Find right-most orrucance of character in string.
 * 	@param	s	String probably containing the character.
 * 	@param	c	Character to search for.
 * 	@return	Pointer to character position on success, NULL on error.
 */
char *
dk3str_c8_rchr(char const *s, char c);

/**	Find right-most orrucance of character in string.
 * 	@param	s	String probably containing the character.
 * 	@param	c	Character to search for.
 * 	@return	Pointer to character position on success, NULL on error.
 */
dk3_c16_t *
dk3str_c16_rchr(dk3_c16_t const *s, dk3_c16_t c);

/**	Find right-most orrucance of character in string.
 * 	@param	s	String probably containing the character.
 * 	@param	c	Character to search for.
 * 	@return	Pointer to character position on success, NULL on error.
 */
dk3_c32_t *
dk3str_c32_rchr(dk3_c32_t const *s, dk3_c32_t c);

/**	Find right-most orrucance of character in string.
 * 	@param	s	String probably containing the character.
 * 	@param	c	Character to search for.
 * 	@return	Pointer to character position on success, NULL on error.
 */
dkChar *
dk3str_rchr(dkChar const *s, dkChar c);

/**	Copy string.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3str_c8_cpy(char *d, char const *s);

/**	Copy string.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3str_c16_cpy(dk3_c16_t *d, dk3_c16_t const *s);

/**	Copy string.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3str_c32_cpy(dk3_c32_t *d, dk3_c32_t const *s);

/**	Copy string.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3str_cpy(dkChar *d, dkChar const *s);

/**	Copy string.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3str_c8_cpy_not_overlapped(char *d, char const *s);

/**	Copy string.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3str_c16_cpy_not_overlapped(dk3_c16_t *d, dk3_c16_t const *s);

/**	Copy string.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3str_c32_cpy_not_overlapped(dk3_c32_t *d, dk3_c32_t const *s);

/**	Copy string.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3str_cpy_not_overlapped(dkChar *d, dkChar const *s);

/**	Copy string, cut to buffer size if necessary.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 * 	@param	n	Size of \a d (number of characters).
 */
void
dk3str_c8_ncpy(char *d, char const *s, size_t n);

/**	Copy string, cut to buffer size if necessary.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 * 	@param	n	Size of \a d (number of characters).
 */
void
dk3str_c16_ncpy(dk3_c16_t *d, dk3_c16_t const *s, size_t n);

/**	Copy string, cut to buffer size if necessary.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 * 	@param	n	Size of \a d (number of characters).
 */
void
dk3str_c32_ncpy(dk3_c32_t *d, dk3_c32_t const *s, size_t n);

/**	Copy string, cut to buffer size if necessary.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 * 	@param	n	Size of \a d (number of characters).
 */
void
dk3str_ncpy(dkChar *d, dkChar const *s, size_t n);

/**	Concatenate two strings.
 * 	Do not use this function directly, use dk3str_c8_cat() instead.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3str_c8_cat(char *d, char const *s);

/**	Concatenate two strings.
 * 	Do not use this function directly, use dk3str_c16_cat() instead.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3str_c16_cat(dk3_c16_t *d, dk3_c16_t const *s);

/**	Concatenate two strings.
 * 	Do not use this function directly, use dk3str_c32_cat() instead.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3str_c32_cat(dk3_c32_t *d, dk3_c32_t const *s);

/**	Concatenate two strings.
 * 	Do not use this function directly, use dk3str_c32_cat() instead.
 * 	@param	d	Destination pointer.
 * 	@param	s	Source pointer.
 */
void
dk3str_cat(dkChar *d, dkChar const *s);

/**	Create a string copy in dynamically allocated memory.
	@param	s	Original string.
	@param	app	Application structure for diagnostics.
	@return	Pointer to copy on success, NULL on error.
	The pointer returned on success must be released by
	dk3_release() when done with it.
*/
char *
dk3str_c8_dup_app(char const *s, dk3_app_t *app);

/**	Create a string copy in dynamically allocated memory.
	@param	s	Original string.
	@param	app	Application structure for diagnostics.
	@return	Pointer to copy on success, NULL on error.
	The pointer returned on success must be released by
	dk3_release() when done with it.
*/
dk3_c16_t *
dk3str_c16_dup_app(dk3_c16_t const *s, dk3_app_t *app);

/**	Create a string copy in dynamically allocated memory.
	@param	s	Original string.
	@param	app	Application structure for diagnostics.
	@return	Pointer to copy on success, NULL on error.
	The pointer returned on success must be released by
	dk3_release() when done with it.
*/
dk3_c32_t *
dk3str_c32_dup_app(dk3_c32_t const *s, dk3_app_t *app);

/**	Create a string copy in dynamically allocated memory.
	@param	s	Original string.
	@param	app	Application structure for diagnostics.
	@return	Pointer to copy on success, NULL on error.
	The pointer returned on success must be released by
	dk3_release() when done with it.
*/
dkChar *
dk3str_dup_app(dkChar const *s, dk3_app_t *app);

/**	Convert to lower-case character.
 * 	@param	c	Character to convert.
 * 	@return	Conversion result.
 */
char
dk3str_c8_tolower(char c);

/**	Convert to lower-case character.
 * 	@param	c	Character to convert.
 * 	@return	Conversion result.
 */
dk3_c16_t
dk3str_c16_tolower(dk3_c16_t c);

/**	Convert to lower-case character.
 * 	@param	c	Character to convert.
 * 	@return	Conversion result.
 */
dk3_c32_t
dk3str_c32_tolower(dk3_c32_t c);

/**	Convert to lower-case character.
 * 	@param	c	Character to convert.
 * 	@return	Conversion result.
 */
dkChar
dk3str_tolower(dkChar c);

/**	Convert to upper-case character.
 * 	@param	c	Character to convert.
 * 	@return	Conversion result.
 */
char
dk3str_c8_toupper(char c);

/**	Convert to upper-case character.
 * 	@param	c	Character to convert.
 * 	@return	Conversion result.
 */
dk3_c16_t
dk3str_c16_toupper(dk3_c16_t c);

/**	Convert to upper-case character.
 * 	@param	c	Character to convert.
 * 	@return	Conversion result.
 */
dk3_c32_t
dk3str_c32_toupper(dk3_c32_t c);

/**	Convert to upper-case character.
 * 	@param	c	Character to convert.
 * 	@return	Conversion result.
 */
dkChar
dk3str_toupper(dkChar c);

/**	Find start of string (first non-whitespace).
 * 	@param	str	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 * 	@return	Pointer to first non-whitespace on success, NULL on error.
 */
char *
dk3str_c8_start(char const *str, char const *whsp);

/**	Find start of string (first non-whitespace).
 * 	@param	str	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 * 	@return	Pointer to first non-whitespace on success, NULL on error.
 */
dk3_c16_t *
dk3str_c16_start(dk3_c16_t const *str, dk3_c16_t const *whsp);

/**	Find start of string (first non-whitespace).
 * 	@param	str	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 * 	@return	Pointer to first non-whitespace on success, NULL on error.
 */
dk3_c32_t *
dk3str_c32_start(dk3_c32_t const *str, dk3_c32_t const *whsp);

/**	Find start of string (first non-whitespace).
 * 	@param	str	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 * 	@return	Pointer to first non-whitespace on success, NULL on error.
 */
dkChar *
dk3str_start(dkChar const *str, dkChar const *whsp);

/**	Find start of second text
 * 	@param	str	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 * 	@return	Pointer to second non-whitespace sequence on success, or NULL.
 */
char    *
dk3str_c8_next(char *str, char const *whsp);

/**	Find start of second text
 * 	@param	str	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 * 	@return	Pointer to second non-whitespace sequence on success, or NULL.
 */
dk3_c16_t *
dk3str_c16_next(dk3_c16_t *str, dk3_c16_t const *whsp);

/**	Find start of second text
 * 	@param	str	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 * 	@return	Pointer to second non-whitespace sequence on success, or NULL.
 */
dk3_c32_t *
dk3str_c32_next(dk3_c32_t *str, dk3_c32_t const *whsp);

/**	Find start of second text
 * 	@param	str	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 * 	@return	Pointer to second non-whitespace sequence on success, or NULL.
 */
dkChar *
dk3str_next(dkChar *str, dkChar const *whsp);

/**	Remove trailing whitespaces from string.
 * 	@param	str	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 */
void
dk3str_c8_chomp(char *str, char const *whsp);

/**	Remove trailing whitespaces from string.
 * 	@param	str	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 */
void
dk3str_c16_chomp(dk3_c16_t *str, dk3_c16_t const *whsp);

/**	Remove trailing whitespaces from string.
 * 	@param	str	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 */
void
dk3str_c32_chomp(dk3_c32_t *str, dk3_c32_t const *whsp);

/**	Remove trailing whitespaces from string.
 * 	@param	str	String to process.
 * 	@param	whsp	Whitespaces set (use NULL for default whitespace set).
 */
void
dk3str_chomp(dkChar *str, dkChar const *whsp);

/**	Remove trailing newline.
	@param	str	String to modify.
*/
void
dk3str_c8_delnl(char *str);

/**	Remove trailing newline.
	@param	str	String to modify.
*/
void
dk3str_c16_delnl(dk3_c16_t *str);

/**	Remove trailing newline.
	@param	str	String to modify.
*/
void
dk3str_c32_delnl(dk3_c32_t *str);

/**	Remove trailing newline.
	@param	str	String to modify.
*/
void
dk3str_delnl(dkChar *str);

/**	Find index of a string in an array of patterns.
 * 	@param	a	Patterns array.
 * 	@param	s	String to find.
 * 	@param	c	Flag: Case-sensitive (1) or not (0).
 * 	@return	Index of \a s in \a a on success, -1 on error (not found).
 */
int
dk3str_c8_array_index(char const * const *a, char const *s, int c);

/**	Find index of a string in an array of patterns.
 * 	@param	a	Patterns array.
 * 	@param	s	String to find.
 * 	@param	c	Flag: Case-sensitive (1) or not (0).
 * 	@return	Index of \a s in \a a on success, -1 on error (not found).
 */
int
dk3str_c16_array_index(dk3_c16_t const * const *a, dk3_c16_t const *s, int c);

/**	Find index of a string in an array of patterns.
 * 	@param	a	Patterns array.
 * 	@param	s	String to find.
 * 	@param	c	Flag: Case-sensitive (1) or not (0).
 * 	@return	Index of \a s in \a a on success, -1 on error (not found).
 */
int
dk3str_c32_array_index(dk3_c32_t const * const *a, dk3_c32_t const *s, int c);

/**	Find index of a string in an array of patterns.
 * 	@param	a	Patterns array.
 * 	@param	s	String to find.
 * 	@param	c	Flag: Case-sensitive (1) or not (0).
 * 	@return	Index of \a s in \a a on success, -1 on error (not found).
 */
int
dk3str_array_index(dkChar const * const *a, dkChar const *s, int c);

/**	Check whether a text matches a pattern, the text may be abbreviated.
 * 	@param	line	Text to check.
 * 	@param	pattern	Pattern for comparison.
 * 	@param	spec	Special character marking the abbreviation in the
 *	pattern.
 * 	@param	cs	Flag: Case sensitive (1) or not (0).
 * 	@return	1 for a match, 0 otherwise.
 */
int
dk3str_c8_is_abbr(char const *line,char const *pattern,char spec,int cs);

/**	Check whether a text matches a pattern, the text may be abbreviated.
 * 	@param	line	Text to check.
 * 	@param	pattern	Pattern for comparison.
 * 	@param	spec	Special character marking the abbreviation in the
 *	pattern.
 * 	@param	cs	Flag: Case sensitive (1) or not (0).
 * 	@return	1 for a match, 0 otherwise.
 */
int
dk3str_c16_is_abbr(
  dk3_c16_t const *line, dk3_c16_t const *pattern, dk3_c16_t spec, int cs
);

/**	Check whether a text matches a pattern, the text may be abbreviated.
 * 	@param	line	Text to check.
 * 	@param	pattern	Pattern for comparison.
 * 	@param	spec	Special character marking the abbreviation in the
 *	pattern.
 * 	@param	cs	Flag: Case sensitive (1) or not (0).
 * 	@return	1 for a match, 0 otherwise.
 */
int
dk3str_c32_is_abbr(
  dk3_c32_t const *line, dk3_c32_t const *pattern, dk3_c32_t spec, int cs
);

/**	Check whether a text matches a pattern, the text may be abbreviated.
 * 	@param	line	Text to check.
 * 	@param	pattern	Pattern for comparison.
 * 	@param	spec	Special character marking the abbreviation in the
 *	pattern.
 * 	@param	cs	Flag: Case sensitive (1) or not (0).
 * 	@return	1 for a match, 0 otherwise.
 */
int
dk3str_is_abbr(dkChar const *line, dkChar const *pattern, dkChar spec, int cs);

/**	Search for a string in an array of patterns with abbreviations allowed.
 * 	@param	ar	Pattern array.
 * 	@param	str	String to search for.
 * 	@param	sp	Special character to mark abbreviation position.
 * 	@param	cs	Flag: Case-sensitive (1) or not (0).
 * 	@return	Index of \a str in \a ar on success, -1 on error (not found).
 */
int
dk3str_c8_array_abbr(char const * const *ar, char const *str, char sp, int cs);

/**	Search for a string in an array of patterns with abbreviations allowed.
 * 	@param	arr	Pattern array.
 * 	@param	str	String to search for.
 * 	@param	sp	Special character to mark abbreviation position.
 * 	@param	cs	Flag: Case-sensitive (1) or not (0).
 * 	@return	Index of \a str in \a ar on success, -1 on error (not found).
 */
int
dk3str_c16_array_abbr(
  dk3_c16_t const * const *arr, dk3_c16_t const *str, dk3_c16_t sp, int cs
);

/**	Search for a string in an array of patterns with abbreviations allowed.
 * 	@param	arr	Pattern array.
 * 	@param	str	String to search for.
 * 	@param	sp	Special character to mark abbreviation position.
 * 	@param	cs	Flag: Case-sensitive (1) or not (0).
 * 	@return	Index of \a str in \a ar on success, -1 on error (not found).
 */
int
dk3str_c32_array_abbr(
  dk3_c32_t const * const *arr, dk3_c32_t const *str, dk3_c32_t sp, int cs
);

/**	Search for a string in an array of patterns with abbreviations allowed.
 * 	@param	ar	Pattern array.
 * 	@param	str	String to search for.
 * 	@param	sp	Special character to mark abbreviation position.
 * 	@param	cs	Flag: Case-sensitive (1) or not (0).
 * 	@return	Index of \a str in \a ar on success, -1 on error (not found).
 */
int
dk3str_array_abbr(dkChar const * const *ar,dkChar const *str,dkChar sp,int cs);

/**	Check whether the text represents a boolean value.
 * 	@param	str	Text to process.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_c8_is_bool(char const *str);

/**	Check whether the text represents a boolean value.
 * 	@param	str	Text to process.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_c16_is_bool(dk3_c16_t const *str);

/**	Check whether the text represents a boolean value.
 * 	@param	str	Text to process.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_c32_is_bool(dk3_c32_t const *str);

/**	Check whether the text represents a boolean value.
 * 	@param	str	Text to process.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_is_bool(dkChar const *str);

/**	Check whether the text represents the boolean value "true".
 * 	@param	str	Text to process.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_c8_is_on(char const *str);

/**	Check whether the text represents the boolean value "true".
 * 	@param	str	Text to process.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_c16_is_on(dk3_c16_t const *str);

/**	Check whether the text represents the boolean value "true".
 * 	@param	str	Text to process.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_c32_is_on(dk3_c32_t const *str);

/**	Check whether the text represents the boolean value "true".
 * 	@param	str	Text to process.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_is_on(dkChar const *str);

/**	Explode a string (split string into array of text words).
	@param	array	Destination pointers array.
	@param	sz	Size of \a array (number of elements).
	@param	str	String to process.
	@param	whsp	Whitespaces set (may be NULL).
	@return	Number of elements set in \a array, 0 on error.
*/
size_t
dk3str_c8_explode(char **array, size_t sz, char *str, char const *whsp);

/**	Explode a string (split string into array of text words).
	@param	array	Destination pointers array.
	@param	sz	Size of \a array (number of elements).
	@param	str	String to process.
	@param	whsp	Whitespaces set (may be NULL).
	@return	Number of elements set in \a array, 0 on error.
*/
size_t
dk3str_c16_explode(
  dk3_c16_t **array, size_t sz, dk3_c16_t *str, dk3_c16_t const *whsp
);

/**	Explode a string (split string into array of text words).
	@param	array	Destination pointers array.
	@param	sz	Size of \a array (number of elements).
	@param	str	String to process.
	@param	whsp	Whitespaces set (may be NULL).
	@return	Number of elements set in \a array, 0 on error.
*/
size_t
dk3str_c32_explode(
  dk3_c32_t **array, size_t sz, dk3_c32_t *str, dk3_c32_t const *whsp
);

/**	Explode a string (split string into array of text words).
	@param	array	Destination pointers array.
	@param	sz	Size of \a array (number of elements).
	@param	str	String to process.
	@param	whsp	Whitespaces set (may be NULL).
	@return	Number of elements set in \a array, 0 on error.
*/
size_t
dk3str_explode(dkChar **array, size_t sz, dkChar *str, dkChar const *whsp);

/**	Normalize text line.
	@param	l	Text line to modify.
	@param	w	Whitespaces set (may be NULL).
	@param	s	Separator character.
*/
void
dk3str_c8_normalize(char *l, char const *w, char s);

/**	Normalize text line.
	@param	l	Text line to modify.
	@param	w	Whitespaces set (may be NULL).
	@param	s	Separator character.
*/
void
dk3str_c16_normalize(dk3_c16_t *l, dk3_c16_t const *w, char s);

/**	Normalize text line.
	@param	l	Text line to modify.
	@param	w	Whitespaces set (may be NULL).
	@param	s	Separator character.
*/
void
dk3str_c32_normalize(dk3_c32_t *l, dk3_c32_t const *w, char s);

/**	Normalize text line.
	@param	l	Text line to modify.
	@param	w	Whitespaces set (may be NULL).
	@param	s	Separator character.
*/
void
dk3str_normalize(dkChar *l, dkChar const *w, dkChar s);

/**	Correct file name.
 * 	@param	n	File name to correct.
 */
void
dk3str_c8_correct_filename(char *n);

/**	Correct file name.
 * 	@param	n	File name to correct.
 */
void
dk3str_c16_correct_filename(dk3_c16_t *n);

/**	Correct file name.
 * 	@param	n	File name to correct.
 */
void
dk3str_c32_correct_filename(dk3_c32_t *n);

/**	Correct file name.
 * 	@param	n	File name to correct.
 */
void
dk3str_correct_filename(dkChar *n);

/**	Check whether a file/directory name is an absolute path.
 * 	@param	n	Name to check.
 * 	@return	1 for absolute path, 0 otherwise.
 */
int
dk3str_c8_is_abs_path(char const *n);

/**	Check whether a file/directory name is an absolute path.
 * 	@param	n	Name to check.
 * 	@return	1 for absolute path, 0 otherwise.
 */
int
dk3str_c16_is_abs_path(dk3_c16_t const *n);

/**	Check whether a file/directory name is an absolute path.
 * 	@param	n	Name to check.
 * 	@return	1 for absolute path, 0 otherwise.
 */
int
dk3str_c32_is_abs_path(dk3_c32_t const *n);

/**	Check whether a file/directory name is an absolute path.
 * 	@param	n	Name to check.
 * 	@return	1 for absolute path, 0 otherwise.
 */
int
dk3str_is_abs_path(dkChar const *n);

/**	Append path to a given directory.
 * 	@param	d	In: directory, out: modified path.
 * 	@param	sz	Destination buffer size (number of characters).
 * 	@param	n	Path name to append.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on errors.
 */
int
dk3str_c8_append_path_app(char *d, size_t sz, char const *n, dk3_app_t *app);

/**	Append path to a given directory.
 * 	@param	d	In: directory, out: modified path.
 * 	@param	sz	Destination buffer size (number of characters).
 * 	@param	n	Path name to append.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on errors.
 */
int
dk3str_c16_append_path_app(
  dk3_c16_t *d, size_t sz, dk3_c16_t const *n, dk3_app_t *app
);

/**	Append path to a given directory.
 * 	@param	d	In: directory, out: modified path.
 * 	@param	sz	Destination buffer size (number of characters).
 * 	@param	n	Path name to append.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on errors.
 */
int
dk3str_c32_append_path_app(
  dk3_c32_t *d, size_t sz, dk3_c32_t const *n, dk3_app_t *app
);

/**	Append path to a given directory.
 * 	@param	d	In: directory, out: modified path.
 * 	@param	sz	Destination buffer size (number of characters).
 * 	@param	n	Path name to append.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on errors.
 */
int
dk3str_append_path_app(dkChar *d, size_t sz, dkChar const *n, dk3_app_t *app);


/**	Get file name suffix.
	@param	s	File name.
	@return	Pointer to suffix on success, NULL on error (no
	suffix found).
*/
char *
dk3str_c8_get_suffix(char const *s);

/**	Get file name suffix.
	@param	s	File name.
	@return	Pointer to suffix on success, NULL on error (no
	suffix found).
*/
dk3_c16_t *
dk3str_c16_get_suffix(dk3_c16_t const *s);

/**	Get file name suffix.
	@param	s	File name.
	@return	Pointer to suffix on success, NULL on error (no
	suffix found).
*/
dk3_c32_t *
dk3str_c32_get_suffix(dk3_c32_t const *s);

/**	Get file name suffix.
	@param	s	File name.
	@return	Pointer to suffix on success, NULL on error (no
	suffix found).
*/
dkChar *
dk3str_get_suffix(dkChar const *s);

/**	Convert 16-bit string to 8-bit string (only ASCII characters).
 * 	@param	d	Destination buffer.
 * 	@param	sz	Size of \a d in bytes.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error (illegal characters or buffer too
 *	short).
 */
int
dk3str_c16_to_c8_simple_app(
  char *d, size_t sz, dk3_c16_t const *s, dk3_app_t *app
);

/**	Convert 32-bit string to 8-bit string (only ASCII characters).
 * 	@param	d	Destination buffer.
 * 	@param	sz	Size of \a d in bytes.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error (illegal characters or buffer too
 *	short).
 */
int
dk3str_c32_to_c8_simple_app(
  char *d, size_t sz, dk3_c32_t const *s, dk3_app_t *app
);

/**	Find buffer size needed to convert from 8-bit plain to 8-bit UTF-8.
 * 	@param	s	Source string (ASCII/ISO-LATIN-1 encoded).
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Number of bytes needed for UTF-8 encoded string,
 * 	the number includes the finalizing 0x00 byte.
 */
size_t
dk3str_cnvsz_c8p_to_c8u_app(char const *s, dk3_app_t *app);

/**	Find buffer size needed to convert from UTF-8 to ISO-LATIN-1.
 * 	@param	s	Source string (UTF-8 encoded).
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Number of bytes needed for ISO-LATIN-1 encoded string,
 * 	the number includes the finalizing 0x00 byte.
 */
size_t
dk3str_cnvsz_c8u_to_c8p_app(char const *s, dk3_app_t *app);

/**	Find buffer size needed to convert from ISO-LATIN-1 to UTF-16.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Number of 16-bit characters needed for result
 * 	including the finalizer.
 */
size_t
dk3str_cnvsz_c8p_to_c16_app(char const *s, dk3_app_t *app);

/**	Find buffer size needed to convert from UTF-8 to UTF-16.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Number of 16-bit characters needed for result
 * 	including the finalizer.
 */
size_t
dk3str_cnvsz_c8u_to_c16_app(char const *s, dk3_app_t *app);

/**	Find buffer size needed to convert from UTF-16 to ISO-LATIN-1.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Number of bytes needed for result, including finalizer.
 */
size_t
dk3str_cnvsz_c16_to_c8p_app(dk3_c16_t const *s, dk3_app_t *app);

/**	Find buffer size needed to convert from UTF-16 to UTF-8.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Number of bytes needed for result, including finalizer.
 */
size_t
dk3str_cnvsz_c16_to_c8u_app(dk3_c16_t const *s, dk3_app_t *app);

/**	Find buffer size needed to convert from ISO-LATIN-1 to 32-bit.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Number of 32-bit characters needed for result,
 * 	including finalizer.
 */
size_t
dk3str_cnvsz_c8p_to_c32_app(char const *s, dk3_app_t *app);

/**	Find buffer size needed to convert from UTF-8 to 32-bit.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Number of 32-bit characters needed for result,
 * 	including finalizer.
 */
size_t
dk3str_cnvsz_c8u_to_c32_app(char const *s, dk3_app_t *app);

/**	Find buffer size needed to convert from UTF-16 to 32-bit.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Number of 32-bit characters needed for result,
 * 	including finalizer.
 */
size_t
dk3str_cnvsz_c16_to_c32_app(dk3_c16_t const *s, dk3_app_t *app);

/**	Find buffer size needed to convert from 32-bit to ISO-LATIN-1.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Number of bytes needed for result, including finalizer.
 */
size_t
dk3str_cnvsz_c32_to_c8p_app(dk3_c32_t const *s, dk3_app_t *app);

/**	Find buffer size needed to convert from 32-bit to UTF-8.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Number of bytes needed for result, including finalizer.
 */
size_t
dk3str_cnvsz_c32_to_c8u_app(dk3_c32_t const *s, dk3_app_t *app);

/**	Find buffer size needed to convert from 32-bit to UTF-16.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Number of UTF-16 chars needed for result, including finalizer.
 */
size_t
dk3str_cnvsz_c32_to_c16_app(dk3_c32_t const *s, dk3_app_t *app);

/**	Convert ISO-LATIN-1 string to UTF-8.
 * 	@param	d	Destination buffer.
 * 	@param	ds	Size of \a d (number of elements).
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_cnv_c8p_to_c8u_app(char *d, size_t ds, char const *s, dk3_app_t *app);

/**	Convert UTF-8 string to ISO-LATIN-1.
 * 	@param	d	Destination buffer.
 * 	@param	ds	Size of \a d (number of elements).
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_cnv_c8u_to_c8p_app(char *d, size_t ds, char const *s, dk3_app_t *app);

/**	Convert ISO-LATIN-1 string to UTF-16.
 * 	@param	d	Destination buffer.
 * 	@param	ds	Size of \a d (number of elements).
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_cnv_c8p_to_c16_app(
  dk3_c16_t *d, size_t ds, char const *s, dk3_app_t *app
);

/**	Convert UTF-8 string to UTF-16.
 * 	@param	d	Destination buffer.
 * 	@param	ds	Size of \a d (number of elements).
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_cnv_c8u_to_c16_app(
  dk3_c16_t *d, size_t ds, char const *s, dk3_app_t *app
);

/**	Convert UTF-16 string to ISO-LATIN-1.
 * 	@param	d	Destination buffer.
 * 	@param	ds	Size of \a d (number of elements).
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_cnv_c16_to_c8p_app(
  char *d, size_t ds, dk3_c16_t const *s, dk3_app_t *app
);

/**	Convert UTF-16 string to UTF-8.
 * 	@param	d	Destination buffer.
 * 	@param	ds	Size of \a d (number of elements).
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_cnv_c16_to_c8u_app(
  char *d, size_t ds, dk3_c16_t const *s, dk3_app_t *app
);

/**	Convert ISO-LATIN-1 string to 32-bit.
 * 	@param	d	Destination buffer.
 * 	@param	ds	Size of \a d (number of elements).
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_cnv_c8p_to_c32_app(
  dk3_c32_t *d, size_t ds, char const *s, dk3_app_t *app
);

/**	Convert UTF-8 string to 32-bit.
 * 	@param	d	Destination buffer.
 * 	@param	ds	Size of \a d (number of elements).
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_cnv_c8u_to_c32_app(
  dk3_c32_t *d, size_t ds, char const *s, dk3_app_t *app
);

/**	Convert UTF-16 string to 32-bit.
 * 	@param	d	Destination buffer.
 * 	@param	ds	Size of \a d (number of elements).
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_cnv_c16_to_c32_app(
  dk3_c32_t *d, size_t ds, dk3_c16_t const *s, dk3_app_t *app
);

/**	Convert 32-bit string to ISO-LATIN-1.
 * 	@param	d	Destination buffer.
 * 	@param	ds	Size of \a d (number of elements).
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_cnv_c32_to_c8p_app(
  char *d, size_t ds, dk3_c32_t const *s, dk3_app_t *app
);

/**	Convert 32-bit string to UTF-8.
 * 	@param	d	Destination buffer.
 * 	@param	ds	Size of \a d (number of elements).
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_cnv_c32_to_c8u_app(
  char *d, size_t ds, dk3_c32_t const *s, dk3_app_t *app
);

/**	Convert 32-bit string to UTF-16.
 * 	@param	d	Destination buffer.
 * 	@param	ds	Size of \a d (number of elements).
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3str_cnv_c32_to_c16_app(
  dk3_c16_t *d, size_t ds, dk3_c32_t const *s, dk3_app_t *app
);

/**	Convert ISO-LATIN-1 string to UTF-8, allocate new memory for result.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new result string on success, NULL on error.
 */
char *
dk3str_cnvnew_c8p_to_c8u_app(char const *s, dk3_app_t *app);

/**	Convert UTF-8 string to ISO-LATIN-1, allocate new memory for result.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new result string on success, NULL on error.
 */
char *
dk3str_cnvnew_c8u_to_c8p_app(char const *s, dk3_app_t *app);

/**	Convert ISO-LATIN-1 string to UTF-16, allocate new memory for result.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new result string on success, NULL on error.
 */
dk3_c16_t *
dk3str_cnvnew_c8p_to_c16_app(char const *s, dk3_app_t *app);

/**	Convert UTF-8 string to UTF-16, allocate new memory for result.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new result string on success, NULL on error.
 */
dk3_c16_t *
dk3str_cnvnew_c8u_to_c16_app(char const *s, dk3_app_t *app);

/**	Convert UTF-16 string to ISO-LATIN-1, allocate new memory for result.
 * 	@param	s	Source string.
 * 	@param	app	Application structure, used for diagnostics.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new result string on success, NULL on error.
 */
char *
dk3str_cnvnew_c16_to_c8p_app(dk3_c16_t const *s, dk3_app_t *app);

/**	Convert UTF-16 string to UTF-8, allocate new memory for result.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new result string on success, NULL on error.
 */
char *
dk3str_cnvnew_c16_to_c8u_app(dk3_c16_t const *s, dk3_app_t *app);

/**	Convert ISO-LATIN-1 string to 32-bit, allocate new memory for result.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new result string on success, NULL on error.
 */
dk3_c32_t *
dk3str_cnvnew_c8p_to_c32_app(char const *s, dk3_app_t *app);

/**	Convert UTF-8 string to 32-bit, allocate new memory for result.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new result string on success, NULL on error.
 */
dk3_c32_t *
dk3str_cnvnew_c8u_to_c32_app(char const *s, dk3_app_t *app);

/**	Convert UTF-16 string to 32-bit, allocate new memory for result.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new result string on success, NULL on error.
 */
dk3_c32_t *
dk3str_cnvnew_c16_to_c32_app(dk3_c16_t const *s, dk3_app_t *app);

/**	Convert 32-bit string to ISO_LATIN-1, allocate new memory for result.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new result string on success, NULL on error.
 */
char *
dk3str_cnvnew_c32_to_c8p_app(dk3_c32_t const *s, dk3_app_t *app);

/**	Convert 32-bit string to UTF-8, allocate new memory for result.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new result string on success, NULL on error.
 */
char *
dk3str_cnvnew_c32_to_c8u_app(dk3_c32_t const *s, dk3_app_t *app);

/**	Convert 32-bit to UTF_16, allocate new memory for result.
 * 	@param	s	Source string.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new result string on success, NULL on error.
 */
dk3_c16_t *
dk3str_cnvnew_c32_to_c16_app(dk3_c32_t const *s, dk3_app_t *app);

/**	Convert 8-bit character to 8/16-bit character
	without re-encoding. This function is mainly intended to convert
	pure ASCII characters like numeric values.
	@param	d	Destination buffer.
	@param	sz	Size of \a d in characters.
	@param	s	Source string.
   	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3str_cnv_c8_to_str_app(dkChar *d, size_t sz, char const *s, dk3_app_t *app);

/**	Convert dkChar string to 8-bit (simple version, 
	used to read numeric values).
	@param	db	Destination buffer.
	@param	sz	Size of \a db.
	@param	s	Source string.
	@param	ap	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error
	(buffer too short or character out of range).
*/
int
dk3str_string_to_c8_simple_app(
  char *db,size_t sz,dkChar const *s,dk3_app_t *ap
);

/**	Convert string to all lower-case characters.
	@param	s	String to modify.
*/
void
dk3str_string_tolower(dkChar *s);

/**	Convert 8-bit text to dkChar string.
	@param	dp	Destination pointer.
	@param	ds	Size of \a dp (number of characters).
	@param	sp	Source pointer.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error (output buffer too small).
*/
int
dk3str_c8_to_str_simple_app(
  dkChar *dp, size_t ds, char const *sp, dk3_app_t *app
);

/**	Convert dkChar string to plain 8-bit text.
	@param	dp	Destination buffer pointer.
	@param	sz	Size of \a dp (number of bytes).
	@param	src	Source text.
	@param	ie	Input encoding (used only for 8-bit characters).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3str_to_c8p_app(
  char *dp, size_t sz, dkChar const *src, int ie, dk3_app_t *app
);

/**	Convert dkChar string to UTF-8 text.
	@param	dp	Destination buffer pointer.
	@param	sz	Size of \a dp (number of bytes).
	@param	src	Source text.
	@param	ie	Input encoding (used only for 8-bit characters).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3str_to_c8u_app(
  char *dp, size_t sz, dkChar const *src, int ie, dk3_app_t *app
);

/**	Convert UTF-8 encoded string to dkChar string.
	@param	d	Destination buffer.
	@param	dsz	Size of @a d (number of elements).
	@param	de	Destination buffer encoding.
	@param	s	Source string.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3str_c8u_to_str_app(
  dkChar 		*d,
  size_t		 dsz,
  int			 de,
  char const		*s,
  dk3_app_t		*app
);

/**	Convert dkChar string to UTF-8 encoded string.
	@param	d	Destination buffer.
	@param	dsz	Size of @a d (number of bytes).
	@param	s	Source string.
	@param	se	Source encoding (used for 8-bit characters only).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3str_str_to_c8u_app(
  char		*d,
  size_t	 dsz,
  dkChar const	*s,
  int		 se,
  dk3_app_t	*app
);

/**	Convert dkChar string to 8-bit character string.
	@param	dp	Destination buffer pointer.
	@param	szdp	Size of dp.
	@param	src	Source string.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3str_to_c8_app(char *dp, size_t szdp, dkChar const *src, dk3_app_t *app);

#ifdef __cplusplus
}
#endif




#endif
