/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3str.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3str.c The dk3str module.
*/


#line 1426 "dk3str.ctr"

#include "dk3all.h"




#line 1431 "dk3str.ctr"


/* ************************************************************************ */
/* *                                                                      * */
/* *         Static data                                                  * */
/* *                                                                      * */
/* ************************************************************************ */


#line 1436 "dk3str.ctr"


/**	The set of whitespace characters.
*/
static char const dk3str_c8_def_whsp[] = { " \t\r\n" };

/**	The current directory.
*/
static char const dk3str_c8_dot[] = { "." };

/**	The parent directory.
*/
static char const dk3str_c8_dot_dot[] = { ".." };

/**	File name separator.
*/
static char const dk3str_c8_fnsep[] = {
#if DK3_ON_WINDOWS || DK3_HAVE_BACKSLASH
"\\"
#else
"/"
#endif
};


/**	Keywords to set boolean values.
*/
static char const * const dk3str_c8_bool_kw[] = {
  "0",
  "n$o",
  "of$f",
  "f$alse",
  "-",
  "+",
  "1",
  "y$es",
  "on",
  "ok",
  "t$rue",
  NULL
};

/**	Index of first "true" entry in \a dk3str_c8_bool_kw.
*/
#define	INDEX_OF_FIRST_BOOLEAN_TRUE 5


#if DK3_ON_WINDOWS || DK3_HAVE_BACKSLASH
/**	File name separator character.
*/
#define	FNS_C8		'\\'
/**	Not the file name separator character.
*/
#define	NO_FNS_C8	'/'
#else
/**	File name separator character.
*/
#define	FNS_C8		'/'
/**	Not the file name separator character.
*/
#define	NO_FNS_C8	'\\'
#endif



/**	Default white spaces set.
*/
static dk3_c16_t const c16_def_whsp[] = {
  0x0020U, 0x0009U, 0x000AU, 0x000DU, 0U
};

/**	The dot for the current directory.
*/
static dk3_c16_t const c16_dot[] = {
  0x002EU, 0U
};

/**	The dot dot for the parent directory.
*/
static dk3_c16_t const c16_dot_dot[] = {
  0x002EU, 0x002EU, 0U
};

/**	File name separator (slash or backslash).
*/
static dk3_c16_t const c16_fnsep[] = {
#if DK3_ON_WINDOWS || DK3_HAVE_BACKSLASH
0x005CU,
#else
0x002FU,
#endif
0U
};

#if DK3_ON_WINDOWS || DK3_HAVE_BACKSLASH
/**	File name separator for 16-bit character strings.
*/
#define	FNS_C16		0x005CU
/**	Not the file name separator for 16-bit character strings.
*/
#define NO_FNS_C16	0x002FU
#else
/**	File name separator for 16-bit character strings.
*/
#define FNS_C16		0x002FU
/**	Not the file name separator for 16-bit character strings.
*/
#define NO_FNS_C16	0x005CU
#endif



/**	Default whitespaces set.
*/
static dk3_c32_t const c32_def_whsp[] = {
  0x00000020UL, 0x00000009UL, 0x0000000AUL, 0x0000000DUL, 0UL
};

/**	The dot is the current directory.
*/
static dk3_c32_t const c32_dot[] = {
  0x0000002EUL, 0UL
};

/**	The dot dot is the parent directory.
*/
static dk3_c32_t const c32_dot_dot[] = {
  0x0000002EUL, 0x0000002EUL, 0UL
};

/**	File name separator (slash or backslash).
*/
static dk3_c32_t const c32_fnsep[] = {
#if DK3_ON_WINDOWS || DK3_HAVE_BACKSLASH
0x0000005CUL,
#else
0x0000002FUL,
#endif
0U
};

#if DK3_ON_WINDOWS || DK3_HAVE_BACKSLASH
/**	File name separator for 32-bit character strings.
*/
#define	FNS_C32		0x0000005CUL
/**	Not a file name separator for 32-bit character strings.
*/
#define NO_FNS_C32	0x0000002FUL
#else
/**	File name separator for 32-bit character strings.
*/
#define FNS_C32		0x0000002FUL
/**	Not a file name separator for 32-bit character strings.
*/
#define NO_FNS_C32	0x0000005CUL
#endif



size_t
dk3str_c8_len(char const *s)
{
  register size_t back;		/* Function result. */
#if DK3_HAVE_STRLEN
  back = strlen(s);
#else
  register char const *ptr;	/* Pointer to traverse s. */
  back = 0; ptr = s;
  while(*(ptr++)) back++;
#endif
  return back;
}



size_t
dk3str_c16_len(dk3_c16_t const *s)
{
  register size_t back;
#if (DK3_HAVE_WCSLEN) && (DK3_SIZEOF_WCHAR_T == 2)
  back = wcslen(s);
#else
#if (DK3_HAVE__WCSLEN) && (DK3_SIZEOF_WCHAR_T == 2)
  back = _wcslen(s);
#else
  register dk3_c16_t const *ptr;	/* Traverse string. */
  back = 0; ptr = s;
  while(*(ptr++)) back++;
#endif
#endif
  return back;
}



size_t
dk3str_c32_len(dk3_c32_t const *s)
{
  register size_t back;
#if (DK3_HAVE_WCSLEN) && (DK3_SIZEOF_WCHAR_T == 4)
  back = wcslen(s);
#else
#if (DK3_HAVE__WCSLEN) && (DK3_SIZEOF_WCHAR_T == 4)
  back = _wcslen(s);
#else
  register dk3_c32_t const *ptr;	/* Traverse source string. */
  back = 0; ptr = s;
  while(*(ptr++)) back++;
#endif
#endif
  return back;
}



size_t
dk3str_len(dkChar const *s)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_len(s));
#else
  return(dk3str_c16_len(s));
#endif
#else
  return(dk3str_c8_len(s));
#endif
}



int
dk3str_c8_cmp(char const *s1, char const *s2)
{
  register int back;		/* Function result. */
#if DK3_HAVE_STRCMP
  back = strcmp(s1, s2);
#else
  register char const *p1;	/* Pointer to traverse s1. */
  register char const *p2;	/* Pointer to traverse s2. */
  register int  cc;		/* Flag: Can continue. */
  back = 0; p1 = s1; p2 = s2; cc = 1;
  while((cc) && (back == 0)) {
    if(*p1 > *p2) {
      back = 1;
    } else {
      if(*p1 < *p2) {
        back = -1;
      } else {
        if((*p1) && (*p2)) {
	  p1++; p2++;
	} else {
	  cc = 0;
	}
      }
    }
  }
#endif
  return back;
}



int
dk3str_c16_cmp(dk3_c16_t const *s1, dk3_c16_t const *s2)
{
  register int back;
#if (DK3_HAVE_WCSCPY) && (DK3_SIZEOF_WCHAR_T == 2)
  back = wcscmp(s1, s2);
#else
#if (DK3_HAVE__WCSCPY) && (DK3_SIZEOF_WCHAR_T == 2)
  back = _wcscmp(s1, s2);
#else
  register dk3_c16_t const *p1;	/* Traverse left string. */
  register dk3_c16_t const *p2;	/* Traverse right string. */
  register int cc;		/* Flag: Can continue. */

  back = 0; p1 = s1; p2 = s2; cc = 1;
  while((cc) && (back == 0)) {
    if(*p1 > *p2) {
      back = 1;
    } else {
      if(*p1 < *p2) {
        back = -1;
      } else {
        if((*p1) && (*p2)) {
	  p1++; p2++;
	} else {
	  cc = 0;
	}
      }
    }
  }
#endif
#endif
  return back;
}



int
dk3str_c32_cmp(dk3_c32_t const *s1, dk3_c32_t const *s2)
{
  register int back;
#if (DK3_HAVE_WCSCMP) && (DK3_SIZEOF_WCHAR_T == 4)
  back = wcscmp(s1, s2);
#else
#if (DK3_HAVE__WCSCMP) && (DK3_SIZEOF_WCHAR_T == 4)
  back = _wcscmp(s1, s2);
#else
  register dk3_c32_t const *p1;	/* Traverse left string. */
  register dk3_c32_t const *p2;	/* Traverse right string. */
  register int cc;		/* Flag: Can continue. */

  back = 0; p1 = s1; p2 = s2; cc = 1;
  while((cc) && (back == 0)) {
    if(*p1 > *p2) {
      back = 1;
    } else {
      if(*p1 < *p2) {
        back = -1;
      } else {
        if((*p1) && (*p2)) {
	  p1++; p2++;
	} else {
	  cc = 0;
	}
      }
    }
  }
#endif
#endif
  return back;
}



int
dk3str_cmp(dkChar const *s1, dkChar const *s2)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_cmp(s1, s2));
#else
  return(dk3str_c16_cmp(s1, s2));
#endif
#else
  return(dk3str_c8_cmp(s1, s2));
#endif
}



int
dk3str_c8_casecmp(char const *s1, char const *s2)
{
  register int back;		/* Function result. */
#if DK3_HAVE_STRCASECMP
  back = strcasecmp(s1, s2);
#else
#if DK3_HAVE_STRICMP && (!DK3_ON_WINDOWS)
  back = stricmp(s1, s2);
#else
#if DK3_HAVE__STRICMP || DK3_ON_WINDOWS
  back = _stricmp(s1, s2);
#else
  register char const *p1;	/* Pointer to traverse s1. */
  register char const *p2;	/* Pointer to traverse s2. */
  register char c1;		/* Current character from s1. */
  register char c2;		/* Current character from s2. */
  register int cc;		/* Flag: Can continue. */
  back = 0; p1 = s1; p2 = s2; cc = 1;
  while((cc) && (back == 0)) {
    c1 = *p1; c2 = *p2;
    if((c1 >= 'A') && (c1 <= 'Z')) { c1 = 'a' + (c1 - 'A'); }
    if((c2 >= 'A') && (c2 <= 'Z')) { c2 = 'a' + (c2 - 'A'); }
    if(c1 > c2) {
      back = 1;
    } else {
      if(c1 < c2) {
        back = -1;
      } else {
        if((c1) && (c2)) {
	  p1++; p2++;
	} else {
	  cc = 0;
	}
      }
    }
  }
#endif
#endif
#endif
  return back;
}



int
dk3str_c16_casecmp(dk3_c16_t const *s1, dk3_c16_t const *s2)
{
  register int back;
#if (DK3_HAVE_WCSICMP) && (DK3_SIZEOF_WCHAR_T == 2)
  back = wcsicmp(s1, s2);
#else
#if (DK3_HAVE__WCSICMP) && (DK3_SIZEOF_WCHAR_T == 2)
  back = _wcsicmp(s1, s2);
#else
  register dk3_c16_t const *p1;	/* Traverse left string. */
  register dk3_c16_t const *p2;	/* Traverse right string. */
  register dk3_c16_t c1;	/* Left character. */
  register dk3_c16_t c2;	/* Right character. */
  register int cc;		/* Flag: Can continue. */
  

#line 1850 "dk3str.ctr"
  back = 0; p1 = s1; p2 = s2; cc = 1;
  while((cc) && (back == 0)) {
    c1 = *p1; c2 = *p2;
    if((c1 >= 0x0041U) && (c1 <= 0x005AU)) { c1 = 0x0061U + (c1 - 0x0041U); }
    if((c2 >= 0x0041U) && (c2 <= 0x005AU)) { c2 = 0x0061U + (c2 - 0x0041U); }
    if(c1 > c2) {
      back = 1;
    } else {
      if(c1 < c2) {
        back = -1;
      } else {
        if((c1) && (c2)) {
	  p1++; p2++;
	} else {
	  cc = 0;
	}
      }
    }
  } 

#line 1869 "dk3str.ctr"
#endif
#endif
  return back;
}



int
dk3str_c32_casecmp(dk3_c32_t const *s1, dk3_c32_t const *s2)
{
  register int back;
#if (DK3_HAVE_WCSICMP) && (DK3_SIZEOF_WCHAR_T == 4)
  back = wcsicmp(s1, s2);
#else
#if (DK3_HAVE__WCSICMP) && (DK3_SIZEOF_WCHAR_T == 4)
  back = _wcsicmp(s1, s2);
#else
  register dk3_c32_t const *p1;	/* Traverse left string. */
  register dk3_c32_t const *p2;	/* Traverse right string. */
  register dk3_c32_t c1;	/* Left character. */
  register dk3_c32_t c2;	/* Right character. */
  register int cc;		/* Flag: Can continue. */

  back = 0; p1 = s1; p2 = s2; cc = 1;
  while((cc) && (back == 0)) {
    c1 = *p1; c2 = *p2;
    if((c1 >= (dk3_c32_t)0x00000041UL) && (c1 <= (dk3_c32_t)0x0000005AUL)) {
      c1 = 0x00000061UL + (c1 - 0x00000041UL);
    }
    if((c2 >= (dk3_c32_t)0x00000041UL) && (c2 <= (dk3_c32_t)0x0000005AUL)) {
      c2 = 0x00000061UL + (c2 - 0x00000041UL);
    }
    if(c1 > c2) {
      back = 1;
    } else {
      if(c1 < c2) {
        back = -1;
      } else {
        if((c1) && (c2)) {
	  p1++; p2++;
	} else {
	  cc = 0;
	}
      }
    }
  }
#endif
#endif
  return back;
}



int
dk3str_casecmp(dkChar const *s1, dkChar const *s2)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_casecmp(s1, s2));
#else
  return(dk3str_c16_casecmp(s1, s2));
#endif
#else
  return(dk3str_c8_casecmp(s1, s2));
#endif
}



int
dk3str_fncmp(dkChar const *s1, dkChar const *s2)
{
#if DK3_ON_WINDOWS || DK3_HAVE_FNCASEINS
  return(dk3str_casecmp(s1, s2));
#else
  return(dk3str_cmp(s1, s2));
#endif
}


int
dk3str_c8_ncmp(char const *s1, char const *s2, size_t n)
{
  register int back;		/* Function result. */
#if DK3_HAVE_STRNCMP
  back = strncmp(s1, s2, n);
#else
  register char const *p1;	/* Pointer to traverse s1. */
  register char const *p2;	/* Pointer to traverse s2. */
  register size_t max;		/* Register copy of n. */
  register size_t used;		/* Number of chars already used. */
  back = 0; p1 = s1; p2 = s2; max = n; used = 0;
  while((used < max) && (back == 0)) {
    if(*p1 > *p2) {
      back = 1;
    } else {
      if(*p1 < *p2) {
        back = -1;
      } else {
        if((*p1) && (*p2)) {
	  p1++; p2++; used++;
	} else {
	  used = max;
	}
      }
    }
  }
#endif
  return back;
}



int
dk3str_c16_ncmp(dk3_c16_t const *s1, dk3_c16_t const *s2, size_t n)
{
  register int back;
#if (DK3_HAVE_WCSNCMP) && (DK3_SIZEOF_WCHAR_T == 2)
  back = wcsncmp(s1, s2, n);
#else
#if (DK3_HAVE__WCSNCMP) && (DK3_SIZEOF_WCHAR_T == 2)
  back = _wcsncmp(s1, s2, n);
#else
  register dk3_c16_t const *p1;	/* Traverse left string. */
  register dk3_c16_t const *p2;	/* Traverse right string. */
  register size_t max;		/* Maximum number of characters to compare. */
  register size_t used;		/* Number of characters already compared. */

  back = 0; p1 = s1; p2 = s2; max = n; used = 0;
  while((used < max) && (back == 0)) {
    if(*p1 > *p2) {
      back = 1;
    } else {
      if(*p1 < *p2) {
        back = -1;
      } else {
        if((*p1) && (*p2)) {
	  p1++; p2++; used++;
	} else {
	  used = max;
	}
      }
    }
  }
#endif
#endif
  return back;
}



int
dk3str_c32_ncmp(dk3_c32_t const *s1, dk3_c32_t const *s2, size_t n)
{
  register int back;
#if (DK3_HAVE_WCSNCMP) && (DK3_SIZEOF_WCHAR_T == 4)
  back = wcsncmp(s1, s2, n);
#else
#if (DK3_HAVE__WCSNCMP) && (DK3_SIZEOF_WCHAR_T == 4)
  back = _wcsncmp(s1, s2, n);
#else
  register dk3_c32_t const *p1;	/* Traverse left string. */
  register dk3_c32_t const *p2;	/* Traverse right string. */
  register size_t max;		/* Maximum number of characters to compare. */
  register size_t used;		/* Number of characters used. */

  back = 0; p1 = s1; p2 = s2; max = n; used = 0;
  while((used < max) && (back == 0)) {
    if(*p1 > *p2) {
      back = 1;
    } else {
      if(*p1 < *p2) {
        back = -1;
      } else {
        if((*p1) && (*p2)) {
	  p1++; p2++; used++;
	} else {
	  used = max;
	}
      }
    }
  }
#endif
#endif
  return back;
}



int
dk3str_ncmp(dkChar const *s1, dkChar const *s2, size_t n)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_ncmp(s1, s2, n));
#else
  return(dk3str_c16_ncmp(s1, s2, n));
#endif
#else
  return(dk3str_c8_ncmp(s1, s2, n));
#endif
}



char *
dk3str_c8_chr(char const *s, char c)
{
  register char *back;		/* Function result. */
#if DK3_HAVE_STRCHR
  back = strchr(s, c);
#else
  register char const *ptr;	/* Pointer to traverse s. */
  register char chr;		/* Register copy of c. */
  back = NULL; ptr = s; chr = c;
  while((*ptr) && (back == NULL)) {
    if(*ptr == chr) { back = (char *)ptr; } else { ptr++; }
  }
#endif
  return back;
}



dk3_c16_t *
dk3str_c16_chr(dk3_c16_t const *s, dk3_c16_t c)
{
  register dk3_c16_t *back;
#if (DK3_HAVE_WCSCHR) && (DK3_SIZEOF_WCHAR_T == 2)
  back = wcschr(s, c);
#else
#if (DK3_HAVE__WCSCHR) && (DK3_SIZEOF_WCHAR_T == 2)
  back = _wcschr(s, c);
#else
  register dk3_c16_t const *ptr;	/* Traverse source string. */
  register dk3_c16_t chr;		/* Character to search for. */
  back = NULL; ptr = s; chr = c;
  while((*ptr) && (back == NULL)) {
    if(*ptr == chr) { back = (dk3_c16_t *)ptr; } else { ptr++; }
  }
#endif
#endif
  return back;
}



dk3_c32_t *
dk3str_c32_chr(dk3_c32_t const *s, dk3_c32_t c)
{
  register dk3_c32_t *back;
#if (DK3_HAVE_WCSCHR) && (DK3_SIZEOF_WCHAR_T == 4)
  back = wcschr(s, c);
#else
#if (DK3_HAVE__WCSCHR) && (DK3_SIZEOF_WCHAR_T == 4)
  back = _wcschr(s, c);
#else
  register dk3_c32_t const *ptr;	/* Traverse source string. */
  register dk3_c32_t chr;		/* Character to find. */

  back = NULL; ptr = s; chr = c;
  while((*ptr) && (back == NULL)) {
    if(*ptr == chr) { back = (dk3_c32_t *)ptr; } else { ptr++; }
  }
#endif
#endif
  return back;
}



dkChar *
dk3str_chr(dkChar const *s, dkChar c)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_chr(s, c));
#else
  return(dk3str_c16_chr(s, c));
#endif
#else
  return(dk3str_c8_chr(s, c));
#endif
}


char *
dk3str_c8_rchr(char const *s, char c)
{
  register char *back;		/* Function result. */
#if DK3_HAVE_STRRCHR
  back = strrchr(s, c);
#else
  register char const *ptr;	/* Pointer to traverse s. */
  register char chr;		/* Register copy of c. */
  back = NULL; ptr = s; chr = c;
  while(*ptr) {
    if(*ptr == chr) { back = (char *)ptr; }
    ptr++;
  }
#endif
  return back;
}




dk3_c16_t *
dk3str_c16_rchr(dk3_c16_t const *s, dk3_c16_t c)
{
  register dk3_c16_t *back;
#if (DK3_HAVE_WCSRCHR) && (DK3_SIZEOF_WCHAR_T == 2)
  back = wcsrchr(s, c);
#else
#if (DK3_HAVE__WCSRCHR) && (DK3_SIZEOF_WCHAR_T == 2)
  back = _wcsrchr(s, c);
#else
  register dk3_c16_t const *ptr;	/* Traverse the string. */
  register dk3_c16_t chr;		/* Character to search for. */
  back = NULL; ptr = s; chr = c;
  while(*ptr) {
    if(*ptr == chr) { back = (dk3_c16_t *)ptr; }
    ptr++;
  }
#endif
#endif
  return back;
}



dk3_c32_t *
dk3str_c32_rchr(dk3_c32_t const *s, dk3_c32_t c)
{
  register dk3_c32_t *back;
#if (DK3_HAVE_WCSRCHR) && (DK3_SIZEOF_WCHAR_T == 4)
  back = wcsrchr(s, c);
#else
#if (DK3_HAVE__WCSRCHR) && (DK3_SIZEOF_WCHAR_T == 4)
  back = _wcsrchr(s, c);
#else
  register dk3_c32_t const *ptr;	/* Traverse source string. */
  register dk3_c32_t chr;		/* Character to search for. */

  back = NULL; ptr = s; chr = c;
  while(*ptr) {
    if(*ptr == chr) { back = (dk3_c32_t *)ptr; }
    ptr++;
  }
#endif
#endif
  return back;
}



dkChar *
dk3str_rchr(dkChar const *s, dkChar c)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_rchr(s, c));
#else
  return(dk3str_c16_rchr(s, c));
#endif
#else
  return(dk3str_c8_rchr(s, c));
#endif
}


void
dk3str_c8_cpy(char *d, char const *s)
{
  register char *dp;		/* Destination buffer pointer. */
  register char const *sp;	/* Source buffer pointer. */
  register char x;
  dp = d; sp = s;
  while(*sp) { x = *(sp++); *(dp++) = x; }
  *dp = '\0';
}



void
dk3str_c16_cpy(dk3_c16_t *d, dk3_c16_t const *s)
{
  register dk3_c16_t *dp;	/* Destination pointer. */
  register dk3_c16_t const *sp;	/* Source pointer. */
  register dk3_c16_t x;		/* Current character. */

  dp = d; sp = s;
  while(*sp) { x = *(sp++); *(dp++) = x; }
  *dp = 0U;
}



void
dk3str_c32_cpy(dk3_c32_t *d, dk3_c32_t const *s)
{
  register dk3_c32_t *dp;	/* Destination pointer. */
  register dk3_c32_t const *sp;	/* Source pointer. */
  register dk3_c32_t x;		/* Current character. */
  dp = d; sp = s;
  while(*sp) { x = *(sp++); *(dp++) = x; }
  *dp = 0UL;
}



void
dk3str_cpy(dkChar *d, dkChar const *s)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  dk3str_c32_cpy(d, s);
#else
  dk3str_c16_cpy(d, s);
#endif
#else
  dk3str_c8_cpy(d, s);
#endif
}


void
dk3str_c8_cpy_not_overlapped(char *d, char const *s)
{
#if DK3_HAVE_STRCPY
  strcpy(d, s);
#else
#if DK3_HAVE_STRLEN
  size_t	sz;
  int		ec	=	0;
  sz = dk3mem_add_size_t(1, strlen(s), &ec);
  if((0 != sz) && (0 == ec)) {
    dk3mem_cpy(d,s,sz);
  } else {
    dk3str_c8_cpy(d, s);
  }
#else
  dk3str_c8_cpy(d, s);
#endif
#endif
}



void
dk3str_c16_cpy_not_overlapped(dk3_c16_t *d, dk3_c16_t const *s)
{
#if (DK3_HAVE_WCSCPY) && (DK3_SIZEOF_WCHAR_T == 2)
  wcscpy(d, s);
#else
#if (DK3_HAVE__WCSCPY) && (DK3_SIZEOF_WCHAR_T == 2)
  _wcscpy(d, s);
#else
#if (DK3_HAVE_WCSLEN) && (DK3_SIZEOF_WCHAR_T == 2)
  size_t	sz;
  int		ec	= 0;
  sz = dk3mem_mul_size_t(2, dk3mem_add_size_t(1, wcslen(s), &ec), &ec);
  if((0 != sz) && (0 == ec)) {
    dk3mem_cpy(d, s, sz);
  } else {
    dk3str_c16_cpy(d,s);
  }
#else
#if (DK3_HAVE__WCSLEN) && (DK3_SIZEOF_WCHAR_T == 2)
  size_t	sz;
  int		ec	= 0;
  sz = dk3mem_mul_size_t(2, dk3mem_add_size_t(1, _wcslen(s), &ec), &ec);
  if((0 != sz) && (0 == ec)) {
    dk3mem_cpy(d, s, sz);
  } else {
    dk3str_c16_cpy(d,s);
  }
#else
  dk3str_c16_cpy(d,s);
#endif
#endif
#endif
#endif
}



void
dk3str_c32_cpy_not_overlapped(dk3_c32_t *d, dk3_c32_t const *s)
{
#if (DK3_HAVE_WCSCPY) && (DK3_SIZEOF_WCHAR_T == 4)
  wcscpy(d, s);
#else
#if (DK3_HAVE__WCSCPY) && (DK3_SIZEOF_WCHAR_T == 4)
  _wcscpy(d, s);
#else
#if (DK3_HAVE_WCSLEN) && (DK3_SIZEOF_WCHAR_T == 4)
  size_t	sz;
  int		ec	= 0;
  sz = dk3mem_mul_size_t(4, dk3mem_add_size_t(1, wcslen(s), &ec), &ec);
  if((0 != sz) && (0 == ec)) {
    dk3mem_cpy(d, s, sz);
  } else {
    dk3str_c32_cpy(d,s);
  }
#else
#if (DK3_HAVE__WCSLEN) && (DK3_SIZEOF_WCHAR_T == 4)
  size_t	sz;
  int		ec	= 0;
  sz = dk3mem_mul_size_t(4, dk3mem_add_size_t(1, _wcslen(s), &ec), &ec);
  if((0 != sz) && (0 == ec)) {
    dk3mem_cpy(d, s, sz);
  } else {
    dk3str_c32_cpy(d,s);
  }
#else
  dk3str_c32_cpy(d,s);
#endif
#endif
#endif
#endif
}



void
dk3str_cpy_not_overlapped(dkChar *d, dkChar const *s)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  dk3str_c32_cpy_not_overlapped(d, s);
#else
  dk3str_c16_cpy_not_overlapped(d, s);
#endif
#else
  dk3str_c8_cpy_not_overlapped(d, s);
#endif
}


void
dk3str_c8_ncpy(char *d, char const *s, size_t n)
{
#if DK3_HAVE_STRNCPY
  strncpy(d,s,n);
  d[n-1] = '\0';
#else
  register char *dp;		/* Destination buffer pointer. */
  register char const *sp;	/* Source buffer pointer. */
  register size_t max;		/* Register copy of n. */
  register size_t used;		/* Number of characters already copied. */
  register char	  x;
  dp = d; sp = s; max = n; used = 0;
  while((*sp) && (used < max)) { x = *(sp++); *(dp++) = x;  used++; }
  if(used < max) { *dp = '\0'; }
  else		 { d[max - 1] = '\0'; }
#endif
}



void
dk3str_c16_ncpy(dk3_c16_t *d, dk3_c16_t const *s, size_t n)
{
#if (DK3_HAVE_WCSNCPY) && (DK3_SIZEOF_WCHAR_T == 2)
  wcsncpy(d,s,n);
  d[n-1] = 0U;
#else
#if (DK3_HAVE__WCSNCPY) && (DK3_SIZEOF_WCHAR_T == 2)
  _wcsncpy(d,s,n);
  d[n-1] = 0U;
#else
  register dk3_c16_t *dp;	/* Destionation pointer. */
  register dk3_c16_t const *sp;	/* Source pointer. */
  register dk3_c16_t x;		/* Current character. */
  register size_t max;		/* Maximum number of characters to copy. */
  register size_t used;		/* Characters already copied. */

  dp = d; sp = s; max = n; used = 0;
  while((*sp) && (used < max)) { x = *(sp++); *(dp++) = x; used++; }
  if(used < max) { *dp = 0U; }
  else { d[max - 1] = 0U; }
#endif
#endif
}



void
dk3str_c32_ncpy(dk3_c32_t *d, dk3_c32_t const *s, size_t n)
{
#if (DK3_HAVE_WCSNCPY) && (DK3_SIZEOF_WCHAR_T == 4)
  wcsncpy(d,s,n);
  d[n-1] = 0UL;
#else
#if (DK3_HAVE__WCSNCPY) && (DK3_SIZEOF_WCHAR_T == 4)
  _wcsncpy(d,s,n);
  d[n-1] = 0UL;
#else
  register dk3_c32_t *dp;	/* Destination pointer. */
  register dk3_c32_t const *sp;	/* Source pointer. */
  register dk3_c32_t x;		/* Current character. */
  register size_t max;		/* Maximum number of characters to copy. */
  register size_t used;		/* Number of characters copied. */

  dp = d; sp = s; max = n; used = 0;
  while((*sp) && (used < max)) { x = *(sp++); *(dp++) = x; used++; }
  if(used < max) { *dp = 0UL; }
  else { d[max - 1] = 0UL; }
#endif
#endif
}



void
dk3str_ncpy(dkChar *d, dkChar const *s, size_t n)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  dk3str_c32_ncpy(d, s, n);
#else
  dk3str_c16_ncpy(d, s, n);
#endif
#else
  dk3str_c8_ncpy(d, s, n);
#endif
}



void
dk3str_c8_cat(char *d, char const *s)
{
#if DK3_HAVE_STRCAT
  strcat(d, s);
#else
  register char *dp;		/* Destination buffer pointer. */
  register char const *sp;	/* Source buffer pointer. */
  register char x;
  dp = d; sp = s;
  while(*dp) dp++;
  while(*sp) { x = *(sp++); *(dp++) = x; }
  *dp = '\0';
#endif
}



void
dk3str_c16_cat(dk3_c16_t *d, dk3_c16_t const *s)
{
#if (DK3_HAVE_WCSCAT) && (DK3_SIZEOF_WCHAR_T == 2)
  wcscat(d, s);
#else
#if (DK3_HAVE__WCSCAT) && (DK3_SIZEOF_WCHAR_T == 2)
  _wcscat(d, s);
#else
  register dk3_c16_t *dp;	/* Destination pointer. */
  register dk3_c16_t const *sp;	/* Source pointer. */
  register dk3_c16_t x;		/* Current character. */
  dp = d; sp = s;
  while(*dp) dp++;
  while(*sp) { x = *(sp++); *(dp++) = x;  }
  *dp = 0U;
#endif
#endif
}



void
dk3str_c32_cat(dk3_c32_t *d, dk3_c32_t const *s)
{
#if (DK3_HAVE_WCSCAT) && (DK3_SIZEOF_WCHAR_T == 4)
  wcscat(d, s);
#else
#if (DK3_HAVE__WCSCAT) && (DK3_SIZEOF_WCHAR_T == 4)
  _wcscat(d, s);
#else
  register dk3_c32_t *dp;	/* Destination pointer. */
  register dk3_c32_t const *sp;	/* Source pointer. */
  register dk3_c32_t x;		/* Current character. */

  dp = d; sp = s;
  while(*dp) dp++;
  while(*sp) { x = *(sp++); *(dp++) = x; }
  *dp = 0UL;
#endif
#endif
}



void
dk3str_cat(dkChar *d, dkChar const *s)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  dk3str_c32_cat(d, s);
#else
  dk3str_c16_cat(d, s);
#endif
#else
  dk3str_c8_cat(d, s);
#endif
}



/**	Report memory allocation error.
	@param	app	Application structure.
	@param	elsize	Size of one character.
	@param	nelem	Number of characters required.
*/
static
void
dk3str_memory_error(dk3_app_t *app, size_t elsize, size_t nelem)
{
#if VERSION_BEFORE_20140716
  dkChar	bu1[64];
  unsigned long	prod;
  prod = (unsigned long)elsize * (unsigned long)nelem;
  dk3sf_sprintf3(bu1, dkT("%lu"), prod);
  dk3app_log_i3(app, DK3_LL_ERROR, 12, 13, bu1);
#else
  dkChar	bu1[64];
  dk3_um_t	prod;
  int		mec = 0;
  prod = dk3ma_um_mul_ok((dk3_um_t)elsize, (dk3_um_t)nelem, &mec);
  if (0 == mec) {
    if (dk3ma_um_to_string(bu1, DK3_SIZEOF(bu1,dkChar), (dk3_um_t)prod)) {
      dk3app_log_i3(app, DK3_LL_ERROR, 12, 13, bu1);
    }
  } else {
    /* Math overflow in size calculation */
    dk3app_log_i1(app, DK3_LL_ERROR, 15);
  }
#endif
}



char *
dk3str_c8_dup_app(char const *s, dk3_app_t *app)
{
  char	*back;
#if DK3_HAVE_STRDUP && (!DK3_ON_WINDOWS)
  back = strdup(s);
  if(!(back)) {
    if(app) {
      dk3str_memory_error(app, 1, (1+strlen(s)));
    }
  }
#else
#if DK3_HAVE__STRDUP || DK3_ON_WINDOWS
  back = _strdup(s);
  if(!(back)) {
    if(app) {
      dk3str_memory_error(app, 1, (1+strlen(s)));
    }
  }
#else
  size_t sz;
  sz = 1 + dk3str_c8_len(s);
  if(app) {
    back = dk3_new_app(char,sz,app);
  } else {
    back = dk3_new(char,sz);
  }
  if(back) {
    dk3str_c8_cpy_not_overlapped(back, s);
  }
#endif
#endif
  return back;
}



dk3_c16_t *
dk3str_c16_dup_app(dk3_c16_t const *s, dk3_app_t *app)
{
  dk3_c16_t *back;
#if (DK3_HAVE_WCSDUP) && (DK3_SIZEOF_WCHAR_T == 2)
  back = wcsdup(s);
  if(!(back)) {
    if(app) {
      dk3str_memory_error(app, 2, (1 + dk3str_c16_len(s)));
    }
  }
#else
#if (DK3_HAVE__WCSDUP) && (DK3_SIZEOF_WCHAR_T == 2)
  back = _wcsdup(s);
  if(!(back)) {
    if(app) {
      dk3str_memory_error(app, 2, (1 + dk3str_c16_len(s)));
    }
  }
#else
  size_t sz;
  sz = 1 + dk3str_c16_len(s);
  if(app) {
    back = dk3_new_app(dk3_c16_t,sz,app);
  } else {
    back = dk3_new(dk3_c16_t,sz);
  }
  if(back) {
    dk3str_c16_cpy_not_overlapped(back, s);
  }
#endif
#endif
  return back;
}



dk3_c32_t *
dk3str_c32_dup_app(dk3_c32_t const *s, dk3_app_t *app)
{
  dk3_c32_t *back;
#if (DK3_HAVE_WCSDUP) && (DK3_SIZEOF_WCHAR_T == 4)
  back = wcsdup(s);
  if(!(back)) {
    if(app) {
      dk3str_memory_error(app, 4, (1 + dk3str_c32_len(s)));
    }
  }
#else
#if (DK3_HAVE__WCSDUP) && (DK3_SIZEOF_WCHAR_T == 4)
  back = _wcsdup(s);
  if(!(back)) {
    if(app) {
      dk3str_memory_error(app, 4, (1 + dk3str_c32_len(s)));
    }
  }
#else
  size_t sz;
  sz = 1 + dk3str_c32_len(s);
  if(app) {
    back = dk3_new_app(dk3_c32_t,sz,app);
  } else {
    back = dk3_new(dk3_c32_t,sz);
  }
  if(back) {
    dk3str_c32_cpy(back, s);
  }
#endif
#endif
  return back;
}



dkChar *
dk3str_dup_app(dkChar const *s, dk3_app_t *app)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_dup_app(s, app));
#else
  return(dk3str_c16_dup_app(s, app));
#endif
#else
  return(dk3str_c8_dup_app(s, app));
#endif
}


char
dk3str_c8_tolower(char c)
{
  char back;		/* Function result. */
  back = c;
  if((back >= 'A') && (back <= 'Z')) {
    back = 'a' + (back - 'A');
  }
  return back;
}



dk3_c16_t
dk3str_c16_tolower(dk3_c16_t c)
{
  dk3_c16_t back;
  back = c;
  if((back >= 0x0041U) && (back <= 0x005AU)) {
    back = 0x0061U + (back - 0x0041U);
  }
  return back;
}



dk3_c32_t
dk3str_c32_tolower(dk3_c32_t c)
{
  dk3_c32_t back;
  back = c;
  if((back >= (dk3_c32_t)0x00000041UL) && (back <= (dk3_c32_t)0x0000005AUL)) {
    back = (dk3_c32_t)0x00000061UL + (back - (dk3_c32_t)0x00000041UL);
  }
  return back;
}



dkChar
dk3str_tolower(dkChar c)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_tolower(c));
#else
  return(dk3str_c16_tolower(c));
#endif
#else
  return(dk3str_c8_tolower(c));
#endif
}



char
dk3str_c8_toupper(char c)
{
  char back;		/* Function result. */
  back = c;
  if((back >= 'a') && (back <= 'z')) {
    back = 'A' + (back - 'a');
  }
  return back;
}



dk3_c16_t
dk3str_c16_toupper(dk3_c16_t c)
{
  dk3_c16_t back;
  back = c;
  if((back >= 0x0061U) && (back <= 0x007AU)) {
    back = 0x0041U + (back - 0x0061U);
  }
  return back;
}



dk3_c32_t
dk3str_c32_toupper(dk3_c32_t c)
{
  dk3_c32_t back;
  back = c;
  if((back >= (dk3_c32_t)0x00000061UL) && (back <= (dk3_c32_t)0x0000007AUL)) {
    back = (dk3_c32_t)0x00000041UL + (back - (dk3_c32_t)0x00000061UL);
  }
  return back;
}



dkChar
dk3str_toupper(dkChar c)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_toupper(c));
#else
  return(dk3str_c16_toupper(c));
#endif
#else
  return(dk3str_c8_toupper(c));
#endif
}



char *
dk3str_c8_start(char const *str, char const *whsp)
{
  char *back = NULL;	/* Function result. */
  char const *ptr;	/* Pointer to traverse str. */
  char const *wh;	/* Whitespaces set. */
  

#line 2855 "dk3str.ctr"
  if(str) {
    wh = (whsp ? whsp : dk3str_c8_def_whsp);
    ptr = str;
    while((*ptr) && (!(back))) {
      if(dk3str_c8_chr(wh,*ptr)) {
	ptr++;
      } else {
	back = (char *)ptr;
      }
    }
  } 

#line 2866 "dk3str.ctr"
  return back;
}



dk3_c16_t *
dk3str_c16_start(dk3_c16_t const *str, dk3_c16_t const *whsp)
{
  dk3_c16_t *back = NULL;
  dk3_c16_t const *ptr;		/* Pointer into string. */
  dk3_c16_t const *wh;		/* Whitespaces set. */

  if(str) {
    wh = (whsp ? whsp : c16_def_whsp);
    ptr = str;
    while((*ptr) && (!(back))) {
      if(dk3str_c16_chr(wh, *ptr)) {
        ptr++;
      } else {
        back = (dk3_c16_t *)ptr;
      }
    }
  }
  return back;
}



dk3_c32_t *
dk3str_c32_start(dk3_c32_t const *str, dk3_c32_t const *whsp)
{
  dk3_c32_t *back = NULL;
  dk3_c32_t const *ptr = NULL;	/* Current character. */
  dk3_c32_t const *wh = NULL;	/* Whitespaces set. */
  

#line 2901 "dk3str.ctr"
  if(str) {
    wh = (whsp ? whsp : c32_def_whsp);
    ptr = str;
    while((*ptr) && (!(back))) {
      if(dk3str_c32_chr(wh, *ptr)) {
        ptr++;
      } else {
        back = (dk3_c32_t *)ptr;
      }
    }
  } 

#line 2912 "dk3str.ctr"
  return back;
}



dkChar *
dk3str_start(dkChar const *str, dkChar const *whsp)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_start(str, whsp));
#else
  return(dk3str_c16_start(str, whsp));
#endif
#else
  return(dk3str_c8_start(str, whsp));
#endif
}



char    *
dk3str_c8_next(char *str, char const *whsp)
{
  char *back = NULL;		/* Function result. */
  char *ptr = NULL;		/* Pointer to traverse str. */
  char const *wh = NULL;	/* Whitespaces set to use. */
  int state = 0;		/* Current processing state. */
  

#line 2941 "dk3str.ctr"
  if(str) {
    ptr = str;
    wh = (whsp ? whsp : dk3str_c8_def_whsp);
    state = 0;
    while((state < 2) && (*ptr)) {
      if(dk3str_c8_chr(wh, *ptr)) {
	if(state == 1) {
	  state = 2;
	  *(ptr++) = '\0';
	  back = dk3str_c8_start(ptr, wh);
	} else {
	  ptr++;
	}
      } else {
	state = 1;
	ptr++;
      }
    }
  } 

#line 2960 "dk3str.ctr"
  return back;
}



dk3_c16_t *
dk3str_c16_next(dk3_c16_t *str, dk3_c16_t const *whsp)
{
  dk3_c16_t *back = NULL;
  dk3_c16_t *ptr;		/* Pointer into string. */
  dk3_c16_t const *wh;		/* Whitespaces set. */
  int state;			/* Current state. */

  if(str) {
    ptr = str;
    wh = (whsp ? whsp : c16_def_whsp);
    state = 0;
    while((state < 2) && (*ptr)) {
      if(dk3str_c16_chr(wh, *ptr)) {
        if(state == 1) {
	  state = 2;
	  *(ptr++) = 0U;
	  back = dk3str_c16_start(ptr, wh);
	} else {
	  ptr++;
	}
      } else {
        state = 1; ptr++;
      }
    }
  }
  return back;
}



dk3_c32_t *
dk3str_c32_next(dk3_c32_t *str, dk3_c32_t const *whsp)
{
  dk3_c32_t *back = NULL;
  dk3_c32_t *ptr = NULL;	/* Pointer into string. */
  dk3_c32_t const *wh = NULL;	/* Whitespaces. */
  int state = 0;		/* Current processing state. */
  

#line 3004 "dk3str.ctr"
  if(str) {
    ptr = str;
    wh = (whsp ? whsp : c32_def_whsp);
    state = 0;
    while((state < 2) && (*ptr)) {
      if(dk3str_c32_chr(wh, *ptr)) {	

#line 3010 "dk3str.ctr"
        if(state == 1) {
	  state = 2;
	  *(ptr++) = 0UL;
	  back = dk3str_c32_start(ptr, wh);
	} else {
	  ptr++;
	}
      } else {
        state = 1; ptr++;
      }
    }
  } 

#line 3022 "dk3str.ctr"
  return back;
}



dkChar *
dk3str_next(dkChar *str, dkChar const *whsp)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_next(str, whsp));
#else
  return(dk3str_c16_next(str, whsp));
#endif
#else
  return(dk3str_c8_next(str, whsp));
#endif
}



void
dk3str_c8_chomp(char *str, char const *whsp)
{
  char const *wh;	/* Whitespaces set to use. */
  char *ptr;		/* Pointer to traverse str. */
  char *x;		/* Start position of final space sequence. */
  

#line 3050 "dk3str.ctr"
  if(str) {
    wh = (whsp ? whsp : dk3str_c8_def_whsp);
    x = NULL; ptr = str;
    while(*ptr) {
      if(dk3str_c8_chr(wh, *ptr)) {
	if(!(x)) { x = ptr; }
      } else {
	x = NULL;
      }
      ptr++;
    }
    if(x) { *x = '\0'; }
  }
  

#line 3064 "dk3str.ctr"
}



void
dk3str_c16_chomp(dk3_c16_t *str, dk3_c16_t const *whsp)
{
  dk3_c16_t const *wh;	/* Whitespaces set. */
  dk3_c16_t *ptr;	/* Pointer into string. */
  dk3_c16_t *x;		/* Test pointer for whitespaces set. */

  if(str) {
    wh = (whsp ? whsp : c16_def_whsp);
    x = NULL; ptr = str;
    while(*ptr) {
      if(dk3str_c16_chr(wh, *ptr)) {
        if(!(x)) x = ptr;
      } else {
        x = NULL;
      }
      ptr++;
    }
    if(x) { *x = 0U; }
  }
}



void
dk3str_c32_chomp(dk3_c32_t *str, dk3_c32_t const *whsp)
{
  dk3_c32_t const *wh = NULL;	/* Whitespaces set. */
  dk3_c32_t *ptr = NULL;	/* Pointer into string. */
  dk3_c32_t *x = NULL;		/* For whitespace-set test. */

  if(str) {
    wh = (whsp ? whsp : c32_def_whsp);
    x = NULL; ptr = str;
    while(*ptr) {
      if(dk3str_c32_chr(wh, *ptr)) {
        if(!(x)) x = ptr;
      } else {
        x = NULL;
      }
      ptr++;
    }
    if(x) { *x = 0UL; }
  }
}



void
dk3str_chomp(dkChar *str, dkChar const *whsp)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  dk3str_c32_chomp(str, whsp);
#else
  dk3str_c16_chomp(str, whsp);
#endif
#else
  dk3str_c8_chomp(str, whsp);
#endif
}



void
dk3str_c8_delnl(char *str)
{
  char *ptr;
  if(str) {
    ptr = str;
    while(*ptr) {
      if(*ptr == 0x0D) {
        if(ptr[1] == 0x0A) {
	  *ptr = '\0';
	} else {
	  ptr++;
	}
      } else {
        if(*ptr == 0x0A) {
	  *ptr = '\0';
	} else {
	  ptr++;
	}
      }
    }
  }
}



void
dk3str_c16_delnl(dk3_c16_t *str)
{
  dk3_c16_t *ptr;
  if(str) {
    ptr = str;
    while(*ptr) {
      if(*ptr == 0x000DU) {
        if(ptr[1] == 0x000AU) {
	  *ptr = (dk3_c16_t)0U;
	} else {
	  ptr++;
	}
      } else {
        if(*ptr == 0x000AU) {
	  *ptr = (dk3_c16_t)0U;
	} else {
	  ptr++;
	}
      }
    }
  }
}



void
dk3str_c32_delnl(dk3_c32_t *str)
{
  dk3_c32_t	*ptr;
  if(str) {
    ptr = str;
    while(*ptr) {
      if(*ptr == 0x0000000DUL) {
        if(ptr[1] == 0x0000000AUL) {
	  *ptr = (dk3_c32_t)0UL;
	} else {
	  ptr++;
	}
      } else {
        if(*ptr == 0x0000000AUL) {
	  *ptr = (dk3_c32_t)0UL;
	} else {
	  ptr++;
	}
      }
    }
  }
}



void
dk3str_delnl(dkChar *str)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  dk3str_c32_delnl(str);
#else
  dk3str_c16_delnl(str);
#endif
#else
  dk3str_c8_delnl(str);
#endif
}



int
dk3str_c8_array_index(char const * const *a, char const *s, int c)
{
  int back = -1;		/* Function result. */
  int ci;			/* Current array index for test. */
  char const * const *ap;	/* Pointer to traverse array a. */
  if((a) && (s)) {
    ap = a; ci = 0;
    while((*ap) && (back == -1)) {
      if(c) {
        if(dk3str_c8_cmp(*ap, s) == 0) back = ci;
      } else {
        if(dk3str_c8_casecmp(*ap, s) == 0) back = ci;
      }
      if(back == -1) { ap++; ci++; }
    }
  }
  return back;
}



int
dk3str_c16_array_index(dk3_c16_t const * const *a, dk3_c16_t const *s, int c)
{
  int back = -1;
  int ci;			/* Current index. */
  dk3_c16_t const * const *ap;	/* Pointer into array. */
  if((a) && (s)) {
    ap = a; ci = 0;
    while((*ap) && (back == -1)) {
      if(c) {
        if(dk3str_c16_cmp(*ap, s) == 0) back = ci;
      } else {
        if(dk3str_c16_casecmp(*ap, s) == 0) back = ci;
      }
      if(back == -1) { ap++; ci++; }
    }
  }
  return back;
}



int
dk3str_c32_array_index(dk3_c32_t const * const *a, dk3_c32_t const *s, int c)
{
  int back = -1;
  int ci;			/* Current index. */
  dk3_c32_t const * const *ap;	/* Pointer into array. */

  if((a) && (s)) {
    ap = a; ci = 0;
    while((*ap) && (back == -1)) {
      if(c) {
        if(dk3str_c32_cmp(*ap, s) == 0) back = ci;
      } else {
        if(dk3str_c32_casecmp(*ap, s) == 0) back = ci;
      }
      if(back == -1) { ap++; ci++; }
    }
  }
  return back;
}



int
dk3str_array_index(dkChar const * const *a, dkChar const *s, int c)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_array_index(a, s, c));
#else
  return(dk3str_c16_array_index(a, s, c));
#endif
#else
  return(dk3str_c8_array_index(a, s, c));
#endif
}



int
dk3str_c8_is_abbr(char const *line,char const *pattern,char spec,int cs)
{
  int back = 0;			/* Function result. */
  char cl;			/* Current character from line. */
  char cp;			/* Current character from pattern. */
  char const *lptr = NULL;	/* Pointer to traverse line. */
  char const *pptr = NULL;	/* Pointer to traverse pattern. */
  int afterspec = 0;		/* Flag: cs was already found in the pattern. */
  int cc = 0;			/* Flag: Can continue. */
  

#line 3320 "dk3str.ctr"
  if((line) && (pattern)) {
    lptr = line; pptr = pattern; afterspec = 0; cc = 1;
    while(cc) {
      if(*pptr) {
        if((!afterspec) && (*pptr == spec)) {
	  afterspec = 1; pptr++;
	} else {
	  if(*lptr) {
	    cl = *lptr; cp = *pptr;
	    if(!cs) {
	      cl = dk3str_c8_toupper(cl);
	      cp = dk3str_c8_toupper(cp);
	    }
	    if(cl == cp) {
	      lptr++; pptr++;
	    } else {
	      cc = 0; back = 0;
	    }
	  } else {
	    cc = 0;
	    if(afterspec) back = 1;
	  }
	}
      } else {
        cc = 0;
	if(!(*lptr)) {
	  back = 1;
	}
      }
    }
  }
  

#line 3352 "dk3str.ctr"
  return back;
}



int
dk3str_c16_is_abbr(dk3_c16_t const *line, dk3_c16_t const *pattern, dk3_c16_t spec, int cs)
{
  int back = 0;
  dk3_c16_t cl;			/* Current character from line. */
  dk3_c16_t cp;			/* Current character from pattern. */
  dk3_c16_t const *lptr;	/* Input text to check. */
  dk3_c16_t const *pptr;	/* Pattern. */
  int afterspec;		/* Flag: Abbreviation inidicator found. */
  int cc;			/* Flag: Can continue. */

  if((line) && (pattern)) {
    lptr = line; pptr = pattern; afterspec = 0; cc = 1;
    while(cc) {
      if(*pptr) {
        if((!afterspec) && (*pptr == spec)) {
	  afterspec = 1; pptr++;
	} else {
	  if(*lptr) {
	    cl = *lptr; cp = *pptr;
	    if(!cs) {
	      cl = dk3str_c16_toupper(cl);
	      cp = dk3str_c16_toupper(cp);
	    }
	    if(cl == cp) {
	      lptr++; pptr++;
	    } else {
	      cc = 0; back = 0;
	    }
	  } else {
	    cc = 0;
	    if(afterspec) back = 1;
	  }
	}
      } else {
        cc = 0;
	if(!(*lptr)) {
	  back = 1;
	}
      }
    }
  }
  return back;
}



int
dk3str_c32_is_abbr(dk3_c32_t const *line, dk3_c32_t const *pattern, dk3_c32_t spec, int cs)
{
  int back = 0;
  dk3_c32_t cl = 0UL;		/* Text character. */
  dk3_c32_t cp = 0UL;		/* Pattern character. */
  dk3_c32_t const *lptr = NULL;	/* Pointer into text. */
  dk3_c32_t const *pptr = NULL;	/* Pointer into pattern. */
  int afterspec = 0;		/* Flag: Abbreviation indicator was found. */
  int cc = 0;			/* Flag: Can continue. */

  if((line) && (pattern)) {
    lptr = line; pptr = pattern; afterspec = 0; cc = 1;
    while(cc) {
      if(*pptr) {
        if((!afterspec) && (*pptr == spec)) {
	  afterspec = 1; pptr++;
	} else {
	  if(*lptr) {
	    cl = *lptr; cp = *pptr;
	    if(!cs) {
	      cl = dk3str_c32_toupper(cl);
	      cp = dk3str_c32_toupper(cp);
	    }
	    if(cl == cp) {
	      lptr++; pptr++;
	    } else {
	      cc = 0; back = 0;
	    }
	  } else {
	    cc = 0;
	    if(afterspec) back = 1;
	  }
	}
      } else {
        cc = 0;
	if(!(*lptr)) { back = 1; }
      }
    }
  }
  return back;
}



int
dk3str_is_abbr(dkChar const *line, dkChar const *pattern, dkChar spec, int cs)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_is_abbr(line, pattern, spec, cs));
#else
  return(dk3str_c16_is_abbr(line, pattern, spec, cs));
#endif
#else
  return(dk3str_c8_is_abbr(line, pattern, spec, cs));
#endif
}



int
dk3str_c8_array_abbr(char const * const *ar, char const *str, char sp, int cs)
{
  int back = -1;		/* Function result. */
  char const * const *ptr;	/* Pointer to traverse array ar. */
  int i;			/* Current index of ptr in ar. */
  

#line 3472 "dk3str.ctr"
  if((ar) && (str)) {
    i = 0; ptr = ar;
    while((*ptr) && (back == -1)) {
      

#line 3476 "dk3str.ctr"
      if(dk3str_c8_is_abbr(str, *ptr, sp, cs)) {
        back = i;
      }
      if(back == -1) {
	ptr++; i++;
      }
      

#line 3483 "dk3str.ctr"
    }
  } 

#line 3485 "dk3str.ctr"
  return back;
}



int
dk3str_c16_array_abbr(dk3_c16_t const * const *arr, dk3_c16_t const *str, dk3_c16_t sp, int cs)
{
  int back = -1;
  dk3_c16_t const * const *ptr;	/* Pointer into array. */
  int i;			/* Current index. */
  

#line 3497 "dk3str.ctr"
  if((arr) && (str)) {	

#line 3498 "dk3str.ctr"
    i = 0; ptr = arr;
    while((*ptr) && (back == -1)) {			

#line 3500 "dk3str.ctr"
#if DK3_CHAR_SIZE > 1
      

#line 3502 "dk3str.ctr"
#else
      

#line 3504 "dk3str.ctr"
#endif
      if(dk3str_c16_is_abbr(str, *ptr, sp, cs)) {	

#line 3506 "dk3str.ctr"
        back = i;
      } else {						

#line 3508 "dk3str.ctr"
      }
      if(back == -1) {
        ptr++; i++;
      }							

#line 3512 "dk3str.ctr"
    }				

#line 3513 "dk3str.ctr"
  } 

#line 3514 "dk3str.ctr"
  return back;
}



int
dk3str_c32_array_abbr(dk3_c32_t const * const *arr, dk3_c32_t const *str, dk3_c32_t sp, int cs)
{
  int back = -1;
  dk3_c32_t const * const *ptr = NULL;	/* Pointer into array. */
  int i = 0;				/* Current index. */

  if((arr) && (str)) {
    i = 0; ptr = arr;
    while((*ptr) && (back == -1)) {
      if(dk3str_c32_is_abbr(str, *ptr, sp, cs)) {
        back = i;
      }
      if(back == -1) {
        ptr++; i++;
      }
    }
  }
  return back;
}



int
dk3str_array_abbr(dkChar const * const *ar,dkChar const *str,dkChar sp,int cs)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_array_abbr(ar, str, sp, cs));
#else
  return(dk3str_c16_array_abbr(ar, str, sp, cs));
#endif
#else
  return(dk3str_c8_array_abbr(ar, str, sp, cs));
#endif
}



int
dk3str_c8_is_bool(char const *str)
{
  int back = 0;	/* Function result. */
  

#line 3563 "dk3str.ctr"
  if(str) {
    if(dk3str_c8_array_abbr(dk3str_c8_bool_kw,str,'$',0) >= 0) {
      back = 1;
    }
  } 

#line 3568 "dk3str.ctr"
  return back;
}



int
dk3str_c16_is_bool(dk3_c16_t const *str)
{
  int back = 0;
  char	mytest[256];	/* 8-bit version of the str text. */
  if(str) {
#if VERSION_BEFORE_20130928
    if(dk3str_c16_to_c8_simple(mytest, sizeof(mytest), str)) {
      back = dk3str_c8_is_bool(mytest);
    }
#else
    if(dk3str_cnv_c16_to_c8u_app(mytest, sizeof(mytest), str, NULL)) {
      back = dk3str_c8_is_bool(mytest);
    }
#endif
  }
  return back;
}



int
dk3str_c32_is_bool(dk3_c32_t const *str)
{
  int back = 0;
  char mytest[256];	/* 8-bit text copy of str. */
  if(str) {
#if VERSION_BEFORE_20130928
    if(dk3str_c32_to_c8_simple(mytest, sizeof(mytest), str)) {
      back = dk3str_c8_is_bool(mytest);
    }
#else
    if(dk3str_cnv_c32_to_c8u_app(mytest, sizeof(mytest), str, NULL)) {
      back = dk3str_c8_is_bool(mytest);
    }
#endif
  }
  return back;
}



int
dk3str_is_bool(dkChar const *str)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_is_bool(str));
#else
  return(dk3str_c16_is_bool(str));
#endif
#else
  return(dk3str_c8_is_bool(str));
#endif
}



int
dk3str_c8_is_on(char const *str)
{
  int back = 0;	/* Function result. */
  

#line 3636 "dk3str.ctr"
  if(str) {
    if(dk3str_c8_array_abbr(dk3str_c8_bool_kw,str,'$',0) >= INDEX_OF_FIRST_BOOLEAN_TRUE) {
      back = 1;
    }
  } 

#line 3641 "dk3str.ctr"
  return back;
}



int
dk3str_c16_is_on(dk3_c16_t const *str)
{
  int back = 0;
  char	mytest[256];	/* 8-bit version of the str text. */
  if(str) {
#if VERSION_BEFORE_20130928
    if(dk3str_c16_to_c8_simple(mytest, sizeof(mytest), str)) {
      back = dk3str_c8_is_on(mytest);
    }
#else
    if(dk3str_cnv_c16_to_c8u_app(mytest, sizeof(mytest), str, NULL)) {
      back = dk3str_c8_is_on(mytest);
    }
#endif
  }
  return back;
}



int
dk3str_c32_is_on(dk3_c32_t const *str)
{
  int back = 0;
  char mytest[256];	/* 8-bit copy of str text. */
  if(str) {
#if VERSION_BEFORE_20130928
    if(dk3str_c32_to_c8_simple(mytest, sizeof(mytest), str)) {
      back = dk3str_c8_is_on(mytest);
    }
#else
    if(dk3str_cnv_c32_to_c8u_app(mytest, sizeof(mytest), str, NULL)) {
      back = dk3str_c8_is_on(mytest);
    }
#endif
  }
  return back;
}



int
dk3str_is_on(dkChar const *str)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_is_on(str));
#else
  return(dk3str_c16_is_on(str));
#endif
#else
  return(dk3str_c8_is_on(str));
#endif
}



size_t
dk3str_c8_explode(char **array, size_t sz, char *str, char const *whsp)
{
  size_t	back = 0;	/* Function result. */
  char const	*wh = NULL;	/* White spaces set to use. */
  char		*current = NULL; /* Current text word to process. */
  char		*next = NULL;	/* Remaining text after processing the word. */
  char		**ptr = NULL;	/* Pointer to current array element. */
  size_t 	i = 0;		/* Number of remaining usable array elements. */
  if((array) && (sz > 1) && (str)) {
    wh = (whsp ? whsp : dk3str_c8_def_whsp);
    ptr = array; i = sz;
    while(i--) { *(ptr++) = NULL; }
    ptr = array; i = 0;
    current = dk3str_c8_start(str, wh);
    while((current) && (i < (sz - 1))) {
      next = dk3str_c8_next(current,wh);
      *(ptr++) = current; i++; back++;
      current = next;
    }
  }
  return back;
}



size_t
dk3str_c16_explode(dk3_c16_t **array, size_t sz, dk3_c16_t *str, dk3_c16_t const *whsp)
{
  size_t		back = 0;
  dk3_c16_t const	*wh = NULL;	/* Whitespaces set. */
  dk3_c16_t		*current = NULL;	/* Start of current word. */
  dk3_c16_t		*next = NULL;	/* Start of next word after current. */
  dk3_c16_t		**ptr = NULL;	/* Pointer into array. */
  size_t		i = 0;		/* Number of words found. */

  if((array) && (sz > 1) && (str)) {
    wh = (whsp ? whsp : c16_def_whsp);
    ptr = array; i = sz;
    while(i--) { *(ptr++) = NULL; }
    ptr = array; i = 0;
    current = dk3str_c16_start(str, wh);
    while((current) && (i < (sz - 1))) {
      next = dk3str_c16_next(current, wh);
      *(ptr++) = current; i++; back++;
      current = next;
    }
  }
  return back;
}



size_t
dk3str_c32_explode(dk3_c32_t **array, size_t sz, dk3_c32_t *str, dk3_c32_t const *whsp)
{
  size_t		back = 0;
  dk3_c32_t const	*wh = NULL;	/* Whitespace set. */
  dk3_c32_t		*current = NULL;	/* Current word. */
  dk3_c32_t		*next = NULL;	/* Next word. */
  dk3_c32_t		**ptr = NULL;	/* Pointer into destination array. */
  size_t		i = 0;		/* Current index. */
  if((array) && (sz > 1) && (str)) {
    wh = (whsp ? whsp : c32_def_whsp);
    ptr = array; i = sz;
    while(i--) { *(ptr++) = NULL; }
    ptr = array; i = 0;
    current = dk3str_c32_start(str, wh);
    while((current) && (i < (sz - 1))) {
      next = dk3str_c32_next(current, wh);
      *(ptr++) = current; i++; back++;
      current = next;
    }
  }
  return back;
}



size_t
dk3str_explode(dkChar **array, size_t sz, dkChar *str, dkChar const *whsp)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_explode(array, sz, str, whsp));
#else
  return(dk3str_c16_explode(array, sz, str, whsp));
#endif
#else
  return(dk3str_c8_explode(array, sz, str, whsp));
#endif
}



void
dk3str_c8_normalize(char *l, char const *w, char s)
{
  char		*parts[256];	/* All the text words. */
  char		*dp = NULL;	/* Destination pointer. */
  char		*sp = NULL;	/* Source pointer. */
  size_t	np = 0;		/* Number of parts used. */
  size_t	i = 0;		/* Current word to process. */
  if(l) {
    np = dk3str_c8_explode(parts, 255, l, w);
    if(np > 0) {
      dp = l;
      for(i = 0; i < np; i++) {
        sp = parts[i];
	if(i) { *(dp++) = s; }
	while(*sp) { *(dp++) = *(sp++); }
      }
      *dp = '\0';
    }
  }
}



void
dk3str_c16_normalize(dk3_c16_t *l, dk3_c16_t const *w, char s)
{
  dk3_c16_t		*parts[256];	/* Pointers to the words. */
  dk3_c16_t		*dp = NULL;	/* Destination pointer. */
  dk3_c16_t		*sp = NULL;	/* Source pointer. */
  size_t		np = 0;		/* Number of parts. */
  size_t		i = 0;		/* Index of current part. */

  if(l) {
    np = dk3str_c16_explode(parts, 255, l, w);
    if(np > 0) {
      dp = l;
      for(i = 0; i < np; i++) {
        sp = parts[i];
	if(i) { *(dp++) = s; }
	while(*sp) { *(sp++) = *(dp++); }
      }
      *dp = 0U;
    }
  }
}



void
dk3str_c32_normalize(dk3_c32_t *l, dk3_c32_t const *w, char s)
{
  dk3_c32_t	*parts[256];	/* Words. */
  dk3_c32_t	*dp = NULL;	/* Destination pointer. */
  dk3_c32_t	*sp = NULL;	/* Source pointer. */
  size_t	np = 0;	/* Number of words. */
  size_t	i = 0;		/* Index of current word. */
  if(l) {
    np = dk3str_c32_explode(parts, 255, l, w);
    if(np > 0) {
      dp = l;
      for(i = 0; i < np; i++) {
        sp = parts[i];
	if(i) { *(dp++) = s; }
	while(*sp) { *(dp++) = *(sp++); }
      }
      *dp = 0UL;
    }
  }
}



void
dk3str_normalize(dkChar *l, dkChar const *w, dkChar s)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  dk3str_c32_normalize(l, w, s);
#else
  dk3str_c16_normalize(l, w, s);
#endif
#else
  dk3str_c8_normalize(l, w, s);
#endif
}



void
dk3str_c8_correct_filename(char *n)
{
  register char *p;
  p = n;
  while(*p) { if(*p == NO_FNS_C8) { *p = FNS_C8; } p++; }
}



void
dk3str_c16_correct_filename(dk3_c16_t *n)
{
  register dk3_c16_t *p;
  p = n;
  while(*p) { if(*p == NO_FNS_C16) { *p = FNS_C16; } p++;}
}



void
dk3str_c32_correct_filename(dk3_c32_t *n)
{
  register dk3_c32_t *p;	/* Pointer into text. */
  p = n;
  while(*p) { if(*p == NO_FNS_C32) { *p = FNS_C32; } p++;}
} 



void
dk3str_correct_filename(dkChar *n)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  dk3str_c32_correct_filename(n);
#else
  dk3str_c16_correct_filename(n);
#endif
#else
  dk3str_c8_correct_filename(n);
#endif
}



int
dk3str_c8_is_abs_path(char const *n)
{
  int back = 0;
  if(n) {
    if(*n == FNS_C8) {
      back = 1;
    } else {
#if DK3_ON_WINDOWS
      if(((*n >= 'A') && (*n <= 'Z')) || ((*n >= 'a') && (*n <= 'z'))) {
        if(n[1] == ':') {
	  if(n[2] == FNS_C8) {
	    back = 1;
	  }
	}
      }
#endif
    }
  }
  return back;
}



int
dk3str_c16_is_abs_path(dk3_c16_t const *n)
{
  int back = 0;
  if(n) {
    if(*n == FNS_C16) {
      back = 1;
    } else {
#if DK3_ON_WINDOWS
      if(((*n >= 0x0061U) && (*n <= 0x007AU))
         || ((*n >= 0x0041U) && (*n <= 0x005AU)))
      {
        if(n[1] == 0x003AU) {
	  if(n[2] == FNS_C16) {
	    back = 1;
	  }
	}
      }
#endif
    }
  }
  return back;
}



int
dk3str_c32_is_abs_path(dk3_c32_t const *n)
{
  int back = 0;
  

#line 3989 "dk3str.ctr"
  if(n) {
    if(*n == FNS_C32) {
      back = 1;
    } else {
#if DK3_ON_WINDOWS
      if(((*n >= 0x00000061UL) && (*n <= 0x0000007AUL))
        || ((*n >= 0x00000041UL) && (*n <= 0x0000005AUL)))
      {
        if(n[1] == 0x0000003AUL) {
	  if(n[2] == FNS_C32) {
	    back = 1;
	  }
	}
      }
#endif
    }
  } 

#line 4006 "dk3str.ctr"
  return back;
}



int
dk3str_is_abs_path(dkChar const *n)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_is_abs_path(n));
#else
  return(dk3str_c16_is_abs_path(n));
#endif
#else
  return(dk3str_c8_is_abs_path(n));
#endif
}



int
dk3str_c8_append_path_app(char *d, size_t sz, char const *n, dk3_app_t *app)
{
  int		 back = 0;		/* Function result. */
  char		 myn[DK3_MAX_PATH];	/* My editable copy of n. */
  char 		*p1 = NULL;		/* Current name part. */
  char 		*p2 = NULL;		/* Remaining text. */
  char		*p3 = NULL;		/* Used to delete one part from path. */
  size_t	 tsz;			/* Size for tests. */
  if((d) && (sz) && (n)) {
    if(dk3str_c8_is_abs_path(n)) {	/* Absolute path, copy. */
      if(dk3str_c8_len(n) < sz) {
        dk3str_c8_cpy(d,n);
	back = 1;
      } else {
        if(app) {
	  /* ERROR: Name n too long! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 109);
	}
      }
    } else {				/* Relative path, append. */
      if(dk3str_c8_len(n) < sizeof(myn)) {
        back = 1;
        dk3str_c8_cpy(myn,n);
	p1 = myn;
	while((p1) && (back)) {
	  p2 = dk3str_c8_chr(p1,FNS_C8);
	  if(p2) { *(p2++) = '\0'; }
	  if(dk3str_c8_cmp(dk3str_c8_dot,p1)) {
	    if(dk3str_c8_cmp(dk3str_c8_dot_dot,p1)) {	/* Add another part. */
	      tsz =	dk3str_c8_len(d) + dk3str_c8_len(dk3str_c8_fnsep)
	      		+ dk3str_c8_len(p1);
	      if(tsz < sz) {
	        dk3str_c8_cat(d,dk3str_c8_fnsep);
		dk3str_c8_cat(d,p1);
	      } else {
	        if(app) {
		  /* ERROR: Result too long for destination buffer! */
		  dk3app_log_i1(app, DK3_LL_ERROR, 38);
		}
	      }
	    } else {			/* Remove last part. */
	      p3 = dk3str_c8_rchr(d,FNS_C8);
	      if(p3) {
	        *p3 = '\0';
	      } else {
	        if(app) {
		  /* ERROR: Too many ".." entries! */
#if DK3_CHAR_SIZE == 1
		  dk3app_log_i3(app, DK3_LL_ERROR, 110, 111, n);
#else
		  dk3app_log_i1(app, DK3_LL_ERROR, 126);
#endif
		}
	      }
	    }
	  }
	  p1 = p2;
	}
      } else {
        if(app) {
	  /* ERROR: Name n too long! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 109);
	}
      }
    }
  }
  return back;
}



int
dk3str_c16_append_path_app(dk3_c16_t *d, size_t sz, dk3_c16_t const *n, dk3_app_t *app)
{
  int back = 0;
  dk3_c16_t	myn[DK3_MAX_PATH];
  dk3_c16_t	*p1 = NULL;		/* Path component to process. */
  dk3_c16_t	*p2 = NULL;		/* Remainder of path. */
  dk3_c16_t	*p3 = NULL;		/* Last path component to remove. */
  size_t	 tsz;			/* Test size. */

  if((d) && (sz) && (n)) {
    if(dk3str_c16_is_abs_path(n)) {
      if(dk3str_c16_len(n) < sz) {
        dk3str_c16_cpy(d,n) ;
	back = 1;
      } else {
        if(app) {
	  /* ERROR: Name n too long! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 109);
	}
      }
    } else {
      if(dk3str_c16_len(n) < DK3_SIZEOF(myn,dk3_c16_t)) {
        back = 1;
	dk3str_c16_cpy(myn,n) ;
	p1 = myn;
	while((p1) && (back)) {
	  p2 = dk3str_c16_chr(p1, FNS_C16);
	  if(p2) { *(p2++) = 0U; }
	  if(dk3str_c16_cmp(c16_dot,p1)) {
	    if(dk3str_c16_cmp(c16_dot_dot,p1)) {
	      tsz =	dk3str_c16_len(d) + dk3str_c16_len(c16_fnsep)
	      		+ dk3str_c16_len(p1);
	      if(tsz < sz) {
	        dk3str_c16_cat(d,c16_fnsep);
		dk3str_c16_cat(d,p1);
	      } else {
	        if(app) {
		  /* ERROR: Result too long for destination buffer! */
		  dk3app_log_i1(app, DK3_LL_ERROR, 38);
		}
	      }
	    } else {
	      p3 = dk3str_c16_rchr(d,FNS_C16);
	      if(p3) {
	        *p3 = 0U;
	      } else {
	        if(app) {
		  /* ERROR: Too many ".." entries! */
#if DK3_CHAR_SIZE == 2
		  dk3app_log_i3(app, DK3_LL_ERROR, 110, 111, n);
#else
		  dk3app_log_i1(app, DK3_LL_ERROR, 126);
#endif
		}
	      }
	    }
	  }
	  p1 = p2;
	}
      } else {
        if(app) {
	  /* ERROR: Name n too long! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 109);
	}
      }
    }
  }
  return back;
}



int
dk3str_c32_append_path_app(dk3_c32_t *d, size_t sz, dk3_c32_t const *n, dk3_app_t *app)
{
  int back = 0;
  dk3_c32_t	myn[DK3_MAX_PATH];	/* My editable copy of n. */
  dk3_c32_t	*p1 = NULL;		/* Current name part. */
  dk3_c32_t	*p2 = NULL;		/* Remaining text. */
  dk3_c32_t	*p3 = NULL;		/* Used to delete one part from path. */
  size_t	 tsz;			/* Test size. */

  

#line 4183 "dk3str.ctr"
  if((d) && (sz) && (n)) {
    if(dk3str_c32_is_abs_path(n)) {	

#line 4185 "dk3str.ctr"
      if(dk3str_c32_len(n) < sz) {
        dk3str_c32_cpy(d,n) ;
	back = 1;
      } else {
        if(app) {
	  /* ERROR: Name n too long! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 109);
	}
      }
    } else {				

#line 4195 "dk3str.ctr"
      if(dk3str_c32_len(n) < DK3_SIZEOF(myn,dk3_c32_t)) {
        back = 1;
	dk3str_c32_cpy(myn,n) ;
	p1 = myn;
	while((p1) && (back)) {
	  p2 = dk3str_c32_chr(p1,FNS_C32);
	  if(p2) { *(p2++) = 0UL; }
	  if(dk3str_c32_cmp(c32_dot,p1)) {
	    if(dk3str_c32_cmp(c32_dot_dot,p1)) {
	      tsz =	dk3str_c32_len(d) + dk3str_c32_len(c32_fnsep)
	      		+ dk3str_c32_len(p1);
	      if(tsz < sz) {
	        dk3str_c32_cat(d,c32_fnsep);
		dk3str_c32_cat(d,p1);
	      } else {
	        if(app) {
		  /* ERROR: Result too long for destination buffer! */
		  dk3app_log_i1(app, DK3_LL_ERROR, 38);
		}
	      }
	    } else {
	      p3 = dk3str_c32_rchr(d,FNS_C32);
	      if(p3) {
	        *p3 = 0UL;
	      } else {
	        if(app) {
		  /* ERROR: Too many ".." entries! */
		  dk3app_log_i1(app, DK3_LL_ERROR, 110);
		}
	      }
	    }
	  }
	  p1 = p2;
	}
      } else {
        if(app) {
	  /* ERROR: Name n too long! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 109);
	}
      }
    }
  }
  if(back) {	

#line 4238 "dk3str.ctr"
  } 

#line 4239 "dk3str.ctr"
  return back;
}



int
dk3str_append_path_app(dkChar *d, size_t sz, dkChar const *n, dk3_app_t *app)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_append_path_app(d, sz, n, app));
#else
  return(dk3str_c16_append_path_app(d, sz, n, app));
#endif
#else
  return(dk3str_c8_append_path_app(d, sz, n, app));
#endif
}



char *
dk3str_c8_get_suffix(char const *s)
{
  char *back = NULL;
  char const *ptr;
  if(s) {
    ptr = s;
    while(*ptr) {
      if(*ptr == '.') {
        back = (char *)ptr;
      } else {
	if(*ptr == FNS_C8) {
	  back = NULL;
	}
      }
      ptr++;
    }
  }
  return back;
}



dk3_c16_t *
dk3str_c16_get_suffix(dk3_c16_t const *s)
{
  dk3_c16_t *back = NULL;
  dk3_c16_t const *ptr;

  if(s) {
    ptr = s;
    while(*ptr) {
      if(*ptr == 0x002EU) {
        back = (dk3_c16_t *)ptr;
      } else {
        if(*ptr == FNS_C16) {
	  back = NULL;
	}
      }
      ptr++;
    }
  }
  return back;
}



dk3_c32_t *
dk3str_c32_get_suffix(dk3_c32_t const *s)
{
  dk3_c32_t *back = NULL;
  dk3_c32_t const *ptr;
  if(s) {
    ptr = s;
    while(*ptr) {
      if(*ptr == 0x0000002EUL) {
        back = (dk3_c32_t *)ptr;
      } else {
        if(*ptr == FNS_C32) {
	  back = NULL;
	}
      }
      ptr++;
    }
  }
  return back;
}



dkChar *
dk3str_get_suffix(dkChar const *s)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  return(dk3str_c32_get_suffix(s));
#else
  return(dk3str_c16_get_suffix(s));
#endif
#else
  return(dk3str_c8_get_suffix(s));
#endif
}



int
dk3str_c32_to_c8_simple_app(char *d, size_t sz, dk3_c32_t const *s, dk3_app_t *app)
{
  int back = 0;
  dk3_c32_t const *ptr = NULL;	/* Pointer into source string. */
  dk3_c32_t c = 0UL;		/* Source character. */
  unsigned char uc = 0x00;	/* Destination character. */
  char *dptr = NULL;		/* Destination pointer. */

  if((d) && (sz) && (s)) {
    if(dk3str_c32_len(s) < sz) {
      back = 1; ptr = s; dptr = d;
      while(0UL != (c = *ptr)) {
        if(c < (dk3_c32_t)0x00000100UL) {
	  uc = (unsigned char)c;
	  *(dptr++) = (char)uc;
	} else {
	  if((back == 1) && (app)) {
	    /* ERROR: Illegal character(s) in source string! */
	    dk3app_log_i1(app, DK3_LL_ERROR, 112);
	  }
	  back = 0;
	}
	ptr++;
      }
      *dptr = '\0';
    } else {
      d[0] = '\0';
      if(app) {
        /* ERROR: Source string too long! */
	dk3app_log_i1(app, DK3_LL_ERROR, 108);
      }
    }
  }
  return back;
}







/**	Convert 8-bit plain text to other encodings.
	@param	d	Destination buffer (NULL to just count result elements).
	@param	s	Source string.
	@param	app	Application structure for diagnostics, may be NULL.
	@param	enc	Destination encoding (DK3_ENCODING_xxx).
	@return	Number of destination elements created.
*/
static
size_t
dk3str_i_cnv_c8p(void *d, char const *s, dk3_app_t *app, int enc)
{
  size_t	back = 0;
  int		error = 0;	/* Flag: Error occured. */
  char const	*sptr = NULL;	/* Source pointer. */
  char 		*dp8 = NULL;	/* Pointer to 8-bit destination. */
  dk3_c16_t	*dp16 = NULL;	/* Pointer to 16-bit destination. */
  dk3_c32_t	*dp32 = NULL;	/* Pointer to 32-bit destination. */
  char		c = 0x00;	/* Current source character to process. */
  unsigned char	uc = 0x00;	/* Destination byte. */
  dk3_c32_t	ul = 0UL;	/* Conversion result. */
  unsigned char	myuc[16];	/* Conversion result buffer. */
  dk3_c16_t	myc16[16];	/* Conversion result buffer. */
  size_t	u8u = 0;	/* UTF-8 bytes used for encoding. */
  size_t	u16u = 0;	/* UTF-16 characters used for encoding. */
  size_t	sl = 0;		/* Number of remaining characters in source. */
  size_t	i = 0;		/* Copy converted characters to destination. */
  

#line 4416 "dk3str.ctr"
  if(s) {
    sptr = s; sl = dk3str_c8_len(s);
    if(d) {
      switch(enc) {
        case DK3_ENCODING_UTF8: { dp8 = (char *)d; } break;
	case DK3_ENCODING_UTF16: { dp16 = (dk3_c16_t *)d; } break;
	case DK3_ENCODING_UNICODE: { dp32 = (dk3_c32_t *)d; } break;
	default: {
	  if(app) {
	    /* ERROR: Illegal destination encoding! */
	    dk3app_log_i1(app, DK3_LL_ERROR, 114);
	  }
	} break;
      }
    }
    while((sl) && (0 == error)) {
      c = *(sptr++); sl--;
      uc = (unsigned char)c;
      ul = (dk3_c32_t)uc;
      ul &= 0x000000FFUL;
      switch(enc) {
        case DK3_ENCODING_UTF8: {
	  u8u = dk3enc_uc2utf8(ul, myuc, 16);
	  if(u8u) {
	    back = dk3mem_add_size_t(back, u8u, &error);
	    if(d) {
	      for(i = 0; i < u8u; i++) { *(dp8++) = myuc[i]; }
	    }
	  } else {
	    if(0 == error) {
	      if(app) {
	        /* ERROR: Conversion to UTF-8 failed! */
		dk3app_log_i1(app, DK3_LL_ERROR, 115);
	      }
	    } error = 1;
	  }
	} break;
	case DK3_ENCODING_UTF16: {
	  u16u = dk3enc_uc2utf16(ul, myc16, 16);
	  if(u16u) {
	    back = dk3mem_add_size_t(back, u16u, &error);
	    if(d) {
	      for(i = 0; i < u16u; i++) { *(dp16++) = myc16[i]; }
	    }
	  } else {
	    if(0 == error) {
	      if(app) {		

#line 4463 "dk3str.ctr"
	        /* ERROR: Conversion to UTF-16 failed! */
		dk3app_log_i1(app, DK3_LL_ERROR, 116);
	      }
	    } error = 1;
	  }
	} break;
	case DK3_ENCODING_UNICODE: {
	  back = dk3mem_add_size_t(back, 1, &error);
	  if(d) { *(dp32++) = ul; }
	} break;
      }
    }
    if(d) {
      switch(enc) {
        case DK3_ENCODING_UTF8: { *dp8 = '\0'; } break;
	case DK3_ENCODING_UTF16: { *dp16 = 0U; } break;
	case DK3_ENCODING_UNICODE: { *dp32 = 0UL; } break;
      }
    }
    back = dk3mem_add_size_t(back, 1, &error);
    if(error) {
      back = 0;
      if(error == DK3_ERROR_MATH_OVERFLOW) {
        if(app) {
	  /* ERROR: Input string too long for conversion! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 108);
	}
      }
    }
  } 

#line 4493 "dk3str.ctr"
  return back;
}




size_t
dk3str_cnvsz_c8p_to_c8u_app(char const *s, dk3_app_t *app)
{
  size_t back = 0;
  if(s) {
    back = dk3str_i_cnv_c8p(NULL, s, app, DK3_ENCODING_UTF8);
  }
  return back;
}


int
dk3str_cnv_c8p_to_c8u_app(char *d, size_t ds, char const *s, dk3_app_t *app)
{
  int		back = 0;
  size_t	sz;		/* Number of chars produced. */
  if((d) && (ds) && (s)) {
    sz = dk3str_i_cnv_c8p(NULL, s, app, DK3_ENCODING_UTF8);
    if(sz) {
      if(ds >= sz) {
        if(dk3str_i_cnv_c8p((void *)d, s, app, DK3_ENCODING_UTF8)) {
	  back = 1;
	}
      } else {
        if(app) {
	  /* ERROR: Destination buffer too small! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 38);
	}
      }
    }
  }
  return back;
}



char *
dk3str_cnvnew_c8p_to_c8u_app(char const *s, dk3_app_t *app)
{
  char		*back = NULL;
  size_t	sz;		/* Number of characters produced. */
  if(s) {
    sz = dk3str_i_cnv_c8p(NULL, s, app, DK3_ENCODING_UTF8);
    if(sz) {
      back = dk3_new_app(char,sz,app);
      if(back) {
        if(!dk3str_i_cnv_c8p((void *)back, s, app, DK3_ENCODING_UTF8)) {
	  dk3_delete(back); back = NULL;
	}
      }
    }
  }
  return back;
}



size_t
dk3str_cnvsz_c8p_to_c16_app(char const *s, dk3_app_t *app)
{
  size_t back = 0;
  if(s) {
    back = dk3str_i_cnv_c8p(NULL, s, app, DK3_ENCODING_UTF16);
  }
  return back;
}



int
dk3str_cnv_c8p_to_c16_app(dk3_c16_t *d, size_t ds, char const *s, dk3_app_t *app)
{
  int		back = 0;
  size_t	sz;		/* Destination buffer length needed. */
  if((d) && (ds) && (s)) {
    sz = dk3str_i_cnv_c8p(NULL, s, app, DK3_ENCODING_UTF16);
    if(sz) {
      if(ds >= sz) {
        if(dk3str_i_cnv_c8p((void *)d, s, app, DK3_ENCODING_UTF16)) {
	  back = 1;
	}
      } else {
        if(app) {
	  /* ERROR: Destination buffer too small! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 38);
	}
      }
    }
  }
  return back;
}



dk3_c16_t *
dk3str_cnvnew_c8p_to_c16_app(char const *s, dk3_app_t *app)
{
  dk3_c16_t	*back = NULL;
  size_t	sz;		/* Destination buffer length needed. */
  if(s) {
    sz = dk3str_i_cnv_c8p(NULL, s, app, DK3_ENCODING_UTF16);
    if(sz) {
      back = dk3_new_app(dk3_c16_t,sz,app);
      if(back) {
        if(!dk3str_i_cnv_c8p((void *)back, s, app, DK3_ENCODING_UTF16)) {
	  dk3_delete(back); back = NULL;
	}
      }
    }
  }
  return back;
}



size_t
dk3str_cnvsz_c8p_to_c32_app(char const *s, dk3_app_t *app)
{
  size_t back = 0;
  if(s) {
    back = dk3str_i_cnv_c8p(NULL, s, app, DK3_ENCODING_UNICODE);
  }
  return back;
}



int
dk3str_cnv_c8p_to_c32_app(dk3_c32_t *d, size_t ds, char const *s, dk3_app_t *app)
{
  int		back = 0;
  size_t	sz;		/* Destination buffer length needed. */
  if((d) && (ds) && (s)) {
    sz = dk3str_i_cnv_c8p(NULL, s, app, DK3_ENCODING_UNICODE);
    if(sz) {
      if(ds >= sz) {
        if(dk3str_i_cnv_c8p((void *)d, s, app, DK3_ENCODING_UNICODE)) {
	  back = 1;
	}
      } else {
        if(app) {
	  /* ERROR: Destination buffer too small! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 38);
	}
      }
    }
  }
  return back;
}



dk3_c32_t *
dk3str_cnvnew_c8p_to_c32_app(char const *s, dk3_app_t *app)
{
  dk3_c32_t	*back = NULL;
  size_t	sz;		/* Destination buffer length needed. */
  if(s) {
    sz = dk3str_i_cnv_c8p(NULL, s, app, DK3_ENCODING_UNICODE);
    if(sz) {
      back = dk3_new_app(dk3_c32_t,sz,app);
      if(back) {
        if(!dk3str_i_cnv_c8p((void *)back, s, app, DK3_ENCODING_UNICODE)) {
	  dk3_delete(back); back = NULL;
	}
      }
    }
  }
  return back;
}



/**	Convert UTF-8 string to other encodings.
	@param	d	Destination pointer, may be NULL.
	@param	s	Source string.
	@param	app	Application structure for diagnostics, may be NULL.
	@param	enc	Destination encoding.
	@return	Buffer length used (d!=NULL) or needed (d==NULL).
*/
static
size_t
dk3str_i_cnv_c8u(void *d, char const *s, dk3_app_t *app, int enc)
{
  size_t		back = 0;
  int			error = 0;	/* Flag: Error occued. */
  char			*dp8 = NULL;	/* Pointer to 8-bit destination. */
  dk3_c16_t		*dp16 = NULL;	/* Pointer to 16-bit destination. */
  dk3_c32_t		*dp32 = NULL;	/* Pointer to 32-bit destination. */
  dk3_c16_t		myc16[16];	/* Conversion result buffer. */
  dk3_c32_t		c32 = 0UL;	/* Conversion result. */
  unsigned char		uc = 0x00;	/* Result character. */
  char			c = 0x00;	/* Current character to process. */
  unsigned char const	*sptr = NULL;	/* Source ponter. */
  size_t		u8u = 0;	/* Number of UTF-8 bytes used. */
  size_t		u16u = 0;	/* Number of UTF-16 chars produced. */
  size_t		i = 0;		/* Copy buffer to destination. */
  size_t		sl = 0;		/* Remaining source string length. */
  

#line 4698 "dk3str.ctr"
  if(s) {
    /* Initialize variables */
    sptr = (unsigned char const *)s; sl = dk3str_c8_len(s);
    if(d) {
      switch(enc) {
        case DK3_ENCODING_PLAIN: { dp8 = (char *)d; } break;
	case DK3_ENCODING_UTF16: { dp16 = (dk3_c16_t *)d; } break;
	case DK3_ENCODING_UNICODE: { dp32 = (dk3_c32_t *)d; } break;
	default: {
	  if(0 == error) {
	    if(app) {
	      /* ERROR: Illegal output encoding! */
	      dk3app_log_i1(app, DK3_LL_ERROR, 114);
	    }
	  } error = 1;
	} break;
      }
    }
    /* Process input */
    while((sl) && (0 == error)) {
      u8u = 0;
      if(dk3enc_utf82uc(&c32, sptr, sl, &u8u)) {
        if(u8u) {
	  switch(enc) {
            case DK3_ENCODING_PLAIN: {
	      if(c32 < (dk3_c32_t)0x00000100UL) {
		back = dk3mem_add_size_t(back, 1, &error);
		if(d) {
	          uc = (unsigned char)c32;
		  c = (char)uc;
		  *(dp8++) = c;
		}
	      } else {
	        if(0 == error) {
		  if(app) {
		    /* ERROR: Result character out of range! */
		    dk3app_log_i1(app, DK3_LL_ERROR, 117);
		  }
		} error = 1;
	      }
	    } break;
	    case DK3_ENCODING_UTF16: {
	      u16u = dk3enc_uc2utf16(c32, myc16, 16);
	      if(u16u) {
		back = dk3mem_add_size_t(back, u16u, &error);
		if(d) {
		  for(i = 0; i < u16u; i++) { *(dp16++) = myc16[i]; }
		}
	      } else {
	        if(0 == error) {
		  if(app) {		

#line 4749 "dk3str.ctr"
		    /* ERROR: Conversion to UTF-16 failed! */
		    dk3app_log_i1(app, DK3_LL_ERROR, 116);
		  }
		} error = 1;
	      }
	    } break;
	    case DK3_ENCODING_UNICODE: {
	      back = dk3mem_add_size_t(back, 1, &error);
	      if(d) { *(dp32++) = c32; }
	    } break;
	  }
	  if(sl >= u8u) {
	    sl = sl - u8u;
	    sptr = &(sptr[u8u]);
	  } else {
	    sl = 0;
	  }
	} else {
	  if(0 == error) {
	    if(app) {
	      /* ERROR: UTF-8 decode operation failed! */
	      dk3app_log_i1(app, DK3_LL_ERROR, 118);
	    }
	  } error = 1;
	}
      } else {
        if(0 == error) {
	  if(app) {
	    /* ERROR: UTF-8 decode operation failed! */
	    dk3app_log_i1(app, DK3_LL_ERROR, 118);
	  }
	} error = 1;
      }
    }
    /* Finalize output */
    back = dk3mem_add_size_t(back, 1, &error);
    if(d) {
      switch(enc) {
        case DK3_ENCODING_PLAIN: { *dp8 = '\0'; } break;
	case DK3_ENCODING_UTF16: { *dp16 = 0U; } break;
	case DK3_ENCODING_UNICODE: { *dp32 = 0UL; } break;
      }
    }
    if(error) {
      back = 0;
      if(error == DK3_ERROR_MATH_OVERFLOW) {
        if(app) {
	  /* ERROR: Input string too long for conversion! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 108);
	}
      }
    }
  } 

#line 4802 "dk3str.ctr"
  return back;
}



size_t
dk3str_cnvsz_c8u_to_c8p_app(char const *s, dk3_app_t *app)
{
  size_t back = 0;
  if(s) {
    back = dk3str_i_cnv_c8u(NULL, s, app, DK3_ENCODING_PLAIN);
  }
  return back;
}



int
dk3str_cnv_c8u_to_c8p_app(char *d, size_t ds, char const *s, dk3_app_t *app)
{
  int		back = 0;
  size_t	sz;		/* Destination buffer length needed. */
  if((d) && (ds) && (s)) {
    sz = dk3str_i_cnv_c8u(NULL, s, app, DK3_ENCODING_PLAIN);
    if(sz) {
      if(ds >= sz) {
        if(dk3str_i_cnv_c8u((void *)d, s, app, DK3_ENCODING_PLAIN)) {
	  back = 1;
	}
      } else {
        if(app) {
	  /* ERROR: Destination buffer too small! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 38);
	}
      }
    }
  }
  return back;
}


char *
dk3str_cnvnew_c8u_to_c8p_app(char const *s, dk3_app_t *app)
{
  char		*back = NULL;
  size_t	sz;		/* Destination buffer length needed. */
  if(s) {
    sz = dk3str_i_cnv_c8u(NULL, s, app, DK3_ENCODING_PLAIN);
    if(sz) {
      back = dk3_new_app(char,sz,app);
      if(back) {
        if(!dk3str_i_cnv_c8u((void *)back, s, app, DK3_ENCODING_PLAIN)) {
	  dk3_delete(back); back = NULL;
	}
      }
    }
  }
  return back;
}




size_t
dk3str_cnvsz_c8u_to_c16_app(char const *s, dk3_app_t *app)
{
  size_t back = 0;
  if(s) {
    back = dk3str_i_cnv_c8u(NULL, s, app, DK3_ENCODING_UTF16);
  }
  return back;
}



int
dk3str_cnv_c8u_to_c16_app(dk3_c16_t *d, size_t ds, char const *s, dk3_app_t *app)
{
  int		back = 0;
  size_t	sz;		/* Destination buffer length needed. */
  if((d) && (ds) && (s)) {
    sz = dk3str_i_cnv_c8u(NULL, s, app, DK3_ENCODING_UTF16);
    if(sz) {
      if(ds >= sz) {
        if(dk3str_i_cnv_c8u((void *)d, s, app, DK3_ENCODING_UTF16)) {
	  back = 1;
	}
      } else {
        if(app) {
	  /* ERROR: Destination buffer too small! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 38);
	}
      }
    }
  }
  return back;
}



dk3_c16_t *
dk3str_cnvnew_c8u_to_c16_app(char const *s, dk3_app_t *app)
{
  dk3_c16_t	*back = NULL;
  size_t	sz;		/* Destination buffer length needed. */
  if(s) {
    sz = dk3str_i_cnv_c8u(NULL, s, app, DK3_ENCODING_UTF16);
    if(sz) {
      back = dk3_new_app(dk3_c16_t,sz,app);
      if(back) {
        if(!dk3str_i_cnv_c8u((void *)back, s, app, DK3_ENCODING_UTF16)) {
	  dk3_delete(back); back = NULL;
	}
      }
    }
  }
  return back;
}



size_t
dk3str_cnvsz_c8u_to_c32_app(char const *s, dk3_app_t *app)
{
  size_t back = 0;
  

#line 4928 "dk3str.ctr"
  if(s) {
    back = dk3str_i_cnv_c8u(NULL, s, app, DK3_ENCODING_UNICODE);
  } 

#line 4931 "dk3str.ctr"
  return back;
}



int
dk3str_cnv_c8u_to_c32_app(dk3_c32_t *d, size_t ds, char const *s, dk3_app_t *app)
{
  int		back = 0;
  size_t	sz;		/* Destination buffer length needed. */
  if((d) && (ds) && (s)) {
    sz = dk3str_i_cnv_c8u(NULL, s, app, DK3_ENCODING_UNICODE);
    if(sz) {
      if(ds >= sz) {
        if(dk3str_i_cnv_c8u((void *)d, s, app, DK3_ENCODING_UNICODE)) {
	  back = 1;
	}
      } else {
        if(app) {
	  /* ERROR: Destination buffer too small! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 38);
	}
      }
    }
  }
  return back;
}



dk3_c32_t *
dk3str_cnvnew_c8u_to_c32_app(char const *s, dk3_app_t *app)
{
  dk3_c32_t	*back = NULL;
  size_t	sz;		/* Destination buffer length needed. */
  if(s) {
    sz = dk3str_i_cnv_c8u(NULL, s, app, DK3_ENCODING_UNICODE);
    if(sz) {
      back = dk3_new_app(dk3_c32_t,sz,app);
      if(back) {
        if(!dk3str_i_cnv_c8u((void *)back, s, app, DK3_ENCODING_UNICODE)) {
	  dk3_delete(back); back = NULL;
	}
      }
    }
  }
  return back;
}



/**	Convert 16-bit character string to other encodings.
	@param	d	Destination pointer (NULL for size check).
	@param	s	Source string.
	@param	app	Application structure for diagnostics.
	@param	enc	Destination encoding.
	@return	Number of destination characters needed/produced.
*/
static
size_t
dk3str_i_cnv_c16(void *d, dk3_c16_t const *s, dk3_app_t *app, int enc)
{
  size_t		back = 0;
  int			error = 0;	/* Flag: Error occured. */
  char			*dp8 = NULL;	/* Pointer to 8-bit destination. */
  dk3_c32_t		*dp32 = NULL;	/* Pointer to 32-bit destination. */
  dk3_c16_t const	*sptr = NULL;	/* Source pointer. */
  dk3_c32_t		c32 = 0UL;	/* Conversion result. */
  unsigned char		uc = 0x00;	/* Current output character. */
  char			c = 0x00;	/* Current output character. */
  unsigned char		myuc[16];	/* Conversion result buffer. */
  size_t		sl = 0;		/* Remaining string length. */
  size_t		u16u = 0;	/* Number of U16 characters used. */
  size_t		u8u = 0;	/* Number of 8-bit chars produced. */
  size_t		i = 0;		/* Copy buffer to destination. */
  if(s) {
    /* Initialize variables */
    sptr = s; sl = dk3str_c16_len(s);
    if(d) {
      switch(enc) {
        case DK3_ENCODING_PLAIN: { dp8 = (char *)d; } break;
	case DK3_ENCODING_UTF8:	{ dp8 = (char *)d; } break;
	case DK3_ENCODING_UNICODE: { dp32 = (dk3_c32_t *)d; } break;
	default: {
	  if(0 == error) {
	    if(app) {
	      /* ERROR: Illegal output encoding! */
	      dk3app_log_i1(app, DK3_LL_ERROR, 114);
	    }
	  } error = 1;
	} break;
      }
    }
    /* Process input */
    while((sl) && (0 == error)) {
      u16u = 0;
      if(dk3enc_utf162uc(&c32, sptr, sl, &u16u)) {
        if(u16u) {
	  if(sl >= u16u) {
	    switch(enc) {
              case DK3_ENCODING_PLAIN: {
	        if(c32 < (dk3_c32_t)0x00000100UL) {
		  back = dk3mem_add_size_t(back, 1, &error);
		  if(d) {
		    uc = (unsigned char)c32; c = (char)uc;
		    *(dp8++) = c;
		  }
		} else {
		  if(0 == error) {
		    if(app) {
		      /* ERROR: Result character out of range! */
		      dk3app_log_i1(app, DK3_LL_ERROR, 117);
		    }
		  } error = 1;
		}
	      } break;
	      case DK3_ENCODING_UTF8:	{
	        u8u = dk3enc_uc2utf8(c32, myuc, 16);
		if(u8u) {
		  back = dk3mem_add_size_t(back, u8u, &error);
		  if(d) {
		    for(i = 0; i < u8u; i++) { *(dp8++) = myuc[i]; }
		  }
		} else {
		  if(0 == error) {
		    if(app) {
		      /* ERROR: Conversion to UTF-8 failed! */
		      dk3app_log_i1(app, DK3_LL_ERROR, 115);
		    }
		  } error = 1;
		}
	      } break;
	      case DK3_ENCODING_UNICODE: {
		back = dk3mem_add_size_t(back, 1, &error);
		if(d) { *(dp32++) = c32; }
	      } break;
	    }
	    sl = sl - u16u;
	    sptr = &(sptr[u16u]);
	  } else {
	    sl = 0;
	  }
	} else {
	  if(0 == error) {
	    if(app) {
	      /* ERROR: UTF-16 decode operation failed! */
	      dk3app_log_i1(app, DK3_LL_ERROR, 119);
	    }
	  } error = 1;
	}
      } else {
        if(0 == error) {
	  if(app) {
	    /* ERROR: UTF-16 decode operation failed! */
	    dk3app_log_i1(app, DK3_LL_ERROR, 119);
	  }
	} error = 1;
      }
    }
    /* Finalize output */
    back = dk3mem_add_size_t(back, 1, &error);
    if(d) {
      switch(enc) {
        case DK3_ENCODING_PLAIN: { *dp8 = '\0'; } break;
	case DK3_ENCODING_UTF8:	{ *dp8 = '\0'; } break;
	case DK3_ENCODING_UNICODE: { *dp32 = 0UL; } break;
      }
    }
    if(error) {
      back = 0;
      if(error == DK3_ERROR_MATH_OVERFLOW) {
        if(app) {
	  /* ERROR: Input string too long for conversion! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 108);
	}
      }
    }
  }
  return back;
}



size_t
dk3str_cnvsz_c16_to_c8p_app(dk3_c16_t const *s, dk3_app_t *app)
{
  size_t back = 0;
  if(s) {
    back = dk3str_i_cnv_c16(NULL, s, app, DK3_ENCODING_PLAIN);
  }
  return back;
}



int
dk3str_cnv_c16_to_c8p_app(char *d, size_t ds, dk3_c16_t const *s, dk3_app_t *app)
{
  int		back = 0;
  size_t	sz;		/* Destination buffer size needed. */
  if((d) && (ds) && (s)) {
    sz = dk3str_i_cnv_c16(NULL, s, app, DK3_ENCODING_PLAIN);
    if(sz) {
      if(ds >= sz) {
        if(dk3str_i_cnv_c16((void *)d, s, app, DK3_ENCODING_PLAIN)) {
	  back = 1;
	}
      } else {
        if(app) {
	  /* ERROR: Result buffer too small! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 38);
	}
      }
    }
  }
  return back;
}



char *
dk3str_cnvnew_c16_to_c8p_app(dk3_c16_t const *s, dk3_app_t *app)
{
  char		*back = NULL;
  size_t	sz;		/* Destination buffer size needed. */
  if(s) {
    sz = dk3str_i_cnv_c16(NULL, s, app, DK3_ENCODING_PLAIN);
    if(sz) {
      back = dk3_new_app(char,sz,app);
      if(back) {
        if(!dk3str_i_cnv_c16((void *)back, s, app, DK3_ENCODING_PLAIN)) {
	  dk3_delete(back); back = NULL;
	}
      }
    }
  }
  return back;
}



size_t
dk3str_cnvsz_c16_to_c8u_app(dk3_c16_t const *s, dk3_app_t *app)
{
  size_t back = 0;
  if(s) {
    back = dk3str_i_cnv_c16(NULL, s, app, DK3_ENCODING_UTF8);
  }
  return back;
}



int
dk3str_cnv_c16_to_c8u_app(char *d, size_t ds, dk3_c16_t const *s, dk3_app_t *app)
{
  int		back = 0;
  size_t	sz;		/* Destination buffer size needed. */
  if((d) && (ds) && (s)) {
    sz = dk3str_i_cnv_c16(NULL, s, app, DK3_ENCODING_UTF8);
    if(sz) {
      if(ds >= sz) {
        if(dk3str_i_cnv_c16((void *)d, s, app, DK3_ENCODING_UTF8)) {
	  back = 1;
	}
      } else {
        if(app) {
	  /* ERROR: Result buffer too small! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 38);
	}
      }
    }
  }
  return back;
}


char *
dk3str_cnvnew_c16_to_c8u_app(dk3_c16_t const *s, dk3_app_t *app)
{
  char		*back = NULL;
  size_t	sz;		/* Destination buffer size needed. */
  if(s) {
    sz = dk3str_i_cnv_c16(NULL, s, app, DK3_ENCODING_UTF8);
    if(sz) {
      back = dk3_new_app(char,sz,app);
      if(back) {
        if(!dk3str_i_cnv_c16((void *)back, s, app, DK3_ENCODING_UTF8)) {
	  dk3_delete(back); back = NULL;
	}
      }
    }
  }
  return back;
}



int
dk3str_c16_to_c8_simple_app(
  char *d, size_t sz, dk3_c16_t const *s, dk3_app_t *app
)
{
  int back = 0;
  dk3_c16_t const *ptr;	/* Source pointer. */
  dk3_c16_t c;		/* Source character. */
  unsigned char uc;	/* Destination character. */
  char *dptr;		/* Destination pointer. */

  if((d) && (sz) && (s)) {
    if(dk3str_c16_len(s) < sz) {
      back = 1; ptr = s; dptr = d;
      while(0U != (c = *ptr)) {
        if(c < 0x0100U) {
	  uc = (unsigned char)c;
	  *(dptr++) = (char)uc;
	} else {
	  if((back == 1) && (app)) {
	    /* ERROR: Illegal character(s) in source string! */
	    dk3app_log_i1(app, DK3_LL_ERROR, 112);
	  }
	  back = 0;
	}
        ptr++;
      }
      *dptr = '\0';
    } else {
      d[0] = '\0';
      if(app) {
        /* ERROR: Source string too long! */ 
	dk3app_log_i1(app, DK3_LL_ERROR, 108);
      }
    }
  }
  return back;
}


size_t
dk3str_cnvsz_c16_to_c32_app(dk3_c16_t const *s, dk3_app_t *app)
{
  size_t back = 0;
  if(s) {
    back = dk3str_i_cnv_c16(NULL, s, app, DK3_ENCODING_UNICODE);
  }
  return back;
}



int
dk3str_cnv_c16_to_c32_app(dk3_c32_t *d, size_t ds, dk3_c16_t const *s, dk3_app_t *app)
{
  int		back = 0;
  size_t	sz;		/* Destination buffer size needed. */
  if((d) && (ds) && (s)) {
    sz = dk3str_i_cnv_c16(NULL, s, app, DK3_ENCODING_UNICODE);
    if(sz) {
      if(ds >= sz) {
        if(dk3str_i_cnv_c16((void *)d, s, app, DK3_ENCODING_UNICODE)) {
	  back = 1;
	}
      } else {
        if(app) {
	  /* ERROR: Result buffer too small! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 38);
	}
      }
    }
  }
  return back;
}



dk3_c32_t *
dk3str_cnvnew_c16_to_c32_app(dk3_c16_t const *s, dk3_app_t *app)
{
  dk3_c32_t	*back = NULL;
  size_t	sz;		/* Destination buffer size needed. */
  if(s) {
    sz = dk3str_i_cnv_c16(NULL, s, app, DK3_ENCODING_UNICODE);
    if(sz) {
      back = dk3_new_app(dk3_c32_t,sz,app);
      if(back) {
        if(!dk3str_i_cnv_c16((void *)back, s, app, DK3_ENCODING_UNICODE)) {
	  dk3_delete(back); back = NULL;
	}
      }
    }
  }
  return back;
}



/**	Convert 32-bit character string to other encodings.
	@param	d	Destination buffer pointer (may be NULL for size check).
	@param	s	Source string.
	@param	app	Application structure for diagnostics.
	@param	enc	Output encoding.
	@return	Number of destination characters produced/needed.
*/
static
size_t
dk3str_i_cnv_c32(void *d, dk3_c32_t const *s, dk3_app_t *app, int enc)
{
  size_t		back = 0;
  int			error = 0;	/* Flag: Error occured. */
  char			*dp8 = NULL;	/* Pointer to 8-bit destination. */
  dk3_c16_t		*dp16 = NULL;	/* Pointer to 16-bit destination. */
  dk3_c32_t const	*sptr = NULL;	/* Source pointer. */
  dk3_c32_t		c32 = 0UL;	/* Current character to process. */
  dk3_c16_t		myc16[16];	/* Conversion result buffer. */
  unsigned char		myuc[16];	/* Conversion result buffer. */
  unsigned char		uc = 0x00;	/* Output character. */
  char			c = 0x00;	/* Output character. */
  size_t		sl = 0;		/* Remaining string length. */
  size_t		u8u = 0;	/* Number of UTF-8 chars produced. */
  size_t		u16u = 0;	/* Numer of UTF-16 chars produced. */
  size_t		i = 0;		/* Copy buffer to destination. */
  

#line 5353 "dk3str.ctr"
  if(s) {
    /* Initialize variables */
    sptr = s; sl = dk3str_c32_len(s);
    if(d) {
      switch(enc) {
        case DK3_ENCODING_PLAIN: { dp8 = (char *)d; } break;
	case DK3_ENCODING_UTF8: { dp8 = (char *)d; } break;
	case DK3_ENCODING_UTF16: { dp16 = (dk3_c16_t *)d; } break;
	default: {
	  if(0 == error) {
	    if(app) {
	      /* ERROR: Illegal output encoding! */
	      dk3app_log_i1(app, DK3_LL_ERROR, 114);
	    }
	  } error = 1;
	} break;
      }
    }
    /* Process input */
    while((sl) && (0 == error)) {
      c32 = *(sptr++); sl--;
      switch(enc) {
        case DK3_ENCODING_PLAIN: {
	  if(c32 < (dk3_c32_t)0x00000100UL) {
	    back = dk3mem_add_size_t(back, 1, &error);
	    if(d) {
	      uc = (unsigned char)c32; c = (char)uc;
	      *(dp8++) = c;
	    }
	  } else {
	    if(0 == error) {
	      if(app) {
	        /* ERROR: Output character out of range! */
		dk3app_log_i1(app, DK3_LL_ERROR, 117);
	      }
	    } error = 1;
	  }
	} break;
	case DK3_ENCODING_UTF8: {
	  u8u = dk3enc_uc2utf8(c32, myuc, 16);
	  if(u8u) {
	    back = dk3mem_add_size_t(back, u8u, &error);
	    if(d) {
	      for(i = 0; i < u8u; i++) { *(dp8++) = myuc[i]; }
	    }
	  } else {
	    if(0 == error) {
	      if(app) {
	        /* ERROR: UTF-8 encoding failed! */
		dk3app_log_i1(app, DK3_LL_ERROR, 115);
	      }
	    } error = 1;
	  }
	} break;
	case DK3_ENCODING_UTF16: {
	  u16u = dk3enc_uc2utf16(c32, myc16, 16);
	  if(u16u) {
	    back = dk3mem_add_size_t(back, u16u, &error);
	    if(d) {
	      for(i = 0; i < u16u; i++) { *(dp16++) = myc16[i]; }
	    }
	  } else {
	    if(0 == error) {
	      if(app) {		

#line 5417 "dk3str.ctr"
	        /* ERROR: Conversion to UTF-16 failed! */
		dk3app_log_i1(app, DK3_LL_ERROR, 116);
	      }
	    } error = 1;
	  }
	} break;
      }
    }
    /* Finalize output */
    back = dk3mem_add_size_t(back, 1, &error);
    if(d) {
      switch(enc) {
        case DK3_ENCODING_PLAIN: { *dp8 = '\0'; } break;
	case DK3_ENCODING_UTF8: { *dp8 = '\0'; } break;
	case DK3_ENCODING_UTF16: { *dp16 = 0U; } break;
      }
    }
    if(error) {
      back = 0;
      if(error == DK3_ERROR_MATH_OVERFLOW) {
        if(app) {
	  /* ERROR: Input string too long for conversion! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 108);
	}
      }
    }
  } 

#line 5444 "dk3str.ctr"
  return back;
}



size_t
dk3str_cnvsz_c32_to_c8p_app(dk3_c32_t const *s, dk3_app_t *app)
{
  size_t back = 0;
  if(s) {
    back = dk3str_i_cnv_c32(NULL, s, app, DK3_ENCODING_PLAIN);
  }
  return back;
}



int
dk3str_cnv_c32_to_c8p_app(char *d, size_t ds, dk3_c32_t const *s, dk3_app_t *app)
{
  int		back = 0;
  size_t	sz;		/* Destination buffer size needed. */
  if((d) && (ds) && (s)) {
    sz = dk3str_i_cnv_c32(NULL, s, app, DK3_ENCODING_PLAIN);
    if(sz) {
      if(ds >= sz) {
        if(dk3str_i_cnv_c32((void *)d, s, app, DK3_ENCODING_PLAIN)) {
	  back = 1;
	}
      } else {
        if(app) {
	  /* ERROR: Destination buffer too small! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 38);
	}
      }
    }
  }
  return back;
}



char *
dk3str_cnvnew_c32_to_c8p_app(dk3_c32_t const *s, dk3_app_t *app)
{
  char		*back = NULL;
  size_t	sz;		/* Destination buffer size needed. */
  if(s) {
    sz = dk3str_i_cnv_c32(NULL, s, app, DK3_ENCODING_PLAIN);
    if(sz) {
      back = dk3_new_app(char,sz,app);
      if(back) {
        if(!dk3str_i_cnv_c32((void *)back, s, app, DK3_ENCODING_PLAIN)) {
	  dk3_delete(back); back = NULL;
	}
      }
    }
  }
  return back;
}



size_t
dk3str_cnvsz_c32_to_c8u_app(dk3_c32_t const *s, dk3_app_t *app)
{
  size_t back = 0;
  if(s) {
    back = dk3str_i_cnv_c32(NULL, s, app, DK3_ENCODING_UTF8);
  }
  return back;
}



int
dk3str_cnv_c32_to_c8u_app(char *d, size_t ds, dk3_c32_t const *s, dk3_app_t *app)
{
  int		back = 0;
  size_t	sz;		/* Destination buffer size needed. */
  if((d) && (ds) && (s)) {
    sz = dk3str_i_cnv_c32(NULL, s, app, DK3_ENCODING_UTF8);
    if(sz) {
      if(ds >= sz) {
        if(dk3str_i_cnv_c32((void *)d, s, app, DK3_ENCODING_UTF8)) {
	  back = 1;
	}
      } else {
        if(app) {
	  /* ERROR: Destination buffer too small! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 38);
	}
      }
    }
  }
  return back;
}



char *
dk3str_cnvnew_c32_to_c8u_app(dk3_c32_t const *s, dk3_app_t *app)
{
  char		*back = NULL;
  size_t	sz;		/* Destination buffer size needed. */
  if(s) {
    sz = dk3str_i_cnv_c32(NULL, s, app, DK3_ENCODING_UTF8);
    if(sz) {
      back = dk3_new_app(char,sz,app);
      if(back) {
        if(!dk3str_i_cnv_c32((void *)back, s, app, DK3_ENCODING_UTF8)) {
	  dk3_delete(back); back = NULL;
	}
      }
    }
  }
  return back;
}



size_t
dk3str_cnvsz_c32_to_c16_app(dk3_c32_t const *s, dk3_app_t *app)
{
  size_t back = 0;
  if(s) {
    back = dk3str_i_cnv_c32(NULL, s, app, DK3_ENCODING_UTF16);
  }
  return back;
}



int
dk3str_cnv_c32_to_c16_app(dk3_c16_t *d, size_t ds, dk3_c32_t const *s, dk3_app_t *app)
{
  int		back = 0;
  size_t	sz;		/* Destination buffer size needed. */
  if((d) && (ds) && (s)) {
    sz = dk3str_i_cnv_c32(NULL, s, app, DK3_ENCODING_UTF16);
    if(sz) {
      if(ds >= sz) {
        if(dk3str_i_cnv_c32((void *)d, s, app, DK3_ENCODING_UTF16)) {
	  back = 1;
	}
      } else {
        if(app) {
	  /* ERROR: Destination buffer too small! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 38);
	}
      }
    }
  }
  return back;
}



dk3_c16_t *
dk3str_cnvnew_c32_to_c16_app(dk3_c32_t const *s, dk3_app_t *app)
{
  dk3_c16_t	*back = NULL;
  size_t	sz;		/* Destination buffer size needed. */
  if(s) {
    sz = dk3str_i_cnv_c32(NULL, s, app, DK3_ENCODING_UTF16);
    if(sz) {
      back = dk3_new_app(dk3_c16_t,sz,app);
      if(back) {
        if(!dk3str_i_cnv_c32((void *)back, s, app, DK3_ENCODING_UTF16)) {
	  dk3_delete(back); back = NULL;
	}
      }
    }
  }
  return back;
}



int
dk3str_cnv_c8_to_str_app(dkChar *d, size_t sz, char const *s, dk3_app_t *app)
{
  register int		back = 0;
  register size_t	l;		/* Number of destination chars used. */
  register char const	*sptr;		/* Source pointer. */
  register dkChar	*dptr;		/* Destination pointer. */
  register char		x = 0x00;	/* Current character to process. */

  if((d) && (sz) && (s)) {
    sptr = s; dptr = d; l = 0; back = 1;
    while((*sptr) && (l < (sz - 1))) {
      x = *(sptr++);
      *(dptr++) = (dkChar)x;
      l++;
    }
    *dptr = (dkChar)'\0';
    if(*sptr) {
      back = 0;
      if(app) {
        /* ERROR: Destination buffer too small! */
	dk3app_log_i1(app, DK3_LL_ERROR, 38);
      }
    }
  }
  return back;
}



int
dk3str_string_to_c8_simple_app(char *db,size_t sz,dkChar const *s,dk3_app_t *ap)
{
  int			back = 0;
  register dkChar const	*sptr;		/* Source pointer. */
  register dkChar	x;		/* Current source character. */
  register char		*dptr;		/* Destination pointer. */

  if((db) && (sz) && (s)) {
    if(dk3str_len(s) < sz) {
      back = 1;
      sptr = s; dptr = db;
      while(*sptr) {
        x = *(sptr++);
	*(dptr++) = (char)x;
#if DK3_CHAR_SIZE > 1
	if(x > (dkChar)0xFF) {
	  back = 0;
	}
#endif
      }
      *dptr = '\0';
      if(!(back)) {
        if(ap) {
	  /* ERROR: Non-ISO-LATIN-1 characters found! */
	  dk3app_log_i1(ap, DK3_LL_ERROR, 219);
	}
      }
    } else {
      if(ap) {
        /* ERROR: Destination buffer too short! */
	dk3app_log_i1(ap, DK3_LL_ERROR, 38);
      }
    }
  }
  return back;
}



void
dk3str_string_tolower(dkChar *s)
{
  dkChar *ptr;	/* Pointer into string. */
  if(s) {
    ptr = s;
    while(*ptr) {
      *ptr = dk3str_tolower(*ptr);
      ptr++;
    }
  }
}



int
dk3str_c8_to_str_simple_app(
  dkChar *dp, size_t ds, char const *sp, dk3_app_t *app
)
{
  int		 back = 0;
  char const	*sptr;		/* Pointer into source buffer. */
  dkChar	*dptr;		/* Pointer into destination buffer. */
  size_t	 sz;		/* Required destination size. */
  if((dp) && (ds) && (sp)) {
    sz = dk3str_c8_len(sp);
    if(ds > sz) {
      back = 1; sptr = sp; dptr = dp;
      while(*sptr) { *(dptr++) = (dkChar)(*(sptr++)); }
      *dptr = dkT('\0');
    } else {
      if(app) {
        /* ERROR: Destination buffer too short! */
	dk3app_log_i1(app, DK3_LL_ERROR, 38);
      }
    }
  }
  return back;
}



int
dk3str_to_c8p_app(
  char *dp, size_t sz, dkChar const *src, int ie, dk3_app_t *app
)
{
  int back = 0;
  if((dp) && (sz) && (src)) {
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
    back = dk3str_cnv_c32_to_c8p_app(dp, sz, src, app);
#else
    back = dk3str_cnv_c16_to_c8p_app(dp, sz, src, app);
#endif
#else
    if(ie == DK3_ENCODING_PLAIN) {
      if(sz > dk3str_c8_len(src)) {
        dk3str_c8_cpy(dp, src);
	back = 1;
      }
    } else {
      back = dk3str_cnv_c8u_to_c8p_app(dp, sz, src, app);
    }
#endif
  }
  return back;
}



int
dk3str_to_c8u_app(
  char *dp, size_t sz, dkChar const *src, int ie, dk3_app_t *app
)
{
  int back = 0;
  if((dp) && (sz) && (src)) {
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
    back = dk3str_cnv_c32_to_c8u_app(dp, sz, src, app);
#else
    back = dk3str_cnv_c16_to_c8u_app(dp, sz, src, app);
#endif
#else
    if(ie == DK3_ENCODING_PLAIN) {
      back = dk3str_cnv_c8p_to_c8u_app(dp, sz, src, app);
    } else {
      if(sz > dk3str_c8_len(src)) {
        dk3str_c8_cpy(dp, src);
	back = 1;
      }
    }
#endif
  }
  return back;
}



int
dk3str_str_to_c8u_app(
  char		*d,
  size_t	 dsz,
  dkChar const	*s,
  int		 se,
  dk3_app_t	*app
)
{
  int		back = 0;
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
  back = dk3str_cnv_c32_to_c8u_app(d, dsz, s, app);
#else
  back = dk3str_cnv_c16_to_c8u_app(d, dsz, s, app);
#endif
#else
  switch(se) {
    case DK3_ENCODING_UTF8: {
      if(dk3str_c8_len(s) < dsz) {
        dk3str_c8_cpy(d, s);
	back = 1;
      } else {
        if(app) {
	  /* ERROR: String too long! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 108);
	}
      }
    } break;
    default: {
      back = dk3str_cnv_c8p_to_c8u_app(d, dsz, s, app);
    } break;
  }
#endif
  return back;
}



int
dk3str_c8u_to_str_app(
  dkChar 		*d,
  size_t		 dsz,
  int			 de,
  char const		*s,
  dk3_app_t		*app
)
{
  int		 back = 0;
  

#line 5843 "dk3str.ctr"
  if((d) && (dsz) && (s)) {
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
    

#line 5847 "dk3str.ctr"
    back = dk3str_cnv_c8u_to_c32_app(d, dsz, s, app);
#else
    

#line 5850 "dk3str.ctr"
    back = dk3str_cnv_c8u_to_c16_app(d, dsz, s, app);
#endif
#else
    switch(de) {
      case DK3_ENCODING_UTF8: {
        

#line 5856 "dk3str.ctr"
        if(dsz > dk3str_c8_len(s)) {
	  dk3str_c8_cpy(d, s);
	  back = 1;
	} else {
	  if(app) {
	    /* ERROR: Source string too long! */
	    dk3app_log_i1(app, DK3_LL_ERROR, 108);
	  }
	}
      } break;
      default: {
        

#line 5868 "dk3str.ctr"
        back = dk3str_cnv_c8u_to_c8p_app(d, dsz, s, app);
      } break;
    }
#endif
  } 

#line 5873 "dk3str.ctr"
  return back;
}



int
dk3str_to_c8_app(char *dp, size_t szdp, dkChar const *src, dk3_app_t *app)
{
  int		 back = 0;
  

#line 5883 "dk3str.ctr"
  if((dp) && (szdp) && (src)) {
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
    back = dk3str_cnv_c32_to_c8p_app(dp, szdp, src, app);
#else
    back = dk3str_cnv_c16_to_c8p_app(dp, szdp, src, app);
#endif
#else
    if(strlen(src) < szdp) {
      strcpy(dp, src);
      back = 1;
    } else {
      /* ERROR: Destination buffer too small! */
      dk3app_log_i1(app, DK3_LL_ERROR, 38);
    }
#endif
  } 

#line 5900 "dk3str.ctr"
  return back;
}






/* vim: set ai sw=2 : */

